// components/media_router/common/mojom/debugger.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_MEDIA_ROUTER_COMMON_MOJOM_DEBUGGER_MOJOM_H_
#define COMPONENTS_MEDIA_ROUTER_COMMON_MOJOM_DEBUGGER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/media_router/common/mojom/debugger.mojom-features.h"  // IWYU pragma: export
#include "components/media_router/common/mojom/debugger.mojom-shared.h"  // IWYU pragma: export
#include "components/media_router/common/mojom/debugger.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/values.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace media_router::mojom {

class DebuggerProxy;

template <typename ImplRefTraits>
class DebuggerStub;

class DebuggerRequestValidator;
class DebuggerResponseValidator;


class Debugger
    : public DebuggerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "media_router.mojom.Debugger";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = DebuggerInterfaceBase;
  using Proxy_ = DebuggerProxy;

  template <typename ImplRefTraits>
  using Stub_ = DebuggerStub<ImplRefTraits>;

  using RequestValidator_ = DebuggerRequestValidator;
  using ResponseValidator_ = DebuggerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kShouldFetchMirroringStatsMinVersion = 0,
    kOnMirroringStatsMinVersion = 0,
    kBindReceiverMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ShouldFetchMirroringStats_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnMirroringStats_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BindReceiver_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Debugger() = default;

  using ShouldFetchMirroringStatsCallback = base::OnceCallback<void(bool)>;
  using ShouldFetchMirroringStatsMojoCallback = base::OnceCallback<void(bool)>;

  virtual void ShouldFetchMirroringStats(ShouldFetchMirroringStatsCallback callback) = 0;

  virtual void OnMirroringStats(::base::Value json_stats) = 0;

  virtual void BindReceiver(::mojo::PendingReceiver<Debugger> receiver) = 0;
};



class  DebuggerProxy
    : public Debugger {
 public:
  using InterfaceType = Debugger;

  explicit DebuggerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ShouldFetchMirroringStats(ShouldFetchMirroringStatsCallback callback) final;
  
  void OnMirroringStats(::base::Value json_stats) final;
  
  void BindReceiver(::mojo::PendingReceiver<Debugger> receiver) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  DebuggerStubDispatch {
 public:
  static bool Accept(Debugger* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Debugger* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Debugger>>
class DebuggerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DebuggerStub() = default;
  ~DebuggerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DebuggerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DebuggerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  DebuggerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  DebuggerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // media_router::mojom

namespace mojo {

}  // namespace mojo

#endif  // COMPONENTS_MEDIA_ROUTER_COMMON_MOJOM_DEBUGGER_MOJOM_H_