// components/media_router/common/mojom/debugger.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/media_router/common/mojom/debugger.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/media_router/common/mojom/debugger.mojom-params-data.h"
#include "components/media_router/common/mojom/debugger.mojom-shared-message-ids.h"

#include "components/media_router/common/mojom/debugger.mojom-import-headers.h"
#include "components/media_router/common/mojom/debugger.mojom-test-utils.h"


namespace media_router::mojom {
// The declaration includes the definition on other builds.

Debugger::IPCStableHashFunction Debugger::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Debugger>(message.name())) {
    case messages::Debugger::kShouldFetchMirroringStats: {
      return &Debugger::ShouldFetchMirroringStats_Sym::IPCStableHash;
    }
    case messages::Debugger::kOnMirroringStats: {
      return &Debugger::OnMirroringStats_Sym::IPCStableHash;
    }
    case messages::Debugger::kBindReceiver: {
      return &Debugger::BindReceiver_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Debugger::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Debugger>(message.name())) {
      case messages::Debugger::kShouldFetchMirroringStats:
            return "Receive media_router::mojom::Debugger::ShouldFetchMirroringStats";
      case messages::Debugger::kOnMirroringStats:
            return "Receive media_router::mojom::Debugger::OnMirroringStats";
      case messages::Debugger::kBindReceiver:
            return "Receive media_router::mojom::Debugger::BindReceiver";
    }
  } else {
    switch (static_cast<messages::Debugger>(message.name())) {
      case messages::Debugger::kShouldFetchMirroringStats:
            return "Receive reply media_router::mojom::Debugger::ShouldFetchMirroringStats";
      case messages::Debugger::kOnMirroringStats:
            return "Receive reply media_router::mojom::Debugger::OnMirroringStats";
      case messages::Debugger::kBindReceiver:
            return "Receive reply media_router::mojom::Debugger::BindReceiver";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Debugger::ShouldFetchMirroringStats_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1c5c6c74;  // IPCStableHash for media_router::mojom::Debugger::ShouldFetchMirroringStats
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Debugger::OnMirroringStats_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7e3f11d9;  // IPCStableHash for media_router::mojom::Debugger::OnMirroringStats
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Debugger::BindReceiver_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x018f8009;  // IPCStableHash for media_router::mojom::Debugger::BindReceiver
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class Debugger_ShouldFetchMirroringStats_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Debugger_ShouldFetchMirroringStats_ForwardToCallback(
      Debugger::ShouldFetchMirroringStatsCallback callback
      ) : callback_(std::move(callback)) {
  }

  Debugger_ShouldFetchMirroringStats_ForwardToCallback(const Debugger_ShouldFetchMirroringStats_ForwardToCallback&) = delete;
  Debugger_ShouldFetchMirroringStats_ForwardToCallback& operator=(const Debugger_ShouldFetchMirroringStats_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Debugger::ShouldFetchMirroringStatsCallback callback_;
};

DebuggerProxy::DebuggerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DebuggerProxy::ShouldFetchMirroringStats(
    ShouldFetchMirroringStatsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media_router::mojom::Debugger::ShouldFetchMirroringStats");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Debugger::kShouldFetchMirroringStats), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_router::mojom::internal::Debugger_ShouldFetchMirroringStats_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Debugger::Name_);
  message.set_method_name("ShouldFetchMirroringStats");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Debugger_ShouldFetchMirroringStats_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void DebuggerProxy::OnMirroringStats(
    ::base::Value in_json_stats) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_router::mojom::Debugger::OnMirroringStats", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("json_stats"), in_json_stats,
                        "<value of type ::base::Value>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Debugger::kOnMirroringStats), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_router::mojom::internal::Debugger_OnMirroringStats_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->json_stats)>
      json_stats_fragment(params.message());
  json_stats_fragment.Claim(&params->json_stats);
  
  mojo::internal::Serialize<::mojo_base::mojom::ValueDataView>(
    in_json_stats,
    json_stats_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->json_stats.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null json_stats in Debugger.OnMirroringStats request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Debugger::Name_);
  message.set_method_name("OnMirroringStats");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DebuggerProxy::BindReceiver(
    ::mojo::PendingReceiver<Debugger> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_router::mojom::Debugger::BindReceiver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<Debugger>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Debugger::kBindReceiver), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_router::mojom::internal::Debugger_BindReceiver_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media_router::mojom::DebuggerInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in Debugger.BindReceiver request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Debugger::Name_);
  message.set_method_name("BindReceiver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class Debugger_ShouldFetchMirroringStats_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Debugger::ShouldFetchMirroringStatsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Debugger_ShouldFetchMirroringStats_ProxyToResponder> proxy(
        new Debugger_ShouldFetchMirroringStats_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Debugger_ShouldFetchMirroringStats_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Debugger_ShouldFetchMirroringStats_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Debugger_ShouldFetchMirroringStats_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Debugger::ShouldFetchMirroringStatsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_should_fetch);
};

bool Debugger_ShouldFetchMirroringStats_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Debugger_ShouldFetchMirroringStats_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Debugger_ShouldFetchMirroringStats_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Debugger.0
  bool success = true;
  bool p_should_fetch{};
  Debugger_ShouldFetchMirroringStats_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_should_fetch = input_data_view.should_fetch();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Debugger::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_should_fetch));
  }
  return true;
}

void Debugger_ShouldFetchMirroringStats_ProxyToResponder::Run(
    bool in_should_fetch) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media_router::mojom::Debugger::ShouldFetchMirroringStats", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("should_fetch"), in_should_fetch,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Debugger::kShouldFetchMirroringStats), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_router::mojom::internal::Debugger_ShouldFetchMirroringStats_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->should_fetch = in_should_fetch;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Debugger::Name_);
  message.set_method_name("ShouldFetchMirroringStats");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool DebuggerStubDispatch::Accept(
    Debugger* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Debugger>(message->header()->name)) {
    case messages::Debugger::kShouldFetchMirroringStats: {
      break;
    }
    case messages::Debugger::kOnMirroringStats: {
      DCHECK(message->is_serialized());
      internal::Debugger_OnMirroringStats_Params_Data* params =
          reinterpret_cast<internal::Debugger_OnMirroringStats_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Debugger.1
      bool success = true;
      ::base::Value p_json_stats{};
      Debugger_OnMirroringStats_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadJsonStats(&p_json_stats))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Debugger::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnMirroringStats(        
        std::move(p_json_stats));
      return true;
    }
    case messages::Debugger::kBindReceiver: {
      DCHECK(message->is_serialized());
      internal::Debugger_BindReceiver_Params_Data* params =
          reinterpret_cast<internal::Debugger_BindReceiver_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Debugger.2
      bool success = true;
      ::mojo::PendingReceiver<Debugger> p_receiver{};
      Debugger_BindReceiver_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Debugger::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindReceiver(        
        std::move(p_receiver));
      return true;
    }
  }
  return false;
}

// static
bool DebuggerStubDispatch::AcceptWithResponder(
    Debugger* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Debugger>(message->header()->name)) {
    case messages::Debugger::kShouldFetchMirroringStats: {
      internal::Debugger_ShouldFetchMirroringStats_Params_Data* params =
          reinterpret_cast<
              internal::Debugger_ShouldFetchMirroringStats_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Debugger.0
      bool success = true;
      Debugger_ShouldFetchMirroringStats_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Debugger::Name_, 0, false);
        return false;
      }
      auto callback =
          Debugger_ShouldFetchMirroringStats_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShouldFetchMirroringStats(std::move(callback));
      return true;
    }
    case messages::Debugger::kOnMirroringStats: {
      break;
    }
    case messages::Debugger::kBindReceiver: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kDebuggerValidationInfo[] = {
    { &internal::Debugger_ShouldFetchMirroringStats_Params_Data::Validate,
     &internal::Debugger_ShouldFetchMirroringStats_ResponseParams_Data::Validate},
    { &internal::Debugger_OnMirroringStats_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Debugger_BindReceiver_Params_Data::Validate,
     nullptr /* no response */},
};

bool DebuggerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media_router::mojom::Debugger::Name_,
    kDebuggerValidationInfo);
}

bool DebuggerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::media_router::mojom::Debugger::Name_,
    kDebuggerValidationInfo);
}


}  // media_router::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace media_router::mojom {


void DebuggerInterceptorForTesting::ShouldFetchMirroringStats(ShouldFetchMirroringStatsCallback callback) {
  GetForwardingInterface()->ShouldFetchMirroringStats(std::move(callback));
}
void DebuggerInterceptorForTesting::OnMirroringStats(::base::Value json_stats) {
  GetForwardingInterface()->OnMirroringStats(
    std::move(json_stats)
    );
}
void DebuggerInterceptorForTesting::BindReceiver(::mojo::PendingReceiver<Debugger> receiver) {
  GetForwardingInterface()->BindReceiver(
    std::move(receiver)
    );
}
DebuggerAsyncWaiter::DebuggerAsyncWaiter(
    Debugger* proxy) : proxy_(proxy) {}

DebuggerAsyncWaiter::~DebuggerAsyncWaiter() = default;


void DebuggerAsyncWaiter::ShouldFetchMirroringStats(
    bool* out_should_fetch) {
  base::RunLoop loop;
  proxy_->ShouldFetchMirroringStats(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_should_fetch
,
             bool should_fetch) {*out_should_fetch = std::move(should_fetch);
            loop->Quit();
          },
          &loop,
          out_should_fetch));
  loop.Run();
}

bool DebuggerAsyncWaiter::ShouldFetchMirroringStats(
    ) {
  bool async_wait_result;
  ShouldFetchMirroringStats(&async_wait_result);
  return async_wait_result;
}






}  // media_router::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif