// components/lens/lens_metadata.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_LENS_LENS_METADATA_MOJOM_SHARED_H_
#define COMPONENTS_LENS_LENS_METADATA_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/lens/lens_metadata.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"




#include "components/lens/lens_metadata.mojom-data-view.h"




namespace std {

template <>
struct hash<::lens::mojom::ImageFormat>
    : public mojo::internal::EnumHashImpl<::lens::mojom::ImageFormat> {};

template <>
struct hash<::lens::mojom::Phase>
    : public mojo::internal::EnumHashImpl<::lens::mojom::Phase> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::lens::mojom::ImageFormat, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::lens::mojom::ImageFormat, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::lens::mojom::ImageFormat>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::lens::mojom::Phase, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::lens::mojom::Phase, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::lens::mojom::Phase>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::lens::mojom::LatencyLogDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::lens::mojom::LatencyLogDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::lens::mojom::internal::LatencyLog_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::lens::mojom::Phase>(
      Traits::phase(input),
      &fragment->phase);

    decltype(Traits::original_size(input)) in_original_size = Traits::original_size(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->original_size)::BaseType> original_size_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_original_size,
      original_size_fragment);

    fragment->original_size.Set(
        original_size_fragment.is_null() ? nullptr : original_size_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->original_size.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null original_size in LatencyLog struct");

    decltype(Traits::downscaled_size(input)) in_downscaled_size = Traits::downscaled_size(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->downscaled_size)::BaseType> downscaled_size_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_downscaled_size,
      downscaled_size_fragment);

    fragment->downscaled_size.Set(
        downscaled_size_fragment.is_null() ? nullptr : downscaled_size_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->downscaled_size.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null downscaled_size in LatencyLog struct");

    
    mojo::internal::Serialize<::lens::mojom::ImageFormat>(
      Traits::image_format(input),
      &fragment->image_format);

    decltype(Traits::time(input)) in_time = Traits::time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->time)::BaseType> time_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_time,
      time_fragment);

    fragment->time.Set(
        time_fragment.is_null() ? nullptr : time_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->time.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null time in LatencyLog struct");

    fragment->encoded_bytes_size = Traits::encoded_bytes_size(input);
  }

  static bool Deserialize(::lens::mojom::internal::LatencyLog_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::lens::mojom::LatencyLogDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace lens::mojom {

inline void LatencyLogDataView::GetOriginalSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->original_size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}
inline void LatencyLogDataView::GetDownscaledSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->downscaled_size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}
inline void LatencyLogDataView::GetTimeDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->time.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}



}  // lens::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::lens::mojom::ImageFormat> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::lens::mojom::ImageFormat value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::lens::mojom::Phase> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::lens::mojom::Phase value);
};

} // namespace perfetto

#endif  // COMPONENTS_LENS_LENS_METADATA_MOJOM_SHARED_H_