// components/ip_protection/mojom/core_test.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/ip_protection/mojom/core_test.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/ip_protection/mojom/core_test.mojom-params-data.h"
#include "components/ip_protection/mojom/core_test.mojom-shared-message-ids.h"

#include "components/ip_protection/mojom/core_test.mojom-import-headers.h"
#include "components/ip_protection/mojom/core_test.mojom-test-utils.h"


namespace ip_protection::mojom {
// The declaration includes the definition on other builds.

CoreControlTest::IPCStableHashFunction CoreControlTest::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::CoreControlTest>(message.name())) {
    case messages::CoreControlTest::kVerifyIpProtectionCoreHostForTesting: {
      return &CoreControlTest::VerifyIpProtectionCoreHostForTesting_Sym::IPCStableHash;
    }
    case messages::CoreControlTest::kIsIpProtectionEnabledForTesting: {
      return &CoreControlTest::IsIpProtectionEnabledForTesting_Sym::IPCStableHash;
    }
    case messages::CoreControlTest::kGetAuthTokenForTesting: {
      return &CoreControlTest::GetAuthTokenForTesting_Sym::IPCStableHash;
    }
    case messages::CoreControlTest::kHasTrackingProtectionExceptionForTesting: {
      return &CoreControlTest::HasTrackingProtectionExceptionForTesting_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* CoreControlTest::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::CoreControlTest>(message.name())) {
      case messages::CoreControlTest::kVerifyIpProtectionCoreHostForTesting:
            return "Receive ip_protection::mojom::CoreControlTest::VerifyIpProtectionCoreHostForTesting";
      case messages::CoreControlTest::kIsIpProtectionEnabledForTesting:
            return "Receive ip_protection::mojom::CoreControlTest::IsIpProtectionEnabledForTesting";
      case messages::CoreControlTest::kGetAuthTokenForTesting:
            return "Receive ip_protection::mojom::CoreControlTest::GetAuthTokenForTesting";
      case messages::CoreControlTest::kHasTrackingProtectionExceptionForTesting:
            return "Receive ip_protection::mojom::CoreControlTest::HasTrackingProtectionExceptionForTesting";
    }
  } else {
    switch (static_cast<messages::CoreControlTest>(message.name())) {
      case messages::CoreControlTest::kVerifyIpProtectionCoreHostForTesting:
            return "Receive reply ip_protection::mojom::CoreControlTest::VerifyIpProtectionCoreHostForTesting";
      case messages::CoreControlTest::kIsIpProtectionEnabledForTesting:
            return "Receive reply ip_protection::mojom::CoreControlTest::IsIpProtectionEnabledForTesting";
      case messages::CoreControlTest::kGetAuthTokenForTesting:
            return "Receive reply ip_protection::mojom::CoreControlTest::GetAuthTokenForTesting";
      case messages::CoreControlTest::kHasTrackingProtectionExceptionForTesting:
            return "Receive reply ip_protection::mojom::CoreControlTest::HasTrackingProtectionExceptionForTesting";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t CoreControlTest::VerifyIpProtectionCoreHostForTesting_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x260e3000;  // IPCStableHash for ip_protection::mojom::CoreControlTest::VerifyIpProtectionCoreHostForTesting
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CoreControlTest::IsIpProtectionEnabledForTesting_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1920477e;  // IPCStableHash for ip_protection::mojom::CoreControlTest::IsIpProtectionEnabledForTesting
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CoreControlTest::GetAuthTokenForTesting_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x02a8e08f;  // IPCStableHash for ip_protection::mojom::CoreControlTest::GetAuthTokenForTesting
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CoreControlTest::HasTrackingProtectionExceptionForTesting_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x67e1482f;  // IPCStableHash for ip_protection::mojom::CoreControlTest::HasTrackingProtectionExceptionForTesting
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class CoreControlTest_VerifyIpProtectionCoreHostForTesting_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CoreControlTest_VerifyIpProtectionCoreHostForTesting_ForwardToCallback(
      CoreControlTest::VerifyIpProtectionCoreHostForTestingCallback callback
      ) : callback_(std::move(callback)) {
  }

  CoreControlTest_VerifyIpProtectionCoreHostForTesting_ForwardToCallback(const CoreControlTest_VerifyIpProtectionCoreHostForTesting_ForwardToCallback&) = delete;
  CoreControlTest_VerifyIpProtectionCoreHostForTesting_ForwardToCallback& operator=(const CoreControlTest_VerifyIpProtectionCoreHostForTesting_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CoreControlTest::VerifyIpProtectionCoreHostForTestingCallback callback_;
};

class CoreControlTest_IsIpProtectionEnabledForTesting_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CoreControlTest_IsIpProtectionEnabledForTesting_ForwardToCallback(
      CoreControlTest::IsIpProtectionEnabledForTestingCallback callback
      ) : callback_(std::move(callback)) {
  }

  CoreControlTest_IsIpProtectionEnabledForTesting_ForwardToCallback(const CoreControlTest_IsIpProtectionEnabledForTesting_ForwardToCallback&) = delete;
  CoreControlTest_IsIpProtectionEnabledForTesting_ForwardToCallback& operator=(const CoreControlTest_IsIpProtectionEnabledForTesting_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CoreControlTest::IsIpProtectionEnabledForTestingCallback callback_;
};

class CoreControlTest_GetAuthTokenForTesting_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CoreControlTest_GetAuthTokenForTesting_ForwardToCallback(
      CoreControlTest::GetAuthTokenForTestingCallback callback
      ) : callback_(std::move(callback)) {
  }

  CoreControlTest_GetAuthTokenForTesting_ForwardToCallback(const CoreControlTest_GetAuthTokenForTesting_ForwardToCallback&) = delete;
  CoreControlTest_GetAuthTokenForTesting_ForwardToCallback& operator=(const CoreControlTest_GetAuthTokenForTesting_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CoreControlTest::GetAuthTokenForTestingCallback callback_;
};

class CoreControlTest_HasTrackingProtectionExceptionForTesting_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CoreControlTest_HasTrackingProtectionExceptionForTesting_ForwardToCallback(
      CoreControlTest::HasTrackingProtectionExceptionForTestingCallback callback
      ) : callback_(std::move(callback)) {
  }

  CoreControlTest_HasTrackingProtectionExceptionForTesting_ForwardToCallback(const CoreControlTest_HasTrackingProtectionExceptionForTesting_ForwardToCallback&) = delete;
  CoreControlTest_HasTrackingProtectionExceptionForTesting_ForwardToCallback& operator=(const CoreControlTest_HasTrackingProtectionExceptionForTesting_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CoreControlTest::HasTrackingProtectionExceptionForTestingCallback callback_;
};

CoreControlTestProxy::CoreControlTestProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CoreControlTestProxy::VerifyIpProtectionCoreHostForTesting(
    VerifyIpProtectionCoreHostForTestingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send ip_protection::mojom::CoreControlTest::VerifyIpProtectionCoreHostForTesting");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CoreControlTest::kVerifyIpProtectionCoreHostForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::ip_protection::mojom::internal::CoreControlTest_VerifyIpProtectionCoreHostForTesting_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CoreControlTest::Name_);
  message.set_method_name("VerifyIpProtectionCoreHostForTesting");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CoreControlTest_VerifyIpProtectionCoreHostForTesting_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void CoreControlTestProxy::IsIpProtectionEnabledForTesting(
    IsIpProtectionEnabledForTestingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send ip_protection::mojom::CoreControlTest::IsIpProtectionEnabledForTesting");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CoreControlTest::kIsIpProtectionEnabledForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::ip_protection::mojom::internal::CoreControlTest_IsIpProtectionEnabledForTesting_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CoreControlTest::Name_);
  message.set_method_name("IsIpProtectionEnabledForTesting");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CoreControlTest_IsIpProtectionEnabledForTesting_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void CoreControlTestProxy::GetAuthTokenForTesting(
    ::ip_protection::ProxyLayer in_proxy_layer, const std::string& in_geo_id, GetAuthTokenForTestingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send ip_protection::mojom::CoreControlTest::GetAuthTokenForTesting", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("proxy_layer"), in_proxy_layer,
                        "<value of type ::ip_protection::ProxyLayer>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("geo_id"), in_geo_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CoreControlTest::kGetAuthTokenForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::ip_protection::mojom::internal::CoreControlTest_GetAuthTokenForTesting_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::ip_protection::mojom::ProxyLayer>(
    in_proxy_layer,
    &params->proxy_layer);
  mojo::internal::MessageFragment<
      typename decltype(params->geo_id)::BaseType> geo_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_geo_id,
    geo_id_fragment);

  params->geo_id.Set(
      geo_id_fragment.is_null() ? nullptr : geo_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->geo_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null geo_id in CoreControlTest.GetAuthTokenForTesting request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CoreControlTest::Name_);
  message.set_method_name("GetAuthTokenForTesting");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CoreControlTest_GetAuthTokenForTesting_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void CoreControlTestProxy::HasTrackingProtectionExceptionForTesting(
    const ::GURL& in_first_party_url, HasTrackingProtectionExceptionForTestingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send ip_protection::mojom::CoreControlTest::HasTrackingProtectionExceptionForTesting", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("first_party_url"), in_first_party_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CoreControlTest::kHasTrackingProtectionExceptionForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::ip_protection::mojom::internal::CoreControlTest_HasTrackingProtectionExceptionForTesting_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->first_party_url)::BaseType> first_party_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_first_party_url,
    first_party_url_fragment);

  params->first_party_url.Set(
      first_party_url_fragment.is_null() ? nullptr : first_party_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->first_party_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null first_party_url in CoreControlTest.HasTrackingProtectionExceptionForTesting request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CoreControlTest::Name_);
  message.set_method_name("HasTrackingProtectionExceptionForTesting");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CoreControlTest_HasTrackingProtectionExceptionForTesting_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class CoreControlTest_VerifyIpProtectionCoreHostForTesting_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CoreControlTest::VerifyIpProtectionCoreHostForTestingCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CoreControlTest_VerifyIpProtectionCoreHostForTesting_ProxyToResponder> proxy(
        new CoreControlTest_VerifyIpProtectionCoreHostForTesting_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CoreControlTest_VerifyIpProtectionCoreHostForTesting_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CoreControlTest_VerifyIpProtectionCoreHostForTesting_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CoreControlTest_VerifyIpProtectionCoreHostForTesting_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "CoreControlTest::VerifyIpProtectionCoreHostForTestingCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::optional<::ip_protection::BlindSignedAuthToken> in_bsa_token, std::optional<::base::Time> in_try_again_after);
};

bool CoreControlTest_VerifyIpProtectionCoreHostForTesting_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CoreControlTest_VerifyIpProtectionCoreHostForTesting_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CoreControlTest_VerifyIpProtectionCoreHostForTesting_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CoreControlTest.0
  bool success = true;
  std::optional<::ip_protection::BlindSignedAuthToken> p_bsa_token{};
  std::optional<::base::Time> p_try_again_after{};
  CoreControlTest_VerifyIpProtectionCoreHostForTesting_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadBsaToken(&p_bsa_token))
    success = false;
  if (success && !input_data_view.ReadTryAgainAfter(&p_try_again_after))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CoreControlTest::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_bsa_token), 
std::move(p_try_again_after));
  }
  return true;
}

void CoreControlTest_VerifyIpProtectionCoreHostForTesting_ProxyToResponder::Run(
    std::optional<::ip_protection::BlindSignedAuthToken> in_bsa_token, std::optional<::base::Time> in_try_again_after) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply ip_protection::mojom::CoreControlTest::VerifyIpProtectionCoreHostForTesting", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bsa_token"), in_bsa_token,
                        "<value of type std::optional<::ip_protection::BlindSignedAuthToken>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("try_again_after"), in_try_again_after,
                        "<value of type std::optional<::base::Time>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CoreControlTest::kVerifyIpProtectionCoreHostForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::ip_protection::mojom::internal::CoreControlTest_VerifyIpProtectionCoreHostForTesting_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->bsa_token)::BaseType> bsa_token_fragment(
          params.message());
  
  mojo::internal::Serialize<::ip_protection::mojom::BlindSignedAuthTokenDataView>(
    in_bsa_token,
    bsa_token_fragment);

  params->bsa_token.Set(
      bsa_token_fragment.is_null() ? nullptr : bsa_token_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->try_again_after)::BaseType> try_again_after_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
    in_try_again_after,
    try_again_after_fragment);

  params->try_again_after.Set(
      try_again_after_fragment.is_null() ? nullptr : try_again_after_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CoreControlTest::Name_);
  message.set_method_name("VerifyIpProtectionCoreHostForTesting");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CoreControlTest_IsIpProtectionEnabledForTesting_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CoreControlTest::IsIpProtectionEnabledForTestingCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CoreControlTest_IsIpProtectionEnabledForTesting_ProxyToResponder> proxy(
        new CoreControlTest_IsIpProtectionEnabledForTesting_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CoreControlTest_IsIpProtectionEnabledForTesting_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CoreControlTest_IsIpProtectionEnabledForTesting_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CoreControlTest_IsIpProtectionEnabledForTesting_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "CoreControlTest::IsIpProtectionEnabledForTestingCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_value);
};

bool CoreControlTest_IsIpProtectionEnabledForTesting_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CoreControlTest_IsIpProtectionEnabledForTesting_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CoreControlTest_IsIpProtectionEnabledForTesting_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CoreControlTest.1
  bool success = true;
  bool p_value{};
  CoreControlTest_IsIpProtectionEnabledForTesting_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_value = input_data_view.value();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CoreControlTest::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_value));
  }
  return true;
}

void CoreControlTest_IsIpProtectionEnabledForTesting_ProxyToResponder::Run(
    bool in_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply ip_protection::mojom::CoreControlTest::IsIpProtectionEnabledForTesting", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("value"), in_value,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CoreControlTest::kIsIpProtectionEnabledForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::ip_protection::mojom::internal::CoreControlTest_IsIpProtectionEnabledForTesting_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->value = in_value;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CoreControlTest::Name_);
  message.set_method_name("IsIpProtectionEnabledForTesting");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CoreControlTest_GetAuthTokenForTesting_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CoreControlTest::GetAuthTokenForTestingCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CoreControlTest_GetAuthTokenForTesting_ProxyToResponder> proxy(
        new CoreControlTest_GetAuthTokenForTesting_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CoreControlTest_GetAuthTokenForTesting_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CoreControlTest_GetAuthTokenForTesting_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CoreControlTest_GetAuthTokenForTesting_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "CoreControlTest::GetAuthTokenForTestingCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::optional<::ip_protection::BlindSignedAuthToken> in_token);
};

bool CoreControlTest_GetAuthTokenForTesting_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CoreControlTest_GetAuthTokenForTesting_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CoreControlTest_GetAuthTokenForTesting_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CoreControlTest.2
  bool success = true;
  std::optional<::ip_protection::BlindSignedAuthToken> p_token{};
  CoreControlTest_GetAuthTokenForTesting_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadToken(&p_token))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CoreControlTest::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_token));
  }
  return true;
}

void CoreControlTest_GetAuthTokenForTesting_ProxyToResponder::Run(
    std::optional<::ip_protection::BlindSignedAuthToken> in_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply ip_protection::mojom::CoreControlTest::GetAuthTokenForTesting", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token,
                        "<value of type std::optional<::ip_protection::BlindSignedAuthToken>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CoreControlTest::kGetAuthTokenForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::ip_protection::mojom::internal::CoreControlTest_GetAuthTokenForTesting_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->token)::BaseType> token_fragment(
          params.message());
  
  mojo::internal::Serialize<::ip_protection::mojom::BlindSignedAuthTokenDataView>(
    in_token,
    token_fragment);

  params->token.Set(
      token_fragment.is_null() ? nullptr : token_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CoreControlTest::Name_);
  message.set_method_name("GetAuthTokenForTesting");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CoreControlTest_HasTrackingProtectionExceptionForTesting_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CoreControlTest::HasTrackingProtectionExceptionForTestingCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CoreControlTest_HasTrackingProtectionExceptionForTesting_ProxyToResponder> proxy(
        new CoreControlTest_HasTrackingProtectionExceptionForTesting_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CoreControlTest_HasTrackingProtectionExceptionForTesting_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CoreControlTest_HasTrackingProtectionExceptionForTesting_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CoreControlTest_HasTrackingProtectionExceptionForTesting_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "CoreControlTest::HasTrackingProtectionExceptionForTestingCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_has_exception);
};

bool CoreControlTest_HasTrackingProtectionExceptionForTesting_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CoreControlTest_HasTrackingProtectionExceptionForTesting_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CoreControlTest_HasTrackingProtectionExceptionForTesting_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CoreControlTest.3
  bool success = true;
  bool p_has_exception{};
  CoreControlTest_HasTrackingProtectionExceptionForTesting_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_has_exception = input_data_view.has_exception();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CoreControlTest::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_has_exception));
  }
  return true;
}

void CoreControlTest_HasTrackingProtectionExceptionForTesting_ProxyToResponder::Run(
    bool in_has_exception) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply ip_protection::mojom::CoreControlTest::HasTrackingProtectionExceptionForTesting", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("has_exception"), in_has_exception,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CoreControlTest::kHasTrackingProtectionExceptionForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::ip_protection::mojom::internal::CoreControlTest_HasTrackingProtectionExceptionForTesting_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->has_exception = in_has_exception;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CoreControlTest::Name_);
  message.set_method_name("HasTrackingProtectionExceptionForTesting");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool CoreControlTestStubDispatch::Accept(
    CoreControlTest* impl,
    mojo::Message* message) {
  switch (static_cast<messages::CoreControlTest>(message->header()->name)) {
    case messages::CoreControlTest::kVerifyIpProtectionCoreHostForTesting: {
      break;
    }
    case messages::CoreControlTest::kIsIpProtectionEnabledForTesting: {
      break;
    }
    case messages::CoreControlTest::kGetAuthTokenForTesting: {
      break;
    }
    case messages::CoreControlTest::kHasTrackingProtectionExceptionForTesting: {
      break;
    }
  }
  return false;
}

// static
bool CoreControlTestStubDispatch::AcceptWithResponder(
    CoreControlTest* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::CoreControlTest>(message->header()->name)) {
    case messages::CoreControlTest::kVerifyIpProtectionCoreHostForTesting: {
      internal::CoreControlTest_VerifyIpProtectionCoreHostForTesting_Params_Data* params =
          reinterpret_cast<
              internal::CoreControlTest_VerifyIpProtectionCoreHostForTesting_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CoreControlTest.0
      bool success = true;
      CoreControlTest_VerifyIpProtectionCoreHostForTesting_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CoreControlTest::Name_, 0, false);
        return false;
      }
      auto callback =
          CoreControlTest_VerifyIpProtectionCoreHostForTesting_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->VerifyIpProtectionCoreHostForTesting(std::move(callback));
      return true;
    }
    case messages::CoreControlTest::kIsIpProtectionEnabledForTesting: {
      internal::CoreControlTest_IsIpProtectionEnabledForTesting_Params_Data* params =
          reinterpret_cast<
              internal::CoreControlTest_IsIpProtectionEnabledForTesting_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CoreControlTest.1
      bool success = true;
      CoreControlTest_IsIpProtectionEnabledForTesting_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CoreControlTest::Name_, 1, false);
        return false;
      }
      auto callback =
          CoreControlTest_IsIpProtectionEnabledForTesting_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->IsIpProtectionEnabledForTesting(std::move(callback));
      return true;
    }
    case messages::CoreControlTest::kGetAuthTokenForTesting: {
      internal::CoreControlTest_GetAuthTokenForTesting_Params_Data* params =
          reinterpret_cast<
              internal::CoreControlTest_GetAuthTokenForTesting_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CoreControlTest.2
      bool success = true;
      ::ip_protection::ProxyLayer p_proxy_layer{};
      std::string p_geo_id{};
      CoreControlTest_GetAuthTokenForTesting_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadProxyLayer(&p_proxy_layer))
        success = false;
      if (success && !input_data_view.ReadGeoId(&p_geo_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CoreControlTest::Name_, 2, false);
        return false;
      }
      auto callback =
          CoreControlTest_GetAuthTokenForTesting_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAuthTokenForTesting(        
        std::move(p_proxy_layer), 
        std::move(p_geo_id), std::move(callback));
      return true;
    }
    case messages::CoreControlTest::kHasTrackingProtectionExceptionForTesting: {
      internal::CoreControlTest_HasTrackingProtectionExceptionForTesting_Params_Data* params =
          reinterpret_cast<
              internal::CoreControlTest_HasTrackingProtectionExceptionForTesting_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CoreControlTest.3
      bool success = true;
      ::GURL p_first_party_url{};
      CoreControlTest_HasTrackingProtectionExceptionForTesting_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFirstPartyUrl(&p_first_party_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CoreControlTest::Name_, 3, false);
        return false;
      }
      auto callback =
          CoreControlTest_HasTrackingProtectionExceptionForTesting_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HasTrackingProtectionExceptionForTesting(        
        std::move(p_first_party_url), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kCoreControlTestValidationInfo[] = {
    { &internal::CoreControlTest_VerifyIpProtectionCoreHostForTesting_Params_Data::Validate,
     &internal::CoreControlTest_VerifyIpProtectionCoreHostForTesting_ResponseParams_Data::Validate},
    { &internal::CoreControlTest_IsIpProtectionEnabledForTesting_Params_Data::Validate,
     &internal::CoreControlTest_IsIpProtectionEnabledForTesting_ResponseParams_Data::Validate},
    { &internal::CoreControlTest_GetAuthTokenForTesting_Params_Data::Validate,
     &internal::CoreControlTest_GetAuthTokenForTesting_ResponseParams_Data::Validate},
    { &internal::CoreControlTest_HasTrackingProtectionExceptionForTesting_Params_Data::Validate,
     &internal::CoreControlTest_HasTrackingProtectionExceptionForTesting_ResponseParams_Data::Validate},
};

bool CoreControlTestRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::ip_protection::mojom::CoreControlTest::Name_,
    kCoreControlTestValidationInfo);
}

bool CoreControlTestResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::ip_protection::mojom::CoreControlTest::Name_,
    kCoreControlTestValidationInfo);
}


}  // ip_protection::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace ip_protection::mojom {


void CoreControlTestInterceptorForTesting::VerifyIpProtectionCoreHostForTesting(VerifyIpProtectionCoreHostForTestingCallback callback) {
  GetForwardingInterface()->VerifyIpProtectionCoreHostForTesting(std::move(callback));
}
void CoreControlTestInterceptorForTesting::IsIpProtectionEnabledForTesting(IsIpProtectionEnabledForTestingCallback callback) {
  GetForwardingInterface()->IsIpProtectionEnabledForTesting(std::move(callback));
}
void CoreControlTestInterceptorForTesting::GetAuthTokenForTesting(::ip_protection::ProxyLayer proxy_layer, const std::string& geo_id, GetAuthTokenForTestingCallback callback) {
  GetForwardingInterface()->GetAuthTokenForTesting(
    std::move(proxy_layer)
    , 
    std::move(geo_id)
    , std::move(callback));
}
void CoreControlTestInterceptorForTesting::HasTrackingProtectionExceptionForTesting(const ::GURL& first_party_url, HasTrackingProtectionExceptionForTestingCallback callback) {
  GetForwardingInterface()->HasTrackingProtectionExceptionForTesting(
    std::move(first_party_url)
    , std::move(callback));
}
CoreControlTestAsyncWaiter::CoreControlTestAsyncWaiter(
    CoreControlTest* proxy) : proxy_(proxy) {}

CoreControlTestAsyncWaiter::~CoreControlTestAsyncWaiter() = default;


void CoreControlTestAsyncWaiter::VerifyIpProtectionCoreHostForTesting(
    std::optional<::ip_protection::BlindSignedAuthToken>* out_bsa_token, std::optional<::base::Time>* out_try_again_after) {
  base::RunLoop loop;
  proxy_->VerifyIpProtectionCoreHostForTesting(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<::ip_protection::BlindSignedAuthToken>* out_bsa_token
,
             std::optional<::base::Time>* out_try_again_after
,
             std::optional<::ip_protection::BlindSignedAuthToken> bsa_token,
             std::optional<::base::Time> try_again_after) {*out_bsa_token = std::move(bsa_token);*out_try_again_after = std::move(try_again_after);
            loop->Quit();
          },
          &loop,
          out_bsa_token,
          out_try_again_after));
  loop.Run();
}



void CoreControlTestAsyncWaiter::IsIpProtectionEnabledForTesting(
    bool* out_value) {
  base::RunLoop loop;
  proxy_->IsIpProtectionEnabledForTesting(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_value
,
             bool value) {*out_value = std::move(value);
            loop->Quit();
          },
          &loop,
          out_value));
  loop.Run();
}

bool CoreControlTestAsyncWaiter::IsIpProtectionEnabledForTesting(
    ) {
  bool async_wait_result;
  IsIpProtectionEnabledForTesting(&async_wait_result);
  return async_wait_result;
}

void CoreControlTestAsyncWaiter::GetAuthTokenForTesting(
    ::ip_protection::ProxyLayer proxy_layer, const std::string& geo_id, std::optional<::ip_protection::BlindSignedAuthToken>* out_token) {
  base::RunLoop loop;
  proxy_->GetAuthTokenForTesting(
      std::move(proxy_layer),
      std::move(geo_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<::ip_protection::BlindSignedAuthToken>* out_token
,
             std::optional<::ip_protection::BlindSignedAuthToken> token) {*out_token = std::move(token);
            loop->Quit();
          },
          &loop,
          out_token));
  loop.Run();
}

std::optional<::ip_protection::BlindSignedAuthToken> CoreControlTestAsyncWaiter::GetAuthTokenForTesting(
    ::ip_protection::ProxyLayer proxy_layer, const std::string& geo_id) {
  std::optional<::ip_protection::BlindSignedAuthToken> async_wait_result;
  GetAuthTokenForTesting(std::move(proxy_layer),std::move(geo_id),&async_wait_result);
  return async_wait_result;
}

void CoreControlTestAsyncWaiter::HasTrackingProtectionExceptionForTesting(
    const ::GURL& first_party_url, bool* out_has_exception) {
  base::RunLoop loop;
  proxy_->HasTrackingProtectionExceptionForTesting(
      std::move(first_party_url),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_has_exception
,
             bool has_exception) {*out_has_exception = std::move(has_exception);
            loop->Quit();
          },
          &loop,
          out_has_exception));
  loop.Run();
}

bool CoreControlTestAsyncWaiter::HasTrackingProtectionExceptionForTesting(
    const ::GURL& first_party_url) {
  bool async_wait_result;
  HasTrackingProtectionExceptionForTesting(std::move(first_party_url),&async_wait_result);
  return async_wait_result;
}






}  // ip_protection::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif