// components/ip_protection/mojom/core.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/ip_protection/mojom/core.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/ip_protection/mojom/core.mojom-params-data.h"
#include "components/ip_protection/mojom/core.mojom-shared-message-ids.h"

#include "components/ip_protection/mojom/core.mojom-blink-import-headers.h"
#include "components/ip_protection/mojom/core.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace ip_protection::mojom::blink {
// The declaration includes the definition on other builds.

CoreControl::IPCStableHashFunction CoreControl::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::CoreControl>(message.name())) {
    case messages::CoreControl::kAuthTokensMayBeAvailable: {
      return &CoreControl::AuthTokensMayBeAvailable_Sym::IPCStableHash;
    }
    case messages::CoreControl::kSetIpProtectionEnabled: {
      return &CoreControl::SetIpProtectionEnabled_Sym::IPCStableHash;
    }
    case messages::CoreControl::kBindTestInterfaceForTesting: {
      return &CoreControl::BindTestInterfaceForTesting_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* CoreControl::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::CoreControl>(message.name())) {
      case messages::CoreControl::kAuthTokensMayBeAvailable:
            return "Receive ip_protection::mojom::CoreControl::AuthTokensMayBeAvailable";
      case messages::CoreControl::kSetIpProtectionEnabled:
            return "Receive ip_protection::mojom::CoreControl::SetIpProtectionEnabled";
      case messages::CoreControl::kBindTestInterfaceForTesting:
            return "Receive ip_protection::mojom::CoreControl::BindTestInterfaceForTesting";
    }
  } else {
    switch (static_cast<messages::CoreControl>(message.name())) {
      case messages::CoreControl::kAuthTokensMayBeAvailable:
            return "Receive reply ip_protection::mojom::CoreControl::AuthTokensMayBeAvailable";
      case messages::CoreControl::kSetIpProtectionEnabled:
            return "Receive reply ip_protection::mojom::CoreControl::SetIpProtectionEnabled";
      case messages::CoreControl::kBindTestInterfaceForTesting:
            return "Receive reply ip_protection::mojom::CoreControl::BindTestInterfaceForTesting";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t CoreControl::AuthTokensMayBeAvailable_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x76df7cf8;  // IPCStableHash for ip_protection::mojom::CoreControl::AuthTokensMayBeAvailable
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CoreControl::SetIpProtectionEnabled_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbd474a82;  // IPCStableHash for ip_protection::mojom::CoreControl::SetIpProtectionEnabled
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CoreControl::BindTestInterfaceForTesting_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x916b7ba0;  // IPCStableHash for ip_protection::mojom::CoreControl::BindTestInterfaceForTesting
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

CoreControlProxy::CoreControlProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CoreControlProxy::AuthTokensMayBeAvailable(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send ip_protection::mojom::CoreControl::AuthTokensMayBeAvailable");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CoreControl::kAuthTokensMayBeAvailable), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::ip_protection::mojom::internal::CoreControl_AuthTokensMayBeAvailable_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CoreControl::Name_);
  message.set_method_name("AuthTokensMayBeAvailable");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CoreControlProxy::SetIpProtectionEnabled(
    bool in_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send ip_protection::mojom::CoreControl::SetIpProtectionEnabled", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("value"), in_value,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CoreControl::kSetIpProtectionEnabled), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::ip_protection::mojom::internal::CoreControl_SetIpProtectionEnabled_Params_Data> params(
          message);
  params.Allocate();

  params->value = in_value;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CoreControl::Name_);
  message.set_method_name("SetIpProtectionEnabled");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CoreControlProxy::BindTestInterfaceForTesting(
    ::mojo::PendingReceiver<::ip_protection::mojom::blink::CoreControlTest> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send ip_protection::mojom::CoreControl::BindTestInterfaceForTesting", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::ip_protection::mojom::blink::CoreControlTest>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CoreControl::kBindTestInterfaceForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::ip_protection::mojom::internal::CoreControl_BindTestInterfaceForTesting_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::ip_protection::mojom::CoreControlTestInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in CoreControl.BindTestInterfaceForTesting request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CoreControl::Name_);
  message.set_method_name("BindTestInterfaceForTesting");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool CoreControlStubDispatch::Accept(
    CoreControl* impl,
    mojo::Message* message) {
  switch (static_cast<messages::CoreControl>(message->header()->name)) {
    case messages::CoreControl::kAuthTokensMayBeAvailable: {
      DCHECK(message->is_serialized());
      internal::CoreControl_AuthTokensMayBeAvailable_Params_Data* params =
          reinterpret_cast<internal::CoreControl_AuthTokensMayBeAvailable_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CoreControl.0
      bool success = true;
      CoreControl_AuthTokensMayBeAvailable_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CoreControl::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AuthTokensMayBeAvailable(        );
      return true;
    }
    case messages::CoreControl::kSetIpProtectionEnabled: {
      DCHECK(message->is_serialized());
      internal::CoreControl_SetIpProtectionEnabled_Params_Data* params =
          reinterpret_cast<internal::CoreControl_SetIpProtectionEnabled_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CoreControl.1
      bool success = true;
      bool p_value{};
      CoreControl_SetIpProtectionEnabled_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_value = input_data_view.value();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CoreControl::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetIpProtectionEnabled(        
        std::move(p_value));
      return true;
    }
    case messages::CoreControl::kBindTestInterfaceForTesting: {
      DCHECK(message->is_serialized());
      internal::CoreControl_BindTestInterfaceForTesting_Params_Data* params =
          reinterpret_cast<internal::CoreControl_BindTestInterfaceForTesting_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CoreControl.2
      bool success = true;
      ::mojo::PendingReceiver<::ip_protection::mojom::blink::CoreControlTest> p_receiver{};
      CoreControl_BindTestInterfaceForTesting_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CoreControl::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindTestInterfaceForTesting(        
        std::move(p_receiver));
      return true;
    }
  }
  return false;
}

// static
bool CoreControlStubDispatch::AcceptWithResponder(
    CoreControl* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::CoreControl>(message->header()->name)) {
    case messages::CoreControl::kAuthTokensMayBeAvailable: {
      break;
    }
    case messages::CoreControl::kSetIpProtectionEnabled: {
      break;
    }
    case messages::CoreControl::kBindTestInterfaceForTesting: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kCoreControlValidationInfo[] = {
    { &internal::CoreControl_AuthTokensMayBeAvailable_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::CoreControl_SetIpProtectionEnabled_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::CoreControl_BindTestInterfaceForTesting_Params_Data::Validate,
     nullptr /* no response */},
};

bool CoreControlRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::ip_protection::mojom::blink::CoreControl::Name_,
    kCoreControlValidationInfo);
}

// The declaration includes the definition on other builds.

CoreHost::IPCStableHashFunction CoreHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::CoreHost>(message.name())) {
    case messages::CoreHost::kTryGetAuthTokens: {
      return &CoreHost::TryGetAuthTokens_Sym::IPCStableHash;
    }
    case messages::CoreHost::kGetProxyConfig: {
      return &CoreHost::GetProxyConfig_Sym::IPCStableHash;
    }
    case messages::CoreHost::kTryGetProbabilisticRevealTokens: {
      return &CoreHost::TryGetProbabilisticRevealTokens_Sym::IPCStableHash;
    }
    case messages::CoreHost::kRecycleTokens: {
      return &CoreHost::RecycleTokens_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* CoreHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::CoreHost>(message.name())) {
      case messages::CoreHost::kTryGetAuthTokens:
            return "Receive ip_protection::mojom::CoreHost::TryGetAuthTokens";
      case messages::CoreHost::kGetProxyConfig:
            return "Receive ip_protection::mojom::CoreHost::GetProxyConfig";
      case messages::CoreHost::kTryGetProbabilisticRevealTokens:
            return "Receive ip_protection::mojom::CoreHost::TryGetProbabilisticRevealTokens";
      case messages::CoreHost::kRecycleTokens:
            return "Receive ip_protection::mojom::CoreHost::RecycleTokens";
    }
  } else {
    switch (static_cast<messages::CoreHost>(message.name())) {
      case messages::CoreHost::kTryGetAuthTokens:
            return "Receive reply ip_protection::mojom::CoreHost::TryGetAuthTokens";
      case messages::CoreHost::kGetProxyConfig:
            return "Receive reply ip_protection::mojom::CoreHost::GetProxyConfig";
      case messages::CoreHost::kTryGetProbabilisticRevealTokens:
            return "Receive reply ip_protection::mojom::CoreHost::TryGetProbabilisticRevealTokens";
      case messages::CoreHost::kRecycleTokens:
            return "Receive reply ip_protection::mojom::CoreHost::RecycleTokens";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t CoreHost::TryGetAuthTokens_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcd2396f1;  // IPCStableHash for ip_protection::mojom::CoreHost::TryGetAuthTokens
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CoreHost::GetProxyConfig_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa8f2299c;  // IPCStableHash for ip_protection::mojom::CoreHost::GetProxyConfig
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CoreHost::TryGetProbabilisticRevealTokens_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x923db723;  // IPCStableHash for ip_protection::mojom::CoreHost::TryGetProbabilisticRevealTokens
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CoreHost::RecycleTokens_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3db4caf1;  // IPCStableHash for ip_protection::mojom::CoreHost::RecycleTokens
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class CoreHost_TryGetAuthTokens_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CoreHost_TryGetAuthTokens_ForwardToCallback(
      CoreHost::TryGetAuthTokensCallback callback
      ) : callback_(std::move(callback)) {
  }

  CoreHost_TryGetAuthTokens_ForwardToCallback(const CoreHost_TryGetAuthTokens_ForwardToCallback&) = delete;
  CoreHost_TryGetAuthTokens_ForwardToCallback& operator=(const CoreHost_TryGetAuthTokens_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CoreHost::TryGetAuthTokensCallback callback_;
};

class CoreHost_GetProxyConfig_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CoreHost_GetProxyConfig_ForwardToCallback(
      CoreHost::GetProxyConfigCallback callback
      ) : callback_(std::move(callback)) {
  }

  CoreHost_GetProxyConfig_ForwardToCallback(const CoreHost_GetProxyConfig_ForwardToCallback&) = delete;
  CoreHost_GetProxyConfig_ForwardToCallback& operator=(const CoreHost_GetProxyConfig_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CoreHost::GetProxyConfigCallback callback_;
};

class CoreHost_TryGetProbabilisticRevealTokens_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CoreHost_TryGetProbabilisticRevealTokens_ForwardToCallback(
      CoreHost::TryGetProbabilisticRevealTokensCallback callback
      ) : callback_(std::move(callback)) {
  }

  CoreHost_TryGetProbabilisticRevealTokens_ForwardToCallback(const CoreHost_TryGetProbabilisticRevealTokens_ForwardToCallback&) = delete;
  CoreHost_TryGetProbabilisticRevealTokens_ForwardToCallback& operator=(const CoreHost_TryGetProbabilisticRevealTokens_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CoreHost::TryGetProbabilisticRevealTokensCallback callback_;
};

CoreHostProxy::CoreHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CoreHostProxy::TryGetAuthTokens(
    uint32_t in_batch_size, ::ip_protection::mojom::blink::ProxyLayer in_proxy_layer, TryGetAuthTokensCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send ip_protection::mojom::CoreHost::TryGetAuthTokens", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("batch_size"), in_batch_size,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("proxy_layer"), in_proxy_layer,
                        "<value of type ::ip_protection::mojom::blink::ProxyLayer>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CoreHost::kTryGetAuthTokens), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::ip_protection::mojom::internal::CoreHost_TryGetAuthTokens_Params_Data> params(
          message);
  params.Allocate();

  params->batch_size = in_batch_size;

  
  mojo::internal::Serialize<::ip_protection::mojom::ProxyLayer>(
    in_proxy_layer,
    &params->proxy_layer);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CoreHost::Name_);
  message.set_method_name("TryGetAuthTokens");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CoreHost_TryGetAuthTokens_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void CoreHostProxy::GetProxyConfig(
    GetProxyConfigCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send ip_protection::mojom::CoreHost::GetProxyConfig");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CoreHost::kGetProxyConfig), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::ip_protection::mojom::internal::CoreHost_GetProxyConfig_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CoreHost::Name_);
  message.set_method_name("GetProxyConfig");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CoreHost_GetProxyConfig_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void CoreHostProxy::TryGetProbabilisticRevealTokens(
    TryGetProbabilisticRevealTokensCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send ip_protection::mojom::CoreHost::TryGetProbabilisticRevealTokens");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CoreHost::kTryGetProbabilisticRevealTokens), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::ip_protection::mojom::internal::CoreHost_TryGetProbabilisticRevealTokens_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CoreHost::Name_);
  message.set_method_name("TryGetProbabilisticRevealTokens");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CoreHost_TryGetProbabilisticRevealTokens_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void CoreHostProxy::RecycleTokens(
    ::ip_protection::mojom::blink::ProxyLayer in_proxy_layer, ::blink::Vector<::ip_protection::mojom::blink::BlindSignedAuthTokenPtr> in_tokens) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send ip_protection::mojom::CoreHost::RecycleTokens", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("proxy_layer"), in_proxy_layer,
                        "<value of type ::ip_protection::mojom::blink::ProxyLayer>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tokens"), in_tokens,
                        "<value of type ::blink::Vector<::ip_protection::mojom::blink::BlindSignedAuthTokenPtr>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CoreHost::kRecycleTokens), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::ip_protection::mojom::internal::CoreHost_RecycleTokens_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::ip_protection::mojom::ProxyLayer>(
    in_proxy_layer,
    &params->proxy_layer);
  mojo::internal::MessageFragment<
      typename decltype(params->tokens)::BaseType>
      tokens_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& tokens_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::ip_protection::mojom::BlindSignedAuthTokenDataView>>(
    in_tokens,
    tokens_fragment,
    &tokens_validate_params);

  params->tokens.Set(
      tokens_fragment.is_null() ? nullptr : tokens_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->tokens.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null tokens in CoreHost.RecycleTokens request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CoreHost::Name_);
  message.set_method_name("RecycleTokens");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class CoreHost_TryGetAuthTokens_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CoreHost::TryGetAuthTokensCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CoreHost_TryGetAuthTokens_ProxyToResponder> proxy(
        new CoreHost_TryGetAuthTokens_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CoreHost_TryGetAuthTokens_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CoreHost_TryGetAuthTokens_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CoreHost_TryGetAuthTokens_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "CoreHost::TryGetAuthTokensCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::optional<::blink::Vector<::ip_protection::mojom::blink::BlindSignedAuthTokenPtr>> in_bsa_tokens, std::optional<::base::Time> in_try_again_after);
};

bool CoreHost_TryGetAuthTokens_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CoreHost_TryGetAuthTokens_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CoreHost_TryGetAuthTokens_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CoreHost.0
  bool success = true;
  std::optional<::blink::Vector<::ip_protection::mojom::blink::BlindSignedAuthTokenPtr>> p_bsa_tokens{};
  std::optional<::base::Time> p_try_again_after{};
  CoreHost_TryGetAuthTokens_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadBsaTokens(&p_bsa_tokens))
    success = false;
  if (success && !input_data_view.ReadTryAgainAfter(&p_try_again_after))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CoreHost::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_bsa_tokens), 
std::move(p_try_again_after));
  }
  return true;
}

void CoreHost_TryGetAuthTokens_ProxyToResponder::Run(
    std::optional<::blink::Vector<::ip_protection::mojom::blink::BlindSignedAuthTokenPtr>> in_bsa_tokens, std::optional<::base::Time> in_try_again_after) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply ip_protection::mojom::CoreHost::TryGetAuthTokens", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bsa_tokens"), in_bsa_tokens,
                        "<value of type std::optional<::blink::Vector<::ip_protection::mojom::blink::BlindSignedAuthTokenPtr>>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("try_again_after"), in_try_again_after,
                        "<value of type std::optional<::base::Time>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CoreHost::kTryGetAuthTokens), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::ip_protection::mojom::internal::CoreHost_TryGetAuthTokens_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->bsa_tokens)::BaseType>
      bsa_tokens_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& bsa_tokens_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::ip_protection::mojom::BlindSignedAuthTokenDataView>>(
    in_bsa_tokens,
    bsa_tokens_fragment,
    &bsa_tokens_validate_params);

  params->bsa_tokens.Set(
      bsa_tokens_fragment.is_null() ? nullptr : bsa_tokens_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->try_again_after)::BaseType> try_again_after_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
    in_try_again_after,
    try_again_after_fragment);

  params->try_again_after.Set(
      try_again_after_fragment.is_null() ? nullptr : try_again_after_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CoreHost::Name_);
  message.set_method_name("TryGetAuthTokens");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CoreHost_GetProxyConfig_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CoreHost::GetProxyConfigCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CoreHost_GetProxyConfig_ProxyToResponder> proxy(
        new CoreHost_GetProxyConfig_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CoreHost_GetProxyConfig_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CoreHost_GetProxyConfig_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CoreHost_GetProxyConfig_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "CoreHost::GetProxyConfigCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::optional<::blink::Vector<::net::ProxyChain>>& in_proxy_list, ::ip_protection::mojom::blink::GeoHintPtr in_geo_hint);
};

bool CoreHost_GetProxyConfig_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CoreHost_GetProxyConfig_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CoreHost_GetProxyConfig_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CoreHost.1
  bool success = true;
  std::optional<::blink::Vector<::net::ProxyChain>> p_proxy_list{};
  ::ip_protection::mojom::blink::GeoHintPtr p_geo_hint{};
  CoreHost_GetProxyConfig_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadProxyList(&p_proxy_list))
    success = false;
  if (success && !input_data_view.ReadGeoHint(&p_geo_hint))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CoreHost::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_proxy_list), 
std::move(p_geo_hint));
  }
  return true;
}

void CoreHost_GetProxyConfig_ProxyToResponder::Run(
    const std::optional<::blink::Vector<::net::ProxyChain>>& in_proxy_list, ::ip_protection::mojom::blink::GeoHintPtr in_geo_hint) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply ip_protection::mojom::CoreHost::GetProxyConfig", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("proxy_list"), in_proxy_list,
                        "<value of type const std::optional<::blink::Vector<::net::ProxyChain>>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("geo_hint"), in_geo_hint,
                        "<value of type ::ip_protection::mojom::blink::GeoHintPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CoreHost::kGetProxyConfig), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::ip_protection::mojom::internal::CoreHost_GetProxyConfig_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->proxy_list)::BaseType>
      proxy_list_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& proxy_list_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::ProxyChainDataView>>(
    in_proxy_list,
    proxy_list_fragment,
    &proxy_list_validate_params);

  params->proxy_list.Set(
      proxy_list_fragment.is_null() ? nullptr : proxy_list_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->geo_hint)::BaseType> geo_hint_fragment(
          params.message());
  
  mojo::internal::Serialize<::ip_protection::mojom::GeoHintDataView>(
    in_geo_hint,
    geo_hint_fragment);

  params->geo_hint.Set(
      geo_hint_fragment.is_null() ? nullptr : geo_hint_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CoreHost::Name_);
  message.set_method_name("GetProxyConfig");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CoreHost_TryGetProbabilisticRevealTokens_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CoreHost::TryGetProbabilisticRevealTokensCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CoreHost_TryGetProbabilisticRevealTokens_ProxyToResponder> proxy(
        new CoreHost_TryGetProbabilisticRevealTokens_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CoreHost_TryGetProbabilisticRevealTokens_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CoreHost_TryGetProbabilisticRevealTokens_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CoreHost_TryGetProbabilisticRevealTokens_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "CoreHost::TryGetProbabilisticRevealTokensCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::ip_protection::mojom::blink::TryGetProbabilisticRevealTokensOutcomePtr in_outcome, ::ip_protection::mojom::blink::TryGetProbabilisticRevealTokensResultPtr in_result);
};

bool CoreHost_TryGetProbabilisticRevealTokens_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CoreHost_TryGetProbabilisticRevealTokens_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CoreHost_TryGetProbabilisticRevealTokens_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CoreHost.2
  bool success = true;
  ::ip_protection::mojom::blink::TryGetProbabilisticRevealTokensOutcomePtr p_outcome{};
  ::ip_protection::mojom::blink::TryGetProbabilisticRevealTokensResultPtr p_result{};
  CoreHost_TryGetProbabilisticRevealTokens_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadOutcome(&p_outcome))
    success = false;
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CoreHost::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_outcome), 
std::move(p_result));
  }
  return true;
}

void CoreHost_TryGetProbabilisticRevealTokens_ProxyToResponder::Run(
    ::ip_protection::mojom::blink::TryGetProbabilisticRevealTokensOutcomePtr in_outcome, ::ip_protection::mojom::blink::TryGetProbabilisticRevealTokensResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply ip_protection::mojom::CoreHost::TryGetProbabilisticRevealTokens", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("outcome"), in_outcome,
                        "<value of type ::ip_protection::mojom::blink::TryGetProbabilisticRevealTokensOutcomePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::ip_protection::mojom::blink::TryGetProbabilisticRevealTokensResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CoreHost::kTryGetProbabilisticRevealTokens), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::ip_protection::mojom::internal::CoreHost_TryGetProbabilisticRevealTokens_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->outcome)::BaseType> outcome_fragment(
          params.message());
  
  mojo::internal::Serialize<::ip_protection::mojom::TryGetProbabilisticRevealTokensOutcomeDataView>(
    in_outcome,
    outcome_fragment);

  params->outcome.Set(
      outcome_fragment.is_null() ? nullptr : outcome_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::ip_protection::mojom::TryGetProbabilisticRevealTokensResultDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CoreHost::Name_);
  message.set_method_name("TryGetProbabilisticRevealTokens");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool CoreHostStubDispatch::Accept(
    CoreHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::CoreHost>(message->header()->name)) {
    case messages::CoreHost::kTryGetAuthTokens: {
      break;
    }
    case messages::CoreHost::kGetProxyConfig: {
      break;
    }
    case messages::CoreHost::kTryGetProbabilisticRevealTokens: {
      break;
    }
    case messages::CoreHost::kRecycleTokens: {
      DCHECK(message->is_serialized());
      internal::CoreHost_RecycleTokens_Params_Data* params =
          reinterpret_cast<internal::CoreHost_RecycleTokens_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CoreHost.3
      bool success = true;
      ::ip_protection::mojom::blink::ProxyLayer p_proxy_layer{};
      ::blink::Vector<::ip_protection::mojom::blink::BlindSignedAuthTokenPtr> p_tokens{};
      CoreHost_RecycleTokens_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadProxyLayer(&p_proxy_layer))
        success = false;
      if (success && !input_data_view.ReadTokens(&p_tokens))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CoreHost::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RecycleTokens(        
        std::move(p_proxy_layer), 
        std::move(p_tokens));
      return true;
    }
  }
  return false;
}

// static
bool CoreHostStubDispatch::AcceptWithResponder(
    CoreHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::CoreHost>(message->header()->name)) {
    case messages::CoreHost::kTryGetAuthTokens: {
      internal::CoreHost_TryGetAuthTokens_Params_Data* params =
          reinterpret_cast<
              internal::CoreHost_TryGetAuthTokens_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CoreHost.0
      bool success = true;
      uint32_t p_batch_size{};
      ::ip_protection::mojom::blink::ProxyLayer p_proxy_layer{};
      CoreHost_TryGetAuthTokens_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_batch_size = input_data_view.batch_size();
      if (success && !input_data_view.ReadProxyLayer(&p_proxy_layer))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CoreHost::Name_, 0, false);
        return false;
      }
      auto callback =
          CoreHost_TryGetAuthTokens_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TryGetAuthTokens(        
        std::move(p_batch_size), 
        std::move(p_proxy_layer), std::move(callback));
      return true;
    }
    case messages::CoreHost::kGetProxyConfig: {
      internal::CoreHost_GetProxyConfig_Params_Data* params =
          reinterpret_cast<
              internal::CoreHost_GetProxyConfig_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CoreHost.1
      bool success = true;
      CoreHost_GetProxyConfig_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CoreHost::Name_, 1, false);
        return false;
      }
      auto callback =
          CoreHost_GetProxyConfig_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetProxyConfig(std::move(callback));
      return true;
    }
    case messages::CoreHost::kTryGetProbabilisticRevealTokens: {
      internal::CoreHost_TryGetProbabilisticRevealTokens_Params_Data* params =
          reinterpret_cast<
              internal::CoreHost_TryGetProbabilisticRevealTokens_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CoreHost.2
      bool success = true;
      CoreHost_TryGetProbabilisticRevealTokens_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CoreHost::Name_, 2, false);
        return false;
      }
      auto callback =
          CoreHost_TryGetProbabilisticRevealTokens_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TryGetProbabilisticRevealTokens(std::move(callback));
      return true;
    }
    case messages::CoreHost::kRecycleTokens: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kCoreHostValidationInfo[] = {
    { &internal::CoreHost_TryGetAuthTokens_Params_Data::Validate,
     &internal::CoreHost_TryGetAuthTokens_ResponseParams_Data::Validate},
    { &internal::CoreHost_GetProxyConfig_Params_Data::Validate,
     &internal::CoreHost_GetProxyConfig_ResponseParams_Data::Validate},
    { &internal::CoreHost_TryGetProbabilisticRevealTokens_Params_Data::Validate,
     &internal::CoreHost_TryGetProbabilisticRevealTokens_ResponseParams_Data::Validate},
    { &internal::CoreHost_RecycleTokens_Params_Data::Validate,
     nullptr /* no response */},
};

bool CoreHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::ip_protection::mojom::blink::CoreHost::Name_,
    kCoreHostValidationInfo);
}

bool CoreHostResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::ip_protection::mojom::blink::CoreHost::Name_,
    kCoreHostValidationInfo);
}


}  // ip_protection::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace ip_protection::mojom::blink {


void CoreControlInterceptorForTesting::AuthTokensMayBeAvailable() {
  GetForwardingInterface()->AuthTokensMayBeAvailable();
}
void CoreControlInterceptorForTesting::SetIpProtectionEnabled(bool value) {
  GetForwardingInterface()->SetIpProtectionEnabled(
    std::move(value)
    );
}
void CoreControlInterceptorForTesting::BindTestInterfaceForTesting(::mojo::PendingReceiver<::ip_protection::mojom::blink::CoreControlTest> receiver) {
  GetForwardingInterface()->BindTestInterfaceForTesting(
    std::move(receiver)
    );
}
CoreControlAsyncWaiter::CoreControlAsyncWaiter(
    CoreControl* proxy) : proxy_(proxy) {}

CoreControlAsyncWaiter::~CoreControlAsyncWaiter() = default;





void CoreHostInterceptorForTesting::TryGetAuthTokens(uint32_t batch_size, ::ip_protection::mojom::blink::ProxyLayer proxy_layer, TryGetAuthTokensCallback callback) {
  GetForwardingInterface()->TryGetAuthTokens(
    std::move(batch_size)
    , 
    std::move(proxy_layer)
    , std::move(callback));
}
void CoreHostInterceptorForTesting::GetProxyConfig(GetProxyConfigCallback callback) {
  GetForwardingInterface()->GetProxyConfig(std::move(callback));
}
void CoreHostInterceptorForTesting::TryGetProbabilisticRevealTokens(TryGetProbabilisticRevealTokensCallback callback) {
  GetForwardingInterface()->TryGetProbabilisticRevealTokens(std::move(callback));
}
void CoreHostInterceptorForTesting::RecycleTokens(::ip_protection::mojom::blink::ProxyLayer proxy_layer, ::blink::Vector<::ip_protection::mojom::blink::BlindSignedAuthTokenPtr> tokens) {
  GetForwardingInterface()->RecycleTokens(
    std::move(proxy_layer)
    , 
    std::move(tokens)
    );
}
CoreHostAsyncWaiter::CoreHostAsyncWaiter(
    CoreHost* proxy) : proxy_(proxy) {}

CoreHostAsyncWaiter::~CoreHostAsyncWaiter() = default;


void CoreHostAsyncWaiter::TryGetAuthTokens(
    uint32_t batch_size, ::ip_protection::mojom::blink::ProxyLayer proxy_layer, std::optional<::blink::Vector<::ip_protection::mojom::blink::BlindSignedAuthTokenPtr>>* out_bsa_tokens, std::optional<::base::Time>* out_try_again_after) {
  base::RunLoop loop;
  proxy_->TryGetAuthTokens(
      std::move(batch_size),
      std::move(proxy_layer),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<::blink::Vector<::ip_protection::mojom::blink::BlindSignedAuthTokenPtr>>* out_bsa_tokens
,
             std::optional<::base::Time>* out_try_again_after
,
             std::optional<::blink::Vector<::ip_protection::mojom::blink::BlindSignedAuthTokenPtr>> bsa_tokens,
             std::optional<::base::Time> try_again_after) {*out_bsa_tokens = std::move(bsa_tokens);*out_try_again_after = std::move(try_again_after);
            loop->Quit();
          },
          &loop,
          out_bsa_tokens,
          out_try_again_after));
  loop.Run();
}



void CoreHostAsyncWaiter::GetProxyConfig(
    std::optional<::blink::Vector<::net::ProxyChain>>* out_proxy_list, ::ip_protection::mojom::blink::GeoHintPtr* out_geo_hint) {
  base::RunLoop loop;
  proxy_->GetProxyConfig(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<::blink::Vector<::net::ProxyChain>>* out_proxy_list
,
             ::ip_protection::mojom::blink::GeoHintPtr* out_geo_hint
,
             const std::optional<::blink::Vector<::net::ProxyChain>>& proxy_list,
             ::ip_protection::mojom::blink::GeoHintPtr geo_hint) {*out_proxy_list = std::move(proxy_list);*out_geo_hint = std::move(geo_hint);
            loop->Quit();
          },
          &loop,
          out_proxy_list,
          out_geo_hint));
  loop.Run();
}



void CoreHostAsyncWaiter::TryGetProbabilisticRevealTokens(
    ::ip_protection::mojom::blink::TryGetProbabilisticRevealTokensOutcomePtr* out_outcome, ::ip_protection::mojom::blink::TryGetProbabilisticRevealTokensResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->TryGetProbabilisticRevealTokens(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::ip_protection::mojom::blink::TryGetProbabilisticRevealTokensOutcomePtr* out_outcome
,
             ::ip_protection::mojom::blink::TryGetProbabilisticRevealTokensResultPtr* out_result
,
             ::ip_protection::mojom::blink::TryGetProbabilisticRevealTokensOutcomePtr outcome,
             ::ip_protection::mojom::blink::TryGetProbabilisticRevealTokensResultPtr result) {*out_outcome = std::move(outcome);*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_outcome,
          out_result));
  loop.Run();
}








}  // ip_protection::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif