// components/global_media_controls/public/mojom/device_service.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_GLOBAL_MEDIA_CONTROLS_PUBLIC_MOJOM_DEVICE_SERVICE_MOJOM_TEST_UTILS_H_
#define COMPONENTS_GLOBAL_MEDIA_CONTROLS_PUBLIC_MOJOM_DEVICE_SERVICE_MOJOM_TEST_UTILS_H_

#include "components/global_media_controls/public/mojom/device_service.mojom.h"


namespace global_media_controls::mojom {


class  DeviceListHostInterceptorForTesting : public DeviceListHost {
  virtual DeviceListHost* GetForwardingInterface() = 0;
  void SelectDevice(const std::string& device_id) override;
};
class  DeviceListHostAsyncWaiter {
 public:
  explicit DeviceListHostAsyncWaiter(DeviceListHost* proxy);

  DeviceListHostAsyncWaiter(const DeviceListHostAsyncWaiter&) = delete;
  DeviceListHostAsyncWaiter& operator=(const DeviceListHostAsyncWaiter&) = delete;

  ~DeviceListHostAsyncWaiter();

 private:
  DeviceListHost* const proxy_;
};


class  DeviceListClientInterceptorForTesting : public DeviceListClient {
  virtual DeviceListClient* GetForwardingInterface() = 0;
  void OnDevicesUpdated(std::vector<DevicePtr> devices) override;
  void OnPermissionRejected() override;
};
class  DeviceListClientAsyncWaiter {
 public:
  explicit DeviceListClientAsyncWaiter(DeviceListClient* proxy);

  DeviceListClientAsyncWaiter(const DeviceListClientAsyncWaiter&) = delete;
  DeviceListClientAsyncWaiter& operator=(const DeviceListClientAsyncWaiter&) = delete;

  ~DeviceListClientAsyncWaiter();

 private:
  DeviceListClient* const proxy_;
};


class  DeviceServiceInterceptorForTesting : public DeviceService {
  virtual DeviceService* GetForwardingInterface() = 0;
  void GetDeviceListHostForSession(const std::string& session_id, ::mojo::PendingReceiver<DeviceListHost> host_receiver, ::mojo::PendingRemote<DeviceListClient> client_remote) override;
  void GetDeviceListHostForPresentation(::mojo::PendingReceiver<DeviceListHost> host_receiver, ::mojo::PendingRemote<DeviceListClient> client_remote) override;
  void SetDevicePickerProvider(::mojo::PendingRemote<DevicePickerProvider> provider_remote) override;
};
class  DeviceServiceAsyncWaiter {
 public:
  explicit DeviceServiceAsyncWaiter(DeviceService* proxy);

  DeviceServiceAsyncWaiter(const DeviceServiceAsyncWaiter&) = delete;
  DeviceServiceAsyncWaiter& operator=(const DeviceServiceAsyncWaiter&) = delete;

  ~DeviceServiceAsyncWaiter();

 private:
  DeviceService* const proxy_;
};


class  DevicePickerProviderInterceptorForTesting : public DevicePickerProvider {
  virtual DevicePickerProvider* GetForwardingInterface() = 0;
  void CreateItem(const ::base::UnguessableToken& source_id) override;
  void DeleteItem() override;
  void ShowItem() override;
  void HideItem() override;
  void OnMetadataChanged(const ::media_session::MediaMetadata& metadata) override;
  void OnArtworkImageChanged(const ::gfx::ImageSkia& artwork_image) override;
  void OnFaviconImageChanged(const ::gfx::ImageSkia& favicon_image) override;
  void AddObserver(::mojo::PendingRemote<DevicePickerObserver> observer) override;
  void HideMediaUI() override;
};
class  DevicePickerProviderAsyncWaiter {
 public:
  explicit DevicePickerProviderAsyncWaiter(DevicePickerProvider* proxy);

  DevicePickerProviderAsyncWaiter(const DevicePickerProviderAsyncWaiter&) = delete;
  DevicePickerProviderAsyncWaiter& operator=(const DevicePickerProviderAsyncWaiter&) = delete;

  ~DevicePickerProviderAsyncWaiter();

 private:
  DevicePickerProvider* const proxy_;
};


class  DevicePickerObserverInterceptorForTesting : public DevicePickerObserver {
  virtual DevicePickerObserver* GetForwardingInterface() = 0;
  void OnMediaUIOpened() override;
  void OnMediaUIClosed() override;
  void OnMediaUIUpdated() override;
  void OnPickerDismissed() override;
};
class  DevicePickerObserverAsyncWaiter {
 public:
  explicit DevicePickerObserverAsyncWaiter(DevicePickerObserver* proxy);

  DevicePickerObserverAsyncWaiter(const DevicePickerObserverAsyncWaiter&) = delete;
  DevicePickerObserverAsyncWaiter& operator=(const DevicePickerObserverAsyncWaiter&) = delete;

  ~DevicePickerObserverAsyncWaiter();

 private:
  DevicePickerObserver* const proxy_;
};




}  // global_media_controls::mojom

#endif  // COMPONENTS_GLOBAL_MEDIA_CONTROLS_PUBLIC_MOJOM_DEVICE_SERVICE_MOJOM_TEST_UTILS_H_