// components/facilitated_payments/core/mojom/pix_code_validator.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_FACILITATED_PAYMENTS_CORE_MOJOM_PIX_CODE_VALIDATOR_MOJOM_H_
#define COMPONENTS_FACILITATED_PAYMENTS_CORE_MOJOM_PIX_CODE_VALIDATOR_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/facilitated_payments/core/mojom/pix_code_validator.mojom-features.h"  // IWYU pragma: export
#include "components/facilitated_payments/core/mojom/pix_code_validator.mojom-shared.h"  // IWYU pragma: export
#include "components/facilitated_payments/core/mojom/pix_code_validator.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace payments::facilitated::mojom {

class PixCodeValidatorProxy;

template <typename ImplRefTraits>
class PixCodeValidatorStub;

class PixCodeValidatorRequestValidator;
class PixCodeValidatorResponseValidator;


class PixCodeValidator
    : public PixCodeValidatorInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "payments.facilitated.mojom.PixCodeValidator";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PixCodeValidatorInterfaceBase;
  using Proxy_ = PixCodeValidatorProxy;

  template <typename ImplRefTraits>
  using Stub_ = PixCodeValidatorStub<ImplRefTraits>;

  using RequestValidator_ = PixCodeValidatorRequestValidator;
  using ResponseValidator_ = PixCodeValidatorResponseValidator;
  enum MethodMinVersions : uint32_t {
    kValidatePixCodeMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ValidatePixCode_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PixCodeValidator() = default;

  using ValidatePixCodeCallback = base::OnceCallback<void(std::optional<PixQrCodeType>)>;
  using ValidatePixCodeMojoCallback = base::OnceCallback<void(std::optional<PixQrCodeType>)>;

  virtual void ValidatePixCode(const std::string& input_text, ValidatePixCodeCallback callback) = 0;
};



class  PixCodeValidatorProxy
    : public PixCodeValidator {
 public:
  using InterfaceType = PixCodeValidator;

  explicit PixCodeValidatorProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ValidatePixCode(const std::string& input_text, ValidatePixCodeCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  PixCodeValidatorStubDispatch {
 public:
  static bool Accept(PixCodeValidator* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PixCodeValidator* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PixCodeValidator>>
class PixCodeValidatorStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PixCodeValidatorStub() = default;
  ~PixCodeValidatorStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PixCodeValidatorStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PixCodeValidatorStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PixCodeValidatorRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PixCodeValidatorResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // payments::facilitated::mojom

namespace mojo {

}  // namespace mojo

#endif  // COMPONENTS_FACILITATED_PAYMENTS_CORE_MOJOM_PIX_CODE_VALIDATOR_MOJOM_H_