// components/data_sharing/data_sharing_internals/webui/data_sharing_internals.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/data_sharing/data_sharing_internals/webui/data_sharing_internals.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/data_sharing/data_sharing_internals/webui/data_sharing_internals.mojom-params-data.h"
#include "components/data_sharing/data_sharing_internals/webui/data_sharing_internals.mojom-shared-message-ids.h"

#include "components/data_sharing/data_sharing_internals/webui/data_sharing_internals.mojom-import-headers.h"
#include "components/data_sharing/data_sharing_internals/webui/data_sharing_internals.mojom-test-utils.h"


namespace data_sharing_internals::mojom {
// The declaration includes the definition on other builds.

PageHandlerFactory::IPCStableHashFunction PageHandlerFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PageHandlerFactory>(message.name())) {
    case messages::PageHandlerFactory::kCreatePageHandler: {
      return &PageHandlerFactory::CreatePageHandler_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PageHandlerFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PageHandlerFactory>(message.name())) {
      case messages::PageHandlerFactory::kCreatePageHandler:
            return "Receive data_sharing_internals::mojom::PageHandlerFactory::CreatePageHandler";
    }
  } else {
    switch (static_cast<messages::PageHandlerFactory>(message.name())) {
      case messages::PageHandlerFactory::kCreatePageHandler:
            return "Receive reply data_sharing_internals::mojom::PageHandlerFactory::CreatePageHandler";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PageHandlerFactory::CreatePageHandler_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd4d3ae15;  // IPCStableHash for data_sharing_internals::mojom::PageHandlerFactory::CreatePageHandler
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PageHandlerFactoryProxy::PageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageHandlerFactoryProxy::CreatePageHandler(
    ::mojo::PendingRemote<Page> in_page, ::mojo::PendingReceiver<PageHandler> in_handler) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send data_sharing_internals::mojom::PageHandlerFactory::CreatePageHandler", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page"), in_page,
                        "<value of type ::mojo::PendingRemote<Page>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handler"), in_handler,
                        "<value of type ::mojo::PendingReceiver<PageHandler>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandlerFactory::kCreatePageHandler), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::data_sharing_internals::mojom::internal::PageHandlerFactory_CreatePageHandler_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::data_sharing_internals::mojom::PageInterfaceBase>>(
    in_page,
    &params->page,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->page)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid page in PageHandlerFactory.CreatePageHandler request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::data_sharing_internals::mojom::PageHandlerInterfaceBase>>(
    in_handler,
    &params->handler,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->handler)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid handler in PageHandlerFactory.CreatePageHandler request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandlerFactory::Name_);
  message.set_method_name("CreatePageHandler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PageHandlerFactoryStubDispatch::Accept(
    PageHandlerFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PageHandlerFactory>(message->header()->name)) {
    case messages::PageHandlerFactory::kCreatePageHandler: {
      DCHECK(message->is_serialized());
      internal::PageHandlerFactory_CreatePageHandler_Params_Data* params =
          reinterpret_cast<internal::PageHandlerFactory_CreatePageHandler_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandlerFactory.0
      bool success = true;
      ::mojo::PendingRemote<Page> p_page{};
      ::mojo::PendingReceiver<PageHandler> p_handler{};
      PageHandlerFactory_CreatePageHandler_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_page =
            input_data_view.TakePage<decltype(p_page)>();
      }
      if (success) {
        p_handler =
            input_data_view.TakeHandler<decltype(p_handler)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandlerFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreatePageHandler(        
        std::move(p_page), 
        std::move(p_handler));
      return true;
    }
  }
  return false;
}

// static
bool PageHandlerFactoryStubDispatch::AcceptWithResponder(
    PageHandlerFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PageHandlerFactory>(message->header()->name)) {
    case messages::PageHandlerFactory::kCreatePageHandler: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageHandlerFactoryValidationInfo[] = {
    { &internal::PageHandlerFactory_CreatePageHandler_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageHandlerFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::data_sharing_internals::mojom::PageHandlerFactory::Name_,
    kPageHandlerFactoryValidationInfo);
}

// The declaration includes the definition on other builds.

PageHandler::IPCStableHashFunction PageHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PageHandler>(message.name())) {
    case messages::PageHandler::kIsEmptyService: {
      return &PageHandler::IsEmptyService_Sym::IPCStableHash;
    }
    case messages::PageHandler::kGetAllGroups: {
      return &PageHandler::GetAllGroups_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PageHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PageHandler>(message.name())) {
      case messages::PageHandler::kIsEmptyService:
            return "Receive data_sharing_internals::mojom::PageHandler::IsEmptyService";
      case messages::PageHandler::kGetAllGroups:
            return "Receive data_sharing_internals::mojom::PageHandler::GetAllGroups";
    }
  } else {
    switch (static_cast<messages::PageHandler>(message.name())) {
      case messages::PageHandler::kIsEmptyService:
            return "Receive reply data_sharing_internals::mojom::PageHandler::IsEmptyService";
      case messages::PageHandler::kGetAllGroups:
            return "Receive reply data_sharing_internals::mojom::PageHandler::GetAllGroups";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PageHandler::IsEmptyService_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3effd23d;  // IPCStableHash for data_sharing_internals::mojom::PageHandler::IsEmptyService
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::GetAllGroups_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9a35d2f9;  // IPCStableHash for data_sharing_internals::mojom::PageHandler::GetAllGroups
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class PageHandler_IsEmptyService_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_IsEmptyService_ForwardToCallback(
      PageHandler::IsEmptyServiceCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_IsEmptyService_ForwardToCallback(const PageHandler_IsEmptyService_ForwardToCallback&) = delete;
  PageHandler_IsEmptyService_ForwardToCallback& operator=(const PageHandler_IsEmptyService_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::IsEmptyServiceCallback callback_;
};

class PageHandler_GetAllGroups_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_GetAllGroups_ForwardToCallback(
      PageHandler::GetAllGroupsCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_GetAllGroups_ForwardToCallback(const PageHandler_GetAllGroups_ForwardToCallback&) = delete;
  PageHandler_GetAllGroups_ForwardToCallback& operator=(const PageHandler_GetAllGroups_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::GetAllGroupsCallback callback_;
};

PageHandlerProxy::PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageHandlerProxy::IsEmptyService(
    IsEmptyServiceCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send data_sharing_internals::mojom::PageHandler::IsEmptyService");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kIsEmptyService), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::data_sharing_internals::mojom::internal::PageHandler_IsEmptyService_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("IsEmptyService");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_IsEmptyService_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::GetAllGroups(
    GetAllGroupsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send data_sharing_internals::mojom::PageHandler::GetAllGroups");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetAllGroups), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::data_sharing_internals::mojom::internal::PageHandler_GetAllGroups_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetAllGroups");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_GetAllGroups_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class PageHandler_IsEmptyService_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::IsEmptyServiceCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_IsEmptyService_ProxyToResponder> proxy(
        new PageHandler_IsEmptyService_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_IsEmptyService_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_IsEmptyService_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_IsEmptyService_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::IsEmptyServiceCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_is_empty);
};

bool PageHandler_IsEmptyService_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_IsEmptyService_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_IsEmptyService_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.0
  bool success = true;
  bool p_is_empty{};
  PageHandler_IsEmptyService_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_is_empty = input_data_view.is_empty();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_is_empty));
  }
  return true;
}

void PageHandler_IsEmptyService_ProxyToResponder::Run(
    bool in_is_empty) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply data_sharing_internals::mojom::PageHandler::IsEmptyService", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_empty"), in_is_empty,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kIsEmptyService), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::data_sharing_internals::mojom::internal::PageHandler_IsEmptyService_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->is_empty = in_is_empty;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("IsEmptyService");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_GetAllGroups_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::GetAllGroupsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_GetAllGroups_ProxyToResponder> proxy(
        new PageHandler_GetAllGroups_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_GetAllGroups_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_GetAllGroups_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_GetAllGroups_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::GetAllGroupsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_is_success, std::vector<::data_sharing::mojom::GroupDataPtr> in_data);
};

bool PageHandler_GetAllGroups_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_GetAllGroups_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_GetAllGroups_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.1
  bool success = true;
  bool p_is_success{};
  std::vector<::data_sharing::mojom::GroupDataPtr> p_data{};
  PageHandler_GetAllGroups_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_is_success = input_data_view.is_success();
  if (success && !input_data_view.ReadData(&p_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_is_success), 
std::move(p_data));
  }
  return true;
}

void PageHandler_GetAllGroups_ProxyToResponder::Run(
    bool in_is_success, std::vector<::data_sharing::mojom::GroupDataPtr> in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply data_sharing_internals::mojom::PageHandler::GetAllGroups", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_success"), in_is_success,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type std::vector<::data_sharing::mojom::GroupDataPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetAllGroups), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::data_sharing_internals::mojom::internal::PageHandler_GetAllGroups_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->is_success = in_is_success;
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType>
      data_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::data_sharing::mojom::GroupDataDataView>>(
    in_data,
    data_fragment,
    &data_validate_params);

  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null data in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetAllGroups");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PageHandlerStubDispatch::Accept(
    PageHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PageHandler>(message->header()->name)) {
    case messages::PageHandler::kIsEmptyService: {
      break;
    }
    case messages::PageHandler::kGetAllGroups: {
      break;
    }
  }
  return false;
}

// static
bool PageHandlerStubDispatch::AcceptWithResponder(
    PageHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PageHandler>(message->header()->name)) {
    case messages::PageHandler::kIsEmptyService: {
      internal::PageHandler_IsEmptyService_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_IsEmptyService_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.0
      bool success = true;
      PageHandler_IsEmptyService_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 0, false);
        return false;
      }
      auto callback =
          PageHandler_IsEmptyService_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->IsEmptyService(std::move(callback));
      return true;
    }
    case messages::PageHandler::kGetAllGroups: {
      internal::PageHandler_GetAllGroups_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_GetAllGroups_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.1
      bool success = true;
      PageHandler_GetAllGroups_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 1, false);
        return false;
      }
      auto callback =
          PageHandler_GetAllGroups_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAllGroups(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageHandlerValidationInfo[] = {
    { &internal::PageHandler_IsEmptyService_Params_Data::Validate,
     &internal::PageHandler_IsEmptyService_ResponseParams_Data::Validate},
    { &internal::PageHandler_GetAllGroups_Params_Data::Validate,
     &internal::PageHandler_GetAllGroups_ResponseParams_Data::Validate},
};

bool PageHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::data_sharing_internals::mojom::PageHandler::Name_,
    kPageHandlerValidationInfo);
}

bool PageHandlerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::data_sharing_internals::mojom::PageHandler::Name_,
    kPageHandlerValidationInfo);
}
// The declaration includes the definition on other builds.

Page::IPCStableHashFunction Page::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Page>(message.name())) {
    case messages::Page::kOnLogMessageAdded: {
      return &Page::OnLogMessageAdded_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Page::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Page>(message.name())) {
      case messages::Page::kOnLogMessageAdded:
            return "Receive data_sharing_internals::mojom::Page::OnLogMessageAdded";
    }
  } else {
    switch (static_cast<messages::Page>(message.name())) {
      case messages::Page::kOnLogMessageAdded:
            return "Receive reply data_sharing_internals::mojom::Page::OnLogMessageAdded";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Page::OnLogMessageAdded_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0e0551d7;  // IPCStableHash for data_sharing_internals::mojom::Page::OnLogMessageAdded
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PageProxy::PageProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageProxy::OnLogMessageAdded(
    ::base::Time in_event_time, ::logger_common::mojom::LogSource in_log_source, const std::string& in_source_file, int32_t in_source_line, const std::string& in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send data_sharing_internals::mojom::Page::OnLogMessageAdded", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event_time"), in_event_time,
                        "<value of type ::base::Time>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("log_source"), in_log_source,
                        "<value of type ::logger_common::mojom::LogSource>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_file"), in_source_file,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_line"), in_source_line,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kOnLogMessageAdded), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::data_sharing_internals::mojom::internal::Page_OnLogMessageAdded_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->event_time)::BaseType> event_time_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
    in_event_time,
    event_time_fragment);

  params->event_time.Set(
      event_time_fragment.is_null() ? nullptr : event_time_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->event_time.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null event_time in Page.OnLogMessageAdded request");

  
  mojo::internal::Serialize<::logger_common::mojom::LogSource>(
    in_log_source,
    &params->log_source);
  mojo::internal::MessageFragment<
      typename decltype(params->source_file)::BaseType> source_file_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_source_file,
    source_file_fragment);

  params->source_file.Set(
      source_file_fragment.is_null() ? nullptr : source_file_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->source_file.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null source_file in Page.OnLogMessageAdded request");

  params->source_line = in_source_line;
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_message,
    message_fragment);

  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null message in Page.OnLogMessageAdded request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("OnLogMessageAdded");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PageStubDispatch::Accept(
    Page* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Page>(message->header()->name)) {
    case messages::Page::kOnLogMessageAdded: {
      DCHECK(message->is_serialized());
      internal::Page_OnLogMessageAdded_Params_Data* params =
          reinterpret_cast<internal::Page_OnLogMessageAdded_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.0
      bool success = true;
      ::base::Time p_event_time{};
      ::logger_common::mojom::LogSource p_log_source{};
      std::string p_source_file{};
      int32_t p_source_line{};
      std::string p_message{};
      Page_OnLogMessageAdded_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEventTime(&p_event_time))
        success = false;
      if (success && !input_data_view.ReadLogSource(&p_log_source))
        success = false;
      if (success && !input_data_view.ReadSourceFile(&p_source_file))
        success = false;
      if (success)
        p_source_line = input_data_view.source_line();
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnLogMessageAdded(        
        std::move(p_event_time), 
        std::move(p_log_source), 
        std::move(p_source_file), 
        std::move(p_source_line), 
        std::move(p_message));
      return true;
    }
  }
  return false;
}

// static
bool PageStubDispatch::AcceptWithResponder(
    Page* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Page>(message->header()->name)) {
    case messages::Page::kOnLogMessageAdded: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageValidationInfo[] = {
    { &internal::Page_OnLogMessageAdded_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::data_sharing_internals::mojom::Page::Name_,
    kPageValidationInfo);
}



}  // data_sharing_internals::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace data_sharing_internals::mojom {


void PageHandlerFactoryInterceptorForTesting::CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) {
  GetForwardingInterface()->CreatePageHandler(
    std::move(page)
    , 
    std::move(handler)
    );
}
PageHandlerFactoryAsyncWaiter::PageHandlerFactoryAsyncWaiter(
    PageHandlerFactory* proxy) : proxy_(proxy) {}

PageHandlerFactoryAsyncWaiter::~PageHandlerFactoryAsyncWaiter() = default;





void PageHandlerInterceptorForTesting::IsEmptyService(IsEmptyServiceCallback callback) {
  GetForwardingInterface()->IsEmptyService(std::move(callback));
}
void PageHandlerInterceptorForTesting::GetAllGroups(GetAllGroupsCallback callback) {
  GetForwardingInterface()->GetAllGroups(std::move(callback));
}
PageHandlerAsyncWaiter::PageHandlerAsyncWaiter(
    PageHandler* proxy) : proxy_(proxy) {}

PageHandlerAsyncWaiter::~PageHandlerAsyncWaiter() = default;


void PageHandlerAsyncWaiter::IsEmptyService(
    bool* out_is_empty) {
  base::RunLoop loop;
  proxy_->IsEmptyService(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_is_empty
,
             bool is_empty) {*out_is_empty = std::move(is_empty);
            loop->Quit();
          },
          &loop,
          out_is_empty));
  loop.Run();
}

bool PageHandlerAsyncWaiter::IsEmptyService(
    ) {
  bool async_wait_result;
  IsEmptyService(&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::GetAllGroups(
    bool* out_is_success, std::vector<::data_sharing::mojom::GroupDataPtr>* out_data) {
  base::RunLoop loop;
  proxy_->GetAllGroups(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_is_success
,
             std::vector<::data_sharing::mojom::GroupDataPtr>* out_data
,
             bool is_success,
             std::vector<::data_sharing::mojom::GroupDataPtr> data) {*out_is_success = std::move(is_success);*out_data = std::move(data);
            loop->Quit();
          },
          &loop,
          out_is_success,
          out_data));
  loop.Run();
}






void PageInterceptorForTesting::OnLogMessageAdded(::base::Time event_time, ::logger_common::mojom::LogSource log_source, const std::string& source_file, int32_t source_line, const std::string& message) {
  GetForwardingInterface()->OnLogMessageAdded(
    std::move(event_time)
    , 
    std::move(log_source)
    , 
    std::move(source_file)
    , 
    std::move(source_line)
    , 
    std::move(message)
    );
}
PageAsyncWaiter::PageAsyncWaiter(
    Page* proxy) : proxy_(proxy) {}

PageAsyncWaiter::~PageAsyncWaiter() = default;







}  // data_sharing_internals::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif