// components/content_capture/common/content_capture_data.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_CONTENT_CAPTURE_COMMON_CONTENT_CAPTURE_DATA_MOJOM_H_
#define COMPONENTS_CONTENT_CAPTURE_COMMON_CONTENT_CAPTURE_DATA_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/content_capture/common/content_capture_data.mojom-features.h"  // IWYU pragma: export
#include "components/content_capture/common/content_capture_data.mojom-shared.h"  // IWYU pragma: export
#include "components/content_capture/common/content_capture_data.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/string16.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include <string>
#include <vector>




#include "components/content_capture/common/content_capture_mojom_traits.h"




namespace content_capture::mojom {








class  ContentCaptureData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ContentCaptureData, T>::value>;
  using DataView = ContentCaptureDataDataView;
  using Data_ = internal::ContentCaptureData_Data;

  template <typename... Args>
  static ContentCaptureDataPtr New(Args&&... args) {
    return ContentCaptureDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ContentCaptureDataPtr From(const U& u) {
    return mojo::TypeConverter<ContentCaptureDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ContentCaptureData>::Convert(*this);
  }


  ContentCaptureData();

  ContentCaptureData(
      int64_t id,
      const ::std::u16string& value,
      const ::gfx::Rect& bounds,
      std::vector<::content_capture::ContentCaptureData> children);


  ~ContentCaptureData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ContentCaptureDataPtr>
  ContentCaptureDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ContentCaptureData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ContentCaptureData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ContentCaptureData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ContentCaptureData::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ContentCaptureData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ContentCaptureData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ContentCaptureData_UnserializedMessageContext<
            UserType, ContentCaptureData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ContentCaptureData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ContentCaptureData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ContentCaptureData_UnserializedMessageContext<
            UserType, ContentCaptureData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ContentCaptureData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int64_t id;
  
  ::std::u16string value;
  
  ::gfx::Rect bounds;
  
  std::vector<::content_capture::ContentCaptureData> children;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ContentCaptureData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ContentCaptureData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ContentCaptureData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ContentCaptureData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ContentCaptureDataPtr ContentCaptureData::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(value),
      mojo::Clone(bounds),
      mojo::Clone(children)
  );
}

template <typename T, ContentCaptureData::EnableIfSame<T>*>
bool ContentCaptureData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  if (!mojo::Equals(this->bounds, other_struct.bounds))
    return false;
  if (!mojo::Equals(this->children, other_struct.children))
    return false;
  return true;
}

template <typename T, ContentCaptureData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  if (lhs.bounds < rhs.bounds)
    return true;
  if (rhs.bounds < lhs.bounds)
    return false;
  if (lhs.children < rhs.children)
    return true;
  if (rhs.children < lhs.children)
    return false;
  return false;
}


}  // content_capture::mojom

namespace mojo {


template <>
struct  StructTraits<::content_capture::mojom::ContentCaptureData::DataView,
                                         ::content_capture::mojom::ContentCaptureDataPtr> {
  static bool IsNull(const ::content_capture::mojom::ContentCaptureDataPtr& input) { return !input; }
  static void SetToNull(::content_capture::mojom::ContentCaptureDataPtr* output) { output->reset(); }

  static decltype(::content_capture::mojom::ContentCaptureData::id) id(
      const ::content_capture::mojom::ContentCaptureDataPtr& input) {
    return input->id;
  }

  static const decltype(::content_capture::mojom::ContentCaptureData::value)& value(
      const ::content_capture::mojom::ContentCaptureDataPtr& input) {
    return input->value;
  }

  static const decltype(::content_capture::mojom::ContentCaptureData::bounds)& bounds(
      const ::content_capture::mojom::ContentCaptureDataPtr& input) {
    return input->bounds;
  }

  static const decltype(::content_capture::mojom::ContentCaptureData::children)& children(
      const ::content_capture::mojom::ContentCaptureDataPtr& input) {
    return input->children;
  }

  static bool Read(::content_capture::mojom::ContentCaptureData::DataView input, ::content_capture::mojom::ContentCaptureDataPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_CONTENT_CAPTURE_COMMON_CONTENT_CAPTURE_DATA_MOJOM_H_