// components/content_capture/common/content_capture.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_CONTENT_CAPTURE_COMMON_CONTENT_CAPTURE_MOJOM_H_
#define COMPONENTS_CONTENT_CAPTURE_COMMON_CONTENT_CAPTURE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/content_capture/common/content_capture.mojom-features.h"  // IWYU pragma: export
#include "components/content_capture/common/content_capture.mojom-shared.h"  // IWYU pragma: export
#include "components/content_capture/common/content_capture.mojom-forward.h"  // IWYU pragma: export
#include "components/content_capture/common/content_capture_data.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace content_capture::mojom {

class ContentCaptureReceiverProxy;

template <typename ImplRefTraits>
class ContentCaptureReceiverStub;

class ContentCaptureReceiverRequestValidator;


class ContentCaptureReceiver
    : public ContentCaptureReceiverInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "content_capture.mojom.ContentCaptureReceiver";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ContentCaptureReceiverInterfaceBase;
  using Proxy_ = ContentCaptureReceiverProxy;

  template <typename ImplRefTraits>
  using Stub_ = ContentCaptureReceiverStub<ImplRefTraits>;

  using RequestValidator_ = ContentCaptureReceiverRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kDidCompleteBatchCaptureContentMinVersion = 0,
    kDidCaptureContentMinVersion = 0,
    kDidUpdateContentMinVersion = 0,
    kDidRemoveContentMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct DidCompleteBatchCaptureContent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidCaptureContent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidUpdateContent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidRemoveContent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ContentCaptureReceiver() = default;

  virtual void DidCompleteBatchCaptureContent() = 0;

  virtual void DidCaptureContent(const ::content_capture::ContentCaptureData& data, bool first_data) = 0;

  virtual void DidUpdateContent(const ::content_capture::ContentCaptureData& data) = 0;

  virtual void DidRemoveContent(const std::vector<int64_t>& ids) = 0;
};

class ContentCaptureSenderProxy;

template <typename ImplRefTraits>
class ContentCaptureSenderStub;

class ContentCaptureSenderRequestValidator;


class ContentCaptureSender
    : public ContentCaptureSenderInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "content_capture.mojom.ContentCaptureSender";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ContentCaptureSenderInterfaceBase;
  using Proxy_ = ContentCaptureSenderProxy;

  template <typename ImplRefTraits>
  using Stub_ = ContentCaptureSenderStub<ImplRefTraits>;

  using RequestValidator_ = ContentCaptureSenderRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kStartCaptureMinVersion = 0,
    kStopCaptureMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct StartCapture_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StopCapture_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ContentCaptureSender() = default;

  virtual void StartCapture() = 0;

  virtual void StopCapture() = 0;
};



class  ContentCaptureReceiverProxy
    : public ContentCaptureReceiver {
 public:
  using InterfaceType = ContentCaptureReceiver;

  explicit ContentCaptureReceiverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void DidCompleteBatchCaptureContent() final;
  
  void DidCaptureContent(const ::content_capture::ContentCaptureData& data, bool first_data) final;
  
  void DidUpdateContent(const ::content_capture::ContentCaptureData& data) final;
  
  void DidRemoveContent(const std::vector<int64_t>& ids) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  ContentCaptureSenderProxy
    : public ContentCaptureSender {
 public:
  using InterfaceType = ContentCaptureSender;

  explicit ContentCaptureSenderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void StartCapture() final;
  
  void StopCapture() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  ContentCaptureReceiverStubDispatch {
 public:
  static bool Accept(ContentCaptureReceiver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ContentCaptureReceiver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ContentCaptureReceiver>>
class ContentCaptureReceiverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ContentCaptureReceiverStub() = default;
  ~ContentCaptureReceiverStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ContentCaptureReceiverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ContentCaptureReceiverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ContentCaptureSenderStubDispatch {
 public:
  static bool Accept(ContentCaptureSender* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ContentCaptureSender* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ContentCaptureSender>>
class ContentCaptureSenderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ContentCaptureSenderStub() = default;
  ~ContentCaptureSenderStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ContentCaptureSenderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ContentCaptureSenderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ContentCaptureReceiverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ContentCaptureSenderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // content_capture::mojom

namespace mojo {

}  // namespace mojo

#endif  // COMPONENTS_CONTENT_CAPTURE_COMMON_CONTENT_CAPTURE_MOJOM_H_