// components/commerce/core/mojom/shopping_service.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_COMMERCE_CORE_MOJOM_SHOPPING_SERVICE_MOJOM_H_
#define COMPONENTS_COMMERCE_CORE_MOJOM_SHOPPING_SERVICE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/commerce/core/mojom/shopping_service.mojom-features.h"  // IWYU pragma: export
#include "components/commerce/core/mojom/shopping_service.mojom-shared.h"  // IWYU pragma: export
#include "components/commerce/core/mojom/shopping_service.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/string16.mojom-forward.h"
#include "mojo/public/mojom/base/uuid.mojom.h"
#include "url/mojom/url.mojom.h"
#include "mojo/public/mojom/base/values.mojom-forward.h"
#include "components/commerce/core/mojom/shared.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace shopping_service::mojom {

class ShoppingServiceHandlerFactoryProxy;

template <typename ImplRefTraits>
class ShoppingServiceHandlerFactoryStub;

class ShoppingServiceHandlerFactoryRequestValidator;


class ShoppingServiceHandlerFactory
    : public ShoppingServiceHandlerFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "shopping_service.mojom.ShoppingServiceHandlerFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ShoppingServiceHandlerFactoryInterfaceBase;
  using Proxy_ = ShoppingServiceHandlerFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = ShoppingServiceHandlerFactoryStub<ImplRefTraits>;

  using RequestValidator_ = ShoppingServiceHandlerFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreateShoppingServiceHandlerMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateShoppingServiceHandler_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ShoppingServiceHandlerFactory() = default;

  virtual void CreateShoppingServiceHandler(::mojo::PendingReceiver<ShoppingServiceHandler> handler) = 0;
};

class ShoppingServiceHandlerProxy;

template <typename ImplRefTraits>
class ShoppingServiceHandlerStub;

class ShoppingServiceHandlerRequestValidator;
class ShoppingServiceHandlerResponseValidator;


class ShoppingServiceHandler
    : public ShoppingServiceHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "shopping_service.mojom.ShoppingServiceHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ShoppingServiceHandlerInterfaceBase;
  using Proxy_ = ShoppingServiceHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = ShoppingServiceHandlerStub<ImplRefTraits>;

  using RequestValidator_ = ShoppingServiceHandlerRequestValidator;
  using ResponseValidator_ = ShoppingServiceHandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetProductInfoForCurrentUrlMinVersion = 0,
    kGetProductInfoForUrlMinVersion = 0,
    kGetProductInfoForUrlsMinVersion = 0,
    kGetPriceInsightsInfoForCurrentUrlMinVersion = 0,
    kGetPriceInsightsInfoForUrlMinVersion = 0,
    kGetProductSpecificationsForUrlsMinVersion = 0,
    kGetUrlInfosForProductTabsMinVersion = 0,
    kGetUrlInfosForRecentlyViewedTabsMinVersion = 0,
    kIsShoppingListEligibleMinVersion = 0,
    kGetPriceTrackingStatusForCurrentUrlMinVersion = 0,
    kOpenUrlInNewTabMinVersion = 0,
    kSwitchToOrOpenTabMinVersion = 0,
    kGetAllProductSpecificationsSetsMinVersion = 0,
    kGetProductSpecificationsSetByUuidMinVersion = 0,
    kAddProductSpecificationsSetMinVersion = 0,
    kDeleteProductSpecificationsSetMinVersion = 0,
    kSetNameForProductSpecificationsSetMinVersion = 0,
    kSetUrlsForProductSpecificationsSetMinVersion = 0,
    kSetProductSpecificationsUserFeedbackMinVersion = 0,
    kGetProductSpecificationsFeatureStateMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetProductInfoForCurrentUrl_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetProductInfoForUrl_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetProductInfoForUrls_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetPriceInsightsInfoForCurrentUrl_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetPriceInsightsInfoForUrl_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetProductSpecificationsForUrls_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetUrlInfosForProductTabs_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetUrlInfosForRecentlyViewedTabs_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct IsShoppingListEligible_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetPriceTrackingStatusForCurrentUrl_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenUrlInNewTab_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SwitchToOrOpenTab_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetAllProductSpecificationsSets_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetProductSpecificationsSetByUuid_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AddProductSpecificationsSet_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DeleteProductSpecificationsSet_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetNameForProductSpecificationsSet_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetUrlsForProductSpecificationsSet_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetProductSpecificationsUserFeedback_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetProductSpecificationsFeatureState_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ShoppingServiceHandler() = default;

  using GetProductInfoForCurrentUrlCallback = base::OnceCallback<void(::commerce::shared::mojom::ProductInfoPtr)>;
  using GetProductInfoForCurrentUrlMojoCallback = base::OnceCallback<void(::commerce::shared::mojom::ProductInfoPtr)>;

  virtual void GetProductInfoForCurrentUrl(GetProductInfoForCurrentUrlCallback callback) = 0;

  using GetProductInfoForUrlCallback = base::OnceCallback<void(const ::GURL&, ::commerce::shared::mojom::ProductInfoPtr)>;
  using GetProductInfoForUrlMojoCallback = base::OnceCallback<void(const ::GURL&, ::commerce::shared::mojom::ProductInfoPtr)>;

  virtual void GetProductInfoForUrl(const ::GURL& url, GetProductInfoForUrlCallback callback) = 0;

  using GetProductInfoForUrlsCallback = base::OnceCallback<void(std::vector<::commerce::shared::mojom::ProductInfoPtr>)>;
  using GetProductInfoForUrlsMojoCallback = base::OnceCallback<void(std::vector<::commerce::shared::mojom::ProductInfoPtr>)>;

  virtual void GetProductInfoForUrls(const std::vector<::GURL>& urls, GetProductInfoForUrlsCallback callback) = 0;

  using GetPriceInsightsInfoForCurrentUrlCallback = base::OnceCallback<void(PriceInsightsInfoPtr)>;
  using GetPriceInsightsInfoForCurrentUrlMojoCallback = base::OnceCallback<void(PriceInsightsInfoPtr)>;

  virtual void GetPriceInsightsInfoForCurrentUrl(GetPriceInsightsInfoForCurrentUrlCallback callback) = 0;

  using GetPriceInsightsInfoForUrlCallback = base::OnceCallback<void(const ::GURL&, PriceInsightsInfoPtr)>;
  using GetPriceInsightsInfoForUrlMojoCallback = base::OnceCallback<void(const ::GURL&, PriceInsightsInfoPtr)>;

  virtual void GetPriceInsightsInfoForUrl(const ::GURL& url, GetPriceInsightsInfoForUrlCallback callback) = 0;

  using GetProductSpecificationsForUrlsCallback = base::OnceCallback<void(ProductSpecificationsPtr)>;
  using GetProductSpecificationsForUrlsMojoCallback = base::OnceCallback<void(ProductSpecificationsPtr)>;

  virtual void GetProductSpecificationsForUrls(const std::vector<::GURL>& urls, GetProductSpecificationsForUrlsCallback callback) = 0;

  using GetUrlInfosForProductTabsCallback = base::OnceCallback<void(std::vector<UrlInfoPtr>)>;
  using GetUrlInfosForProductTabsMojoCallback = base::OnceCallback<void(std::vector<UrlInfoPtr>)>;

  virtual void GetUrlInfosForProductTabs(GetUrlInfosForProductTabsCallback callback) = 0;

  using GetUrlInfosForRecentlyViewedTabsCallback = base::OnceCallback<void(std::vector<UrlInfoPtr>)>;
  using GetUrlInfosForRecentlyViewedTabsMojoCallback = base::OnceCallback<void(std::vector<UrlInfoPtr>)>;

  virtual void GetUrlInfosForRecentlyViewedTabs(GetUrlInfosForRecentlyViewedTabsCallback callback) = 0;

  using IsShoppingListEligibleCallback = base::OnceCallback<void(bool)>;
  using IsShoppingListEligibleMojoCallback = base::OnceCallback<void(bool)>;

  virtual void IsShoppingListEligible(IsShoppingListEligibleCallback callback) = 0;

  using GetPriceTrackingStatusForCurrentUrlCallback = base::OnceCallback<void(bool)>;
  using GetPriceTrackingStatusForCurrentUrlMojoCallback = base::OnceCallback<void(bool)>;

  virtual void GetPriceTrackingStatusForCurrentUrl(GetPriceTrackingStatusForCurrentUrlCallback callback) = 0;

  virtual void OpenUrlInNewTab(const ::GURL& url) = 0;

  virtual void SwitchToOrOpenTab(const ::GURL& url) = 0;

  using GetAllProductSpecificationsSetsCallback = base::OnceCallback<void(std::vector<::commerce::shared::mojom::ProductSpecificationsSetPtr>)>;
  using GetAllProductSpecificationsSetsMojoCallback = base::OnceCallback<void(std::vector<::commerce::shared::mojom::ProductSpecificationsSetPtr>)>;

  virtual void GetAllProductSpecificationsSets(GetAllProductSpecificationsSetsCallback callback) = 0;

  using GetProductSpecificationsSetByUuidCallback = base::OnceCallback<void(::commerce::shared::mojom::ProductSpecificationsSetPtr)>;
  using GetProductSpecificationsSetByUuidMojoCallback = base::OnceCallback<void(::commerce::shared::mojom::ProductSpecificationsSetPtr)>;

  virtual void GetProductSpecificationsSetByUuid(const ::base::Uuid& uuid, GetProductSpecificationsSetByUuidCallback callback) = 0;

  using AddProductSpecificationsSetCallback = base::OnceCallback<void(::commerce::shared::mojom::ProductSpecificationsSetPtr)>;
  using AddProductSpecificationsSetMojoCallback = base::OnceCallback<void(::commerce::shared::mojom::ProductSpecificationsSetPtr)>;

  virtual void AddProductSpecificationsSet(const std::string& name, const std::vector<::GURL>& urls, AddProductSpecificationsSetCallback callback) = 0;

  virtual void DeleteProductSpecificationsSet(const ::base::Uuid& uuid) = 0;

  using SetNameForProductSpecificationsSetCallback = base::OnceCallback<void(::commerce::shared::mojom::ProductSpecificationsSetPtr)>;
  using SetNameForProductSpecificationsSetMojoCallback = base::OnceCallback<void(::commerce::shared::mojom::ProductSpecificationsSetPtr)>;

  virtual void SetNameForProductSpecificationsSet(const ::base::Uuid& uuid, const std::string& name, SetNameForProductSpecificationsSetCallback callback) = 0;

  using SetUrlsForProductSpecificationsSetCallback = base::OnceCallback<void(::commerce::shared::mojom::ProductSpecificationsSetPtr)>;
  using SetUrlsForProductSpecificationsSetMojoCallback = base::OnceCallback<void(::commerce::shared::mojom::ProductSpecificationsSetPtr)>;

  virtual void SetUrlsForProductSpecificationsSet(const ::base::Uuid& uuid, const std::vector<::GURL>& urls, SetUrlsForProductSpecificationsSetCallback callback) = 0;

  virtual void SetProductSpecificationsUserFeedback(UserFeedback feedback) = 0;

  using GetProductSpecificationsFeatureStateCallback = base::OnceCallback<void(ProductSpecificationsFeatureStatePtr)>;
  using GetProductSpecificationsFeatureStateMojoCallback = base::OnceCallback<void(ProductSpecificationsFeatureStatePtr)>;

  virtual void GetProductSpecificationsFeatureState(GetProductSpecificationsFeatureStateCallback callback) = 0;
};



class  ShoppingServiceHandlerFactoryProxy
    : public ShoppingServiceHandlerFactory {
 public:
  using InterfaceType = ShoppingServiceHandlerFactory;

  explicit ShoppingServiceHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateShoppingServiceHandler(::mojo::PendingReceiver<ShoppingServiceHandler> handler) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  ShoppingServiceHandlerProxy
    : public ShoppingServiceHandler {
 public:
  using InterfaceType = ShoppingServiceHandler;

  explicit ShoppingServiceHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetProductInfoForCurrentUrl(GetProductInfoForCurrentUrlCallback callback) final;
  
  void GetProductInfoForUrl(const ::GURL& url, GetProductInfoForUrlCallback callback) final;
  
  void GetProductInfoForUrls(const std::vector<::GURL>& urls, GetProductInfoForUrlsCallback callback) final;
  
  void GetPriceInsightsInfoForCurrentUrl(GetPriceInsightsInfoForCurrentUrlCallback callback) final;
  
  void GetPriceInsightsInfoForUrl(const ::GURL& url, GetPriceInsightsInfoForUrlCallback callback) final;
  
  void GetProductSpecificationsForUrls(const std::vector<::GURL>& urls, GetProductSpecificationsForUrlsCallback callback) final;
  
  void GetUrlInfosForProductTabs(GetUrlInfosForProductTabsCallback callback) final;
  
  void GetUrlInfosForRecentlyViewedTabs(GetUrlInfosForRecentlyViewedTabsCallback callback) final;
  
  void IsShoppingListEligible(IsShoppingListEligibleCallback callback) final;
  
  void GetPriceTrackingStatusForCurrentUrl(GetPriceTrackingStatusForCurrentUrlCallback callback) final;
  
  void OpenUrlInNewTab(const ::GURL& url) final;
  
  void SwitchToOrOpenTab(const ::GURL& url) final;
  
  void GetAllProductSpecificationsSets(GetAllProductSpecificationsSetsCallback callback) final;
  
  void GetProductSpecificationsSetByUuid(const ::base::Uuid& uuid, GetProductSpecificationsSetByUuidCallback callback) final;
  
  void AddProductSpecificationsSet(const std::string& name, const std::vector<::GURL>& urls, AddProductSpecificationsSetCallback callback) final;
  
  void DeleteProductSpecificationsSet(const ::base::Uuid& uuid) final;
  
  void SetNameForProductSpecificationsSet(const ::base::Uuid& uuid, const std::string& name, SetNameForProductSpecificationsSetCallback callback) final;
  
  void SetUrlsForProductSpecificationsSet(const ::base::Uuid& uuid, const std::vector<::GURL>& urls, SetUrlsForProductSpecificationsSetCallback callback) final;
  
  void SetProductSpecificationsUserFeedback(UserFeedback feedback) final;
  
  void GetProductSpecificationsFeatureState(GetProductSpecificationsFeatureStateCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  ShoppingServiceHandlerFactoryStubDispatch {
 public:
  static bool Accept(ShoppingServiceHandlerFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ShoppingServiceHandlerFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ShoppingServiceHandlerFactory>>
class ShoppingServiceHandlerFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ShoppingServiceHandlerFactoryStub() = default;
  ~ShoppingServiceHandlerFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ShoppingServiceHandlerFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ShoppingServiceHandlerFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ShoppingServiceHandlerStubDispatch {
 public:
  static bool Accept(ShoppingServiceHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ShoppingServiceHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ShoppingServiceHandler>>
class ShoppingServiceHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ShoppingServiceHandlerStub() = default;
  ~ShoppingServiceHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ShoppingServiceHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ShoppingServiceHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ShoppingServiceHandlerFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ShoppingServiceHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ShoppingServiceHandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class  PricePoint {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PricePoint, T>::value>;
  using DataView = PricePointDataView;
  using Data_ = internal::PricePoint_Data;

  template <typename... Args>
  static PricePointPtr New(Args&&... args) {
    return PricePointPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PricePointPtr From(const U& u) {
    return mojo::TypeConverter<PricePointPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PricePoint>::Convert(*this);
  }


  PricePoint();

  PricePoint(
      const std::string& date,
      float price,
      const std::string& formatted_price);


  ~PricePoint();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PricePointPtr>
  PricePointPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PricePoint::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PricePoint::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PricePoint::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PricePoint::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PricePoint::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PricePoint::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PricePoint_UnserializedMessageContext<
            UserType, PricePoint::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PricePoint::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PricePoint::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PricePoint_UnserializedMessageContext<
            UserType, PricePoint::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PricePoint::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string date;
  
  float price;
  
  std::string formatted_price;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PricePoint::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PricePoint::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PricePoint::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PricePoint::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

















class  UrlInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<UrlInfo, T>::value>;
  using DataView = UrlInfoDataView;
  using Data_ = internal::UrlInfo_Data;

  template <typename... Args>
  static UrlInfoPtr New(Args&&... args) {
    return UrlInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static UrlInfoPtr From(const U& u) {
    return mojo::TypeConverter<UrlInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, UrlInfo>::Convert(*this);
  }


  UrlInfo();

  UrlInfo(
      const std::string& title,
      const ::GURL& url,
      const ::GURL& favicon_url,
      const ::GURL& thumbnail_url,
      const std::string& previewText);


  ~UrlInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = UrlInfoPtr>
  UrlInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, UrlInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, UrlInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, UrlInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UrlInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UrlInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        UrlInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::UrlInfo_UnserializedMessageContext<
            UserType, UrlInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<UrlInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return UrlInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::UrlInfo_UnserializedMessageContext<
            UserType, UrlInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<UrlInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string title;
  
  ::GURL url;
  
  ::GURL favicon_url;
  
  ::GURL thumbnail_url;
  
  std::string previewText;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, UrlInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, UrlInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, UrlInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, UrlInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  PriceInsightsInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PriceInsightsInfo, T>::value>;
  using DataView = PriceInsightsInfoDataView;
  using Data_ = internal::PriceInsightsInfo_Data;
  using PriceBucket = PriceInsightsInfo_PriceBucket;

  template <typename... Args>
  static PriceInsightsInfoPtr New(Args&&... args) {
    return PriceInsightsInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PriceInsightsInfoPtr From(const U& u) {
    return mojo::TypeConverter<PriceInsightsInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PriceInsightsInfo>::Convert(*this);
  }


  PriceInsightsInfo();

  PriceInsightsInfo(
      uint64_t cluster_id,
      const std::string& typical_low_price,
      const std::string& typical_high_price,
      const std::string& catalog_attributes,
      const ::GURL& jackpot,
      PriceInsightsInfo::PriceBucket bucket,
      bool has_multiple_catalogs,
      std::vector<PricePointPtr> history,
      const std::string& locale,
      const std::string& currency_code);

PriceInsightsInfo(const PriceInsightsInfo&) = delete;
PriceInsightsInfo& operator=(const PriceInsightsInfo&) = delete;

  ~PriceInsightsInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PriceInsightsInfoPtr>
  PriceInsightsInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PriceInsightsInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PriceInsightsInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PriceInsightsInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PriceInsightsInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PriceInsightsInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PriceInsightsInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PriceInsightsInfo_UnserializedMessageContext<
            UserType, PriceInsightsInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PriceInsightsInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PriceInsightsInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PriceInsightsInfo_UnserializedMessageContext<
            UserType, PriceInsightsInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PriceInsightsInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint64_t cluster_id;
  
  std::string typical_low_price;
  
  std::string typical_high_price;
  
  std::string catalog_attributes;
  
  ::GURL jackpot;
  
  PriceInsightsInfo::PriceBucket bucket;
  
  bool has_multiple_catalogs;
  
  std::vector<PricePointPtr> history;
  
  std::string locale;
  
  std::string currency_code;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PriceInsightsInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PriceInsightsInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PriceInsightsInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PriceInsightsInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ProductSpecificationsDescriptionText {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ProductSpecificationsDescriptionText, T>::value>;
  using DataView = ProductSpecificationsDescriptionTextDataView;
  using Data_ = internal::ProductSpecificationsDescriptionText_Data;

  template <typename... Args>
  static ProductSpecificationsDescriptionTextPtr New(Args&&... args) {
    return ProductSpecificationsDescriptionTextPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ProductSpecificationsDescriptionTextPtr From(const U& u) {
    return mojo::TypeConverter<ProductSpecificationsDescriptionTextPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ProductSpecificationsDescriptionText>::Convert(*this);
  }


  ProductSpecificationsDescriptionText();

  ProductSpecificationsDescriptionText(
      const std::string& text,
      std::vector<UrlInfoPtr> urls);

ProductSpecificationsDescriptionText(const ProductSpecificationsDescriptionText&) = delete;
ProductSpecificationsDescriptionText& operator=(const ProductSpecificationsDescriptionText&) = delete;

  ~ProductSpecificationsDescriptionText();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ProductSpecificationsDescriptionTextPtr>
  ProductSpecificationsDescriptionTextPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ProductSpecificationsDescriptionText::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ProductSpecificationsDescriptionText::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ProductSpecificationsDescriptionText::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ProductSpecificationsDescriptionText::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ProductSpecificationsDescriptionText::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ProductSpecificationsDescriptionText::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ProductSpecificationsDescriptionText_UnserializedMessageContext<
            UserType, ProductSpecificationsDescriptionText::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ProductSpecificationsDescriptionText::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ProductSpecificationsDescriptionText::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ProductSpecificationsDescriptionText_UnserializedMessageContext<
            UserType, ProductSpecificationsDescriptionText::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ProductSpecificationsDescriptionText::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string text;
  
  std::vector<UrlInfoPtr> urls;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ProductSpecificationsDescriptionText::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ProductSpecificationsDescriptionText::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ProductSpecificationsDescriptionText::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ProductSpecificationsDescriptionText::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ProductSpecificationsOption {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ProductSpecificationsOption, T>::value>;
  using DataView = ProductSpecificationsOptionDataView;
  using Data_ = internal::ProductSpecificationsOption_Data;

  template <typename... Args>
  static ProductSpecificationsOptionPtr New(Args&&... args) {
    return ProductSpecificationsOptionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ProductSpecificationsOptionPtr From(const U& u) {
    return mojo::TypeConverter<ProductSpecificationsOptionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ProductSpecificationsOption>::Convert(*this);
  }


  ProductSpecificationsOption();

  explicit ProductSpecificationsOption(
      std::vector<ProductSpecificationsDescriptionTextPtr> descriptions);

ProductSpecificationsOption(const ProductSpecificationsOption&) = delete;
ProductSpecificationsOption& operator=(const ProductSpecificationsOption&) = delete;

  ~ProductSpecificationsOption();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ProductSpecificationsOptionPtr>
  ProductSpecificationsOptionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ProductSpecificationsOption::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ProductSpecificationsOption::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ProductSpecificationsOption::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ProductSpecificationsOption::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ProductSpecificationsOption::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ProductSpecificationsOption::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ProductSpecificationsOption_UnserializedMessageContext<
            UserType, ProductSpecificationsOption::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ProductSpecificationsOption::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ProductSpecificationsOption::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ProductSpecificationsOption_UnserializedMessageContext<
            UserType, ProductSpecificationsOption::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ProductSpecificationsOption::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<ProductSpecificationsDescriptionTextPtr> descriptions;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ProductSpecificationsOption::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ProductSpecificationsOption::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ProductSpecificationsOption::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ProductSpecificationsOption::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ProductSpecificationsDescription {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ProductSpecificationsDescription, T>::value>;
  using DataView = ProductSpecificationsDescriptionDataView;
  using Data_ = internal::ProductSpecificationsDescription_Data;

  template <typename... Args>
  static ProductSpecificationsDescriptionPtr New(Args&&... args) {
    return ProductSpecificationsDescriptionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ProductSpecificationsDescriptionPtr From(const U& u) {
    return mojo::TypeConverter<ProductSpecificationsDescriptionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ProductSpecificationsDescription>::Convert(*this);
  }


  ProductSpecificationsDescription();

  ProductSpecificationsDescription(
      std::vector<ProductSpecificationsOptionPtr> options,
      const std::string& label,
      const std::string& alt_text);

ProductSpecificationsDescription(const ProductSpecificationsDescription&) = delete;
ProductSpecificationsDescription& operator=(const ProductSpecificationsDescription&) = delete;

  ~ProductSpecificationsDescription();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ProductSpecificationsDescriptionPtr>
  ProductSpecificationsDescriptionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ProductSpecificationsDescription::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ProductSpecificationsDescription::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ProductSpecificationsDescription::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ProductSpecificationsDescription::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ProductSpecificationsDescription::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ProductSpecificationsDescription::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ProductSpecificationsDescription_UnserializedMessageContext<
            UserType, ProductSpecificationsDescription::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ProductSpecificationsDescription::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ProductSpecificationsDescription::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ProductSpecificationsDescription_UnserializedMessageContext<
            UserType, ProductSpecificationsDescription::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ProductSpecificationsDescription::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<ProductSpecificationsOptionPtr> options;
  
  std::string label;
  
  std::string alt_text;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ProductSpecificationsDescription::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ProductSpecificationsDescription::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ProductSpecificationsDescription::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ProductSpecificationsDescription::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ProductSpecificationsValue {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ProductSpecificationsValue, T>::value>;
  using DataView = ProductSpecificationsValueDataView;
  using Data_ = internal::ProductSpecificationsValue_Data;

  template <typename... Args>
  static ProductSpecificationsValuePtr New(Args&&... args) {
    return ProductSpecificationsValuePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ProductSpecificationsValuePtr From(const U& u) {
    return mojo::TypeConverter<ProductSpecificationsValuePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ProductSpecificationsValue>::Convert(*this);
  }


  ProductSpecificationsValue();

  ProductSpecificationsValue(
      std::vector<ProductSpecificationsDescriptionPtr> specification_descriptions,
      std::vector<ProductSpecificationsDescriptionTextPtr> summary);

ProductSpecificationsValue(const ProductSpecificationsValue&) = delete;
ProductSpecificationsValue& operator=(const ProductSpecificationsValue&) = delete;

  ~ProductSpecificationsValue();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ProductSpecificationsValuePtr>
  ProductSpecificationsValuePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ProductSpecificationsValue::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ProductSpecificationsValue::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ProductSpecificationsValue::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ProductSpecificationsValue::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ProductSpecificationsValue::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ProductSpecificationsValue::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ProductSpecificationsValue_UnserializedMessageContext<
            UserType, ProductSpecificationsValue::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ProductSpecificationsValue::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ProductSpecificationsValue::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ProductSpecificationsValue_UnserializedMessageContext<
            UserType, ProductSpecificationsValue::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ProductSpecificationsValue::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<ProductSpecificationsDescriptionPtr> specification_descriptions;
  
  std::vector<ProductSpecificationsDescriptionTextPtr> summary;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ProductSpecificationsValue::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ProductSpecificationsValue::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ProductSpecificationsValue::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ProductSpecificationsValue::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ProductSpecificationsProduct {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ProductSpecificationsProduct, T>::value>;
  using DataView = ProductSpecificationsProductDataView;
  using Data_ = internal::ProductSpecificationsProduct_Data;

  template <typename... Args>
  static ProductSpecificationsProductPtr New(Args&&... args) {
    return ProductSpecificationsProductPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ProductSpecificationsProductPtr From(const U& u) {
    return mojo::TypeConverter<ProductSpecificationsProductPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ProductSpecificationsProduct>::Convert(*this);
  }


  ProductSpecificationsProduct();

  ProductSpecificationsProduct(
      uint64_t product_cluster_id,
      const std::string& title,
      const ::GURL& image_url,
      base::flat_map<uint64_t, ProductSpecificationsValuePtr> product_dimension_values,
      std::vector<ProductSpecificationsDescriptionTextPtr> summary,
      const ::GURL& buying_options_url);

ProductSpecificationsProduct(const ProductSpecificationsProduct&) = delete;
ProductSpecificationsProduct& operator=(const ProductSpecificationsProduct&) = delete;

  ~ProductSpecificationsProduct();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ProductSpecificationsProductPtr>
  ProductSpecificationsProductPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ProductSpecificationsProduct::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ProductSpecificationsProduct::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ProductSpecificationsProduct::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ProductSpecificationsProduct::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ProductSpecificationsProduct::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ProductSpecificationsProduct::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ProductSpecificationsProduct_UnserializedMessageContext<
            UserType, ProductSpecificationsProduct::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ProductSpecificationsProduct::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ProductSpecificationsProduct::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ProductSpecificationsProduct_UnserializedMessageContext<
            UserType, ProductSpecificationsProduct::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ProductSpecificationsProduct::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint64_t product_cluster_id;
  
  std::string title;
  
  ::GURL image_url;
  
  base::flat_map<uint64_t, ProductSpecificationsValuePtr> product_dimension_values;
  
  std::vector<ProductSpecificationsDescriptionTextPtr> summary;
  
  ::GURL buying_options_url;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ProductSpecificationsProduct::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ProductSpecificationsProduct::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ProductSpecificationsProduct::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ProductSpecificationsProduct::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ProductSpecificationsFeatureState {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ProductSpecificationsFeatureState, T>::value>;
  using DataView = ProductSpecificationsFeatureStateDataView;
  using Data_ = internal::ProductSpecificationsFeatureState_Data;

  template <typename... Args>
  static ProductSpecificationsFeatureStatePtr New(Args&&... args) {
    return ProductSpecificationsFeatureStatePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ProductSpecificationsFeatureStatePtr From(const U& u) {
    return mojo::TypeConverter<ProductSpecificationsFeatureStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ProductSpecificationsFeatureState>::Convert(*this);
  }


  ProductSpecificationsFeatureState();

  ProductSpecificationsFeatureState(
      bool is_syncing_tab_compare,
      bool can_load_full_page_ui,
      bool can_manage_sets,
      bool can_fetch_data,
      bool is_allowed_for_enterprise,
      bool is_quality_logging_allowed,
      bool is_signed_in);


  ~ProductSpecificationsFeatureState();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ProductSpecificationsFeatureStatePtr>
  ProductSpecificationsFeatureStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ProductSpecificationsFeatureState::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ProductSpecificationsFeatureState::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ProductSpecificationsFeatureState::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ProductSpecificationsFeatureState::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ProductSpecificationsFeatureState::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ProductSpecificationsFeatureState::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ProductSpecificationsFeatureState_UnserializedMessageContext<
            UserType, ProductSpecificationsFeatureState::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ProductSpecificationsFeatureState::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ProductSpecificationsFeatureState::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ProductSpecificationsFeatureState_UnserializedMessageContext<
            UserType, ProductSpecificationsFeatureState::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ProductSpecificationsFeatureState::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool is_syncing_tab_compare;
  
  bool can_load_full_page_ui;
  
  bool can_manage_sets;
  
  bool can_fetch_data;
  
  bool is_allowed_for_enterprise;
  
  bool is_quality_logging_allowed;
  
  bool is_signed_in;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ProductSpecificationsFeatureState::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ProductSpecificationsFeatureState::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ProductSpecificationsFeatureState::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ProductSpecificationsFeatureState::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ProductSpecifications {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ProductSpecifications, T>::value>;
  using DataView = ProductSpecificationsDataView;
  using Data_ = internal::ProductSpecifications_Data;

  template <typename... Args>
  static ProductSpecificationsPtr New(Args&&... args) {
    return ProductSpecificationsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ProductSpecificationsPtr From(const U& u) {
    return mojo::TypeConverter<ProductSpecificationsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ProductSpecifications>::Convert(*this);
  }


  ProductSpecifications();

  ProductSpecifications(
      const base::flat_map<uint64_t, std::string>& product_dimension_map,
      std::vector<ProductSpecificationsProductPtr> products);

ProductSpecifications(const ProductSpecifications&) = delete;
ProductSpecifications& operator=(const ProductSpecifications&) = delete;

  ~ProductSpecifications();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ProductSpecificationsPtr>
  ProductSpecificationsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ProductSpecifications::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ProductSpecifications::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ProductSpecifications::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ProductSpecifications::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ProductSpecifications::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ProductSpecifications::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ProductSpecifications_UnserializedMessageContext<
            UserType, ProductSpecifications::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ProductSpecifications::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ProductSpecifications::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ProductSpecifications_UnserializedMessageContext<
            UserType, ProductSpecifications::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ProductSpecifications::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  base::flat_map<uint64_t, std::string> product_dimension_map;
  
  std::vector<ProductSpecificationsProductPtr> products;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ProductSpecifications::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ProductSpecifications::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ProductSpecifications::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ProductSpecifications::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
PricePointPtr PricePoint::Clone() const {
  return New(
      mojo::Clone(date),
      mojo::Clone(price),
      mojo::Clone(formatted_price)
  );
}

template <typename T, PricePoint::EnableIfSame<T>*>
bool PricePoint::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->date, other_struct.date))
    return false;
  if (!mojo::Equals(this->price, other_struct.price))
    return false;
  if (!mojo::Equals(this->formatted_price, other_struct.formatted_price))
    return false;
  return true;
}

template <typename T, PricePoint::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.date < rhs.date)
    return true;
  if (rhs.date < lhs.date)
    return false;
  if (lhs.price < rhs.price)
    return true;
  if (rhs.price < lhs.price)
    return false;
  if (lhs.formatted_price < rhs.formatted_price)
    return true;
  if (rhs.formatted_price < lhs.formatted_price)
    return false;
  return false;
}
template <typename StructPtrType>
UrlInfoPtr UrlInfo::Clone() const {
  return New(
      mojo::Clone(title),
      mojo::Clone(url),
      mojo::Clone(favicon_url),
      mojo::Clone(thumbnail_url),
      mojo::Clone(previewText)
  );
}

template <typename T, UrlInfo::EnableIfSame<T>*>
bool UrlInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->favicon_url, other_struct.favicon_url))
    return false;
  if (!mojo::Equals(this->thumbnail_url, other_struct.thumbnail_url))
    return false;
  if (!mojo::Equals(this->previewText, other_struct.previewText))
    return false;
  return true;
}

template <typename T, UrlInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.favicon_url < rhs.favicon_url)
    return true;
  if (rhs.favicon_url < lhs.favicon_url)
    return false;
  if (lhs.thumbnail_url < rhs.thumbnail_url)
    return true;
  if (rhs.thumbnail_url < lhs.thumbnail_url)
    return false;
  if (lhs.previewText < rhs.previewText)
    return true;
  if (rhs.previewText < lhs.previewText)
    return false;
  return false;
}
template <typename StructPtrType>
PriceInsightsInfoPtr PriceInsightsInfo::Clone() const {
  return New(
      mojo::Clone(cluster_id),
      mojo::Clone(typical_low_price),
      mojo::Clone(typical_high_price),
      mojo::Clone(catalog_attributes),
      mojo::Clone(jackpot),
      mojo::Clone(bucket),
      mojo::Clone(has_multiple_catalogs),
      mojo::Clone(history),
      mojo::Clone(locale),
      mojo::Clone(currency_code)
  );
}

template <typename T, PriceInsightsInfo::EnableIfSame<T>*>
bool PriceInsightsInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->cluster_id, other_struct.cluster_id))
    return false;
  if (!mojo::Equals(this->typical_low_price, other_struct.typical_low_price))
    return false;
  if (!mojo::Equals(this->typical_high_price, other_struct.typical_high_price))
    return false;
  if (!mojo::Equals(this->catalog_attributes, other_struct.catalog_attributes))
    return false;
  if (!mojo::Equals(this->jackpot, other_struct.jackpot))
    return false;
  if (!mojo::Equals(this->bucket, other_struct.bucket))
    return false;
  if (!mojo::Equals(this->has_multiple_catalogs, other_struct.has_multiple_catalogs))
    return false;
  if (!mojo::Equals(this->history, other_struct.history))
    return false;
  if (!mojo::Equals(this->locale, other_struct.locale))
    return false;
  if (!mojo::Equals(this->currency_code, other_struct.currency_code))
    return false;
  return true;
}

template <typename T, PriceInsightsInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.cluster_id < rhs.cluster_id)
    return true;
  if (rhs.cluster_id < lhs.cluster_id)
    return false;
  if (lhs.typical_low_price < rhs.typical_low_price)
    return true;
  if (rhs.typical_low_price < lhs.typical_low_price)
    return false;
  if (lhs.typical_high_price < rhs.typical_high_price)
    return true;
  if (rhs.typical_high_price < lhs.typical_high_price)
    return false;
  if (lhs.catalog_attributes < rhs.catalog_attributes)
    return true;
  if (rhs.catalog_attributes < lhs.catalog_attributes)
    return false;
  if (lhs.jackpot < rhs.jackpot)
    return true;
  if (rhs.jackpot < lhs.jackpot)
    return false;
  if (lhs.bucket < rhs.bucket)
    return true;
  if (rhs.bucket < lhs.bucket)
    return false;
  if (lhs.has_multiple_catalogs < rhs.has_multiple_catalogs)
    return true;
  if (rhs.has_multiple_catalogs < lhs.has_multiple_catalogs)
    return false;
  if (lhs.history < rhs.history)
    return true;
  if (rhs.history < lhs.history)
    return false;
  if (lhs.locale < rhs.locale)
    return true;
  if (rhs.locale < lhs.locale)
    return false;
  if (lhs.currency_code < rhs.currency_code)
    return true;
  if (rhs.currency_code < lhs.currency_code)
    return false;
  return false;
}
template <typename StructPtrType>
ProductSpecificationsDescriptionTextPtr ProductSpecificationsDescriptionText::Clone() const {
  return New(
      mojo::Clone(text),
      mojo::Clone(urls)
  );
}

template <typename T, ProductSpecificationsDescriptionText::EnableIfSame<T>*>
bool ProductSpecificationsDescriptionText::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->text, other_struct.text))
    return false;
  if (!mojo::Equals(this->urls, other_struct.urls))
    return false;
  return true;
}

template <typename T, ProductSpecificationsDescriptionText::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.text < rhs.text)
    return true;
  if (rhs.text < lhs.text)
    return false;
  if (lhs.urls < rhs.urls)
    return true;
  if (rhs.urls < lhs.urls)
    return false;
  return false;
}
template <typename StructPtrType>
ProductSpecificationsOptionPtr ProductSpecificationsOption::Clone() const {
  return New(
      mojo::Clone(descriptions)
  );
}

template <typename T, ProductSpecificationsOption::EnableIfSame<T>*>
bool ProductSpecificationsOption::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->descriptions, other_struct.descriptions))
    return false;
  return true;
}

template <typename T, ProductSpecificationsOption::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.descriptions < rhs.descriptions)
    return true;
  if (rhs.descriptions < lhs.descriptions)
    return false;
  return false;
}
template <typename StructPtrType>
ProductSpecificationsDescriptionPtr ProductSpecificationsDescription::Clone() const {
  return New(
      mojo::Clone(options),
      mojo::Clone(label),
      mojo::Clone(alt_text)
  );
}

template <typename T, ProductSpecificationsDescription::EnableIfSame<T>*>
bool ProductSpecificationsDescription::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->options, other_struct.options))
    return false;
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  if (!mojo::Equals(this->alt_text, other_struct.alt_text))
    return false;
  return true;
}

template <typename T, ProductSpecificationsDescription::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.options < rhs.options)
    return true;
  if (rhs.options < lhs.options)
    return false;
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  if (lhs.alt_text < rhs.alt_text)
    return true;
  if (rhs.alt_text < lhs.alt_text)
    return false;
  return false;
}
template <typename StructPtrType>
ProductSpecificationsValuePtr ProductSpecificationsValue::Clone() const {
  return New(
      mojo::Clone(specification_descriptions),
      mojo::Clone(summary)
  );
}

template <typename T, ProductSpecificationsValue::EnableIfSame<T>*>
bool ProductSpecificationsValue::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->specification_descriptions, other_struct.specification_descriptions))
    return false;
  if (!mojo::Equals(this->summary, other_struct.summary))
    return false;
  return true;
}

template <typename T, ProductSpecificationsValue::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.specification_descriptions < rhs.specification_descriptions)
    return true;
  if (rhs.specification_descriptions < lhs.specification_descriptions)
    return false;
  if (lhs.summary < rhs.summary)
    return true;
  if (rhs.summary < lhs.summary)
    return false;
  return false;
}
template <typename StructPtrType>
ProductSpecificationsProductPtr ProductSpecificationsProduct::Clone() const {
  return New(
      mojo::Clone(product_cluster_id),
      mojo::Clone(title),
      mojo::Clone(image_url),
      mojo::Clone(product_dimension_values),
      mojo::Clone(summary),
      mojo::Clone(buying_options_url)
  );
}

template <typename T, ProductSpecificationsProduct::EnableIfSame<T>*>
bool ProductSpecificationsProduct::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->product_cluster_id, other_struct.product_cluster_id))
    return false;
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->image_url, other_struct.image_url))
    return false;
  if (!mojo::Equals(this->product_dimension_values, other_struct.product_dimension_values))
    return false;
  if (!mojo::Equals(this->summary, other_struct.summary))
    return false;
  if (!mojo::Equals(this->buying_options_url, other_struct.buying_options_url))
    return false;
  return true;
}

template <typename T, ProductSpecificationsProduct::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.product_cluster_id < rhs.product_cluster_id)
    return true;
  if (rhs.product_cluster_id < lhs.product_cluster_id)
    return false;
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  if (lhs.image_url < rhs.image_url)
    return true;
  if (rhs.image_url < lhs.image_url)
    return false;
  if (lhs.product_dimension_values < rhs.product_dimension_values)
    return true;
  if (rhs.product_dimension_values < lhs.product_dimension_values)
    return false;
  if (lhs.summary < rhs.summary)
    return true;
  if (rhs.summary < lhs.summary)
    return false;
  if (lhs.buying_options_url < rhs.buying_options_url)
    return true;
  if (rhs.buying_options_url < lhs.buying_options_url)
    return false;
  return false;
}
template <typename StructPtrType>
ProductSpecificationsFeatureStatePtr ProductSpecificationsFeatureState::Clone() const {
  return New(
      mojo::Clone(is_syncing_tab_compare),
      mojo::Clone(can_load_full_page_ui),
      mojo::Clone(can_manage_sets),
      mojo::Clone(can_fetch_data),
      mojo::Clone(is_allowed_for_enterprise),
      mojo::Clone(is_quality_logging_allowed),
      mojo::Clone(is_signed_in)
  );
}

template <typename T, ProductSpecificationsFeatureState::EnableIfSame<T>*>
bool ProductSpecificationsFeatureState::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->is_syncing_tab_compare, other_struct.is_syncing_tab_compare))
    return false;
  if (!mojo::Equals(this->can_load_full_page_ui, other_struct.can_load_full_page_ui))
    return false;
  if (!mojo::Equals(this->can_manage_sets, other_struct.can_manage_sets))
    return false;
  if (!mojo::Equals(this->can_fetch_data, other_struct.can_fetch_data))
    return false;
  if (!mojo::Equals(this->is_allowed_for_enterprise, other_struct.is_allowed_for_enterprise))
    return false;
  if (!mojo::Equals(this->is_quality_logging_allowed, other_struct.is_quality_logging_allowed))
    return false;
  if (!mojo::Equals(this->is_signed_in, other_struct.is_signed_in))
    return false;
  return true;
}

template <typename T, ProductSpecificationsFeatureState::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.is_syncing_tab_compare < rhs.is_syncing_tab_compare)
    return true;
  if (rhs.is_syncing_tab_compare < lhs.is_syncing_tab_compare)
    return false;
  if (lhs.can_load_full_page_ui < rhs.can_load_full_page_ui)
    return true;
  if (rhs.can_load_full_page_ui < lhs.can_load_full_page_ui)
    return false;
  if (lhs.can_manage_sets < rhs.can_manage_sets)
    return true;
  if (rhs.can_manage_sets < lhs.can_manage_sets)
    return false;
  if (lhs.can_fetch_data < rhs.can_fetch_data)
    return true;
  if (rhs.can_fetch_data < lhs.can_fetch_data)
    return false;
  if (lhs.is_allowed_for_enterprise < rhs.is_allowed_for_enterprise)
    return true;
  if (rhs.is_allowed_for_enterprise < lhs.is_allowed_for_enterprise)
    return false;
  if (lhs.is_quality_logging_allowed < rhs.is_quality_logging_allowed)
    return true;
  if (rhs.is_quality_logging_allowed < lhs.is_quality_logging_allowed)
    return false;
  if (lhs.is_signed_in < rhs.is_signed_in)
    return true;
  if (rhs.is_signed_in < lhs.is_signed_in)
    return false;
  return false;
}
template <typename StructPtrType>
ProductSpecificationsPtr ProductSpecifications::Clone() const {
  return New(
      mojo::Clone(product_dimension_map),
      mojo::Clone(products)
  );
}

template <typename T, ProductSpecifications::EnableIfSame<T>*>
bool ProductSpecifications::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->product_dimension_map, other_struct.product_dimension_map))
    return false;
  if (!mojo::Equals(this->products, other_struct.products))
    return false;
  return true;
}

template <typename T, ProductSpecifications::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.product_dimension_map < rhs.product_dimension_map)
    return true;
  if (rhs.product_dimension_map < lhs.product_dimension_map)
    return false;
  if (lhs.products < rhs.products)
    return true;
  if (rhs.products < lhs.products)
    return false;
  return false;
}


}  // shopping_service::mojom

namespace mojo {


template <>
struct  StructTraits<::shopping_service::mojom::PricePoint::DataView,
                                         ::shopping_service::mojom::PricePointPtr> {
  static bool IsNull(const ::shopping_service::mojom::PricePointPtr& input) { return !input; }
  static void SetToNull(::shopping_service::mojom::PricePointPtr* output) { output->reset(); }

  static const decltype(::shopping_service::mojom::PricePoint::date)& date(
      const ::shopping_service::mojom::PricePointPtr& input) {
    return input->date;
  }

  static decltype(::shopping_service::mojom::PricePoint::price) price(
      const ::shopping_service::mojom::PricePointPtr& input) {
    return input->price;
  }

  static const decltype(::shopping_service::mojom::PricePoint::formatted_price)& formatted_price(
      const ::shopping_service::mojom::PricePointPtr& input) {
    return input->formatted_price;
  }

  static bool Read(::shopping_service::mojom::PricePoint::DataView input, ::shopping_service::mojom::PricePointPtr* output);
};


template <>
struct  StructTraits<::shopping_service::mojom::UrlInfo::DataView,
                                         ::shopping_service::mojom::UrlInfoPtr> {
  static bool IsNull(const ::shopping_service::mojom::UrlInfoPtr& input) { return !input; }
  static void SetToNull(::shopping_service::mojom::UrlInfoPtr* output) { output->reset(); }

  static const decltype(::shopping_service::mojom::UrlInfo::title)& title(
      const ::shopping_service::mojom::UrlInfoPtr& input) {
    return input->title;
  }

  static const decltype(::shopping_service::mojom::UrlInfo::url)& url(
      const ::shopping_service::mojom::UrlInfoPtr& input) {
    return input->url;
  }

  static const decltype(::shopping_service::mojom::UrlInfo::favicon_url)& favicon_url(
      const ::shopping_service::mojom::UrlInfoPtr& input) {
    return input->favicon_url;
  }

  static const decltype(::shopping_service::mojom::UrlInfo::thumbnail_url)& thumbnail_url(
      const ::shopping_service::mojom::UrlInfoPtr& input) {
    return input->thumbnail_url;
  }

  static const decltype(::shopping_service::mojom::UrlInfo::previewText)& previewText(
      const ::shopping_service::mojom::UrlInfoPtr& input) {
    return input->previewText;
  }

  static bool Read(::shopping_service::mojom::UrlInfo::DataView input, ::shopping_service::mojom::UrlInfoPtr* output);
};


template <>
struct  StructTraits<::shopping_service::mojom::PriceInsightsInfo::DataView,
                                         ::shopping_service::mojom::PriceInsightsInfoPtr> {
  static bool IsNull(const ::shopping_service::mojom::PriceInsightsInfoPtr& input) { return !input; }
  static void SetToNull(::shopping_service::mojom::PriceInsightsInfoPtr* output) { output->reset(); }

  static decltype(::shopping_service::mojom::PriceInsightsInfo::cluster_id) cluster_id(
      const ::shopping_service::mojom::PriceInsightsInfoPtr& input) {
    return input->cluster_id;
  }

  static const decltype(::shopping_service::mojom::PriceInsightsInfo::typical_low_price)& typical_low_price(
      const ::shopping_service::mojom::PriceInsightsInfoPtr& input) {
    return input->typical_low_price;
  }

  static const decltype(::shopping_service::mojom::PriceInsightsInfo::typical_high_price)& typical_high_price(
      const ::shopping_service::mojom::PriceInsightsInfoPtr& input) {
    return input->typical_high_price;
  }

  static const decltype(::shopping_service::mojom::PriceInsightsInfo::catalog_attributes)& catalog_attributes(
      const ::shopping_service::mojom::PriceInsightsInfoPtr& input) {
    return input->catalog_attributes;
  }

  static const decltype(::shopping_service::mojom::PriceInsightsInfo::jackpot)& jackpot(
      const ::shopping_service::mojom::PriceInsightsInfoPtr& input) {
    return input->jackpot;
  }

  static decltype(::shopping_service::mojom::PriceInsightsInfo::bucket) bucket(
      const ::shopping_service::mojom::PriceInsightsInfoPtr& input) {
    return input->bucket;
  }

  static decltype(::shopping_service::mojom::PriceInsightsInfo::has_multiple_catalogs) has_multiple_catalogs(
      const ::shopping_service::mojom::PriceInsightsInfoPtr& input) {
    return input->has_multiple_catalogs;
  }

  static const decltype(::shopping_service::mojom::PriceInsightsInfo::history)& history(
      const ::shopping_service::mojom::PriceInsightsInfoPtr& input) {
    return input->history;
  }

  static const decltype(::shopping_service::mojom::PriceInsightsInfo::locale)& locale(
      const ::shopping_service::mojom::PriceInsightsInfoPtr& input) {
    return input->locale;
  }

  static const decltype(::shopping_service::mojom::PriceInsightsInfo::currency_code)& currency_code(
      const ::shopping_service::mojom::PriceInsightsInfoPtr& input) {
    return input->currency_code;
  }

  static bool Read(::shopping_service::mojom::PriceInsightsInfo::DataView input, ::shopping_service::mojom::PriceInsightsInfoPtr* output);
};


template <>
struct  StructTraits<::shopping_service::mojom::ProductSpecificationsDescriptionText::DataView,
                                         ::shopping_service::mojom::ProductSpecificationsDescriptionTextPtr> {
  static bool IsNull(const ::shopping_service::mojom::ProductSpecificationsDescriptionTextPtr& input) { return !input; }
  static void SetToNull(::shopping_service::mojom::ProductSpecificationsDescriptionTextPtr* output) { output->reset(); }

  static const decltype(::shopping_service::mojom::ProductSpecificationsDescriptionText::text)& text(
      const ::shopping_service::mojom::ProductSpecificationsDescriptionTextPtr& input) {
    return input->text;
  }

  static const decltype(::shopping_service::mojom::ProductSpecificationsDescriptionText::urls)& urls(
      const ::shopping_service::mojom::ProductSpecificationsDescriptionTextPtr& input) {
    return input->urls;
  }

  static bool Read(::shopping_service::mojom::ProductSpecificationsDescriptionText::DataView input, ::shopping_service::mojom::ProductSpecificationsDescriptionTextPtr* output);
};


template <>
struct  StructTraits<::shopping_service::mojom::ProductSpecificationsOption::DataView,
                                         ::shopping_service::mojom::ProductSpecificationsOptionPtr> {
  static bool IsNull(const ::shopping_service::mojom::ProductSpecificationsOptionPtr& input) { return !input; }
  static void SetToNull(::shopping_service::mojom::ProductSpecificationsOptionPtr* output) { output->reset(); }

  static const decltype(::shopping_service::mojom::ProductSpecificationsOption::descriptions)& descriptions(
      const ::shopping_service::mojom::ProductSpecificationsOptionPtr& input) {
    return input->descriptions;
  }

  static bool Read(::shopping_service::mojom::ProductSpecificationsOption::DataView input, ::shopping_service::mojom::ProductSpecificationsOptionPtr* output);
};


template <>
struct  StructTraits<::shopping_service::mojom::ProductSpecificationsDescription::DataView,
                                         ::shopping_service::mojom::ProductSpecificationsDescriptionPtr> {
  static bool IsNull(const ::shopping_service::mojom::ProductSpecificationsDescriptionPtr& input) { return !input; }
  static void SetToNull(::shopping_service::mojom::ProductSpecificationsDescriptionPtr* output) { output->reset(); }

  static const decltype(::shopping_service::mojom::ProductSpecificationsDescription::options)& options(
      const ::shopping_service::mojom::ProductSpecificationsDescriptionPtr& input) {
    return input->options;
  }

  static const decltype(::shopping_service::mojom::ProductSpecificationsDescription::label)& label(
      const ::shopping_service::mojom::ProductSpecificationsDescriptionPtr& input) {
    return input->label;
  }

  static const decltype(::shopping_service::mojom::ProductSpecificationsDescription::alt_text)& alt_text(
      const ::shopping_service::mojom::ProductSpecificationsDescriptionPtr& input) {
    return input->alt_text;
  }

  static bool Read(::shopping_service::mojom::ProductSpecificationsDescription::DataView input, ::shopping_service::mojom::ProductSpecificationsDescriptionPtr* output);
};


template <>
struct  StructTraits<::shopping_service::mojom::ProductSpecificationsValue::DataView,
                                         ::shopping_service::mojom::ProductSpecificationsValuePtr> {
  static bool IsNull(const ::shopping_service::mojom::ProductSpecificationsValuePtr& input) { return !input; }
  static void SetToNull(::shopping_service::mojom::ProductSpecificationsValuePtr* output) { output->reset(); }

  static const decltype(::shopping_service::mojom::ProductSpecificationsValue::specification_descriptions)& specification_descriptions(
      const ::shopping_service::mojom::ProductSpecificationsValuePtr& input) {
    return input->specification_descriptions;
  }

  static const decltype(::shopping_service::mojom::ProductSpecificationsValue::summary)& summary(
      const ::shopping_service::mojom::ProductSpecificationsValuePtr& input) {
    return input->summary;
  }

  static bool Read(::shopping_service::mojom::ProductSpecificationsValue::DataView input, ::shopping_service::mojom::ProductSpecificationsValuePtr* output);
};


template <>
struct  StructTraits<::shopping_service::mojom::ProductSpecificationsProduct::DataView,
                                         ::shopping_service::mojom::ProductSpecificationsProductPtr> {
  static bool IsNull(const ::shopping_service::mojom::ProductSpecificationsProductPtr& input) { return !input; }
  static void SetToNull(::shopping_service::mojom::ProductSpecificationsProductPtr* output) { output->reset(); }

  static decltype(::shopping_service::mojom::ProductSpecificationsProduct::product_cluster_id) product_cluster_id(
      const ::shopping_service::mojom::ProductSpecificationsProductPtr& input) {
    return input->product_cluster_id;
  }

  static const decltype(::shopping_service::mojom::ProductSpecificationsProduct::title)& title(
      const ::shopping_service::mojom::ProductSpecificationsProductPtr& input) {
    return input->title;
  }

  static const decltype(::shopping_service::mojom::ProductSpecificationsProduct::image_url)& image_url(
      const ::shopping_service::mojom::ProductSpecificationsProductPtr& input) {
    return input->image_url;
  }

  static const decltype(::shopping_service::mojom::ProductSpecificationsProduct::product_dimension_values)& product_dimension_values(
      const ::shopping_service::mojom::ProductSpecificationsProductPtr& input) {
    return input->product_dimension_values;
  }

  static const decltype(::shopping_service::mojom::ProductSpecificationsProduct::summary)& summary(
      const ::shopping_service::mojom::ProductSpecificationsProductPtr& input) {
    return input->summary;
  }

  static const decltype(::shopping_service::mojom::ProductSpecificationsProduct::buying_options_url)& buying_options_url(
      const ::shopping_service::mojom::ProductSpecificationsProductPtr& input) {
    return input->buying_options_url;
  }

  static bool Read(::shopping_service::mojom::ProductSpecificationsProduct::DataView input, ::shopping_service::mojom::ProductSpecificationsProductPtr* output);
};


template <>
struct  StructTraits<::shopping_service::mojom::ProductSpecificationsFeatureState::DataView,
                                         ::shopping_service::mojom::ProductSpecificationsFeatureStatePtr> {
  static bool IsNull(const ::shopping_service::mojom::ProductSpecificationsFeatureStatePtr& input) { return !input; }
  static void SetToNull(::shopping_service::mojom::ProductSpecificationsFeatureStatePtr* output) { output->reset(); }

  static decltype(::shopping_service::mojom::ProductSpecificationsFeatureState::is_syncing_tab_compare) is_syncing_tab_compare(
      const ::shopping_service::mojom::ProductSpecificationsFeatureStatePtr& input) {
    return input->is_syncing_tab_compare;
  }

  static decltype(::shopping_service::mojom::ProductSpecificationsFeatureState::can_load_full_page_ui) can_load_full_page_ui(
      const ::shopping_service::mojom::ProductSpecificationsFeatureStatePtr& input) {
    return input->can_load_full_page_ui;
  }

  static decltype(::shopping_service::mojom::ProductSpecificationsFeatureState::can_manage_sets) can_manage_sets(
      const ::shopping_service::mojom::ProductSpecificationsFeatureStatePtr& input) {
    return input->can_manage_sets;
  }

  static decltype(::shopping_service::mojom::ProductSpecificationsFeatureState::can_fetch_data) can_fetch_data(
      const ::shopping_service::mojom::ProductSpecificationsFeatureStatePtr& input) {
    return input->can_fetch_data;
  }

  static decltype(::shopping_service::mojom::ProductSpecificationsFeatureState::is_allowed_for_enterprise) is_allowed_for_enterprise(
      const ::shopping_service::mojom::ProductSpecificationsFeatureStatePtr& input) {
    return input->is_allowed_for_enterprise;
  }

  static decltype(::shopping_service::mojom::ProductSpecificationsFeatureState::is_quality_logging_allowed) is_quality_logging_allowed(
      const ::shopping_service::mojom::ProductSpecificationsFeatureStatePtr& input) {
    return input->is_quality_logging_allowed;
  }

  static decltype(::shopping_service::mojom::ProductSpecificationsFeatureState::is_signed_in) is_signed_in(
      const ::shopping_service::mojom::ProductSpecificationsFeatureStatePtr& input) {
    return input->is_signed_in;
  }

  static bool Read(::shopping_service::mojom::ProductSpecificationsFeatureState::DataView input, ::shopping_service::mojom::ProductSpecificationsFeatureStatePtr* output);
};


template <>
struct  StructTraits<::shopping_service::mojom::ProductSpecifications::DataView,
                                         ::shopping_service::mojom::ProductSpecificationsPtr> {
  static bool IsNull(const ::shopping_service::mojom::ProductSpecificationsPtr& input) { return !input; }
  static void SetToNull(::shopping_service::mojom::ProductSpecificationsPtr* output) { output->reset(); }

  static const decltype(::shopping_service::mojom::ProductSpecifications::product_dimension_map)& product_dimension_map(
      const ::shopping_service::mojom::ProductSpecificationsPtr& input) {
    return input->product_dimension_map;
  }

  static const decltype(::shopping_service::mojom::ProductSpecifications::products)& products(
      const ::shopping_service::mojom::ProductSpecificationsPtr& input) {
    return input->products;
  }

  static bool Read(::shopping_service::mojom::ProductSpecifications::DataView input, ::shopping_service::mojom::ProductSpecificationsPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_COMMERCE_CORE_MOJOM_SHOPPING_SERVICE_MOJOM_H_