// components/commerce/core/mojom/shopping_service.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/commerce/core/mojom/shopping_service.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/commerce/core/mojom/shopping_service.mojom-params-data.h"
#include "components/commerce/core/mojom/shopping_service.mojom-shared-message-ids.h"

#include "components/commerce/core/mojom/shopping_service.mojom-import-headers.h"
#include "components/commerce/core/mojom/shopping_service.mojom-test-utils.h"


namespace shopping_service::mojom {
PricePoint::PricePoint()
    : date(),
      price(),
      formatted_price() {}

PricePoint::PricePoint(
    const std::string& date_in,
    float price_in,
    const std::string& formatted_price_in)
    : date(std::move(date_in)),
      price(std::move(price_in)),
      formatted_price(std::move(formatted_price_in)) {}

PricePoint::~PricePoint() = default;
size_t PricePoint::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->date);
  seed = mojo::internal::Hash(seed, this->price);
  seed = mojo::internal::Hash(seed, this->formatted_price);
  return seed;
}

void PricePoint::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "date"), this->date,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "price"), this->price,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "formatted_price"), this->formatted_price,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PricePoint::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
UrlInfo::UrlInfo()
    : title(),
      url(),
      favicon_url(),
      thumbnail_url(),
      previewText() {}

UrlInfo::UrlInfo(
    const std::string& title_in,
    const ::GURL& url_in,
    const ::GURL& favicon_url_in,
    const ::GURL& thumbnail_url_in,
    const std::string& previewText_in)
    : title(std::move(title_in)),
      url(std::move(url_in)),
      favicon_url(std::move(favicon_url_in)),
      thumbnail_url(std::move(thumbnail_url_in)),
      previewText(std::move(previewText_in)) {}

UrlInfo::~UrlInfo() = default;

void UrlInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "favicon_url"), this->favicon_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "thumbnail_url"), this->thumbnail_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "previewText"), this->previewText,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool UrlInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PriceInsightsInfo::PriceInsightsInfo()
    : cluster_id(),
      typical_low_price(),
      typical_high_price(),
      catalog_attributes(),
      jackpot(),
      bucket(),
      has_multiple_catalogs(),
      history(),
      locale(),
      currency_code() {}

PriceInsightsInfo::PriceInsightsInfo(
    uint64_t cluster_id_in,
    const std::string& typical_low_price_in,
    const std::string& typical_high_price_in,
    const std::string& catalog_attributes_in,
    const ::GURL& jackpot_in,
    PriceInsightsInfo::PriceBucket bucket_in,
    bool has_multiple_catalogs_in,
    std::vector<PricePointPtr> history_in,
    const std::string& locale_in,
    const std::string& currency_code_in)
    : cluster_id(std::move(cluster_id_in)),
      typical_low_price(std::move(typical_low_price_in)),
      typical_high_price(std::move(typical_high_price_in)),
      catalog_attributes(std::move(catalog_attributes_in)),
      jackpot(std::move(jackpot_in)),
      bucket(std::move(bucket_in)),
      has_multiple_catalogs(std::move(has_multiple_catalogs_in)),
      history(std::move(history_in)),
      locale(std::move(locale_in)),
      currency_code(std::move(currency_code_in)) {}

PriceInsightsInfo::~PriceInsightsInfo() = default;

void PriceInsightsInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cluster_id"), this->cluster_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "typical_low_price"), this->typical_low_price,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "typical_high_price"), this->typical_high_price,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "catalog_attributes"), this->catalog_attributes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "jackpot"), this->jackpot,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bucket"), this->bucket,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PriceInsightsInfo::PriceBucket>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_multiple_catalogs"), this->has_multiple_catalogs,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "history"), this->history,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<PricePointPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "locale"), this->locale,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "currency_code"), this->currency_code,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PriceInsightsInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ProductSpecificationsDescriptionText::ProductSpecificationsDescriptionText()
    : text(),
      urls() {}

ProductSpecificationsDescriptionText::ProductSpecificationsDescriptionText(
    const std::string& text_in,
    std::vector<UrlInfoPtr> urls_in)
    : text(std::move(text_in)),
      urls(std::move(urls_in)) {}

ProductSpecificationsDescriptionText::~ProductSpecificationsDescriptionText() = default;

void ProductSpecificationsDescriptionText::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "text"), this->text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "urls"), this->urls,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<UrlInfoPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ProductSpecificationsDescriptionText::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ProductSpecificationsOption::ProductSpecificationsOption()
    : descriptions() {}

ProductSpecificationsOption::ProductSpecificationsOption(
    std::vector<ProductSpecificationsDescriptionTextPtr> descriptions_in)
    : descriptions(std::move(descriptions_in)) {}

ProductSpecificationsOption::~ProductSpecificationsOption() = default;

void ProductSpecificationsOption::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "descriptions"), this->descriptions,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<ProductSpecificationsDescriptionTextPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ProductSpecificationsOption::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ProductSpecificationsDescription::ProductSpecificationsDescription()
    : options(),
      label(),
      alt_text() {}

ProductSpecificationsDescription::ProductSpecificationsDescription(
    std::vector<ProductSpecificationsOptionPtr> options_in,
    const std::string& label_in,
    const std::string& alt_text_in)
    : options(std::move(options_in)),
      label(std::move(label_in)),
      alt_text(std::move(alt_text_in)) {}

ProductSpecificationsDescription::~ProductSpecificationsDescription() = default;

void ProductSpecificationsDescription::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "options"), this->options,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<ProductSpecificationsOptionPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "alt_text"), this->alt_text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ProductSpecificationsDescription::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ProductSpecificationsValue::ProductSpecificationsValue()
    : specification_descriptions(),
      summary() {}

ProductSpecificationsValue::ProductSpecificationsValue(
    std::vector<ProductSpecificationsDescriptionPtr> specification_descriptions_in,
    std::vector<ProductSpecificationsDescriptionTextPtr> summary_in)
    : specification_descriptions(std::move(specification_descriptions_in)),
      summary(std::move(summary_in)) {}

ProductSpecificationsValue::~ProductSpecificationsValue() = default;

void ProductSpecificationsValue::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "specification_descriptions"), this->specification_descriptions,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<ProductSpecificationsDescriptionPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "summary"), this->summary,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<ProductSpecificationsDescriptionTextPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ProductSpecificationsValue::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ProductSpecificationsProduct::ProductSpecificationsProduct()
    : product_cluster_id(),
      title(),
      image_url(),
      product_dimension_values(),
      summary(),
      buying_options_url() {}

ProductSpecificationsProduct::ProductSpecificationsProduct(
    uint64_t product_cluster_id_in,
    const std::string& title_in,
    const ::GURL& image_url_in,
    base::flat_map<uint64_t, ProductSpecificationsValuePtr> product_dimension_values_in,
    std::vector<ProductSpecificationsDescriptionTextPtr> summary_in,
    const ::GURL& buying_options_url_in)
    : product_cluster_id(std::move(product_cluster_id_in)),
      title(std::move(title_in)),
      image_url(std::move(image_url_in)),
      product_dimension_values(std::move(product_dimension_values_in)),
      summary(std::move(summary_in)),
      buying_options_url(std::move(buying_options_url_in)) {}

ProductSpecificationsProduct::~ProductSpecificationsProduct() = default;

void ProductSpecificationsProduct::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "product_cluster_id"), this->product_cluster_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "image_url"), this->image_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "product_dimension_values"), this->product_dimension_values,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type base::flat_map<uint64_t, ProductSpecificationsValuePtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "summary"), this->summary,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<ProductSpecificationsDescriptionTextPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "buying_options_url"), this->buying_options_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ProductSpecificationsProduct::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ProductSpecificationsFeatureState::ProductSpecificationsFeatureState()
    : is_syncing_tab_compare(),
      can_load_full_page_ui(),
      can_manage_sets(),
      can_fetch_data(),
      is_allowed_for_enterprise(),
      is_quality_logging_allowed(),
      is_signed_in() {}

ProductSpecificationsFeatureState::ProductSpecificationsFeatureState(
    bool is_syncing_tab_compare_in,
    bool can_load_full_page_ui_in,
    bool can_manage_sets_in,
    bool can_fetch_data_in,
    bool is_allowed_for_enterprise_in,
    bool is_quality_logging_allowed_in,
    bool is_signed_in_in)
    : is_syncing_tab_compare(std::move(is_syncing_tab_compare_in)),
      can_load_full_page_ui(std::move(can_load_full_page_ui_in)),
      can_manage_sets(std::move(can_manage_sets_in)),
      can_fetch_data(std::move(can_fetch_data_in)),
      is_allowed_for_enterprise(std::move(is_allowed_for_enterprise_in)),
      is_quality_logging_allowed(std::move(is_quality_logging_allowed_in)),
      is_signed_in(std::move(is_signed_in_in)) {}

ProductSpecificationsFeatureState::~ProductSpecificationsFeatureState() = default;
size_t ProductSpecificationsFeatureState::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->is_syncing_tab_compare);
  seed = mojo::internal::Hash(seed, this->can_load_full_page_ui);
  seed = mojo::internal::Hash(seed, this->can_manage_sets);
  seed = mojo::internal::Hash(seed, this->can_fetch_data);
  seed = mojo::internal::Hash(seed, this->is_allowed_for_enterprise);
  seed = mojo::internal::Hash(seed, this->is_quality_logging_allowed);
  seed = mojo::internal::Hash(seed, this->is_signed_in);
  return seed;
}

void ProductSpecificationsFeatureState::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_syncing_tab_compare"), this->is_syncing_tab_compare,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "can_load_full_page_ui"), this->can_load_full_page_ui,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "can_manage_sets"), this->can_manage_sets,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "can_fetch_data"), this->can_fetch_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_allowed_for_enterprise"), this->is_allowed_for_enterprise,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_quality_logging_allowed"), this->is_quality_logging_allowed,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_signed_in"), this->is_signed_in,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ProductSpecificationsFeatureState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ProductSpecifications::ProductSpecifications()
    : product_dimension_map(),
      products() {}

ProductSpecifications::ProductSpecifications(
    const base::flat_map<uint64_t, std::string>& product_dimension_map_in,
    std::vector<ProductSpecificationsProductPtr> products_in)
    : product_dimension_map(std::move(product_dimension_map_in)),
      products(std::move(products_in)) {}

ProductSpecifications::~ProductSpecifications() = default;

void ProductSpecifications::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "product_dimension_map"), this->product_dimension_map,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const base::flat_map<uint64_t, std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "products"), this->products,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<ProductSpecificationsProductPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ProductSpecifications::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

ShoppingServiceHandlerFactory::IPCStableHashFunction ShoppingServiceHandlerFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ShoppingServiceHandlerFactory>(message.name())) {
    case messages::ShoppingServiceHandlerFactory::kCreateShoppingServiceHandler: {
      return &ShoppingServiceHandlerFactory::CreateShoppingServiceHandler_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ShoppingServiceHandlerFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ShoppingServiceHandlerFactory>(message.name())) {
      case messages::ShoppingServiceHandlerFactory::kCreateShoppingServiceHandler:
            return "Receive shopping_service::mojom::ShoppingServiceHandlerFactory::CreateShoppingServiceHandler";
    }
  } else {
    switch (static_cast<messages::ShoppingServiceHandlerFactory>(message.name())) {
      case messages::ShoppingServiceHandlerFactory::kCreateShoppingServiceHandler:
            return "Receive reply shopping_service::mojom::ShoppingServiceHandlerFactory::CreateShoppingServiceHandler";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ShoppingServiceHandlerFactory::CreateShoppingServiceHandler_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb2ceb78b;  // IPCStableHash for shopping_service::mojom::ShoppingServiceHandlerFactory::CreateShoppingServiceHandler
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ShoppingServiceHandlerFactoryProxy::ShoppingServiceHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ShoppingServiceHandlerFactoryProxy::CreateShoppingServiceHandler(
    ::mojo::PendingReceiver<ShoppingServiceHandler> in_handler) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send shopping_service::mojom::ShoppingServiceHandlerFactory::CreateShoppingServiceHandler", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handler"), in_handler,
                        "<value of type ::mojo::PendingReceiver<ShoppingServiceHandler>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ShoppingServiceHandlerFactory::kCreateShoppingServiceHandler), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::shopping_service::mojom::internal::ShoppingServiceHandlerFactory_CreateShoppingServiceHandler_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::shopping_service::mojom::ShoppingServiceHandlerInterfaceBase>>(
    in_handler,
    &params->handler,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->handler)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid handler in ShoppingServiceHandlerFactory.CreateShoppingServiceHandler request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ShoppingServiceHandlerFactory::Name_);
  message.set_method_name("CreateShoppingServiceHandler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ShoppingServiceHandlerFactoryStubDispatch::Accept(
    ShoppingServiceHandlerFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ShoppingServiceHandlerFactory>(message->header()->name)) {
    case messages::ShoppingServiceHandlerFactory::kCreateShoppingServiceHandler: {
      DCHECK(message->is_serialized());
      internal::ShoppingServiceHandlerFactory_CreateShoppingServiceHandler_Params_Data* params =
          reinterpret_cast<internal::ShoppingServiceHandlerFactory_CreateShoppingServiceHandler_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ShoppingServiceHandlerFactory.0
      bool success = true;
      ::mojo::PendingReceiver<ShoppingServiceHandler> p_handler{};
      ShoppingServiceHandlerFactory_CreateShoppingServiceHandler_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_handler =
            input_data_view.TakeHandler<decltype(p_handler)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ShoppingServiceHandlerFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateShoppingServiceHandler(        
        std::move(p_handler));
      return true;
    }
  }
  return false;
}

// static
bool ShoppingServiceHandlerFactoryStubDispatch::AcceptWithResponder(
    ShoppingServiceHandlerFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ShoppingServiceHandlerFactory>(message->header()->name)) {
    case messages::ShoppingServiceHandlerFactory::kCreateShoppingServiceHandler: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kShoppingServiceHandlerFactoryValidationInfo[] = {
    { &internal::ShoppingServiceHandlerFactory_CreateShoppingServiceHandler_Params_Data::Validate,
     nullptr /* no response */},
};

bool ShoppingServiceHandlerFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::shopping_service::mojom::ShoppingServiceHandlerFactory::Name_,
    kShoppingServiceHandlerFactoryValidationInfo);
}

// The declaration includes the definition on other builds.

ShoppingServiceHandler::IPCStableHashFunction ShoppingServiceHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ShoppingServiceHandler>(message.name())) {
    case messages::ShoppingServiceHandler::kGetProductInfoForCurrentUrl: {
      return &ShoppingServiceHandler::GetProductInfoForCurrentUrl_Sym::IPCStableHash;
    }
    case messages::ShoppingServiceHandler::kGetProductInfoForUrl: {
      return &ShoppingServiceHandler::GetProductInfoForUrl_Sym::IPCStableHash;
    }
    case messages::ShoppingServiceHandler::kGetProductInfoForUrls: {
      return &ShoppingServiceHandler::GetProductInfoForUrls_Sym::IPCStableHash;
    }
    case messages::ShoppingServiceHandler::kGetPriceInsightsInfoForCurrentUrl: {
      return &ShoppingServiceHandler::GetPriceInsightsInfoForCurrentUrl_Sym::IPCStableHash;
    }
    case messages::ShoppingServiceHandler::kGetPriceInsightsInfoForUrl: {
      return &ShoppingServiceHandler::GetPriceInsightsInfoForUrl_Sym::IPCStableHash;
    }
    case messages::ShoppingServiceHandler::kGetProductSpecificationsForUrls: {
      return &ShoppingServiceHandler::GetProductSpecificationsForUrls_Sym::IPCStableHash;
    }
    case messages::ShoppingServiceHandler::kGetUrlInfosForProductTabs: {
      return &ShoppingServiceHandler::GetUrlInfosForProductTabs_Sym::IPCStableHash;
    }
    case messages::ShoppingServiceHandler::kGetUrlInfosForRecentlyViewedTabs: {
      return &ShoppingServiceHandler::GetUrlInfosForRecentlyViewedTabs_Sym::IPCStableHash;
    }
    case messages::ShoppingServiceHandler::kIsShoppingListEligible: {
      return &ShoppingServiceHandler::IsShoppingListEligible_Sym::IPCStableHash;
    }
    case messages::ShoppingServiceHandler::kGetPriceTrackingStatusForCurrentUrl: {
      return &ShoppingServiceHandler::GetPriceTrackingStatusForCurrentUrl_Sym::IPCStableHash;
    }
    case messages::ShoppingServiceHandler::kOpenUrlInNewTab: {
      return &ShoppingServiceHandler::OpenUrlInNewTab_Sym::IPCStableHash;
    }
    case messages::ShoppingServiceHandler::kSwitchToOrOpenTab: {
      return &ShoppingServiceHandler::SwitchToOrOpenTab_Sym::IPCStableHash;
    }
    case messages::ShoppingServiceHandler::kGetAllProductSpecificationsSets: {
      return &ShoppingServiceHandler::GetAllProductSpecificationsSets_Sym::IPCStableHash;
    }
    case messages::ShoppingServiceHandler::kGetProductSpecificationsSetByUuid: {
      return &ShoppingServiceHandler::GetProductSpecificationsSetByUuid_Sym::IPCStableHash;
    }
    case messages::ShoppingServiceHandler::kAddProductSpecificationsSet: {
      return &ShoppingServiceHandler::AddProductSpecificationsSet_Sym::IPCStableHash;
    }
    case messages::ShoppingServiceHandler::kDeleteProductSpecificationsSet: {
      return &ShoppingServiceHandler::DeleteProductSpecificationsSet_Sym::IPCStableHash;
    }
    case messages::ShoppingServiceHandler::kSetNameForProductSpecificationsSet: {
      return &ShoppingServiceHandler::SetNameForProductSpecificationsSet_Sym::IPCStableHash;
    }
    case messages::ShoppingServiceHandler::kSetUrlsForProductSpecificationsSet: {
      return &ShoppingServiceHandler::SetUrlsForProductSpecificationsSet_Sym::IPCStableHash;
    }
    case messages::ShoppingServiceHandler::kSetProductSpecificationsUserFeedback: {
      return &ShoppingServiceHandler::SetProductSpecificationsUserFeedback_Sym::IPCStableHash;
    }
    case messages::ShoppingServiceHandler::kGetProductSpecificationsFeatureState: {
      return &ShoppingServiceHandler::GetProductSpecificationsFeatureState_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ShoppingServiceHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ShoppingServiceHandler>(message.name())) {
      case messages::ShoppingServiceHandler::kGetProductInfoForCurrentUrl:
            return "Receive shopping_service::mojom::ShoppingServiceHandler::GetProductInfoForCurrentUrl";
      case messages::ShoppingServiceHandler::kGetProductInfoForUrl:
            return "Receive shopping_service::mojom::ShoppingServiceHandler::GetProductInfoForUrl";
      case messages::ShoppingServiceHandler::kGetProductInfoForUrls:
            return "Receive shopping_service::mojom::ShoppingServiceHandler::GetProductInfoForUrls";
      case messages::ShoppingServiceHandler::kGetPriceInsightsInfoForCurrentUrl:
            return "Receive shopping_service::mojom::ShoppingServiceHandler::GetPriceInsightsInfoForCurrentUrl";
      case messages::ShoppingServiceHandler::kGetPriceInsightsInfoForUrl:
            return "Receive shopping_service::mojom::ShoppingServiceHandler::GetPriceInsightsInfoForUrl";
      case messages::ShoppingServiceHandler::kGetProductSpecificationsForUrls:
            return "Receive shopping_service::mojom::ShoppingServiceHandler::GetProductSpecificationsForUrls";
      case messages::ShoppingServiceHandler::kGetUrlInfosForProductTabs:
            return "Receive shopping_service::mojom::ShoppingServiceHandler::GetUrlInfosForProductTabs";
      case messages::ShoppingServiceHandler::kGetUrlInfosForRecentlyViewedTabs:
            return "Receive shopping_service::mojom::ShoppingServiceHandler::GetUrlInfosForRecentlyViewedTabs";
      case messages::ShoppingServiceHandler::kIsShoppingListEligible:
            return "Receive shopping_service::mojom::ShoppingServiceHandler::IsShoppingListEligible";
      case messages::ShoppingServiceHandler::kGetPriceTrackingStatusForCurrentUrl:
            return "Receive shopping_service::mojom::ShoppingServiceHandler::GetPriceTrackingStatusForCurrentUrl";
      case messages::ShoppingServiceHandler::kOpenUrlInNewTab:
            return "Receive shopping_service::mojom::ShoppingServiceHandler::OpenUrlInNewTab";
      case messages::ShoppingServiceHandler::kSwitchToOrOpenTab:
            return "Receive shopping_service::mojom::ShoppingServiceHandler::SwitchToOrOpenTab";
      case messages::ShoppingServiceHandler::kGetAllProductSpecificationsSets:
            return "Receive shopping_service::mojom::ShoppingServiceHandler::GetAllProductSpecificationsSets";
      case messages::ShoppingServiceHandler::kGetProductSpecificationsSetByUuid:
            return "Receive shopping_service::mojom::ShoppingServiceHandler::GetProductSpecificationsSetByUuid";
      case messages::ShoppingServiceHandler::kAddProductSpecificationsSet:
            return "Receive shopping_service::mojom::ShoppingServiceHandler::AddProductSpecificationsSet";
      case messages::ShoppingServiceHandler::kDeleteProductSpecificationsSet:
            return "Receive shopping_service::mojom::ShoppingServiceHandler::DeleteProductSpecificationsSet";
      case messages::ShoppingServiceHandler::kSetNameForProductSpecificationsSet:
            return "Receive shopping_service::mojom::ShoppingServiceHandler::SetNameForProductSpecificationsSet";
      case messages::ShoppingServiceHandler::kSetUrlsForProductSpecificationsSet:
            return "Receive shopping_service::mojom::ShoppingServiceHandler::SetUrlsForProductSpecificationsSet";
      case messages::ShoppingServiceHandler::kSetProductSpecificationsUserFeedback:
            return "Receive shopping_service::mojom::ShoppingServiceHandler::SetProductSpecificationsUserFeedback";
      case messages::ShoppingServiceHandler::kGetProductSpecificationsFeatureState:
            return "Receive shopping_service::mojom::ShoppingServiceHandler::GetProductSpecificationsFeatureState";
    }
  } else {
    switch (static_cast<messages::ShoppingServiceHandler>(message.name())) {
      case messages::ShoppingServiceHandler::kGetProductInfoForCurrentUrl:
            return "Receive reply shopping_service::mojom::ShoppingServiceHandler::GetProductInfoForCurrentUrl";
      case messages::ShoppingServiceHandler::kGetProductInfoForUrl:
            return "Receive reply shopping_service::mojom::ShoppingServiceHandler::GetProductInfoForUrl";
      case messages::ShoppingServiceHandler::kGetProductInfoForUrls:
            return "Receive reply shopping_service::mojom::ShoppingServiceHandler::GetProductInfoForUrls";
      case messages::ShoppingServiceHandler::kGetPriceInsightsInfoForCurrentUrl:
            return "Receive reply shopping_service::mojom::ShoppingServiceHandler::GetPriceInsightsInfoForCurrentUrl";
      case messages::ShoppingServiceHandler::kGetPriceInsightsInfoForUrl:
            return "Receive reply shopping_service::mojom::ShoppingServiceHandler::GetPriceInsightsInfoForUrl";
      case messages::ShoppingServiceHandler::kGetProductSpecificationsForUrls:
            return "Receive reply shopping_service::mojom::ShoppingServiceHandler::GetProductSpecificationsForUrls";
      case messages::ShoppingServiceHandler::kGetUrlInfosForProductTabs:
            return "Receive reply shopping_service::mojom::ShoppingServiceHandler::GetUrlInfosForProductTabs";
      case messages::ShoppingServiceHandler::kGetUrlInfosForRecentlyViewedTabs:
            return "Receive reply shopping_service::mojom::ShoppingServiceHandler::GetUrlInfosForRecentlyViewedTabs";
      case messages::ShoppingServiceHandler::kIsShoppingListEligible:
            return "Receive reply shopping_service::mojom::ShoppingServiceHandler::IsShoppingListEligible";
      case messages::ShoppingServiceHandler::kGetPriceTrackingStatusForCurrentUrl:
            return "Receive reply shopping_service::mojom::ShoppingServiceHandler::GetPriceTrackingStatusForCurrentUrl";
      case messages::ShoppingServiceHandler::kOpenUrlInNewTab:
            return "Receive reply shopping_service::mojom::ShoppingServiceHandler::OpenUrlInNewTab";
      case messages::ShoppingServiceHandler::kSwitchToOrOpenTab:
            return "Receive reply shopping_service::mojom::ShoppingServiceHandler::SwitchToOrOpenTab";
      case messages::ShoppingServiceHandler::kGetAllProductSpecificationsSets:
            return "Receive reply shopping_service::mojom::ShoppingServiceHandler::GetAllProductSpecificationsSets";
      case messages::ShoppingServiceHandler::kGetProductSpecificationsSetByUuid:
            return "Receive reply shopping_service::mojom::ShoppingServiceHandler::GetProductSpecificationsSetByUuid";
      case messages::ShoppingServiceHandler::kAddProductSpecificationsSet:
            return "Receive reply shopping_service::mojom::ShoppingServiceHandler::AddProductSpecificationsSet";
      case messages::ShoppingServiceHandler::kDeleteProductSpecificationsSet:
            return "Receive reply shopping_service::mojom::ShoppingServiceHandler::DeleteProductSpecificationsSet";
      case messages::ShoppingServiceHandler::kSetNameForProductSpecificationsSet:
            return "Receive reply shopping_service::mojom::ShoppingServiceHandler::SetNameForProductSpecificationsSet";
      case messages::ShoppingServiceHandler::kSetUrlsForProductSpecificationsSet:
            return "Receive reply shopping_service::mojom::ShoppingServiceHandler::SetUrlsForProductSpecificationsSet";
      case messages::ShoppingServiceHandler::kSetProductSpecificationsUserFeedback:
            return "Receive reply shopping_service::mojom::ShoppingServiceHandler::SetProductSpecificationsUserFeedback";
      case messages::ShoppingServiceHandler::kGetProductSpecificationsFeatureState:
            return "Receive reply shopping_service::mojom::ShoppingServiceHandler::GetProductSpecificationsFeatureState";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ShoppingServiceHandler::GetProductInfoForCurrentUrl_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x005baf6c;  // IPCStableHash for shopping_service::mojom::ShoppingServiceHandler::GetProductInfoForCurrentUrl
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ShoppingServiceHandler::GetProductInfoForUrl_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x808140d8;  // IPCStableHash for shopping_service::mojom::ShoppingServiceHandler::GetProductInfoForUrl
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ShoppingServiceHandler::GetProductInfoForUrls_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x58293c67;  // IPCStableHash for shopping_service::mojom::ShoppingServiceHandler::GetProductInfoForUrls
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ShoppingServiceHandler::GetPriceInsightsInfoForCurrentUrl_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x427000e1;  // IPCStableHash for shopping_service::mojom::ShoppingServiceHandler::GetPriceInsightsInfoForCurrentUrl
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ShoppingServiceHandler::GetPriceInsightsInfoForUrl_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x44fcbed8;  // IPCStableHash for shopping_service::mojom::ShoppingServiceHandler::GetPriceInsightsInfoForUrl
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ShoppingServiceHandler::GetProductSpecificationsForUrls_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1cc33998;  // IPCStableHash for shopping_service::mojom::ShoppingServiceHandler::GetProductSpecificationsForUrls
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ShoppingServiceHandler::GetUrlInfosForProductTabs_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1c4e02b7;  // IPCStableHash for shopping_service::mojom::ShoppingServiceHandler::GetUrlInfosForProductTabs
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ShoppingServiceHandler::GetUrlInfosForRecentlyViewedTabs_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7d7feb79;  // IPCStableHash for shopping_service::mojom::ShoppingServiceHandler::GetUrlInfosForRecentlyViewedTabs
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ShoppingServiceHandler::IsShoppingListEligible_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xefa220aa;  // IPCStableHash for shopping_service::mojom::ShoppingServiceHandler::IsShoppingListEligible
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ShoppingServiceHandler::GetPriceTrackingStatusForCurrentUrl_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc94cb18f;  // IPCStableHash for shopping_service::mojom::ShoppingServiceHandler::GetPriceTrackingStatusForCurrentUrl
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ShoppingServiceHandler::OpenUrlInNewTab_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x79732bf9;  // IPCStableHash for shopping_service::mojom::ShoppingServiceHandler::OpenUrlInNewTab
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ShoppingServiceHandler::SwitchToOrOpenTab_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb6f0204b;  // IPCStableHash for shopping_service::mojom::ShoppingServiceHandler::SwitchToOrOpenTab
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ShoppingServiceHandler::GetAllProductSpecificationsSets_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x15ebc296;  // IPCStableHash for shopping_service::mojom::ShoppingServiceHandler::GetAllProductSpecificationsSets
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ShoppingServiceHandler::GetProductSpecificationsSetByUuid_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2ac2dd24;  // IPCStableHash for shopping_service::mojom::ShoppingServiceHandler::GetProductSpecificationsSetByUuid
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ShoppingServiceHandler::AddProductSpecificationsSet_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x85e76973;  // IPCStableHash for shopping_service::mojom::ShoppingServiceHandler::AddProductSpecificationsSet
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ShoppingServiceHandler::DeleteProductSpecificationsSet_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xff37e87c;  // IPCStableHash for shopping_service::mojom::ShoppingServiceHandler::DeleteProductSpecificationsSet
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ShoppingServiceHandler::SetNameForProductSpecificationsSet_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdff4f2e0;  // IPCStableHash for shopping_service::mojom::ShoppingServiceHandler::SetNameForProductSpecificationsSet
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ShoppingServiceHandler::SetUrlsForProductSpecificationsSet_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9f47601a;  // IPCStableHash for shopping_service::mojom::ShoppingServiceHandler::SetUrlsForProductSpecificationsSet
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ShoppingServiceHandler::SetProductSpecificationsUserFeedback_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8f91f510;  // IPCStableHash for shopping_service::mojom::ShoppingServiceHandler::SetProductSpecificationsUserFeedback
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ShoppingServiceHandler::GetProductSpecificationsFeatureState_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcbadb591;  // IPCStableHash for shopping_service::mojom::ShoppingServiceHandler::GetProductSpecificationsFeatureState
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class ShoppingServiceHandler_GetProductInfoForCurrentUrl_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ShoppingServiceHandler_GetProductInfoForCurrentUrl_ForwardToCallback(
      ShoppingServiceHandler::GetProductInfoForCurrentUrlCallback callback
      ) : callback_(std::move(callback)) {
  }

  ShoppingServiceHandler_GetProductInfoForCurrentUrl_ForwardToCallback(const ShoppingServiceHandler_GetProductInfoForCurrentUrl_ForwardToCallback&) = delete;
  ShoppingServiceHandler_GetProductInfoForCurrentUrl_ForwardToCallback& operator=(const ShoppingServiceHandler_GetProductInfoForCurrentUrl_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ShoppingServiceHandler::GetProductInfoForCurrentUrlCallback callback_;
};

class ShoppingServiceHandler_GetProductInfoForUrl_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ShoppingServiceHandler_GetProductInfoForUrl_ForwardToCallback(
      ShoppingServiceHandler::GetProductInfoForUrlCallback callback
      ) : callback_(std::move(callback)) {
  }

  ShoppingServiceHandler_GetProductInfoForUrl_ForwardToCallback(const ShoppingServiceHandler_GetProductInfoForUrl_ForwardToCallback&) = delete;
  ShoppingServiceHandler_GetProductInfoForUrl_ForwardToCallback& operator=(const ShoppingServiceHandler_GetProductInfoForUrl_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ShoppingServiceHandler::GetProductInfoForUrlCallback callback_;
};

class ShoppingServiceHandler_GetProductInfoForUrls_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ShoppingServiceHandler_GetProductInfoForUrls_ForwardToCallback(
      ShoppingServiceHandler::GetProductInfoForUrlsCallback callback
      ) : callback_(std::move(callback)) {
  }

  ShoppingServiceHandler_GetProductInfoForUrls_ForwardToCallback(const ShoppingServiceHandler_GetProductInfoForUrls_ForwardToCallback&) = delete;
  ShoppingServiceHandler_GetProductInfoForUrls_ForwardToCallback& operator=(const ShoppingServiceHandler_GetProductInfoForUrls_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ShoppingServiceHandler::GetProductInfoForUrlsCallback callback_;
};

class ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_ForwardToCallback(
      ShoppingServiceHandler::GetPriceInsightsInfoForCurrentUrlCallback callback
      ) : callback_(std::move(callback)) {
  }

  ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_ForwardToCallback(const ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_ForwardToCallback&) = delete;
  ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_ForwardToCallback& operator=(const ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ShoppingServiceHandler::GetPriceInsightsInfoForCurrentUrlCallback callback_;
};

class ShoppingServiceHandler_GetPriceInsightsInfoForUrl_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ShoppingServiceHandler_GetPriceInsightsInfoForUrl_ForwardToCallback(
      ShoppingServiceHandler::GetPriceInsightsInfoForUrlCallback callback
      ) : callback_(std::move(callback)) {
  }

  ShoppingServiceHandler_GetPriceInsightsInfoForUrl_ForwardToCallback(const ShoppingServiceHandler_GetPriceInsightsInfoForUrl_ForwardToCallback&) = delete;
  ShoppingServiceHandler_GetPriceInsightsInfoForUrl_ForwardToCallback& operator=(const ShoppingServiceHandler_GetPriceInsightsInfoForUrl_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ShoppingServiceHandler::GetPriceInsightsInfoForUrlCallback callback_;
};

class ShoppingServiceHandler_GetProductSpecificationsForUrls_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ShoppingServiceHandler_GetProductSpecificationsForUrls_ForwardToCallback(
      ShoppingServiceHandler::GetProductSpecificationsForUrlsCallback callback
      ) : callback_(std::move(callback)) {
  }

  ShoppingServiceHandler_GetProductSpecificationsForUrls_ForwardToCallback(const ShoppingServiceHandler_GetProductSpecificationsForUrls_ForwardToCallback&) = delete;
  ShoppingServiceHandler_GetProductSpecificationsForUrls_ForwardToCallback& operator=(const ShoppingServiceHandler_GetProductSpecificationsForUrls_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ShoppingServiceHandler::GetProductSpecificationsForUrlsCallback callback_;
};

class ShoppingServiceHandler_GetUrlInfosForProductTabs_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ShoppingServiceHandler_GetUrlInfosForProductTabs_ForwardToCallback(
      ShoppingServiceHandler::GetUrlInfosForProductTabsCallback callback
      ) : callback_(std::move(callback)) {
  }

  ShoppingServiceHandler_GetUrlInfosForProductTabs_ForwardToCallback(const ShoppingServiceHandler_GetUrlInfosForProductTabs_ForwardToCallback&) = delete;
  ShoppingServiceHandler_GetUrlInfosForProductTabs_ForwardToCallback& operator=(const ShoppingServiceHandler_GetUrlInfosForProductTabs_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ShoppingServiceHandler::GetUrlInfosForProductTabsCallback callback_;
};

class ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_ForwardToCallback(
      ShoppingServiceHandler::GetUrlInfosForRecentlyViewedTabsCallback callback
      ) : callback_(std::move(callback)) {
  }

  ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_ForwardToCallback(const ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_ForwardToCallback&) = delete;
  ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_ForwardToCallback& operator=(const ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ShoppingServiceHandler::GetUrlInfosForRecentlyViewedTabsCallback callback_;
};

class ShoppingServiceHandler_IsShoppingListEligible_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ShoppingServiceHandler_IsShoppingListEligible_ForwardToCallback(
      ShoppingServiceHandler::IsShoppingListEligibleCallback callback
      ) : callback_(std::move(callback)) {
  }

  ShoppingServiceHandler_IsShoppingListEligible_ForwardToCallback(const ShoppingServiceHandler_IsShoppingListEligible_ForwardToCallback&) = delete;
  ShoppingServiceHandler_IsShoppingListEligible_ForwardToCallback& operator=(const ShoppingServiceHandler_IsShoppingListEligible_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ShoppingServiceHandler::IsShoppingListEligibleCallback callback_;
};

class ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_ForwardToCallback(
      ShoppingServiceHandler::GetPriceTrackingStatusForCurrentUrlCallback callback
      ) : callback_(std::move(callback)) {
  }

  ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_ForwardToCallback(const ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_ForwardToCallback&) = delete;
  ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_ForwardToCallback& operator=(const ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ShoppingServiceHandler::GetPriceTrackingStatusForCurrentUrlCallback callback_;
};

class ShoppingServiceHandler_GetAllProductSpecificationsSets_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ShoppingServiceHandler_GetAllProductSpecificationsSets_ForwardToCallback(
      ShoppingServiceHandler::GetAllProductSpecificationsSetsCallback callback
      ) : callback_(std::move(callback)) {
  }

  ShoppingServiceHandler_GetAllProductSpecificationsSets_ForwardToCallback(const ShoppingServiceHandler_GetAllProductSpecificationsSets_ForwardToCallback&) = delete;
  ShoppingServiceHandler_GetAllProductSpecificationsSets_ForwardToCallback& operator=(const ShoppingServiceHandler_GetAllProductSpecificationsSets_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ShoppingServiceHandler::GetAllProductSpecificationsSetsCallback callback_;
};

class ShoppingServiceHandler_GetProductSpecificationsSetByUuid_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ShoppingServiceHandler_GetProductSpecificationsSetByUuid_ForwardToCallback(
      ShoppingServiceHandler::GetProductSpecificationsSetByUuidCallback callback
      ) : callback_(std::move(callback)) {
  }

  ShoppingServiceHandler_GetProductSpecificationsSetByUuid_ForwardToCallback(const ShoppingServiceHandler_GetProductSpecificationsSetByUuid_ForwardToCallback&) = delete;
  ShoppingServiceHandler_GetProductSpecificationsSetByUuid_ForwardToCallback& operator=(const ShoppingServiceHandler_GetProductSpecificationsSetByUuid_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ShoppingServiceHandler::GetProductSpecificationsSetByUuidCallback callback_;
};

class ShoppingServiceHandler_AddProductSpecificationsSet_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ShoppingServiceHandler_AddProductSpecificationsSet_ForwardToCallback(
      ShoppingServiceHandler::AddProductSpecificationsSetCallback callback
      ) : callback_(std::move(callback)) {
  }

  ShoppingServiceHandler_AddProductSpecificationsSet_ForwardToCallback(const ShoppingServiceHandler_AddProductSpecificationsSet_ForwardToCallback&) = delete;
  ShoppingServiceHandler_AddProductSpecificationsSet_ForwardToCallback& operator=(const ShoppingServiceHandler_AddProductSpecificationsSet_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ShoppingServiceHandler::AddProductSpecificationsSetCallback callback_;
};

class ShoppingServiceHandler_SetNameForProductSpecificationsSet_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ShoppingServiceHandler_SetNameForProductSpecificationsSet_ForwardToCallback(
      ShoppingServiceHandler::SetNameForProductSpecificationsSetCallback callback
      ) : callback_(std::move(callback)) {
  }

  ShoppingServiceHandler_SetNameForProductSpecificationsSet_ForwardToCallback(const ShoppingServiceHandler_SetNameForProductSpecificationsSet_ForwardToCallback&) = delete;
  ShoppingServiceHandler_SetNameForProductSpecificationsSet_ForwardToCallback& operator=(const ShoppingServiceHandler_SetNameForProductSpecificationsSet_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ShoppingServiceHandler::SetNameForProductSpecificationsSetCallback callback_;
};

class ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_ForwardToCallback(
      ShoppingServiceHandler::SetUrlsForProductSpecificationsSetCallback callback
      ) : callback_(std::move(callback)) {
  }

  ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_ForwardToCallback(const ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_ForwardToCallback&) = delete;
  ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_ForwardToCallback& operator=(const ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ShoppingServiceHandler::SetUrlsForProductSpecificationsSetCallback callback_;
};

class ShoppingServiceHandler_GetProductSpecificationsFeatureState_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ShoppingServiceHandler_GetProductSpecificationsFeatureState_ForwardToCallback(
      ShoppingServiceHandler::GetProductSpecificationsFeatureStateCallback callback
      ) : callback_(std::move(callback)) {
  }

  ShoppingServiceHandler_GetProductSpecificationsFeatureState_ForwardToCallback(const ShoppingServiceHandler_GetProductSpecificationsFeatureState_ForwardToCallback&) = delete;
  ShoppingServiceHandler_GetProductSpecificationsFeatureState_ForwardToCallback& operator=(const ShoppingServiceHandler_GetProductSpecificationsFeatureState_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ShoppingServiceHandler::GetProductSpecificationsFeatureStateCallback callback_;
};

ShoppingServiceHandlerProxy::ShoppingServiceHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ShoppingServiceHandlerProxy::GetProductInfoForCurrentUrl(
    GetProductInfoForCurrentUrlCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send shopping_service::mojom::ShoppingServiceHandler::GetProductInfoForCurrentUrl");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ShoppingServiceHandler::kGetProductInfoForCurrentUrl), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::shopping_service::mojom::internal::ShoppingServiceHandler_GetProductInfoForCurrentUrl_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ShoppingServiceHandler::Name_);
  message.set_method_name("GetProductInfoForCurrentUrl");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ShoppingServiceHandler_GetProductInfoForCurrentUrl_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ShoppingServiceHandlerProxy::GetProductInfoForUrl(
    const ::GURL& in_url, GetProductInfoForUrlCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send shopping_service::mojom::ShoppingServiceHandler::GetProductInfoForUrl", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ShoppingServiceHandler::kGetProductInfoForUrl), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::shopping_service::mojom::internal::ShoppingServiceHandler_GetProductInfoForUrl_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in ShoppingServiceHandler.GetProductInfoForUrl request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ShoppingServiceHandler::Name_);
  message.set_method_name("GetProductInfoForUrl");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ShoppingServiceHandler_GetProductInfoForUrl_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ShoppingServiceHandlerProxy::GetProductInfoForUrls(
    const std::vector<::GURL>& in_urls, GetProductInfoForUrlsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send shopping_service::mojom::ShoppingServiceHandler::GetProductInfoForUrls", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("urls"), in_urls,
                        "<value of type const std::vector<::GURL>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ShoppingServiceHandler::kGetProductInfoForUrls), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::shopping_service::mojom::internal::ShoppingServiceHandler_GetProductInfoForUrls_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->urls)::BaseType>
      urls_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& urls_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
    in_urls,
    urls_fragment,
    &urls_validate_params);

  params->urls.Set(
      urls_fragment.is_null() ? nullptr : urls_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->urls.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null urls in ShoppingServiceHandler.GetProductInfoForUrls request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ShoppingServiceHandler::Name_);
  message.set_method_name("GetProductInfoForUrls");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ShoppingServiceHandler_GetProductInfoForUrls_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ShoppingServiceHandlerProxy::GetPriceInsightsInfoForCurrentUrl(
    GetPriceInsightsInfoForCurrentUrlCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send shopping_service::mojom::ShoppingServiceHandler::GetPriceInsightsInfoForCurrentUrl");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ShoppingServiceHandler::kGetPriceInsightsInfoForCurrentUrl), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::shopping_service::mojom::internal::ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ShoppingServiceHandler::Name_);
  message.set_method_name("GetPriceInsightsInfoForCurrentUrl");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ShoppingServiceHandlerProxy::GetPriceInsightsInfoForUrl(
    const ::GURL& in_url, GetPriceInsightsInfoForUrlCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send shopping_service::mojom::ShoppingServiceHandler::GetPriceInsightsInfoForUrl", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ShoppingServiceHandler::kGetPriceInsightsInfoForUrl), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::shopping_service::mojom::internal::ShoppingServiceHandler_GetPriceInsightsInfoForUrl_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in ShoppingServiceHandler.GetPriceInsightsInfoForUrl request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ShoppingServiceHandler::Name_);
  message.set_method_name("GetPriceInsightsInfoForUrl");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ShoppingServiceHandler_GetPriceInsightsInfoForUrl_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ShoppingServiceHandlerProxy::GetProductSpecificationsForUrls(
    const std::vector<::GURL>& in_urls, GetProductSpecificationsForUrlsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send shopping_service::mojom::ShoppingServiceHandler::GetProductSpecificationsForUrls", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("urls"), in_urls,
                        "<value of type const std::vector<::GURL>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ShoppingServiceHandler::kGetProductSpecificationsForUrls), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::shopping_service::mojom::internal::ShoppingServiceHandler_GetProductSpecificationsForUrls_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->urls)::BaseType>
      urls_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& urls_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
    in_urls,
    urls_fragment,
    &urls_validate_params);

  params->urls.Set(
      urls_fragment.is_null() ? nullptr : urls_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->urls.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null urls in ShoppingServiceHandler.GetProductSpecificationsForUrls request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ShoppingServiceHandler::Name_);
  message.set_method_name("GetProductSpecificationsForUrls");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ShoppingServiceHandler_GetProductSpecificationsForUrls_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ShoppingServiceHandlerProxy::GetUrlInfosForProductTabs(
    GetUrlInfosForProductTabsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send shopping_service::mojom::ShoppingServiceHandler::GetUrlInfosForProductTabs");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ShoppingServiceHandler::kGetUrlInfosForProductTabs), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::shopping_service::mojom::internal::ShoppingServiceHandler_GetUrlInfosForProductTabs_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ShoppingServiceHandler::Name_);
  message.set_method_name("GetUrlInfosForProductTabs");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ShoppingServiceHandler_GetUrlInfosForProductTabs_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ShoppingServiceHandlerProxy::GetUrlInfosForRecentlyViewedTabs(
    GetUrlInfosForRecentlyViewedTabsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send shopping_service::mojom::ShoppingServiceHandler::GetUrlInfosForRecentlyViewedTabs");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ShoppingServiceHandler::kGetUrlInfosForRecentlyViewedTabs), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::shopping_service::mojom::internal::ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ShoppingServiceHandler::Name_);
  message.set_method_name("GetUrlInfosForRecentlyViewedTabs");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ShoppingServiceHandlerProxy::IsShoppingListEligible(
    IsShoppingListEligibleCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send shopping_service::mojom::ShoppingServiceHandler::IsShoppingListEligible");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ShoppingServiceHandler::kIsShoppingListEligible), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::shopping_service::mojom::internal::ShoppingServiceHandler_IsShoppingListEligible_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ShoppingServiceHandler::Name_);
  message.set_method_name("IsShoppingListEligible");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ShoppingServiceHandler_IsShoppingListEligible_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ShoppingServiceHandlerProxy::GetPriceTrackingStatusForCurrentUrl(
    GetPriceTrackingStatusForCurrentUrlCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send shopping_service::mojom::ShoppingServiceHandler::GetPriceTrackingStatusForCurrentUrl");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ShoppingServiceHandler::kGetPriceTrackingStatusForCurrentUrl), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::shopping_service::mojom::internal::ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ShoppingServiceHandler::Name_);
  message.set_method_name("GetPriceTrackingStatusForCurrentUrl");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ShoppingServiceHandlerProxy::OpenUrlInNewTab(
    const ::GURL& in_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send shopping_service::mojom::ShoppingServiceHandler::OpenUrlInNewTab", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ShoppingServiceHandler::kOpenUrlInNewTab), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::shopping_service::mojom::internal::ShoppingServiceHandler_OpenUrlInNewTab_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in ShoppingServiceHandler.OpenUrlInNewTab request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ShoppingServiceHandler::Name_);
  message.set_method_name("OpenUrlInNewTab");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ShoppingServiceHandlerProxy::SwitchToOrOpenTab(
    const ::GURL& in_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send shopping_service::mojom::ShoppingServiceHandler::SwitchToOrOpenTab", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ShoppingServiceHandler::kSwitchToOrOpenTab), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::shopping_service::mojom::internal::ShoppingServiceHandler_SwitchToOrOpenTab_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in ShoppingServiceHandler.SwitchToOrOpenTab request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ShoppingServiceHandler::Name_);
  message.set_method_name("SwitchToOrOpenTab");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ShoppingServiceHandlerProxy::GetAllProductSpecificationsSets(
    GetAllProductSpecificationsSetsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send shopping_service::mojom::ShoppingServiceHandler::GetAllProductSpecificationsSets");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ShoppingServiceHandler::kGetAllProductSpecificationsSets), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::shopping_service::mojom::internal::ShoppingServiceHandler_GetAllProductSpecificationsSets_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ShoppingServiceHandler::Name_);
  message.set_method_name("GetAllProductSpecificationsSets");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ShoppingServiceHandler_GetAllProductSpecificationsSets_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ShoppingServiceHandlerProxy::GetProductSpecificationsSetByUuid(
    const ::base::Uuid& in_uuid, GetProductSpecificationsSetByUuidCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send shopping_service::mojom::ShoppingServiceHandler::GetProductSpecificationsSetByUuid", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("uuid"), in_uuid,
                        "<value of type const ::base::Uuid&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ShoppingServiceHandler::kGetProductSpecificationsSetByUuid), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::shopping_service::mojom::internal::ShoppingServiceHandler_GetProductSpecificationsSetByUuid_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->uuid)::BaseType> uuid_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UuidDataView>(
    in_uuid,
    uuid_fragment);

  params->uuid.Set(
      uuid_fragment.is_null() ? nullptr : uuid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->uuid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null uuid in ShoppingServiceHandler.GetProductSpecificationsSetByUuid request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ShoppingServiceHandler::Name_);
  message.set_method_name("GetProductSpecificationsSetByUuid");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ShoppingServiceHandler_GetProductSpecificationsSetByUuid_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ShoppingServiceHandlerProxy::AddProductSpecificationsSet(
    const std::string& in_name, const std::vector<::GURL>& in_urls, AddProductSpecificationsSetCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send shopping_service::mojom::ShoppingServiceHandler::AddProductSpecificationsSet", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("name"), in_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("urls"), in_urls,
                        "<value of type const std::vector<::GURL>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ShoppingServiceHandler::kAddProductSpecificationsSet), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::shopping_service::mojom::internal::ShoppingServiceHandler_AddProductSpecificationsSet_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->name)::BaseType> name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_name,
    name_fragment);

  params->name.Set(
      name_fragment.is_null() ? nullptr : name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null name in ShoppingServiceHandler.AddProductSpecificationsSet request");
  mojo::internal::MessageFragment<
      typename decltype(params->urls)::BaseType>
      urls_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& urls_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
    in_urls,
    urls_fragment,
    &urls_validate_params);

  params->urls.Set(
      urls_fragment.is_null() ? nullptr : urls_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->urls.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null urls in ShoppingServiceHandler.AddProductSpecificationsSet request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ShoppingServiceHandler::Name_);
  message.set_method_name("AddProductSpecificationsSet");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ShoppingServiceHandler_AddProductSpecificationsSet_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ShoppingServiceHandlerProxy::DeleteProductSpecificationsSet(
    const ::base::Uuid& in_uuid) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send shopping_service::mojom::ShoppingServiceHandler::DeleteProductSpecificationsSet", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("uuid"), in_uuid,
                        "<value of type const ::base::Uuid&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ShoppingServiceHandler::kDeleteProductSpecificationsSet), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::shopping_service::mojom::internal::ShoppingServiceHandler_DeleteProductSpecificationsSet_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->uuid)::BaseType> uuid_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UuidDataView>(
    in_uuid,
    uuid_fragment);

  params->uuid.Set(
      uuid_fragment.is_null() ? nullptr : uuid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->uuid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null uuid in ShoppingServiceHandler.DeleteProductSpecificationsSet request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ShoppingServiceHandler::Name_);
  message.set_method_name("DeleteProductSpecificationsSet");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ShoppingServiceHandlerProxy::SetNameForProductSpecificationsSet(
    const ::base::Uuid& in_uuid, const std::string& in_name, SetNameForProductSpecificationsSetCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send shopping_service::mojom::ShoppingServiceHandler::SetNameForProductSpecificationsSet", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("uuid"), in_uuid,
                        "<value of type const ::base::Uuid&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("name"), in_name,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ShoppingServiceHandler::kSetNameForProductSpecificationsSet), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::shopping_service::mojom::internal::ShoppingServiceHandler_SetNameForProductSpecificationsSet_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->uuid)::BaseType> uuid_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UuidDataView>(
    in_uuid,
    uuid_fragment);

  params->uuid.Set(
      uuid_fragment.is_null() ? nullptr : uuid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->uuid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null uuid in ShoppingServiceHandler.SetNameForProductSpecificationsSet request");
  mojo::internal::MessageFragment<
      typename decltype(params->name)::BaseType> name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_name,
    name_fragment);

  params->name.Set(
      name_fragment.is_null() ? nullptr : name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null name in ShoppingServiceHandler.SetNameForProductSpecificationsSet request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ShoppingServiceHandler::Name_);
  message.set_method_name("SetNameForProductSpecificationsSet");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ShoppingServiceHandler_SetNameForProductSpecificationsSet_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ShoppingServiceHandlerProxy::SetUrlsForProductSpecificationsSet(
    const ::base::Uuid& in_uuid, const std::vector<::GURL>& in_urls, SetUrlsForProductSpecificationsSetCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send shopping_service::mojom::ShoppingServiceHandler::SetUrlsForProductSpecificationsSet", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("uuid"), in_uuid,
                        "<value of type const ::base::Uuid&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("urls"), in_urls,
                        "<value of type const std::vector<::GURL>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ShoppingServiceHandler::kSetUrlsForProductSpecificationsSet), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::shopping_service::mojom::internal::ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->uuid)::BaseType> uuid_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UuidDataView>(
    in_uuid,
    uuid_fragment);

  params->uuid.Set(
      uuid_fragment.is_null() ? nullptr : uuid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->uuid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null uuid in ShoppingServiceHandler.SetUrlsForProductSpecificationsSet request");
  mojo::internal::MessageFragment<
      typename decltype(params->urls)::BaseType>
      urls_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& urls_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
    in_urls,
    urls_fragment,
    &urls_validate_params);

  params->urls.Set(
      urls_fragment.is_null() ? nullptr : urls_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->urls.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null urls in ShoppingServiceHandler.SetUrlsForProductSpecificationsSet request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ShoppingServiceHandler::Name_);
  message.set_method_name("SetUrlsForProductSpecificationsSet");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ShoppingServiceHandlerProxy::SetProductSpecificationsUserFeedback(
    UserFeedback in_feedback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send shopping_service::mojom::ShoppingServiceHandler::SetProductSpecificationsUserFeedback", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("feedback"), in_feedback,
                        "<value of type UserFeedback>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ShoppingServiceHandler::kSetProductSpecificationsUserFeedback), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::shopping_service::mojom::internal::ShoppingServiceHandler_SetProductSpecificationsUserFeedback_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::shopping_service::mojom::UserFeedback>(
    in_feedback,
    &params->feedback);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ShoppingServiceHandler::Name_);
  message.set_method_name("SetProductSpecificationsUserFeedback");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ShoppingServiceHandlerProxy::GetProductSpecificationsFeatureState(
    GetProductSpecificationsFeatureStateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send shopping_service::mojom::ShoppingServiceHandler::GetProductSpecificationsFeatureState");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ShoppingServiceHandler::kGetProductSpecificationsFeatureState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::shopping_service::mojom::internal::ShoppingServiceHandler_GetProductSpecificationsFeatureState_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ShoppingServiceHandler::Name_);
  message.set_method_name("GetProductSpecificationsFeatureState");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ShoppingServiceHandler_GetProductSpecificationsFeatureState_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class ShoppingServiceHandler_GetProductInfoForCurrentUrl_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ShoppingServiceHandler::GetProductInfoForCurrentUrlCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ShoppingServiceHandler_GetProductInfoForCurrentUrl_ProxyToResponder> proxy(
        new ShoppingServiceHandler_GetProductInfoForCurrentUrl_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ShoppingServiceHandler_GetProductInfoForCurrentUrl_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ShoppingServiceHandler_GetProductInfoForCurrentUrl_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ShoppingServiceHandler_GetProductInfoForCurrentUrl_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ShoppingServiceHandler::GetProductInfoForCurrentUrlCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::commerce::shared::mojom::ProductInfoPtr in_productInfo);
};

bool ShoppingServiceHandler_GetProductInfoForCurrentUrl_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ShoppingServiceHandler_GetProductInfoForCurrentUrl_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ShoppingServiceHandler_GetProductInfoForCurrentUrl_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ShoppingServiceHandler.0
  bool success = true;
  ::commerce::shared::mojom::ProductInfoPtr p_productInfo{};
  ShoppingServiceHandler_GetProductInfoForCurrentUrl_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadProductInfo(&p_productInfo))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ShoppingServiceHandler::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_productInfo));
  }
  return true;
}

void ShoppingServiceHandler_GetProductInfoForCurrentUrl_ProxyToResponder::Run(
    ::commerce::shared::mojom::ProductInfoPtr in_productInfo) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply shopping_service::mojom::ShoppingServiceHandler::GetProductInfoForCurrentUrl", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("productInfo"), in_productInfo,
                        "<value of type ::commerce::shared::mojom::ProductInfoPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ShoppingServiceHandler::kGetProductInfoForCurrentUrl), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::shopping_service::mojom::internal::ShoppingServiceHandler_GetProductInfoForCurrentUrl_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->productInfo)::BaseType> productInfo_fragment(
          params.message());
  
  mojo::internal::Serialize<::commerce::shared::mojom::ProductInfoDataView>(
    in_productInfo,
    productInfo_fragment);

  params->productInfo.Set(
      productInfo_fragment.is_null() ? nullptr : productInfo_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->productInfo.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null productInfo in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ShoppingServiceHandler::Name_);
  message.set_method_name("GetProductInfoForCurrentUrl");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ShoppingServiceHandler_GetProductInfoForUrl_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ShoppingServiceHandler::GetProductInfoForUrlCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ShoppingServiceHandler_GetProductInfoForUrl_ProxyToResponder> proxy(
        new ShoppingServiceHandler_GetProductInfoForUrl_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ShoppingServiceHandler_GetProductInfoForUrl_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ShoppingServiceHandler_GetProductInfoForUrl_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ShoppingServiceHandler_GetProductInfoForUrl_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ShoppingServiceHandler::GetProductInfoForUrlCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::GURL& in_url, ::commerce::shared::mojom::ProductInfoPtr in_productInfo);
};

bool ShoppingServiceHandler_GetProductInfoForUrl_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ShoppingServiceHandler_GetProductInfoForUrl_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ShoppingServiceHandler_GetProductInfoForUrl_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ShoppingServiceHandler.1
  bool success = true;
  ::GURL p_url{};
  ::commerce::shared::mojom::ProductInfoPtr p_productInfo{};
  ShoppingServiceHandler_GetProductInfoForUrl_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadUrl(&p_url))
    success = false;
  if (success && !input_data_view.ReadProductInfo(&p_productInfo))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ShoppingServiceHandler::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_url), 
std::move(p_productInfo));
  }
  return true;
}

void ShoppingServiceHandler_GetProductInfoForUrl_ProxyToResponder::Run(
    const ::GURL& in_url, ::commerce::shared::mojom::ProductInfoPtr in_productInfo) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply shopping_service::mojom::ShoppingServiceHandler::GetProductInfoForUrl", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("productInfo"), in_productInfo,
                        "<value of type ::commerce::shared::mojom::ProductInfoPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ShoppingServiceHandler::kGetProductInfoForUrl), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::shopping_service::mojom::internal::ShoppingServiceHandler_GetProductInfoForUrl_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in ");
  mojo::internal::MessageFragment<
      typename decltype(params->productInfo)::BaseType> productInfo_fragment(
          params.message());
  
  mojo::internal::Serialize<::commerce::shared::mojom::ProductInfoDataView>(
    in_productInfo,
    productInfo_fragment);

  params->productInfo.Set(
      productInfo_fragment.is_null() ? nullptr : productInfo_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->productInfo.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null productInfo in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ShoppingServiceHandler::Name_);
  message.set_method_name("GetProductInfoForUrl");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ShoppingServiceHandler_GetProductInfoForUrls_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ShoppingServiceHandler::GetProductInfoForUrlsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ShoppingServiceHandler_GetProductInfoForUrls_ProxyToResponder> proxy(
        new ShoppingServiceHandler_GetProductInfoForUrls_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ShoppingServiceHandler_GetProductInfoForUrls_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ShoppingServiceHandler_GetProductInfoForUrls_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ShoppingServiceHandler_GetProductInfoForUrls_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ShoppingServiceHandler::GetProductInfoForUrlsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<::commerce::shared::mojom::ProductInfoPtr> in_productInfos);
};

bool ShoppingServiceHandler_GetProductInfoForUrls_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ShoppingServiceHandler_GetProductInfoForUrls_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ShoppingServiceHandler_GetProductInfoForUrls_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ShoppingServiceHandler.2
  bool success = true;
  std::vector<::commerce::shared::mojom::ProductInfoPtr> p_productInfos{};
  ShoppingServiceHandler_GetProductInfoForUrls_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadProductInfos(&p_productInfos))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ShoppingServiceHandler::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_productInfos));
  }
  return true;
}

void ShoppingServiceHandler_GetProductInfoForUrls_ProxyToResponder::Run(
    std::vector<::commerce::shared::mojom::ProductInfoPtr> in_productInfos) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply shopping_service::mojom::ShoppingServiceHandler::GetProductInfoForUrls", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("productInfos"), in_productInfos,
                        "<value of type std::vector<::commerce::shared::mojom::ProductInfoPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ShoppingServiceHandler::kGetProductInfoForUrls), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::shopping_service::mojom::internal::ShoppingServiceHandler_GetProductInfoForUrls_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->productInfos)::BaseType>
      productInfos_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& productInfos_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::commerce::shared::mojom::ProductInfoDataView>>(
    in_productInfos,
    productInfos_fragment,
    &productInfos_validate_params);

  params->productInfos.Set(
      productInfos_fragment.is_null() ? nullptr : productInfos_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->productInfos.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null productInfos in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ShoppingServiceHandler::Name_);
  message.set_method_name("GetProductInfoForUrls");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ShoppingServiceHandler::GetPriceInsightsInfoForCurrentUrlCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_ProxyToResponder> proxy(
        new ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ShoppingServiceHandler::GetPriceInsightsInfoForCurrentUrlCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      PriceInsightsInfoPtr in_priceInsightsInfo);
};

bool ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ShoppingServiceHandler.3
  bool success = true;
  PriceInsightsInfoPtr p_priceInsightsInfo{};
  ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadPriceInsightsInfo(&p_priceInsightsInfo))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ShoppingServiceHandler::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_priceInsightsInfo));
  }
  return true;
}

void ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_ProxyToResponder::Run(
    PriceInsightsInfoPtr in_priceInsightsInfo) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply shopping_service::mojom::ShoppingServiceHandler::GetPriceInsightsInfoForCurrentUrl", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("priceInsightsInfo"), in_priceInsightsInfo,
                        "<value of type PriceInsightsInfoPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ShoppingServiceHandler::kGetPriceInsightsInfoForCurrentUrl), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::shopping_service::mojom::internal::ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->priceInsightsInfo)::BaseType> priceInsightsInfo_fragment(
          params.message());
  
  mojo::internal::Serialize<::shopping_service::mojom::PriceInsightsInfoDataView>(
    in_priceInsightsInfo,
    priceInsightsInfo_fragment);

  params->priceInsightsInfo.Set(
      priceInsightsInfo_fragment.is_null() ? nullptr : priceInsightsInfo_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->priceInsightsInfo.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null priceInsightsInfo in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ShoppingServiceHandler::Name_);
  message.set_method_name("GetPriceInsightsInfoForCurrentUrl");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ShoppingServiceHandler_GetPriceInsightsInfoForUrl_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ShoppingServiceHandler::GetPriceInsightsInfoForUrlCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ShoppingServiceHandler_GetPriceInsightsInfoForUrl_ProxyToResponder> proxy(
        new ShoppingServiceHandler_GetPriceInsightsInfoForUrl_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ShoppingServiceHandler_GetPriceInsightsInfoForUrl_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ShoppingServiceHandler_GetPriceInsightsInfoForUrl_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ShoppingServiceHandler_GetPriceInsightsInfoForUrl_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ShoppingServiceHandler::GetPriceInsightsInfoForUrlCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::GURL& in_url, PriceInsightsInfoPtr in_priceInsightsInfo);
};

bool ShoppingServiceHandler_GetPriceInsightsInfoForUrl_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ShoppingServiceHandler_GetPriceInsightsInfoForUrl_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ShoppingServiceHandler_GetPriceInsightsInfoForUrl_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ShoppingServiceHandler.4
  bool success = true;
  ::GURL p_url{};
  PriceInsightsInfoPtr p_priceInsightsInfo{};
  ShoppingServiceHandler_GetPriceInsightsInfoForUrl_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadUrl(&p_url))
    success = false;
  if (success && !input_data_view.ReadPriceInsightsInfo(&p_priceInsightsInfo))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ShoppingServiceHandler::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_url), 
std::move(p_priceInsightsInfo));
  }
  return true;
}

void ShoppingServiceHandler_GetPriceInsightsInfoForUrl_ProxyToResponder::Run(
    const ::GURL& in_url, PriceInsightsInfoPtr in_priceInsightsInfo) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply shopping_service::mojom::ShoppingServiceHandler::GetPriceInsightsInfoForUrl", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("priceInsightsInfo"), in_priceInsightsInfo,
                        "<value of type PriceInsightsInfoPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ShoppingServiceHandler::kGetPriceInsightsInfoForUrl), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::shopping_service::mojom::internal::ShoppingServiceHandler_GetPriceInsightsInfoForUrl_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in ");
  mojo::internal::MessageFragment<
      typename decltype(params->priceInsightsInfo)::BaseType> priceInsightsInfo_fragment(
          params.message());
  
  mojo::internal::Serialize<::shopping_service::mojom::PriceInsightsInfoDataView>(
    in_priceInsightsInfo,
    priceInsightsInfo_fragment);

  params->priceInsightsInfo.Set(
      priceInsightsInfo_fragment.is_null() ? nullptr : priceInsightsInfo_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->priceInsightsInfo.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null priceInsightsInfo in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ShoppingServiceHandler::Name_);
  message.set_method_name("GetPriceInsightsInfoForUrl");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ShoppingServiceHandler_GetProductSpecificationsForUrls_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ShoppingServiceHandler::GetProductSpecificationsForUrlsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ShoppingServiceHandler_GetProductSpecificationsForUrls_ProxyToResponder> proxy(
        new ShoppingServiceHandler_GetProductSpecificationsForUrls_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ShoppingServiceHandler_GetProductSpecificationsForUrls_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ShoppingServiceHandler_GetProductSpecificationsForUrls_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ShoppingServiceHandler_GetProductSpecificationsForUrls_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ShoppingServiceHandler::GetProductSpecificationsForUrlsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ProductSpecificationsPtr in_productSpecs);
};

bool ShoppingServiceHandler_GetProductSpecificationsForUrls_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ShoppingServiceHandler_GetProductSpecificationsForUrls_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ShoppingServiceHandler_GetProductSpecificationsForUrls_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ShoppingServiceHandler.5
  bool success = true;
  ProductSpecificationsPtr p_productSpecs{};
  ShoppingServiceHandler_GetProductSpecificationsForUrls_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadProductSpecs(&p_productSpecs))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ShoppingServiceHandler::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_productSpecs));
  }
  return true;
}

void ShoppingServiceHandler_GetProductSpecificationsForUrls_ProxyToResponder::Run(
    ProductSpecificationsPtr in_productSpecs) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply shopping_service::mojom::ShoppingServiceHandler::GetProductSpecificationsForUrls", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("productSpecs"), in_productSpecs,
                        "<value of type ProductSpecificationsPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ShoppingServiceHandler::kGetProductSpecificationsForUrls), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::shopping_service::mojom::internal::ShoppingServiceHandler_GetProductSpecificationsForUrls_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->productSpecs)::BaseType> productSpecs_fragment(
          params.message());
  
  mojo::internal::Serialize<::shopping_service::mojom::ProductSpecificationsDataView>(
    in_productSpecs,
    productSpecs_fragment);

  params->productSpecs.Set(
      productSpecs_fragment.is_null() ? nullptr : productSpecs_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->productSpecs.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null productSpecs in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ShoppingServiceHandler::Name_);
  message.set_method_name("GetProductSpecificationsForUrls");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ShoppingServiceHandler_GetUrlInfosForProductTabs_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ShoppingServiceHandler::GetUrlInfosForProductTabsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ShoppingServiceHandler_GetUrlInfosForProductTabs_ProxyToResponder> proxy(
        new ShoppingServiceHandler_GetUrlInfosForProductTabs_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ShoppingServiceHandler_GetUrlInfosForProductTabs_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ShoppingServiceHandler_GetUrlInfosForProductTabs_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ShoppingServiceHandler_GetUrlInfosForProductTabs_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ShoppingServiceHandler::GetUrlInfosForProductTabsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<UrlInfoPtr> in_url_infos);
};

bool ShoppingServiceHandler_GetUrlInfosForProductTabs_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ShoppingServiceHandler_GetUrlInfosForProductTabs_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ShoppingServiceHandler_GetUrlInfosForProductTabs_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ShoppingServiceHandler.6
  bool success = true;
  std::vector<UrlInfoPtr> p_url_infos{};
  ShoppingServiceHandler_GetUrlInfosForProductTabs_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadUrlInfos(&p_url_infos))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ShoppingServiceHandler::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_url_infos));
  }
  return true;
}

void ShoppingServiceHandler_GetUrlInfosForProductTabs_ProxyToResponder::Run(
    std::vector<UrlInfoPtr> in_url_infos) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply shopping_service::mojom::ShoppingServiceHandler::GetUrlInfosForProductTabs", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url_infos"), in_url_infos,
                        "<value of type std::vector<UrlInfoPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ShoppingServiceHandler::kGetUrlInfosForProductTabs), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::shopping_service::mojom::internal::ShoppingServiceHandler_GetUrlInfosForProductTabs_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url_infos)::BaseType>
      url_infos_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& url_infos_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::shopping_service::mojom::UrlInfoDataView>>(
    in_url_infos,
    url_infos_fragment,
    &url_infos_validate_params);

  params->url_infos.Set(
      url_infos_fragment.is_null() ? nullptr : url_infos_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url_infos.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url_infos in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ShoppingServiceHandler::Name_);
  message.set_method_name("GetUrlInfosForProductTabs");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ShoppingServiceHandler::GetUrlInfosForRecentlyViewedTabsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_ProxyToResponder> proxy(
        new ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ShoppingServiceHandler::GetUrlInfosForRecentlyViewedTabsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<UrlInfoPtr> in_url_infos);
};

bool ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ShoppingServiceHandler.7
  bool success = true;
  std::vector<UrlInfoPtr> p_url_infos{};
  ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadUrlInfos(&p_url_infos))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ShoppingServiceHandler::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_url_infos));
  }
  return true;
}

void ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_ProxyToResponder::Run(
    std::vector<UrlInfoPtr> in_url_infos) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply shopping_service::mojom::ShoppingServiceHandler::GetUrlInfosForRecentlyViewedTabs", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url_infos"), in_url_infos,
                        "<value of type std::vector<UrlInfoPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ShoppingServiceHandler::kGetUrlInfosForRecentlyViewedTabs), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::shopping_service::mojom::internal::ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url_infos)::BaseType>
      url_infos_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& url_infos_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::shopping_service::mojom::UrlInfoDataView>>(
    in_url_infos,
    url_infos_fragment,
    &url_infos_validate_params);

  params->url_infos.Set(
      url_infos_fragment.is_null() ? nullptr : url_infos_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url_infos.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url_infos in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ShoppingServiceHandler::Name_);
  message.set_method_name("GetUrlInfosForRecentlyViewedTabs");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ShoppingServiceHandler_IsShoppingListEligible_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ShoppingServiceHandler::IsShoppingListEligibleCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ShoppingServiceHandler_IsShoppingListEligible_ProxyToResponder> proxy(
        new ShoppingServiceHandler_IsShoppingListEligible_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ShoppingServiceHandler_IsShoppingListEligible_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ShoppingServiceHandler_IsShoppingListEligible_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ShoppingServiceHandler_IsShoppingListEligible_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ShoppingServiceHandler::IsShoppingListEligibleCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_eligible);
};

bool ShoppingServiceHandler_IsShoppingListEligible_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ShoppingServiceHandler_IsShoppingListEligible_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ShoppingServiceHandler_IsShoppingListEligible_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ShoppingServiceHandler.8
  bool success = true;
  bool p_eligible{};
  ShoppingServiceHandler_IsShoppingListEligible_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_eligible = input_data_view.eligible();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ShoppingServiceHandler::Name_, 8, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_eligible));
  }
  return true;
}

void ShoppingServiceHandler_IsShoppingListEligible_ProxyToResponder::Run(
    bool in_eligible) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply shopping_service::mojom::ShoppingServiceHandler::IsShoppingListEligible", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("eligible"), in_eligible,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ShoppingServiceHandler::kIsShoppingListEligible), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::shopping_service::mojom::internal::ShoppingServiceHandler_IsShoppingListEligible_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->eligible = in_eligible;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ShoppingServiceHandler::Name_);
  message.set_method_name("IsShoppingListEligible");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ShoppingServiceHandler::GetPriceTrackingStatusForCurrentUrlCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_ProxyToResponder> proxy(
        new ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ShoppingServiceHandler::GetPriceTrackingStatusForCurrentUrlCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_tracked);
};

bool ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ShoppingServiceHandler.9
  bool success = true;
  bool p_tracked{};
  ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_tracked = input_data_view.tracked();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ShoppingServiceHandler::Name_, 9, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_tracked));
  }
  return true;
}

void ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_ProxyToResponder::Run(
    bool in_tracked) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply shopping_service::mojom::ShoppingServiceHandler::GetPriceTrackingStatusForCurrentUrl", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tracked"), in_tracked,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ShoppingServiceHandler::kGetPriceTrackingStatusForCurrentUrl), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::shopping_service::mojom::internal::ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->tracked = in_tracked;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ShoppingServiceHandler::Name_);
  message.set_method_name("GetPriceTrackingStatusForCurrentUrl");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ShoppingServiceHandler_GetAllProductSpecificationsSets_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ShoppingServiceHandler::GetAllProductSpecificationsSetsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ShoppingServiceHandler_GetAllProductSpecificationsSets_ProxyToResponder> proxy(
        new ShoppingServiceHandler_GetAllProductSpecificationsSets_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ShoppingServiceHandler_GetAllProductSpecificationsSets_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ShoppingServiceHandler_GetAllProductSpecificationsSets_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ShoppingServiceHandler_GetAllProductSpecificationsSets_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ShoppingServiceHandler::GetAllProductSpecificationsSetsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<::commerce::shared::mojom::ProductSpecificationsSetPtr> in_sets);
};

bool ShoppingServiceHandler_GetAllProductSpecificationsSets_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ShoppingServiceHandler_GetAllProductSpecificationsSets_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ShoppingServiceHandler_GetAllProductSpecificationsSets_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ShoppingServiceHandler.12
  bool success = true;
  std::vector<::commerce::shared::mojom::ProductSpecificationsSetPtr> p_sets{};
  ShoppingServiceHandler_GetAllProductSpecificationsSets_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadSets(&p_sets))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ShoppingServiceHandler::Name_, 12, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_sets));
  }
  return true;
}

void ShoppingServiceHandler_GetAllProductSpecificationsSets_ProxyToResponder::Run(
    std::vector<::commerce::shared::mojom::ProductSpecificationsSetPtr> in_sets) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply shopping_service::mojom::ShoppingServiceHandler::GetAllProductSpecificationsSets", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sets"), in_sets,
                        "<value of type std::vector<::commerce::shared::mojom::ProductSpecificationsSetPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ShoppingServiceHandler::kGetAllProductSpecificationsSets), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::shopping_service::mojom::internal::ShoppingServiceHandler_GetAllProductSpecificationsSets_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->sets)::BaseType>
      sets_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& sets_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::commerce::shared::mojom::ProductSpecificationsSetDataView>>(
    in_sets,
    sets_fragment,
    &sets_validate_params);

  params->sets.Set(
      sets_fragment.is_null() ? nullptr : sets_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->sets.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null sets in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ShoppingServiceHandler::Name_);
  message.set_method_name("GetAllProductSpecificationsSets");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ShoppingServiceHandler_GetProductSpecificationsSetByUuid_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ShoppingServiceHandler::GetProductSpecificationsSetByUuidCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ShoppingServiceHandler_GetProductSpecificationsSetByUuid_ProxyToResponder> proxy(
        new ShoppingServiceHandler_GetProductSpecificationsSetByUuid_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ShoppingServiceHandler_GetProductSpecificationsSetByUuid_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ShoppingServiceHandler_GetProductSpecificationsSetByUuid_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ShoppingServiceHandler_GetProductSpecificationsSetByUuid_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ShoppingServiceHandler::GetProductSpecificationsSetByUuidCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::commerce::shared::mojom::ProductSpecificationsSetPtr in_set);
};

bool ShoppingServiceHandler_GetProductSpecificationsSetByUuid_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ShoppingServiceHandler_GetProductSpecificationsSetByUuid_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ShoppingServiceHandler_GetProductSpecificationsSetByUuid_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ShoppingServiceHandler.13
  bool success = true;
  ::commerce::shared::mojom::ProductSpecificationsSetPtr p_set{};
  ShoppingServiceHandler_GetProductSpecificationsSetByUuid_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadSet(&p_set))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ShoppingServiceHandler::Name_, 13, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_set));
  }
  return true;
}

void ShoppingServiceHandler_GetProductSpecificationsSetByUuid_ProxyToResponder::Run(
    ::commerce::shared::mojom::ProductSpecificationsSetPtr in_set) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply shopping_service::mojom::ShoppingServiceHandler::GetProductSpecificationsSetByUuid", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("set"), in_set,
                        "<value of type ::commerce::shared::mojom::ProductSpecificationsSetPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ShoppingServiceHandler::kGetProductSpecificationsSetByUuid), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::shopping_service::mojom::internal::ShoppingServiceHandler_GetProductSpecificationsSetByUuid_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->set)::BaseType> set_fragment(
          params.message());
  
  mojo::internal::Serialize<::commerce::shared::mojom::ProductSpecificationsSetDataView>(
    in_set,
    set_fragment);

  params->set.Set(
      set_fragment.is_null() ? nullptr : set_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ShoppingServiceHandler::Name_);
  message.set_method_name("GetProductSpecificationsSetByUuid");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ShoppingServiceHandler_AddProductSpecificationsSet_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ShoppingServiceHandler::AddProductSpecificationsSetCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ShoppingServiceHandler_AddProductSpecificationsSet_ProxyToResponder> proxy(
        new ShoppingServiceHandler_AddProductSpecificationsSet_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ShoppingServiceHandler_AddProductSpecificationsSet_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ShoppingServiceHandler_AddProductSpecificationsSet_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ShoppingServiceHandler_AddProductSpecificationsSet_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ShoppingServiceHandler::AddProductSpecificationsSetCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::commerce::shared::mojom::ProductSpecificationsSetPtr in_created_set);
};

bool ShoppingServiceHandler_AddProductSpecificationsSet_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ShoppingServiceHandler_AddProductSpecificationsSet_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ShoppingServiceHandler_AddProductSpecificationsSet_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ShoppingServiceHandler.14
  bool success = true;
  ::commerce::shared::mojom::ProductSpecificationsSetPtr p_created_set{};
  ShoppingServiceHandler_AddProductSpecificationsSet_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadCreatedSet(&p_created_set))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ShoppingServiceHandler::Name_, 14, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_created_set));
  }
  return true;
}

void ShoppingServiceHandler_AddProductSpecificationsSet_ProxyToResponder::Run(
    ::commerce::shared::mojom::ProductSpecificationsSetPtr in_created_set) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply shopping_service::mojom::ShoppingServiceHandler::AddProductSpecificationsSet", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("created_set"), in_created_set,
                        "<value of type ::commerce::shared::mojom::ProductSpecificationsSetPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ShoppingServiceHandler::kAddProductSpecificationsSet), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::shopping_service::mojom::internal::ShoppingServiceHandler_AddProductSpecificationsSet_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->created_set)::BaseType> created_set_fragment(
          params.message());
  
  mojo::internal::Serialize<::commerce::shared::mojom::ProductSpecificationsSetDataView>(
    in_created_set,
    created_set_fragment);

  params->created_set.Set(
      created_set_fragment.is_null() ? nullptr : created_set_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ShoppingServiceHandler::Name_);
  message.set_method_name("AddProductSpecificationsSet");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ShoppingServiceHandler_SetNameForProductSpecificationsSet_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ShoppingServiceHandler::SetNameForProductSpecificationsSetCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ShoppingServiceHandler_SetNameForProductSpecificationsSet_ProxyToResponder> proxy(
        new ShoppingServiceHandler_SetNameForProductSpecificationsSet_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ShoppingServiceHandler_SetNameForProductSpecificationsSet_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ShoppingServiceHandler_SetNameForProductSpecificationsSet_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ShoppingServiceHandler_SetNameForProductSpecificationsSet_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ShoppingServiceHandler::SetNameForProductSpecificationsSetCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::commerce::shared::mojom::ProductSpecificationsSetPtr in_updated_set);
};

bool ShoppingServiceHandler_SetNameForProductSpecificationsSet_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ShoppingServiceHandler_SetNameForProductSpecificationsSet_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ShoppingServiceHandler_SetNameForProductSpecificationsSet_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ShoppingServiceHandler.16
  bool success = true;
  ::commerce::shared::mojom::ProductSpecificationsSetPtr p_updated_set{};
  ShoppingServiceHandler_SetNameForProductSpecificationsSet_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadUpdatedSet(&p_updated_set))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ShoppingServiceHandler::Name_, 16, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_updated_set));
  }
  return true;
}

void ShoppingServiceHandler_SetNameForProductSpecificationsSet_ProxyToResponder::Run(
    ::commerce::shared::mojom::ProductSpecificationsSetPtr in_updated_set) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply shopping_service::mojom::ShoppingServiceHandler::SetNameForProductSpecificationsSet", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("updated_set"), in_updated_set,
                        "<value of type ::commerce::shared::mojom::ProductSpecificationsSetPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ShoppingServiceHandler::kSetNameForProductSpecificationsSet), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::shopping_service::mojom::internal::ShoppingServiceHandler_SetNameForProductSpecificationsSet_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->updated_set)::BaseType> updated_set_fragment(
          params.message());
  
  mojo::internal::Serialize<::commerce::shared::mojom::ProductSpecificationsSetDataView>(
    in_updated_set,
    updated_set_fragment);

  params->updated_set.Set(
      updated_set_fragment.is_null() ? nullptr : updated_set_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ShoppingServiceHandler::Name_);
  message.set_method_name("SetNameForProductSpecificationsSet");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ShoppingServiceHandler::SetUrlsForProductSpecificationsSetCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_ProxyToResponder> proxy(
        new ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ShoppingServiceHandler::SetUrlsForProductSpecificationsSetCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::commerce::shared::mojom::ProductSpecificationsSetPtr in_updated_set);
};

bool ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ShoppingServiceHandler.17
  bool success = true;
  ::commerce::shared::mojom::ProductSpecificationsSetPtr p_updated_set{};
  ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadUpdatedSet(&p_updated_set))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ShoppingServiceHandler::Name_, 17, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_updated_set));
  }
  return true;
}

void ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_ProxyToResponder::Run(
    ::commerce::shared::mojom::ProductSpecificationsSetPtr in_updated_set) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply shopping_service::mojom::ShoppingServiceHandler::SetUrlsForProductSpecificationsSet", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("updated_set"), in_updated_set,
                        "<value of type ::commerce::shared::mojom::ProductSpecificationsSetPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ShoppingServiceHandler::kSetUrlsForProductSpecificationsSet), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::shopping_service::mojom::internal::ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->updated_set)::BaseType> updated_set_fragment(
          params.message());
  
  mojo::internal::Serialize<::commerce::shared::mojom::ProductSpecificationsSetDataView>(
    in_updated_set,
    updated_set_fragment);

  params->updated_set.Set(
      updated_set_fragment.is_null() ? nullptr : updated_set_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ShoppingServiceHandler::Name_);
  message.set_method_name("SetUrlsForProductSpecificationsSet");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ShoppingServiceHandler_GetProductSpecificationsFeatureState_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ShoppingServiceHandler::GetProductSpecificationsFeatureStateCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ShoppingServiceHandler_GetProductSpecificationsFeatureState_ProxyToResponder> proxy(
        new ShoppingServiceHandler_GetProductSpecificationsFeatureState_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ShoppingServiceHandler_GetProductSpecificationsFeatureState_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ShoppingServiceHandler_GetProductSpecificationsFeatureState_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ShoppingServiceHandler_GetProductSpecificationsFeatureState_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ShoppingServiceHandler::GetProductSpecificationsFeatureStateCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ProductSpecificationsFeatureStatePtr in_state);
};

bool ShoppingServiceHandler_GetProductSpecificationsFeatureState_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ShoppingServiceHandler_GetProductSpecificationsFeatureState_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ShoppingServiceHandler_GetProductSpecificationsFeatureState_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ShoppingServiceHandler.19
  bool success = true;
  ProductSpecificationsFeatureStatePtr p_state{};
  ShoppingServiceHandler_GetProductSpecificationsFeatureState_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadState(&p_state))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ShoppingServiceHandler::Name_, 19, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_state));
  }
  return true;
}

void ShoppingServiceHandler_GetProductSpecificationsFeatureState_ProxyToResponder::Run(
    ProductSpecificationsFeatureStatePtr in_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply shopping_service::mojom::ShoppingServiceHandler::GetProductSpecificationsFeatureState", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("state"), in_state,
                        "<value of type ProductSpecificationsFeatureStatePtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ShoppingServiceHandler::kGetProductSpecificationsFeatureState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::shopping_service::mojom::internal::ShoppingServiceHandler_GetProductSpecificationsFeatureState_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->state)::BaseType> state_fragment(
          params.message());
  
  mojo::internal::Serialize<::shopping_service::mojom::ProductSpecificationsFeatureStateDataView>(
    in_state,
    state_fragment);

  params->state.Set(
      state_fragment.is_null() ? nullptr : state_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->state.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null state in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ShoppingServiceHandler::Name_);
  message.set_method_name("GetProductSpecificationsFeatureState");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ShoppingServiceHandlerStubDispatch::Accept(
    ShoppingServiceHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ShoppingServiceHandler>(message->header()->name)) {
    case messages::ShoppingServiceHandler::kGetProductInfoForCurrentUrl: {
      break;
    }
    case messages::ShoppingServiceHandler::kGetProductInfoForUrl: {
      break;
    }
    case messages::ShoppingServiceHandler::kGetProductInfoForUrls: {
      break;
    }
    case messages::ShoppingServiceHandler::kGetPriceInsightsInfoForCurrentUrl: {
      break;
    }
    case messages::ShoppingServiceHandler::kGetPriceInsightsInfoForUrl: {
      break;
    }
    case messages::ShoppingServiceHandler::kGetProductSpecificationsForUrls: {
      break;
    }
    case messages::ShoppingServiceHandler::kGetUrlInfosForProductTabs: {
      break;
    }
    case messages::ShoppingServiceHandler::kGetUrlInfosForRecentlyViewedTabs: {
      break;
    }
    case messages::ShoppingServiceHandler::kIsShoppingListEligible: {
      break;
    }
    case messages::ShoppingServiceHandler::kGetPriceTrackingStatusForCurrentUrl: {
      break;
    }
    case messages::ShoppingServiceHandler::kOpenUrlInNewTab: {
      DCHECK(message->is_serialized());
      internal::ShoppingServiceHandler_OpenUrlInNewTab_Params_Data* params =
          reinterpret_cast<internal::ShoppingServiceHandler_OpenUrlInNewTab_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ShoppingServiceHandler.10
      bool success = true;
      ::GURL p_url{};
      ShoppingServiceHandler_OpenUrlInNewTab_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ShoppingServiceHandler::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenUrlInNewTab(        
        std::move(p_url));
      return true;
    }
    case messages::ShoppingServiceHandler::kSwitchToOrOpenTab: {
      DCHECK(message->is_serialized());
      internal::ShoppingServiceHandler_SwitchToOrOpenTab_Params_Data* params =
          reinterpret_cast<internal::ShoppingServiceHandler_SwitchToOrOpenTab_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ShoppingServiceHandler.11
      bool success = true;
      ::GURL p_url{};
      ShoppingServiceHandler_SwitchToOrOpenTab_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ShoppingServiceHandler::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SwitchToOrOpenTab(        
        std::move(p_url));
      return true;
    }
    case messages::ShoppingServiceHandler::kGetAllProductSpecificationsSets: {
      break;
    }
    case messages::ShoppingServiceHandler::kGetProductSpecificationsSetByUuid: {
      break;
    }
    case messages::ShoppingServiceHandler::kAddProductSpecificationsSet: {
      break;
    }
    case messages::ShoppingServiceHandler::kDeleteProductSpecificationsSet: {
      DCHECK(message->is_serialized());
      internal::ShoppingServiceHandler_DeleteProductSpecificationsSet_Params_Data* params =
          reinterpret_cast<internal::ShoppingServiceHandler_DeleteProductSpecificationsSet_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ShoppingServiceHandler.15
      bool success = true;
      ::base::Uuid p_uuid{};
      ShoppingServiceHandler_DeleteProductSpecificationsSet_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUuid(&p_uuid))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ShoppingServiceHandler::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteProductSpecificationsSet(        
        std::move(p_uuid));
      return true;
    }
    case messages::ShoppingServiceHandler::kSetNameForProductSpecificationsSet: {
      break;
    }
    case messages::ShoppingServiceHandler::kSetUrlsForProductSpecificationsSet: {
      break;
    }
    case messages::ShoppingServiceHandler::kSetProductSpecificationsUserFeedback: {
      DCHECK(message->is_serialized());
      internal::ShoppingServiceHandler_SetProductSpecificationsUserFeedback_Params_Data* params =
          reinterpret_cast<internal::ShoppingServiceHandler_SetProductSpecificationsUserFeedback_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ShoppingServiceHandler.18
      bool success = true;
      UserFeedback p_feedback{};
      ShoppingServiceHandler_SetProductSpecificationsUserFeedback_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFeedback(&p_feedback))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ShoppingServiceHandler::Name_, 18, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetProductSpecificationsUserFeedback(        
        std::move(p_feedback));
      return true;
    }
    case messages::ShoppingServiceHandler::kGetProductSpecificationsFeatureState: {
      break;
    }
  }
  return false;
}

// static
bool ShoppingServiceHandlerStubDispatch::AcceptWithResponder(
    ShoppingServiceHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ShoppingServiceHandler>(message->header()->name)) {
    case messages::ShoppingServiceHandler::kGetProductInfoForCurrentUrl: {
      internal::ShoppingServiceHandler_GetProductInfoForCurrentUrl_Params_Data* params =
          reinterpret_cast<
              internal::ShoppingServiceHandler_GetProductInfoForCurrentUrl_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ShoppingServiceHandler.0
      bool success = true;
      ShoppingServiceHandler_GetProductInfoForCurrentUrl_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ShoppingServiceHandler::Name_, 0, false);
        return false;
      }
      auto callback =
          ShoppingServiceHandler_GetProductInfoForCurrentUrl_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetProductInfoForCurrentUrl(std::move(callback));
      return true;
    }
    case messages::ShoppingServiceHandler::kGetProductInfoForUrl: {
      internal::ShoppingServiceHandler_GetProductInfoForUrl_Params_Data* params =
          reinterpret_cast<
              internal::ShoppingServiceHandler_GetProductInfoForUrl_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ShoppingServiceHandler.1
      bool success = true;
      ::GURL p_url{};
      ShoppingServiceHandler_GetProductInfoForUrl_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ShoppingServiceHandler::Name_, 1, false);
        return false;
      }
      auto callback =
          ShoppingServiceHandler_GetProductInfoForUrl_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetProductInfoForUrl(        
        std::move(p_url), std::move(callback));
      return true;
    }
    case messages::ShoppingServiceHandler::kGetProductInfoForUrls: {
      internal::ShoppingServiceHandler_GetProductInfoForUrls_Params_Data* params =
          reinterpret_cast<
              internal::ShoppingServiceHandler_GetProductInfoForUrls_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ShoppingServiceHandler.2
      bool success = true;
      std::vector<::GURL> p_urls{};
      ShoppingServiceHandler_GetProductInfoForUrls_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrls(&p_urls))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ShoppingServiceHandler::Name_, 2, false);
        return false;
      }
      auto callback =
          ShoppingServiceHandler_GetProductInfoForUrls_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetProductInfoForUrls(        
        std::move(p_urls), std::move(callback));
      return true;
    }
    case messages::ShoppingServiceHandler::kGetPriceInsightsInfoForCurrentUrl: {
      internal::ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_Params_Data* params =
          reinterpret_cast<
              internal::ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ShoppingServiceHandler.3
      bool success = true;
      ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ShoppingServiceHandler::Name_, 3, false);
        return false;
      }
      auto callback =
          ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetPriceInsightsInfoForCurrentUrl(std::move(callback));
      return true;
    }
    case messages::ShoppingServiceHandler::kGetPriceInsightsInfoForUrl: {
      internal::ShoppingServiceHandler_GetPriceInsightsInfoForUrl_Params_Data* params =
          reinterpret_cast<
              internal::ShoppingServiceHandler_GetPriceInsightsInfoForUrl_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ShoppingServiceHandler.4
      bool success = true;
      ::GURL p_url{};
      ShoppingServiceHandler_GetPriceInsightsInfoForUrl_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ShoppingServiceHandler::Name_, 4, false);
        return false;
      }
      auto callback =
          ShoppingServiceHandler_GetPriceInsightsInfoForUrl_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetPriceInsightsInfoForUrl(        
        std::move(p_url), std::move(callback));
      return true;
    }
    case messages::ShoppingServiceHandler::kGetProductSpecificationsForUrls: {
      internal::ShoppingServiceHandler_GetProductSpecificationsForUrls_Params_Data* params =
          reinterpret_cast<
              internal::ShoppingServiceHandler_GetProductSpecificationsForUrls_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ShoppingServiceHandler.5
      bool success = true;
      std::vector<::GURL> p_urls{};
      ShoppingServiceHandler_GetProductSpecificationsForUrls_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrls(&p_urls))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ShoppingServiceHandler::Name_, 5, false);
        return false;
      }
      auto callback =
          ShoppingServiceHandler_GetProductSpecificationsForUrls_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetProductSpecificationsForUrls(        
        std::move(p_urls), std::move(callback));
      return true;
    }
    case messages::ShoppingServiceHandler::kGetUrlInfosForProductTabs: {
      internal::ShoppingServiceHandler_GetUrlInfosForProductTabs_Params_Data* params =
          reinterpret_cast<
              internal::ShoppingServiceHandler_GetUrlInfosForProductTabs_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ShoppingServiceHandler.6
      bool success = true;
      ShoppingServiceHandler_GetUrlInfosForProductTabs_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ShoppingServiceHandler::Name_, 6, false);
        return false;
      }
      auto callback =
          ShoppingServiceHandler_GetUrlInfosForProductTabs_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetUrlInfosForProductTabs(std::move(callback));
      return true;
    }
    case messages::ShoppingServiceHandler::kGetUrlInfosForRecentlyViewedTabs: {
      internal::ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_Params_Data* params =
          reinterpret_cast<
              internal::ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ShoppingServiceHandler.7
      bool success = true;
      ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ShoppingServiceHandler::Name_, 7, false);
        return false;
      }
      auto callback =
          ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetUrlInfosForRecentlyViewedTabs(std::move(callback));
      return true;
    }
    case messages::ShoppingServiceHandler::kIsShoppingListEligible: {
      internal::ShoppingServiceHandler_IsShoppingListEligible_Params_Data* params =
          reinterpret_cast<
              internal::ShoppingServiceHandler_IsShoppingListEligible_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ShoppingServiceHandler.8
      bool success = true;
      ShoppingServiceHandler_IsShoppingListEligible_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ShoppingServiceHandler::Name_, 8, false);
        return false;
      }
      auto callback =
          ShoppingServiceHandler_IsShoppingListEligible_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->IsShoppingListEligible(std::move(callback));
      return true;
    }
    case messages::ShoppingServiceHandler::kGetPriceTrackingStatusForCurrentUrl: {
      internal::ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_Params_Data* params =
          reinterpret_cast<
              internal::ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ShoppingServiceHandler.9
      bool success = true;
      ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ShoppingServiceHandler::Name_, 9, false);
        return false;
      }
      auto callback =
          ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetPriceTrackingStatusForCurrentUrl(std::move(callback));
      return true;
    }
    case messages::ShoppingServiceHandler::kOpenUrlInNewTab: {
      break;
    }
    case messages::ShoppingServiceHandler::kSwitchToOrOpenTab: {
      break;
    }
    case messages::ShoppingServiceHandler::kGetAllProductSpecificationsSets: {
      internal::ShoppingServiceHandler_GetAllProductSpecificationsSets_Params_Data* params =
          reinterpret_cast<
              internal::ShoppingServiceHandler_GetAllProductSpecificationsSets_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ShoppingServiceHandler.12
      bool success = true;
      ShoppingServiceHandler_GetAllProductSpecificationsSets_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ShoppingServiceHandler::Name_, 12, false);
        return false;
      }
      auto callback =
          ShoppingServiceHandler_GetAllProductSpecificationsSets_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAllProductSpecificationsSets(std::move(callback));
      return true;
    }
    case messages::ShoppingServiceHandler::kGetProductSpecificationsSetByUuid: {
      internal::ShoppingServiceHandler_GetProductSpecificationsSetByUuid_Params_Data* params =
          reinterpret_cast<
              internal::ShoppingServiceHandler_GetProductSpecificationsSetByUuid_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ShoppingServiceHandler.13
      bool success = true;
      ::base::Uuid p_uuid{};
      ShoppingServiceHandler_GetProductSpecificationsSetByUuid_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUuid(&p_uuid))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ShoppingServiceHandler::Name_, 13, false);
        return false;
      }
      auto callback =
          ShoppingServiceHandler_GetProductSpecificationsSetByUuid_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetProductSpecificationsSetByUuid(        
        std::move(p_uuid), std::move(callback));
      return true;
    }
    case messages::ShoppingServiceHandler::kAddProductSpecificationsSet: {
      internal::ShoppingServiceHandler_AddProductSpecificationsSet_Params_Data* params =
          reinterpret_cast<
              internal::ShoppingServiceHandler_AddProductSpecificationsSet_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ShoppingServiceHandler.14
      bool success = true;
      std::string p_name{};
      std::vector<::GURL> p_urls{};
      ShoppingServiceHandler_AddProductSpecificationsSet_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (success && !input_data_view.ReadUrls(&p_urls))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ShoppingServiceHandler::Name_, 14, false);
        return false;
      }
      auto callback =
          ShoppingServiceHandler_AddProductSpecificationsSet_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddProductSpecificationsSet(        
        std::move(p_name), 
        std::move(p_urls), std::move(callback));
      return true;
    }
    case messages::ShoppingServiceHandler::kDeleteProductSpecificationsSet: {
      break;
    }
    case messages::ShoppingServiceHandler::kSetNameForProductSpecificationsSet: {
      internal::ShoppingServiceHandler_SetNameForProductSpecificationsSet_Params_Data* params =
          reinterpret_cast<
              internal::ShoppingServiceHandler_SetNameForProductSpecificationsSet_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ShoppingServiceHandler.16
      bool success = true;
      ::base::Uuid p_uuid{};
      std::string p_name{};
      ShoppingServiceHandler_SetNameForProductSpecificationsSet_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUuid(&p_uuid))
        success = false;
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ShoppingServiceHandler::Name_, 16, false);
        return false;
      }
      auto callback =
          ShoppingServiceHandler_SetNameForProductSpecificationsSet_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetNameForProductSpecificationsSet(        
        std::move(p_uuid), 
        std::move(p_name), std::move(callback));
      return true;
    }
    case messages::ShoppingServiceHandler::kSetUrlsForProductSpecificationsSet: {
      internal::ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_Params_Data* params =
          reinterpret_cast<
              internal::ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ShoppingServiceHandler.17
      bool success = true;
      ::base::Uuid p_uuid{};
      std::vector<::GURL> p_urls{};
      ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUuid(&p_uuid))
        success = false;
      if (success && !input_data_view.ReadUrls(&p_urls))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ShoppingServiceHandler::Name_, 17, false);
        return false;
      }
      auto callback =
          ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetUrlsForProductSpecificationsSet(        
        std::move(p_uuid), 
        std::move(p_urls), std::move(callback));
      return true;
    }
    case messages::ShoppingServiceHandler::kSetProductSpecificationsUserFeedback: {
      break;
    }
    case messages::ShoppingServiceHandler::kGetProductSpecificationsFeatureState: {
      internal::ShoppingServiceHandler_GetProductSpecificationsFeatureState_Params_Data* params =
          reinterpret_cast<
              internal::ShoppingServiceHandler_GetProductSpecificationsFeatureState_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ShoppingServiceHandler.19
      bool success = true;
      ShoppingServiceHandler_GetProductSpecificationsFeatureState_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ShoppingServiceHandler::Name_, 19, false);
        return false;
      }
      auto callback =
          ShoppingServiceHandler_GetProductSpecificationsFeatureState_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetProductSpecificationsFeatureState(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kShoppingServiceHandlerValidationInfo[] = {
    { &internal::ShoppingServiceHandler_GetProductInfoForCurrentUrl_Params_Data::Validate,
     &internal::ShoppingServiceHandler_GetProductInfoForCurrentUrl_ResponseParams_Data::Validate},
    { &internal::ShoppingServiceHandler_GetProductInfoForUrl_Params_Data::Validate,
     &internal::ShoppingServiceHandler_GetProductInfoForUrl_ResponseParams_Data::Validate},
    { &internal::ShoppingServiceHandler_GetProductInfoForUrls_Params_Data::Validate,
     &internal::ShoppingServiceHandler_GetProductInfoForUrls_ResponseParams_Data::Validate},
    { &internal::ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_Params_Data::Validate,
     &internal::ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_ResponseParams_Data::Validate},
    { &internal::ShoppingServiceHandler_GetPriceInsightsInfoForUrl_Params_Data::Validate,
     &internal::ShoppingServiceHandler_GetPriceInsightsInfoForUrl_ResponseParams_Data::Validate},
    { &internal::ShoppingServiceHandler_GetProductSpecificationsForUrls_Params_Data::Validate,
     &internal::ShoppingServiceHandler_GetProductSpecificationsForUrls_ResponseParams_Data::Validate},
    { &internal::ShoppingServiceHandler_GetUrlInfosForProductTabs_Params_Data::Validate,
     &internal::ShoppingServiceHandler_GetUrlInfosForProductTabs_ResponseParams_Data::Validate},
    { &internal::ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_Params_Data::Validate,
     &internal::ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_ResponseParams_Data::Validate},
    { &internal::ShoppingServiceHandler_IsShoppingListEligible_Params_Data::Validate,
     &internal::ShoppingServiceHandler_IsShoppingListEligible_ResponseParams_Data::Validate},
    { &internal::ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_Params_Data::Validate,
     &internal::ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_ResponseParams_Data::Validate},
    { &internal::ShoppingServiceHandler_OpenUrlInNewTab_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ShoppingServiceHandler_SwitchToOrOpenTab_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ShoppingServiceHandler_GetAllProductSpecificationsSets_Params_Data::Validate,
     &internal::ShoppingServiceHandler_GetAllProductSpecificationsSets_ResponseParams_Data::Validate},
    { &internal::ShoppingServiceHandler_GetProductSpecificationsSetByUuid_Params_Data::Validate,
     &internal::ShoppingServiceHandler_GetProductSpecificationsSetByUuid_ResponseParams_Data::Validate},
    { &internal::ShoppingServiceHandler_AddProductSpecificationsSet_Params_Data::Validate,
     &internal::ShoppingServiceHandler_AddProductSpecificationsSet_ResponseParams_Data::Validate},
    { &internal::ShoppingServiceHandler_DeleteProductSpecificationsSet_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ShoppingServiceHandler_SetNameForProductSpecificationsSet_Params_Data::Validate,
     &internal::ShoppingServiceHandler_SetNameForProductSpecificationsSet_ResponseParams_Data::Validate},
    { &internal::ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_Params_Data::Validate,
     &internal::ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_ResponseParams_Data::Validate},
    { &internal::ShoppingServiceHandler_SetProductSpecificationsUserFeedback_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ShoppingServiceHandler_GetProductSpecificationsFeatureState_Params_Data::Validate,
     &internal::ShoppingServiceHandler_GetProductSpecificationsFeatureState_ResponseParams_Data::Validate},
};

bool ShoppingServiceHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::shopping_service::mojom::ShoppingServiceHandler::Name_,
    kShoppingServiceHandlerValidationInfo);
}

bool ShoppingServiceHandlerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::shopping_service::mojom::ShoppingServiceHandler::Name_,
    kShoppingServiceHandlerValidationInfo);
}


}  // shopping_service::mojom


namespace mojo {


// static
bool StructTraits<::shopping_service::mojom::PricePoint::DataView, ::shopping_service::mojom::PricePointPtr>::Read(
    ::shopping_service::mojom::PricePoint::DataView input,
    ::shopping_service::mojom::PricePointPtr* output) {
  bool success = true;
  ::shopping_service::mojom::PricePointPtr result(::shopping_service::mojom::PricePoint::New());
  
      if (success && !input.ReadDate(&result->date))
        success = false;
      if (success)
        result->price = input.price();
      if (success && !input.ReadFormattedPrice(&result->formatted_price))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::shopping_service::mojom::UrlInfo::DataView, ::shopping_service::mojom::UrlInfoPtr>::Read(
    ::shopping_service::mojom::UrlInfo::DataView input,
    ::shopping_service::mojom::UrlInfoPtr* output) {
  bool success = true;
  ::shopping_service::mojom::UrlInfoPtr result(::shopping_service::mojom::UrlInfo::New());
  
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadFaviconUrl(&result->favicon_url))
        success = false;
      if (success && !input.ReadThumbnailUrl(&result->thumbnail_url))
        success = false;
      if (success && !input.ReadPreviewText(&result->previewText))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::shopping_service::mojom::PriceInsightsInfo::DataView, ::shopping_service::mojom::PriceInsightsInfoPtr>::Read(
    ::shopping_service::mojom::PriceInsightsInfo::DataView input,
    ::shopping_service::mojom::PriceInsightsInfoPtr* output) {
  bool success = true;
  ::shopping_service::mojom::PriceInsightsInfoPtr result(::shopping_service::mojom::PriceInsightsInfo::New());
  
      if (success)
        result->cluster_id = input.cluster_id();
      if (success && !input.ReadTypicalLowPrice(&result->typical_low_price))
        success = false;
      if (success && !input.ReadTypicalHighPrice(&result->typical_high_price))
        success = false;
      if (success && !input.ReadCatalogAttributes(&result->catalog_attributes))
        success = false;
      if (success && !input.ReadJackpot(&result->jackpot))
        success = false;
      if (success && !input.ReadBucket(&result->bucket))
        success = false;
      if (success)
        result->has_multiple_catalogs = input.has_multiple_catalogs();
      if (success && !input.ReadHistory(&result->history))
        success = false;
      if (success && !input.ReadLocale(&result->locale))
        success = false;
      if (success && !input.ReadCurrencyCode(&result->currency_code))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::shopping_service::mojom::ProductSpecificationsDescriptionText::DataView, ::shopping_service::mojom::ProductSpecificationsDescriptionTextPtr>::Read(
    ::shopping_service::mojom::ProductSpecificationsDescriptionText::DataView input,
    ::shopping_service::mojom::ProductSpecificationsDescriptionTextPtr* output) {
  bool success = true;
  ::shopping_service::mojom::ProductSpecificationsDescriptionTextPtr result(::shopping_service::mojom::ProductSpecificationsDescriptionText::New());
  
      if (success && !input.ReadText(&result->text))
        success = false;
      if (success && !input.ReadUrls(&result->urls))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::shopping_service::mojom::ProductSpecificationsOption::DataView, ::shopping_service::mojom::ProductSpecificationsOptionPtr>::Read(
    ::shopping_service::mojom::ProductSpecificationsOption::DataView input,
    ::shopping_service::mojom::ProductSpecificationsOptionPtr* output) {
  bool success = true;
  ::shopping_service::mojom::ProductSpecificationsOptionPtr result(::shopping_service::mojom::ProductSpecificationsOption::New());
  
      if (success && !input.ReadDescriptions(&result->descriptions))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::shopping_service::mojom::ProductSpecificationsDescription::DataView, ::shopping_service::mojom::ProductSpecificationsDescriptionPtr>::Read(
    ::shopping_service::mojom::ProductSpecificationsDescription::DataView input,
    ::shopping_service::mojom::ProductSpecificationsDescriptionPtr* output) {
  bool success = true;
  ::shopping_service::mojom::ProductSpecificationsDescriptionPtr result(::shopping_service::mojom::ProductSpecificationsDescription::New());
  
      if (success && !input.ReadOptions(&result->options))
        success = false;
      if (success && !input.ReadLabel(&result->label))
        success = false;
      if (success && !input.ReadAltText(&result->alt_text))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::shopping_service::mojom::ProductSpecificationsValue::DataView, ::shopping_service::mojom::ProductSpecificationsValuePtr>::Read(
    ::shopping_service::mojom::ProductSpecificationsValue::DataView input,
    ::shopping_service::mojom::ProductSpecificationsValuePtr* output) {
  bool success = true;
  ::shopping_service::mojom::ProductSpecificationsValuePtr result(::shopping_service::mojom::ProductSpecificationsValue::New());
  
      if (success && !input.ReadSpecificationDescriptions(&result->specification_descriptions))
        success = false;
      if (success && !input.ReadSummary(&result->summary))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::shopping_service::mojom::ProductSpecificationsProduct::DataView, ::shopping_service::mojom::ProductSpecificationsProductPtr>::Read(
    ::shopping_service::mojom::ProductSpecificationsProduct::DataView input,
    ::shopping_service::mojom::ProductSpecificationsProductPtr* output) {
  bool success = true;
  ::shopping_service::mojom::ProductSpecificationsProductPtr result(::shopping_service::mojom::ProductSpecificationsProduct::New());
  
      if (success)
        result->product_cluster_id = input.product_cluster_id();
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success && !input.ReadImageUrl(&result->image_url))
        success = false;
      if (success && !input.ReadProductDimensionValues(&result->product_dimension_values))
        success = false;
      if (success && !input.ReadSummary(&result->summary))
        success = false;
      if (success && !input.ReadBuyingOptionsUrl(&result->buying_options_url))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::shopping_service::mojom::ProductSpecificationsFeatureState::DataView, ::shopping_service::mojom::ProductSpecificationsFeatureStatePtr>::Read(
    ::shopping_service::mojom::ProductSpecificationsFeatureState::DataView input,
    ::shopping_service::mojom::ProductSpecificationsFeatureStatePtr* output) {
  bool success = true;
  ::shopping_service::mojom::ProductSpecificationsFeatureStatePtr result(::shopping_service::mojom::ProductSpecificationsFeatureState::New());
  
      if (success)
        result->is_syncing_tab_compare = input.is_syncing_tab_compare();
      if (success)
        result->can_load_full_page_ui = input.can_load_full_page_ui();
      if (success)
        result->can_manage_sets = input.can_manage_sets();
      if (success)
        result->can_fetch_data = input.can_fetch_data();
      if (success)
        result->is_allowed_for_enterprise = input.is_allowed_for_enterprise();
      if (success)
        result->is_quality_logging_allowed = input.is_quality_logging_allowed();
      if (success)
        result->is_signed_in = input.is_signed_in();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::shopping_service::mojom::ProductSpecifications::DataView, ::shopping_service::mojom::ProductSpecificationsPtr>::Read(
    ::shopping_service::mojom::ProductSpecifications::DataView input,
    ::shopping_service::mojom::ProductSpecificationsPtr* output) {
  bool success = true;
  ::shopping_service::mojom::ProductSpecificationsPtr result(::shopping_service::mojom::ProductSpecifications::New());
  
      if (success && !input.ReadProductDimensionMap(&result->product_dimension_map))
        success = false;
      if (success && !input.ReadProducts(&result->products))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace shopping_service::mojom {


void ShoppingServiceHandlerFactoryInterceptorForTesting::CreateShoppingServiceHandler(::mojo::PendingReceiver<ShoppingServiceHandler> handler) {
  GetForwardingInterface()->CreateShoppingServiceHandler(
    std::move(handler)
    );
}
ShoppingServiceHandlerFactoryAsyncWaiter::ShoppingServiceHandlerFactoryAsyncWaiter(
    ShoppingServiceHandlerFactory* proxy) : proxy_(proxy) {}

ShoppingServiceHandlerFactoryAsyncWaiter::~ShoppingServiceHandlerFactoryAsyncWaiter() = default;





void ShoppingServiceHandlerInterceptorForTesting::GetProductInfoForCurrentUrl(GetProductInfoForCurrentUrlCallback callback) {
  GetForwardingInterface()->GetProductInfoForCurrentUrl(std::move(callback));
}
void ShoppingServiceHandlerInterceptorForTesting::GetProductInfoForUrl(const ::GURL& url, GetProductInfoForUrlCallback callback) {
  GetForwardingInterface()->GetProductInfoForUrl(
    std::move(url)
    , std::move(callback));
}
void ShoppingServiceHandlerInterceptorForTesting::GetProductInfoForUrls(const std::vector<::GURL>& urls, GetProductInfoForUrlsCallback callback) {
  GetForwardingInterface()->GetProductInfoForUrls(
    std::move(urls)
    , std::move(callback));
}
void ShoppingServiceHandlerInterceptorForTesting::GetPriceInsightsInfoForCurrentUrl(GetPriceInsightsInfoForCurrentUrlCallback callback) {
  GetForwardingInterface()->GetPriceInsightsInfoForCurrentUrl(std::move(callback));
}
void ShoppingServiceHandlerInterceptorForTesting::GetPriceInsightsInfoForUrl(const ::GURL& url, GetPriceInsightsInfoForUrlCallback callback) {
  GetForwardingInterface()->GetPriceInsightsInfoForUrl(
    std::move(url)
    , std::move(callback));
}
void ShoppingServiceHandlerInterceptorForTesting::GetProductSpecificationsForUrls(const std::vector<::GURL>& urls, GetProductSpecificationsForUrlsCallback callback) {
  GetForwardingInterface()->GetProductSpecificationsForUrls(
    std::move(urls)
    , std::move(callback));
}
void ShoppingServiceHandlerInterceptorForTesting::GetUrlInfosForProductTabs(GetUrlInfosForProductTabsCallback callback) {
  GetForwardingInterface()->GetUrlInfosForProductTabs(std::move(callback));
}
void ShoppingServiceHandlerInterceptorForTesting::GetUrlInfosForRecentlyViewedTabs(GetUrlInfosForRecentlyViewedTabsCallback callback) {
  GetForwardingInterface()->GetUrlInfosForRecentlyViewedTabs(std::move(callback));
}
void ShoppingServiceHandlerInterceptorForTesting::IsShoppingListEligible(IsShoppingListEligibleCallback callback) {
  GetForwardingInterface()->IsShoppingListEligible(std::move(callback));
}
void ShoppingServiceHandlerInterceptorForTesting::GetPriceTrackingStatusForCurrentUrl(GetPriceTrackingStatusForCurrentUrlCallback callback) {
  GetForwardingInterface()->GetPriceTrackingStatusForCurrentUrl(std::move(callback));
}
void ShoppingServiceHandlerInterceptorForTesting::OpenUrlInNewTab(const ::GURL& url) {
  GetForwardingInterface()->OpenUrlInNewTab(
    std::move(url)
    );
}
void ShoppingServiceHandlerInterceptorForTesting::SwitchToOrOpenTab(const ::GURL& url) {
  GetForwardingInterface()->SwitchToOrOpenTab(
    std::move(url)
    );
}
void ShoppingServiceHandlerInterceptorForTesting::GetAllProductSpecificationsSets(GetAllProductSpecificationsSetsCallback callback) {
  GetForwardingInterface()->GetAllProductSpecificationsSets(std::move(callback));
}
void ShoppingServiceHandlerInterceptorForTesting::GetProductSpecificationsSetByUuid(const ::base::Uuid& uuid, GetProductSpecificationsSetByUuidCallback callback) {
  GetForwardingInterface()->GetProductSpecificationsSetByUuid(
    std::move(uuid)
    , std::move(callback));
}
void ShoppingServiceHandlerInterceptorForTesting::AddProductSpecificationsSet(const std::string& name, const std::vector<::GURL>& urls, AddProductSpecificationsSetCallback callback) {
  GetForwardingInterface()->AddProductSpecificationsSet(
    std::move(name)
    , 
    std::move(urls)
    , std::move(callback));
}
void ShoppingServiceHandlerInterceptorForTesting::DeleteProductSpecificationsSet(const ::base::Uuid& uuid) {
  GetForwardingInterface()->DeleteProductSpecificationsSet(
    std::move(uuid)
    );
}
void ShoppingServiceHandlerInterceptorForTesting::SetNameForProductSpecificationsSet(const ::base::Uuid& uuid, const std::string& name, SetNameForProductSpecificationsSetCallback callback) {
  GetForwardingInterface()->SetNameForProductSpecificationsSet(
    std::move(uuid)
    , 
    std::move(name)
    , std::move(callback));
}
void ShoppingServiceHandlerInterceptorForTesting::SetUrlsForProductSpecificationsSet(const ::base::Uuid& uuid, const std::vector<::GURL>& urls, SetUrlsForProductSpecificationsSetCallback callback) {
  GetForwardingInterface()->SetUrlsForProductSpecificationsSet(
    std::move(uuid)
    , 
    std::move(urls)
    , std::move(callback));
}
void ShoppingServiceHandlerInterceptorForTesting::SetProductSpecificationsUserFeedback(UserFeedback feedback) {
  GetForwardingInterface()->SetProductSpecificationsUserFeedback(
    std::move(feedback)
    );
}
void ShoppingServiceHandlerInterceptorForTesting::GetProductSpecificationsFeatureState(GetProductSpecificationsFeatureStateCallback callback) {
  GetForwardingInterface()->GetProductSpecificationsFeatureState(std::move(callback));
}
ShoppingServiceHandlerAsyncWaiter::ShoppingServiceHandlerAsyncWaiter(
    ShoppingServiceHandler* proxy) : proxy_(proxy) {}

ShoppingServiceHandlerAsyncWaiter::~ShoppingServiceHandlerAsyncWaiter() = default;


void ShoppingServiceHandlerAsyncWaiter::GetProductInfoForCurrentUrl(
    ::commerce::shared::mojom::ProductInfoPtr* out_productInfo) {
  base::RunLoop loop;
  proxy_->GetProductInfoForCurrentUrl(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::commerce::shared::mojom::ProductInfoPtr* out_productInfo
,
             ::commerce::shared::mojom::ProductInfoPtr productInfo) {*out_productInfo = std::move(productInfo);
            loop->Quit();
          },
          &loop,
          out_productInfo));
  loop.Run();
}

::commerce::shared::mojom::ProductInfoPtr ShoppingServiceHandlerAsyncWaiter::GetProductInfoForCurrentUrl(
    ) {
  ::commerce::shared::mojom::ProductInfoPtr async_wait_result;
  GetProductInfoForCurrentUrl(&async_wait_result);
  return async_wait_result;
}

void ShoppingServiceHandlerAsyncWaiter::GetProductInfoForUrl(
    const ::GURL& url, ::GURL* out_url, ::commerce::shared::mojom::ProductInfoPtr* out_productInfo) {
  base::RunLoop loop;
  proxy_->GetProductInfoForUrl(
      std::move(url),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::GURL* out_url
,
             ::commerce::shared::mojom::ProductInfoPtr* out_productInfo
,
             const ::GURL& url,
             ::commerce::shared::mojom::ProductInfoPtr productInfo) {*out_url = std::move(url);*out_productInfo = std::move(productInfo);
            loop->Quit();
          },
          &loop,
          out_url,
          out_productInfo));
  loop.Run();
}



void ShoppingServiceHandlerAsyncWaiter::GetProductInfoForUrls(
    const std::vector<::GURL>& urls, std::vector<::commerce::shared::mojom::ProductInfoPtr>* out_productInfos) {
  base::RunLoop loop;
  proxy_->GetProductInfoForUrls(
      std::move(urls),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<::commerce::shared::mojom::ProductInfoPtr>* out_productInfos
,
             std::vector<::commerce::shared::mojom::ProductInfoPtr> productInfos) {*out_productInfos = std::move(productInfos);
            loop->Quit();
          },
          &loop,
          out_productInfos));
  loop.Run();
}

std::vector<::commerce::shared::mojom::ProductInfoPtr> ShoppingServiceHandlerAsyncWaiter::GetProductInfoForUrls(
    const std::vector<::GURL>& urls) {
  std::vector<::commerce::shared::mojom::ProductInfoPtr> async_wait_result;
  GetProductInfoForUrls(std::move(urls),&async_wait_result);
  return async_wait_result;
}

void ShoppingServiceHandlerAsyncWaiter::GetPriceInsightsInfoForCurrentUrl(
    PriceInsightsInfoPtr* out_priceInsightsInfo) {
  base::RunLoop loop;
  proxy_->GetPriceInsightsInfoForCurrentUrl(
      base::BindOnce(
          [](base::RunLoop* loop,
             PriceInsightsInfoPtr* out_priceInsightsInfo
,
             PriceInsightsInfoPtr priceInsightsInfo) {*out_priceInsightsInfo = std::move(priceInsightsInfo);
            loop->Quit();
          },
          &loop,
          out_priceInsightsInfo));
  loop.Run();
}

PriceInsightsInfoPtr ShoppingServiceHandlerAsyncWaiter::GetPriceInsightsInfoForCurrentUrl(
    ) {
  PriceInsightsInfoPtr async_wait_result;
  GetPriceInsightsInfoForCurrentUrl(&async_wait_result);
  return async_wait_result;
}

void ShoppingServiceHandlerAsyncWaiter::GetPriceInsightsInfoForUrl(
    const ::GURL& url, ::GURL* out_url, PriceInsightsInfoPtr* out_priceInsightsInfo) {
  base::RunLoop loop;
  proxy_->GetPriceInsightsInfoForUrl(
      std::move(url),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::GURL* out_url
,
             PriceInsightsInfoPtr* out_priceInsightsInfo
,
             const ::GURL& url,
             PriceInsightsInfoPtr priceInsightsInfo) {*out_url = std::move(url);*out_priceInsightsInfo = std::move(priceInsightsInfo);
            loop->Quit();
          },
          &loop,
          out_url,
          out_priceInsightsInfo));
  loop.Run();
}



void ShoppingServiceHandlerAsyncWaiter::GetProductSpecificationsForUrls(
    const std::vector<::GURL>& urls, ProductSpecificationsPtr* out_productSpecs) {
  base::RunLoop loop;
  proxy_->GetProductSpecificationsForUrls(
      std::move(urls),
      base::BindOnce(
          [](base::RunLoop* loop,
             ProductSpecificationsPtr* out_productSpecs
,
             ProductSpecificationsPtr productSpecs) {*out_productSpecs = std::move(productSpecs);
            loop->Quit();
          },
          &loop,
          out_productSpecs));
  loop.Run();
}

ProductSpecificationsPtr ShoppingServiceHandlerAsyncWaiter::GetProductSpecificationsForUrls(
    const std::vector<::GURL>& urls) {
  ProductSpecificationsPtr async_wait_result;
  GetProductSpecificationsForUrls(std::move(urls),&async_wait_result);
  return async_wait_result;
}

void ShoppingServiceHandlerAsyncWaiter::GetUrlInfosForProductTabs(
    std::vector<UrlInfoPtr>* out_url_infos) {
  base::RunLoop loop;
  proxy_->GetUrlInfosForProductTabs(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<UrlInfoPtr>* out_url_infos
,
             std::vector<UrlInfoPtr> url_infos) {*out_url_infos = std::move(url_infos);
            loop->Quit();
          },
          &loop,
          out_url_infos));
  loop.Run();
}

std::vector<UrlInfoPtr> ShoppingServiceHandlerAsyncWaiter::GetUrlInfosForProductTabs(
    ) {
  std::vector<UrlInfoPtr> async_wait_result;
  GetUrlInfosForProductTabs(&async_wait_result);
  return async_wait_result;
}

void ShoppingServiceHandlerAsyncWaiter::GetUrlInfosForRecentlyViewedTabs(
    std::vector<UrlInfoPtr>* out_url_infos) {
  base::RunLoop loop;
  proxy_->GetUrlInfosForRecentlyViewedTabs(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<UrlInfoPtr>* out_url_infos
,
             std::vector<UrlInfoPtr> url_infos) {*out_url_infos = std::move(url_infos);
            loop->Quit();
          },
          &loop,
          out_url_infos));
  loop.Run();
}

std::vector<UrlInfoPtr> ShoppingServiceHandlerAsyncWaiter::GetUrlInfosForRecentlyViewedTabs(
    ) {
  std::vector<UrlInfoPtr> async_wait_result;
  GetUrlInfosForRecentlyViewedTabs(&async_wait_result);
  return async_wait_result;
}

void ShoppingServiceHandlerAsyncWaiter::IsShoppingListEligible(
    bool* out_eligible) {
  base::RunLoop loop;
  proxy_->IsShoppingListEligible(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_eligible
,
             bool eligible) {*out_eligible = std::move(eligible);
            loop->Quit();
          },
          &loop,
          out_eligible));
  loop.Run();
}

bool ShoppingServiceHandlerAsyncWaiter::IsShoppingListEligible(
    ) {
  bool async_wait_result;
  IsShoppingListEligible(&async_wait_result);
  return async_wait_result;
}

void ShoppingServiceHandlerAsyncWaiter::GetPriceTrackingStatusForCurrentUrl(
    bool* out_tracked) {
  base::RunLoop loop;
  proxy_->GetPriceTrackingStatusForCurrentUrl(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_tracked
,
             bool tracked) {*out_tracked = std::move(tracked);
            loop->Quit();
          },
          &loop,
          out_tracked));
  loop.Run();
}

bool ShoppingServiceHandlerAsyncWaiter::GetPriceTrackingStatusForCurrentUrl(
    ) {
  bool async_wait_result;
  GetPriceTrackingStatusForCurrentUrl(&async_wait_result);
  return async_wait_result;
}

void ShoppingServiceHandlerAsyncWaiter::GetAllProductSpecificationsSets(
    std::vector<::commerce::shared::mojom::ProductSpecificationsSetPtr>* out_sets) {
  base::RunLoop loop;
  proxy_->GetAllProductSpecificationsSets(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<::commerce::shared::mojom::ProductSpecificationsSetPtr>* out_sets
,
             std::vector<::commerce::shared::mojom::ProductSpecificationsSetPtr> sets) {*out_sets = std::move(sets);
            loop->Quit();
          },
          &loop,
          out_sets));
  loop.Run();
}

std::vector<::commerce::shared::mojom::ProductSpecificationsSetPtr> ShoppingServiceHandlerAsyncWaiter::GetAllProductSpecificationsSets(
    ) {
  std::vector<::commerce::shared::mojom::ProductSpecificationsSetPtr> async_wait_result;
  GetAllProductSpecificationsSets(&async_wait_result);
  return async_wait_result;
}

void ShoppingServiceHandlerAsyncWaiter::GetProductSpecificationsSetByUuid(
    const ::base::Uuid& uuid, ::commerce::shared::mojom::ProductSpecificationsSetPtr* out_set) {
  base::RunLoop loop;
  proxy_->GetProductSpecificationsSetByUuid(
      std::move(uuid),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::commerce::shared::mojom::ProductSpecificationsSetPtr* out_set
,
             ::commerce::shared::mojom::ProductSpecificationsSetPtr set) {*out_set = std::move(set);
            loop->Quit();
          },
          &loop,
          out_set));
  loop.Run();
}

::commerce::shared::mojom::ProductSpecificationsSetPtr ShoppingServiceHandlerAsyncWaiter::GetProductSpecificationsSetByUuid(
    const ::base::Uuid& uuid) {
  ::commerce::shared::mojom::ProductSpecificationsSetPtr async_wait_result;
  GetProductSpecificationsSetByUuid(std::move(uuid),&async_wait_result);
  return async_wait_result;
}

void ShoppingServiceHandlerAsyncWaiter::AddProductSpecificationsSet(
    const std::string& name, const std::vector<::GURL>& urls, ::commerce::shared::mojom::ProductSpecificationsSetPtr* out_created_set) {
  base::RunLoop loop;
  proxy_->AddProductSpecificationsSet(
      std::move(name),
      std::move(urls),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::commerce::shared::mojom::ProductSpecificationsSetPtr* out_created_set
,
             ::commerce::shared::mojom::ProductSpecificationsSetPtr created_set) {*out_created_set = std::move(created_set);
            loop->Quit();
          },
          &loop,
          out_created_set));
  loop.Run();
}

::commerce::shared::mojom::ProductSpecificationsSetPtr ShoppingServiceHandlerAsyncWaiter::AddProductSpecificationsSet(
    const std::string& name, const std::vector<::GURL>& urls) {
  ::commerce::shared::mojom::ProductSpecificationsSetPtr async_wait_result;
  AddProductSpecificationsSet(std::move(name),std::move(urls),&async_wait_result);
  return async_wait_result;
}

void ShoppingServiceHandlerAsyncWaiter::SetNameForProductSpecificationsSet(
    const ::base::Uuid& uuid, const std::string& name, ::commerce::shared::mojom::ProductSpecificationsSetPtr* out_updated_set) {
  base::RunLoop loop;
  proxy_->SetNameForProductSpecificationsSet(
      std::move(uuid),
      std::move(name),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::commerce::shared::mojom::ProductSpecificationsSetPtr* out_updated_set
,
             ::commerce::shared::mojom::ProductSpecificationsSetPtr updated_set) {*out_updated_set = std::move(updated_set);
            loop->Quit();
          },
          &loop,
          out_updated_set));
  loop.Run();
}

::commerce::shared::mojom::ProductSpecificationsSetPtr ShoppingServiceHandlerAsyncWaiter::SetNameForProductSpecificationsSet(
    const ::base::Uuid& uuid, const std::string& name) {
  ::commerce::shared::mojom::ProductSpecificationsSetPtr async_wait_result;
  SetNameForProductSpecificationsSet(std::move(uuid),std::move(name),&async_wait_result);
  return async_wait_result;
}

void ShoppingServiceHandlerAsyncWaiter::SetUrlsForProductSpecificationsSet(
    const ::base::Uuid& uuid, const std::vector<::GURL>& urls, ::commerce::shared::mojom::ProductSpecificationsSetPtr* out_updated_set) {
  base::RunLoop loop;
  proxy_->SetUrlsForProductSpecificationsSet(
      std::move(uuid),
      std::move(urls),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::commerce::shared::mojom::ProductSpecificationsSetPtr* out_updated_set
,
             ::commerce::shared::mojom::ProductSpecificationsSetPtr updated_set) {*out_updated_set = std::move(updated_set);
            loop->Quit();
          },
          &loop,
          out_updated_set));
  loop.Run();
}

::commerce::shared::mojom::ProductSpecificationsSetPtr ShoppingServiceHandlerAsyncWaiter::SetUrlsForProductSpecificationsSet(
    const ::base::Uuid& uuid, const std::vector<::GURL>& urls) {
  ::commerce::shared::mojom::ProductSpecificationsSetPtr async_wait_result;
  SetUrlsForProductSpecificationsSet(std::move(uuid),std::move(urls),&async_wait_result);
  return async_wait_result;
}

void ShoppingServiceHandlerAsyncWaiter::GetProductSpecificationsFeatureState(
    ProductSpecificationsFeatureStatePtr* out_state) {
  base::RunLoop loop;
  proxy_->GetProductSpecificationsFeatureState(
      base::BindOnce(
          [](base::RunLoop* loop,
             ProductSpecificationsFeatureStatePtr* out_state
,
             ProductSpecificationsFeatureStatePtr state) {*out_state = std::move(state);
            loop->Quit();
          },
          &loop,
          out_state));
  loop.Run();
}

ProductSpecificationsFeatureStatePtr ShoppingServiceHandlerAsyncWaiter::GetProductSpecificationsFeatureState(
    ) {
  ProductSpecificationsFeatureStatePtr async_wait_result;
  GetProductSpecificationsFeatureState(&async_wait_result);
  return async_wait_result;
}






}  // shopping_service::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif