// components/commerce/core/mojom/shopping_service.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_COMMERCE_CORE_MOJOM_SHOPPING_SERVICE_MOJOM_TEST_UTILS_H_
#define COMPONENTS_COMMERCE_CORE_MOJOM_SHOPPING_SERVICE_MOJOM_TEST_UTILS_H_

#include "components/commerce/core/mojom/shopping_service.mojom.h"


namespace shopping_service::mojom {


class  ShoppingServiceHandlerFactoryInterceptorForTesting : public ShoppingServiceHandlerFactory {
  virtual ShoppingServiceHandlerFactory* GetForwardingInterface() = 0;
  void CreateShoppingServiceHandler(::mojo::PendingReceiver<ShoppingServiceHandler> handler) override;
};
class  ShoppingServiceHandlerFactoryAsyncWaiter {
 public:
  explicit ShoppingServiceHandlerFactoryAsyncWaiter(ShoppingServiceHandlerFactory* proxy);

  ShoppingServiceHandlerFactoryAsyncWaiter(const ShoppingServiceHandlerFactoryAsyncWaiter&) = delete;
  ShoppingServiceHandlerFactoryAsyncWaiter& operator=(const ShoppingServiceHandlerFactoryAsyncWaiter&) = delete;

  ~ShoppingServiceHandlerFactoryAsyncWaiter();

 private:
  ShoppingServiceHandlerFactory* const proxy_;
};


class  ShoppingServiceHandlerInterceptorForTesting : public ShoppingServiceHandler {
  virtual ShoppingServiceHandler* GetForwardingInterface() = 0;
  void GetProductInfoForCurrentUrl(GetProductInfoForCurrentUrlCallback callback) override;
  void GetProductInfoForUrl(const ::GURL& url, GetProductInfoForUrlCallback callback) override;
  void GetProductInfoForUrls(const std::vector<::GURL>& urls, GetProductInfoForUrlsCallback callback) override;
  void GetPriceInsightsInfoForCurrentUrl(GetPriceInsightsInfoForCurrentUrlCallback callback) override;
  void GetPriceInsightsInfoForUrl(const ::GURL& url, GetPriceInsightsInfoForUrlCallback callback) override;
  void GetProductSpecificationsForUrls(const std::vector<::GURL>& urls, GetProductSpecificationsForUrlsCallback callback) override;
  void GetUrlInfosForProductTabs(GetUrlInfosForProductTabsCallback callback) override;
  void GetUrlInfosForRecentlyViewedTabs(GetUrlInfosForRecentlyViewedTabsCallback callback) override;
  void IsShoppingListEligible(IsShoppingListEligibleCallback callback) override;
  void GetPriceTrackingStatusForCurrentUrl(GetPriceTrackingStatusForCurrentUrlCallback callback) override;
  void OpenUrlInNewTab(const ::GURL& url) override;
  void SwitchToOrOpenTab(const ::GURL& url) override;
  void GetAllProductSpecificationsSets(GetAllProductSpecificationsSetsCallback callback) override;
  void GetProductSpecificationsSetByUuid(const ::base::Uuid& uuid, GetProductSpecificationsSetByUuidCallback callback) override;
  void AddProductSpecificationsSet(const std::string& name, const std::vector<::GURL>& urls, AddProductSpecificationsSetCallback callback) override;
  void DeleteProductSpecificationsSet(const ::base::Uuid& uuid) override;
  void SetNameForProductSpecificationsSet(const ::base::Uuid& uuid, const std::string& name, SetNameForProductSpecificationsSetCallback callback) override;
  void SetUrlsForProductSpecificationsSet(const ::base::Uuid& uuid, const std::vector<::GURL>& urls, SetUrlsForProductSpecificationsSetCallback callback) override;
  void SetProductSpecificationsUserFeedback(UserFeedback feedback) override;
  void GetProductSpecificationsFeatureState(GetProductSpecificationsFeatureStateCallback callback) override;
};
class  ShoppingServiceHandlerAsyncWaiter {
 public:
  explicit ShoppingServiceHandlerAsyncWaiter(ShoppingServiceHandler* proxy);

  ShoppingServiceHandlerAsyncWaiter(const ShoppingServiceHandlerAsyncWaiter&) = delete;
  ShoppingServiceHandlerAsyncWaiter& operator=(const ShoppingServiceHandlerAsyncWaiter&) = delete;

  ~ShoppingServiceHandlerAsyncWaiter();
  void GetProductInfoForCurrentUrl(
      ::commerce::shared::mojom::ProductInfoPtr* out_productInfo);
  ::commerce::shared::mojom::ProductInfoPtr GetProductInfoForCurrentUrl();
  void GetProductInfoForUrl(
      const ::GURL& url, ::GURL* out_url, ::commerce::shared::mojom::ProductInfoPtr* out_productInfo);
  
  void GetProductInfoForUrls(
      const std::vector<::GURL>& urls, std::vector<::commerce::shared::mojom::ProductInfoPtr>* out_productInfos);
  std::vector<::commerce::shared::mojom::ProductInfoPtr> GetProductInfoForUrls(const std::vector<::GURL>& urls);
  void GetPriceInsightsInfoForCurrentUrl(
      PriceInsightsInfoPtr* out_priceInsightsInfo);
  PriceInsightsInfoPtr GetPriceInsightsInfoForCurrentUrl();
  void GetPriceInsightsInfoForUrl(
      const ::GURL& url, ::GURL* out_url, PriceInsightsInfoPtr* out_priceInsightsInfo);
  
  void GetProductSpecificationsForUrls(
      const std::vector<::GURL>& urls, ProductSpecificationsPtr* out_productSpecs);
  ProductSpecificationsPtr GetProductSpecificationsForUrls(const std::vector<::GURL>& urls);
  void GetUrlInfosForProductTabs(
      std::vector<UrlInfoPtr>* out_url_infos);
  std::vector<UrlInfoPtr> GetUrlInfosForProductTabs();
  void GetUrlInfosForRecentlyViewedTabs(
      std::vector<UrlInfoPtr>* out_url_infos);
  std::vector<UrlInfoPtr> GetUrlInfosForRecentlyViewedTabs();
  void IsShoppingListEligible(
      bool* out_eligible);
  bool IsShoppingListEligible();
  void GetPriceTrackingStatusForCurrentUrl(
      bool* out_tracked);
  bool GetPriceTrackingStatusForCurrentUrl();
  void GetAllProductSpecificationsSets(
      std::vector<::commerce::shared::mojom::ProductSpecificationsSetPtr>* out_sets);
  std::vector<::commerce::shared::mojom::ProductSpecificationsSetPtr> GetAllProductSpecificationsSets();
  void GetProductSpecificationsSetByUuid(
      const ::base::Uuid& uuid, ::commerce::shared::mojom::ProductSpecificationsSetPtr* out_set);
  ::commerce::shared::mojom::ProductSpecificationsSetPtr GetProductSpecificationsSetByUuid(const ::base::Uuid& uuid);
  void AddProductSpecificationsSet(
      const std::string& name, const std::vector<::GURL>& urls, ::commerce::shared::mojom::ProductSpecificationsSetPtr* out_created_set);
  ::commerce::shared::mojom::ProductSpecificationsSetPtr AddProductSpecificationsSet(const std::string& name, const std::vector<::GURL>& urls);
  void SetNameForProductSpecificationsSet(
      const ::base::Uuid& uuid, const std::string& name, ::commerce::shared::mojom::ProductSpecificationsSetPtr* out_updated_set);
  ::commerce::shared::mojom::ProductSpecificationsSetPtr SetNameForProductSpecificationsSet(const ::base::Uuid& uuid, const std::string& name);
  void SetUrlsForProductSpecificationsSet(
      const ::base::Uuid& uuid, const std::vector<::GURL>& urls, ::commerce::shared::mojom::ProductSpecificationsSetPtr* out_updated_set);
  ::commerce::shared::mojom::ProductSpecificationsSetPtr SetUrlsForProductSpecificationsSet(const ::base::Uuid& uuid, const std::vector<::GURL>& urls);
  void GetProductSpecificationsFeatureState(
      ProductSpecificationsFeatureStatePtr* out_state);
  ProductSpecificationsFeatureStatePtr GetProductSpecificationsFeatureState();

 private:
  ShoppingServiceHandler* const proxy_;
};




}  // shopping_service::mojom

#endif  // COMPONENTS_COMMERCE_CORE_MOJOM_SHOPPING_SERVICE_MOJOM_TEST_UTILS_H_