// components/commerce/core/mojom/shopping_service.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_COMMERCE_CORE_MOJOM_SHOPPING_SERVICE_MOJOM_SHARED_H_
#define COMPONENTS_COMMERCE_CORE_MOJOM_SHOPPING_SERVICE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/commerce/core/mojom/shopping_service.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/uuid.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"
#include "components/commerce/core/mojom/shared.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "components/commerce/core/mojom/shopping_service.mojom-data-view.h"




namespace std {

template <>
struct hash<::shopping_service::mojom::UserFeedback>
    : public mojo::internal::EnumHashImpl<::shopping_service::mojom::UserFeedback> {};

template <>
struct hash<::shopping_service::mojom::PriceInsightsInfo_PriceBucket>
    : public mojo::internal::EnumHashImpl<::shopping_service::mojom::PriceInsightsInfo_PriceBucket> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::shopping_service::mojom::UserFeedback, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::shopping_service::mojom::UserFeedback, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::shopping_service::mojom::UserFeedback>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::shopping_service::mojom::PriceInsightsInfo_PriceBucket, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::shopping_service::mojom::PriceInsightsInfo_PriceBucket, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::shopping_service::mojom::PriceInsightsInfo_PriceBucket>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::shopping_service::mojom::PricePointDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::shopping_service::mojom::PricePointDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::shopping_service::mojom::internal::PricePoint_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::date(input)) in_date = Traits::date(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->date)::BaseType> date_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_date,
      date_fragment);

    fragment->date.Set(
        date_fragment.is_null() ? nullptr : date_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->date.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null date in PricePoint struct");

    fragment->price = Traits::price(input);

    decltype(Traits::formatted_price(input)) in_formatted_price = Traits::formatted_price(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->formatted_price)::BaseType> formatted_price_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_formatted_price,
      formatted_price_fragment);

    fragment->formatted_price.Set(
        formatted_price_fragment.is_null() ? nullptr : formatted_price_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->formatted_price.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null formatted_price in PricePoint struct");
  }

  static bool Deserialize(::shopping_service::mojom::internal::PricePoint_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::shopping_service::mojom::PricePointDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::shopping_service::mojom::UrlInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::shopping_service::mojom::UrlInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::shopping_service::mojom::internal::UrlInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_title,
      title_fragment);

    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->title.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null title in UrlInfo struct");

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in UrlInfo struct");

    decltype(Traits::favicon_url(input)) in_favicon_url = Traits::favicon_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->favicon_url)::BaseType> favicon_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_favicon_url,
      favicon_url_fragment);

    fragment->favicon_url.Set(
        favicon_url_fragment.is_null() ? nullptr : favicon_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->favicon_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null favicon_url in UrlInfo struct");

    decltype(Traits::thumbnail_url(input)) in_thumbnail_url = Traits::thumbnail_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->thumbnail_url)::BaseType> thumbnail_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_thumbnail_url,
      thumbnail_url_fragment);

    fragment->thumbnail_url.Set(
        thumbnail_url_fragment.is_null() ? nullptr : thumbnail_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->thumbnail_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null thumbnail_url in UrlInfo struct");

    decltype(Traits::previewText(input)) in_previewText = Traits::previewText(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->previewText)::BaseType> previewText_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_previewText,
      previewText_fragment);

    fragment->previewText.Set(
        previewText_fragment.is_null() ? nullptr : previewText_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->previewText.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null previewText in UrlInfo struct");
  }

  static bool Deserialize(::shopping_service::mojom::internal::UrlInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::shopping_service::mojom::UrlInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::shopping_service::mojom::PriceInsightsInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::shopping_service::mojom::PriceInsightsInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::shopping_service::mojom::internal::PriceInsightsInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->cluster_id = Traits::cluster_id(input);

    decltype(Traits::typical_low_price(input)) in_typical_low_price = Traits::typical_low_price(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->typical_low_price)::BaseType> typical_low_price_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_typical_low_price,
      typical_low_price_fragment);

    fragment->typical_low_price.Set(
        typical_low_price_fragment.is_null() ? nullptr : typical_low_price_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->typical_low_price.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null typical_low_price in PriceInsightsInfo struct");

    decltype(Traits::typical_high_price(input)) in_typical_high_price = Traits::typical_high_price(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->typical_high_price)::BaseType> typical_high_price_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_typical_high_price,
      typical_high_price_fragment);

    fragment->typical_high_price.Set(
        typical_high_price_fragment.is_null() ? nullptr : typical_high_price_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->typical_high_price.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null typical_high_price in PriceInsightsInfo struct");

    decltype(Traits::catalog_attributes(input)) in_catalog_attributes = Traits::catalog_attributes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->catalog_attributes)::BaseType> catalog_attributes_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_catalog_attributes,
      catalog_attributes_fragment);

    fragment->catalog_attributes.Set(
        catalog_attributes_fragment.is_null() ? nullptr : catalog_attributes_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->catalog_attributes.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null catalog_attributes in PriceInsightsInfo struct");

    decltype(Traits::jackpot(input)) in_jackpot = Traits::jackpot(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->jackpot)::BaseType> jackpot_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_jackpot,
      jackpot_fragment);

    fragment->jackpot.Set(
        jackpot_fragment.is_null() ? nullptr : jackpot_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->jackpot.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null jackpot in PriceInsightsInfo struct");

    
    mojo::internal::Serialize<::shopping_service::mojom::PriceInsightsInfo_PriceBucket>(
      Traits::bucket(input),
      &fragment->bucket);

    fragment->has_multiple_catalogs = Traits::has_multiple_catalogs(input);

    decltype(Traits::history(input)) in_history = Traits::history(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->history)::BaseType>
        history_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& history_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::shopping_service::mojom::PricePointDataView>>(
      in_history,
      history_fragment,
      &history_validate_params);

    fragment->history.Set(
        history_fragment.is_null() ? nullptr : history_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->history.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null history in PriceInsightsInfo struct");

    decltype(Traits::locale(input)) in_locale = Traits::locale(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->locale)::BaseType> locale_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_locale,
      locale_fragment);

    fragment->locale.Set(
        locale_fragment.is_null() ? nullptr : locale_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->locale.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null locale in PriceInsightsInfo struct");

    decltype(Traits::currency_code(input)) in_currency_code = Traits::currency_code(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->currency_code)::BaseType> currency_code_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_currency_code,
      currency_code_fragment);

    fragment->currency_code.Set(
        currency_code_fragment.is_null() ? nullptr : currency_code_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->currency_code.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null currency_code in PriceInsightsInfo struct");
  }

  static bool Deserialize(::shopping_service::mojom::internal::PriceInsightsInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::shopping_service::mojom::PriceInsightsInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::shopping_service::mojom::ProductSpecificationsDescriptionTextDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::shopping_service::mojom::ProductSpecificationsDescriptionTextDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::shopping_service::mojom::internal::ProductSpecificationsDescriptionText_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::text(input)) in_text = Traits::text(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->text)::BaseType> text_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_text,
      text_fragment);

    fragment->text.Set(
        text_fragment.is_null() ? nullptr : text_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->text.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null text in ProductSpecificationsDescriptionText struct");

    decltype(Traits::urls(input)) in_urls = Traits::urls(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->urls)::BaseType>
        urls_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& urls_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::shopping_service::mojom::UrlInfoDataView>>(
      in_urls,
      urls_fragment,
      &urls_validate_params);

    fragment->urls.Set(
        urls_fragment.is_null() ? nullptr : urls_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->urls.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null urls in ProductSpecificationsDescriptionText struct");
  }

  static bool Deserialize(::shopping_service::mojom::internal::ProductSpecificationsDescriptionText_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::shopping_service::mojom::ProductSpecificationsDescriptionTextDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::shopping_service::mojom::ProductSpecificationsOptionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::shopping_service::mojom::ProductSpecificationsOptionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::shopping_service::mojom::internal::ProductSpecificationsOption_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::descriptions(input)) in_descriptions = Traits::descriptions(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->descriptions)::BaseType>
        descriptions_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& descriptions_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::shopping_service::mojom::ProductSpecificationsDescriptionTextDataView>>(
      in_descriptions,
      descriptions_fragment,
      &descriptions_validate_params);

    fragment->descriptions.Set(
        descriptions_fragment.is_null() ? nullptr : descriptions_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->descriptions.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null descriptions in ProductSpecificationsOption struct");
  }

  static bool Deserialize(::shopping_service::mojom::internal::ProductSpecificationsOption_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::shopping_service::mojom::ProductSpecificationsOptionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::shopping_service::mojom::ProductSpecificationsDescriptionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::shopping_service::mojom::ProductSpecificationsDescriptionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::shopping_service::mojom::internal::ProductSpecificationsDescription_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::options(input)) in_options = Traits::options(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->options)::BaseType>
        options_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& options_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::shopping_service::mojom::ProductSpecificationsOptionDataView>>(
      in_options,
      options_fragment,
      &options_validate_params);

    fragment->options.Set(
        options_fragment.is_null() ? nullptr : options_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->options.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null options in ProductSpecificationsDescription struct");

    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_label,
      label_fragment);

    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->label.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in ProductSpecificationsDescription struct");

    decltype(Traits::alt_text(input)) in_alt_text = Traits::alt_text(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->alt_text)::BaseType> alt_text_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_alt_text,
      alt_text_fragment);

    fragment->alt_text.Set(
        alt_text_fragment.is_null() ? nullptr : alt_text_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->alt_text.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null alt_text in ProductSpecificationsDescription struct");
  }

  static bool Deserialize(::shopping_service::mojom::internal::ProductSpecificationsDescription_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::shopping_service::mojom::ProductSpecificationsDescriptionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::shopping_service::mojom::ProductSpecificationsValueDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::shopping_service::mojom::ProductSpecificationsValueDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::shopping_service::mojom::internal::ProductSpecificationsValue_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::specification_descriptions(input)) in_specification_descriptions = Traits::specification_descriptions(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->specification_descriptions)::BaseType>
        specification_descriptions_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& specification_descriptions_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::shopping_service::mojom::ProductSpecificationsDescriptionDataView>>(
      in_specification_descriptions,
      specification_descriptions_fragment,
      &specification_descriptions_validate_params);

    fragment->specification_descriptions.Set(
        specification_descriptions_fragment.is_null() ? nullptr : specification_descriptions_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->specification_descriptions.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null specification_descriptions in ProductSpecificationsValue struct");

    decltype(Traits::summary(input)) in_summary = Traits::summary(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->summary)::BaseType>
        summary_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& summary_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::shopping_service::mojom::ProductSpecificationsDescriptionTextDataView>>(
      in_summary,
      summary_fragment,
      &summary_validate_params);

    fragment->summary.Set(
        summary_fragment.is_null() ? nullptr : summary_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->summary.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null summary in ProductSpecificationsValue struct");
  }

  static bool Deserialize(::shopping_service::mojom::internal::ProductSpecificationsValue_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::shopping_service::mojom::ProductSpecificationsValueDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::shopping_service::mojom::ProductSpecificationsProductDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::shopping_service::mojom::ProductSpecificationsProductDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::shopping_service::mojom::internal::ProductSpecificationsProduct_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->product_cluster_id = Traits::product_cluster_id(input);

    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_title,
      title_fragment);

    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->title.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null title in ProductSpecificationsProduct struct");

    decltype(Traits::image_url(input)) in_image_url = Traits::image_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->image_url)::BaseType> image_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_image_url,
      image_url_fragment);

    fragment->image_url.Set(
        image_url_fragment.is_null() ? nullptr : image_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->image_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null image_url in ProductSpecificationsProduct struct");

    decltype(Traits::product_dimension_values(input)) in_product_dimension_values = Traits::product_dimension_values(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->product_dimension_values)::BaseType>
        product_dimension_values_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& product_dimension_values_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<uint64_t, ::shopping_service::mojom::ProductSpecificationsValueDataView>>(
      in_product_dimension_values,
      product_dimension_values_fragment,
      &product_dimension_values_validate_params);

    fragment->product_dimension_values.Set(
        product_dimension_values_fragment.is_null() ? nullptr : product_dimension_values_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->product_dimension_values.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null product_dimension_values in ProductSpecificationsProduct struct");

    decltype(Traits::summary(input)) in_summary = Traits::summary(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->summary)::BaseType>
        summary_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& summary_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::shopping_service::mojom::ProductSpecificationsDescriptionTextDataView>>(
      in_summary,
      summary_fragment,
      &summary_validate_params);

    fragment->summary.Set(
        summary_fragment.is_null() ? nullptr : summary_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->summary.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null summary in ProductSpecificationsProduct struct");

    decltype(Traits::buying_options_url(input)) in_buying_options_url = Traits::buying_options_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->buying_options_url)::BaseType> buying_options_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_buying_options_url,
      buying_options_url_fragment);

    fragment->buying_options_url.Set(
        buying_options_url_fragment.is_null() ? nullptr : buying_options_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->buying_options_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null buying_options_url in ProductSpecificationsProduct struct");
  }

  static bool Deserialize(::shopping_service::mojom::internal::ProductSpecificationsProduct_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::shopping_service::mojom::ProductSpecificationsProductDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::shopping_service::mojom::ProductSpecificationsFeatureStateDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::shopping_service::mojom::ProductSpecificationsFeatureStateDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::shopping_service::mojom::internal::ProductSpecificationsFeatureState_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->is_syncing_tab_compare = Traits::is_syncing_tab_compare(input);

    fragment->can_load_full_page_ui = Traits::can_load_full_page_ui(input);

    fragment->can_manage_sets = Traits::can_manage_sets(input);

    fragment->can_fetch_data = Traits::can_fetch_data(input);

    fragment->is_allowed_for_enterprise = Traits::is_allowed_for_enterprise(input);

    fragment->is_quality_logging_allowed = Traits::is_quality_logging_allowed(input);

    fragment->is_signed_in = Traits::is_signed_in(input);
  }

  static bool Deserialize(::shopping_service::mojom::internal::ProductSpecificationsFeatureState_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::shopping_service::mojom::ProductSpecificationsFeatureStateDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::shopping_service::mojom::ProductSpecificationsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::shopping_service::mojom::ProductSpecificationsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::shopping_service::mojom::internal::ProductSpecifications_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::product_dimension_map(input)) in_product_dimension_map = Traits::product_dimension_map(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->product_dimension_map)::BaseType>
        product_dimension_map_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& product_dimension_map_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<uint64_t, mojo::StringDataView>>(
      in_product_dimension_map,
      product_dimension_map_fragment,
      &product_dimension_map_validate_params);

    fragment->product_dimension_map.Set(
        product_dimension_map_fragment.is_null() ? nullptr : product_dimension_map_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->product_dimension_map.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null product_dimension_map in ProductSpecifications struct");

    decltype(Traits::products(input)) in_products = Traits::products(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->products)::BaseType>
        products_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& products_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::shopping_service::mojom::ProductSpecificationsProductDataView>>(
      in_products,
      products_fragment,
      &products_validate_params);

    fragment->products.Set(
        products_fragment.is_null() ? nullptr : products_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->products.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null products in ProductSpecifications struct");
  }

  static bool Deserialize(::shopping_service::mojom::internal::ProductSpecifications_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::shopping_service::mojom::ProductSpecificationsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace shopping_service::mojom {

inline void PricePointDataView::GetDateDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->date.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PricePointDataView::GetFormattedPriceDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->formatted_price.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void UrlInfoDataView::GetTitleDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->title.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void UrlInfoDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void UrlInfoDataView::GetFaviconUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->favicon_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void UrlInfoDataView::GetThumbnailUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->thumbnail_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void UrlInfoDataView::GetPreviewTextDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->previewText.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void PriceInsightsInfoDataView::GetTypicalLowPriceDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->typical_low_price.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PriceInsightsInfoDataView::GetTypicalHighPriceDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->typical_high_price.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PriceInsightsInfoDataView::GetCatalogAttributesDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->catalog_attributes.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PriceInsightsInfoDataView::GetJackpotDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->jackpot.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void PriceInsightsInfoDataView::GetHistoryDataView(
    mojo::ArrayDataView<PricePointDataView>* output) {
  auto pointer = data_->history.Get();
  *output = mojo::ArrayDataView<PricePointDataView>(pointer, message_);
}
inline void PriceInsightsInfoDataView::GetLocaleDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->locale.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PriceInsightsInfoDataView::GetCurrencyCodeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->currency_code.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void ProductSpecificationsDescriptionTextDataView::GetTextDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->text.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ProductSpecificationsDescriptionTextDataView::GetUrlsDataView(
    mojo::ArrayDataView<UrlInfoDataView>* output) {
  auto pointer = data_->urls.Get();
  *output = mojo::ArrayDataView<UrlInfoDataView>(pointer, message_);
}


inline void ProductSpecificationsOptionDataView::GetDescriptionsDataView(
    mojo::ArrayDataView<ProductSpecificationsDescriptionTextDataView>* output) {
  auto pointer = data_->descriptions.Get();
  *output = mojo::ArrayDataView<ProductSpecificationsDescriptionTextDataView>(pointer, message_);
}


inline void ProductSpecificationsDescriptionDataView::GetOptionsDataView(
    mojo::ArrayDataView<ProductSpecificationsOptionDataView>* output) {
  auto pointer = data_->options.Get();
  *output = mojo::ArrayDataView<ProductSpecificationsOptionDataView>(pointer, message_);
}
inline void ProductSpecificationsDescriptionDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ProductSpecificationsDescriptionDataView::GetAltTextDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->alt_text.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void ProductSpecificationsValueDataView::GetSpecificationDescriptionsDataView(
    mojo::ArrayDataView<ProductSpecificationsDescriptionDataView>* output) {
  auto pointer = data_->specification_descriptions.Get();
  *output = mojo::ArrayDataView<ProductSpecificationsDescriptionDataView>(pointer, message_);
}
inline void ProductSpecificationsValueDataView::GetSummaryDataView(
    mojo::ArrayDataView<ProductSpecificationsDescriptionTextDataView>* output) {
  auto pointer = data_->summary.Get();
  *output = mojo::ArrayDataView<ProductSpecificationsDescriptionTextDataView>(pointer, message_);
}


inline void ProductSpecificationsProductDataView::GetTitleDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->title.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ProductSpecificationsProductDataView::GetImageUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->image_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void ProductSpecificationsProductDataView::GetProductDimensionValuesDataView(
    mojo::MapDataView<uint64_t, ProductSpecificationsValueDataView>* output) {
  auto pointer = data_->product_dimension_values.Get();
  *output = mojo::MapDataView<uint64_t, ProductSpecificationsValueDataView>(pointer, message_);
}
inline void ProductSpecificationsProductDataView::GetSummaryDataView(
    mojo::ArrayDataView<ProductSpecificationsDescriptionTextDataView>* output) {
  auto pointer = data_->summary.Get();
  *output = mojo::ArrayDataView<ProductSpecificationsDescriptionTextDataView>(pointer, message_);
}
inline void ProductSpecificationsProductDataView::GetBuyingOptionsUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->buying_options_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}




inline void ProductSpecificationsDataView::GetProductDimensionMapDataView(
    mojo::MapDataView<uint64_t, mojo::StringDataView>* output) {
  auto pointer = data_->product_dimension_map.Get();
  *output = mojo::MapDataView<uint64_t, mojo::StringDataView>(pointer, message_);
}
inline void ProductSpecificationsDataView::GetProductsDataView(
    mojo::ArrayDataView<ProductSpecificationsProductDataView>* output) {
  auto pointer = data_->products.Get();
  *output = mojo::ArrayDataView<ProductSpecificationsProductDataView>(pointer, message_);
}



}  // shopping_service::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::shopping_service::mojom::UserFeedback> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::shopping_service::mojom::UserFeedback value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::shopping_service::mojom::PriceInsightsInfo_PriceBucket> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::shopping_service::mojom::PriceInsightsInfo_PriceBucket value);
};

} // namespace perfetto

#endif  // COMPONENTS_COMMERCE_CORE_MOJOM_SHOPPING_SERVICE_MOJOM_SHARED_H_