// components/commerce/core/mojom/shopping_service.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_COMMERCE_CORE_MOJOM_SHOPPING_SERVICE_MOJOM_SHARED_INTERNAL_H_
#define COMPONENTS_COMMERCE_CORE_MOJOM_SHOPPING_SERVICE_MOJOM_SHARED_INTERNAL_H_
#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "mojo/public/mojom/base/string16.mojom-shared-internal.h"
#include "mojo/public/mojom/base/uuid.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared-internal.h"
#include "mojo/public/mojom/base/values.mojom-shared-internal.h"
#include "components/commerce/core/mojom/shared.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}


namespace shopping_service::mojom {
namespace internal {
class PricePoint_Data;
class UrlInfo_Data;
class PriceInsightsInfo_Data;
class ProductSpecificationsDescriptionText_Data;
class ProductSpecificationsOption_Data;
class ProductSpecificationsDescription_Data;
class ProductSpecificationsValue_Data;
class ProductSpecificationsProduct_Data;
class ProductSpecificationsFeatureState_Data;
class ProductSpecifications_Data;

struct UserFeedback_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct PriceInsightsInfo_PriceBucket_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
      case 3:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

#pragma pack(push, 1)
class  PricePoint_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> date;
  float price;
  uint8_t pad1_[4];
  mojo::internal::Pointer<mojo::internal::String_Data> formatted_price;

 private:
  friend class mojo::internal::MessageFragment<PricePoint_Data>;

  PricePoint_Data();
  ~PricePoint_Data() = delete;
};
static_assert(sizeof(PricePoint_Data) == 32,
              "Bad sizeof(PricePoint_Data)");
// Used by PricePoint::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct PricePoint_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  PricePoint_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~PricePoint_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<PricePoint_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    PricePoint_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  UrlInfo_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> title;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> url;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> favicon_url;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> thumbnail_url;
  mojo::internal::Pointer<mojo::internal::String_Data> previewText;

 private:
  friend class mojo::internal::MessageFragment<UrlInfo_Data>;

  UrlInfo_Data();
  ~UrlInfo_Data() = delete;
};
static_assert(sizeof(UrlInfo_Data) == 48,
              "Bad sizeof(UrlInfo_Data)");
// Used by UrlInfo::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct UrlInfo_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  UrlInfo_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~UrlInfo_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<UrlInfo_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    UrlInfo_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  PriceInsightsInfo_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint64_t cluster_id;
  mojo::internal::Pointer<mojo::internal::String_Data> typical_low_price;
  mojo::internal::Pointer<mojo::internal::String_Data> typical_high_price;
  mojo::internal::Pointer<mojo::internal::String_Data> catalog_attributes;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> jackpot;
  int32_t bucket;
  uint8_t has_multiple_catalogs : 1;
  uint8_t pad6_[3];
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::PricePoint_Data>>> history;
  mojo::internal::Pointer<mojo::internal::String_Data> locale;
  mojo::internal::Pointer<mojo::internal::String_Data> currency_code;

 private:
  friend class mojo::internal::MessageFragment<PriceInsightsInfo_Data>;

  PriceInsightsInfo_Data();
  ~PriceInsightsInfo_Data() = delete;
};
static_assert(sizeof(PriceInsightsInfo_Data) == 80,
              "Bad sizeof(PriceInsightsInfo_Data)");
// Used by PriceInsightsInfo::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct PriceInsightsInfo_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  PriceInsightsInfo_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~PriceInsightsInfo_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<PriceInsightsInfo_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    PriceInsightsInfo_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  ProductSpecificationsDescriptionText_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> text;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::UrlInfo_Data>>> urls;

 private:
  friend class mojo::internal::MessageFragment<ProductSpecificationsDescriptionText_Data>;

  ProductSpecificationsDescriptionText_Data();
  ~ProductSpecificationsDescriptionText_Data() = delete;
};
static_assert(sizeof(ProductSpecificationsDescriptionText_Data) == 24,
              "Bad sizeof(ProductSpecificationsDescriptionText_Data)");
// Used by ProductSpecificationsDescriptionText::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct ProductSpecificationsDescriptionText_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  ProductSpecificationsDescriptionText_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~ProductSpecificationsDescriptionText_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<ProductSpecificationsDescriptionText_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    ProductSpecificationsDescriptionText_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  ProductSpecificationsOption_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::ProductSpecificationsDescriptionText_Data>>> descriptions;

 private:
  friend class mojo::internal::MessageFragment<ProductSpecificationsOption_Data>;

  ProductSpecificationsOption_Data();
  ~ProductSpecificationsOption_Data() = delete;
};
static_assert(sizeof(ProductSpecificationsOption_Data) == 16,
              "Bad sizeof(ProductSpecificationsOption_Data)");
// Used by ProductSpecificationsOption::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct ProductSpecificationsOption_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  ProductSpecificationsOption_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~ProductSpecificationsOption_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<ProductSpecificationsOption_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    ProductSpecificationsOption_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  ProductSpecificationsDescription_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::ProductSpecificationsOption_Data>>> options;
  mojo::internal::Pointer<mojo::internal::String_Data> label;
  mojo::internal::Pointer<mojo::internal::String_Data> alt_text;

 private:
  friend class mojo::internal::MessageFragment<ProductSpecificationsDescription_Data>;

  ProductSpecificationsDescription_Data();
  ~ProductSpecificationsDescription_Data() = delete;
};
static_assert(sizeof(ProductSpecificationsDescription_Data) == 32,
              "Bad sizeof(ProductSpecificationsDescription_Data)");
// Used by ProductSpecificationsDescription::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct ProductSpecificationsDescription_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  ProductSpecificationsDescription_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~ProductSpecificationsDescription_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<ProductSpecificationsDescription_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    ProductSpecificationsDescription_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  ProductSpecificationsValue_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::ProductSpecificationsDescription_Data>>> specification_descriptions;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::ProductSpecificationsDescriptionText_Data>>> summary;

 private:
  friend class mojo::internal::MessageFragment<ProductSpecificationsValue_Data>;

  ProductSpecificationsValue_Data();
  ~ProductSpecificationsValue_Data() = delete;
};
static_assert(sizeof(ProductSpecificationsValue_Data) == 24,
              "Bad sizeof(ProductSpecificationsValue_Data)");
// Used by ProductSpecificationsValue::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct ProductSpecificationsValue_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  ProductSpecificationsValue_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~ProductSpecificationsValue_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<ProductSpecificationsValue_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    ProductSpecificationsValue_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  ProductSpecificationsProduct_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint64_t product_cluster_id;
  mojo::internal::Pointer<mojo::internal::String_Data> title;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> image_url;
  mojo::internal::Pointer<mojo::internal::Map_Data<uint64_t, mojo::internal::Pointer<internal::ProductSpecificationsValue_Data>>> product_dimension_values;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::ProductSpecificationsDescriptionText_Data>>> summary;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> buying_options_url;

 private:
  friend class mojo::internal::MessageFragment<ProductSpecificationsProduct_Data>;

  ProductSpecificationsProduct_Data();
  ~ProductSpecificationsProduct_Data() = delete;
};
static_assert(sizeof(ProductSpecificationsProduct_Data) == 56,
              "Bad sizeof(ProductSpecificationsProduct_Data)");
// Used by ProductSpecificationsProduct::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct ProductSpecificationsProduct_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  ProductSpecificationsProduct_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~ProductSpecificationsProduct_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<ProductSpecificationsProduct_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    ProductSpecificationsProduct_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  ProductSpecificationsFeatureState_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t is_syncing_tab_compare : 1;
  uint8_t can_load_full_page_ui : 1;
  uint8_t can_manage_sets : 1;
  uint8_t can_fetch_data : 1;
  uint8_t is_allowed_for_enterprise : 1;
  uint8_t is_quality_logging_allowed : 1;
  uint8_t is_signed_in : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<ProductSpecificationsFeatureState_Data>;

  ProductSpecificationsFeatureState_Data();
  ~ProductSpecificationsFeatureState_Data() = delete;
};
static_assert(sizeof(ProductSpecificationsFeatureState_Data) == 16,
              "Bad sizeof(ProductSpecificationsFeatureState_Data)");
// Used by ProductSpecificationsFeatureState::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct ProductSpecificationsFeatureState_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  ProductSpecificationsFeatureState_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~ProductSpecificationsFeatureState_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<ProductSpecificationsFeatureState_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    ProductSpecificationsFeatureState_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  ProductSpecifications_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Map_Data<uint64_t, mojo::internal::Pointer<mojo::internal::String_Data>>> product_dimension_map;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::ProductSpecificationsProduct_Data>>> products;

 private:
  friend class mojo::internal::MessageFragment<ProductSpecifications_Data>;

  ProductSpecifications_Data();
  ~ProductSpecifications_Data() = delete;
};
static_assert(sizeof(ProductSpecifications_Data) == 24,
              "Bad sizeof(ProductSpecifications_Data)");
// Used by ProductSpecifications::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct ProductSpecifications_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  ProductSpecifications_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~ProductSpecifications_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<ProductSpecifications_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    ProductSpecifications_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal

}  // shopping_service::mojom

#endif  // COMPONENTS_COMMERCE_CORE_MOJOM_SHOPPING_SERVICE_MOJOM_SHARED_INTERNAL_H_