// components/commerce/core/mojom/shared.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/commerce/core/mojom/shared.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/commerce/core/mojom/shared.mojom-params-data.h"
#include "components/commerce/core/mojom/shared.mojom-shared-message-ids.h"

#include "components/commerce/core/mojom/shared.mojom-import-headers.h"
#include "components/commerce/core/mojom/shared.mojom-test-utils.h"


namespace commerce::shared::mojom {
ProductInfo::ProductInfo()
    : title(),
      cluster_title(),
      domain(),
      image_url(),
      product_url(),
      current_price(),
      previous_price(),
      cluster_id(),
      category_labels(),
      price_summary() {}

ProductInfo::ProductInfo(
    const std::string& title_in,
    const std::string& cluster_title_in,
    const std::string& domain_in,
    const ::GURL& image_url_in,
    const ::GURL& product_url_in,
    const std::string& current_price_in,
    const std::string& previous_price_in,
    uint64_t cluster_id_in,
    std::vector<std::string> category_labels_in,
    const std::string& price_summary_in)
    : title(std::move(title_in)),
      cluster_title(std::move(cluster_title_in)),
      domain(std::move(domain_in)),
      image_url(std::move(image_url_in)),
      product_url(std::move(product_url_in)),
      current_price(std::move(current_price_in)),
      previous_price(std::move(previous_price_in)),
      cluster_id(std::move(cluster_id_in)),
      category_labels(std::move(category_labels_in)),
      price_summary(std::move(price_summary_in)) {}

ProductInfo::~ProductInfo() = default;

void ProductInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cluster_title"), this->cluster_title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "domain"), this->domain,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "image_url"), this->image_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "product_url"), this->product_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "current_price"), this->current_price,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "previous_price"), this->previous_price,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cluster_id"), this->cluster_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "category_labels"), this->category_labels,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "price_summary"), this->price_summary,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ProductInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
BookmarkProductInfo::BookmarkProductInfo()
    : bookmark_id(),
      info() {}

BookmarkProductInfo::BookmarkProductInfo(
    int64_t bookmark_id_in,
    ProductInfoPtr info_in)
    : bookmark_id(std::move(bookmark_id_in)),
      info(std::move(info_in)) {}

BookmarkProductInfo::~BookmarkProductInfo() = default;

void BookmarkProductInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bookmark_id"), this->bookmark_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "info"), this->info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ProductInfoPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BookmarkProductInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ProductSpecificationsSet::ProductSpecificationsSet()
    : name(),
      uuid(),
      urls() {}

ProductSpecificationsSet::ProductSpecificationsSet(
    const std::string& name_in,
    const ::base::Uuid& uuid_in,
    std::vector<::GURL> urls_in)
    : name(std::move(name_in)),
      uuid(std::move(uuid_in)),
      urls(std::move(urls_in)) {}

ProductSpecificationsSet::~ProductSpecificationsSet() = default;

void ProductSpecificationsSet::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "uuid"), this->uuid,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::Uuid&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "urls"), this->urls,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::GURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ProductSpecificationsSet::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // commerce::shared::mojom


namespace mojo {


// static
bool StructTraits<::commerce::shared::mojom::ProductInfo::DataView, ::commerce::shared::mojom::ProductInfoPtr>::Read(
    ::commerce::shared::mojom::ProductInfo::DataView input,
    ::commerce::shared::mojom::ProductInfoPtr* output) {
  bool success = true;
  ::commerce::shared::mojom::ProductInfoPtr result(::commerce::shared::mojom::ProductInfo::New());
  
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success && !input.ReadClusterTitle(&result->cluster_title))
        success = false;
      if (success && !input.ReadDomain(&result->domain))
        success = false;
      if (success && !input.ReadImageUrl(&result->image_url))
        success = false;
      if (success && !input.ReadProductUrl(&result->product_url))
        success = false;
      if (success && !input.ReadCurrentPrice(&result->current_price))
        success = false;
      if (success && !input.ReadPreviousPrice(&result->previous_price))
        success = false;
      if (success)
        result->cluster_id = input.cluster_id();
      if (success && !input.ReadCategoryLabels(&result->category_labels))
        success = false;
      if (success && !input.ReadPriceSummary(&result->price_summary))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::commerce::shared::mojom::BookmarkProductInfo::DataView, ::commerce::shared::mojom::BookmarkProductInfoPtr>::Read(
    ::commerce::shared::mojom::BookmarkProductInfo::DataView input,
    ::commerce::shared::mojom::BookmarkProductInfoPtr* output) {
  bool success = true;
  ::commerce::shared::mojom::BookmarkProductInfoPtr result(::commerce::shared::mojom::BookmarkProductInfo::New());
  
      if (success)
        result->bookmark_id = input.bookmark_id();
      if (success && !input.ReadInfo(&result->info))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::commerce::shared::mojom::ProductSpecificationsSet::DataView, ::commerce::shared::mojom::ProductSpecificationsSetPtr>::Read(
    ::commerce::shared::mojom::ProductSpecificationsSet::DataView input,
    ::commerce::shared::mojom::ProductSpecificationsSetPtr* output) {
  bool success = true;
  ::commerce::shared::mojom::ProductSpecificationsSetPtr result(::commerce::shared::mojom::ProductSpecificationsSet::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadUuid(&result->uuid))
        success = false;
      if (success && !input.ReadUrls(&result->urls))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace commerce::shared::mojom {




}  // commerce::shared::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif