// components/commerce/core/mojom/shared.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_COMMERCE_CORE_MOJOM_SHARED_MOJOM_DATA_VIEW_H_
#define COMPONENTS_COMMERCE_CORE_MOJOM_SHARED_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "components/commerce/core/mojom/shared.mojom-shared-internal.h"
#include "mojo/public/mojom/base/uuid.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace commerce::shared::mojom {
class ProductInfoDataView;

class BookmarkProductInfoDataView;

class ProductSpecificationsSetDataView;



}  // commerce::shared::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::commerce::shared::mojom::ProductInfoDataView> {
  using Data = ::commerce::shared::mojom::internal::ProductInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::commerce::shared::mojom::BookmarkProductInfoDataView> {
  using Data = ::commerce::shared::mojom::internal::BookmarkProductInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::commerce::shared::mojom::ProductSpecificationsSetDataView> {
  using Data = ::commerce::shared::mojom::internal::ProductSpecificationsSet_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace commerce::shared::mojom {


class ProductInfoDataView {
 public:
  ProductInfoDataView() = default;

  ProductInfoDataView(
      internal::ProductInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTitleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetClusterTitleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadClusterTitle(UserType* output) {
    
    auto* pointer = data_->cluster_title.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDomainDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDomain(UserType* output) {
    
    auto* pointer = data_->domain.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetImageUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadImageUrl(UserType* output) {
    
    auto* pointer = data_->image_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetProductUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProductUrl(UserType* output) {
    
    auto* pointer = data_->product_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetCurrentPriceDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCurrentPrice(UserType* output) {
    
    auto* pointer = data_->current_price.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetPreviousPriceDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPreviousPrice(UserType* output) {
    
    auto* pointer = data_->previous_price.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  uint64_t cluster_id() const {
    return data_->cluster_id;
  }
  inline void GetCategoryLabelsDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCategoryLabels(UserType* output) {
    
    auto* pointer = data_->category_labels.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  inline void GetPriceSummaryDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPriceSummary(UserType* output) {
    
    auto* pointer = data_->price_summary.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::ProductInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BookmarkProductInfoDataView {
 public:
  BookmarkProductInfoDataView() = default;

  BookmarkProductInfoDataView(
      internal::BookmarkProductInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int64_t bookmark_id() const {
    return data_->bookmark_id;
  }
  inline void GetInfoDataView(
      ProductInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInfo(UserType* output) {
    
    auto* pointer = data_->info.Get();
    return mojo::internal::Deserialize<::commerce::shared::mojom::ProductInfoDataView>(
        pointer, output, message_);
  }
 private:
  internal::BookmarkProductInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ProductSpecificationsSetDataView {
 public:
  ProductSpecificationsSetDataView() = default;

  ProductSpecificationsSetDataView(
      internal::ProductSpecificationsSet_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetUuidDataView(
      ::mojo_base::mojom::UuidDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUuid(UserType* output) {
    
    auto* pointer = data_->uuid.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UuidDataView>(
        pointer, output, message_);
  }
  inline void GetUrlsDataView(
      mojo::ArrayDataView<::url::mojom::UrlDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrls(UserType* output) {
    
    auto* pointer = data_->urls.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
        pointer, output, message_);
  }
 private:
  internal::ProductSpecificationsSet_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // commerce::shared::mojom

#endif  // COMPONENTS_COMMERCE_CORE_MOJOM_SHARED_MOJOM_DATA_VIEW_H_