// components/commerce/core/mojom/price_tracking.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_COMMERCE_CORE_MOJOM_PRICE_TRACKING_MOJOM_H_
#define COMPONENTS_COMMERCE_CORE_MOJOM_PRICE_TRACKING_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/commerce/core/mojom/price_tracking.mojom-features.h"  // IWYU pragma: export
#include "components/commerce/core/mojom/price_tracking.mojom-shared.h"  // IWYU pragma: export
#include "components/commerce/core/mojom/price_tracking.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/string16.mojom.h"
#include "components/commerce/core/mojom/shared.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace commerce::price_tracking::mojom {

class PriceTrackingHandlerProxy;

template <typename ImplRefTraits>
class PriceTrackingHandlerStub;

class PriceTrackingHandlerRequestValidator;
class PriceTrackingHandlerResponseValidator;


class PriceTrackingHandler
    : public PriceTrackingHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "commerce.price_tracking.mojom.PriceTrackingHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PriceTrackingHandlerInterfaceBase;
  using Proxy_ = PriceTrackingHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = PriceTrackingHandlerStub<ImplRefTraits>;

  using RequestValidator_ = PriceTrackingHandlerRequestValidator;
  using ResponseValidator_ = PriceTrackingHandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kTrackPriceForBookmarkMinVersion = 0,
    kUntrackPriceForBookmarkMinVersion = 0,
    kSetPriceTrackingStatusForCurrentUrlMinVersion = 0,
    kGetAllShoppingBookmarkProductInfoMinVersion = 0,
    kGetAllPriceTrackedBookmarkProductInfoMinVersion = 0,
    kGetShoppingCollectionBookmarkFolderIdMinVersion = 0,
    kGetParentBookmarkFolderNameForCurrentUrlMinVersion = 0,
    kShowBookmarkEditorForCurrentUrlMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct TrackPriceForBookmark_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UntrackPriceForBookmark_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetPriceTrackingStatusForCurrentUrl_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetAllShoppingBookmarkProductInfo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetAllPriceTrackedBookmarkProductInfo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetShoppingCollectionBookmarkFolderId_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetParentBookmarkFolderNameForCurrentUrl_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShowBookmarkEditorForCurrentUrl_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PriceTrackingHandler() = default;

  virtual void TrackPriceForBookmark(int64_t bookmark_id) = 0;

  virtual void UntrackPriceForBookmark(int64_t bookmark_id) = 0;

  virtual void SetPriceTrackingStatusForCurrentUrl(bool track) = 0;

  using GetAllShoppingBookmarkProductInfoCallback = base::OnceCallback<void(std::vector<::commerce::shared::mojom::BookmarkProductInfoPtr>)>;
  using GetAllShoppingBookmarkProductInfoMojoCallback = base::OnceCallback<void(std::vector<::commerce::shared::mojom::BookmarkProductInfoPtr>)>;

  virtual void GetAllShoppingBookmarkProductInfo(GetAllShoppingBookmarkProductInfoCallback callback) = 0;

  using GetAllPriceTrackedBookmarkProductInfoCallback = base::OnceCallback<void(std::vector<::commerce::shared::mojom::BookmarkProductInfoPtr>)>;
  using GetAllPriceTrackedBookmarkProductInfoMojoCallback = base::OnceCallback<void(std::vector<::commerce::shared::mojom::BookmarkProductInfoPtr>)>;

  virtual void GetAllPriceTrackedBookmarkProductInfo(GetAllPriceTrackedBookmarkProductInfoCallback callback) = 0;

  using GetShoppingCollectionBookmarkFolderIdCallback = base::OnceCallback<void(int64_t)>;
  using GetShoppingCollectionBookmarkFolderIdMojoCallback = base::OnceCallback<void(int64_t)>;

  virtual void GetShoppingCollectionBookmarkFolderId(GetShoppingCollectionBookmarkFolderIdCallback callback) = 0;

  using GetParentBookmarkFolderNameForCurrentUrlCallback = base::OnceCallback<void(const ::std::u16string&)>;
  using GetParentBookmarkFolderNameForCurrentUrlMojoCallback = base::OnceCallback<void(const ::std::u16string&)>;

  virtual void GetParentBookmarkFolderNameForCurrentUrl(GetParentBookmarkFolderNameForCurrentUrlCallback callback) = 0;

  virtual void ShowBookmarkEditorForCurrentUrl() = 0;
};

class PageProxy;

template <typename ImplRefTraits>
class PageStub;

class PageRequestValidator;


class Page
    : public PageInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "commerce.price_tracking.mojom.Page";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageInterfaceBase;
  using Proxy_ = PageProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageStub<ImplRefTraits>;

  using RequestValidator_ = PageRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kPriceTrackedForBookmarkMinVersion = 0,
    kPriceUntrackedForBookmarkMinVersion = 0,
    kOperationFailedForBookmarkMinVersion = 0,
    kOnProductBookmarkMovedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct PriceTrackedForBookmark_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PriceUntrackedForBookmark_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OperationFailedForBookmark_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnProductBookmarkMoved_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Page() = default;

  virtual void PriceTrackedForBookmark(::commerce::shared::mojom::BookmarkProductInfoPtr bookmark_product) = 0;

  virtual void PriceUntrackedForBookmark(::commerce::shared::mojom::BookmarkProductInfoPtr bookmark_product) = 0;

  virtual void OperationFailedForBookmark(::commerce::shared::mojom::BookmarkProductInfoPtr bookmark_product, bool attempted_track) = 0;

  virtual void OnProductBookmarkMoved(::commerce::shared::mojom::BookmarkProductInfoPtr bookmark_product) = 0;
};

class PriceTrackingHandlerFactoryProxy;

template <typename ImplRefTraits>
class PriceTrackingHandlerFactoryStub;

class PriceTrackingHandlerFactoryRequestValidator;


class PriceTrackingHandlerFactory
    : public PriceTrackingHandlerFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "commerce.price_tracking.mojom.PriceTrackingHandlerFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PriceTrackingHandlerFactoryInterfaceBase;
  using Proxy_ = PriceTrackingHandlerFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = PriceTrackingHandlerFactoryStub<ImplRefTraits>;

  using RequestValidator_ = PriceTrackingHandlerFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreatePriceTrackingHandlerMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreatePriceTrackingHandler_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PriceTrackingHandlerFactory() = default;

  virtual void CreatePriceTrackingHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PriceTrackingHandler> handler) = 0;
};



class  PriceTrackingHandlerProxy
    : public PriceTrackingHandler {
 public:
  using InterfaceType = PriceTrackingHandler;

  explicit PriceTrackingHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void TrackPriceForBookmark(int64_t bookmark_id) final;
  
  void UntrackPriceForBookmark(int64_t bookmark_id) final;
  
  void SetPriceTrackingStatusForCurrentUrl(bool track) final;
  
  void GetAllShoppingBookmarkProductInfo(GetAllShoppingBookmarkProductInfoCallback callback) final;
  
  void GetAllPriceTrackedBookmarkProductInfo(GetAllPriceTrackedBookmarkProductInfoCallback callback) final;
  
  void GetShoppingCollectionBookmarkFolderId(GetShoppingCollectionBookmarkFolderIdCallback callback) final;
  
  void GetParentBookmarkFolderNameForCurrentUrl(GetParentBookmarkFolderNameForCurrentUrlCallback callback) final;
  
  void ShowBookmarkEditorForCurrentUrl() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PageProxy
    : public Page {
 public:
  using InterfaceType = Page;

  explicit PageProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void PriceTrackedForBookmark(::commerce::shared::mojom::BookmarkProductInfoPtr bookmark_product) final;
  
  void PriceUntrackedForBookmark(::commerce::shared::mojom::BookmarkProductInfoPtr bookmark_product) final;
  
  void OperationFailedForBookmark(::commerce::shared::mojom::BookmarkProductInfoPtr bookmark_product, bool attempted_track) final;
  
  void OnProductBookmarkMoved(::commerce::shared::mojom::BookmarkProductInfoPtr bookmark_product) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PriceTrackingHandlerFactoryProxy
    : public PriceTrackingHandlerFactory {
 public:
  using InterfaceType = PriceTrackingHandlerFactory;

  explicit PriceTrackingHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreatePriceTrackingHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PriceTrackingHandler> handler) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  PriceTrackingHandlerStubDispatch {
 public:
  static bool Accept(PriceTrackingHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PriceTrackingHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PriceTrackingHandler>>
class PriceTrackingHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PriceTrackingHandlerStub() = default;
  ~PriceTrackingHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PriceTrackingHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PriceTrackingHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageStubDispatch {
 public:
  static bool Accept(Page* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Page* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Page>>
class PageStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageStub() = default;
  ~PageStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PriceTrackingHandlerFactoryStubDispatch {
 public:
  static bool Accept(PriceTrackingHandlerFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PriceTrackingHandlerFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PriceTrackingHandlerFactory>>
class PriceTrackingHandlerFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PriceTrackingHandlerFactoryStub() = default;
  ~PriceTrackingHandlerFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PriceTrackingHandlerFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PriceTrackingHandlerFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PriceTrackingHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PriceTrackingHandlerFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PriceTrackingHandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // commerce::price_tracking::mojom

namespace mojo {

}  // namespace mojo

#endif  // COMPONENTS_COMMERCE_CORE_MOJOM_PRICE_TRACKING_MOJOM_H_