// components/browsing_topics/mojom/browsing_topics_internals.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_BROWSING_TOPICS_MOJOM_BROWSING_TOPICS_INTERNALS_MOJOM_DATA_VIEW_H_
#define COMPONENTS_BROWSING_TOPICS_MOJOM_BROWSING_TOPICS_INTERNALS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "components/browsing_topics/mojom/browsing_topics_internals.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"


namespace browsing_topics::mojom {
class WebUIBrowsingTopicsConfigurationDataView;

class WebUITopicDataView;

class WebUIEpochDataView;

class WebUIBrowsingTopicsStateDataView;

class WebUIModelInfoDataView;

class WebUIGetBrowsingTopicsStateResultDataView;
class WebUIGetModelInfoResultDataView;


}  // browsing_topics::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::browsing_topics::mojom::WebUIBrowsingTopicsConfigurationDataView> {
  using Data = ::browsing_topics::mojom::internal::WebUIBrowsingTopicsConfiguration_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::browsing_topics::mojom::WebUITopicDataView> {
  using Data = ::browsing_topics::mojom::internal::WebUITopic_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::browsing_topics::mojom::WebUIEpochDataView> {
  using Data = ::browsing_topics::mojom::internal::WebUIEpoch_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::browsing_topics::mojom::WebUIBrowsingTopicsStateDataView> {
  using Data = ::browsing_topics::mojom::internal::WebUIBrowsingTopicsState_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::browsing_topics::mojom::WebUIModelInfoDataView> {
  using Data = ::browsing_topics::mojom::internal::WebUIModelInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::browsing_topics::mojom::WebUIGetBrowsingTopicsStateResultDataView> {
  using Data = ::browsing_topics::mojom::internal::WebUIGetBrowsingTopicsStateResult_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::browsing_topics::mojom::WebUIGetModelInfoResultDataView> {
  using Data = ::browsing_topics::mojom::internal::WebUIGetModelInfoResult_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace browsing_topics::mojom {
// Interface base classes. They are used for type safety check.
class PageHandlerInterfaceBase {};

using PageHandlerPtrDataView =
    mojo::InterfacePtrDataView<PageHandlerInterfaceBase>;
using PageHandlerRequestDataView =
    mojo::InterfaceRequestDataView<PageHandlerInterfaceBase>;
using PageHandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageHandlerInterfaceBase>;
using PageHandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageHandlerInterfaceBase>;


class WebUIBrowsingTopicsConfigurationDataView {
 public:
  WebUIBrowsingTopicsConfigurationDataView() = default;

  WebUIBrowsingTopicsConfigurationDataView(
      internal::WebUIBrowsingTopicsConfiguration_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool browsing_topics_enabled() const {
    return data_->browsing_topics_enabled;
  }
  bool privacy_sandbox_ads_apis_override_enabled() const {
    return data_->privacy_sandbox_ads_apis_override_enabled;
  }
  bool override_privacy_sandbox_settings_local_testing_enabled() const {
    return data_->override_privacy_sandbox_settings_local_testing_enabled;
  }
  bool browsing_topics_bypass_ip_is_publicly_routable_check_enabled() const {
    return data_->browsing_topics_bypass_ip_is_publicly_routable_check_enabled;
  }
  bool browsing_topics_document_api_enabled() const {
    return data_->browsing_topics_document_api_enabled;
  }
  int32_t config_version() const {
    return data_->config_version;
  }
  bool browsing_topics_parameters_enabled() const {
    return data_->browsing_topics_parameters_enabled;
  }
  int32_t number_of_epochs_to_expose() const {
    return data_->number_of_epochs_to_expose;
  }
  inline void GetTimePeriodPerEpochDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTimePeriodPerEpoch(UserType* output) {
    
    auto* pointer = data_->time_period_per_epoch.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  int32_t number_of_top_topics_per_epoch() const {
    return data_->number_of_top_topics_per_epoch;
  }
  int32_t use_random_topic_probability_percent() const {
    return data_->use_random_topic_probability_percent;
  }
  inline void GetMaxEpochIntroductionDelayDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMaxEpochIntroductionDelay(UserType* output) {
    
    auto* pointer = data_->max_epoch_introduction_delay.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  int32_t number_of_epochs_of_observation_data_to_use_for_filtering() const {
    return data_->number_of_epochs_of_observation_data_to_use_for_filtering;
  }
  int32_t max_number_of_api_usage_context_domains_to_keep_per_topic() const {
    return data_->max_number_of_api_usage_context_domains_to_keep_per_topic;
  }
  int32_t max_number_of_api_usage_context_entries_to_load_per_epoch() const {
    return data_->max_number_of_api_usage_context_entries_to_load_per_epoch;
  }
  int32_t max_number_of_api_usage_context_domains_to_store_per_page_load() const {
    return data_->max_number_of_api_usage_context_domains_to_store_per_page_load;
  }
  int32_t taxonomy_version() const {
    return data_->taxonomy_version;
  }
  inline void GetDisabledTopicsListDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDisabledTopicsList(UserType* output) {
    
    auto* pointer = data_->disabled_topics_list.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::WebUIBrowsingTopicsConfiguration_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebUITopicDataView {
 public:
  WebUITopicDataView() = default;

  WebUITopicDataView(
      internal::WebUITopic_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t topic_id() const {
    return data_->topic_id;
  }
  inline void GetTopicNameDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTopicName(UserType* output) {
    
    auto* pointer = data_->topic_name.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  bool is_real_topic() const {
    return data_->is_real_topic;
  }
  inline void GetObservedByDomainsDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadObservedByDomains(UserType* output) {
    
    auto* pointer = data_->observed_by_domains.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
 private:
  internal::WebUITopic_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebUIEpochDataView {
 public:
  WebUIEpochDataView() = default;

  WebUIEpochDataView(
      internal::WebUIEpoch_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTopicsDataView(
      mojo::ArrayDataView<WebUITopicDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTopics(UserType* output) {
    
    auto* pointer = data_->topics.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::browsing_topics::mojom::WebUITopicDataView>>(
        pointer, output, message_);
  }
  inline void GetCalculationTimeDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCalculationTime(UserType* output) {
    
    auto* pointer = data_->calculation_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  inline void GetModelVersionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadModelVersion(UserType* output) {
    
    auto* pointer = data_->model_version.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetTaxonomyVersionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTaxonomyVersion(UserType* output) {
    
    auto* pointer = data_->taxonomy_version.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::WebUIEpoch_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebUIBrowsingTopicsStateDataView {
 public:
  WebUIBrowsingTopicsStateDataView() = default;

  WebUIBrowsingTopicsStateDataView(
      internal::WebUIBrowsingTopicsState_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetEpochsDataView(
      mojo::ArrayDataView<WebUIEpochDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEpochs(UserType* output) {
    
    auto* pointer = data_->epochs.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::browsing_topics::mojom::WebUIEpochDataView>>(
        pointer, output, message_);
  }
  inline void GetNextScheduledCalculationTimeDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNextScheduledCalculationTime(UserType* output) {
    
    auto* pointer = data_->next_scheduled_calculation_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
 private:
  internal::WebUIBrowsingTopicsState_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebUIModelInfoDataView {
 public:
  WebUIModelInfoDataView() = default;

  WebUIModelInfoDataView(
      internal::WebUIModelInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetModelVersionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadModelVersion(UserType* output) {
    
    auto* pointer = data_->model_version.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetModelFilePathDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadModelFilePath(UserType* output) {
    
    auto* pointer = data_->model_file_path.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::WebUIModelInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebUIGetBrowsingTopicsStateResultDataView {
 public:
  using Tag = internal::WebUIGetBrowsingTopicsStateResult_Data::WebUIGetBrowsingTopicsStateResult_Tag;

  WebUIGetBrowsingTopicsStateResultDataView() = default;

  WebUIGetBrowsingTopicsStateResultDataView(
      internal::WebUIGetBrowsingTopicsStateResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_override_status_message() const { return data_->tag == Tag::kOverrideStatusMessage; }
  inline void GetOverrideStatusMessageDataView(
      mojo::StringDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadOverrideStatusMessage(UserType* output) const {
    
    CHECK(is_override_status_message());
    return mojo::internal::Deserialize<mojo::StringDataView>(
        data_->data.f_override_status_message.Get(), output, message_);
  }
  bool is_browsing_topics_state() const { return data_->tag == Tag::kBrowsingTopicsState; }
  inline void GetBrowsingTopicsStateDataView(
      WebUIBrowsingTopicsStateDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadBrowsingTopicsState(UserType* output) const {
    
    CHECK(is_browsing_topics_state());
    return mojo::internal::Deserialize<::browsing_topics::mojom::WebUIBrowsingTopicsStateDataView>(
        data_->data.f_browsing_topics_state.Get(), output, message_);
  }

 private:
  internal::WebUIGetBrowsingTopicsStateResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class WebUIGetModelInfoResultDataView {
 public:
  using Tag = internal::WebUIGetModelInfoResult_Data::WebUIGetModelInfoResult_Tag;

  WebUIGetModelInfoResultDataView() = default;

  WebUIGetModelInfoResultDataView(
      internal::WebUIGetModelInfoResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_override_status_message() const { return data_->tag == Tag::kOverrideStatusMessage; }
  inline void GetOverrideStatusMessageDataView(
      mojo::StringDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadOverrideStatusMessage(UserType* output) const {
    
    CHECK(is_override_status_message());
    return mojo::internal::Deserialize<mojo::StringDataView>(
        data_->data.f_override_status_message.Get(), output, message_);
  }
  bool is_model_info() const { return data_->tag == Tag::kModelInfo; }
  inline void GetModelInfoDataView(
      WebUIModelInfoDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadModelInfo(UserType* output) const {
    
    CHECK(is_model_info());
    return mojo::internal::Deserialize<::browsing_topics::mojom::WebUIModelInfoDataView>(
        data_->data.f_model_info.Get(), output, message_);
  }

 private:
  internal::WebUIGetModelInfoResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // browsing_topics::mojom

#endif  // COMPONENTS_BROWSING_TOPICS_MOJOM_BROWSING_TOPICS_INTERNALS_MOJOM_DATA_VIEW_H_