// components/browser_apis/tab_strip/tab_strip_experiment_api.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/browser_apis/tab_strip/tab_strip_experiment_api.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/browser_apis/tab_strip/tab_strip_experiment_api.mojom-params-data.h"
#include "components/browser_apis/tab_strip/tab_strip_experiment_api.mojom-shared-message-ids.h"

#include "components/browser_apis/tab_strip/tab_strip_experiment_api.mojom-import-headers.h"
#include "components/browser_apis/tab_strip/tab_strip_experiment_api.mojom-test-utils.h"


namespace tabs_api::mojom {
TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_ResultPtr
TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_Result::NewSuccess(
    const ::std::monostate& value) {
  return TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_ResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
      std::move(value));
}

TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_ResultPtr
TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_Result::NewFailure(
    ::mojo_base::mojom::ErrorPtr value) {
  return TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_ResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kFailure)>,
      std::move(value));
}

TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_Result::TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_Result(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    const ::std::monostate& value)
    : tag_(Tag::kSuccess),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
            std::move(value)) {}

TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_Result::TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_Result(
    std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
    ::mojo_base::mojom::ErrorPtr value)
    : tag_(Tag::kFailure),
      data_(std::in_place_index<static_cast<size_t>(Tag::kFailure)>,
            std::move(value)) {}
TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_Result::~TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_Result() {
  DestroyActive();
}

void TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_Result::set_success(const ::std::monostate& success) {
  if (tag_ == Tag::kSuccess) {
    data_.success = std::move(success);
  } else {
    DestroyActive();
    tag_ = Tag::kSuccess;
    new (&data_.success) ::std::monostate(
        std::move(success));
  }
}

void TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_Result::set_failure(::mojo_base::mojom::ErrorPtr failure) {
  if (tag_ == Tag::kFailure) {
    data_.failure = std::move(failure);
  } else {
    DestroyActive();
    tag_ = Tag::kFailure;
    new (&data_.failure) ::mojo_base::mojom::ErrorPtr(
        std::move(failure));
  }
}


TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_Result::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    const ::std::monostate& value)
    : success(std::move(value)) {}

TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_Result::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
    ::mojo_base::mojom::ErrorPtr value)
    : failure(std::move(value)) {}

void TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_Result::DestroyActive() {
  switch (tag_) {

    case Tag::kSuccess:
      std::destroy_at(&data_.success);
      break;
    case Tag::kFailure:
      std::destroy_at(&data_.failure);
      break;
  }
}

bool TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_Result::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

TabStripExperimentService::IPCStableHashFunction TabStripExperimentService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::TabStripExperimentService>(message.name())) {
    case messages::TabStripExperimentService::kUpdateTabGroupVisual: {
      return &TabStripExperimentService::UpdateTabGroupVisual_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* TabStripExperimentService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::TabStripExperimentService>(message.name())) {
      case messages::TabStripExperimentService::kUpdateTabGroupVisual:
            return "Receive tabs_api::mojom::TabStripExperimentService::UpdateTabGroupVisual";
    }
  } else {
    switch (static_cast<messages::TabStripExperimentService>(message.name())) {
      case messages::TabStripExperimentService::kUpdateTabGroupVisual:
            return "Receive reply tabs_api::mojom::TabStripExperimentService::UpdateTabGroupVisual";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t TabStripExperimentService::UpdateTabGroupVisual_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbe276c38;  // IPCStableHash for tabs_api::mojom::TabStripExperimentService::UpdateTabGroupVisual
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class TabStripExperimentService_UpdateTabGroupVisual_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  TabStripExperimentService_UpdateTabGroupVisual_ForwardToCallback(
      TabStripExperimentService::UpdateTabGroupVisualCallback callback
      ) : callback_(std::move(callback)) {
  }

  TabStripExperimentService_UpdateTabGroupVisual_ForwardToCallback(const TabStripExperimentService_UpdateTabGroupVisual_ForwardToCallback&) = delete;
  TabStripExperimentService_UpdateTabGroupVisual_ForwardToCallback& operator=(const TabStripExperimentService_UpdateTabGroupVisual_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  TabStripExperimentService::UpdateTabGroupVisualCallback callback_;
};

TabStripExperimentServiceProxy::TabStripExperimentServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void TabStripExperimentServiceProxy::UpdateTabGroupVisual(
    const ::tabs_api::NodeId& in_id, const ::tab_groups::TabGroupVisualData& in_visual_data, UpdateTabGroupVisualCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tabs_api::mojom::TabStripExperimentService::UpdateTabGroupVisual", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type const ::tabs_api::NodeId&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("visual_data"), in_visual_data,
                        "<value of type const ::tab_groups::TabGroupVisualData&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TabStripExperimentService::kUpdateTabGroupVisual), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tabs_api::mojom::internal::TabStripExperimentService_UpdateTabGroupVisual_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  
  mojo::internal::Serialize<::tabs_api::mojom::NodeIdDataView>(
    in_id,
    id_fragment);

  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null id in TabStripExperimentService.UpdateTabGroupVisual request");
  mojo::internal::MessageFragment<
      typename decltype(params->visual_data)::BaseType> visual_data_fragment(
          params.message());
  
  mojo::internal::Serialize<::tabs_api::mojom::TabGroupVisualDataDataView>(
    in_visual_data,
    visual_data_fragment);

  params->visual_data.Set(
      visual_data_fragment.is_null() ? nullptr : visual_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->visual_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null visual_data in TabStripExperimentService.UpdateTabGroupVisual request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TabStripExperimentService::Name_);
  message.set_method_name("UpdateTabGroupVisual");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TabStripExperimentService_UpdateTabGroupVisual_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class TabStripExperimentService_UpdateTabGroupVisual_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static TabStripExperimentService::UpdateTabGroupVisualCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<TabStripExperimentService_UpdateTabGroupVisual_ProxyToResponder> proxy(
        new TabStripExperimentService_UpdateTabGroupVisual_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Transform)
      .Then(base::BindOnce(&TabStripExperimentService_UpdateTabGroupVisual_ProxyToResponder::Run,
                          std::move(proxy)));
  }

  static TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_ResultPtr Transform(base::expected<
  ::std::monostate,
  ::mojo_base::mojom::ErrorPtr> in) {
    return in.has_value() ? ::tabs_api::mojom::TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_Result::NewSuccess(std::move(in.value())) :
                            ::tabs_api::mojom::TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_Result::NewFailure(std::move(in.error()));
  }



  ~TabStripExperimentService_UpdateTabGroupVisual_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  TabStripExperimentService_UpdateTabGroupVisual_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "TabStripExperimentService::UpdateTabGroupVisualCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_ResultPtr in_result);
};

bool TabStripExperimentService_UpdateTabGroupVisual_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::TabStripExperimentService_UpdateTabGroupVisual_ResponseParams_Data* params =
      reinterpret_cast<
          internal::TabStripExperimentService_UpdateTabGroupVisual_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for TabStripExperimentService.0
  bool success = true;
  TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_ResultPtr p_result{};
  TabStripExperimentService_UpdateTabGroupVisual_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TabStripExperimentService::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    if (p_result->is_success()) {
      std::move(callback_).Run(base::ok(std::move(p_result->get_success())));
    } else {
      std::move(callback_).Run(base::unexpected(std::move(p_result->get_failure())));
    }
  }
  return true;
}

void TabStripExperimentService_UpdateTabGroupVisual_ProxyToResponder::Run(
    TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_ResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply tabs_api::mojom::TabStripExperimentService::UpdateTabGroupVisual", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_ResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TabStripExperimentService::kUpdateTabGroupVisual), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tabs_api::mojom::internal::TabStripExperimentService_UpdateTabGroupVisual_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::tabs_api::mojom::TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_ResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TabStripExperimentService::Name_);
  message.set_method_name("UpdateTabGroupVisual");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool TabStripExperimentServiceStubDispatch::Accept(
    TabStripExperimentService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::TabStripExperimentService>(message->header()->name)) {
    case messages::TabStripExperimentService::kUpdateTabGroupVisual: {
      break;
    }
  }
  return false;
}

// static
bool TabStripExperimentServiceStubDispatch::AcceptWithResponder(
    TabStripExperimentService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::TabStripExperimentService>(message->header()->name)) {
    case messages::TabStripExperimentService::kUpdateTabGroupVisual: {
      internal::TabStripExperimentService_UpdateTabGroupVisual_Params_Data* params =
          reinterpret_cast<
              internal::TabStripExperimentService_UpdateTabGroupVisual_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for TabStripExperimentService.0
      bool success = true;
      ::tabs_api::NodeId p_id{};
      ::tab_groups::TabGroupVisualData p_visual_data{};
      TabStripExperimentService_UpdateTabGroupVisual_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (success && !input_data_view.ReadVisualData(&p_visual_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TabStripExperimentService::Name_, 0, false);
        return false;
      }
      auto callback =
          TabStripExperimentService_UpdateTabGroupVisual_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateTabGroupVisual(        
        std::move(p_id), 
        std::move(p_visual_data), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kTabStripExperimentServiceValidationInfo[] = {
    { &internal::TabStripExperimentService_UpdateTabGroupVisual_Params_Data::Validate,
     &internal::TabStripExperimentService_UpdateTabGroupVisual_ResponseParams_Data::Validate},
};

bool TabStripExperimentServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::tabs_api::mojom::TabStripExperimentService::Name_,
    kTabStripExperimentServiceValidationInfo);
}

bool TabStripExperimentServiceResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::tabs_api::mojom::TabStripExperimentService::Name_,
    kTabStripExperimentServiceValidationInfo);
}


}  // tabs_api::mojom


namespace mojo {

// static
bool UnionTraits<::tabs_api::mojom::TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_Result::DataView, ::tabs_api::mojom::TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_ResultPtr>::Read(
    ::tabs_api::mojom::TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_Result::DataView input,
    ::tabs_api::mojom::TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_ResultPtr* output) {
  using UnionType = ::tabs_api::mojom::TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_Result;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kSuccess: {
      ::std::monostate result_success{};
      if (!input.ReadSuccess(&result_success))
        return false;

      *output = UnionType::NewSuccess(
          std::move(result_success));
      break;
    }
    case Tag::kFailure: {
      ::mojo_base::mojom::ErrorPtr result_failure{};
      if (!input.ReadFailure(&result_failure))
        return false;

      *output = UnionType::NewFailure(
          std::move(result_failure));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace tabs_api::mojom {


void TabStripExperimentServiceInterceptorForTesting::UpdateTabGroupVisual(const ::tabs_api::NodeId& id, const ::tab_groups::TabGroupVisualData& visual_data, UpdateTabGroupVisualCallback callback) {
  GetForwardingInterface()->UpdateTabGroupVisual(
    std::move(id)
    , 
    std::move(visual_data)
    , std::move(callback));
}
TabStripExperimentServiceAsyncWaiter::TabStripExperimentServiceAsyncWaiter(
    TabStripExperimentService* proxy) : proxy_(proxy) {}

TabStripExperimentServiceAsyncWaiter::~TabStripExperimentServiceAsyncWaiter() = default;







}  // tabs_api::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif