// components/browser_apis/tab_strip/tab_strip_api_data_model.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_BROWSER_APIS_TAB_STRIP_TAB_STRIP_API_DATA_MODEL_MOJOM_SEND_VALIDATION_H_
#define COMPONENTS_BROWSER_APIS_TAB_STRIP_TAB_STRIP_API_DATA_MODEL_MOJOM_SEND_VALIDATION_H_

#include "components/browser_apis/tab_strip/tab_strip_api_data_model.mojom-shared-internal.h"
#include "components/browser_apis/tab_strip/tab_strip_api_types.mojom-shared.h"
#include "components/tab_groups/public/mojom/tab_group_types.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"

#include "components/browser_apis/tab_strip/tab_strip_api_data_model.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::tabs_api::mojom::AlertState, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::tabs_api::mojom::NetworkState, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::tabs_api::mojom::ImageDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tabs_api::mojom::ImageDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tabs_api::mojom::internal::Image_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::data_url(input)) in_data_url = Traits::data_url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->data_url)::BaseType> data_url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_data_url,
        data_url_fragment);

      fragment->data_url.Set(
          data_url_fragment.is_null() ? nullptr : data_url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->data_url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null data_url in Image struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::tabs_api::mojom::TabDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tabs_api::mojom::TabDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tabs_api::mojom::internal::Tab_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::id(input)) in_id = Traits::id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->id)::BaseType> id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::tabs_api::mojom::NodeIdDataView, send_validation>(
        in_id,
        id_fragment);

      fragment->id.Set(
          id_fragment.is_null() ? nullptr : id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null id in Tab struct");

      decltype(Traits::title(input)) in_title = Traits::title(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->title)::BaseType> title_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_title,
        title_fragment);

      fragment->title.Set(
          title_fragment.is_null() ? nullptr : title_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->title.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null title in Tab struct");

      decltype(Traits::url(input)) in_url = Traits::url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->url)::BaseType> url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_url,
        url_fragment);

      fragment->url.Set(
          url_fragment.is_null() ? nullptr : url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in Tab struct");

      decltype(Traits::favicon(input)) in_favicon = Traits::favicon(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->favicon)::BaseType> favicon_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::tabs_api::mojom::ImageDataView, send_validation>(
        in_favicon,
        favicon_fragment);

      fragment->favicon.Set(
          favicon_fragment.is_null() ? nullptr : favicon_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->favicon.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null favicon in Tab struct");

      decltype(Traits::alert_states(input)) in_alert_states = Traits::alert_states(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->alert_states)::BaseType>
          alert_states_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& alert_states_validate_params =
          mojo::internal::GetArrayOfEnumsValidator<0, false, ::tabs_api::mojom::internal::AlertState_Data::Validate>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::tabs_api::mojom::AlertState>, send_validation>(
        in_alert_states,
        alert_states_fragment,
        &alert_states_validate_params);

      fragment->alert_states.Set(
          alert_states_fragment.is_null() ? nullptr : alert_states_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->alert_states.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null alert_states in Tab struct");

      
      mojo::internal::Serialize<::tabs_api::mojom::NetworkState>(
        Traits::network_state(input),
        &fragment->network_state);

      fragment->is_active = Traits::is_active(input);

      fragment->is_selected = Traits::is_selected(input);

      fragment->is_blocked = Traits::is_blocked(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::tabs_api::mojom::TabStripDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tabs_api::mojom::TabStripDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tabs_api::mojom::internal::TabStrip_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::id(input)) in_id = Traits::id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->id)::BaseType> id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::tabs_api::mojom::NodeIdDataView, send_validation>(
        in_id,
        id_fragment);

      fragment->id.Set(
          id_fragment.is_null() ? nullptr : id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null id in TabStrip struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::tabs_api::mojom::PinnedTabsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tabs_api::mojom::PinnedTabsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tabs_api::mojom::internal::PinnedTabs_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::id(input)) in_id = Traits::id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->id)::BaseType> id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::tabs_api::mojom::NodeIdDataView, send_validation>(
        in_id,
        id_fragment);

      fragment->id.Set(
          id_fragment.is_null() ? nullptr : id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null id in PinnedTabs struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::tabs_api::mojom::UnpinnedTabsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tabs_api::mojom::UnpinnedTabsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tabs_api::mojom::internal::UnpinnedTabs_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::id(input)) in_id = Traits::id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->id)::BaseType> id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::tabs_api::mojom::NodeIdDataView, send_validation>(
        in_id,
        id_fragment);

      fragment->id.Set(
          id_fragment.is_null() ? nullptr : id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null id in UnpinnedTabs struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::tabs_api::mojom::TabGroupDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tabs_api::mojom::TabGroupDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tabs_api::mojom::internal::TabGroup_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::id(input)) in_id = Traits::id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->id)::BaseType> id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::tabs_api::mojom::NodeIdDataView, send_validation>(
        in_id,
        id_fragment);

      fragment->id.Set(
          id_fragment.is_null() ? nullptr : id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null id in TabGroup struct");

      decltype(Traits::data(input)) in_data = Traits::data(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->data)::BaseType> data_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::tabs_api::mojom::TabGroupVisualDataDataView, send_validation>(
        in_data,
        data_fragment);

      fragment->data.Set(
          data_fragment.is_null() ? nullptr : data_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->data.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null data in TabGroup struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::tabs_api::mojom::TabGroupVisualDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tabs_api::mojom::TabGroupVisualDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tabs_api::mojom::internal::TabGroupVisualData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::title(input)) in_title = Traits::title(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->title)::BaseType> title_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_title,
        title_fragment);

      fragment->title.Set(
          title_fragment.is_null() ? nullptr : title_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->title.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null title in TabGroupVisualData struct");

      
      mojo::internal::Serialize<::tab_groups::mojom::Color>(
        Traits::color(input),
        &fragment->color);

      fragment->is_collapsed = Traits::is_collapsed(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::tabs_api::mojom::SplitTabDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tabs_api::mojom::SplitTabDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tabs_api::mojom::internal::SplitTab_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::id(input)) in_id = Traits::id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->id)::BaseType> id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::tabs_api::mojom::NodeIdDataView, send_validation>(
        in_id,
        id_fragment);

      fragment->id.Set(
          id_fragment.is_null() ? nullptr : id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null id in SplitTab struct");

      decltype(Traits::data(input)) in_data = Traits::data(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->data)::BaseType> data_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::tabs_api::mojom::SplitTabVisualDataDataView, send_validation>(
        in_data,
        data_fragment);

      fragment->data.Set(
          data_fragment.is_null() ? nullptr : data_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->data.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null data in SplitTab struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::tabs_api::mojom::SplitTabVisualDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tabs_api::mojom::SplitTabVisualDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tabs_api::mojom::internal::SplitTabVisualData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::tabs_api::mojom::SplitTabVisualData_Layout>(
        Traits::layout(input),
        &fragment->layout);

      fragment->split_ratio = Traits::split_ratio(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::tabs_api::mojom::ContainerDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tabs_api::mojom::ContainerDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tabs_api::mojom::internal::Container_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::data(input)) in_data = Traits::data(input);
      mojo::internal::MessageFragment<decltype(fragment->data)>
          data_fragment(fragment.message());
      data_fragment.Claim(&fragment->data);
      
      mojo::internal::Serialize<::tabs_api::mojom::DataDataView, send_validation>(
        in_data,
        data_fragment,
        true);

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->data.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null data in Container struct");

      decltype(Traits::children(input)) in_children = Traits::children(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->children)::BaseType>
          children_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& children_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::tabs_api::mojom::ContainerDataView>, send_validation>(
        in_children,
        children_fragment,
        &children_validate_params);

      fragment->children.Set(
          children_fragment.is_null() ? nullptr : children_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->children.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null children in Container struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::tabs_api::mojom::TabCreatedContainerDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tabs_api::mojom::TabCreatedContainerDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tabs_api::mojom::internal::TabCreatedContainer_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::tab(input)) in_tab = Traits::tab(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->tab)::BaseType> tab_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::tabs_api::mojom::TabDataView, send_validation>(
        in_tab,
        tab_fragment);

      fragment->tab.Set(
          tab_fragment.is_null() ? nullptr : tab_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->tab.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null tab in TabCreatedContainer struct");

      decltype(Traits::position(input)) in_position = Traits::position(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->position)::BaseType> position_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::tabs_api::mojom::PositionDataView, send_validation>(
        in_position,
        position_fragment);

      fragment->position.Set(
          position_fragment.is_null() ? nullptr : position_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->position.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null position in TabCreatedContainer struct");
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::tabs_api::mojom::DataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::tabs_api::mojom::DataDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::tabs_api::mojom::internal::Data_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::tabs_api::mojom::DataDataView::Tag::kTab: {
    decltype(Traits::tab(input))
    in_tab = Traits::tab(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_tab)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::tabs_api::mojom::TabDataView, send_validation>(
  in_tab,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null tab in Data union");
    fragment->data.f_tab.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::tabs_api::mojom::DataDataView::Tag::kTabStrip: {
    decltype(Traits::tab_strip(input))
    in_tab_strip = Traits::tab_strip(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_tab_strip)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::tabs_api::mojom::TabStripDataView, send_validation>(
  in_tab_strip,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null tab_strip in Data union");
    fragment->data.f_tab_strip.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::tabs_api::mojom::DataDataView::Tag::kPinnedTabs: {
    decltype(Traits::pinned_tabs(input))
    in_pinned_tabs = Traits::pinned_tabs(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_pinned_tabs)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::tabs_api::mojom::PinnedTabsDataView, send_validation>(
  in_pinned_tabs,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null pinned_tabs in Data union");
    fragment->data.f_pinned_tabs.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::tabs_api::mojom::DataDataView::Tag::kUnpinnedTabs: {
    decltype(Traits::unpinned_tabs(input))
    in_unpinned_tabs = Traits::unpinned_tabs(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_unpinned_tabs)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::tabs_api::mojom::UnpinnedTabsDataView, send_validation>(
  in_unpinned_tabs,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null unpinned_tabs in Data union");
    fragment->data.f_unpinned_tabs.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::tabs_api::mojom::DataDataView::Tag::kTabGroup: {
    decltype(Traits::tab_group(input))
    in_tab_group = Traits::tab_group(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_tab_group)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::tabs_api::mojom::TabGroupDataView, send_validation>(
  in_tab_group,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null tab_group in Data union");
    fragment->data.f_tab_group.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::tabs_api::mojom::DataDataView::Tag::kSplitTab: {
    decltype(Traits::split_tab(input))
    in_split_tab = Traits::split_tab(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_split_tab)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::tabs_api::mojom::SplitTabDataView, send_validation>(
  in_split_tab,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null split_tab in Data union");
    fragment->data.f_split_tab.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // COMPONENTS_BROWSER_APIS_TAB_STRIP_TAB_STRIP_API_DATA_MODEL_MOJOM_SEND_VALIDATION_H_