// components/autofill/core/browser/ml_model/logging/autofill_ml_internals.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_AUTOFILL_CORE_BROWSER_ML_MODEL_LOGGING_AUTOFILL_ML_INTERNALS_MOJOM_SHARED_H_
#define COMPONENTS_AUTOFILL_CORE_BROWSER_ML_MODEL_LOGGING_AUTOFILL_ML_INTERNALS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/autofill/core/browser/ml_model/logging/autofill_ml_internals.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "components/autofill/core/browser/ml_model/logging/autofill_ml_internals.mojom-data-view.h"




namespace std {

template <>
struct hash<::autofill_ml_internals::mojom::OptimizationTarget>
    : public mojo::internal::EnumHashImpl<::autofill_ml_internals::mojom::OptimizationTarget> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::autofill_ml_internals::mojom::OptimizationTarget, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::autofill_ml_internals::mojom::OptimizationTarget, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::autofill_ml_internals::mojom::OptimizationTarget>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::autofill_ml_internals::mojom::SelectOptionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::autofill_ml_internals::mojom::SelectOptionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::autofill_ml_internals::mojom::internal::SelectOption_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::value(input)) in_value = Traits::value(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->value)::BaseType> value_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_value,
      value_fragment);

    fragment->value.Set(
        value_fragment.is_null() ? nullptr : value_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->value.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null value in SelectOption struct");

    decltype(Traits::text(input)) in_text = Traits::text(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->text)::BaseType> text_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_text,
      text_fragment);

    fragment->text.Set(
        text_fragment.is_null() ? nullptr : text_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->text.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null text in SelectOption struct");
  }

  static bool Deserialize(::autofill_ml_internals::mojom::internal::SelectOption_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::autofill_ml_internals::mojom::SelectOptionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::autofill_ml_internals::mojom::MlFieldPredictionLogDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::autofill_ml_internals::mojom::MlFieldPredictionLogDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::autofill_ml_internals::mojom::internal::MlFieldPredictionLog_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_label,
      label_fragment);

    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->label.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in MlFieldPredictionLog struct");

    decltype(Traits::placeholder(input)) in_placeholder = Traits::placeholder(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->placeholder)::BaseType> placeholder_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_placeholder,
      placeholder_fragment);

    fragment->placeholder.Set(
        placeholder_fragment.is_null() ? nullptr : placeholder_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->placeholder.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null placeholder in MlFieldPredictionLog struct");

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in MlFieldPredictionLog struct");

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_id,
      id_fragment);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in MlFieldPredictionLog struct");

    decltype(Traits::autocomplete(input)) in_autocomplete = Traits::autocomplete(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->autocomplete)::BaseType> autocomplete_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_autocomplete,
      autocomplete_fragment);

    fragment->autocomplete.Set(
        autocomplete_fragment.is_null() ? nullptr : autocomplete_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->autocomplete.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null autocomplete in MlFieldPredictionLog struct");

    decltype(Traits::form_control_type(input)) in_form_control_type = Traits::form_control_type(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->form_control_type)::BaseType> form_control_type_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_form_control_type,
      form_control_type_fragment);

    fragment->form_control_type.Set(
        form_control_type_fragment.is_null() ? nullptr : form_control_type_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->form_control_type.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null form_control_type in MlFieldPredictionLog struct");

    decltype(Traits::select_options(input)) in_select_options = Traits::select_options(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->select_options)::BaseType>
        select_options_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& select_options_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::autofill_ml_internals::mojom::SelectOptionDataView>>(
      in_select_options,
      select_options_fragment,
      &select_options_validate_params);

    fragment->select_options.Set(
        select_options_fragment.is_null() ? nullptr : select_options_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->select_options.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null select_options in MlFieldPredictionLog struct");

    decltype(Traits::probabilities(input)) in_probabilities = Traits::probabilities(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->probabilities)::BaseType>
        probabilities_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& probabilities_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<float>>(
      in_probabilities,
      probabilities_fragment,
      &probabilities_validate_params);

    fragment->probabilities.Set(
        probabilities_fragment.is_null() ? nullptr : probabilities_fragment.data());

    decltype(Traits::tokenized_field_representation(input)) in_tokenized_field_representation = Traits::tokenized_field_representation(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->tokenized_field_representation)::BaseType>
        tokenized_field_representation_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& tokenized_field_representation_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_tokenized_field_representation,
      tokenized_field_representation_fragment,
      &tokenized_field_representation_validate_params);

    fragment->tokenized_field_representation.Set(
        tokenized_field_representation_fragment.is_null() ? nullptr : tokenized_field_representation_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->tokenized_field_representation.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null tokenized_field_representation in MlFieldPredictionLog struct");
  }

  static bool Deserialize(::autofill_ml_internals::mojom::internal::MlFieldPredictionLog_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::autofill_ml_internals::mojom::MlFieldPredictionLogDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::autofill_ml_internals::mojom::MlPredictionLogDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::autofill_ml_internals::mojom::MlPredictionLogDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::autofill_ml_internals::mojom::internal::MlPredictionLog_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::form_signature(input)) in_form_signature = Traits::form_signature(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->form_signature)::BaseType> form_signature_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_form_signature,
      form_signature_fragment);

    fragment->form_signature.Set(
        form_signature_fragment.is_null() ? nullptr : form_signature_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->form_signature.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null form_signature in MlPredictionLog struct");

    decltype(Traits::form_url(input)) in_form_url = Traits::form_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->form_url)::BaseType> form_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_form_url,
      form_url_fragment);

    fragment->form_url.Set(
        form_url_fragment.is_null() ? nullptr : form_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->form_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null form_url in MlPredictionLog struct");

    decltype(Traits::model_output_types(input)) in_model_output_types = Traits::model_output_types(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->model_output_types)::BaseType>
        model_output_types_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& model_output_types_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_model_output_types,
      model_output_types_fragment,
      &model_output_types_validate_params);

    fragment->model_output_types.Set(
        model_output_types_fragment.is_null() ? nullptr : model_output_types_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->model_output_types.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null model_output_types in MlPredictionLog struct");

    decltype(Traits::field_predictions(input)) in_field_predictions = Traits::field_predictions(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->field_predictions)::BaseType>
        field_predictions_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& field_predictions_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::autofill_ml_internals::mojom::MlFieldPredictionLogDataView>>(
      in_field_predictions,
      field_predictions_fragment,
      &field_predictions_validate_params);

    fragment->field_predictions.Set(
        field_predictions_fragment.is_null() ? nullptr : field_predictions_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->field_predictions.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null field_predictions in MlPredictionLog struct");

    decltype(Traits::start_time(input)) in_start_time = Traits::start_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->start_time)::BaseType> start_time_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_start_time,
      start_time_fragment);

    fragment->start_time.Set(
        start_time_fragment.is_null() ? nullptr : start_time_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->start_time.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null start_time in MlPredictionLog struct");

    decltype(Traits::end_time(input)) in_end_time = Traits::end_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->end_time)::BaseType> end_time_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_end_time,
      end_time_fragment);

    fragment->end_time.Set(
        end_time_fragment.is_null() ? nullptr : end_time_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->end_time.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null end_time in MlPredictionLog struct");

    decltype(Traits::duration(input)) in_duration = Traits::duration(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->duration)::BaseType> duration_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_duration,
      duration_fragment);

    fragment->duration.Set(
        duration_fragment.is_null() ? nullptr : duration_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->duration.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null duration in MlPredictionLog struct");

    
    mojo::internal::Serialize<::autofill_ml_internals::mojom::OptimizationTarget>(
      Traits::optimization_target(input),
      &fragment->optimization_target);
  }

  static bool Deserialize(::autofill_ml_internals::mojom::internal::MlPredictionLog_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::autofill_ml_internals::mojom::MlPredictionLogDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace autofill_ml_internals::mojom {

inline void SelectOptionDataView::GetValueDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->value.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SelectOptionDataView::GetTextDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->text.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void MlFieldPredictionLogDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void MlFieldPredictionLogDataView::GetPlaceholderDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->placeholder.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void MlFieldPredictionLogDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void MlFieldPredictionLogDataView::GetIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void MlFieldPredictionLogDataView::GetAutocompleteDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->autocomplete.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void MlFieldPredictionLogDataView::GetFormControlTypeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->form_control_type.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void MlFieldPredictionLogDataView::GetSelectOptionsDataView(
    mojo::ArrayDataView<SelectOptionDataView>* output) {
  auto pointer = data_->select_options.Get();
  *output = mojo::ArrayDataView<SelectOptionDataView>(pointer, message_);
}
inline void MlFieldPredictionLogDataView::GetProbabilitiesDataView(
    mojo::ArrayDataView<float>* output) {
  auto pointer = data_->probabilities.Get();
  *output = mojo::ArrayDataView<float>(pointer, message_);
}
inline void MlFieldPredictionLogDataView::GetTokenizedFieldRepresentationDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->tokenized_field_representation.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}


inline void MlPredictionLogDataView::GetFormSignatureDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->form_signature.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void MlPredictionLogDataView::GetFormUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->form_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void MlPredictionLogDataView::GetModelOutputTypesDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->model_output_types.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}
inline void MlPredictionLogDataView::GetFieldPredictionsDataView(
    mojo::ArrayDataView<MlFieldPredictionLogDataView>* output) {
  auto pointer = data_->field_predictions.Get();
  *output = mojo::ArrayDataView<MlFieldPredictionLogDataView>(pointer, message_);
}
inline void MlPredictionLogDataView::GetStartTimeDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->start_time.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}
inline void MlPredictionLogDataView::GetEndTimeDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->end_time.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}
inline void MlPredictionLogDataView::GetDurationDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->duration.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}



}  // autofill_ml_internals::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::autofill_ml_internals::mojom::OptimizationTarget> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::autofill_ml_internals::mojom::OptimizationTarget value);
};

} // namespace perfetto

#endif  // COMPONENTS_AUTOFILL_CORE_BROWSER_ML_MODEL_LOGGING_AUTOFILL_ML_INTERNALS_MOJOM_SHARED_H_