// components/autofill/core/browser/ml_model/logging/autofill_ml_internals.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/autofill/core/browser/ml_model/logging/autofill_ml_internals.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/autofill/core/browser/ml_model/logging/autofill_ml_internals.mojom-params-data.h"
namespace autofill_ml_internals {
namespace mojom {

NOINLINE static const char* OptimizationTargetToStringHelper(OptimizationTarget value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case OptimizationTarget::kUnknown:
      return "kUnknown";
    case OptimizationTarget::kAutofill:
      return "kAutofill";
    case OptimizationTarget::kPassword:
      return "kPassword";
    default:
      return nullptr;
  }
}

std::string OptimizationTargetToString(OptimizationTarget value) {
  const char *str = OptimizationTargetToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown OptimizationTarget value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, OptimizationTarget value) {
  return os << OptimizationTargetToString(value);
}

namespace internal {


// static
bool SelectOption_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SelectOption_Data* object =
      static_cast<const SelectOption_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& value_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->value, validation_context,
                                         &value_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& text_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->text, validation_context,
                                         &text_validate_params)) {
    return false;
  }

  return true;
}

SelectOption_Data::SelectOption_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MlFieldPredictionLog_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 80, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MlFieldPredictionLog_Data* object =
      static_cast<const MlFieldPredictionLog_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->placeholder, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& placeholder_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->placeholder, validation_context,
                                         &placeholder_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->autocomplete, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& autocomplete_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->autocomplete, validation_context,
                                         &autocomplete_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->form_control_type, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& form_control_type_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->form_control_type, validation_context,
                                         &form_control_type_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->select_options, 7, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& select_options_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->select_options, validation_context,
                                         &select_options_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& probabilities_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->probabilities, validation_context,
                                         &probabilities_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tokenized_field_representation, 9, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& tokenized_field_representation_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->tokenized_field_representation, validation_context,
                                         &tokenized_field_representation_validate_params)) {
    return false;
  }

  return true;
}

MlFieldPredictionLog_Data::MlFieldPredictionLog_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MlPredictionLog_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 72, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MlPredictionLog_Data* object =
      static_cast<const MlPredictionLog_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->form_signature, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& form_signature_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->form_signature, validation_context,
                                         &form_signature_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->form_url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->form_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->model_output_types, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& model_output_types_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->model_output_types, validation_context,
                                         &model_output_types_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->field_predictions, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& field_predictions_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->field_predictions, validation_context,
                                         &field_predictions_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->start_time, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->start_time, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->end_time, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->end_time, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->duration, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->duration, validation_context))
    return false;


  if (!::autofill_ml_internals::mojom::internal::OptimizationTarget_Data
        ::Validate(object->optimization_target, validation_context))
    return false;

  return true;
}

MlPredictionLog_Data::MlPredictionLog_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_OnLogAdded_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_OnLogAdded_Params_Data* object =
      static_cast<const Page_OnLogAdded_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->log, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->log, validation_context))
    return false;

  return true;
}

Page_OnLogAdded_Params_Data::Page_OnLogAdded_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_SetPage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_SetPage_Params_Data* object =
      static_cast<const PageHandler_SetPage_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->page, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->page,
                                                 validation_context)) {
    return false;
  }

  return true;
}

PageHandler_SetPage_Params_Data::PageHandler_SetPage_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace autofill_ml_internals

namespace perfetto {

// static
void TraceFormatTraits<::autofill_ml_internals::mojom::OptimizationTarget>::WriteIntoTrace(
   perfetto::TracedValue context, ::autofill_ml_internals::mojom::OptimizationTarget value) {
  return std::move(context).WriteString(::autofill_ml_internals::mojom::OptimizationTargetToString(value));
}

} // namespace perfetto