// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_AUTOFILL_CORE_BROWSER_GEO_COUNTRY_NATIVE_NAMES_INL_H_
#define COMPONENTS_AUTOFILL_CORE_BROWSER_GEO_COUNTRY_NATIVE_NAMES_INL_H_

#include <string_view>
#include "base/containers/fixed_flat_map.h"

namespace autofill {

// A map from the country name in their native language to the country code.
// This is generated by // components/autofill/core/browser/geo/tools/generate_country_native_names.cc.
// Do not edit manually.
namespace {

constexpr auto kCountryNativeNames = base::MakeFixedFlatMap<std::u16string_view, std::string>({
    {u"AF", "AF"},
    {u"AFGHANISTAN", "AF"},
    {u"ALBANIA", "AL"},
    {u"ALGÉRIE", "DZ"},
    {u"AMERICAN SAMOA", "AS"},
    {u"ANDORRA", "AD"},
    {u"ANGOLA", "AO"},
    {u"ANGUILLA", "AI"},
    {u"ANTIGUA & BARBUDA", "AG"},
    {u"ARGENTINA", "AR"},
    {u"ARMENIA", "AM"},
    {u"ARUBA", "AW"},
    {u"AUSTRALIA", "AU"},
    {u"AUSTRIA", "AT"},
    {u"AZ", "AZ"},
    {u"AZERBAIJAN", "AZ"},
    {u"BA", "BA"},
    {u"BAHAMAS", "BS"},
    {u"BARBADOS", "BB"},
    {u"BELARUS", "BY"},
    {u"BELGIEN", "BE"},
    {u"BELGIQUE", "BE"},
    {u"BELGIUM", "BE"},
    {u"BELGIË", "BE"},
    {u"BELICE", "BZ"},
    {u"BELIZE", "BZ"},
    {u"BENIN", "BJ"},
    {u"BERMUDA", "BM"},
    {u"BHARAT", "IN"},
    {u"BOLIVIA", "BO"},
    {u"BOSNA I HERCEGOVINA", "BA"},
    {u"BOSNIA & HERZEGOVINA", "BA"},
    {u"BOTSWANA", "BW"},
    {u"BRASIL", "BR"},
    {u"BRITISH INDIAN OCEAN TERRITORY", "IO"},
    {u"BRITISH VIRGIN ISLANDS", "VG"},
    {u"BRUNEI", "BN"},
    {u"BURKINA FASO", "BF"},
    {u"BURUNDI", "BI"},
    {u"BÉNIN", "BJ"},
    {u"CABO VERDE", "CV"},
    {u"CAMBODIA", "KH"},
    {u"CAMEROON", "CM"},
    {u"CAMEROUN", "CM"},
    {u"CANADA", "CA"},
    {u"CARIBISCH NEDERLAND", "BQ"},
    {u"CAYMAN ISLANDS", "KY"},
    {u"CENTRAL AFRICAN REPUBLIC", "CF"},
    {u"CHILE", "CL"},
    {u"CHINA", "CN"},
    {u"CHRISTMAS ISLAND", "CX"},
    {u"CITTÀ DEL VATICANO", "VA"},
    {u"COCOS (KEELING) ISLANDS", "CC"},
    {u"COLOMBIA", "CO"},
    {u"COMORES", "KM"},
    {u"CONGO - BRAZZAVILLE", "CG"},
    {u"CONGO - KINSHASA", "CD"},
    {u"CONGO-BRAZZAVILLE", "CG"},
    {u"CONGO-KINSHASA", "CD"},
    {u"COOK ISLANDS", "CK"},
    {u"COSTA RICA", "CR"},
    {u"CRNA GORA", "ME"},
    {u"CUBA", "CU"},
    {u"CURAÇAO", "CW"},
    {u"CYPRUS", "CY"},
    {u"CZECHIA", "CZ"},
    {u"CÔTE D’IVOIRE", "CI"},
    {u"DANMARK", "DK"},
    {u"DENMARK", "DK"},
    {u"DEUTSCHLAND", "DE"},
    {u"DJIBOUTI", "DJ"},
    {u"DOMINICA", "DM"},
    {u"ECUADOR", "EC"},
    {u"EESTI", "EE"},
    {u"EL SALVADOR", "SV"},
    {u"ERITREA", "ER"},
    {u"ESPANYA", "ES"},
    {u"ESPAÑA", "ES"},
    {u"ESTADOS UNIDOS", "US"},
    {u"ESWATINI", "SZ"},
    {u"ETHIOPIA", "ET"},
    {u"FALKLAND ISLANDS (ISLAS MALVINAS)", "FK"},
    {u"FAROE ISLANDS", "FO"},
    {u"FIJI", "FJ"},
    {u"FILIPINAS", "PH"},
    {u"FINLAND", "FI"},
    {u"FRANCE", "FR"},
    {u"FRANÇA", "FR"},
    {u"GABON", "GA"},
    {u"GAMBIA", "GM"},
    {u"GEORGIA", "GE"},
    {u"GERMANY", "DE"},
    {u"GHANA", "GH"},
    {u"GIBRALTAR", "GI"},
    {u"GRENADA", "GD"},
    {u"GRØNLAND", "GL"},
    {u"GUADELOUPE", "GP"},
    {u"GUAM", "GU"},
    {u"GUATEMALA", "GT"},
    {u"GUERNSEY", "GG"},
    {u"GUINEA ECUATORIAL", "GQ"},
    {u"GUINÉ EQUATORIAL", "GQ"},
    {u"GUINÉ-BISSAU", "GW"},
    {u"GUINÉE", "GN"},
    {u"GUINÉE ÉQUATORIALE", "GQ"},
    {u"GUYANA", "GY"},
    {u"GUYANE FRANÇAISE", "GF"},
    {u"HAÏTI", "HT"},
    {u"HONDURAS", "HN"},
    {u"HONG KONG", "HK"},
    {u"HRVATSKA", "HR"},
    {u"HUNGARY", "HU"},
    {u"ICELAND", "IS"},
    {u"IN", "IN"},
    {u"INDIA", "IN"},
    {u"INDONESIA", "ID"},
    {u"IRAN", "IR"},
    {u"IRAQ", "IQ"},
    {u"IRELAND", "IE"},
    {u"ISLE OF MAN", "IM"},
    {u"ISRAEL", "IL"},
    {u"ITALIA", "IT"},
    {u"ITALIEN", "IT"},
    {u"ITALY", "IT"},
    {u"ITÀLIA", "IT"},
    {u"JAMAICA", "JM"},
    {u"JAMHURI YA KIDEMOKRASIA YA KONGO", "CD"},
    {u"JERSEY", "JE"},
    {u"KAZAKHSTAN", "KZ"},
    {u"KENYA", "KE"},
    {u"KIBRIS", "CY"},
    {u"KIRIBATI", "KI"},
    {u"KOSOVO", "XK"},
    {u"KYRGYZSTAN", "KG"},
    {u"LA RÉUNION", "RE"},
    {u"LAOS", "LA"},
    {u"LATVIJA", "LV"},
    {u"LESOTHO", "LS"},
    {u"LIBERIA", "LR"},
    {u"LIECHTENSTEIN", "LI"},
    {u"LIETUVA", "LT"},
    {u"LUXEMBOURG", "LU"},
    {u"LUXEMBURG", "LU"},
    {u"LUXEMBURGO", "LU"},
    {u"MACAO", "MO"},
    {u"MACAU", "MO"},
    {u"MADAGASCAR", "MG"},
    {u"MAGYARORSZÁG", "HU"},
    {u"MALAWI", "MW"},
    {u"MALAYSIA", "MY"},
    {u"MALDIVES", "MV"},
    {u"MALI", "ML"},
    {u"MALTA", "MT"},
    {u"MAROC", "MA"},
    {u"MARSHALL ISLANDS", "MH"},
    {u"MARTINIQUE", "MQ"},
    {u"MAURICE", "MU"},
    {u"MAURITANIE", "MR"},
    {u"MAURITIUS", "MU"},
    {u"MAYOTTE", "YT"},
    {u"MICRONESIA", "FM"},
    {u"MONACO", "MC"},
    {u"MONGOLIA", "MN"},
    {u"MONTSERRAT", "MS"},
    {u"MOÇAMBIQUE", "MZ"},
    {u"MYANMAR (BURMA)", "MM"},
    {u"MÉXICO", "MX"},
    {u"NAMIBIA", "NA"},
    {u"NAMIBIË", "NA"},
    {u"NAURU", "NR"},
    {u"NEDERLAND", "NL"},
    {u"NEPAL", "NP"},
    {u"NETHERLANDS", "NL"},
    {u"NEW ZEALAND", "NZ"},
    {u"NICARAGUA", "NI"},
    {u"NIGER", "NE"},
    {u"NIGERIA", "NG"},
    {u"NIUE", "NU"},
    {u"NORFOLK ISLAND", "NF"},
    {u"NORGE", "NO"},
    {u"NORTH MACEDONIA", "MK"},
    {u"NORTHERN MARIANA ISLANDS", "MP"},
    {u"NORWAY", "NO"},
    {u"NOUVELLE-CALÉDONIE", "NC"},
    {u"PAKISTAN", "PK"},
    {u"PALAU", "PW"},
    {u"PANAMÁ", "PA"},
    {u"PAPUA NEW GUINEA", "PG"},
    {u"PARAGUAY", "PY"},
    {u"PERU", "PE"},
    {u"PERÚ", "PE"},
    {u"PHILIPPINES", "PH"},
    {u"PILIPINAS", "PH"},
    {u"PITCAIRN ISLANDS", "PN"},
    {u"PK", "PK"},
    {u"POLAND", "PL"},
    {u"POLSKA", "PL"},
    {u"POLYNÉSIE FRANÇAISE", "PF"},
    {u"PORTUGAL", "PT"},
    {u"PUERTO RICO", "PR"},
    {u"REPUBLICA MOLDOVA", "MD"},
    {u"REPÚBLICA DOMINICANA", "DO"},
    {u"ROMANIA", "RO"},
    {u"ROMÂNIA", "RO"},
    {u"RUSSIA", "RU"},
    {u"RWANDA", "RW"},
    {u"RÉPUBLIQUE CENTRAFRICAINE", "CF"},
    {u"SAINT-BARTHÉLEMY", "BL"},
    {u"SAINT-MARTIN", "MF"},
    {u"SAINT-PIERRE-ET-MIQUELON", "PM"},
    {u"SAMOA", "WS"},
    {u"SAN MARINO", "SM"},
    {u"SCHWEIZ", "CH"},
    {u"SENEGAL", "SN"},
    {u"SEYCHELLES", "SC"},
    {u"SIERRA LEONE", "SL"},
    {u"SINGAPORE", "SG"},
    {u"SINGAPURA", "SG"},
    {u"SINT MAARTEN", "SX"},
    {u"SINT-MAARTEN", "SX"},
    {u"SLOVAKIA", "SK"},
    {u"SLOVENIA", "SI"},
    {u"SLOVENIJA", "SI"},
    {u"SLOVENSKO", "SK"},
    {u"SOLOMON ISLANDS", "SB"},
    {u"SOMALIA", "SO"},
    {u"SOUTH AFRICA", "ZA"},
    {u"SOUTH GEORGIA & SOUTH SANDWICH ISLANDS", "GS"},
    {u"SOUTH SUDAN", "SS"},
    {u"SPAIN", "ES"},
    {u"SRBIJA", "RS"},
    {u"SRI LANKA", "LK"},
    {u"ST HELENA", "SH"},
    {u"ST KITTS & NEVIS", "KN"},
    {u"ST LUCIA", "LC"},
    {u"ST VINCENT & THE GRENADINES", "VC"},
    {u"SUDAN", "SD"},
    {u"SUID-AFRIKA", "ZA"},
    {u"SUISSE", "CH"},
    {u"SUOMI", "FI"},
    {u"SURINAME", "SR"},
    {u"SUÍÇA", "CH"},
    {u"SVALBARD OG JAN MAYEN", "SJ"},
    {u"SVERIGE", "SE"},
    {u"SVIZZERA", "CH"},
    {u"SWEDEN", "SE"},
    {u"SWITZERLAND", "CH"},
    {u"SYRIE", "SY"},
    {u"SÃO TOMÉ E PRÍNCIPE", "ST"},
    {u"SÉNÉGAL", "SN"},
    {u"TAJIKISTAN", "TJ"},
    {u"TANZANIA", "TZ"},
    {u"TCHAD", "TD"},
    {u"TIMOR-LESTE", "TL"},
    {u"TOGO", "TG"},
    {u"TOKELAU", "TK"},
    {u"TONGA", "TO"},
    {u"TRINIDAD & TOBAGO", "TT"},
    {u"TUNISIE", "TN"},
    {u"TURKMENISTAN", "TM"},
    {u"TURKS & CAICOS ISLANDS", "TC"},
    {u"TUVALU", "TV"},
    {u"TÜRKIYE", "TR"},
    {u"U.S. OUTLYING ISLANDS", "UM"},
    {u"U.S. VIRGIN ISLANDS", "VI"},
    {u"UGANDA", "UG"},
    {u"UKRAINE", "UA"},
    {u"UNITED ARAB EMIRATES", "AE"},
    {u"UNITED KINGDOM", "GB"},
    {u"UNITED STATES", "US"},
    {u"URUGUAY", "UY"},
    {u"UZ", "UZ"},
    {u"UZBEKISTAN", "UZ"},
    {u"VANUATU", "VU"},
    {u"VENEZUELA", "VE"},
    {u"VIỆT NAM", "VN"},
    {u"WALLIS-ET-FUTUNA", "WF"},
    {u"ZAMBIA", "ZM"},
    {u"ZIMBABWE", "ZW"},
    {u"ÅLAND", "AX"},
    {u"ÖSTERREICH", "AT"},
    {u"ČESKO", "CZ"},
    {u"ΕΛΛΆΔΑ", "GR"},
    {u"ΚΎΠΡΟΣ", "CY"},
    {u"БЕЛАРУСЬ", "BY"},
    {u"БОСНА И ХЕРЦЕГОВИНА", "BA"},
    {u"БЪЛГАРИЯ", "BG"},
    {u"КАЗАХСТАН", "KZ"},
    {u"КИРГИЗИЯ", "KG"},
    {u"КОСОВО", "XK"},
    {u"МОЛДОВА", "MD"},
    {u"РОССИЯ", "RU"},
    {u"СРБИЈА", "RS"},
    {u"УКРАЇНА", "UA"},
    {u"УКРАИНА", "UA"},
    {u"ЦРНА ГОРА", "ME"},
    {u"ישראל", "IL"},
    {u"إريتريا", "ER"},
    {u"إسرائيل", "IL"},
    {u"افغانستان", "AF"},
    {u"الأردن", "JO"},
    {u"الإمارات العربية المتحدة", "AE"},
    {u"البحرين", "BH"},
    {u"الجزائر", "DZ"},
    {u"السودان", "SD"},
    {u"الصحراء الغربية", "EH"},
    {u"الصومال", "SO"},
    {u"العراق", "IQ"},
    {u"الكويت", "KW"},
    {u"المغرب", "MA"},
    {u"المملكة العربية السعودية", "SA"},
    {u"اليمن", "YE"},
    {u"ایران", "IR"},
    {u"بھارت", "IN"},
    {u"تشاد", "TD"},
    {u"تونس", "TN"},
    {u"جزر القمر", "KM"},
    {u"جنوب السودان", "SS"},
    {u"جيبوتي", "DJ"},
    {u"سوريا", "SY"},
    {u"عُمان", "OM"},
    {u"فلسطين", "PS"},
    {u"قطر", "QA"},
    {u"لبنان", "LB"},
    {u"ليبيا", "LY"},
    {u"مصر", "EG"},
    {u"موريتانيا", "MR"},
    {u"پاکستان", "PK"},
    {u"भारत", "IN"},
    {u"বাংলাদেশ", "BD"},
    {u"ভারত", "IN"},
    {u"ભારત", "IN"},
    {u"இந்தியா", "IN"},
    {u"இலங்கை", "LK"},
    {u"சிங்கப்பூர்", "SG"},
    {u"மலேசியா", "MY"},
    {u"భారతదేశం", "IN"},
    {u"ಭಾರತ", "IN"},
    {u"ഇന്ത്യ", "IN"},
    {u"ไทย", "TH"},
    {u"ኢትዮጵያ", "ET"},
    {u"中国", "CN"},
    {u"台灣", "TW"},
    {u"新加坡", "SG"},
    {u"日本", "JP"},
    {u"澳門", "MO"},
    {u"澳门", "MO"},
    {u"香港", "HK"},
    {u"馬來西亞", "MY"},
    {u"马来西亚", "MY"},
    {u"대한민국", "KR"},
    {u"조선민주주의인민공화국", "KP"},
    {u"중국", "CN"},
  });

}  // namespace

}  // namespace autofill

#endif  // COMPONENTS_AUTOFILL_CORE_BROWSER_GEO_COUNTRY_NATIVE_NAMES_INL_H_
