// components/attribution_reporting/registration_header_error.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_ATTRIBUTION_REPORTING_REGISTRATION_HEADER_ERROR_MOJOM_DATA_VIEW_H_
#define COMPONENTS_ATTRIBUTION_REPORTING_REGISTRATION_HEADER_ERROR_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "components/attribution_reporting/registration_header_error.mojom-shared-internal.h"
#include "components/attribution_reporting/os_registration_error.mojom-shared.h"
#include "components/attribution_reporting/source_registration_error.mojom-shared.h"
#include "components/attribution_reporting/trigger_registration_error.mojom-shared.h"


namespace attribution_reporting::mojom {
class RegistrationHeaderErrorDataView;

class RegistrationHeaderErrorDetailsDataView;


}  // attribution_reporting::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::attribution_reporting::mojom::RegistrationHeaderErrorDataView> {
  using Data = ::attribution_reporting::mojom::internal::RegistrationHeaderError_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::attribution_reporting::mojom::RegistrationHeaderErrorDetailsDataView> {
  using Data = ::attribution_reporting::mojom::internal::RegistrationHeaderErrorDetails_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace attribution_reporting::mojom {


class RegistrationHeaderErrorDataView {
 public:
  RegistrationHeaderErrorDataView() = default;

  RegistrationHeaderErrorDataView(
      internal::RegistrationHeaderError_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetHeaderValueDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHeaderValue(UserType* output) {
    
    auto* pointer = data_->header_value.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetErrorDetailsDataView(
      RegistrationHeaderErrorDetailsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadErrorDetails(UserType* output) {
    
    auto* pointer = !data_->error_details.is_null() ? &data_->error_details : nullptr;
    return mojo::internal::Deserialize<::attribution_reporting::mojom::RegistrationHeaderErrorDetailsDataView>(
        pointer, output, message_);
  }
 private:
  internal::RegistrationHeaderError_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RegistrationHeaderErrorDetailsDataView {
 public:
  using Tag = internal::RegistrationHeaderErrorDetails_Data::RegistrationHeaderErrorDetails_Tag;

  RegistrationHeaderErrorDetailsDataView() = default;

  RegistrationHeaderErrorDetailsDataView(
      internal::RegistrationHeaderErrorDetails_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_source_error() const { return data_->tag == Tag::kSourceError; }
  template <typename UserType>
  [[nodiscard]] bool ReadSourceError(UserType* output) const {
    CHECK(is_source_error());
    return mojo::internal::Deserialize<::attribution_reporting::mojom::SourceRegistrationError>(
        data_->data.f_source_error, output);
  }
  ::attribution_reporting::mojom::SourceRegistrationError source_error() const {
    CHECK(is_source_error());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::attribution_reporting::mojom::SourceRegistrationError>(data_->data.f_source_error));
  }
  bool is_trigger_error() const { return data_->tag == Tag::kTriggerError; }
  template <typename UserType>
  [[nodiscard]] bool ReadTriggerError(UserType* output) const {
    CHECK(is_trigger_error());
    return mojo::internal::Deserialize<::attribution_reporting::mojom::TriggerRegistrationError>(
        data_->data.f_trigger_error, output);
  }
  ::attribution_reporting::mojom::TriggerRegistrationError trigger_error() const {
    CHECK(is_trigger_error());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::attribution_reporting::mojom::TriggerRegistrationError>(data_->data.f_trigger_error));
  }
  bool is_os_source_error() const { return data_->tag == Tag::kOsSourceError; }
  template <typename UserType>
  [[nodiscard]] bool ReadOsSourceError(UserType* output) const {
    CHECK(is_os_source_error());
    return mojo::internal::Deserialize<::attribution_reporting::mojom::OsRegistrationError>(
        data_->data.f_os_source_error, output);
  }
  ::attribution_reporting::mojom::OsRegistrationError os_source_error() const {
    CHECK(is_os_source_error());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::attribution_reporting::mojom::OsRegistrationError>(data_->data.f_os_source_error));
  }
  bool is_os_trigger_error() const { return data_->tag == Tag::kOsTriggerError; }
  template <typename UserType>
  [[nodiscard]] bool ReadOsTriggerError(UserType* output) const {
    CHECK(is_os_trigger_error());
    return mojo::internal::Deserialize<::attribution_reporting::mojom::OsRegistrationError>(
        data_->data.f_os_trigger_error, output);
  }
  ::attribution_reporting::mojom::OsRegistrationError os_trigger_error() const {
    CHECK(is_os_trigger_error());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::attribution_reporting::mojom::OsRegistrationError>(data_->data.f_os_trigger_error));
  }

 private:
  internal::RegistrationHeaderErrorDetails_Data* data_ = nullptr;
};



}  // attribution_reporting::mojom

#endif  // COMPONENTS_ATTRIBUTION_REPORTING_REGISTRATION_HEADER_ERROR_MOJOM_DATA_VIEW_H_