// chrome/updater/mojom/updater_service_internal.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/updater/mojom/updater_service_internal.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/updater/mojom/updater_service_internal.mojom-params-data.h"
#include "chrome/updater/mojom/updater_service_internal.mojom-shared-message-ids.h"

#include "chrome/updater/mojom/updater_service_internal.mojom-import-headers.h"
#include "chrome/updater/mojom/updater_service_internal.mojom-test-utils.h"


namespace updater::mojom {
// The declaration includes the definition on other builds.

UpdateServiceInternal::IPCStableHashFunction UpdateServiceInternal::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::UpdateServiceInternal>(message.name())) {
    case messages::UpdateServiceInternal::kRun: {
      return &UpdateServiceInternal::Run_Sym::IPCStableHash;
    }
    case messages::UpdateServiceInternal::kHello: {
      return &UpdateServiceInternal::Hello_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* UpdateServiceInternal::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::UpdateServiceInternal>(message.name())) {
      case messages::UpdateServiceInternal::kRun:
            return "Receive updater::mojom::UpdateServiceInternal::Run";
      case messages::UpdateServiceInternal::kHello:
            return "Receive updater::mojom::UpdateServiceInternal::Hello";
    }
  } else {
    switch (static_cast<messages::UpdateServiceInternal>(message.name())) {
      case messages::UpdateServiceInternal::kRun:
            return "Receive reply updater::mojom::UpdateServiceInternal::Run";
      case messages::UpdateServiceInternal::kHello:
            return "Receive reply updater::mojom::UpdateServiceInternal::Hello";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t UpdateServiceInternal::Run_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7e8e052b;  // IPCStableHash for updater::mojom::UpdateServiceInternal::Run
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UpdateServiceInternal::Hello_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc4b53af1;  // IPCStableHash for updater::mojom::UpdateServiceInternal::Hello
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class UpdateServiceInternal_Run_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  UpdateServiceInternal_Run_ForwardToCallback(
      UpdateServiceInternal::RunCallback callback
      ) : callback_(std::move(callback)) {
  }

  UpdateServiceInternal_Run_ForwardToCallback(const UpdateServiceInternal_Run_ForwardToCallback&) = delete;
  UpdateServiceInternal_Run_ForwardToCallback& operator=(const UpdateServiceInternal_Run_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  UpdateServiceInternal::RunCallback callback_;
};

class UpdateServiceInternal_Hello_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  UpdateServiceInternal_Hello_ForwardToCallback(
      UpdateServiceInternal::HelloCallback callback
      ) : callback_(std::move(callback)) {
  }

  UpdateServiceInternal_Hello_ForwardToCallback(const UpdateServiceInternal_Hello_ForwardToCallback&) = delete;
  UpdateServiceInternal_Hello_ForwardToCallback& operator=(const UpdateServiceInternal_Hello_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  UpdateServiceInternal::HelloCallback callback_;
};

UpdateServiceInternalProxy::UpdateServiceInternalProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void UpdateServiceInternalProxy::Run(
    RunCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send updater::mojom::UpdateServiceInternal::Run");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UpdateServiceInternal::kRun), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::updater::mojom::internal::UpdateServiceInternal_Run_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UpdateServiceInternal::Name_);
  message.set_method_name("Run");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new UpdateServiceInternal_Run_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void UpdateServiceInternalProxy::Hello(
    HelloCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send updater::mojom::UpdateServiceInternal::Hello");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UpdateServiceInternal::kHello), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::updater::mojom::internal::UpdateServiceInternal_Hello_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UpdateServiceInternal::Name_);
  message.set_method_name("Hello");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new UpdateServiceInternal_Hello_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class UpdateServiceInternal_Run_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static UpdateServiceInternal::RunCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<UpdateServiceInternal_Run_ProxyToResponder> proxy(
        new UpdateServiceInternal_Run_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&UpdateServiceInternal_Run_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~UpdateServiceInternal_Run_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  UpdateServiceInternal_Run_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "UpdateServiceInternal::RunCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool UpdateServiceInternal_Run_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::UpdateServiceInternal_Run_ResponseParams_Data* params =
      reinterpret_cast<
          internal::UpdateServiceInternal_Run_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for UpdateServiceInternal.0
  bool success = true;
  UpdateServiceInternal_Run_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        UpdateServiceInternal::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void UpdateServiceInternal_Run_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply updater::mojom::UpdateServiceInternal::Run");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UpdateServiceInternal::kRun), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::updater::mojom::internal::UpdateServiceInternal_Run_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UpdateServiceInternal::Name_);
  message.set_method_name("Run");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class UpdateServiceInternal_Hello_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static UpdateServiceInternal::HelloCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<UpdateServiceInternal_Hello_ProxyToResponder> proxy(
        new UpdateServiceInternal_Hello_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&UpdateServiceInternal_Hello_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~UpdateServiceInternal_Hello_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  UpdateServiceInternal_Hello_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "UpdateServiceInternal::HelloCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool UpdateServiceInternal_Hello_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::UpdateServiceInternal_Hello_ResponseParams_Data* params =
      reinterpret_cast<
          internal::UpdateServiceInternal_Hello_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for UpdateServiceInternal.1
  bool success = true;
  UpdateServiceInternal_Hello_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        UpdateServiceInternal::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void UpdateServiceInternal_Hello_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply updater::mojom::UpdateServiceInternal::Hello");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UpdateServiceInternal::kHello), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::updater::mojom::internal::UpdateServiceInternal_Hello_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UpdateServiceInternal::Name_);
  message.set_method_name("Hello");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool UpdateServiceInternalStubDispatch::Accept(
    UpdateServiceInternal* impl,
    mojo::Message* message) {
  switch (static_cast<messages::UpdateServiceInternal>(message->header()->name)) {
    case messages::UpdateServiceInternal::kRun: {
      break;
    }
    case messages::UpdateServiceInternal::kHello: {
      break;
    }
  }
  return false;
}

// static
bool UpdateServiceInternalStubDispatch::AcceptWithResponder(
    UpdateServiceInternal* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::UpdateServiceInternal>(message->header()->name)) {
    case messages::UpdateServiceInternal::kRun: {
      internal::UpdateServiceInternal_Run_Params_Data* params =
          reinterpret_cast<
              internal::UpdateServiceInternal_Run_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for UpdateServiceInternal.0
      bool success = true;
      UpdateServiceInternal_Run_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UpdateServiceInternal::Name_, 0, false);
        return false;
      }
      auto callback =
          UpdateServiceInternal_Run_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Run(std::move(callback));
      return true;
    }
    case messages::UpdateServiceInternal::kHello: {
      internal::UpdateServiceInternal_Hello_Params_Data* params =
          reinterpret_cast<
              internal::UpdateServiceInternal_Hello_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for UpdateServiceInternal.1
      bool success = true;
      UpdateServiceInternal_Hello_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UpdateServiceInternal::Name_, 1, false);
        return false;
      }
      auto callback =
          UpdateServiceInternal_Hello_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Hello(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kUpdateServiceInternalValidationInfo[] = {
    { &internal::UpdateServiceInternal_Run_Params_Data::Validate,
     &internal::UpdateServiceInternal_Run_ResponseParams_Data::Validate},
    { &internal::UpdateServiceInternal_Hello_Params_Data::Validate,
     &internal::UpdateServiceInternal_Hello_ResponseParams_Data::Validate},
};

bool UpdateServiceInternalRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::updater::mojom::UpdateServiceInternal::Name_,
    kUpdateServiceInternalValidationInfo);
}

bool UpdateServiceInternalResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::updater::mojom::UpdateServiceInternal::Name_,
    kUpdateServiceInternalValidationInfo);
}


}  // updater::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace updater::mojom {


void UpdateServiceInternalInterceptorForTesting::Run(RunCallback callback) {
  GetForwardingInterface()->Run(std::move(callback));
}
void UpdateServiceInternalInterceptorForTesting::Hello(HelloCallback callback) {
  GetForwardingInterface()->Hello(std::move(callback));
}
UpdateServiceInternalAsyncWaiter::UpdateServiceInternalAsyncWaiter(
    UpdateServiceInternal* proxy) : proxy_(proxy) {}

UpdateServiceInternalAsyncWaiter::~UpdateServiceInternalAsyncWaiter() = default;


void UpdateServiceInternalAsyncWaiter::Run(
    ) {
  base::RunLoop loop;
  proxy_->Run(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void UpdateServiceInternalAsyncWaiter::Hello(
    ) {
  base::RunLoop loop;
  proxy_->Hello(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}








}  // updater::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif