// chrome/services/printing/public/mojom/print_backend_service.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/services/printing/public/mojom/print_backend_service.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/services/printing/public/mojom/print_backend_service.mojom-params-data.h"
#include "chrome/services/printing/public/mojom/print_backend_service.mojom-shared-message-ids.h"

#include "chrome/services/printing/public/mojom/print_backend_service.mojom-import-headers.h"
#include "chrome/services/printing/public/mojom/print_backend_service.mojom-test-utils.h"


namespace printing::mojom {
PrinterCapsAndInfo::PrinterCapsAndInfo()
    : printer_info(),
      printer_caps() {}

PrinterCapsAndInfo::PrinterCapsAndInfo(
    const ::printing::PrinterBasicInfo& printer_info_in,
    const ::printing::PrinterSemanticCapsAndDefaults& printer_caps_in)
    : printer_info(std::move(printer_info_in)),
      printer_caps(std::move(printer_caps_in)) {}

PrinterCapsAndInfo::~PrinterCapsAndInfo() = default;

void PrinterCapsAndInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "printer_info"), this->printer_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::printing::PrinterBasicInfo&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "printer_caps"), this->printer_caps,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::printing::PrinterSemanticCapsAndDefaults&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PrinterCapsAndInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PrintBackendService_EnumeratePrinters_ResponseParam_ResultPtr
PrintBackendService_EnumeratePrinters_ResponseParam_Result::NewSuccess(
    std::vector<::printing::PrinterBasicInfo> value) {
  return PrintBackendService_EnumeratePrinters_ResponseParam_ResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
      std::move(value));
}

PrintBackendService_EnumeratePrinters_ResponseParam_ResultPtr
PrintBackendService_EnumeratePrinters_ResponseParam_Result::NewFailure(
    ::printing::mojom::ResultCode value) {
  return PrintBackendService_EnumeratePrinters_ResponseParam_ResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kFailure)>,
      std::move(value));
}

PrintBackendService_EnumeratePrinters_ResponseParam_Result::PrintBackendService_EnumeratePrinters_ResponseParam_Result(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    std::vector<::printing::PrinterBasicInfo> value)
    : tag_(Tag::kSuccess),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
            std::move(value)) {}

PrintBackendService_EnumeratePrinters_ResponseParam_Result::PrintBackendService_EnumeratePrinters_ResponseParam_Result(
    std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
    ::printing::mojom::ResultCode value)
    : tag_(Tag::kFailure),
      data_(std::in_place_index<static_cast<size_t>(Tag::kFailure)>,
            std::move(value)) {}
PrintBackendService_EnumeratePrinters_ResponseParam_Result::~PrintBackendService_EnumeratePrinters_ResponseParam_Result() {
  DestroyActive();
}

void PrintBackendService_EnumeratePrinters_ResponseParam_Result::set_success(std::vector<::printing::PrinterBasicInfo> success) {
  if (tag_ == Tag::kSuccess) {
    data_.success = std::move(success);
  } else {
    DestroyActive();
    tag_ = Tag::kSuccess;
    new (&data_.success) std::vector<::printing::PrinterBasicInfo>(
        std::move(success));
  }
}

void PrintBackendService_EnumeratePrinters_ResponseParam_Result::set_failure(::printing::mojom::ResultCode failure) {
  if (tag_ != Tag::kFailure) {
    DestroyActive();
    tag_ = Tag::kFailure;
  }
  data_.failure = failure;
}


PrintBackendService_EnumeratePrinters_ResponseParam_Result::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    std::vector<::printing::PrinterBasicInfo> value)
    : success(std::move(value)) {}

PrintBackendService_EnumeratePrinters_ResponseParam_Result::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
    ::printing::mojom::ResultCode value)
    : failure(std::move(value)) {}

void PrintBackendService_EnumeratePrinters_ResponseParam_Result::DestroyActive() {
  switch (tag_) {

    case Tag::kSuccess:
      std::destroy_at(&data_.success);
      break;
    case Tag::kFailure:
      std::destroy_at(&data_.failure);
      break;
  }
}

bool PrintBackendService_EnumeratePrinters_ResponseParam_Result::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
PrintBackendService_GetDefaultPrinterName_ResponseParam_ResultPtr
PrintBackendService_GetDefaultPrinterName_ResponseParam_Result::NewSuccess(
    const std::string& value) {
  return PrintBackendService_GetDefaultPrinterName_ResponseParam_ResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
      std::move(value));
}

PrintBackendService_GetDefaultPrinterName_ResponseParam_ResultPtr
PrintBackendService_GetDefaultPrinterName_ResponseParam_Result::NewFailure(
    ::printing::mojom::ResultCode value) {
  return PrintBackendService_GetDefaultPrinterName_ResponseParam_ResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kFailure)>,
      std::move(value));
}

PrintBackendService_GetDefaultPrinterName_ResponseParam_Result::PrintBackendService_GetDefaultPrinterName_ResponseParam_Result(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    const std::string& value)
    : tag_(Tag::kSuccess),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
            std::move(value)) {}

PrintBackendService_GetDefaultPrinterName_ResponseParam_Result::PrintBackendService_GetDefaultPrinterName_ResponseParam_Result(
    std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
    ::printing::mojom::ResultCode value)
    : tag_(Tag::kFailure),
      data_(std::in_place_index<static_cast<size_t>(Tag::kFailure)>,
            std::move(value)) {}
PrintBackendService_GetDefaultPrinterName_ResponseParam_Result::~PrintBackendService_GetDefaultPrinterName_ResponseParam_Result() {
  DestroyActive();
}

void PrintBackendService_GetDefaultPrinterName_ResponseParam_Result::set_success(const std::string& success) {
  if (tag_ == Tag::kSuccess) {
    data_.success = std::move(success);
  } else {
    DestroyActive();
    tag_ = Tag::kSuccess;
    new (&data_.success) std::string(
        std::move(success));
  }
}

void PrintBackendService_GetDefaultPrinterName_ResponseParam_Result::set_failure(::printing::mojom::ResultCode failure) {
  if (tag_ != Tag::kFailure) {
    DestroyActive();
    tag_ = Tag::kFailure;
  }
  data_.failure = failure;
}


PrintBackendService_GetDefaultPrinterName_ResponseParam_Result::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    const std::string& value)
    : success(std::move(value)) {}

PrintBackendService_GetDefaultPrinterName_ResponseParam_Result::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
    ::printing::mojom::ResultCode value)
    : failure(std::move(value)) {}

void PrintBackendService_GetDefaultPrinterName_ResponseParam_Result::DestroyActive() {
  switch (tag_) {

    case Tag::kSuccess:
      std::destroy_at(&data_.success);
      break;
    case Tag::kFailure:
      std::destroy_at(&data_.failure);
      break;
  }
}
size_t PrintBackendService_GetDefaultPrinterName_ResponseParam_Result::Hash(size_t seed) const {
  seed = mojo::internal::HashCombine(seed, static_cast<uint32_t>(tag_));
  switch (tag_) {

    case Tag::kSuccess:
      return mojo::internal::Hash(seed, data_.success);
    case Tag::kFailure:
      return mojo::internal::Hash(seed, data_.failure);
    default:
      NOTREACHED();
  }
}

bool PrintBackendService_GetDefaultPrinterName_ResponseParam_Result::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
PrintBackendService_FetchCapabilities_ResponseParam_ResultPtr
PrintBackendService_FetchCapabilities_ResponseParam_Result::NewSuccess(
    PrinterCapsAndInfoPtr value) {
  return PrintBackendService_FetchCapabilities_ResponseParam_ResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
      std::move(value));
}

PrintBackendService_FetchCapabilities_ResponseParam_ResultPtr
PrintBackendService_FetchCapabilities_ResponseParam_Result::NewFailure(
    ::printing::mojom::ResultCode value) {
  return PrintBackendService_FetchCapabilities_ResponseParam_ResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kFailure)>,
      std::move(value));
}

PrintBackendService_FetchCapabilities_ResponseParam_Result::PrintBackendService_FetchCapabilities_ResponseParam_Result(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    PrinterCapsAndInfoPtr value)
    : tag_(Tag::kSuccess),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
            std::move(value)) {}

PrintBackendService_FetchCapabilities_ResponseParam_Result::PrintBackendService_FetchCapabilities_ResponseParam_Result(
    std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
    ::printing::mojom::ResultCode value)
    : tag_(Tag::kFailure),
      data_(std::in_place_index<static_cast<size_t>(Tag::kFailure)>,
            std::move(value)) {}
PrintBackendService_FetchCapabilities_ResponseParam_Result::~PrintBackendService_FetchCapabilities_ResponseParam_Result() {
  DestroyActive();
}

void PrintBackendService_FetchCapabilities_ResponseParam_Result::set_success(PrinterCapsAndInfoPtr success) {
  if (tag_ == Tag::kSuccess) {
    data_.success = std::move(success);
  } else {
    DestroyActive();
    tag_ = Tag::kSuccess;
    new (&data_.success) PrinterCapsAndInfoPtr(
        std::move(success));
  }
}

void PrintBackendService_FetchCapabilities_ResponseParam_Result::set_failure(::printing::mojom::ResultCode failure) {
  if (tag_ != Tag::kFailure) {
    DestroyActive();
    tag_ = Tag::kFailure;
  }
  data_.failure = failure;
}


PrintBackendService_FetchCapabilities_ResponseParam_Result::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    PrinterCapsAndInfoPtr value)
    : success(std::move(value)) {}

PrintBackendService_FetchCapabilities_ResponseParam_Result::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
    ::printing::mojom::ResultCode value)
    : failure(std::move(value)) {}

void PrintBackendService_FetchCapabilities_ResponseParam_Result::DestroyActive() {
  switch (tag_) {

    case Tag::kSuccess:
      std::destroy_at(&data_.success);
      break;
    case Tag::kFailure:
      std::destroy_at(&data_.failure);
      break;
  }
}

bool PrintBackendService_FetchCapabilities_ResponseParam_Result::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
PrintBackendService_UseDefaultSettings_ResponseParam_ResultPtr
PrintBackendService_UseDefaultSettings_ResponseParam_Result::NewSuccess(
    const ::printing::PrintSettings& value) {
  return PrintBackendService_UseDefaultSettings_ResponseParam_ResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
      std::move(value));
}

PrintBackendService_UseDefaultSettings_ResponseParam_ResultPtr
PrintBackendService_UseDefaultSettings_ResponseParam_Result::NewFailure(
    ::printing::mojom::ResultCode value) {
  return PrintBackendService_UseDefaultSettings_ResponseParam_ResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kFailure)>,
      std::move(value));
}

PrintBackendService_UseDefaultSettings_ResponseParam_Result::PrintBackendService_UseDefaultSettings_ResponseParam_Result(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    const ::printing::PrintSettings& value)
    : tag_(Tag::kSuccess),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
            std::move(value)) {}

PrintBackendService_UseDefaultSettings_ResponseParam_Result::PrintBackendService_UseDefaultSettings_ResponseParam_Result(
    std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
    ::printing::mojom::ResultCode value)
    : tag_(Tag::kFailure),
      data_(std::in_place_index<static_cast<size_t>(Tag::kFailure)>,
            std::move(value)) {}
PrintBackendService_UseDefaultSettings_ResponseParam_Result::~PrintBackendService_UseDefaultSettings_ResponseParam_Result() {
  DestroyActive();
}

void PrintBackendService_UseDefaultSettings_ResponseParam_Result::set_success(const ::printing::PrintSettings& success) {
  if (tag_ == Tag::kSuccess) {
    data_.success = std::move(success);
  } else {
    DestroyActive();
    tag_ = Tag::kSuccess;
    new (&data_.success) ::printing::PrintSettings(
        std::move(success));
  }
}

void PrintBackendService_UseDefaultSettings_ResponseParam_Result::set_failure(::printing::mojom::ResultCode failure) {
  if (tag_ != Tag::kFailure) {
    DestroyActive();
    tag_ = Tag::kFailure;
  }
  data_.failure = failure;
}


PrintBackendService_UseDefaultSettings_ResponseParam_Result::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    const ::printing::PrintSettings& value)
    : success(std::move(value)) {}

PrintBackendService_UseDefaultSettings_ResponseParam_Result::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
    ::printing::mojom::ResultCode value)
    : failure(std::move(value)) {}

void PrintBackendService_UseDefaultSettings_ResponseParam_Result::DestroyActive() {
  switch (tag_) {

    case Tag::kSuccess:
      std::destroy_at(&data_.success);
      break;
    case Tag::kFailure:
      std::destroy_at(&data_.failure);
      break;
  }
}

bool PrintBackendService_UseDefaultSettings_ResponseParam_Result::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
PrintBackendService_UpdatePrintSettings_ResponseParam_ResultPtr
PrintBackendService_UpdatePrintSettings_ResponseParam_Result::NewSuccess(
    const ::printing::PrintSettings& value) {
  return PrintBackendService_UpdatePrintSettings_ResponseParam_ResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
      std::move(value));
}

PrintBackendService_UpdatePrintSettings_ResponseParam_ResultPtr
PrintBackendService_UpdatePrintSettings_ResponseParam_Result::NewFailure(
    ::printing::mojom::ResultCode value) {
  return PrintBackendService_UpdatePrintSettings_ResponseParam_ResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kFailure)>,
      std::move(value));
}

PrintBackendService_UpdatePrintSettings_ResponseParam_Result::PrintBackendService_UpdatePrintSettings_ResponseParam_Result(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    const ::printing::PrintSettings& value)
    : tag_(Tag::kSuccess),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
            std::move(value)) {}

PrintBackendService_UpdatePrintSettings_ResponseParam_Result::PrintBackendService_UpdatePrintSettings_ResponseParam_Result(
    std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
    ::printing::mojom::ResultCode value)
    : tag_(Tag::kFailure),
      data_(std::in_place_index<static_cast<size_t>(Tag::kFailure)>,
            std::move(value)) {}
PrintBackendService_UpdatePrintSettings_ResponseParam_Result::~PrintBackendService_UpdatePrintSettings_ResponseParam_Result() {
  DestroyActive();
}

void PrintBackendService_UpdatePrintSettings_ResponseParam_Result::set_success(const ::printing::PrintSettings& success) {
  if (tag_ == Tag::kSuccess) {
    data_.success = std::move(success);
  } else {
    DestroyActive();
    tag_ = Tag::kSuccess;
    new (&data_.success) ::printing::PrintSettings(
        std::move(success));
  }
}

void PrintBackendService_UpdatePrintSettings_ResponseParam_Result::set_failure(::printing::mojom::ResultCode failure) {
  if (tag_ != Tag::kFailure) {
    DestroyActive();
    tag_ = Tag::kFailure;
  }
  data_.failure = failure;
}


PrintBackendService_UpdatePrintSettings_ResponseParam_Result::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    const ::printing::PrintSettings& value)
    : success(std::move(value)) {}

PrintBackendService_UpdatePrintSettings_ResponseParam_Result::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
    ::printing::mojom::ResultCode value)
    : failure(std::move(value)) {}

void PrintBackendService_UpdatePrintSettings_ResponseParam_Result::DestroyActive() {
  switch (tag_) {

    case Tag::kSuccess:
      std::destroy_at(&data_.success);
      break;
    case Tag::kFailure:
      std::destroy_at(&data_.failure);
      break;
  }
}

bool PrintBackendService_UpdatePrintSettings_ResponseParam_Result::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

UnsandboxedPrintBackendHost::IPCStableHashFunction UnsandboxedPrintBackendHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::UnsandboxedPrintBackendHost>(message.name())) {
    case messages::UnsandboxedPrintBackendHost::kBindBackend: {
      return &UnsandboxedPrintBackendHost::BindBackend_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* UnsandboxedPrintBackendHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::UnsandboxedPrintBackendHost>(message.name())) {
      case messages::UnsandboxedPrintBackendHost::kBindBackend:
            return "Receive printing::mojom::UnsandboxedPrintBackendHost::BindBackend";
    }
  } else {
    switch (static_cast<messages::UnsandboxedPrintBackendHost>(message.name())) {
      case messages::UnsandboxedPrintBackendHost::kBindBackend:
            return "Receive reply printing::mojom::UnsandboxedPrintBackendHost::BindBackend";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t UnsandboxedPrintBackendHost::BindBackend_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x19e6abfc;  // IPCStableHash for printing::mojom::UnsandboxedPrintBackendHost::BindBackend
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

UnsandboxedPrintBackendHostProxy::UnsandboxedPrintBackendHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void UnsandboxedPrintBackendHostProxy::BindBackend(
    ::mojo::PendingReceiver<PrintBackendService> in_service) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send printing::mojom::UnsandboxedPrintBackendHost::BindBackend", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service"), in_service,
                        "<value of type ::mojo::PendingReceiver<PrintBackendService>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UnsandboxedPrintBackendHost::kBindBackend), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::UnsandboxedPrintBackendHost_BindBackend_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::printing::mojom::PrintBackendServiceInterfaceBase>>(
    in_service,
    &params->service,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->service)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid service in UnsandboxedPrintBackendHost.BindBackend request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UnsandboxedPrintBackendHost::Name_);
  message.set_method_name("BindBackend");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool UnsandboxedPrintBackendHostStubDispatch::Accept(
    UnsandboxedPrintBackendHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::UnsandboxedPrintBackendHost>(message->header()->name)) {
    case messages::UnsandboxedPrintBackendHost::kBindBackend: {
      DCHECK(message->is_serialized());
      internal::UnsandboxedPrintBackendHost_BindBackend_Params_Data* params =
          reinterpret_cast<internal::UnsandboxedPrintBackendHost_BindBackend_Params_Data*>(
              message->mutable_payload());
      

      // Validation for UnsandboxedPrintBackendHost.0
      bool success = true;
      ::mojo::PendingReceiver<PrintBackendService> p_service{};
      UnsandboxedPrintBackendHost_BindBackend_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_service =
            input_data_view.TakeService<decltype(p_service)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UnsandboxedPrintBackendHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindBackend(        
        std::move(p_service));
      return true;
    }
  }
  return false;
}

// static
bool UnsandboxedPrintBackendHostStubDispatch::AcceptWithResponder(
    UnsandboxedPrintBackendHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::UnsandboxedPrintBackendHost>(message->header()->name)) {
    case messages::UnsandboxedPrintBackendHost::kBindBackend: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kUnsandboxedPrintBackendHostValidationInfo[] = {
    { &internal::UnsandboxedPrintBackendHost_BindBackend_Params_Data::Validate,
     nullptr /* no response */},
};

bool UnsandboxedPrintBackendHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::printing::mojom::UnsandboxedPrintBackendHost::Name_,
    kUnsandboxedPrintBackendHostValidationInfo);
}

// The declaration includes the definition on other builds.

SandboxedPrintBackendHost::IPCStableHashFunction SandboxedPrintBackendHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SandboxedPrintBackendHost>(message.name())) {
    case messages::SandboxedPrintBackendHost::kBindBackend: {
      return &SandboxedPrintBackendHost::BindBackend_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SandboxedPrintBackendHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SandboxedPrintBackendHost>(message.name())) {
      case messages::SandboxedPrintBackendHost::kBindBackend:
            return "Receive printing::mojom::SandboxedPrintBackendHost::BindBackend";
    }
  } else {
    switch (static_cast<messages::SandboxedPrintBackendHost>(message.name())) {
      case messages::SandboxedPrintBackendHost::kBindBackend:
            return "Receive reply printing::mojom::SandboxedPrintBackendHost::BindBackend";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SandboxedPrintBackendHost::BindBackend_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xebdd6a9f;  // IPCStableHash for printing::mojom::SandboxedPrintBackendHost::BindBackend
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

SandboxedPrintBackendHostProxy::SandboxedPrintBackendHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SandboxedPrintBackendHostProxy::BindBackend(
    ::mojo::PendingReceiver<PrintBackendService> in_service) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send printing::mojom::SandboxedPrintBackendHost::BindBackend", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service"), in_service,
                        "<value of type ::mojo::PendingReceiver<PrintBackendService>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SandboxedPrintBackendHost::kBindBackend), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::SandboxedPrintBackendHost_BindBackend_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::printing::mojom::PrintBackendServiceInterfaceBase>>(
    in_service,
    &params->service,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->service)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid service in SandboxedPrintBackendHost.BindBackend request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SandboxedPrintBackendHost::Name_);
  message.set_method_name("BindBackend");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool SandboxedPrintBackendHostStubDispatch::Accept(
    SandboxedPrintBackendHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SandboxedPrintBackendHost>(message->header()->name)) {
    case messages::SandboxedPrintBackendHost::kBindBackend: {
      DCHECK(message->is_serialized());
      internal::SandboxedPrintBackendHost_BindBackend_Params_Data* params =
          reinterpret_cast<internal::SandboxedPrintBackendHost_BindBackend_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SandboxedPrintBackendHost.0
      bool success = true;
      ::mojo::PendingReceiver<PrintBackendService> p_service{};
      SandboxedPrintBackendHost_BindBackend_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_service =
            input_data_view.TakeService<decltype(p_service)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SandboxedPrintBackendHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindBackend(        
        std::move(p_service));
      return true;
    }
  }
  return false;
}

// static
bool SandboxedPrintBackendHostStubDispatch::AcceptWithResponder(
    SandboxedPrintBackendHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SandboxedPrintBackendHost>(message->header()->name)) {
    case messages::SandboxedPrintBackendHost::kBindBackend: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSandboxedPrintBackendHostValidationInfo[] = {
    { &internal::SandboxedPrintBackendHost_BindBackend_Params_Data::Validate,
     nullptr /* no response */},
};

bool SandboxedPrintBackendHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::printing::mojom::SandboxedPrintBackendHost::Name_,
    kSandboxedPrintBackendHostValidationInfo);
}

// The declaration includes the definition on other builds.

PrintBackendService::IPCStableHashFunction PrintBackendService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PrintBackendService>(message.name())) {
    case messages::PrintBackendService::kInit: {
      return &PrintBackendService::Init_Sym::IPCStableHash;
    }
    case messages::PrintBackendService::kPoke: {
      return &PrintBackendService::Poke_Sym::IPCStableHash;
    }
    case messages::PrintBackendService::kEnumeratePrinters: {
      return &PrintBackendService::EnumeratePrinters_Sym::IPCStableHash;
    }
    case messages::PrintBackendService::kGetDefaultPrinterName: {
      return &PrintBackendService::GetDefaultPrinterName_Sym::IPCStableHash;
    }
    case messages::PrintBackendService::kFetchCapabilities: {
      return &PrintBackendService::FetchCapabilities_Sym::IPCStableHash;
    }
    case messages::PrintBackendService::kEstablishPrintingContext: {
      return &PrintBackendService::EstablishPrintingContext_Sym::IPCStableHash;
    }
    case messages::PrintBackendService::kUseDefaultSettings: {
      return &PrintBackendService::UseDefaultSettings_Sym::IPCStableHash;
    }
    case messages::PrintBackendService::kUpdatePrintSettings: {
      return &PrintBackendService::UpdatePrintSettings_Sym::IPCStableHash;
    }
    case messages::PrintBackendService::kStartPrinting: {
      return &PrintBackendService::StartPrinting_Sym::IPCStableHash;
    }
    case messages::PrintBackendService::kRenderPrintedDocument: {
      return &PrintBackendService::RenderPrintedDocument_Sym::IPCStableHash;
    }
    case messages::PrintBackendService::kDocumentDone: {
      return &PrintBackendService::DocumentDone_Sym::IPCStableHash;
    }
    case messages::PrintBackendService::kCancel: {
      return &PrintBackendService::Cancel_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PrintBackendService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PrintBackendService>(message.name())) {
      case messages::PrintBackendService::kInit:
            return "Receive printing::mojom::PrintBackendService::Init";
      case messages::PrintBackendService::kPoke:
            return "Receive printing::mojom::PrintBackendService::Poke";
      case messages::PrintBackendService::kEnumeratePrinters:
            return "Receive printing::mojom::PrintBackendService::EnumeratePrinters";
      case messages::PrintBackendService::kGetDefaultPrinterName:
            return "Receive printing::mojom::PrintBackendService::GetDefaultPrinterName";
      case messages::PrintBackendService::kFetchCapabilities:
            return "Receive printing::mojom::PrintBackendService::FetchCapabilities";
      case messages::PrintBackendService::kEstablishPrintingContext:
            return "Receive printing::mojom::PrintBackendService::EstablishPrintingContext";
      case messages::PrintBackendService::kUseDefaultSettings:
            return "Receive printing::mojom::PrintBackendService::UseDefaultSettings";
      case messages::PrintBackendService::kUpdatePrintSettings:
            return "Receive printing::mojom::PrintBackendService::UpdatePrintSettings";
      case messages::PrintBackendService::kStartPrinting:
            return "Receive printing::mojom::PrintBackendService::StartPrinting";
      case messages::PrintBackendService::kRenderPrintedDocument:
            return "Receive printing::mojom::PrintBackendService::RenderPrintedDocument";
      case messages::PrintBackendService::kDocumentDone:
            return "Receive printing::mojom::PrintBackendService::DocumentDone";
      case messages::PrintBackendService::kCancel:
            return "Receive printing::mojom::PrintBackendService::Cancel";
    }
  } else {
    switch (static_cast<messages::PrintBackendService>(message.name())) {
      case messages::PrintBackendService::kInit:
            return "Receive reply printing::mojom::PrintBackendService::Init";
      case messages::PrintBackendService::kPoke:
            return "Receive reply printing::mojom::PrintBackendService::Poke";
      case messages::PrintBackendService::kEnumeratePrinters:
            return "Receive reply printing::mojom::PrintBackendService::EnumeratePrinters";
      case messages::PrintBackendService::kGetDefaultPrinterName:
            return "Receive reply printing::mojom::PrintBackendService::GetDefaultPrinterName";
      case messages::PrintBackendService::kFetchCapabilities:
            return "Receive reply printing::mojom::PrintBackendService::FetchCapabilities";
      case messages::PrintBackendService::kEstablishPrintingContext:
            return "Receive reply printing::mojom::PrintBackendService::EstablishPrintingContext";
      case messages::PrintBackendService::kUseDefaultSettings:
            return "Receive reply printing::mojom::PrintBackendService::UseDefaultSettings";
      case messages::PrintBackendService::kUpdatePrintSettings:
            return "Receive reply printing::mojom::PrintBackendService::UpdatePrintSettings";
      case messages::PrintBackendService::kStartPrinting:
            return "Receive reply printing::mojom::PrintBackendService::StartPrinting";
      case messages::PrintBackendService::kRenderPrintedDocument:
            return "Receive reply printing::mojom::PrintBackendService::RenderPrintedDocument";
      case messages::PrintBackendService::kDocumentDone:
            return "Receive reply printing::mojom::PrintBackendService::DocumentDone";
      case messages::PrintBackendService::kCancel:
            return "Receive reply printing::mojom::PrintBackendService::Cancel";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PrintBackendService::Init_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1916b3e7;  // IPCStableHash for printing::mojom::PrintBackendService::Init
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PrintBackendService::Poke_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbdfef378;  // IPCStableHash for printing::mojom::PrintBackendService::Poke
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PrintBackendService::EnumeratePrinters_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa6bb8215;  // IPCStableHash for printing::mojom::PrintBackendService::EnumeratePrinters
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PrintBackendService::GetDefaultPrinterName_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xca8127db;  // IPCStableHash for printing::mojom::PrintBackendService::GetDefaultPrinterName
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PrintBackendService::FetchCapabilities_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2a1d7c56;  // IPCStableHash for printing::mojom::PrintBackendService::FetchCapabilities
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PrintBackendService::EstablishPrintingContext_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x80e84ae9;  // IPCStableHash for printing::mojom::PrintBackendService::EstablishPrintingContext
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PrintBackendService::UseDefaultSettings_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb0a1c94d;  // IPCStableHash for printing::mojom::PrintBackendService::UseDefaultSettings
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PrintBackendService::UpdatePrintSettings_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfbe9bb6f;  // IPCStableHash for printing::mojom::PrintBackendService::UpdatePrintSettings
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PrintBackendService::StartPrinting_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa68634ca;  // IPCStableHash for printing::mojom::PrintBackendService::StartPrinting
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PrintBackendService::RenderPrintedDocument_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf02d5112;  // IPCStableHash for printing::mojom::PrintBackendService::RenderPrintedDocument
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PrintBackendService::DocumentDone_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x634f3271;  // IPCStableHash for printing::mojom::PrintBackendService::DocumentDone
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PrintBackendService::Cancel_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9c7a2852;  // IPCStableHash for printing::mojom::PrintBackendService::Cancel
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class PrintBackendService_EnumeratePrinters_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PrintBackendService_EnumeratePrinters_ForwardToCallback(
      PrintBackendService::EnumeratePrintersCallback callback
      ) : callback_(std::move(callback)) {
  }

  PrintBackendService_EnumeratePrinters_ForwardToCallback(const PrintBackendService_EnumeratePrinters_ForwardToCallback&) = delete;
  PrintBackendService_EnumeratePrinters_ForwardToCallback& operator=(const PrintBackendService_EnumeratePrinters_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PrintBackendService::EnumeratePrintersCallback callback_;
};

class PrintBackendService_GetDefaultPrinterName_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PrintBackendService_GetDefaultPrinterName_ForwardToCallback(
      PrintBackendService::GetDefaultPrinterNameCallback callback
      ) : callback_(std::move(callback)) {
  }

  PrintBackendService_GetDefaultPrinterName_ForwardToCallback(const PrintBackendService_GetDefaultPrinterName_ForwardToCallback&) = delete;
  PrintBackendService_GetDefaultPrinterName_ForwardToCallback& operator=(const PrintBackendService_GetDefaultPrinterName_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PrintBackendService::GetDefaultPrinterNameCallback callback_;
};

class PrintBackendService_FetchCapabilities_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PrintBackendService_FetchCapabilities_ForwardToCallback(
      PrintBackendService::FetchCapabilitiesCallback callback
      ) : callback_(std::move(callback)) {
  }

  PrintBackendService_FetchCapabilities_ForwardToCallback(const PrintBackendService_FetchCapabilities_ForwardToCallback&) = delete;
  PrintBackendService_FetchCapabilities_ForwardToCallback& operator=(const PrintBackendService_FetchCapabilities_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PrintBackendService::FetchCapabilitiesCallback callback_;
};

class PrintBackendService_UseDefaultSettings_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PrintBackendService_UseDefaultSettings_ForwardToCallback(
      PrintBackendService::UseDefaultSettingsCallback callback
      ) : callback_(std::move(callback)) {
  }

  PrintBackendService_UseDefaultSettings_ForwardToCallback(const PrintBackendService_UseDefaultSettings_ForwardToCallback&) = delete;
  PrintBackendService_UseDefaultSettings_ForwardToCallback& operator=(const PrintBackendService_UseDefaultSettings_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PrintBackendService::UseDefaultSettingsCallback callback_;
};

class PrintBackendService_UpdatePrintSettings_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PrintBackendService_UpdatePrintSettings_ForwardToCallback(
      PrintBackendService::UpdatePrintSettingsCallback callback
      ) : callback_(std::move(callback)) {
  }

  PrintBackendService_UpdatePrintSettings_ForwardToCallback(const PrintBackendService_UpdatePrintSettings_ForwardToCallback&) = delete;
  PrintBackendService_UpdatePrintSettings_ForwardToCallback& operator=(const PrintBackendService_UpdatePrintSettings_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PrintBackendService::UpdatePrintSettingsCallback callback_;
};

class PrintBackendService_StartPrinting_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PrintBackendService_StartPrinting_ForwardToCallback(
      PrintBackendService::StartPrintingCallback callback
      ) : callback_(std::move(callback)) {
  }

  PrintBackendService_StartPrinting_ForwardToCallback(const PrintBackendService_StartPrinting_ForwardToCallback&) = delete;
  PrintBackendService_StartPrinting_ForwardToCallback& operator=(const PrintBackendService_StartPrinting_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PrintBackendService::StartPrintingCallback callback_;
};

class PrintBackendService_RenderPrintedDocument_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PrintBackendService_RenderPrintedDocument_ForwardToCallback(
      PrintBackendService::RenderPrintedDocumentCallback callback
      ) : callback_(std::move(callback)) {
  }

  PrintBackendService_RenderPrintedDocument_ForwardToCallback(const PrintBackendService_RenderPrintedDocument_ForwardToCallback&) = delete;
  PrintBackendService_RenderPrintedDocument_ForwardToCallback& operator=(const PrintBackendService_RenderPrintedDocument_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PrintBackendService::RenderPrintedDocumentCallback callback_;
};

class PrintBackendService_DocumentDone_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PrintBackendService_DocumentDone_ForwardToCallback(
      PrintBackendService::DocumentDoneCallback callback
      ) : callback_(std::move(callback)) {
  }

  PrintBackendService_DocumentDone_ForwardToCallback(const PrintBackendService_DocumentDone_ForwardToCallback&) = delete;
  PrintBackendService_DocumentDone_ForwardToCallback& operator=(const PrintBackendService_DocumentDone_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PrintBackendService::DocumentDoneCallback callback_;
};

class PrintBackendService_Cancel_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PrintBackendService_Cancel_ForwardToCallback(
      PrintBackendService::CancelCallback callback
      ) : callback_(std::move(callback)) {
  }

  PrintBackendService_Cancel_ForwardToCallback(const PrintBackendService_Cancel_ForwardToCallback&) = delete;
  PrintBackendService_Cancel_ForwardToCallback& operator=(const PrintBackendService_Cancel_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PrintBackendService::CancelCallback callback_;
};

PrintBackendServiceProxy::PrintBackendServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PrintBackendServiceProxy::Init(
    const std::string& in_locale) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send printing::mojom::PrintBackendService::Init", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("locale"), in_locale,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintBackendService::kInit), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintBackendService_Init_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->locale)::BaseType> locale_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_locale,
    locale_fragment);

  params->locale.Set(
      locale_fragment.is_null() ? nullptr : locale_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->locale.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null locale in PrintBackendService.Init request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintBackendService::Name_);
  message.set_method_name("Init");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PrintBackendServiceProxy::Poke(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send printing::mojom::PrintBackendService::Poke");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintBackendService::kPoke), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintBackendService_Poke_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintBackendService::Name_);
  message.set_method_name("Poke");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PrintBackendServiceProxy::EnumeratePrinters(
    EnumeratePrintersCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send printing::mojom::PrintBackendService::EnumeratePrinters");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintBackendService::kEnumeratePrinters), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintBackendService_EnumeratePrinters_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintBackendService::Name_);
  message.set_method_name("EnumeratePrinters");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PrintBackendService_EnumeratePrinters_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PrintBackendServiceProxy::GetDefaultPrinterName(
    GetDefaultPrinterNameCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send printing::mojom::PrintBackendService::GetDefaultPrinterName");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintBackendService::kGetDefaultPrinterName), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintBackendService_GetDefaultPrinterName_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintBackendService::Name_);
  message.set_method_name("GetDefaultPrinterName");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PrintBackendService_GetDefaultPrinterName_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PrintBackendServiceProxy::FetchCapabilities(
    const std::string& in_printer_name, FetchCapabilitiesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send printing::mojom::PrintBackendService::FetchCapabilities", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("printer_name"), in_printer_name,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintBackendService::kFetchCapabilities), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintBackendService_FetchCapabilities_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->printer_name)::BaseType> printer_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_printer_name,
    printer_name_fragment);

  params->printer_name.Set(
      printer_name_fragment.is_null() ? nullptr : printer_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->printer_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null printer_name in PrintBackendService.FetchCapabilities request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintBackendService::Name_);
  message.set_method_name("FetchCapabilities");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PrintBackendService_FetchCapabilities_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PrintBackendServiceProxy::EstablishPrintingContext(
    uint32_t in_context_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send printing::mojom::PrintBackendService::EstablishPrintingContext", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("context_id"), in_context_id,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintBackendService::kEstablishPrintingContext), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintBackendService_EstablishPrintingContext_Params_Data> params(
          message);
  params.Allocate();

  params->context_id = in_context_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintBackendService::Name_);
  message.set_method_name("EstablishPrintingContext");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PrintBackendServiceProxy::UseDefaultSettings(
    uint32_t in_context_id, UseDefaultSettingsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send printing::mojom::PrintBackendService::UseDefaultSettings", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("context_id"), in_context_id,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintBackendService::kUseDefaultSettings), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintBackendService_UseDefaultSettings_Params_Data> params(
          message);
  params.Allocate();

  params->context_id = in_context_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintBackendService::Name_);
  message.set_method_name("UseDefaultSettings");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PrintBackendService_UseDefaultSettings_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PrintBackendServiceProxy::UpdatePrintSettings(
    uint32_t in_context_id, ::base::Value::Dict in_job_settings, UpdatePrintSettingsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send printing::mojom::PrintBackendService::UpdatePrintSettings", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("context_id"), in_context_id,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("job_settings"), in_job_settings,
                        "<value of type ::base::Value::Dict>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintBackendService::kUpdatePrintSettings), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintBackendService_UpdatePrintSettings_Params_Data> params(
          message);
  params.Allocate();

  params->context_id = in_context_id;
  mojo::internal::MessageFragment<
      typename decltype(params->job_settings)::BaseType> job_settings_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::DictionaryValueDataView>(
    in_job_settings,
    job_settings_fragment);

  params->job_settings.Set(
      job_settings_fragment.is_null() ? nullptr : job_settings_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->job_settings.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null job_settings in PrintBackendService.UpdatePrintSettings request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintBackendService::Name_);
  message.set_method_name("UpdatePrintSettings");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PrintBackendService_UpdatePrintSettings_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PrintBackendServiceProxy::StartPrinting(
    uint32_t in_context_id, int32_t in_document_cookie, const ::std::u16string& in_document_name, const std::optional<::printing::PrintSettings>& in_settings, StartPrintingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send printing::mojom::PrintBackendService::StartPrinting", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("context_id"), in_context_id,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("document_cookie"), in_document_cookie,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("document_name"), in_document_name,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("settings"), in_settings,
                        "<value of type const std::optional<::printing::PrintSettings>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintBackendService::kStartPrinting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintBackendService_StartPrinting_Params_Data> params(
          message);
  params.Allocate();

  params->context_id = in_context_id;

  params->document_cookie = in_document_cookie;
  mojo::internal::MessageFragment<
      typename decltype(params->document_name)::BaseType> document_name_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_document_name,
    document_name_fragment);

  params->document_name.Set(
      document_name_fragment.is_null() ? nullptr : document_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->document_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null document_name in PrintBackendService.StartPrinting request");
  mojo::internal::MessageFragment<
      typename decltype(params->settings)::BaseType> settings_fragment(
          params.message());
  
  mojo::internal::Serialize<::printing::mojom::PrintSettingsDataView>(
    in_settings,
    settings_fragment);

  params->settings.Set(
      settings_fragment.is_null() ? nullptr : settings_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintBackendService::Name_);
  message.set_method_name("StartPrinting");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PrintBackendService_StartPrinting_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PrintBackendServiceProxy::RenderPrintedDocument(
    int32_t in_document_cookie, uint32_t in_page_count, ::printing::mojom::MetafileDataType in_data_type, ::base::ReadOnlySharedMemoryRegion in_serialized_doc, RenderPrintedDocumentCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send printing::mojom::PrintBackendService::RenderPrintedDocument", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("document_cookie"), in_document_cookie,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page_count"), in_page_count,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data_type"), in_data_type,
                        "<value of type ::printing::mojom::MetafileDataType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("serialized_doc"), in_serialized_doc,
                        "<value of type ::base::ReadOnlySharedMemoryRegion>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintBackendService::kRenderPrintedDocument), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintBackendService_RenderPrintedDocument_Params_Data> params(
          message);
  params.Allocate();

  params->document_cookie = in_document_cookie;

  params->page_count = in_page_count;

  
  mojo::internal::Serialize<::printing::mojom::MetafileDataType>(
    in_data_type,
    &params->data_type);
  mojo::internal::MessageFragment<
      typename decltype(params->serialized_doc)::BaseType> serialized_doc_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
    in_serialized_doc,
    serialized_doc_fragment);

  params->serialized_doc.Set(
      serialized_doc_fragment.is_null() ? nullptr : serialized_doc_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->serialized_doc.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null serialized_doc in PrintBackendService.RenderPrintedDocument request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintBackendService::Name_);
  message.set_method_name("RenderPrintedDocument");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PrintBackendService_RenderPrintedDocument_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PrintBackendServiceProxy::DocumentDone(
    int32_t in_document_cookie, DocumentDoneCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send printing::mojom::PrintBackendService::DocumentDone", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("document_cookie"), in_document_cookie,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintBackendService::kDocumentDone), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintBackendService_DocumentDone_Params_Data> params(
          message);
  params.Allocate();

  params->document_cookie = in_document_cookie;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintBackendService::Name_);
  message.set_method_name("DocumentDone");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PrintBackendService_DocumentDone_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PrintBackendServiceProxy::Cancel(
    int32_t in_document_cookie, CancelCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send printing::mojom::PrintBackendService::Cancel", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("document_cookie"), in_document_cookie,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintBackendService::kCancel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintBackendService_Cancel_Params_Data> params(
          message);
  params.Allocate();

  params->document_cookie = in_document_cookie;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintBackendService::Name_);
  message.set_method_name("Cancel");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PrintBackendService_Cancel_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class PrintBackendService_EnumeratePrinters_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PrintBackendService::EnumeratePrintersCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PrintBackendService_EnumeratePrinters_ProxyToResponder> proxy(
        new PrintBackendService_EnumeratePrinters_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Transform)
      .Then(base::BindOnce(&PrintBackendService_EnumeratePrinters_ProxyToResponder::Run,
                          std::move(proxy)));
  }

  static PrintBackendService_EnumeratePrinters_ResponseParam_ResultPtr Transform(base::expected<
  std::vector<::printing::PrinterBasicInfo>,
  ::printing::mojom::ResultCode> in) {
    return in.has_value() ? ::printing::mojom::PrintBackendService_EnumeratePrinters_ResponseParam_Result::NewSuccess(std::move(in.value())) :
                            ::printing::mojom::PrintBackendService_EnumeratePrinters_ResponseParam_Result::NewFailure(std::move(in.error()));
  }



  ~PrintBackendService_EnumeratePrinters_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PrintBackendService_EnumeratePrinters_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PrintBackendService::EnumeratePrintersCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      PrintBackendService_EnumeratePrinters_ResponseParam_ResultPtr in_result);
};

bool PrintBackendService_EnumeratePrinters_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PrintBackendService_EnumeratePrinters_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PrintBackendService_EnumeratePrinters_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PrintBackendService.2
  bool success = true;
  PrintBackendService_EnumeratePrinters_ResponseParam_ResultPtr p_result{};
  PrintBackendService_EnumeratePrinters_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PrintBackendService::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    if (p_result->is_success()) {
      std::move(callback_).Run(base::ok(std::move(p_result->get_success())));
    } else {
      std::move(callback_).Run(base::unexpected(std::move(p_result->get_failure())));
    }
  }
  return true;
}

void PrintBackendService_EnumeratePrinters_ProxyToResponder::Run(
    PrintBackendService_EnumeratePrinters_ResponseParam_ResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply printing::mojom::PrintBackendService::EnumeratePrinters", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type PrintBackendService_EnumeratePrinters_ResponseParam_ResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintBackendService::kEnumeratePrinters), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintBackendService_EnumeratePrinters_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::printing::mojom::PrintBackendService_EnumeratePrinters_ResponseParam_ResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintBackendService::Name_);
  message.set_method_name("EnumeratePrinters");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PrintBackendService_GetDefaultPrinterName_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PrintBackendService::GetDefaultPrinterNameCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PrintBackendService_GetDefaultPrinterName_ProxyToResponder> proxy(
        new PrintBackendService_GetDefaultPrinterName_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Transform)
      .Then(base::BindOnce(&PrintBackendService_GetDefaultPrinterName_ProxyToResponder::Run,
                          std::move(proxy)));
  }

  static PrintBackendService_GetDefaultPrinterName_ResponseParam_ResultPtr Transform(base::expected<
  std::string,
  ::printing::mojom::ResultCode> in) {
    return in.has_value() ? ::printing::mojom::PrintBackendService_GetDefaultPrinterName_ResponseParam_Result::NewSuccess(std::move(in.value())) :
                            ::printing::mojom::PrintBackendService_GetDefaultPrinterName_ResponseParam_Result::NewFailure(std::move(in.error()));
  }



  ~PrintBackendService_GetDefaultPrinterName_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PrintBackendService_GetDefaultPrinterName_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PrintBackendService::GetDefaultPrinterNameCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      PrintBackendService_GetDefaultPrinterName_ResponseParam_ResultPtr in_result);
};

bool PrintBackendService_GetDefaultPrinterName_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PrintBackendService_GetDefaultPrinterName_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PrintBackendService_GetDefaultPrinterName_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PrintBackendService.3
  bool success = true;
  PrintBackendService_GetDefaultPrinterName_ResponseParam_ResultPtr p_result{};
  PrintBackendService_GetDefaultPrinterName_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PrintBackendService::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    if (p_result->is_success()) {
      std::move(callback_).Run(base::ok(std::move(p_result->get_success())));
    } else {
      std::move(callback_).Run(base::unexpected(std::move(p_result->get_failure())));
    }
  }
  return true;
}

void PrintBackendService_GetDefaultPrinterName_ProxyToResponder::Run(
    PrintBackendService_GetDefaultPrinterName_ResponseParam_ResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply printing::mojom::PrintBackendService::GetDefaultPrinterName", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type PrintBackendService_GetDefaultPrinterName_ResponseParam_ResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintBackendService::kGetDefaultPrinterName), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintBackendService_GetDefaultPrinterName_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::printing::mojom::PrintBackendService_GetDefaultPrinterName_ResponseParam_ResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintBackendService::Name_);
  message.set_method_name("GetDefaultPrinterName");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PrintBackendService_FetchCapabilities_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PrintBackendService::FetchCapabilitiesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PrintBackendService_FetchCapabilities_ProxyToResponder> proxy(
        new PrintBackendService_FetchCapabilities_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Transform)
      .Then(base::BindOnce(&PrintBackendService_FetchCapabilities_ProxyToResponder::Run,
                          std::move(proxy)));
  }

  static PrintBackendService_FetchCapabilities_ResponseParam_ResultPtr Transform(base::expected<
  PrinterCapsAndInfoPtr,
  ::printing::mojom::ResultCode> in) {
    return in.has_value() ? ::printing::mojom::PrintBackendService_FetchCapabilities_ResponseParam_Result::NewSuccess(std::move(in.value())) :
                            ::printing::mojom::PrintBackendService_FetchCapabilities_ResponseParam_Result::NewFailure(std::move(in.error()));
  }



  ~PrintBackendService_FetchCapabilities_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PrintBackendService_FetchCapabilities_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PrintBackendService::FetchCapabilitiesCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      PrintBackendService_FetchCapabilities_ResponseParam_ResultPtr in_result);
};

bool PrintBackendService_FetchCapabilities_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PrintBackendService_FetchCapabilities_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PrintBackendService_FetchCapabilities_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PrintBackendService.4
  bool success = true;
  PrintBackendService_FetchCapabilities_ResponseParam_ResultPtr p_result{};
  PrintBackendService_FetchCapabilities_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PrintBackendService::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    if (p_result->is_success()) {
      std::move(callback_).Run(base::ok(std::move(p_result->get_success())));
    } else {
      std::move(callback_).Run(base::unexpected(std::move(p_result->get_failure())));
    }
  }
  return true;
}

void PrintBackendService_FetchCapabilities_ProxyToResponder::Run(
    PrintBackendService_FetchCapabilities_ResponseParam_ResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply printing::mojom::PrintBackendService::FetchCapabilities", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type PrintBackendService_FetchCapabilities_ResponseParam_ResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintBackendService::kFetchCapabilities), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintBackendService_FetchCapabilities_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::printing::mojom::PrintBackendService_FetchCapabilities_ResponseParam_ResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintBackendService::Name_);
  message.set_method_name("FetchCapabilities");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PrintBackendService_UseDefaultSettings_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PrintBackendService::UseDefaultSettingsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PrintBackendService_UseDefaultSettings_ProxyToResponder> proxy(
        new PrintBackendService_UseDefaultSettings_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Transform)
      .Then(base::BindOnce(&PrintBackendService_UseDefaultSettings_ProxyToResponder::Run,
                          std::move(proxy)));
  }

  static PrintBackendService_UseDefaultSettings_ResponseParam_ResultPtr Transform(base::expected<
  ::printing::PrintSettings,
  ::printing::mojom::ResultCode> in) {
    return in.has_value() ? ::printing::mojom::PrintBackendService_UseDefaultSettings_ResponseParam_Result::NewSuccess(std::move(in.value())) :
                            ::printing::mojom::PrintBackendService_UseDefaultSettings_ResponseParam_Result::NewFailure(std::move(in.error()));
  }



  ~PrintBackendService_UseDefaultSettings_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PrintBackendService_UseDefaultSettings_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PrintBackendService::UseDefaultSettingsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      PrintBackendService_UseDefaultSettings_ResponseParam_ResultPtr in_result);
};

bool PrintBackendService_UseDefaultSettings_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PrintBackendService_UseDefaultSettings_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PrintBackendService_UseDefaultSettings_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PrintBackendService.6
  bool success = true;
  PrintBackendService_UseDefaultSettings_ResponseParam_ResultPtr p_result{};
  PrintBackendService_UseDefaultSettings_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PrintBackendService::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null()) {
    if (p_result->is_success()) {
      std::move(callback_).Run(base::ok(std::move(p_result->get_success())));
    } else {
      std::move(callback_).Run(base::unexpected(std::move(p_result->get_failure())));
    }
  }
  return true;
}

void PrintBackendService_UseDefaultSettings_ProxyToResponder::Run(
    PrintBackendService_UseDefaultSettings_ResponseParam_ResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply printing::mojom::PrintBackendService::UseDefaultSettings", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type PrintBackendService_UseDefaultSettings_ResponseParam_ResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintBackendService::kUseDefaultSettings), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintBackendService_UseDefaultSettings_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::printing::mojom::PrintBackendService_UseDefaultSettings_ResponseParam_ResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintBackendService::Name_);
  message.set_method_name("UseDefaultSettings");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PrintBackendService_UpdatePrintSettings_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PrintBackendService::UpdatePrintSettingsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PrintBackendService_UpdatePrintSettings_ProxyToResponder> proxy(
        new PrintBackendService_UpdatePrintSettings_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Transform)
      .Then(base::BindOnce(&PrintBackendService_UpdatePrintSettings_ProxyToResponder::Run,
                          std::move(proxy)));
  }

  static PrintBackendService_UpdatePrintSettings_ResponseParam_ResultPtr Transform(base::expected<
  ::printing::PrintSettings,
  ::printing::mojom::ResultCode> in) {
    return in.has_value() ? ::printing::mojom::PrintBackendService_UpdatePrintSettings_ResponseParam_Result::NewSuccess(std::move(in.value())) :
                            ::printing::mojom::PrintBackendService_UpdatePrintSettings_ResponseParam_Result::NewFailure(std::move(in.error()));
  }



  ~PrintBackendService_UpdatePrintSettings_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PrintBackendService_UpdatePrintSettings_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PrintBackendService::UpdatePrintSettingsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      PrintBackendService_UpdatePrintSettings_ResponseParam_ResultPtr in_result);
};

bool PrintBackendService_UpdatePrintSettings_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PrintBackendService_UpdatePrintSettings_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PrintBackendService_UpdatePrintSettings_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PrintBackendService.7
  bool success = true;
  PrintBackendService_UpdatePrintSettings_ResponseParam_ResultPtr p_result{};
  PrintBackendService_UpdatePrintSettings_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PrintBackendService::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null()) {
    if (p_result->is_success()) {
      std::move(callback_).Run(base::ok(std::move(p_result->get_success())));
    } else {
      std::move(callback_).Run(base::unexpected(std::move(p_result->get_failure())));
    }
  }
  return true;
}

void PrintBackendService_UpdatePrintSettings_ProxyToResponder::Run(
    PrintBackendService_UpdatePrintSettings_ResponseParam_ResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply printing::mojom::PrintBackendService::UpdatePrintSettings", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type PrintBackendService_UpdatePrintSettings_ResponseParam_ResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintBackendService::kUpdatePrintSettings), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintBackendService_UpdatePrintSettings_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::printing::mojom::PrintBackendService_UpdatePrintSettings_ResponseParam_ResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintBackendService::Name_);
  message.set_method_name("UpdatePrintSettings");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PrintBackendService_StartPrinting_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PrintBackendService::StartPrintingCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PrintBackendService_StartPrinting_ProxyToResponder> proxy(
        new PrintBackendService_StartPrinting_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PrintBackendService_StartPrinting_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PrintBackendService_StartPrinting_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PrintBackendService_StartPrinting_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PrintBackendService::StartPrintingCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::printing::mojom::ResultCode in_result_code, int32_t in_job_id);
};

bool PrintBackendService_StartPrinting_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PrintBackendService_StartPrinting_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PrintBackendService_StartPrinting_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PrintBackendService.8
  bool success = true;
  ::printing::mojom::ResultCode p_result_code{};
  int32_t p_job_id{};
  PrintBackendService_StartPrinting_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResultCode(&p_result_code))
    success = false;
  if (success)
    p_job_id = input_data_view.job_id();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PrintBackendService::Name_, 8, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result_code), 
std::move(p_job_id));
  }
  return true;
}

void PrintBackendService_StartPrinting_ProxyToResponder::Run(
    ::printing::mojom::ResultCode in_result_code, int32_t in_job_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply printing::mojom::PrintBackendService::StartPrinting", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result_code"), in_result_code,
                        "<value of type ::printing::mojom::ResultCode>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("job_id"), in_job_id,
                        "<value of type int32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintBackendService::kStartPrinting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintBackendService_StartPrinting_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::printing::mojom::ResultCode>(
    in_result_code,
    &params->result_code);

  params->job_id = in_job_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintBackendService::Name_);
  message.set_method_name("StartPrinting");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PrintBackendService_RenderPrintedDocument_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PrintBackendService::RenderPrintedDocumentCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PrintBackendService_RenderPrintedDocument_ProxyToResponder> proxy(
        new PrintBackendService_RenderPrintedDocument_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PrintBackendService_RenderPrintedDocument_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PrintBackendService_RenderPrintedDocument_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PrintBackendService_RenderPrintedDocument_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PrintBackendService::RenderPrintedDocumentCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::printing::mojom::ResultCode in_result_code);
};

bool PrintBackendService_RenderPrintedDocument_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PrintBackendService_RenderPrintedDocument_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PrintBackendService_RenderPrintedDocument_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PrintBackendService.9
  bool success = true;
  ::printing::mojom::ResultCode p_result_code{};
  PrintBackendService_RenderPrintedDocument_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResultCode(&p_result_code))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PrintBackendService::Name_, 9, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result_code));
  }
  return true;
}

void PrintBackendService_RenderPrintedDocument_ProxyToResponder::Run(
    ::printing::mojom::ResultCode in_result_code) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply printing::mojom::PrintBackendService::RenderPrintedDocument", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result_code"), in_result_code,
                        "<value of type ::printing::mojom::ResultCode>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintBackendService::kRenderPrintedDocument), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintBackendService_RenderPrintedDocument_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::printing::mojom::ResultCode>(
    in_result_code,
    &params->result_code);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintBackendService::Name_);
  message.set_method_name("RenderPrintedDocument");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PrintBackendService_DocumentDone_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PrintBackendService::DocumentDoneCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PrintBackendService_DocumentDone_ProxyToResponder> proxy(
        new PrintBackendService_DocumentDone_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PrintBackendService_DocumentDone_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PrintBackendService_DocumentDone_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PrintBackendService_DocumentDone_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PrintBackendService::DocumentDoneCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::printing::mojom::ResultCode in_result_code);
};

bool PrintBackendService_DocumentDone_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PrintBackendService_DocumentDone_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PrintBackendService_DocumentDone_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PrintBackendService.10
  bool success = true;
  ::printing::mojom::ResultCode p_result_code{};
  PrintBackendService_DocumentDone_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResultCode(&p_result_code))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PrintBackendService::Name_, 10, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result_code));
  }
  return true;
}

void PrintBackendService_DocumentDone_ProxyToResponder::Run(
    ::printing::mojom::ResultCode in_result_code) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply printing::mojom::PrintBackendService::DocumentDone", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result_code"), in_result_code,
                        "<value of type ::printing::mojom::ResultCode>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintBackendService::kDocumentDone), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintBackendService_DocumentDone_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::printing::mojom::ResultCode>(
    in_result_code,
    &params->result_code);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintBackendService::Name_);
  message.set_method_name("DocumentDone");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PrintBackendService_Cancel_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PrintBackendService::CancelCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PrintBackendService_Cancel_ProxyToResponder> proxy(
        new PrintBackendService_Cancel_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PrintBackendService_Cancel_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PrintBackendService_Cancel_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PrintBackendService_Cancel_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PrintBackendService::CancelCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool PrintBackendService_Cancel_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PrintBackendService_Cancel_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PrintBackendService_Cancel_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PrintBackendService.11
  bool success = true;
  PrintBackendService_Cancel_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PrintBackendService::Name_, 11, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void PrintBackendService_Cancel_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply printing::mojom::PrintBackendService::Cancel");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintBackendService::kCancel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintBackendService_Cancel_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintBackendService::Name_);
  message.set_method_name("Cancel");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PrintBackendServiceStubDispatch::Accept(
    PrintBackendService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PrintBackendService>(message->header()->name)) {
    case messages::PrintBackendService::kInit: {
      DCHECK(message->is_serialized());
      internal::PrintBackendService_Init_Params_Data* params =
          reinterpret_cast<internal::PrintBackendService_Init_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PrintBackendService.0
      bool success = true;
      std::string p_locale{};
      PrintBackendService_Init_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLocale(&p_locale))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintBackendService::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Init(        
        std::move(p_locale));
      return true;
    }
    case messages::PrintBackendService::kPoke: {
      DCHECK(message->is_serialized());
      internal::PrintBackendService_Poke_Params_Data* params =
          reinterpret_cast<internal::PrintBackendService_Poke_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PrintBackendService.1
      bool success = true;
      PrintBackendService_Poke_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintBackendService::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Poke(        );
      return true;
    }
    case messages::PrintBackendService::kEnumeratePrinters: {
      break;
    }
    case messages::PrintBackendService::kGetDefaultPrinterName: {
      break;
    }
    case messages::PrintBackendService::kFetchCapabilities: {
      break;
    }
    case messages::PrintBackendService::kEstablishPrintingContext: {
      DCHECK(message->is_serialized());
      internal::PrintBackendService_EstablishPrintingContext_Params_Data* params =
          reinterpret_cast<internal::PrintBackendService_EstablishPrintingContext_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PrintBackendService.5
      bool success = true;
      uint32_t p_context_id{};
      PrintBackendService_EstablishPrintingContext_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_context_id = input_data_view.context_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintBackendService::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EstablishPrintingContext(        
        std::move(p_context_id));
      return true;
    }
    case messages::PrintBackendService::kUseDefaultSettings: {
      break;
    }
    case messages::PrintBackendService::kUpdatePrintSettings: {
      break;
    }
    case messages::PrintBackendService::kStartPrinting: {
      break;
    }
    case messages::PrintBackendService::kRenderPrintedDocument: {
      break;
    }
    case messages::PrintBackendService::kDocumentDone: {
      break;
    }
    case messages::PrintBackendService::kCancel: {
      break;
    }
  }
  return false;
}

// static
bool PrintBackendServiceStubDispatch::AcceptWithResponder(
    PrintBackendService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PrintBackendService>(message->header()->name)) {
    case messages::PrintBackendService::kInit: {
      break;
    }
    case messages::PrintBackendService::kPoke: {
      break;
    }
    case messages::PrintBackendService::kEnumeratePrinters: {
      internal::PrintBackendService_EnumeratePrinters_Params_Data* params =
          reinterpret_cast<
              internal::PrintBackendService_EnumeratePrinters_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PrintBackendService.2
      bool success = true;
      PrintBackendService_EnumeratePrinters_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintBackendService::Name_, 2, false);
        return false;
      }
      auto callback =
          PrintBackendService_EnumeratePrinters_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnumeratePrinters(std::move(callback));
      return true;
    }
    case messages::PrintBackendService::kGetDefaultPrinterName: {
      internal::PrintBackendService_GetDefaultPrinterName_Params_Data* params =
          reinterpret_cast<
              internal::PrintBackendService_GetDefaultPrinterName_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PrintBackendService.3
      bool success = true;
      PrintBackendService_GetDefaultPrinterName_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintBackendService::Name_, 3, false);
        return false;
      }
      auto callback =
          PrintBackendService_GetDefaultPrinterName_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDefaultPrinterName(std::move(callback));
      return true;
    }
    case messages::PrintBackendService::kFetchCapabilities: {
      internal::PrintBackendService_FetchCapabilities_Params_Data* params =
          reinterpret_cast<
              internal::PrintBackendService_FetchCapabilities_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PrintBackendService.4
      bool success = true;
      std::string p_printer_name{};
      PrintBackendService_FetchCapabilities_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPrinterName(&p_printer_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintBackendService::Name_, 4, false);
        return false;
      }
      auto callback =
          PrintBackendService_FetchCapabilities_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FetchCapabilities(        
        std::move(p_printer_name), std::move(callback));
      return true;
    }
    case messages::PrintBackendService::kEstablishPrintingContext: {
      break;
    }
    case messages::PrintBackendService::kUseDefaultSettings: {
      internal::PrintBackendService_UseDefaultSettings_Params_Data* params =
          reinterpret_cast<
              internal::PrintBackendService_UseDefaultSettings_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PrintBackendService.6
      bool success = true;
      uint32_t p_context_id{};
      PrintBackendService_UseDefaultSettings_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_context_id = input_data_view.context_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintBackendService::Name_, 6, false);
        return false;
      }
      auto callback =
          PrintBackendService_UseDefaultSettings_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UseDefaultSettings(        
        std::move(p_context_id), std::move(callback));
      return true;
    }
    case messages::PrintBackendService::kUpdatePrintSettings: {
      internal::PrintBackendService_UpdatePrintSettings_Params_Data* params =
          reinterpret_cast<
              internal::PrintBackendService_UpdatePrintSettings_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PrintBackendService.7
      bool success = true;
      uint32_t p_context_id{};
      ::base::Value::Dict p_job_settings{};
      PrintBackendService_UpdatePrintSettings_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_context_id = input_data_view.context_id();
      if (success && !input_data_view.ReadJobSettings(&p_job_settings))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintBackendService::Name_, 7, false);
        return false;
      }
      auto callback =
          PrintBackendService_UpdatePrintSettings_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdatePrintSettings(        
        std::move(p_context_id), 
        std::move(p_job_settings), std::move(callback));
      return true;
    }
    case messages::PrintBackendService::kStartPrinting: {
      internal::PrintBackendService_StartPrinting_Params_Data* params =
          reinterpret_cast<
              internal::PrintBackendService_StartPrinting_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PrintBackendService.8
      bool success = true;
      uint32_t p_context_id{};
      int32_t p_document_cookie{};
      ::std::u16string p_document_name{};
      std::optional<::printing::PrintSettings> p_settings{};
      PrintBackendService_StartPrinting_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_context_id = input_data_view.context_id();
      if (success)
        p_document_cookie = input_data_view.document_cookie();
      if (success && !input_data_view.ReadDocumentName(&p_document_name))
        success = false;
      if (success && !input_data_view.ReadSettings(&p_settings))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintBackendService::Name_, 8, false);
        return false;
      }
      auto callback =
          PrintBackendService_StartPrinting_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartPrinting(        
        std::move(p_context_id), 
        std::move(p_document_cookie), 
        std::move(p_document_name), 
        std::move(p_settings), std::move(callback));
      return true;
    }
    case messages::PrintBackendService::kRenderPrintedDocument: {
      internal::PrintBackendService_RenderPrintedDocument_Params_Data* params =
          reinterpret_cast<
              internal::PrintBackendService_RenderPrintedDocument_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PrintBackendService.9
      bool success = true;
      int32_t p_document_cookie{};
      uint32_t p_page_count{};
      ::printing::mojom::MetafileDataType p_data_type{};
      ::base::ReadOnlySharedMemoryRegion p_serialized_doc{};
      PrintBackendService_RenderPrintedDocument_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_document_cookie = input_data_view.document_cookie();
      if (success)
        p_page_count = input_data_view.page_count();
      if (success && !input_data_view.ReadDataType(&p_data_type))
        success = false;
      if (success && !input_data_view.ReadSerializedDoc(&p_serialized_doc))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintBackendService::Name_, 9, false);
        return false;
      }
      auto callback =
          PrintBackendService_RenderPrintedDocument_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RenderPrintedDocument(        
        std::move(p_document_cookie), 
        std::move(p_page_count), 
        std::move(p_data_type), 
        std::move(p_serialized_doc), std::move(callback));
      return true;
    }
    case messages::PrintBackendService::kDocumentDone: {
      internal::PrintBackendService_DocumentDone_Params_Data* params =
          reinterpret_cast<
              internal::PrintBackendService_DocumentDone_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PrintBackendService.10
      bool success = true;
      int32_t p_document_cookie{};
      PrintBackendService_DocumentDone_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_document_cookie = input_data_view.document_cookie();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintBackendService::Name_, 10, false);
        return false;
      }
      auto callback =
          PrintBackendService_DocumentDone_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DocumentDone(        
        std::move(p_document_cookie), std::move(callback));
      return true;
    }
    case messages::PrintBackendService::kCancel: {
      internal::PrintBackendService_Cancel_Params_Data* params =
          reinterpret_cast<
              internal::PrintBackendService_Cancel_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PrintBackendService.11
      bool success = true;
      int32_t p_document_cookie{};
      PrintBackendService_Cancel_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_document_cookie = input_data_view.document_cookie();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintBackendService::Name_, 11, false);
        return false;
      }
      auto callback =
          PrintBackendService_Cancel_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Cancel(        
        std::move(p_document_cookie), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPrintBackendServiceValidationInfo[] = {
    { &internal::PrintBackendService_Init_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PrintBackendService_Poke_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PrintBackendService_EnumeratePrinters_Params_Data::Validate,
     &internal::PrintBackendService_EnumeratePrinters_ResponseParams_Data::Validate},
    { &internal::PrintBackendService_GetDefaultPrinterName_Params_Data::Validate,
     &internal::PrintBackendService_GetDefaultPrinterName_ResponseParams_Data::Validate},
    { &internal::PrintBackendService_FetchCapabilities_Params_Data::Validate,
     &internal::PrintBackendService_FetchCapabilities_ResponseParams_Data::Validate},
    { &internal::PrintBackendService_EstablishPrintingContext_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PrintBackendService_UseDefaultSettings_Params_Data::Validate,
     &internal::PrintBackendService_UseDefaultSettings_ResponseParams_Data::Validate},
    { &internal::PrintBackendService_UpdatePrintSettings_Params_Data::Validate,
     &internal::PrintBackendService_UpdatePrintSettings_ResponseParams_Data::Validate},
    { &internal::PrintBackendService_StartPrinting_Params_Data::Validate,
     &internal::PrintBackendService_StartPrinting_ResponseParams_Data::Validate},
    { &internal::PrintBackendService_RenderPrintedDocument_Params_Data::Validate,
     &internal::PrintBackendService_RenderPrintedDocument_ResponseParams_Data::Validate},
    { &internal::PrintBackendService_DocumentDone_Params_Data::Validate,
     &internal::PrintBackendService_DocumentDone_ResponseParams_Data::Validate},
    { &internal::PrintBackendService_Cancel_Params_Data::Validate,
     &internal::PrintBackendService_Cancel_ResponseParams_Data::Validate},
};

bool PrintBackendServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::printing::mojom::PrintBackendService::Name_,
    kPrintBackendServiceValidationInfo);
}

bool PrintBackendServiceResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::printing::mojom::PrintBackendService::Name_,
    kPrintBackendServiceValidationInfo);
}


}  // printing::mojom


namespace mojo {


// static
bool StructTraits<::printing::mojom::PrinterCapsAndInfo::DataView, ::printing::mojom::PrinterCapsAndInfoPtr>::Read(
    ::printing::mojom::PrinterCapsAndInfo::DataView input,
    ::printing::mojom::PrinterCapsAndInfoPtr* output) {
  bool success = true;
  ::printing::mojom::PrinterCapsAndInfoPtr result(::printing::mojom::PrinterCapsAndInfo::New());
  
      if (success && !input.ReadPrinterInfo(&result->printer_info))
        success = false;
      if (success && !input.ReadPrinterCaps(&result->printer_caps))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::printing::mojom::PrintBackendService_EnumeratePrinters_ResponseParam_Result::DataView, ::printing::mojom::PrintBackendService_EnumeratePrinters_ResponseParam_ResultPtr>::Read(
    ::printing::mojom::PrintBackendService_EnumeratePrinters_ResponseParam_Result::DataView input,
    ::printing::mojom::PrintBackendService_EnumeratePrinters_ResponseParam_ResultPtr* output) {
  using UnionType = ::printing::mojom::PrintBackendService_EnumeratePrinters_ResponseParam_Result;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kSuccess: {
      std::vector<::printing::PrinterBasicInfo> result_success{};
      if (!input.ReadSuccess(&result_success))
        return false;

      *output = UnionType::NewSuccess(
          std::move(result_success));
      break;
    }
    case Tag::kFailure: {
      ::printing::mojom::ResultCode result_failure;
      if (!input.ReadFailure(&result_failure))
        return false;

      *output = UnionType::NewFailure(result_failure);
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::printing::mojom::PrintBackendService_GetDefaultPrinterName_ResponseParam_Result::DataView, ::printing::mojom::PrintBackendService_GetDefaultPrinterName_ResponseParam_ResultPtr>::Read(
    ::printing::mojom::PrintBackendService_GetDefaultPrinterName_ResponseParam_Result::DataView input,
    ::printing::mojom::PrintBackendService_GetDefaultPrinterName_ResponseParam_ResultPtr* output) {
  using UnionType = ::printing::mojom::PrintBackendService_GetDefaultPrinterName_ResponseParam_Result;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kSuccess: {
      std::string result_success{};
      if (!input.ReadSuccess(&result_success))
        return false;

      *output = UnionType::NewSuccess(
          std::move(result_success));
      break;
    }
    case Tag::kFailure: {
      ::printing::mojom::ResultCode result_failure;
      if (!input.ReadFailure(&result_failure))
        return false;

      *output = UnionType::NewFailure(result_failure);
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::printing::mojom::PrintBackendService_FetchCapabilities_ResponseParam_Result::DataView, ::printing::mojom::PrintBackendService_FetchCapabilities_ResponseParam_ResultPtr>::Read(
    ::printing::mojom::PrintBackendService_FetchCapabilities_ResponseParam_Result::DataView input,
    ::printing::mojom::PrintBackendService_FetchCapabilities_ResponseParam_ResultPtr* output) {
  using UnionType = ::printing::mojom::PrintBackendService_FetchCapabilities_ResponseParam_Result;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kSuccess: {
      ::printing::mojom::PrinterCapsAndInfoPtr result_success{};
      if (!input.ReadSuccess(&result_success))
        return false;

      *output = UnionType::NewSuccess(
          std::move(result_success));
      break;
    }
    case Tag::kFailure: {
      ::printing::mojom::ResultCode result_failure;
      if (!input.ReadFailure(&result_failure))
        return false;

      *output = UnionType::NewFailure(result_failure);
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::printing::mojom::PrintBackendService_UseDefaultSettings_ResponseParam_Result::DataView, ::printing::mojom::PrintBackendService_UseDefaultSettings_ResponseParam_ResultPtr>::Read(
    ::printing::mojom::PrintBackendService_UseDefaultSettings_ResponseParam_Result::DataView input,
    ::printing::mojom::PrintBackendService_UseDefaultSettings_ResponseParam_ResultPtr* output) {
  using UnionType = ::printing::mojom::PrintBackendService_UseDefaultSettings_ResponseParam_Result;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kSuccess: {
      ::printing::PrintSettings result_success{};
      if (!input.ReadSuccess(&result_success))
        return false;

      *output = UnionType::NewSuccess(
          std::move(result_success));
      break;
    }
    case Tag::kFailure: {
      ::printing::mojom::ResultCode result_failure;
      if (!input.ReadFailure(&result_failure))
        return false;

      *output = UnionType::NewFailure(result_failure);
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::printing::mojom::PrintBackendService_UpdatePrintSettings_ResponseParam_Result::DataView, ::printing::mojom::PrintBackendService_UpdatePrintSettings_ResponseParam_ResultPtr>::Read(
    ::printing::mojom::PrintBackendService_UpdatePrintSettings_ResponseParam_Result::DataView input,
    ::printing::mojom::PrintBackendService_UpdatePrintSettings_ResponseParam_ResultPtr* output) {
  using UnionType = ::printing::mojom::PrintBackendService_UpdatePrintSettings_ResponseParam_Result;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kSuccess: {
      ::printing::PrintSettings result_success{};
      if (!input.ReadSuccess(&result_success))
        return false;

      *output = UnionType::NewSuccess(
          std::move(result_success));
      break;
    }
    case Tag::kFailure: {
      ::printing::mojom::ResultCode result_failure;
      if (!input.ReadFailure(&result_failure))
        return false;

      *output = UnionType::NewFailure(result_failure);
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace printing::mojom {


void UnsandboxedPrintBackendHostInterceptorForTesting::BindBackend(::mojo::PendingReceiver<PrintBackendService> service) {
  GetForwardingInterface()->BindBackend(
    std::move(service)
    );
}
UnsandboxedPrintBackendHostAsyncWaiter::UnsandboxedPrintBackendHostAsyncWaiter(
    UnsandboxedPrintBackendHost* proxy) : proxy_(proxy) {}

UnsandboxedPrintBackendHostAsyncWaiter::~UnsandboxedPrintBackendHostAsyncWaiter() = default;





void SandboxedPrintBackendHostInterceptorForTesting::BindBackend(::mojo::PendingReceiver<PrintBackendService> service) {
  GetForwardingInterface()->BindBackend(
    std::move(service)
    );
}
SandboxedPrintBackendHostAsyncWaiter::SandboxedPrintBackendHostAsyncWaiter(
    SandboxedPrintBackendHost* proxy) : proxy_(proxy) {}

SandboxedPrintBackendHostAsyncWaiter::~SandboxedPrintBackendHostAsyncWaiter() = default;





void PrintBackendServiceInterceptorForTesting::Init(const std::string& locale) {
  GetForwardingInterface()->Init(
    std::move(locale)
    );
}
void PrintBackendServiceInterceptorForTesting::Poke() {
  GetForwardingInterface()->Poke();
}
void PrintBackendServiceInterceptorForTesting::EnumeratePrinters(EnumeratePrintersCallback callback) {
  GetForwardingInterface()->EnumeratePrinters(std::move(callback));
}
void PrintBackendServiceInterceptorForTesting::GetDefaultPrinterName(GetDefaultPrinterNameCallback callback) {
  GetForwardingInterface()->GetDefaultPrinterName(std::move(callback));
}
void PrintBackendServiceInterceptorForTesting::FetchCapabilities(const std::string& printer_name, FetchCapabilitiesCallback callback) {
  GetForwardingInterface()->FetchCapabilities(
    std::move(printer_name)
    , std::move(callback));
}
void PrintBackendServiceInterceptorForTesting::EstablishPrintingContext(uint32_t context_id) {
  GetForwardingInterface()->EstablishPrintingContext(
    std::move(context_id)
    );
}
void PrintBackendServiceInterceptorForTesting::UseDefaultSettings(uint32_t context_id, UseDefaultSettingsCallback callback) {
  GetForwardingInterface()->UseDefaultSettings(
    std::move(context_id)
    , std::move(callback));
}
void PrintBackendServiceInterceptorForTesting::UpdatePrintSettings(uint32_t context_id, ::base::Value::Dict job_settings, UpdatePrintSettingsCallback callback) {
  GetForwardingInterface()->UpdatePrintSettings(
    std::move(context_id)
    , 
    std::move(job_settings)
    , std::move(callback));
}
void PrintBackendServiceInterceptorForTesting::StartPrinting(uint32_t context_id, int32_t document_cookie, const ::std::u16string& document_name, const std::optional<::printing::PrintSettings>& settings, StartPrintingCallback callback) {
  GetForwardingInterface()->StartPrinting(
    std::move(context_id)
    , 
    std::move(document_cookie)
    , 
    std::move(document_name)
    , 
    std::move(settings)
    , std::move(callback));
}
void PrintBackendServiceInterceptorForTesting::RenderPrintedDocument(int32_t document_cookie, uint32_t page_count, ::printing::mojom::MetafileDataType data_type, ::base::ReadOnlySharedMemoryRegion serialized_doc, RenderPrintedDocumentCallback callback) {
  GetForwardingInterface()->RenderPrintedDocument(
    std::move(document_cookie)
    , 
    std::move(page_count)
    , 
    std::move(data_type)
    , 
    std::move(serialized_doc)
    , std::move(callback));
}
void PrintBackendServiceInterceptorForTesting::DocumentDone(int32_t document_cookie, DocumentDoneCallback callback) {
  GetForwardingInterface()->DocumentDone(
    std::move(document_cookie)
    , std::move(callback));
}
void PrintBackendServiceInterceptorForTesting::Cancel(int32_t document_cookie, CancelCallback callback) {
  GetForwardingInterface()->Cancel(
    std::move(document_cookie)
    , std::move(callback));
}
PrintBackendServiceAsyncWaiter::PrintBackendServiceAsyncWaiter(
    PrintBackendService* proxy) : proxy_(proxy) {}

PrintBackendServiceAsyncWaiter::~PrintBackendServiceAsyncWaiter() = default;


void PrintBackendServiceAsyncWaiter::StartPrinting(
    uint32_t context_id, int32_t document_cookie, const ::std::u16string& document_name, const std::optional<::printing::PrintSettings>& settings, ::printing::mojom::ResultCode* out_result_code, int32_t* out_job_id) {
  base::RunLoop loop;
  proxy_->StartPrinting(
      std::move(context_id),
      std::move(document_cookie),
      std::move(document_name),
      std::move(settings),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::printing::mojom::ResultCode* out_result_code
,
             int32_t* out_job_id
,
             ::printing::mojom::ResultCode result_code,
             int32_t job_id) {*out_result_code = std::move(result_code);*out_job_id = std::move(job_id);
            loop->Quit();
          },
          &loop,
          out_result_code,
          out_job_id));
  loop.Run();
}



void PrintBackendServiceAsyncWaiter::RenderPrintedDocument(
    int32_t document_cookie, uint32_t page_count, ::printing::mojom::MetafileDataType data_type, ::base::ReadOnlySharedMemoryRegion serialized_doc, ::printing::mojom::ResultCode* out_result_code) {
  base::RunLoop loop;
  proxy_->RenderPrintedDocument(
      std::move(document_cookie),
      std::move(page_count),
      std::move(data_type),
      std::move(serialized_doc),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::printing::mojom::ResultCode* out_result_code
,
             ::printing::mojom::ResultCode result_code) {*out_result_code = std::move(result_code);
            loop->Quit();
          },
          &loop,
          out_result_code));
  loop.Run();
}

::printing::mojom::ResultCode PrintBackendServiceAsyncWaiter::RenderPrintedDocument(
    int32_t document_cookie, uint32_t page_count, ::printing::mojom::MetafileDataType data_type, ::base::ReadOnlySharedMemoryRegion serialized_doc) {
  ::printing::mojom::ResultCode async_wait_result;
  RenderPrintedDocument(std::move(document_cookie),std::move(page_count),std::move(data_type),std::move(serialized_doc),&async_wait_result);
  return async_wait_result;
}

void PrintBackendServiceAsyncWaiter::DocumentDone(
    int32_t document_cookie, ::printing::mojom::ResultCode* out_result_code) {
  base::RunLoop loop;
  proxy_->DocumentDone(
      std::move(document_cookie),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::printing::mojom::ResultCode* out_result_code
,
             ::printing::mojom::ResultCode result_code) {*out_result_code = std::move(result_code);
            loop->Quit();
          },
          &loop,
          out_result_code));
  loop.Run();
}

::printing::mojom::ResultCode PrintBackendServiceAsyncWaiter::DocumentDone(
    int32_t document_cookie) {
  ::printing::mojom::ResultCode async_wait_result;
  DocumentDone(std::move(document_cookie),&async_wait_result);
  return async_wait_result;
}

void PrintBackendServiceAsyncWaiter::Cancel(
    int32_t document_cookie) {
  base::RunLoop loop;
  proxy_->Cancel(
      std::move(document_cookie),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}








}  // printing::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif