// chrome/services/printing/public/mojom/pdf_to_pwg_raster_converter.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_SERVICES_PRINTING_PUBLIC_MOJOM_PDF_TO_PWG_RASTER_CONVERTER_MOJOM_H_
#define CHROME_SERVICES_PRINTING_PUBLIC_MOJOM_PDF_TO_PWG_RASTER_CONVERTER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/services/printing/public/mojom/pdf_to_pwg_raster_converter.mojom-features.h"  // IWYU pragma: export
#include "chrome/services/printing/public/mojom/pdf_to_pwg_raster_converter.mojom-shared.h"  // IWYU pragma: export
#include "chrome/services/printing/public/mojom/pdf_to_pwg_raster_converter.mojom-forward.h"  // IWYU pragma: export
#include "chrome/services/printing/public/mojom/pdf_render_settings.mojom.h"
#include "mojo/public/mojom/base/shared_memory.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "chrome/services/printing/public/mojom/pdf_to_pwg_raster_converter_mojom_traits.h"




namespace printing::mojom {

class PdfToPwgRasterConverterProxy;

template <typename ImplRefTraits>
class PdfToPwgRasterConverterStub;

class PdfToPwgRasterConverterRequestValidator;
class PdfToPwgRasterConverterResponseValidator;


class PdfToPwgRasterConverter
    : public PdfToPwgRasterConverterInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "printing.mojom.PdfToPwgRasterConverter";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PdfToPwgRasterConverterInterfaceBase;
  using Proxy_ = PdfToPwgRasterConverterProxy;

  template <typename ImplRefTraits>
  using Stub_ = PdfToPwgRasterConverterStub<ImplRefTraits>;

  using RequestValidator_ = PdfToPwgRasterConverterRequestValidator;
  using ResponseValidator_ = PdfToPwgRasterConverterResponseValidator;
  enum MethodMinVersions : uint32_t {
    kConvertMinVersion = 0,
    kSetUseSkiaRendererPolicyMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Convert_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetUseSkiaRendererPolicy_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PdfToPwgRasterConverter() = default;

  using ConvertCallback = base::OnceCallback<void(::base::ReadOnlySharedMemoryRegion, uint32_t)>;
  using ConvertMojoCallback = base::OnceCallback<void(::base::ReadOnlySharedMemoryRegion, uint32_t)>;

  virtual void Convert(::base::ReadOnlySharedMemoryRegion pdf_region, const ::printing::PdfRenderSettings& pdf_settings, const ::printing::PwgRasterSettings& pwg_raster_settings, ConvertCallback callback) = 0;

  virtual void SetUseSkiaRendererPolicy(bool use_skia) = 0;
};



class  PdfToPwgRasterConverterProxy
    : public PdfToPwgRasterConverter {
 public:
  using InterfaceType = PdfToPwgRasterConverter;

  explicit PdfToPwgRasterConverterProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Convert(::base::ReadOnlySharedMemoryRegion pdf_region, const ::printing::PdfRenderSettings& pdf_settings, const ::printing::PwgRasterSettings& pwg_raster_settings, ConvertCallback callback) final;
  
  void SetUseSkiaRendererPolicy(bool use_skia) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  PdfToPwgRasterConverterStubDispatch {
 public:
  static bool Accept(PdfToPwgRasterConverter* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PdfToPwgRasterConverter* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PdfToPwgRasterConverter>>
class PdfToPwgRasterConverterStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PdfToPwgRasterConverterStub() = default;
  ~PdfToPwgRasterConverterStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PdfToPwgRasterConverterStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PdfToPwgRasterConverterStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PdfToPwgRasterConverterRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PdfToPwgRasterConverterResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class  PwgRasterSettings {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PwgRasterSettings, T>::value>;
  using DataView = PwgRasterSettingsDataView;
  using Data_ = internal::PwgRasterSettings_Data;
  using TransformType = PwgRasterSettings_TransformType;
  using DuplexMode = PwgRasterSettings_DuplexMode;

  template <typename... Args>
  static PwgRasterSettingsPtr New(Args&&... args) {
    return PwgRasterSettingsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PwgRasterSettingsPtr From(const U& u) {
    return mojo::TypeConverter<PwgRasterSettingsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PwgRasterSettings>::Convert(*this);
  }


  PwgRasterSettings();

  PwgRasterSettings(
      PwgRasterSettings::DuplexMode duplex_mode,
      ::printing::PwgRasterTransformType odd_page_transform,
      bool rotate_all_pages,
      bool reverse_page_order,
      bool use_color);


  ~PwgRasterSettings();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PwgRasterSettingsPtr>
  PwgRasterSettingsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PwgRasterSettings::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PwgRasterSettings::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PwgRasterSettings::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PwgRasterSettings::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PwgRasterSettings::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PwgRasterSettings::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PwgRasterSettings_UnserializedMessageContext<
            UserType, PwgRasterSettings::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PwgRasterSettings::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PwgRasterSettings::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PwgRasterSettings_UnserializedMessageContext<
            UserType, PwgRasterSettings::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PwgRasterSettings::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  PwgRasterSettings::DuplexMode duplex_mode;
  
  ::printing::PwgRasterTransformType odd_page_transform;
  
  bool rotate_all_pages;
  
  bool reverse_page_order;
  
  bool use_color;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PwgRasterSettings::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PwgRasterSettings::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PwgRasterSettings::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PwgRasterSettings::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
PwgRasterSettingsPtr PwgRasterSettings::Clone() const {
  return New(
      mojo::Clone(duplex_mode),
      mojo::Clone(odd_page_transform),
      mojo::Clone(rotate_all_pages),
      mojo::Clone(reverse_page_order),
      mojo::Clone(use_color)
  );
}

template <typename T, PwgRasterSettings::EnableIfSame<T>*>
bool PwgRasterSettings::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->duplex_mode, other_struct.duplex_mode))
    return false;
  if (!mojo::Equals(this->odd_page_transform, other_struct.odd_page_transform))
    return false;
  if (!mojo::Equals(this->rotate_all_pages, other_struct.rotate_all_pages))
    return false;
  if (!mojo::Equals(this->reverse_page_order, other_struct.reverse_page_order))
    return false;
  if (!mojo::Equals(this->use_color, other_struct.use_color))
    return false;
  return true;
}

template <typename T, PwgRasterSettings::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.duplex_mode < rhs.duplex_mode)
    return true;
  if (rhs.duplex_mode < lhs.duplex_mode)
    return false;
  if (lhs.odd_page_transform < rhs.odd_page_transform)
    return true;
  if (rhs.odd_page_transform < lhs.odd_page_transform)
    return false;
  if (lhs.rotate_all_pages < rhs.rotate_all_pages)
    return true;
  if (rhs.rotate_all_pages < lhs.rotate_all_pages)
    return false;
  if (lhs.reverse_page_order < rhs.reverse_page_order)
    return true;
  if (rhs.reverse_page_order < lhs.reverse_page_order)
    return false;
  if (lhs.use_color < rhs.use_color)
    return true;
  if (rhs.use_color < lhs.use_color)
    return false;
  return false;
}


}  // printing::mojom

namespace mojo {


template <>
struct  StructTraits<::printing::mojom::PwgRasterSettings::DataView,
                                         ::printing::mojom::PwgRasterSettingsPtr> {
  static bool IsNull(const ::printing::mojom::PwgRasterSettingsPtr& input) { return !input; }
  static void SetToNull(::printing::mojom::PwgRasterSettingsPtr* output) { output->reset(); }

  static decltype(::printing::mojom::PwgRasterSettings::duplex_mode) duplex_mode(
      const ::printing::mojom::PwgRasterSettingsPtr& input) {
    return input->duplex_mode;
  }

  static decltype(::printing::mojom::PwgRasterSettings::odd_page_transform) odd_page_transform(
      const ::printing::mojom::PwgRasterSettingsPtr& input) {
    return input->odd_page_transform;
  }

  static decltype(::printing::mojom::PwgRasterSettings::rotate_all_pages) rotate_all_pages(
      const ::printing::mojom::PwgRasterSettingsPtr& input) {
    return input->rotate_all_pages;
  }

  static decltype(::printing::mojom::PwgRasterSettings::reverse_page_order) reverse_page_order(
      const ::printing::mojom::PwgRasterSettingsPtr& input) {
    return input->reverse_page_order;
  }

  static decltype(::printing::mojom::PwgRasterSettings::use_color) use_color(
      const ::printing::mojom::PwgRasterSettingsPtr& input) {
    return input->use_color;
  }

  static bool Read(::printing::mojom::PwgRasterSettings::DataView input, ::printing::mojom::PwgRasterSettingsPtr* output);
};

}  // namespace mojo

#endif  // CHROME_SERVICES_PRINTING_PUBLIC_MOJOM_PDF_TO_PWG_RASTER_CONVERTER_MOJOM_H_