// chrome/services/media_gallery_util/public/mojom/media_parser.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_SERVICES_MEDIA_GALLERY_UTIL_PUBLIC_MOJOM_MEDIA_PARSER_MOJOM_H_
#define CHROME_SERVICES_MEDIA_GALLERY_UTIL_PUBLIC_MOJOM_MEDIA_PARSER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/services/media_gallery_util/public/mojom/media_parser.mojom-features.h"  // IWYU pragma: export
#include "chrome/services/media_gallery_util/public/mojom/media_parser.mojom-shared.h"  // IWYU pragma: export
#include "chrome/services/media_gallery_util/public/mojom/media_parser.mojom-forward.h"  // IWYU pragma: export
#include "media/mojo/mojom/media_types.mojom-forward.h"
#include "mojo/public/mojom/base/file.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "mojo/public/mojom/base/values.mojom.h"
#include "sandbox/policy/mojom/sandbox.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "chrome/services/media_gallery_util/public/mojom/media_parser_mojom_traits.h"




namespace chrome::mojom {

class MediaParserProxy;

template <typename ImplRefTraits>
class MediaParserStub;

class MediaParserRequestValidator;
class MediaParserResponseValidator;


class MediaParser
    : public MediaParserInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "chrome.mojom.MediaParser";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = MediaParserInterfaceBase;
  using Proxy_ = MediaParserProxy;

  template <typename ImplRefTraits>
  using Stub_ = MediaParserStub<ImplRefTraits>;

  using RequestValidator_ = MediaParserRequestValidator;
  using ResponseValidator_ = MediaParserResponseValidator;
  enum MethodMinVersions : uint32_t {
    kParseMediaMetadataMinVersion = 0,
    kCheckMediaFileMinVersion = 0,
    kGetCpuInfoMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ParseMediaMetadata_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CheckMediaFile_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetCpuInfo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~MediaParser() = default;

  using ParseMediaMetadataCallback = base::OnceCallback<void(bool, MediaMetadataPtr, const std::vector<::metadata::AttachedImage>&)>;
  using ParseMediaMetadataMojoCallback = base::OnceCallback<void(bool, MediaMetadataPtr, const std::vector<::metadata::AttachedImage>&)>;

  virtual void ParseMediaMetadata(const std::string& mime_type, int64_t total_size, bool get_attached_images, ::mojo::PendingRemote<MediaDataSource> media_data_source, ParseMediaMetadataCallback callback) = 0;

  using CheckMediaFileCallback = base::OnceCallback<void(bool)>;
  using CheckMediaFileMojoCallback = base::OnceCallback<void(bool)>;

  virtual void CheckMediaFile(::base::TimeDelta decode_time, ::base::File file, CheckMediaFileCallback callback) = 0;

  using GetCpuInfoCallback = base::OnceCallback<void(int64_t, int64_t)>;
  using GetCpuInfoMojoCallback = base::OnceCallback<void(int64_t, int64_t)>;

  virtual void GetCpuInfo(GetCpuInfoCallback callback) = 0;
};

class MediaParserFactoryProxy;

template <typename ImplRefTraits>
class MediaParserFactoryStub;

class MediaParserFactoryRequestValidator;
class MediaParserFactoryResponseValidator;


class MediaParserFactory
    : public MediaParserFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "chrome.mojom.MediaParserFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr auto kServiceSandbox = sandbox::mojom::Sandbox::kService;
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = MediaParserFactoryInterfaceBase;
  using Proxy_ = MediaParserFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = MediaParserFactoryStub<ImplRefTraits>;

  using RequestValidator_ = MediaParserFactoryRequestValidator;
  using ResponseValidator_ = MediaParserFactoryResponseValidator;
  enum MethodMinVersions : uint32_t {
    kCreateMediaParserMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateMediaParser_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~MediaParserFactory() = default;

  using CreateMediaParserCallback = base::OnceCallback<void(::mojo::PendingRemote<MediaParser>)>;
  using CreateMediaParserMojoCallback = base::OnceCallback<void(::mojo::PendingRemote<MediaParser>)>;

  virtual void CreateMediaParser(int64_t libyuv_cpu_flags, int64_t libavutil_cpu_flags, CreateMediaParserCallback callback) = 0;
};

class MediaDataSourceProxy;

template <typename ImplRefTraits>
class MediaDataSourceStub;

class MediaDataSourceRequestValidator;
class MediaDataSourceResponseValidator;


class MediaDataSource
    : public MediaDataSourceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "chrome.mojom.MediaDataSource";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = MediaDataSourceInterfaceBase;
  using Proxy_ = MediaDataSourceProxy;

  template <typename ImplRefTraits>
  using Stub_ = MediaDataSourceStub<ImplRefTraits>;

  using RequestValidator_ = MediaDataSourceRequestValidator;
  using ResponseValidator_ = MediaDataSourceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kReadMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Read_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~MediaDataSource() = default;

  using ReadCallback = base::OnceCallback<void(const std::vector<uint8_t>&)>;
  using ReadMojoCallback = base::OnceCallback<void(const std::vector<uint8_t>&)>;

  virtual void Read(int64_t position, int64_t length, ReadCallback callback) = 0;
};



class  MediaParserProxy
    : public MediaParser {
 public:
  using InterfaceType = MediaParser;

  explicit MediaParserProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ParseMediaMetadata(const std::string& mime_type, int64_t total_size, bool get_attached_images, ::mojo::PendingRemote<MediaDataSource> media_data_source, ParseMediaMetadataCallback callback) final;
  
  void CheckMediaFile(::base::TimeDelta decode_time, ::base::File file, CheckMediaFileCallback callback) final;
  
  void GetCpuInfo(GetCpuInfoCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  MediaParserFactoryProxy
    : public MediaParserFactory {
 public:
  using InterfaceType = MediaParserFactory;

  explicit MediaParserFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateMediaParser(int64_t libyuv_cpu_flags, int64_t libavutil_cpu_flags, CreateMediaParserCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  MediaDataSourceProxy
    : public MediaDataSource {
 public:
  using InterfaceType = MediaDataSource;

  explicit MediaDataSourceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Read(int64_t position, int64_t length, ReadCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  MediaParserStubDispatch {
 public:
  static bool Accept(MediaParser* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      MediaParser* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<MediaParser>>
class MediaParserStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  MediaParserStub() = default;
  ~MediaParserStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaParserStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaParserStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  MediaParserFactoryStubDispatch {
 public:
  static bool Accept(MediaParserFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      MediaParserFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<MediaParserFactory>>
class MediaParserFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  MediaParserFactoryStub() = default;
  ~MediaParserFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaParserFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaParserFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  MediaDataSourceStubDispatch {
 public:
  static bool Accept(MediaDataSource* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      MediaDataSource* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<MediaDataSource>>
class MediaDataSourceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  MediaDataSourceStub() = default;
  ~MediaDataSourceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaDataSourceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaDataSourceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  MediaParserRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  MediaParserFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  MediaDataSourceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  MediaParserResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  MediaParserFactoryResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  MediaDataSourceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};










class  MediaStreamInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<MediaStreamInfo, T>::value>;
  using DataView = MediaStreamInfoDataView;
  using Data_ = internal::MediaStreamInfo_Data;

  template <typename... Args>
  static MediaStreamInfoPtr New(Args&&... args) {
    return MediaStreamInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static MediaStreamInfoPtr From(const U& u) {
    return mojo::TypeConverter<MediaStreamInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MediaStreamInfo>::Convert(*this);
  }


  MediaStreamInfo();

  MediaStreamInfo(
      const std::string& type,
      ::base::Value::Dict additional_properties);

MediaStreamInfo(const MediaStreamInfo&) = delete;
MediaStreamInfo& operator=(const MediaStreamInfo&) = delete;

  ~MediaStreamInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = MediaStreamInfoPtr>
  MediaStreamInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, MediaStreamInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, MediaStreamInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, MediaStreamInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MediaStreamInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MediaStreamInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MediaStreamInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::MediaStreamInfo_UnserializedMessageContext<
            UserType, MediaStreamInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<MediaStreamInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return MediaStreamInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::MediaStreamInfo_UnserializedMessageContext<
            UserType, MediaStreamInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<MediaStreamInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string type;
  
  ::base::Value::Dict additional_properties;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, MediaStreamInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, MediaStreamInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, MediaStreamInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, MediaStreamInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  MediaMetadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<MediaMetadata, T>::value>;
  using DataView = MediaMetadataDataView;
  using Data_ = internal::MediaMetadata_Data;

  template <typename... Args>
  static MediaMetadataPtr New(Args&&... args) {
    return MediaMetadataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static MediaMetadataPtr From(const U& u) {
    return mojo::TypeConverter<MediaMetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MediaMetadata>::Convert(*this);
  }


  MediaMetadata();

  MediaMetadata(
      const std::string& mime_type,
      int32_t height,
      int32_t width,
      double duration,
      int32_t rotation,
      const std::string& album,
      const std::string& artist,
      const std::string& comment,
      const std::string& copyright,
      int32_t disc,
      const std::string& genre,
      const std::string& language,
      const std::string& title,
      int32_t track,
      std::vector<MediaStreamInfoPtr> raw_tags);

MediaMetadata(const MediaMetadata&) = delete;
MediaMetadata& operator=(const MediaMetadata&) = delete;

  ~MediaMetadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = MediaMetadataPtr>
  MediaMetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, MediaMetadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, MediaMetadata::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, MediaMetadata::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MediaMetadata::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MediaMetadata::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MediaMetadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::MediaMetadata_UnserializedMessageContext<
            UserType, MediaMetadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<MediaMetadata::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return MediaMetadata::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::MediaMetadata_UnserializedMessageContext<
            UserType, MediaMetadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<MediaMetadata::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string mime_type;
  
  int32_t height;
  
  int32_t width;
  
  double duration;
  
  int32_t rotation;
  
  std::string album;
  
  std::string artist;
  
  std::string comment;
  
  std::string copyright;
  
  int32_t disc;
  
  std::string genre;
  
  std::string language;
  
  std::string title;
  
  int32_t track;
  
  std::vector<MediaStreamInfoPtr> raw_tags;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, MediaMetadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, MediaMetadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, MediaMetadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, MediaMetadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  AttachedImage {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AttachedImage, T>::value>;
  using DataView = AttachedImageDataView;
  using Data_ = internal::AttachedImage_Data;

  template <typename... Args>
  static AttachedImagePtr New(Args&&... args) {
    return AttachedImagePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AttachedImagePtr From(const U& u) {
    return mojo::TypeConverter<AttachedImagePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AttachedImage>::Convert(*this);
  }


  AttachedImage();

  AttachedImage(
      const std::string& type,
      std::vector<uint8_t> data);


  ~AttachedImage();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AttachedImagePtr>
  AttachedImagePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AttachedImage::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AttachedImage::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AttachedImage::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AttachedImage::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AttachedImage::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AttachedImage::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AttachedImage_UnserializedMessageContext<
            UserType, AttachedImage::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AttachedImage::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AttachedImage::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AttachedImage_UnserializedMessageContext<
            UserType, AttachedImage::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AttachedImage::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string type;
  
  std::vector<uint8_t> data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AttachedImage::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AttachedImage::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AttachedImage::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AttachedImage::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
MediaStreamInfoPtr MediaStreamInfo::Clone() const {
  return New(
      mojo::Clone(type),
      mojo::Clone(additional_properties)
  );
}

template <typename T, MediaStreamInfo::EnableIfSame<T>*>
bool MediaStreamInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->additional_properties, other_struct.additional_properties))
    return false;
  return true;
}

template <typename T, MediaStreamInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.additional_properties < rhs.additional_properties)
    return true;
  if (rhs.additional_properties < lhs.additional_properties)
    return false;
  return false;
}
template <typename StructPtrType>
MediaMetadataPtr MediaMetadata::Clone() const {
  return New(
      mojo::Clone(mime_type),
      mojo::Clone(height),
      mojo::Clone(width),
      mojo::Clone(duration),
      mojo::Clone(rotation),
      mojo::Clone(album),
      mojo::Clone(artist),
      mojo::Clone(comment),
      mojo::Clone(copyright),
      mojo::Clone(disc),
      mojo::Clone(genre),
      mojo::Clone(language),
      mojo::Clone(title),
      mojo::Clone(track),
      mojo::Clone(raw_tags)
  );
}

template <typename T, MediaMetadata::EnableIfSame<T>*>
bool MediaMetadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->mime_type, other_struct.mime_type))
    return false;
  if (!mojo::Equals(this->height, other_struct.height))
    return false;
  if (!mojo::Equals(this->width, other_struct.width))
    return false;
  if (!mojo::Equals(this->duration, other_struct.duration))
    return false;
  if (!mojo::Equals(this->rotation, other_struct.rotation))
    return false;
  if (!mojo::Equals(this->album, other_struct.album))
    return false;
  if (!mojo::Equals(this->artist, other_struct.artist))
    return false;
  if (!mojo::Equals(this->comment, other_struct.comment))
    return false;
  if (!mojo::Equals(this->copyright, other_struct.copyright))
    return false;
  if (!mojo::Equals(this->disc, other_struct.disc))
    return false;
  if (!mojo::Equals(this->genre, other_struct.genre))
    return false;
  if (!mojo::Equals(this->language, other_struct.language))
    return false;
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->track, other_struct.track))
    return false;
  if (!mojo::Equals(this->raw_tags, other_struct.raw_tags))
    return false;
  return true;
}

template <typename T, MediaMetadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.mime_type < rhs.mime_type)
    return true;
  if (rhs.mime_type < lhs.mime_type)
    return false;
  if (lhs.height < rhs.height)
    return true;
  if (rhs.height < lhs.height)
    return false;
  if (lhs.width < rhs.width)
    return true;
  if (rhs.width < lhs.width)
    return false;
  if (lhs.duration < rhs.duration)
    return true;
  if (rhs.duration < lhs.duration)
    return false;
  if (lhs.rotation < rhs.rotation)
    return true;
  if (rhs.rotation < lhs.rotation)
    return false;
  if (lhs.album < rhs.album)
    return true;
  if (rhs.album < lhs.album)
    return false;
  if (lhs.artist < rhs.artist)
    return true;
  if (rhs.artist < lhs.artist)
    return false;
  if (lhs.comment < rhs.comment)
    return true;
  if (rhs.comment < lhs.comment)
    return false;
  if (lhs.copyright < rhs.copyright)
    return true;
  if (rhs.copyright < lhs.copyright)
    return false;
  if (lhs.disc < rhs.disc)
    return true;
  if (rhs.disc < lhs.disc)
    return false;
  if (lhs.genre < rhs.genre)
    return true;
  if (rhs.genre < lhs.genre)
    return false;
  if (lhs.language < rhs.language)
    return true;
  if (rhs.language < lhs.language)
    return false;
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  if (lhs.track < rhs.track)
    return true;
  if (rhs.track < lhs.track)
    return false;
  if (lhs.raw_tags < rhs.raw_tags)
    return true;
  if (rhs.raw_tags < lhs.raw_tags)
    return false;
  return false;
}
template <typename StructPtrType>
AttachedImagePtr AttachedImage::Clone() const {
  return New(
      mojo::Clone(type),
      mojo::Clone(data)
  );
}

template <typename T, AttachedImage::EnableIfSame<T>*>
bool AttachedImage::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->data, other_struct.data))
    return false;
  return true;
}

template <typename T, AttachedImage::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.data < rhs.data)
    return true;
  if (rhs.data < lhs.data)
    return false;
  return false;
}


}  // chrome::mojom

namespace mojo {


template <>
struct  StructTraits<::chrome::mojom::MediaStreamInfo::DataView,
                                         ::chrome::mojom::MediaStreamInfoPtr> {
  static bool IsNull(const ::chrome::mojom::MediaStreamInfoPtr& input) { return !input; }
  static void SetToNull(::chrome::mojom::MediaStreamInfoPtr* output) { output->reset(); }

  static const decltype(::chrome::mojom::MediaStreamInfo::type)& type(
      const ::chrome::mojom::MediaStreamInfoPtr& input) {
    return input->type;
  }

  static const decltype(::chrome::mojom::MediaStreamInfo::additional_properties)& additional_properties(
      const ::chrome::mojom::MediaStreamInfoPtr& input) {
    return input->additional_properties;
  }

  static bool Read(::chrome::mojom::MediaStreamInfo::DataView input, ::chrome::mojom::MediaStreamInfoPtr* output);
};


template <>
struct  StructTraits<::chrome::mojom::MediaMetadata::DataView,
                                         ::chrome::mojom::MediaMetadataPtr> {
  static bool IsNull(const ::chrome::mojom::MediaMetadataPtr& input) { return !input; }
  static void SetToNull(::chrome::mojom::MediaMetadataPtr* output) { output->reset(); }

  static const decltype(::chrome::mojom::MediaMetadata::mime_type)& mime_type(
      const ::chrome::mojom::MediaMetadataPtr& input) {
    return input->mime_type;
  }

  static decltype(::chrome::mojom::MediaMetadata::height) height(
      const ::chrome::mojom::MediaMetadataPtr& input) {
    return input->height;
  }

  static decltype(::chrome::mojom::MediaMetadata::width) width(
      const ::chrome::mojom::MediaMetadataPtr& input) {
    return input->width;
  }

  static decltype(::chrome::mojom::MediaMetadata::duration) duration(
      const ::chrome::mojom::MediaMetadataPtr& input) {
    return input->duration;
  }

  static decltype(::chrome::mojom::MediaMetadata::rotation) rotation(
      const ::chrome::mojom::MediaMetadataPtr& input) {
    return input->rotation;
  }

  static const decltype(::chrome::mojom::MediaMetadata::album)& album(
      const ::chrome::mojom::MediaMetadataPtr& input) {
    return input->album;
  }

  static const decltype(::chrome::mojom::MediaMetadata::artist)& artist(
      const ::chrome::mojom::MediaMetadataPtr& input) {
    return input->artist;
  }

  static const decltype(::chrome::mojom::MediaMetadata::comment)& comment(
      const ::chrome::mojom::MediaMetadataPtr& input) {
    return input->comment;
  }

  static const decltype(::chrome::mojom::MediaMetadata::copyright)& copyright(
      const ::chrome::mojom::MediaMetadataPtr& input) {
    return input->copyright;
  }

  static decltype(::chrome::mojom::MediaMetadata::disc) disc(
      const ::chrome::mojom::MediaMetadataPtr& input) {
    return input->disc;
  }

  static const decltype(::chrome::mojom::MediaMetadata::genre)& genre(
      const ::chrome::mojom::MediaMetadataPtr& input) {
    return input->genre;
  }

  static const decltype(::chrome::mojom::MediaMetadata::language)& language(
      const ::chrome::mojom::MediaMetadataPtr& input) {
    return input->language;
  }

  static const decltype(::chrome::mojom::MediaMetadata::title)& title(
      const ::chrome::mojom::MediaMetadataPtr& input) {
    return input->title;
  }

  static decltype(::chrome::mojom::MediaMetadata::track) track(
      const ::chrome::mojom::MediaMetadataPtr& input) {
    return input->track;
  }

  static const decltype(::chrome::mojom::MediaMetadata::raw_tags)& raw_tags(
      const ::chrome::mojom::MediaMetadataPtr& input) {
    return input->raw_tags;
  }

  static bool Read(::chrome::mojom::MediaMetadata::DataView input, ::chrome::mojom::MediaMetadataPtr* output);
};


template <>
struct  StructTraits<::chrome::mojom::AttachedImage::DataView,
                                         ::chrome::mojom::AttachedImagePtr> {
  static bool IsNull(const ::chrome::mojom::AttachedImagePtr& input) { return !input; }
  static void SetToNull(::chrome::mojom::AttachedImagePtr* output) { output->reset(); }

  static const decltype(::chrome::mojom::AttachedImage::type)& type(
      const ::chrome::mojom::AttachedImagePtr& input) {
    return input->type;
  }

  static const decltype(::chrome::mojom::AttachedImage::data)& data(
      const ::chrome::mojom::AttachedImagePtr& input) {
    return input->data;
  }

  static bool Read(::chrome::mojom::AttachedImage::DataView input, ::chrome::mojom::AttachedImagePtr* output);
};

}  // namespace mojo

#endif  // CHROME_SERVICES_MEDIA_GALLERY_UTIL_PUBLIC_MOJOM_MEDIA_PARSER_MOJOM_H_