// chrome/services/media_gallery_util/public/mojom/media_parser.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_SERVICES_MEDIA_GALLERY_UTIL_PUBLIC_MOJOM_MEDIA_PARSER_MOJOM_DATA_VIEW_H_
#define CHROME_SERVICES_MEDIA_GALLERY_UTIL_PUBLIC_MOJOM_MEDIA_PARSER_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "chrome/services/media_gallery_util/public/mojom/media_parser.mojom-shared-internal.h"
#include "media/mojo/mojom/media_types.mojom-shared.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"
#include "sandbox/policy/mojom/sandbox.mojom-shared.h"


namespace chrome::mojom {
class MediaStreamInfoDataView;

class MediaMetadataDataView;

class AttachedImageDataView;



}  // chrome::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::chrome::mojom::MediaStreamInfoDataView> {
  using Data = ::chrome::mojom::internal::MediaStreamInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::chrome::mojom::MediaMetadataDataView> {
  using Data = ::chrome::mojom::internal::MediaMetadata_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::chrome::mojom::AttachedImageDataView> {
  using Data = ::chrome::mojom::internal::AttachedImage_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace chrome::mojom {
// Interface base classes. They are used for type safety check.
class MediaParserInterfaceBase {};

using MediaParserPtrDataView =
    mojo::InterfacePtrDataView<MediaParserInterfaceBase>;
using MediaParserRequestDataView =
    mojo::InterfaceRequestDataView<MediaParserInterfaceBase>;
using MediaParserAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<MediaParserInterfaceBase>;
using MediaParserAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<MediaParserInterfaceBase>;
class MediaParserFactoryInterfaceBase {};

using MediaParserFactoryPtrDataView =
    mojo::InterfacePtrDataView<MediaParserFactoryInterfaceBase>;
using MediaParserFactoryRequestDataView =
    mojo::InterfaceRequestDataView<MediaParserFactoryInterfaceBase>;
using MediaParserFactoryAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<MediaParserFactoryInterfaceBase>;
using MediaParserFactoryAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<MediaParserFactoryInterfaceBase>;
class MediaDataSourceInterfaceBase {};

using MediaDataSourcePtrDataView =
    mojo::InterfacePtrDataView<MediaDataSourceInterfaceBase>;
using MediaDataSourceRequestDataView =
    mojo::InterfaceRequestDataView<MediaDataSourceInterfaceBase>;
using MediaDataSourceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<MediaDataSourceInterfaceBase>;
using MediaDataSourceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<MediaDataSourceInterfaceBase>;


class MediaStreamInfoDataView {
 public:
  MediaStreamInfoDataView() = default;

  MediaStreamInfoDataView(
      internal::MediaStreamInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) {
    
    auto* pointer = data_->type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetAdditionalPropertiesDataView(
      ::mojo_base::mojom::DictionaryValueDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAdditionalProperties(UserType* output) {
    
    auto* pointer = data_->additional_properties.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::DictionaryValueDataView>(
        pointer, output, message_);
  }
 private:
  internal::MediaStreamInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaMetadataDataView {
 public:
  MediaMetadataDataView() = default;

  MediaMetadataDataView(
      internal::MediaMetadata_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMimeTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMimeType(UserType* output) {
    
    auto* pointer = data_->mime_type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  int32_t height() const {
    return data_->height;
  }
  int32_t width() const {
    return data_->width;
  }
  double duration() const {
    return data_->duration;
  }
  int32_t rotation() const {
    return data_->rotation;
  }
  inline void GetAlbumDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAlbum(UserType* output) {
    
    auto* pointer = data_->album.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetArtistDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadArtist(UserType* output) {
    
    auto* pointer = data_->artist.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetCommentDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadComment(UserType* output) {
    
    auto* pointer = data_->comment.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetCopyrightDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCopyright(UserType* output) {
    
    auto* pointer = data_->copyright.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  int32_t disc() const {
    return data_->disc;
  }
  inline void GetGenreDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGenre(UserType* output) {
    
    auto* pointer = data_->genre.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetLanguageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLanguage(UserType* output) {
    
    auto* pointer = data_->language.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetTitleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  int32_t track() const {
    return data_->track;
  }
  inline void GetRawTagsDataView(
      mojo::ArrayDataView<MediaStreamInfoDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRawTags(UserType* output) {
    
    auto* pointer = data_->raw_tags.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::chrome::mojom::MediaStreamInfoDataView>>(
        pointer, output, message_);
  }
 private:
  internal::MediaMetadata_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AttachedImageDataView {
 public:
  AttachedImageDataView() = default;

  AttachedImageDataView(
      internal::AttachedImage_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) {
    
    auto* pointer = data_->type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDataDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
    auto* pointer = data_->data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
 private:
  internal::AttachedImage_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // chrome::mojom

#endif  // CHROME_SERVICES_MEDIA_GALLERY_UTIL_PUBLIC_MOJOM_MEDIA_PARSER_MOJOM_DATA_VIEW_H_