// chrome/services/mac_notifications/public/mojom/mac_notifications.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/services/mac_notifications/public/mojom/mac_notifications.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/services/mac_notifications/public/mojom/mac_notifications.mojom-params-data.h"
#include "chrome/services/mac_notifications/public/mojom/mac_notifications.mojom-shared-message-ids.h"

#include "chrome/services/mac_notifications/public/mojom/mac_notifications.mojom-import-headers.h"
#include "chrome/services/mac_notifications/public/mojom/mac_notifications.mojom-test-utils.h"


namespace mac_notifications::mojom {
ProfileIdentifier::ProfileIdentifier()
    : id(),
      incognito() {}

ProfileIdentifier::ProfileIdentifier(
    const std::string& id_in,
    bool incognito_in)
    : id(std::move(id_in)),
      incognito(std::move(incognito_in)) {}

ProfileIdentifier::~ProfileIdentifier() = default;
size_t ProfileIdentifier::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->id);
  seed = mojo::internal::Hash(seed, this->incognito);
  return seed;
}

void ProfileIdentifier::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "incognito"), this->incognito,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ProfileIdentifier::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
NotificationIdentifier::NotificationIdentifier()
    : id(),
      profile() {}

NotificationIdentifier::NotificationIdentifier(
    const std::string& id_in,
    ProfileIdentifierPtr profile_in)
    : id(std::move(id_in)),
      profile(std::move(profile_in)) {}

NotificationIdentifier::~NotificationIdentifier() = default;
size_t NotificationIdentifier::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->id);
  seed = mojo::internal::Hash(seed, this->profile);
  return seed;
}

void NotificationIdentifier::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "profile"), this->profile,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ProfileIdentifierPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool NotificationIdentifier::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
NotificationMetadata::NotificationMetadata()
    : id(),
      type(),
      origin_url(),
      user_data_dir() {}

NotificationMetadata::NotificationMetadata(
    NotificationIdentifierPtr id_in,
    int32_t type_in,
    const ::GURL& origin_url_in,
    const std::string& user_data_dir_in)
    : id(std::move(id_in)),
      type(std::move(type_in)),
      origin_url(std::move(origin_url_in)),
      user_data_dir(std::move(user_data_dir_in)) {}

NotificationMetadata::~NotificationMetadata() = default;

void NotificationMetadata::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type NotificationIdentifierPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "origin_url"), this->origin_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "user_data_dir"), this->user_data_dir,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool NotificationMetadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
NotificationActionInfo::NotificationActionInfo()
    : meta(),
      operation(),
      button_index(),
      reply() {}

NotificationActionInfo::NotificationActionInfo(
    NotificationMetadataPtr meta_in,
    ::NotificationOperation operation_in,
    int32_t button_index_in,
    const std::optional<::std::u16string>& reply_in)
    : meta(std::move(meta_in)),
      operation(std::move(operation_in)),
      button_index(std::move(button_index_in)),
      reply(std::move(reply_in)) {}

NotificationActionInfo::~NotificationActionInfo() = default;

void NotificationActionInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "meta"), this->meta,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type NotificationMetadataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "operation"), this->operation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::NotificationOperation>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "button_index"), this->button_index,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reply"), this->reply,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::std::u16string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool NotificationActionInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
NotificationActionButton::NotificationActionButton()
    : title(),
      placeholder() {}

NotificationActionButton::NotificationActionButton(
    const ::std::u16string& title_in,
    const std::optional<::std::u16string>& placeholder_in)
    : title(std::move(title_in)),
      placeholder(std::move(placeholder_in)) {}

NotificationActionButton::~NotificationActionButton() = default;

void NotificationActionButton::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "placeholder"), this->placeholder,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::std::u16string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool NotificationActionButton::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Notification::Notification()
    : meta(),
      title(),
      subtitle(),
      body(),
      renotify(),
      show_settings_button(),
      buttons(),
      icon() {}

Notification::Notification(
    NotificationMetadataPtr meta_in,
    const ::std::u16string& title_in,
    const ::std::u16string& subtitle_in,
    const ::std::u16string& body_in,
    bool renotify_in,
    bool show_settings_button_in,
    std::vector<NotificationActionButtonPtr> buttons_in,
    const ::gfx::ImageSkia& icon_in)
    : meta(std::move(meta_in)),
      title(std::move(title_in)),
      subtitle(std::move(subtitle_in)),
      body(std::move(body_in)),
      renotify(std::move(renotify_in)),
      show_settings_button(std::move(show_settings_button_in)),
      buttons(std::move(buttons_in)),
      icon(std::move(icon_in)) {}

Notification::~Notification() = default;

void Notification::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "meta"), this->meta,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type NotificationMetadataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "subtitle"), this->subtitle,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "body"), this->body,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "renotify"), this->renotify,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "show_settings_button"), this->show_settings_button,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "buttons"), this->buttons,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<NotificationActionButtonPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "icon"), this->icon,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::ImageSkia&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Notification::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

MacNotificationService::IPCStableHashFunction MacNotificationService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::MacNotificationService>(message.name())) {
    case messages::MacNotificationService::kDisplayNotification: {
      return &MacNotificationService::DisplayNotification_Sym::IPCStableHash;
    }
    case messages::MacNotificationService::kGetDisplayedNotifications: {
      return &MacNotificationService::GetDisplayedNotifications_Sym::IPCStableHash;
    }
    case messages::MacNotificationService::kCloseNotification: {
      return &MacNotificationService::CloseNotification_Sym::IPCStableHash;
    }
    case messages::MacNotificationService::kCloseNotificationsForProfile: {
      return &MacNotificationService::CloseNotificationsForProfile_Sym::IPCStableHash;
    }
    case messages::MacNotificationService::kCloseAllNotifications: {
      return &MacNotificationService::CloseAllNotifications_Sym::IPCStableHash;
    }
    case messages::MacNotificationService::kOkayToTerminateService: {
      return &MacNotificationService::OkayToTerminateService_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* MacNotificationService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::MacNotificationService>(message.name())) {
      case messages::MacNotificationService::kDisplayNotification:
            return "Receive mac_notifications::mojom::MacNotificationService::DisplayNotification";
      case messages::MacNotificationService::kGetDisplayedNotifications:
            return "Receive mac_notifications::mojom::MacNotificationService::GetDisplayedNotifications";
      case messages::MacNotificationService::kCloseNotification:
            return "Receive mac_notifications::mojom::MacNotificationService::CloseNotification";
      case messages::MacNotificationService::kCloseNotificationsForProfile:
            return "Receive mac_notifications::mojom::MacNotificationService::CloseNotificationsForProfile";
      case messages::MacNotificationService::kCloseAllNotifications:
            return "Receive mac_notifications::mojom::MacNotificationService::CloseAllNotifications";
      case messages::MacNotificationService::kOkayToTerminateService:
            return "Receive mac_notifications::mojom::MacNotificationService::OkayToTerminateService";
    }
  } else {
    switch (static_cast<messages::MacNotificationService>(message.name())) {
      case messages::MacNotificationService::kDisplayNotification:
            return "Receive reply mac_notifications::mojom::MacNotificationService::DisplayNotification";
      case messages::MacNotificationService::kGetDisplayedNotifications:
            return "Receive reply mac_notifications::mojom::MacNotificationService::GetDisplayedNotifications";
      case messages::MacNotificationService::kCloseNotification:
            return "Receive reply mac_notifications::mojom::MacNotificationService::CloseNotification";
      case messages::MacNotificationService::kCloseNotificationsForProfile:
            return "Receive reply mac_notifications::mojom::MacNotificationService::CloseNotificationsForProfile";
      case messages::MacNotificationService::kCloseAllNotifications:
            return "Receive reply mac_notifications::mojom::MacNotificationService::CloseAllNotifications";
      case messages::MacNotificationService::kOkayToTerminateService:
            return "Receive reply mac_notifications::mojom::MacNotificationService::OkayToTerminateService";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t MacNotificationService::DisplayNotification_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3b9e5e78;  // IPCStableHash for mac_notifications::mojom::MacNotificationService::DisplayNotification
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MacNotificationService::GetDisplayedNotifications_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2bbc6381;  // IPCStableHash for mac_notifications::mojom::MacNotificationService::GetDisplayedNotifications
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MacNotificationService::CloseNotification_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd31d735b;  // IPCStableHash for mac_notifications::mojom::MacNotificationService::CloseNotification
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MacNotificationService::CloseNotificationsForProfile_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x967d55bf;  // IPCStableHash for mac_notifications::mojom::MacNotificationService::CloseNotificationsForProfile
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MacNotificationService::CloseAllNotifications_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xba499b92;  // IPCStableHash for mac_notifications::mojom::MacNotificationService::CloseAllNotifications
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MacNotificationService::OkayToTerminateService_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8cbf1139;  // IPCStableHash for mac_notifications::mojom::MacNotificationService::OkayToTerminateService
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class MacNotificationService_GetDisplayedNotifications_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  MacNotificationService_GetDisplayedNotifications_ForwardToCallback(
      MacNotificationService::GetDisplayedNotificationsCallback callback
      ) : callback_(std::move(callback)) {
  }

  MacNotificationService_GetDisplayedNotifications_ForwardToCallback(const MacNotificationService_GetDisplayedNotifications_ForwardToCallback&) = delete;
  MacNotificationService_GetDisplayedNotifications_ForwardToCallback& operator=(const MacNotificationService_GetDisplayedNotifications_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  MacNotificationService::GetDisplayedNotificationsCallback callback_;
};

class MacNotificationService_OkayToTerminateService_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  MacNotificationService_OkayToTerminateService_ForwardToCallback(
      MacNotificationService::OkayToTerminateServiceCallback callback
      ) : callback_(std::move(callback)) {
  }

  MacNotificationService_OkayToTerminateService_ForwardToCallback(const MacNotificationService_OkayToTerminateService_ForwardToCallback&) = delete;
  MacNotificationService_OkayToTerminateService_ForwardToCallback& operator=(const MacNotificationService_OkayToTerminateService_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  MacNotificationService::OkayToTerminateServiceCallback callback_;
};

MacNotificationServiceProxy::MacNotificationServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MacNotificationServiceProxy::DisplayNotification(
    NotificationPtr in_notification) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send mac_notifications::mojom::MacNotificationService::DisplayNotification", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("notification"), in_notification,
                        "<value of type NotificationPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MacNotificationService::kDisplayNotification), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mac_notifications::mojom::internal::MacNotificationService_DisplayNotification_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->notification)::BaseType> notification_fragment(
          params.message());
  
  mojo::internal::Serialize<::mac_notifications::mojom::NotificationDataView>(
    in_notification,
    notification_fragment);

  params->notification.Set(
      notification_fragment.is_null() ? nullptr : notification_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->notification.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null notification in MacNotificationService.DisplayNotification request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MacNotificationService::Name_);
  message.set_method_name("DisplayNotification");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MacNotificationServiceProxy::GetDisplayedNotifications(
    ProfileIdentifierPtr in_profile, const std::optional<::GURL>& in_origin, GetDisplayedNotificationsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send mac_notifications::mojom::MacNotificationService::GetDisplayedNotifications", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("profile"), in_profile,
                        "<value of type ProfileIdentifierPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin"), in_origin,
                        "<value of type const std::optional<::GURL>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MacNotificationService::kGetDisplayedNotifications), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mac_notifications::mojom::internal::MacNotificationService_GetDisplayedNotifications_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->profile)::BaseType> profile_fragment(
          params.message());
  
  mojo::internal::Serialize<::mac_notifications::mojom::ProfileIdentifierDataView>(
    in_profile,
    profile_fragment);

  params->profile.Set(
      profile_fragment.is_null() ? nullptr : profile_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->origin)::BaseType> origin_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_origin,
    origin_fragment);

  params->origin.Set(
      origin_fragment.is_null() ? nullptr : origin_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MacNotificationService::Name_);
  message.set_method_name("GetDisplayedNotifications");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new MacNotificationService_GetDisplayedNotifications_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void MacNotificationServiceProxy::CloseNotification(
    NotificationIdentifierPtr in_identifier) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send mac_notifications::mojom::MacNotificationService::CloseNotification", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("identifier"), in_identifier,
                        "<value of type NotificationIdentifierPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MacNotificationService::kCloseNotification), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mac_notifications::mojom::internal::MacNotificationService_CloseNotification_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->identifier)::BaseType> identifier_fragment(
          params.message());
  
  mojo::internal::Serialize<::mac_notifications::mojom::NotificationIdentifierDataView>(
    in_identifier,
    identifier_fragment);

  params->identifier.Set(
      identifier_fragment.is_null() ? nullptr : identifier_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->identifier.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null identifier in MacNotificationService.CloseNotification request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MacNotificationService::Name_);
  message.set_method_name("CloseNotification");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MacNotificationServiceProxy::CloseNotificationsForProfile(
    ProfileIdentifierPtr in_profile) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send mac_notifications::mojom::MacNotificationService::CloseNotificationsForProfile", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("profile"), in_profile,
                        "<value of type ProfileIdentifierPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MacNotificationService::kCloseNotificationsForProfile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mac_notifications::mojom::internal::MacNotificationService_CloseNotificationsForProfile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->profile)::BaseType> profile_fragment(
          params.message());
  
  mojo::internal::Serialize<::mac_notifications::mojom::ProfileIdentifierDataView>(
    in_profile,
    profile_fragment);

  params->profile.Set(
      profile_fragment.is_null() ? nullptr : profile_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->profile.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null profile in MacNotificationService.CloseNotificationsForProfile request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MacNotificationService::Name_);
  message.set_method_name("CloseNotificationsForProfile");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MacNotificationServiceProxy::CloseAllNotifications(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send mac_notifications::mojom::MacNotificationService::CloseAllNotifications");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MacNotificationService::kCloseAllNotifications), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mac_notifications::mojom::internal::MacNotificationService_CloseAllNotifications_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MacNotificationService::Name_);
  message.set_method_name("CloseAllNotifications");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MacNotificationServiceProxy::OkayToTerminateService(
    OkayToTerminateServiceCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send mac_notifications::mojom::MacNotificationService::OkayToTerminateService");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MacNotificationService::kOkayToTerminateService), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mac_notifications::mojom::internal::MacNotificationService_OkayToTerminateService_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MacNotificationService::Name_);
  message.set_method_name("OkayToTerminateService");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new MacNotificationService_OkayToTerminateService_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class MacNotificationService_GetDisplayedNotifications_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static MacNotificationService::GetDisplayedNotificationsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<MacNotificationService_GetDisplayedNotifications_ProxyToResponder> proxy(
        new MacNotificationService_GetDisplayedNotifications_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&MacNotificationService_GetDisplayedNotifications_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~MacNotificationService_GetDisplayedNotifications_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  MacNotificationService_GetDisplayedNotifications_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "MacNotificationService::GetDisplayedNotificationsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<NotificationIdentifierPtr> in_notifications);
};

bool MacNotificationService_GetDisplayedNotifications_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::MacNotificationService_GetDisplayedNotifications_ResponseParams_Data* params =
      reinterpret_cast<
          internal::MacNotificationService_GetDisplayedNotifications_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for MacNotificationService.1
  bool success = true;
  std::vector<NotificationIdentifierPtr> p_notifications{};
  MacNotificationService_GetDisplayedNotifications_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadNotifications(&p_notifications))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        MacNotificationService::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_notifications));
  }
  return true;
}

void MacNotificationService_GetDisplayedNotifications_ProxyToResponder::Run(
    std::vector<NotificationIdentifierPtr> in_notifications) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply mac_notifications::mojom::MacNotificationService::GetDisplayedNotifications", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("notifications"), in_notifications,
                        "<value of type std::vector<NotificationIdentifierPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MacNotificationService::kGetDisplayedNotifications), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mac_notifications::mojom::internal::MacNotificationService_GetDisplayedNotifications_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->notifications)::BaseType>
      notifications_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& notifications_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::mac_notifications::mojom::NotificationIdentifierDataView>>(
    in_notifications,
    notifications_fragment,
    &notifications_validate_params);

  params->notifications.Set(
      notifications_fragment.is_null() ? nullptr : notifications_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->notifications.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null notifications in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MacNotificationService::Name_);
  message.set_method_name("GetDisplayedNotifications");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class MacNotificationService_OkayToTerminateService_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static MacNotificationService::OkayToTerminateServiceCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<MacNotificationService_OkayToTerminateService_ProxyToResponder> proxy(
        new MacNotificationService_OkayToTerminateService_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&MacNotificationService_OkayToTerminateService_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~MacNotificationService_OkayToTerminateService_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  MacNotificationService_OkayToTerminateService_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "MacNotificationService::OkayToTerminateServiceCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_can_terminate);
};

bool MacNotificationService_OkayToTerminateService_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::MacNotificationService_OkayToTerminateService_ResponseParams_Data* params =
      reinterpret_cast<
          internal::MacNotificationService_OkayToTerminateService_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for MacNotificationService.5
  bool success = true;
  bool p_can_terminate{};
  MacNotificationService_OkayToTerminateService_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_can_terminate = input_data_view.can_terminate();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        MacNotificationService::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_can_terminate));
  }
  return true;
}

void MacNotificationService_OkayToTerminateService_ProxyToResponder::Run(
    bool in_can_terminate) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply mac_notifications::mojom::MacNotificationService::OkayToTerminateService", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("can_terminate"), in_can_terminate,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MacNotificationService::kOkayToTerminateService), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mac_notifications::mojom::internal::MacNotificationService_OkayToTerminateService_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->can_terminate = in_can_terminate;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MacNotificationService::Name_);
  message.set_method_name("OkayToTerminateService");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool MacNotificationServiceStubDispatch::Accept(
    MacNotificationService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::MacNotificationService>(message->header()->name)) {
    case messages::MacNotificationService::kDisplayNotification: {
      DCHECK(message->is_serialized());
      internal::MacNotificationService_DisplayNotification_Params_Data* params =
          reinterpret_cast<internal::MacNotificationService_DisplayNotification_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MacNotificationService.0
      bool success = true;
      NotificationPtr p_notification{};
      MacNotificationService_DisplayNotification_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNotification(&p_notification))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MacNotificationService::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DisplayNotification(        
        std::move(p_notification));
      return true;
    }
    case messages::MacNotificationService::kGetDisplayedNotifications: {
      break;
    }
    case messages::MacNotificationService::kCloseNotification: {
      DCHECK(message->is_serialized());
      internal::MacNotificationService_CloseNotification_Params_Data* params =
          reinterpret_cast<internal::MacNotificationService_CloseNotification_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MacNotificationService.2
      bool success = true;
      NotificationIdentifierPtr p_identifier{};
      MacNotificationService_CloseNotification_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadIdentifier(&p_identifier))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MacNotificationService::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CloseNotification(        
        std::move(p_identifier));
      return true;
    }
    case messages::MacNotificationService::kCloseNotificationsForProfile: {
      DCHECK(message->is_serialized());
      internal::MacNotificationService_CloseNotificationsForProfile_Params_Data* params =
          reinterpret_cast<internal::MacNotificationService_CloseNotificationsForProfile_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MacNotificationService.3
      bool success = true;
      ProfileIdentifierPtr p_profile{};
      MacNotificationService_CloseNotificationsForProfile_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadProfile(&p_profile))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MacNotificationService::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CloseNotificationsForProfile(        
        std::move(p_profile));
      return true;
    }
    case messages::MacNotificationService::kCloseAllNotifications: {
      DCHECK(message->is_serialized());
      internal::MacNotificationService_CloseAllNotifications_Params_Data* params =
          reinterpret_cast<internal::MacNotificationService_CloseAllNotifications_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MacNotificationService.4
      bool success = true;
      MacNotificationService_CloseAllNotifications_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MacNotificationService::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CloseAllNotifications(        );
      return true;
    }
    case messages::MacNotificationService::kOkayToTerminateService: {
      break;
    }
  }
  return false;
}

// static
bool MacNotificationServiceStubDispatch::AcceptWithResponder(
    MacNotificationService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::MacNotificationService>(message->header()->name)) {
    case messages::MacNotificationService::kDisplayNotification: {
      break;
    }
    case messages::MacNotificationService::kGetDisplayedNotifications: {
      internal::MacNotificationService_GetDisplayedNotifications_Params_Data* params =
          reinterpret_cast<
              internal::MacNotificationService_GetDisplayedNotifications_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for MacNotificationService.1
      bool success = true;
      ProfileIdentifierPtr p_profile{};
      std::optional<::GURL> p_origin{};
      MacNotificationService_GetDisplayedNotifications_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadProfile(&p_profile))
        success = false;
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MacNotificationService::Name_, 1, false);
        return false;
      }
      auto callback =
          MacNotificationService_GetDisplayedNotifications_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDisplayedNotifications(        
        std::move(p_profile), 
        std::move(p_origin), std::move(callback));
      return true;
    }
    case messages::MacNotificationService::kCloseNotification: {
      break;
    }
    case messages::MacNotificationService::kCloseNotificationsForProfile: {
      break;
    }
    case messages::MacNotificationService::kCloseAllNotifications: {
      break;
    }
    case messages::MacNotificationService::kOkayToTerminateService: {
      internal::MacNotificationService_OkayToTerminateService_Params_Data* params =
          reinterpret_cast<
              internal::MacNotificationService_OkayToTerminateService_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for MacNotificationService.5
      bool success = true;
      MacNotificationService_OkayToTerminateService_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MacNotificationService::Name_, 5, false);
        return false;
      }
      auto callback =
          MacNotificationService_OkayToTerminateService_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OkayToTerminateService(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kMacNotificationServiceValidationInfo[] = {
    { &internal::MacNotificationService_DisplayNotification_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MacNotificationService_GetDisplayedNotifications_Params_Data::Validate,
     &internal::MacNotificationService_GetDisplayedNotifications_ResponseParams_Data::Validate},
    { &internal::MacNotificationService_CloseNotification_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MacNotificationService_CloseNotificationsForProfile_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MacNotificationService_CloseAllNotifications_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MacNotificationService_OkayToTerminateService_Params_Data::Validate,
     &internal::MacNotificationService_OkayToTerminateService_ResponseParams_Data::Validate},
};

bool MacNotificationServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::mac_notifications::mojom::MacNotificationService::Name_,
    kMacNotificationServiceValidationInfo);
}

bool MacNotificationServiceResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::mac_notifications::mojom::MacNotificationService::Name_,
    kMacNotificationServiceValidationInfo);
}
// The declaration includes the definition on other builds.

MacNotificationActionHandler::IPCStableHashFunction MacNotificationActionHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::MacNotificationActionHandler>(message.name())) {
    case messages::MacNotificationActionHandler::kOnNotificationAction: {
      return &MacNotificationActionHandler::OnNotificationAction_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* MacNotificationActionHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::MacNotificationActionHandler>(message.name())) {
      case messages::MacNotificationActionHandler::kOnNotificationAction:
            return "Receive mac_notifications::mojom::MacNotificationActionHandler::OnNotificationAction";
    }
  } else {
    switch (static_cast<messages::MacNotificationActionHandler>(message.name())) {
      case messages::MacNotificationActionHandler::kOnNotificationAction:
            return "Receive reply mac_notifications::mojom::MacNotificationActionHandler::OnNotificationAction";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t MacNotificationActionHandler::OnNotificationAction_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd9537d5a;  // IPCStableHash for mac_notifications::mojom::MacNotificationActionHandler::OnNotificationAction
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

MacNotificationActionHandlerProxy::MacNotificationActionHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MacNotificationActionHandlerProxy::OnNotificationAction(
    NotificationActionInfoPtr in_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send mac_notifications::mojom::MacNotificationActionHandler::OnNotificationAction", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("info"), in_info,
                        "<value of type NotificationActionInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MacNotificationActionHandler::kOnNotificationAction), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mac_notifications::mojom::internal::MacNotificationActionHandler_OnNotificationAction_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->info)::BaseType> info_fragment(
          params.message());
  
  mojo::internal::Serialize<::mac_notifications::mojom::NotificationActionInfoDataView>(
    in_info,
    info_fragment);

  params->info.Set(
      info_fragment.is_null() ? nullptr : info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null info in MacNotificationActionHandler.OnNotificationAction request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MacNotificationActionHandler::Name_);
  message.set_method_name("OnNotificationAction");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool MacNotificationActionHandlerStubDispatch::Accept(
    MacNotificationActionHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::MacNotificationActionHandler>(message->header()->name)) {
    case messages::MacNotificationActionHandler::kOnNotificationAction: {
      DCHECK(message->is_serialized());
      internal::MacNotificationActionHandler_OnNotificationAction_Params_Data* params =
          reinterpret_cast<internal::MacNotificationActionHandler_OnNotificationAction_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MacNotificationActionHandler.0
      bool success = true;
      NotificationActionInfoPtr p_info{};
      MacNotificationActionHandler_OnNotificationAction_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInfo(&p_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MacNotificationActionHandler::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnNotificationAction(        
        std::move(p_info));
      return true;
    }
  }
  return false;
}

// static
bool MacNotificationActionHandlerStubDispatch::AcceptWithResponder(
    MacNotificationActionHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::MacNotificationActionHandler>(message->header()->name)) {
    case messages::MacNotificationActionHandler::kOnNotificationAction: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kMacNotificationActionHandlerValidationInfo[] = {
    { &internal::MacNotificationActionHandler_OnNotificationAction_Params_Data::Validate,
     nullptr /* no response */},
};

bool MacNotificationActionHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::mac_notifications::mojom::MacNotificationActionHandler::Name_,
    kMacNotificationActionHandlerValidationInfo);
}

// The declaration includes the definition on other builds.

MacNotificationProvider::IPCStableHashFunction MacNotificationProvider::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::MacNotificationProvider>(message.name())) {
    case messages::MacNotificationProvider::kBindNotificationService: {
      return &MacNotificationProvider::BindNotificationService_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* MacNotificationProvider::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::MacNotificationProvider>(message.name())) {
      case messages::MacNotificationProvider::kBindNotificationService:
            return "Receive mac_notifications::mojom::MacNotificationProvider::BindNotificationService";
    }
  } else {
    switch (static_cast<messages::MacNotificationProvider>(message.name())) {
      case messages::MacNotificationProvider::kBindNotificationService:
            return "Receive reply mac_notifications::mojom::MacNotificationProvider::BindNotificationService";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t MacNotificationProvider::BindNotificationService_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x47276b59;  // IPCStableHash for mac_notifications::mojom::MacNotificationProvider::BindNotificationService
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

MacNotificationProviderProxy::MacNotificationProviderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MacNotificationProviderProxy::BindNotificationService(
    ::mojo::PendingReceiver<MacNotificationService> in_service, ::mojo::PendingRemote<MacNotificationActionHandler> in_handler) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send mac_notifications::mojom::MacNotificationProvider::BindNotificationService", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service"), in_service,
                        "<value of type ::mojo::PendingReceiver<MacNotificationService>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handler"), in_handler,
                        "<value of type ::mojo::PendingRemote<MacNotificationActionHandler>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MacNotificationProvider::kBindNotificationService), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mac_notifications::mojom::internal::MacNotificationProvider_BindNotificationService_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::mac_notifications::mojom::MacNotificationServiceInterfaceBase>>(
    in_service,
    &params->service,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->service)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid service in MacNotificationProvider.BindNotificationService request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::mac_notifications::mojom::MacNotificationActionHandlerInterfaceBase>>(
    in_handler,
    &params->handler,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->handler)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid handler in MacNotificationProvider.BindNotificationService request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MacNotificationProvider::Name_);
  message.set_method_name("BindNotificationService");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool MacNotificationProviderStubDispatch::Accept(
    MacNotificationProvider* impl,
    mojo::Message* message) {
  switch (static_cast<messages::MacNotificationProvider>(message->header()->name)) {
    case messages::MacNotificationProvider::kBindNotificationService: {
      DCHECK(message->is_serialized());
      internal::MacNotificationProvider_BindNotificationService_Params_Data* params =
          reinterpret_cast<internal::MacNotificationProvider_BindNotificationService_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MacNotificationProvider.0
      bool success = true;
      ::mojo::PendingReceiver<MacNotificationService> p_service{};
      ::mojo::PendingRemote<MacNotificationActionHandler> p_handler{};
      MacNotificationProvider_BindNotificationService_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_service =
            input_data_view.TakeService<decltype(p_service)>();
      }
      if (success) {
        p_handler =
            input_data_view.TakeHandler<decltype(p_handler)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MacNotificationProvider::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindNotificationService(        
        std::move(p_service), 
        std::move(p_handler));
      return true;
    }
  }
  return false;
}

// static
bool MacNotificationProviderStubDispatch::AcceptWithResponder(
    MacNotificationProvider* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::MacNotificationProvider>(message->header()->name)) {
    case messages::MacNotificationProvider::kBindNotificationService: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kMacNotificationProviderValidationInfo[] = {
    { &internal::MacNotificationProvider_BindNotificationService_Params_Data::Validate,
     nullptr /* no response */},
};

bool MacNotificationProviderRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::mac_notifications::mojom::MacNotificationProvider::Name_,
    kMacNotificationProviderValidationInfo);
}



}  // mac_notifications::mojom


namespace mojo {


// static
bool StructTraits<::mac_notifications::mojom::ProfileIdentifier::DataView, ::mac_notifications::mojom::ProfileIdentifierPtr>::Read(
    ::mac_notifications::mojom::ProfileIdentifier::DataView input,
    ::mac_notifications::mojom::ProfileIdentifierPtr* output) {
  bool success = true;
  ::mac_notifications::mojom::ProfileIdentifierPtr result(::mac_notifications::mojom::ProfileIdentifier::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success)
        result->incognito = input.incognito();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::mac_notifications::mojom::NotificationIdentifier::DataView, ::mac_notifications::mojom::NotificationIdentifierPtr>::Read(
    ::mac_notifications::mojom::NotificationIdentifier::DataView input,
    ::mac_notifications::mojom::NotificationIdentifierPtr* output) {
  bool success = true;
  ::mac_notifications::mojom::NotificationIdentifierPtr result(::mac_notifications::mojom::NotificationIdentifier::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadProfile(&result->profile))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::mac_notifications::mojom::NotificationMetadata::DataView, ::mac_notifications::mojom::NotificationMetadataPtr>::Read(
    ::mac_notifications::mojom::NotificationMetadata::DataView input,
    ::mac_notifications::mojom::NotificationMetadataPtr* output) {
  bool success = true;
  ::mac_notifications::mojom::NotificationMetadataPtr result(::mac_notifications::mojom::NotificationMetadata::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success)
        result->type = input.type();
      if (success && !input.ReadOriginUrl(&result->origin_url))
        success = false;
      if (success && !input.ReadUserDataDir(&result->user_data_dir))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::mac_notifications::mojom::NotificationActionInfo::DataView, ::mac_notifications::mojom::NotificationActionInfoPtr>::Read(
    ::mac_notifications::mojom::NotificationActionInfo::DataView input,
    ::mac_notifications::mojom::NotificationActionInfoPtr* output) {
  bool success = true;
  ::mac_notifications::mojom::NotificationActionInfoPtr result(::mac_notifications::mojom::NotificationActionInfo::New());
  
      if (success && !input.ReadMeta(&result->meta))
        success = false;
      if (success && !input.ReadOperation(&result->operation))
        success = false;
      if (success)
        result->button_index = input.button_index();
      if (success && !input.ReadReply(&result->reply))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::mac_notifications::mojom::NotificationActionButton::DataView, ::mac_notifications::mojom::NotificationActionButtonPtr>::Read(
    ::mac_notifications::mojom::NotificationActionButton::DataView input,
    ::mac_notifications::mojom::NotificationActionButtonPtr* output) {
  bool success = true;
  ::mac_notifications::mojom::NotificationActionButtonPtr result(::mac_notifications::mojom::NotificationActionButton::New());
  
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success && !input.ReadPlaceholder(&result->placeholder))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::mac_notifications::mojom::Notification::DataView, ::mac_notifications::mojom::NotificationPtr>::Read(
    ::mac_notifications::mojom::Notification::DataView input,
    ::mac_notifications::mojom::NotificationPtr* output) {
  bool success = true;
  ::mac_notifications::mojom::NotificationPtr result(::mac_notifications::mojom::Notification::New());
  
      if (success && !input.ReadMeta(&result->meta))
        success = false;
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success && !input.ReadSubtitle(&result->subtitle))
        success = false;
      if (success && !input.ReadBody(&result->body))
        success = false;
      if (success)
        result->renotify = input.renotify();
      if (success)
        result->show_settings_button = input.show_settings_button();
      if (success && !input.ReadButtons(&result->buttons))
        success = false;
      if (success && !input.ReadIcon(&result->icon))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace mac_notifications::mojom {


void MacNotificationServiceInterceptorForTesting::DisplayNotification(NotificationPtr notification) {
  GetForwardingInterface()->DisplayNotification(
    std::move(notification)
    );
}
void MacNotificationServiceInterceptorForTesting::GetDisplayedNotifications(ProfileIdentifierPtr profile, const std::optional<::GURL>& origin, GetDisplayedNotificationsCallback callback) {
  GetForwardingInterface()->GetDisplayedNotifications(
    std::move(profile)
    , 
    std::move(origin)
    , std::move(callback));
}
void MacNotificationServiceInterceptorForTesting::CloseNotification(NotificationIdentifierPtr identifier) {
  GetForwardingInterface()->CloseNotification(
    std::move(identifier)
    );
}
void MacNotificationServiceInterceptorForTesting::CloseNotificationsForProfile(ProfileIdentifierPtr profile) {
  GetForwardingInterface()->CloseNotificationsForProfile(
    std::move(profile)
    );
}
void MacNotificationServiceInterceptorForTesting::CloseAllNotifications() {
  GetForwardingInterface()->CloseAllNotifications();
}
void MacNotificationServiceInterceptorForTesting::OkayToTerminateService(OkayToTerminateServiceCallback callback) {
  GetForwardingInterface()->OkayToTerminateService(std::move(callback));
}
MacNotificationServiceAsyncWaiter::MacNotificationServiceAsyncWaiter(
    MacNotificationService* proxy) : proxy_(proxy) {}

MacNotificationServiceAsyncWaiter::~MacNotificationServiceAsyncWaiter() = default;


void MacNotificationServiceAsyncWaiter::GetDisplayedNotifications(
    ProfileIdentifierPtr profile, const std::optional<::GURL>& origin, std::vector<NotificationIdentifierPtr>* out_notifications) {
  base::RunLoop loop;
  proxy_->GetDisplayedNotifications(
      std::move(profile),
      std::move(origin),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<NotificationIdentifierPtr>* out_notifications
,
             std::vector<NotificationIdentifierPtr> notifications) {*out_notifications = std::move(notifications);
            loop->Quit();
          },
          &loop,
          out_notifications));
  loop.Run();
}

std::vector<NotificationIdentifierPtr> MacNotificationServiceAsyncWaiter::GetDisplayedNotifications(
    ProfileIdentifierPtr profile, const std::optional<::GURL>& origin) {
  std::vector<NotificationIdentifierPtr> async_wait_result;
  GetDisplayedNotifications(std::move(profile),std::move(origin),&async_wait_result);
  return async_wait_result;
}

void MacNotificationServiceAsyncWaiter::OkayToTerminateService(
    bool* out_can_terminate) {
  base::RunLoop loop;
  proxy_->OkayToTerminateService(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_can_terminate
,
             bool can_terminate) {*out_can_terminate = std::move(can_terminate);
            loop->Quit();
          },
          &loop,
          out_can_terminate));
  loop.Run();
}

bool MacNotificationServiceAsyncWaiter::OkayToTerminateService(
    ) {
  bool async_wait_result;
  OkayToTerminateService(&async_wait_result);
  return async_wait_result;
}




void MacNotificationActionHandlerInterceptorForTesting::OnNotificationAction(NotificationActionInfoPtr info) {
  GetForwardingInterface()->OnNotificationAction(
    std::move(info)
    );
}
MacNotificationActionHandlerAsyncWaiter::MacNotificationActionHandlerAsyncWaiter(
    MacNotificationActionHandler* proxy) : proxy_(proxy) {}

MacNotificationActionHandlerAsyncWaiter::~MacNotificationActionHandlerAsyncWaiter() = default;





void MacNotificationProviderInterceptorForTesting::BindNotificationService(::mojo::PendingReceiver<MacNotificationService> service, ::mojo::PendingRemote<MacNotificationActionHandler> handler) {
  GetForwardingInterface()->BindNotificationService(
    std::move(service)
    , 
    std::move(handler)
    );
}
MacNotificationProviderAsyncWaiter::MacNotificationProviderAsyncWaiter(
    MacNotificationProvider* proxy) : proxy_(proxy) {}

MacNotificationProviderAsyncWaiter::~MacNotificationProviderAsyncWaiter() = default;







}  // mac_notifications::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif