// chrome/services/file_util/public/mojom/single_file_extractor.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_SERVICES_FILE_UTIL_PUBLIC_MOJOM_SINGLE_FILE_EXTRACTOR_MOJOM_H_
#define CHROME_SERVICES_FILE_UTIL_PUBLIC_MOJOM_SINGLE_FILE_EXTRACTOR_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/services/file_util/public/mojom/single_file_extractor.mojom-features.h"  // IWYU pragma: export
#include "chrome/services/file_util/public/mojom/single_file_extractor.mojom-shared.h"  // IWYU pragma: export
#include "chrome/services/file_util/public/mojom/single_file_extractor.mojom-forward.h"  // IWYU pragma: export
#include "chrome/services/file_util/public/mojom/constants.mojom-forward.h"
#include "mojo/public/mojom/base/file.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace chrome::mojom {

class SingleFileExtractorProxy;

template <typename ImplRefTraits>
class SingleFileExtractorStub;

class SingleFileExtractorRequestValidator;
class SingleFileExtractorResponseValidator;


class SingleFileExtractor
    : public SingleFileExtractorInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "chrome.mojom.SingleFileExtractor";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SingleFileExtractorInterfaceBase;
  using Proxy_ = SingleFileExtractorProxy;

  template <typename ImplRefTraits>
  using Stub_ = SingleFileExtractorStub<ImplRefTraits>;

  using RequestValidator_ = SingleFileExtractorRequestValidator;
  using ResponseValidator_ = SingleFileExtractorResponseValidator;
  enum MethodMinVersions : uint32_t {
    kExtractMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Extract_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SingleFileExtractor() = default;

  using ExtractCallback = base::OnceCallback<void(::chrome::file_util::mojom::ExtractionResult)>;
  using ExtractMojoCallback = base::OnceCallback<void(::chrome::file_util::mojom::ExtractionResult)>;

  virtual void Extract(::base::File src_file, ::base::File dst_file, ::mojo::PendingRemote<SingleFileExtractorListener> listener, ExtractCallback callback) = 0;
};

class SingleFileExtractorListenerProxy;

template <typename ImplRefTraits>
class SingleFileExtractorListenerStub;

class SingleFileExtractorListenerRequestValidator;


class SingleFileExtractorListener
    : public SingleFileExtractorListenerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "chrome.mojom.SingleFileExtractorListener";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SingleFileExtractorListenerInterfaceBase;
  using Proxy_ = SingleFileExtractorListenerProxy;

  template <typename ImplRefTraits>
  using Stub_ = SingleFileExtractorListenerStub<ImplRefTraits>;

  using RequestValidator_ = SingleFileExtractorListenerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnProgressMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnProgress_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SingleFileExtractorListener() = default;

  virtual void OnProgress(uint64_t total_bytes, uint64_t progress_bytes) = 0;
};



class  SingleFileExtractorProxy
    : public SingleFileExtractor {
 public:
  using InterfaceType = SingleFileExtractor;

  explicit SingleFileExtractorProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Extract(::base::File src_file, ::base::File dst_file, ::mojo::PendingRemote<SingleFileExtractorListener> listener, ExtractCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  SingleFileExtractorListenerProxy
    : public SingleFileExtractorListener {
 public:
  using InterfaceType = SingleFileExtractorListener;

  explicit SingleFileExtractorListenerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnProgress(uint64_t total_bytes, uint64_t progress_bytes) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  SingleFileExtractorStubDispatch {
 public:
  static bool Accept(SingleFileExtractor* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SingleFileExtractor* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SingleFileExtractor>>
class SingleFileExtractorStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SingleFileExtractorStub() = default;
  ~SingleFileExtractorStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SingleFileExtractorStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SingleFileExtractorStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SingleFileExtractorListenerStubDispatch {
 public:
  static bool Accept(SingleFileExtractorListener* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SingleFileExtractorListener* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SingleFileExtractorListener>>
class SingleFileExtractorListenerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SingleFileExtractorListenerStub() = default;
  ~SingleFileExtractorListenerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SingleFileExtractorListenerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SingleFileExtractorListenerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SingleFileExtractorRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SingleFileExtractorListenerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SingleFileExtractorResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // chrome::mojom

namespace mojo {

}  // namespace mojo

#endif  // CHROME_SERVICES_FILE_UTIL_PUBLIC_MOJOM_SINGLE_FILE_EXTRACTOR_MOJOM_H_