// chrome/services/file_util/public/mojom/safe_archive_analyzer.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/services/file_util/public/mojom/safe_archive_analyzer.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/services/file_util/public/mojom/safe_archive_analyzer.mojom-params-data.h"
#include "chrome/services/file_util/public/mojom/safe_archive_analyzer.mojom-shared-message-ids.h"

#include "chrome/services/file_util/public/mojom/safe_archive_analyzer.mojom-import-headers.h"
#include "chrome/services/file_util/public/mojom/safe_archive_analyzer.mojom-test-utils.h"
#include "chrome/services/file_util/public/mojom/safe_archive_analyzer_param_traits.h"


namespace chrome::mojom {
// The declaration includes the definition on other builds.

SafeArchiveAnalyzer::IPCStableHashFunction SafeArchiveAnalyzer::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SafeArchiveAnalyzer>(message.name())) {
    case messages::SafeArchiveAnalyzer::kAnalyzeZipFile: {
      return &SafeArchiveAnalyzer::AnalyzeZipFile_Sym::IPCStableHash;
    }
    case messages::SafeArchiveAnalyzer::kAnalyzeDmgFile: {
      return &SafeArchiveAnalyzer::AnalyzeDmgFile_Sym::IPCStableHash;
    }
    case messages::SafeArchiveAnalyzer::kAnalyzeRarFile: {
      return &SafeArchiveAnalyzer::AnalyzeRarFile_Sym::IPCStableHash;
    }
    case messages::SafeArchiveAnalyzer::kAnalyzeSevenZipFile: {
      return &SafeArchiveAnalyzer::AnalyzeSevenZipFile_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SafeArchiveAnalyzer::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SafeArchiveAnalyzer>(message.name())) {
      case messages::SafeArchiveAnalyzer::kAnalyzeZipFile:
            return "Receive chrome::mojom::SafeArchiveAnalyzer::AnalyzeZipFile";
      case messages::SafeArchiveAnalyzer::kAnalyzeDmgFile:
            return "Receive chrome::mojom::SafeArchiveAnalyzer::AnalyzeDmgFile";
      case messages::SafeArchiveAnalyzer::kAnalyzeRarFile:
            return "Receive chrome::mojom::SafeArchiveAnalyzer::AnalyzeRarFile";
      case messages::SafeArchiveAnalyzer::kAnalyzeSevenZipFile:
            return "Receive chrome::mojom::SafeArchiveAnalyzer::AnalyzeSevenZipFile";
    }
  } else {
    switch (static_cast<messages::SafeArchiveAnalyzer>(message.name())) {
      case messages::SafeArchiveAnalyzer::kAnalyzeZipFile:
            return "Receive reply chrome::mojom::SafeArchiveAnalyzer::AnalyzeZipFile";
      case messages::SafeArchiveAnalyzer::kAnalyzeDmgFile:
            return "Receive reply chrome::mojom::SafeArchiveAnalyzer::AnalyzeDmgFile";
      case messages::SafeArchiveAnalyzer::kAnalyzeRarFile:
            return "Receive reply chrome::mojom::SafeArchiveAnalyzer::AnalyzeRarFile";
      case messages::SafeArchiveAnalyzer::kAnalyzeSevenZipFile:
            return "Receive reply chrome::mojom::SafeArchiveAnalyzer::AnalyzeSevenZipFile";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SafeArchiveAnalyzer::AnalyzeZipFile_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa3704076;  // IPCStableHash for chrome::mojom::SafeArchiveAnalyzer::AnalyzeZipFile
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SafeArchiveAnalyzer::AnalyzeDmgFile_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x869a5612;  // IPCStableHash for chrome::mojom::SafeArchiveAnalyzer::AnalyzeDmgFile
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SafeArchiveAnalyzer::AnalyzeRarFile_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xeebac14c;  // IPCStableHash for chrome::mojom::SafeArchiveAnalyzer::AnalyzeRarFile
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SafeArchiveAnalyzer::AnalyzeSevenZipFile_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4d5142d2;  // IPCStableHash for chrome::mojom::SafeArchiveAnalyzer::AnalyzeSevenZipFile
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class SafeArchiveAnalyzer_AnalyzeZipFile_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SafeArchiveAnalyzer_AnalyzeZipFile_ForwardToCallback(
      SafeArchiveAnalyzer::AnalyzeZipFileCallback callback
      ) : callback_(std::move(callback)) {
  }

  SafeArchiveAnalyzer_AnalyzeZipFile_ForwardToCallback(const SafeArchiveAnalyzer_AnalyzeZipFile_ForwardToCallback&) = delete;
  SafeArchiveAnalyzer_AnalyzeZipFile_ForwardToCallback& operator=(const SafeArchiveAnalyzer_AnalyzeZipFile_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SafeArchiveAnalyzer::AnalyzeZipFileCallback callback_;
};

class SafeArchiveAnalyzer_AnalyzeDmgFile_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SafeArchiveAnalyzer_AnalyzeDmgFile_ForwardToCallback(
      SafeArchiveAnalyzer::AnalyzeDmgFileCallback callback
      ) : callback_(std::move(callback)) {
  }

  SafeArchiveAnalyzer_AnalyzeDmgFile_ForwardToCallback(const SafeArchiveAnalyzer_AnalyzeDmgFile_ForwardToCallback&) = delete;
  SafeArchiveAnalyzer_AnalyzeDmgFile_ForwardToCallback& operator=(const SafeArchiveAnalyzer_AnalyzeDmgFile_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SafeArchiveAnalyzer::AnalyzeDmgFileCallback callback_;
};

class SafeArchiveAnalyzer_AnalyzeRarFile_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SafeArchiveAnalyzer_AnalyzeRarFile_ForwardToCallback(
      SafeArchiveAnalyzer::AnalyzeRarFileCallback callback
      ) : callback_(std::move(callback)) {
  }

  SafeArchiveAnalyzer_AnalyzeRarFile_ForwardToCallback(const SafeArchiveAnalyzer_AnalyzeRarFile_ForwardToCallback&) = delete;
  SafeArchiveAnalyzer_AnalyzeRarFile_ForwardToCallback& operator=(const SafeArchiveAnalyzer_AnalyzeRarFile_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SafeArchiveAnalyzer::AnalyzeRarFileCallback callback_;
};

class SafeArchiveAnalyzer_AnalyzeSevenZipFile_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SafeArchiveAnalyzer_AnalyzeSevenZipFile_ForwardToCallback(
      SafeArchiveAnalyzer::AnalyzeSevenZipFileCallback callback
      ) : callback_(std::move(callback)) {
  }

  SafeArchiveAnalyzer_AnalyzeSevenZipFile_ForwardToCallback(const SafeArchiveAnalyzer_AnalyzeSevenZipFile_ForwardToCallback&) = delete;
  SafeArchiveAnalyzer_AnalyzeSevenZipFile_ForwardToCallback& operator=(const SafeArchiveAnalyzer_AnalyzeSevenZipFile_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SafeArchiveAnalyzer::AnalyzeSevenZipFileCallback callback_;
};

SafeArchiveAnalyzerProxy::SafeArchiveAnalyzerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SafeArchiveAnalyzerProxy::AnalyzeZipFile(
    ::base::File in_zip_file, const std::optional<std::string>& in_password, ::mojo::PendingRemote<TemporaryFileGetter> in_temp_file_getter, AnalyzeZipFileCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::SafeArchiveAnalyzer::AnalyzeZipFile", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("zip_file"), in_zip_file,
                        "<value of type ::base::File>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("password"), in_password,
                        "<value of type const std::optional<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("temp_file_getter"), in_temp_file_getter,
                        "<value of type ::mojo::PendingRemote<TemporaryFileGetter>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SafeArchiveAnalyzer::kAnalyzeZipFile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::SafeArchiveAnalyzer_AnalyzeZipFile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->zip_file)::BaseType> zip_file_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlyFileDataView>(
    in_zip_file,
    zip_file_fragment);

  params->zip_file.Set(
      zip_file_fragment.is_null() ? nullptr : zip_file_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->zip_file.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null zip_file in SafeArchiveAnalyzer.AnalyzeZipFile request");
  mojo::internal::MessageFragment<
      typename decltype(params->password)::BaseType> password_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_password,
    password_fragment);

  params->password.Set(
      password_fragment.is_null() ? nullptr : password_fragment.data());

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::chrome::mojom::TemporaryFileGetterInterfaceBase>>(
    in_temp_file_getter,
    &params->temp_file_getter,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->temp_file_getter)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid temp_file_getter in SafeArchiveAnalyzer.AnalyzeZipFile request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SafeArchiveAnalyzer::Name_);
  message.set_method_name("AnalyzeZipFile");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SafeArchiveAnalyzer_AnalyzeZipFile_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SafeArchiveAnalyzerProxy::AnalyzeDmgFile(
    ::base::File in_dmg_file, ::mojo::PendingRemote<TemporaryFileGetter> in_temp_file_getter, AnalyzeDmgFileCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::SafeArchiveAnalyzer::AnalyzeDmgFile", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("dmg_file"), in_dmg_file,
                        "<value of type ::base::File>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("temp_file_getter"), in_temp_file_getter,
                        "<value of type ::mojo::PendingRemote<TemporaryFileGetter>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SafeArchiveAnalyzer::kAnalyzeDmgFile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::SafeArchiveAnalyzer_AnalyzeDmgFile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->dmg_file)::BaseType> dmg_file_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlyFileDataView>(
    in_dmg_file,
    dmg_file_fragment);

  params->dmg_file.Set(
      dmg_file_fragment.is_null() ? nullptr : dmg_file_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->dmg_file.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null dmg_file in SafeArchiveAnalyzer.AnalyzeDmgFile request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::chrome::mojom::TemporaryFileGetterInterfaceBase>>(
    in_temp_file_getter,
    &params->temp_file_getter,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->temp_file_getter)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid temp_file_getter in SafeArchiveAnalyzer.AnalyzeDmgFile request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SafeArchiveAnalyzer::Name_);
  message.set_method_name("AnalyzeDmgFile");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SafeArchiveAnalyzer_AnalyzeDmgFile_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SafeArchiveAnalyzerProxy::AnalyzeRarFile(
    ::base::File in_rar_file, const std::optional<std::string>& in_password, ::mojo::PendingRemote<TemporaryFileGetter> in_temp_file_getter, AnalyzeRarFileCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::SafeArchiveAnalyzer::AnalyzeRarFile", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("rar_file"), in_rar_file,
                        "<value of type ::base::File>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("password"), in_password,
                        "<value of type const std::optional<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("temp_file_getter"), in_temp_file_getter,
                        "<value of type ::mojo::PendingRemote<TemporaryFileGetter>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SafeArchiveAnalyzer::kAnalyzeRarFile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::SafeArchiveAnalyzer_AnalyzeRarFile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->rar_file)::BaseType> rar_file_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlyFileDataView>(
    in_rar_file,
    rar_file_fragment);

  params->rar_file.Set(
      rar_file_fragment.is_null() ? nullptr : rar_file_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->rar_file.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null rar_file in SafeArchiveAnalyzer.AnalyzeRarFile request");
  mojo::internal::MessageFragment<
      typename decltype(params->password)::BaseType> password_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_password,
    password_fragment);

  params->password.Set(
      password_fragment.is_null() ? nullptr : password_fragment.data());

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::chrome::mojom::TemporaryFileGetterInterfaceBase>>(
    in_temp_file_getter,
    &params->temp_file_getter,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->temp_file_getter)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid temp_file_getter in SafeArchiveAnalyzer.AnalyzeRarFile request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SafeArchiveAnalyzer::Name_);
  message.set_method_name("AnalyzeRarFile");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SafeArchiveAnalyzer_AnalyzeRarFile_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SafeArchiveAnalyzerProxy::AnalyzeSevenZipFile(
    ::base::File in_seven_zip_file, ::mojo::PendingRemote<TemporaryFileGetter> in_temp_file_getter, AnalyzeSevenZipFileCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::SafeArchiveAnalyzer::AnalyzeSevenZipFile", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("seven_zip_file"), in_seven_zip_file,
                        "<value of type ::base::File>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("temp_file_getter"), in_temp_file_getter,
                        "<value of type ::mojo::PendingRemote<TemporaryFileGetter>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SafeArchiveAnalyzer::kAnalyzeSevenZipFile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::SafeArchiveAnalyzer_AnalyzeSevenZipFile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->seven_zip_file)::BaseType> seven_zip_file_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlyFileDataView>(
    in_seven_zip_file,
    seven_zip_file_fragment);

  params->seven_zip_file.Set(
      seven_zip_file_fragment.is_null() ? nullptr : seven_zip_file_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->seven_zip_file.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null seven_zip_file in SafeArchiveAnalyzer.AnalyzeSevenZipFile request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::chrome::mojom::TemporaryFileGetterInterfaceBase>>(
    in_temp_file_getter,
    &params->temp_file_getter,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->temp_file_getter)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid temp_file_getter in SafeArchiveAnalyzer.AnalyzeSevenZipFile request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SafeArchiveAnalyzer::Name_);
  message.set_method_name("AnalyzeSevenZipFile");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SafeArchiveAnalyzer_AnalyzeSevenZipFile_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class SafeArchiveAnalyzer_AnalyzeZipFile_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SafeArchiveAnalyzer::AnalyzeZipFileCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SafeArchiveAnalyzer_AnalyzeZipFile_ProxyToResponder> proxy(
        new SafeArchiveAnalyzer_AnalyzeZipFile_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SafeArchiveAnalyzer_AnalyzeZipFile_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SafeArchiveAnalyzer_AnalyzeZipFile_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SafeArchiveAnalyzer_AnalyzeZipFile_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "SafeArchiveAnalyzer::AnalyzeZipFileCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::safe_browsing::ArchiveAnalyzerResults& in_results);
};

bool SafeArchiveAnalyzer_AnalyzeZipFile_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SafeArchiveAnalyzer_AnalyzeZipFile_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SafeArchiveAnalyzer_AnalyzeZipFile_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SafeArchiveAnalyzer.0
  bool success = true;
  ::safe_browsing::ArchiveAnalyzerResults p_results{};
  SafeArchiveAnalyzer_AnalyzeZipFile_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResults(&p_results))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SafeArchiveAnalyzer::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_results));
  }
  return true;
}

void SafeArchiveAnalyzer_AnalyzeZipFile_ProxyToResponder::Run(
    const ::safe_browsing::ArchiveAnalyzerResults& in_results) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply chrome::mojom::SafeArchiveAnalyzer::AnalyzeZipFile", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("results"), in_results,
                        "<value of type const ::safe_browsing::ArchiveAnalyzerResults&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SafeArchiveAnalyzer::kAnalyzeZipFile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::SafeArchiveAnalyzer_AnalyzeZipFile_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->results)::BaseType> results_fragment(
          params.message());
  
  mojo::internal::Serialize<::chrome::mojom::SafeArchiveAnalyzerResultsDataView>(
    in_results,
    results_fragment);

  params->results.Set(
      results_fragment.is_null() ? nullptr : results_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->results.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null results in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SafeArchiveAnalyzer::Name_);
  message.set_method_name("AnalyzeZipFile");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SafeArchiveAnalyzer_AnalyzeDmgFile_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SafeArchiveAnalyzer::AnalyzeDmgFileCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SafeArchiveAnalyzer_AnalyzeDmgFile_ProxyToResponder> proxy(
        new SafeArchiveAnalyzer_AnalyzeDmgFile_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SafeArchiveAnalyzer_AnalyzeDmgFile_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SafeArchiveAnalyzer_AnalyzeDmgFile_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SafeArchiveAnalyzer_AnalyzeDmgFile_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "SafeArchiveAnalyzer::AnalyzeDmgFileCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::safe_browsing::ArchiveAnalyzerResults& in_results);
};

bool SafeArchiveAnalyzer_AnalyzeDmgFile_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SafeArchiveAnalyzer_AnalyzeDmgFile_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SafeArchiveAnalyzer_AnalyzeDmgFile_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SafeArchiveAnalyzer.1
  bool success = true;
  ::safe_browsing::ArchiveAnalyzerResults p_results{};
  SafeArchiveAnalyzer_AnalyzeDmgFile_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResults(&p_results))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SafeArchiveAnalyzer::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_results));
  }
  return true;
}

void SafeArchiveAnalyzer_AnalyzeDmgFile_ProxyToResponder::Run(
    const ::safe_browsing::ArchiveAnalyzerResults& in_results) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply chrome::mojom::SafeArchiveAnalyzer::AnalyzeDmgFile", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("results"), in_results,
                        "<value of type const ::safe_browsing::ArchiveAnalyzerResults&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SafeArchiveAnalyzer::kAnalyzeDmgFile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::SafeArchiveAnalyzer_AnalyzeDmgFile_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->results)::BaseType> results_fragment(
          params.message());
  
  mojo::internal::Serialize<::chrome::mojom::SafeArchiveAnalyzerResultsDataView>(
    in_results,
    results_fragment);

  params->results.Set(
      results_fragment.is_null() ? nullptr : results_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->results.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null results in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SafeArchiveAnalyzer::Name_);
  message.set_method_name("AnalyzeDmgFile");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SafeArchiveAnalyzer_AnalyzeRarFile_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SafeArchiveAnalyzer::AnalyzeRarFileCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SafeArchiveAnalyzer_AnalyzeRarFile_ProxyToResponder> proxy(
        new SafeArchiveAnalyzer_AnalyzeRarFile_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SafeArchiveAnalyzer_AnalyzeRarFile_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SafeArchiveAnalyzer_AnalyzeRarFile_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SafeArchiveAnalyzer_AnalyzeRarFile_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "SafeArchiveAnalyzer::AnalyzeRarFileCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::safe_browsing::ArchiveAnalyzerResults& in_results);
};

bool SafeArchiveAnalyzer_AnalyzeRarFile_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SafeArchiveAnalyzer_AnalyzeRarFile_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SafeArchiveAnalyzer_AnalyzeRarFile_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SafeArchiveAnalyzer.2
  bool success = true;
  ::safe_browsing::ArchiveAnalyzerResults p_results{};
  SafeArchiveAnalyzer_AnalyzeRarFile_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResults(&p_results))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SafeArchiveAnalyzer::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_results));
  }
  return true;
}

void SafeArchiveAnalyzer_AnalyzeRarFile_ProxyToResponder::Run(
    const ::safe_browsing::ArchiveAnalyzerResults& in_results) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply chrome::mojom::SafeArchiveAnalyzer::AnalyzeRarFile", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("results"), in_results,
                        "<value of type const ::safe_browsing::ArchiveAnalyzerResults&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SafeArchiveAnalyzer::kAnalyzeRarFile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::SafeArchiveAnalyzer_AnalyzeRarFile_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->results)::BaseType> results_fragment(
          params.message());
  
  mojo::internal::Serialize<::chrome::mojom::SafeArchiveAnalyzerResultsDataView>(
    in_results,
    results_fragment);

  params->results.Set(
      results_fragment.is_null() ? nullptr : results_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->results.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null results in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SafeArchiveAnalyzer::Name_);
  message.set_method_name("AnalyzeRarFile");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SafeArchiveAnalyzer_AnalyzeSevenZipFile_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SafeArchiveAnalyzer::AnalyzeSevenZipFileCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SafeArchiveAnalyzer_AnalyzeSevenZipFile_ProxyToResponder> proxy(
        new SafeArchiveAnalyzer_AnalyzeSevenZipFile_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SafeArchiveAnalyzer_AnalyzeSevenZipFile_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SafeArchiveAnalyzer_AnalyzeSevenZipFile_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SafeArchiveAnalyzer_AnalyzeSevenZipFile_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "SafeArchiveAnalyzer::AnalyzeSevenZipFileCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::safe_browsing::ArchiveAnalyzerResults& in_results);
};

bool SafeArchiveAnalyzer_AnalyzeSevenZipFile_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SafeArchiveAnalyzer_AnalyzeSevenZipFile_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SafeArchiveAnalyzer_AnalyzeSevenZipFile_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SafeArchiveAnalyzer.3
  bool success = true;
  ::safe_browsing::ArchiveAnalyzerResults p_results{};
  SafeArchiveAnalyzer_AnalyzeSevenZipFile_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResults(&p_results))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SafeArchiveAnalyzer::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_results));
  }
  return true;
}

void SafeArchiveAnalyzer_AnalyzeSevenZipFile_ProxyToResponder::Run(
    const ::safe_browsing::ArchiveAnalyzerResults& in_results) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply chrome::mojom::SafeArchiveAnalyzer::AnalyzeSevenZipFile", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("results"), in_results,
                        "<value of type const ::safe_browsing::ArchiveAnalyzerResults&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SafeArchiveAnalyzer::kAnalyzeSevenZipFile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::SafeArchiveAnalyzer_AnalyzeSevenZipFile_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->results)::BaseType> results_fragment(
          params.message());
  
  mojo::internal::Serialize<::chrome::mojom::SafeArchiveAnalyzerResultsDataView>(
    in_results,
    results_fragment);

  params->results.Set(
      results_fragment.is_null() ? nullptr : results_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->results.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null results in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SafeArchiveAnalyzer::Name_);
  message.set_method_name("AnalyzeSevenZipFile");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool SafeArchiveAnalyzerStubDispatch::Accept(
    SafeArchiveAnalyzer* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SafeArchiveAnalyzer>(message->header()->name)) {
    case messages::SafeArchiveAnalyzer::kAnalyzeZipFile: {
      break;
    }
    case messages::SafeArchiveAnalyzer::kAnalyzeDmgFile: {
      break;
    }
    case messages::SafeArchiveAnalyzer::kAnalyzeRarFile: {
      break;
    }
    case messages::SafeArchiveAnalyzer::kAnalyzeSevenZipFile: {
      break;
    }
  }
  return false;
}

// static
bool SafeArchiveAnalyzerStubDispatch::AcceptWithResponder(
    SafeArchiveAnalyzer* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SafeArchiveAnalyzer>(message->header()->name)) {
    case messages::SafeArchiveAnalyzer::kAnalyzeZipFile: {
      internal::SafeArchiveAnalyzer_AnalyzeZipFile_Params_Data* params =
          reinterpret_cast<
              internal::SafeArchiveAnalyzer_AnalyzeZipFile_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SafeArchiveAnalyzer.0
      bool success = true;
      ::base::File p_zip_file{};
      std::optional<std::string> p_password{};
      ::mojo::PendingRemote<TemporaryFileGetter> p_temp_file_getter{};
      SafeArchiveAnalyzer_AnalyzeZipFile_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadZipFile(&p_zip_file))
        success = false;
      if (success && !input_data_view.ReadPassword(&p_password))
        success = false;
      if (success) {
        p_temp_file_getter =
            input_data_view.TakeTempFileGetter<decltype(p_temp_file_getter)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SafeArchiveAnalyzer::Name_, 0, false);
        return false;
      }
      auto callback =
          SafeArchiveAnalyzer_AnalyzeZipFile_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AnalyzeZipFile(        
        std::move(p_zip_file), 
        std::move(p_password), 
        std::move(p_temp_file_getter), std::move(callback));
      return true;
    }
    case messages::SafeArchiveAnalyzer::kAnalyzeDmgFile: {
      internal::SafeArchiveAnalyzer_AnalyzeDmgFile_Params_Data* params =
          reinterpret_cast<
              internal::SafeArchiveAnalyzer_AnalyzeDmgFile_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SafeArchiveAnalyzer.1
      bool success = true;
      ::base::File p_dmg_file{};
      ::mojo::PendingRemote<TemporaryFileGetter> p_temp_file_getter{};
      SafeArchiveAnalyzer_AnalyzeDmgFile_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDmgFile(&p_dmg_file))
        success = false;
      if (success) {
        p_temp_file_getter =
            input_data_view.TakeTempFileGetter<decltype(p_temp_file_getter)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SafeArchiveAnalyzer::Name_, 1, false);
        return false;
      }
      auto callback =
          SafeArchiveAnalyzer_AnalyzeDmgFile_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AnalyzeDmgFile(        
        std::move(p_dmg_file), 
        std::move(p_temp_file_getter), std::move(callback));
      return true;
    }
    case messages::SafeArchiveAnalyzer::kAnalyzeRarFile: {
      internal::SafeArchiveAnalyzer_AnalyzeRarFile_Params_Data* params =
          reinterpret_cast<
              internal::SafeArchiveAnalyzer_AnalyzeRarFile_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SafeArchiveAnalyzer.2
      bool success = true;
      ::base::File p_rar_file{};
      std::optional<std::string> p_password{};
      ::mojo::PendingRemote<TemporaryFileGetter> p_temp_file_getter{};
      SafeArchiveAnalyzer_AnalyzeRarFile_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRarFile(&p_rar_file))
        success = false;
      if (success && !input_data_view.ReadPassword(&p_password))
        success = false;
      if (success) {
        p_temp_file_getter =
            input_data_view.TakeTempFileGetter<decltype(p_temp_file_getter)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SafeArchiveAnalyzer::Name_, 2, false);
        return false;
      }
      auto callback =
          SafeArchiveAnalyzer_AnalyzeRarFile_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AnalyzeRarFile(        
        std::move(p_rar_file), 
        std::move(p_password), 
        std::move(p_temp_file_getter), std::move(callback));
      return true;
    }
    case messages::SafeArchiveAnalyzer::kAnalyzeSevenZipFile: {
      internal::SafeArchiveAnalyzer_AnalyzeSevenZipFile_Params_Data* params =
          reinterpret_cast<
              internal::SafeArchiveAnalyzer_AnalyzeSevenZipFile_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SafeArchiveAnalyzer.3
      bool success = true;
      ::base::File p_seven_zip_file{};
      ::mojo::PendingRemote<TemporaryFileGetter> p_temp_file_getter{};
      SafeArchiveAnalyzer_AnalyzeSevenZipFile_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSevenZipFile(&p_seven_zip_file))
        success = false;
      if (success) {
        p_temp_file_getter =
            input_data_view.TakeTempFileGetter<decltype(p_temp_file_getter)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SafeArchiveAnalyzer::Name_, 3, false);
        return false;
      }
      auto callback =
          SafeArchiveAnalyzer_AnalyzeSevenZipFile_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AnalyzeSevenZipFile(        
        std::move(p_seven_zip_file), 
        std::move(p_temp_file_getter), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSafeArchiveAnalyzerValidationInfo[] = {
    { &internal::SafeArchiveAnalyzer_AnalyzeZipFile_Params_Data::Validate,
     &internal::SafeArchiveAnalyzer_AnalyzeZipFile_ResponseParams_Data::Validate},
    { &internal::SafeArchiveAnalyzer_AnalyzeDmgFile_Params_Data::Validate,
     &internal::SafeArchiveAnalyzer_AnalyzeDmgFile_ResponseParams_Data::Validate},
    { &internal::SafeArchiveAnalyzer_AnalyzeRarFile_Params_Data::Validate,
     &internal::SafeArchiveAnalyzer_AnalyzeRarFile_ResponseParams_Data::Validate},
    { &internal::SafeArchiveAnalyzer_AnalyzeSevenZipFile_Params_Data::Validate,
     &internal::SafeArchiveAnalyzer_AnalyzeSevenZipFile_ResponseParams_Data::Validate},
};

bool SafeArchiveAnalyzerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::chrome::mojom::SafeArchiveAnalyzer::Name_,
    kSafeArchiveAnalyzerValidationInfo);
}

bool SafeArchiveAnalyzerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::chrome::mojom::SafeArchiveAnalyzer::Name_,
    kSafeArchiveAnalyzerValidationInfo);
}
// The declaration includes the definition on other builds.

TemporaryFileGetter::IPCStableHashFunction TemporaryFileGetter::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::TemporaryFileGetter>(message.name())) {
    case messages::TemporaryFileGetter::kRequestTemporaryFile: {
      return &TemporaryFileGetter::RequestTemporaryFile_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* TemporaryFileGetter::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::TemporaryFileGetter>(message.name())) {
      case messages::TemporaryFileGetter::kRequestTemporaryFile:
            return "Receive chrome::mojom::TemporaryFileGetter::RequestTemporaryFile";
    }
  } else {
    switch (static_cast<messages::TemporaryFileGetter>(message.name())) {
      case messages::TemporaryFileGetter::kRequestTemporaryFile:
            return "Receive reply chrome::mojom::TemporaryFileGetter::RequestTemporaryFile";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t TemporaryFileGetter::RequestTemporaryFile_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x18ff97f8;  // IPCStableHash for chrome::mojom::TemporaryFileGetter::RequestTemporaryFile
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class TemporaryFileGetter_RequestTemporaryFile_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  TemporaryFileGetter_RequestTemporaryFile_ForwardToCallback(
      TemporaryFileGetter::RequestTemporaryFileCallback callback
      ) : callback_(std::move(callback)) {
  }

  TemporaryFileGetter_RequestTemporaryFile_ForwardToCallback(const TemporaryFileGetter_RequestTemporaryFile_ForwardToCallback&) = delete;
  TemporaryFileGetter_RequestTemporaryFile_ForwardToCallback& operator=(const TemporaryFileGetter_RequestTemporaryFile_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  TemporaryFileGetter::RequestTemporaryFileCallback callback_;
};

TemporaryFileGetterProxy::TemporaryFileGetterProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void TemporaryFileGetterProxy::RequestTemporaryFile(
    RequestTemporaryFileCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send chrome::mojom::TemporaryFileGetter::RequestTemporaryFile");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TemporaryFileGetter::kRequestTemporaryFile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::TemporaryFileGetter_RequestTemporaryFile_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TemporaryFileGetter::Name_);
  message.set_method_name("RequestTemporaryFile");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TemporaryFileGetter_RequestTemporaryFile_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class TemporaryFileGetter_RequestTemporaryFile_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static TemporaryFileGetter::RequestTemporaryFileCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<TemporaryFileGetter_RequestTemporaryFile_ProxyToResponder> proxy(
        new TemporaryFileGetter_RequestTemporaryFile_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&TemporaryFileGetter_RequestTemporaryFile_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~TemporaryFileGetter_RequestTemporaryFile_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  TemporaryFileGetter_RequestTemporaryFile_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "TemporaryFileGetter::RequestTemporaryFileCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::File in_temp_file);
};

bool TemporaryFileGetter_RequestTemporaryFile_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::TemporaryFileGetter_RequestTemporaryFile_ResponseParams_Data* params =
      reinterpret_cast<
          internal::TemporaryFileGetter_RequestTemporaryFile_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for TemporaryFileGetter.0
  bool success = true;
  ::base::File p_temp_file{};
  TemporaryFileGetter_RequestTemporaryFile_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadTempFile(&p_temp_file))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TemporaryFileGetter::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_temp_file));
  }
  return true;
}

void TemporaryFileGetter_RequestTemporaryFile_ProxyToResponder::Run(
    ::base::File in_temp_file) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply chrome::mojom::TemporaryFileGetter::RequestTemporaryFile", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("temp_file"), in_temp_file,
                        "<value of type ::base::File>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TemporaryFileGetter::kRequestTemporaryFile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::TemporaryFileGetter_RequestTemporaryFile_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->temp_file)::BaseType> temp_file_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::FileDataView>(
    in_temp_file,
    temp_file_fragment);

  params->temp_file.Set(
      temp_file_fragment.is_null() ? nullptr : temp_file_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TemporaryFileGetter::Name_);
  message.set_method_name("RequestTemporaryFile");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool TemporaryFileGetterStubDispatch::Accept(
    TemporaryFileGetter* impl,
    mojo::Message* message) {
  switch (static_cast<messages::TemporaryFileGetter>(message->header()->name)) {
    case messages::TemporaryFileGetter::kRequestTemporaryFile: {
      break;
    }
  }
  return false;
}

// static
bool TemporaryFileGetterStubDispatch::AcceptWithResponder(
    TemporaryFileGetter* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::TemporaryFileGetter>(message->header()->name)) {
    case messages::TemporaryFileGetter::kRequestTemporaryFile: {
      internal::TemporaryFileGetter_RequestTemporaryFile_Params_Data* params =
          reinterpret_cast<
              internal::TemporaryFileGetter_RequestTemporaryFile_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for TemporaryFileGetter.0
      bool success = true;
      TemporaryFileGetter_RequestTemporaryFile_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TemporaryFileGetter::Name_, 0, false);
        return false;
      }
      auto callback =
          TemporaryFileGetter_RequestTemporaryFile_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestTemporaryFile(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kTemporaryFileGetterValidationInfo[] = {
    { &internal::TemporaryFileGetter_RequestTemporaryFile_Params_Data::Validate,
     &internal::TemporaryFileGetter_RequestTemporaryFile_ResponseParams_Data::Validate},
};

bool TemporaryFileGetterRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::chrome::mojom::TemporaryFileGetter::Name_,
    kTemporaryFileGetterValidationInfo);
}

bool TemporaryFileGetterResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::chrome::mojom::TemporaryFileGetter::Name_,
    kTemporaryFileGetterValidationInfo);
}


}  // chrome::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace chrome::mojom {


void SafeArchiveAnalyzerInterceptorForTesting::AnalyzeZipFile(::base::File zip_file, const std::optional<std::string>& password, ::mojo::PendingRemote<TemporaryFileGetter> temp_file_getter, AnalyzeZipFileCallback callback) {
  GetForwardingInterface()->AnalyzeZipFile(
    std::move(zip_file)
    , 
    std::move(password)
    , 
    std::move(temp_file_getter)
    , std::move(callback));
}
void SafeArchiveAnalyzerInterceptorForTesting::AnalyzeDmgFile(::base::File dmg_file, ::mojo::PendingRemote<TemporaryFileGetter> temp_file_getter, AnalyzeDmgFileCallback callback) {
  GetForwardingInterface()->AnalyzeDmgFile(
    std::move(dmg_file)
    , 
    std::move(temp_file_getter)
    , std::move(callback));
}
void SafeArchiveAnalyzerInterceptorForTesting::AnalyzeRarFile(::base::File rar_file, const std::optional<std::string>& password, ::mojo::PendingRemote<TemporaryFileGetter> temp_file_getter, AnalyzeRarFileCallback callback) {
  GetForwardingInterface()->AnalyzeRarFile(
    std::move(rar_file)
    , 
    std::move(password)
    , 
    std::move(temp_file_getter)
    , std::move(callback));
}
void SafeArchiveAnalyzerInterceptorForTesting::AnalyzeSevenZipFile(::base::File seven_zip_file, ::mojo::PendingRemote<TemporaryFileGetter> temp_file_getter, AnalyzeSevenZipFileCallback callback) {
  GetForwardingInterface()->AnalyzeSevenZipFile(
    std::move(seven_zip_file)
    , 
    std::move(temp_file_getter)
    , std::move(callback));
}
SafeArchiveAnalyzerAsyncWaiter::SafeArchiveAnalyzerAsyncWaiter(
    SafeArchiveAnalyzer* proxy) : proxy_(proxy) {}

SafeArchiveAnalyzerAsyncWaiter::~SafeArchiveAnalyzerAsyncWaiter() = default;


void SafeArchiveAnalyzerAsyncWaiter::AnalyzeZipFile(
    ::base::File zip_file, const std::optional<std::string>& password, ::mojo::PendingRemote<TemporaryFileGetter> temp_file_getter, ::safe_browsing::ArchiveAnalyzerResults* out_results) {
  base::RunLoop loop;
  proxy_->AnalyzeZipFile(
      std::move(zip_file),
      std::move(password),
      std::move(temp_file_getter),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::safe_browsing::ArchiveAnalyzerResults* out_results
,
             const ::safe_browsing::ArchiveAnalyzerResults& results) {*out_results = std::move(results);
            loop->Quit();
          },
          &loop,
          out_results));
  loop.Run();
}

::safe_browsing::ArchiveAnalyzerResults SafeArchiveAnalyzerAsyncWaiter::AnalyzeZipFile(
    ::base::File zip_file, const std::optional<std::string>& password, ::mojo::PendingRemote<TemporaryFileGetter> temp_file_getter) {
  ::safe_browsing::ArchiveAnalyzerResults async_wait_result;
  AnalyzeZipFile(std::move(zip_file),std::move(password),std::move(temp_file_getter),&async_wait_result);
  return async_wait_result;
}

void SafeArchiveAnalyzerAsyncWaiter::AnalyzeDmgFile(
    ::base::File dmg_file, ::mojo::PendingRemote<TemporaryFileGetter> temp_file_getter, ::safe_browsing::ArchiveAnalyzerResults* out_results) {
  base::RunLoop loop;
  proxy_->AnalyzeDmgFile(
      std::move(dmg_file),
      std::move(temp_file_getter),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::safe_browsing::ArchiveAnalyzerResults* out_results
,
             const ::safe_browsing::ArchiveAnalyzerResults& results) {*out_results = std::move(results);
            loop->Quit();
          },
          &loop,
          out_results));
  loop.Run();
}

::safe_browsing::ArchiveAnalyzerResults SafeArchiveAnalyzerAsyncWaiter::AnalyzeDmgFile(
    ::base::File dmg_file, ::mojo::PendingRemote<TemporaryFileGetter> temp_file_getter) {
  ::safe_browsing::ArchiveAnalyzerResults async_wait_result;
  AnalyzeDmgFile(std::move(dmg_file),std::move(temp_file_getter),&async_wait_result);
  return async_wait_result;
}

void SafeArchiveAnalyzerAsyncWaiter::AnalyzeRarFile(
    ::base::File rar_file, const std::optional<std::string>& password, ::mojo::PendingRemote<TemporaryFileGetter> temp_file_getter, ::safe_browsing::ArchiveAnalyzerResults* out_results) {
  base::RunLoop loop;
  proxy_->AnalyzeRarFile(
      std::move(rar_file),
      std::move(password),
      std::move(temp_file_getter),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::safe_browsing::ArchiveAnalyzerResults* out_results
,
             const ::safe_browsing::ArchiveAnalyzerResults& results) {*out_results = std::move(results);
            loop->Quit();
          },
          &loop,
          out_results));
  loop.Run();
}

::safe_browsing::ArchiveAnalyzerResults SafeArchiveAnalyzerAsyncWaiter::AnalyzeRarFile(
    ::base::File rar_file, const std::optional<std::string>& password, ::mojo::PendingRemote<TemporaryFileGetter> temp_file_getter) {
  ::safe_browsing::ArchiveAnalyzerResults async_wait_result;
  AnalyzeRarFile(std::move(rar_file),std::move(password),std::move(temp_file_getter),&async_wait_result);
  return async_wait_result;
}

void SafeArchiveAnalyzerAsyncWaiter::AnalyzeSevenZipFile(
    ::base::File seven_zip_file, ::mojo::PendingRemote<TemporaryFileGetter> temp_file_getter, ::safe_browsing::ArchiveAnalyzerResults* out_results) {
  base::RunLoop loop;
  proxy_->AnalyzeSevenZipFile(
      std::move(seven_zip_file),
      std::move(temp_file_getter),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::safe_browsing::ArchiveAnalyzerResults* out_results
,
             const ::safe_browsing::ArchiveAnalyzerResults& results) {*out_results = std::move(results);
            loop->Quit();
          },
          &loop,
          out_results));
  loop.Run();
}

::safe_browsing::ArchiveAnalyzerResults SafeArchiveAnalyzerAsyncWaiter::AnalyzeSevenZipFile(
    ::base::File seven_zip_file, ::mojo::PendingRemote<TemporaryFileGetter> temp_file_getter) {
  ::safe_browsing::ArchiveAnalyzerResults async_wait_result;
  AnalyzeSevenZipFile(std::move(seven_zip_file),std::move(temp_file_getter),&async_wait_result);
  return async_wait_result;
}




void TemporaryFileGetterInterceptorForTesting::RequestTemporaryFile(RequestTemporaryFileCallback callback) {
  GetForwardingInterface()->RequestTemporaryFile(std::move(callback));
}
TemporaryFileGetterAsyncWaiter::TemporaryFileGetterAsyncWaiter(
    TemporaryFileGetter* proxy) : proxy_(proxy) {}

TemporaryFileGetterAsyncWaiter::~TemporaryFileGetterAsyncWaiter() = default;


void TemporaryFileGetterAsyncWaiter::RequestTemporaryFile(
    ::base::File* out_temp_file) {
  base::RunLoop loop;
  proxy_->RequestTemporaryFile(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::File* out_temp_file
,
             ::base::File temp_file) {*out_temp_file = std::move(temp_file);
            loop->Quit();
          },
          &loop,
          out_temp_file));
  loop.Run();
}

::base::File TemporaryFileGetterAsyncWaiter::RequestTemporaryFile(
    ) {
  ::base::File async_wait_result;
  RequestTemporaryFile(&async_wait_result);
  return async_wait_result;
}






}  // chrome::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif