// chrome/common/supervised_user_commands.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_COMMON_SUPERVISED_USER_COMMANDS_MOJOM_H_
#define CHROME_COMMON_SUPERVISED_USER_COMMANDS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/common/supervised_user_commands.mojom-features.h"  // IWYU pragma: export
#include "chrome/common/supervised_user_commands.mojom-shared.h"  // IWYU pragma: export
#include "chrome/common/supervised_user_commands.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace supervised_user::mojom {

class SupervisedUserCommandsProxy;

template <typename ImplRefTraits>
class SupervisedUserCommandsStub;

class SupervisedUserCommandsRequestValidator;
class SupervisedUserCommandsResponseValidator;


class SupervisedUserCommands
    : public SupervisedUserCommandsInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "supervised_user.mojom.SupervisedUserCommands";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SupervisedUserCommandsInterfaceBase;
  using Proxy_ = SupervisedUserCommandsProxy;

  template <typename ImplRefTraits>
  using Stub_ = SupervisedUserCommandsStub<ImplRefTraits>;

  using RequestValidator_ = SupervisedUserCommandsRequestValidator;
  using ResponseValidator_ = SupervisedUserCommandsResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGoBackMinVersion = 0,
    kRequestUrlAccessRemoteMinVersion = 0,
    kRequestUrlAccessLocalMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GoBack_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestUrlAccessRemote_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestUrlAccessLocal_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SupervisedUserCommands() = default;

  virtual void GoBack() = 0;

  using RequestUrlAccessRemoteCallback = base::OnceCallback<void(bool)>;
  using RequestUrlAccessRemoteMojoCallback = base::OnceCallback<void(bool)>;

  virtual void RequestUrlAccessRemote(RequestUrlAccessRemoteCallback callback) = 0;

  using RequestUrlAccessLocalCallback = base::OnceCallback<void(bool)>;
  using RequestUrlAccessLocalMojoCallback = base::OnceCallback<void(bool)>;

  virtual void RequestUrlAccessLocal(RequestUrlAccessLocalCallback callback) = 0;
};



class  SupervisedUserCommandsProxy
    : public SupervisedUserCommands {
 public:
  using InterfaceType = SupervisedUserCommands;

  explicit SupervisedUserCommandsProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GoBack() final;
  
  void RequestUrlAccessRemote(RequestUrlAccessRemoteCallback callback) final;
  
  void RequestUrlAccessLocal(RequestUrlAccessLocalCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  SupervisedUserCommandsStubDispatch {
 public:
  static bool Accept(SupervisedUserCommands* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SupervisedUserCommands* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SupervisedUserCommands>>
class SupervisedUserCommandsStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SupervisedUserCommandsStub() = default;
  ~SupervisedUserCommandsStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SupervisedUserCommandsStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SupervisedUserCommandsStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SupervisedUserCommandsRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SupervisedUserCommandsResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // supervised_user::mojom

namespace mojo {

}  // namespace mojo

#endif  // CHROME_COMMON_SUPERVISED_USER_COMMANDS_MOJOM_H_