// chrome/common/renderer_configuration.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/common/renderer_configuration.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/common/renderer_configuration.mojom-params-data.h"
#include "chrome/common/renderer_configuration.mojom-shared-message-ids.h"

#include "chrome/common/renderer_configuration.mojom-import-headers.h"
#include "chrome/common/renderer_configuration.mojom-test-utils.h"


namespace chrome::mojom {
BoundSessionThrottlerParams::BoundSessionThrottlerParams()
    : domain(),
      path(),
      cookie_expiry_date() {}

BoundSessionThrottlerParams::BoundSessionThrottlerParams(
    const std::string& domain_in,
    const std::string& path_in,
    ::base::Time cookie_expiry_date_in)
    : domain(std::move(domain_in)),
      path(std::move(path_in)),
      cookie_expiry_date(std::move(cookie_expiry_date_in)) {}

BoundSessionThrottlerParams::~BoundSessionThrottlerParams() = default;

void BoundSessionThrottlerParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "domain"), this->domain,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "path"), this->path,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cookie_expiry_date"), this->cookie_expiry_date,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Time>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BoundSessionThrottlerParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DynamicParams::DynamicParams()
    : bound_session_throttler_params(),
      force_safe_search(true),
      youtube_restrict(0),
      allowed_domains_for_apps() {}

DynamicParams::DynamicParams(
    std::vector<BoundSessionThrottlerParamsPtr> bound_session_throttler_params_in,
    bool force_safe_search_in,
    int32_t youtube_restrict_in,
    const std::string& allowed_domains_for_apps_in)
    : bound_session_throttler_params(std::move(bound_session_throttler_params_in)),
      force_safe_search(std::move(force_safe_search_in)),
      youtube_restrict(std::move(youtube_restrict_in)),
      allowed_domains_for_apps(std::move(allowed_domains_for_apps_in)) {}

DynamicParams::~DynamicParams() = default;

void DynamicParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bound_session_throttler_params"), this->bound_session_throttler_params,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<BoundSessionThrottlerParamsPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "force_safe_search"), this->force_safe_search,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "youtube_restrict"), this->youtube_restrict,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allowed_domains_for_apps"), this->allowed_domains_for_apps,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DynamicParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
StaticParams::StaticParams()
    : is_instant_process(false) {}

StaticParams::StaticParams(
    bool is_instant_process_in)
    : is_instant_process(std::move(is_instant_process_in)) {}

StaticParams::~StaticParams() = default;
size_t StaticParams::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->is_instant_process);
  return seed;
}

void StaticParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_instant_process"), this->is_instant_process,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool StaticParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

BoundSessionRequestThrottledHandler::IPCStableHashFunction BoundSessionRequestThrottledHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::BoundSessionRequestThrottledHandler>(message.name())) {
    case messages::BoundSessionRequestThrottledHandler::kHandleRequestBlockedOnCookie: {
      return &BoundSessionRequestThrottledHandler::HandleRequestBlockedOnCookie_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* BoundSessionRequestThrottledHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::BoundSessionRequestThrottledHandler>(message.name())) {
      case messages::BoundSessionRequestThrottledHandler::kHandleRequestBlockedOnCookie:
            return "Receive chrome::mojom::BoundSessionRequestThrottledHandler::HandleRequestBlockedOnCookie";
    }
  } else {
    switch (static_cast<messages::BoundSessionRequestThrottledHandler>(message.name())) {
      case messages::BoundSessionRequestThrottledHandler::kHandleRequestBlockedOnCookie:
            return "Receive reply chrome::mojom::BoundSessionRequestThrottledHandler::HandleRequestBlockedOnCookie";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t BoundSessionRequestThrottledHandler::HandleRequestBlockedOnCookie_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa79b39ef;  // IPCStableHash for chrome::mojom::BoundSessionRequestThrottledHandler::HandleRequestBlockedOnCookie
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class BoundSessionRequestThrottledHandler_HandleRequestBlockedOnCookie_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BoundSessionRequestThrottledHandler_HandleRequestBlockedOnCookie_ForwardToCallback(
      BoundSessionRequestThrottledHandler::HandleRequestBlockedOnCookieCallback callback
      ) : callback_(std::move(callback)) {
  }

  BoundSessionRequestThrottledHandler_HandleRequestBlockedOnCookie_ForwardToCallback(const BoundSessionRequestThrottledHandler_HandleRequestBlockedOnCookie_ForwardToCallback&) = delete;
  BoundSessionRequestThrottledHandler_HandleRequestBlockedOnCookie_ForwardToCallback& operator=(const BoundSessionRequestThrottledHandler_HandleRequestBlockedOnCookie_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  BoundSessionRequestThrottledHandler::HandleRequestBlockedOnCookieCallback callback_;
};

BoundSessionRequestThrottledHandlerProxy::BoundSessionRequestThrottledHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void BoundSessionRequestThrottledHandlerProxy::HandleRequestBlockedOnCookie(
    const ::GURL& in_untrusted_request_url, HandleRequestBlockedOnCookieCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::BoundSessionRequestThrottledHandler::HandleRequestBlockedOnCookie", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("untrusted_request_url"), in_untrusted_request_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BoundSessionRequestThrottledHandler::kHandleRequestBlockedOnCookie), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::BoundSessionRequestThrottledHandler_HandleRequestBlockedOnCookie_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->untrusted_request_url)::BaseType> untrusted_request_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_untrusted_request_url,
    untrusted_request_url_fragment);

  params->untrusted_request_url.Set(
      untrusted_request_url_fragment.is_null() ? nullptr : untrusted_request_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->untrusted_request_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null untrusted_request_url in BoundSessionRequestThrottledHandler.HandleRequestBlockedOnCookie request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BoundSessionRequestThrottledHandler::Name_);
  message.set_method_name("HandleRequestBlockedOnCookie");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BoundSessionRequestThrottledHandler_HandleRequestBlockedOnCookie_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class BoundSessionRequestThrottledHandler_HandleRequestBlockedOnCookie_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static BoundSessionRequestThrottledHandler::HandleRequestBlockedOnCookieCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<BoundSessionRequestThrottledHandler_HandleRequestBlockedOnCookie_ProxyToResponder> proxy(
        new BoundSessionRequestThrottledHandler_HandleRequestBlockedOnCookie_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&BoundSessionRequestThrottledHandler_HandleRequestBlockedOnCookie_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BoundSessionRequestThrottledHandler_HandleRequestBlockedOnCookie_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  BoundSessionRequestThrottledHandler_HandleRequestBlockedOnCookie_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "BoundSessionRequestThrottledHandler::HandleRequestBlockedOnCookieCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ResumeBlockedRequestsTrigger in_resume_trigger);
};

bool BoundSessionRequestThrottledHandler_HandleRequestBlockedOnCookie_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::BoundSessionRequestThrottledHandler_HandleRequestBlockedOnCookie_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BoundSessionRequestThrottledHandler_HandleRequestBlockedOnCookie_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for BoundSessionRequestThrottledHandler.0
  bool success = true;
  ResumeBlockedRequestsTrigger p_resume_trigger{};
  BoundSessionRequestThrottledHandler_HandleRequestBlockedOnCookie_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResumeTrigger(&p_resume_trigger))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BoundSessionRequestThrottledHandler::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_resume_trigger));
  }
  return true;
}

void BoundSessionRequestThrottledHandler_HandleRequestBlockedOnCookie_ProxyToResponder::Run(
    ResumeBlockedRequestsTrigger in_resume_trigger) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply chrome::mojom::BoundSessionRequestThrottledHandler::HandleRequestBlockedOnCookie", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("resume_trigger"), in_resume_trigger,
                        "<value of type ResumeBlockedRequestsTrigger>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BoundSessionRequestThrottledHandler::kHandleRequestBlockedOnCookie), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::BoundSessionRequestThrottledHandler_HandleRequestBlockedOnCookie_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::chrome::mojom::ResumeBlockedRequestsTrigger>(
    in_resume_trigger,
    &params->resume_trigger);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BoundSessionRequestThrottledHandler::Name_);
  message.set_method_name("HandleRequestBlockedOnCookie");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool BoundSessionRequestThrottledHandlerStubDispatch::Accept(
    BoundSessionRequestThrottledHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::BoundSessionRequestThrottledHandler>(message->header()->name)) {
    case messages::BoundSessionRequestThrottledHandler::kHandleRequestBlockedOnCookie: {
      break;
    }
  }
  return false;
}

// static
bool BoundSessionRequestThrottledHandlerStubDispatch::AcceptWithResponder(
    BoundSessionRequestThrottledHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::BoundSessionRequestThrottledHandler>(message->header()->name)) {
    case messages::BoundSessionRequestThrottledHandler::kHandleRequestBlockedOnCookie: {
      internal::BoundSessionRequestThrottledHandler_HandleRequestBlockedOnCookie_Params_Data* params =
          reinterpret_cast<
              internal::BoundSessionRequestThrottledHandler_HandleRequestBlockedOnCookie_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for BoundSessionRequestThrottledHandler.0
      bool success = true;
      ::GURL p_untrusted_request_url{};
      BoundSessionRequestThrottledHandler_HandleRequestBlockedOnCookie_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUntrustedRequestUrl(&p_untrusted_request_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BoundSessionRequestThrottledHandler::Name_, 0, false);
        return false;
      }
      auto callback =
          BoundSessionRequestThrottledHandler_HandleRequestBlockedOnCookie_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HandleRequestBlockedOnCookie(        
        std::move(p_untrusted_request_url), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kBoundSessionRequestThrottledHandlerValidationInfo[] = {
    { &internal::BoundSessionRequestThrottledHandler_HandleRequestBlockedOnCookie_Params_Data::Validate,
     &internal::BoundSessionRequestThrottledHandler_HandleRequestBlockedOnCookie_ResponseParams_Data::Validate},
};

bool BoundSessionRequestThrottledHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::chrome::mojom::BoundSessionRequestThrottledHandler::Name_,
    kBoundSessionRequestThrottledHandlerValidationInfo);
}

bool BoundSessionRequestThrottledHandlerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::chrome::mojom::BoundSessionRequestThrottledHandler::Name_,
    kBoundSessionRequestThrottledHandlerValidationInfo);
}
// The declaration includes the definition on other builds.

ChromeOSListener::IPCStableHashFunction ChromeOSListener::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ChromeOSListener::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
# endif // !BUILDFLAG(IS_FUCHSIA)

ChromeOSListenerProxy::ChromeOSListenerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

// static
bool ChromeOSListenerStubDispatch::Accept(
    ChromeOSListener* impl,
    mojo::Message* message) {
  return false;
}

// static
bool ChromeOSListenerStubDispatch::AcceptWithResponder(
    ChromeOSListener* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  return false;
}
namespace {
}  // namespace

bool ChromeOSListenerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::chrome::mojom::ChromeOSListener::Name_,
    {});
}

// The declaration includes the definition on other builds.

RendererConfiguration::IPCStableHashFunction RendererConfiguration::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::RendererConfiguration>(message.name())) {
    case messages::RendererConfiguration::kSetInitialConfiguration: {
      return &RendererConfiguration::SetInitialConfiguration_Sym::IPCStableHash;
    }
    case messages::RendererConfiguration::kSetConfiguration: {
      return &RendererConfiguration::SetConfiguration_Sym::IPCStableHash;
    }
    case messages::RendererConfiguration::kSetConfigurationOnProcessLockUpdate: {
      return &RendererConfiguration::SetConfigurationOnProcessLockUpdate_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* RendererConfiguration::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::RendererConfiguration>(message.name())) {
      case messages::RendererConfiguration::kSetInitialConfiguration:
            return "Receive chrome::mojom::RendererConfiguration::SetInitialConfiguration";
      case messages::RendererConfiguration::kSetConfiguration:
            return "Receive chrome::mojom::RendererConfiguration::SetConfiguration";
      case messages::RendererConfiguration::kSetConfigurationOnProcessLockUpdate:
            return "Receive chrome::mojom::RendererConfiguration::SetConfigurationOnProcessLockUpdate";
    }
  } else {
    switch (static_cast<messages::RendererConfiguration>(message.name())) {
      case messages::RendererConfiguration::kSetInitialConfiguration:
            return "Receive reply chrome::mojom::RendererConfiguration::SetInitialConfiguration";
      case messages::RendererConfiguration::kSetConfiguration:
            return "Receive reply chrome::mojom::RendererConfiguration::SetConfiguration";
      case messages::RendererConfiguration::kSetConfigurationOnProcessLockUpdate:
            return "Receive reply chrome::mojom::RendererConfiguration::SetConfigurationOnProcessLockUpdate";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t RendererConfiguration::SetInitialConfiguration_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7936fb72;  // IPCStableHash for chrome::mojom::RendererConfiguration::SetInitialConfiguration
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RendererConfiguration::SetConfiguration_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x81594e5c;  // IPCStableHash for chrome::mojom::RendererConfiguration::SetConfiguration
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RendererConfiguration::SetConfigurationOnProcessLockUpdate_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x19ec5bce;  // IPCStableHash for chrome::mojom::RendererConfiguration::SetConfigurationOnProcessLockUpdate
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

RendererConfigurationProxy::RendererConfigurationProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RendererConfigurationProxy::SetInitialConfiguration(
    bool in_is_incognito_process, ::mojo::PendingReceiver<ChromeOSListener> in_chromeos_listener, ::mojo::PendingRemote<::content_settings::mojom::ContentSettingsManager> in_content_settings_manager, ::mojo::PendingRemote<BoundSessionRequestThrottledHandler> in_bound_session_request_throttled_handler) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::RendererConfiguration::SetInitialConfiguration", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_incognito_process"), in_is_incognito_process,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("chromeos_listener"), in_chromeos_listener,
                        "<value of type ::mojo::PendingReceiver<ChromeOSListener>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("content_settings_manager"), in_content_settings_manager,
                        "<value of type ::mojo::PendingRemote<::content_settings::mojom::ContentSettingsManager>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bound_session_request_throttled_handler"), in_bound_session_request_throttled_handler,
                        "<value of type ::mojo::PendingRemote<BoundSessionRequestThrottledHandler>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RendererConfiguration::kSetInitialConfiguration), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::RendererConfiguration_SetInitialConfiguration_Params_Data> params(
          message);
  params.Allocate();

  params->is_incognito_process = in_is_incognito_process;

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::chrome::mojom::ChromeOSListenerInterfaceBase>>(
    in_chromeos_listener,
    &params->chromeos_listener,
    &params.message());

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::content_settings::mojom::ContentSettingsManagerInterfaceBase>>(
    in_content_settings_manager,
    &params->content_settings_manager,
    &params.message());

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::chrome::mojom::BoundSessionRequestThrottledHandlerInterfaceBase>>(
    in_bound_session_request_throttled_handler,
    &params->bound_session_request_throttled_handler,
    &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RendererConfiguration::Name_);
  message.set_method_name("SetInitialConfiguration");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RendererConfigurationProxy::SetConfiguration(
    DynamicParamsPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::RendererConfiguration::SetConfiguration", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type DynamicParamsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RendererConfiguration::kSetConfiguration), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::RendererConfiguration_SetConfiguration_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::chrome::mojom::DynamicParamsDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in RendererConfiguration.SetConfiguration request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RendererConfiguration::Name_);
  message.set_method_name("SetConfiguration");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RendererConfigurationProxy::SetConfigurationOnProcessLockUpdate(
    StaticParamsPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::RendererConfiguration::SetConfigurationOnProcessLockUpdate", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type StaticParamsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RendererConfiguration::kSetConfigurationOnProcessLockUpdate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::RendererConfiguration_SetConfigurationOnProcessLockUpdate_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::chrome::mojom::StaticParamsDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in RendererConfiguration.SetConfigurationOnProcessLockUpdate request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RendererConfiguration::Name_);
  message.set_method_name("SetConfigurationOnProcessLockUpdate");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool RendererConfigurationStubDispatch::Accept(
    RendererConfiguration* impl,
    mojo::Message* message) {
  switch (static_cast<messages::RendererConfiguration>(message->header()->name)) {
    case messages::RendererConfiguration::kSetInitialConfiguration: {
      DCHECK(message->is_serialized());
      internal::RendererConfiguration_SetInitialConfiguration_Params_Data* params =
          reinterpret_cast<internal::RendererConfiguration_SetInitialConfiguration_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RendererConfiguration.0
      bool success = true;
      bool p_is_incognito_process{};
      ::mojo::PendingReceiver<ChromeOSListener> p_chromeos_listener{};
      ::mojo::PendingRemote<::content_settings::mojom::ContentSettingsManager> p_content_settings_manager{};
      ::mojo::PendingRemote<BoundSessionRequestThrottledHandler> p_bound_session_request_throttled_handler{};
      RendererConfiguration_SetInitialConfiguration_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_incognito_process = input_data_view.is_incognito_process();
      if (success) {
        p_chromeos_listener =
            input_data_view.TakeChromeosListener<decltype(p_chromeos_listener)>();
      }
      if (success) {
        p_content_settings_manager =
            input_data_view.TakeContentSettingsManager<decltype(p_content_settings_manager)>();
      }
      if (success) {
        p_bound_session_request_throttled_handler =
            input_data_view.TakeBoundSessionRequestThrottledHandler<decltype(p_bound_session_request_throttled_handler)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RendererConfiguration::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetInitialConfiguration(        
        std::move(p_is_incognito_process), 
        std::move(p_chromeos_listener), 
        std::move(p_content_settings_manager), 
        std::move(p_bound_session_request_throttled_handler));
      return true;
    }
    case messages::RendererConfiguration::kSetConfiguration: {
      DCHECK(message->is_serialized());
      internal::RendererConfiguration_SetConfiguration_Params_Data* params =
          reinterpret_cast<internal::RendererConfiguration_SetConfiguration_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RendererConfiguration.1
      bool success = true;
      DynamicParamsPtr p_params{};
      RendererConfiguration_SetConfiguration_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RendererConfiguration::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetConfiguration(        
        std::move(p_params));
      return true;
    }
    case messages::RendererConfiguration::kSetConfigurationOnProcessLockUpdate: {
      DCHECK(message->is_serialized());
      internal::RendererConfiguration_SetConfigurationOnProcessLockUpdate_Params_Data* params =
          reinterpret_cast<internal::RendererConfiguration_SetConfigurationOnProcessLockUpdate_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RendererConfiguration.2
      bool success = true;
      StaticParamsPtr p_params{};
      RendererConfiguration_SetConfigurationOnProcessLockUpdate_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RendererConfiguration::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetConfigurationOnProcessLockUpdate(        
        std::move(p_params));
      return true;
    }
  }
  return false;
}

// static
bool RendererConfigurationStubDispatch::AcceptWithResponder(
    RendererConfiguration* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::RendererConfiguration>(message->header()->name)) {
    case messages::RendererConfiguration::kSetInitialConfiguration: {
      break;
    }
    case messages::RendererConfiguration::kSetConfiguration: {
      break;
    }
    case messages::RendererConfiguration::kSetConfigurationOnProcessLockUpdate: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kRendererConfigurationValidationInfo[] = {
    { &internal::RendererConfiguration_SetInitialConfiguration_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RendererConfiguration_SetConfiguration_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RendererConfiguration_SetConfigurationOnProcessLockUpdate_Params_Data::Validate,
     nullptr /* no response */},
};

bool RendererConfigurationRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::chrome::mojom::RendererConfiguration::Name_,
    kRendererConfigurationValidationInfo);
}



}  // chrome::mojom


namespace mojo {


// static
bool StructTraits<::chrome::mojom::BoundSessionThrottlerParams::DataView, ::chrome::mojom::BoundSessionThrottlerParamsPtr>::Read(
    ::chrome::mojom::BoundSessionThrottlerParams::DataView input,
    ::chrome::mojom::BoundSessionThrottlerParamsPtr* output) {
  bool success = true;
  ::chrome::mojom::BoundSessionThrottlerParamsPtr result(::chrome::mojom::BoundSessionThrottlerParams::New());
  
      if (success && !input.ReadDomain(&result->domain))
        success = false;
      if (success && !input.ReadPath(&result->path))
        success = false;
      if (success && !input.ReadCookieExpiryDate(&result->cookie_expiry_date))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::chrome::mojom::DynamicParams::DataView, ::chrome::mojom::DynamicParamsPtr>::Read(
    ::chrome::mojom::DynamicParams::DataView input,
    ::chrome::mojom::DynamicParamsPtr* output) {
  bool success = true;
  ::chrome::mojom::DynamicParamsPtr result(::chrome::mojom::DynamicParams::New());
  
      if (success && !input.ReadBoundSessionThrottlerParams(&result->bound_session_throttler_params))
        success = false;
      if (success)
        result->force_safe_search = input.force_safe_search();
      if (success)
        result->youtube_restrict = input.youtube_restrict();
      if (success && !input.ReadAllowedDomainsForApps(&result->allowed_domains_for_apps))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::chrome::mojom::StaticParams::DataView, ::chrome::mojom::StaticParamsPtr>::Read(
    ::chrome::mojom::StaticParams::DataView input,
    ::chrome::mojom::StaticParamsPtr* output) {
  bool success = true;
  ::chrome::mojom::StaticParamsPtr result(::chrome::mojom::StaticParams::New());
  
      if (success)
        result->is_instant_process = input.is_instant_process();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace chrome::mojom {


void BoundSessionRequestThrottledHandlerInterceptorForTesting::HandleRequestBlockedOnCookie(const ::GURL& untrusted_request_url, HandleRequestBlockedOnCookieCallback callback) {
  GetForwardingInterface()->HandleRequestBlockedOnCookie(
    std::move(untrusted_request_url)
    , std::move(callback));
}
BoundSessionRequestThrottledHandlerAsyncWaiter::BoundSessionRequestThrottledHandlerAsyncWaiter(
    BoundSessionRequestThrottledHandler* proxy) : proxy_(proxy) {}

BoundSessionRequestThrottledHandlerAsyncWaiter::~BoundSessionRequestThrottledHandlerAsyncWaiter() = default;


void BoundSessionRequestThrottledHandlerAsyncWaiter::HandleRequestBlockedOnCookie(
    const ::GURL& untrusted_request_url, ResumeBlockedRequestsTrigger* out_resume_trigger) {
  base::RunLoop loop;
  proxy_->HandleRequestBlockedOnCookie(
      std::move(untrusted_request_url),
      base::BindOnce(
          [](base::RunLoop* loop,
             ResumeBlockedRequestsTrigger* out_resume_trigger
,
             ResumeBlockedRequestsTrigger resume_trigger) {*out_resume_trigger = std::move(resume_trigger);
            loop->Quit();
          },
          &loop,
          out_resume_trigger));
  loop.Run();
}

ResumeBlockedRequestsTrigger BoundSessionRequestThrottledHandlerAsyncWaiter::HandleRequestBlockedOnCookie(
    const ::GURL& untrusted_request_url) {
  ResumeBlockedRequestsTrigger async_wait_result;
  HandleRequestBlockedOnCookie(std::move(untrusted_request_url),&async_wait_result);
  return async_wait_result;
}




ChromeOSListenerAsyncWaiter::ChromeOSListenerAsyncWaiter(
    ChromeOSListener* proxy) : proxy_(proxy) {}

ChromeOSListenerAsyncWaiter::~ChromeOSListenerAsyncWaiter() = default;





void RendererConfigurationInterceptorForTesting::SetInitialConfiguration(bool is_incognito_process, ::mojo::PendingReceiver<ChromeOSListener> chromeos_listener, ::mojo::PendingRemote<::content_settings::mojom::ContentSettingsManager> content_settings_manager, ::mojo::PendingRemote<BoundSessionRequestThrottledHandler> bound_session_request_throttled_handler) {
  GetForwardingInterface()->SetInitialConfiguration(
    std::move(is_incognito_process)
    , 
    std::move(chromeos_listener)
    , 
    std::move(content_settings_manager)
    , 
    std::move(bound_session_request_throttled_handler)
    );
}
void RendererConfigurationInterceptorForTesting::SetConfiguration(DynamicParamsPtr params) {
  GetForwardingInterface()->SetConfiguration(
    std::move(params)
    );
}
void RendererConfigurationInterceptorForTesting::SetConfigurationOnProcessLockUpdate(StaticParamsPtr params) {
  GetForwardingInterface()->SetConfigurationOnProcessLockUpdate(
    std::move(params)
    );
}
RendererConfigurationAsyncWaiter::RendererConfigurationAsyncWaiter(
    RendererConfiguration* proxy) : proxy_(proxy) {}

RendererConfigurationAsyncWaiter::~RendererConfigurationAsyncWaiter() = default;







}  // chrome::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif