// chrome/common/read_anything/read_anything.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/common/read_anything/read_anything.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/common/read_anything/read_anything.mojom-params-data.h"
#include "chrome/common/read_anything/read_anything.mojom-shared-message-ids.h"

#include "chrome/common/read_anything/read_anything.mojom-import-headers.h"
#include "chrome/common/read_anything/read_anything.mojom-test-utils.h"


namespace read_anything::mojom {
VoicePackInfo::VoicePackInfo()
    : pack_state(),
      language() {}

VoicePackInfo::VoicePackInfo(
    VoicePackInstallationStatePtr pack_state_in,
    const std::string& language_in)
    : pack_state(std::move(pack_state_in)),
      language(std::move(language_in)) {}

VoicePackInfo::~VoicePackInfo() = default;
size_t VoicePackInfo::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->pack_state);
  seed = mojo::internal::Hash(seed, this->language);
  return seed;
}

void VoicePackInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pack_state"), this->pack_state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type VoicePackInstallationStatePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "language"), this->language,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool VoicePackInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VoicePackInstallationStatePtr
VoicePackInstallationState::NewInstallationState(
    InstallationState value) {
  return VoicePackInstallationStatePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kInstallationState)>,
      std::move(value));
}

VoicePackInstallationStatePtr
VoicePackInstallationState::NewErrorCode(
    ErrorCode value) {
  return VoicePackInstallationStatePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kErrorCode)>,
      std::move(value));
}

VoicePackInstallationState::VoicePackInstallationState(
    std::in_place_index_t<static_cast<size_t>(Tag::kInstallationState)>,
    InstallationState value)
    : tag_(Tag::kInstallationState),
      data_(std::in_place_index<static_cast<size_t>(Tag::kInstallationState)>,
            std::move(value)) {}

VoicePackInstallationState::VoicePackInstallationState(
    std::in_place_index_t<static_cast<size_t>(Tag::kErrorCode)>,
    ErrorCode value)
    : tag_(Tag::kErrorCode),
      data_(std::in_place_index<static_cast<size_t>(Tag::kErrorCode)>,
            std::move(value)) {}
VoicePackInstallationState::~VoicePackInstallationState() {
  DestroyActive();
}

void VoicePackInstallationState::set_installation_state(InstallationState installation_state) {
  if (tag_ != Tag::kInstallationState) {
    DestroyActive();
    tag_ = Tag::kInstallationState;
  }
  data_.installation_state = installation_state;
}

void VoicePackInstallationState::set_error_code(ErrorCode error_code) {
  if (tag_ != Tag::kErrorCode) {
    DestroyActive();
    tag_ = Tag::kErrorCode;
  }
  data_.error_code = error_code;
}


VoicePackInstallationState::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kInstallationState)>,
    InstallationState value)
    : installation_state(std::move(value)) {}

VoicePackInstallationState::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kErrorCode)>,
    ErrorCode value)
    : error_code(std::move(value)) {}

void VoicePackInstallationState::DestroyActive() {
  switch (tag_) {

    case Tag::kInstallationState:
      std::destroy_at(&data_.installation_state);
      break;
    case Tag::kErrorCode:
      std::destroy_at(&data_.error_code);
      break;
  }
}
size_t VoicePackInstallationState::Hash(size_t seed) const {
  seed = mojo::internal::HashCombine(seed, static_cast<uint32_t>(tag_));
  switch (tag_) {

    case Tag::kInstallationState:
      return mojo::internal::Hash(seed, data_.installation_state);
    case Tag::kErrorCode:
      return mojo::internal::Hash(seed, data_.error_code);
    default:
      NOTREACHED();
  }
}

bool VoicePackInstallationState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

UntrustedPageHandlerFactory::IPCStableHashFunction UntrustedPageHandlerFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::UntrustedPageHandlerFactory>(message.name())) {
    case messages::UntrustedPageHandlerFactory::kCreateUntrustedPageHandler: {
      return &UntrustedPageHandlerFactory::CreateUntrustedPageHandler_Sym::IPCStableHash;
    }
    case messages::UntrustedPageHandlerFactory::kShouldShowUI: {
      return &UntrustedPageHandlerFactory::ShouldShowUI_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* UntrustedPageHandlerFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::UntrustedPageHandlerFactory>(message.name())) {
      case messages::UntrustedPageHandlerFactory::kCreateUntrustedPageHandler:
            return "Receive read_anything::mojom::UntrustedPageHandlerFactory::CreateUntrustedPageHandler";
      case messages::UntrustedPageHandlerFactory::kShouldShowUI:
            return "Receive read_anything::mojom::UntrustedPageHandlerFactory::ShouldShowUI";
    }
  } else {
    switch (static_cast<messages::UntrustedPageHandlerFactory>(message.name())) {
      case messages::UntrustedPageHandlerFactory::kCreateUntrustedPageHandler:
            return "Receive reply read_anything::mojom::UntrustedPageHandlerFactory::CreateUntrustedPageHandler";
      case messages::UntrustedPageHandlerFactory::kShouldShowUI:
            return "Receive reply read_anything::mojom::UntrustedPageHandlerFactory::ShouldShowUI";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t UntrustedPageHandlerFactory::CreateUntrustedPageHandler_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf59868ca;  // IPCStableHash for read_anything::mojom::UntrustedPageHandlerFactory::CreateUntrustedPageHandler
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UntrustedPageHandlerFactory::ShouldShowUI_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe419a665;  // IPCStableHash for read_anything::mojom::UntrustedPageHandlerFactory::ShouldShowUI
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

UntrustedPageHandlerFactoryProxy::UntrustedPageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void UntrustedPageHandlerFactoryProxy::CreateUntrustedPageHandler(
    ::mojo::PendingRemote<UntrustedPage> in_page, ::mojo::PendingReceiver<UntrustedPageHandler> in_handler) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send read_anything::mojom::UntrustedPageHandlerFactory::CreateUntrustedPageHandler", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page"), in_page,
                        "<value of type ::mojo::PendingRemote<UntrustedPage>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handler"), in_handler,
                        "<value of type ::mojo::PendingReceiver<UntrustedPageHandler>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UntrustedPageHandlerFactory::kCreateUntrustedPageHandler), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::read_anything::mojom::internal::UntrustedPageHandlerFactory_CreateUntrustedPageHandler_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::read_anything::mojom::UntrustedPageInterfaceBase>>(
    in_page,
    &params->page,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->page)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid page in UntrustedPageHandlerFactory.CreateUntrustedPageHandler request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::read_anything::mojom::UntrustedPageHandlerInterfaceBase>>(
    in_handler,
    &params->handler,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->handler)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid handler in UntrustedPageHandlerFactory.CreateUntrustedPageHandler request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UntrustedPageHandlerFactory::Name_);
  message.set_method_name("CreateUntrustedPageHandler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void UntrustedPageHandlerFactoryProxy::ShouldShowUI(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send read_anything::mojom::UntrustedPageHandlerFactory::ShouldShowUI");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UntrustedPageHandlerFactory::kShouldShowUI), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::read_anything::mojom::internal::UntrustedPageHandlerFactory_ShouldShowUI_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UntrustedPageHandlerFactory::Name_);
  message.set_method_name("ShouldShowUI");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool UntrustedPageHandlerFactoryStubDispatch::Accept(
    UntrustedPageHandlerFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::UntrustedPageHandlerFactory>(message->header()->name)) {
    case messages::UntrustedPageHandlerFactory::kCreateUntrustedPageHandler: {
      DCHECK(message->is_serialized());
      internal::UntrustedPageHandlerFactory_CreateUntrustedPageHandler_Params_Data* params =
          reinterpret_cast<internal::UntrustedPageHandlerFactory_CreateUntrustedPageHandler_Params_Data*>(
              message->mutable_payload());
      

      // Validation for UntrustedPageHandlerFactory.0
      bool success = true;
      ::mojo::PendingRemote<UntrustedPage> p_page{};
      ::mojo::PendingReceiver<UntrustedPageHandler> p_handler{};
      UntrustedPageHandlerFactory_CreateUntrustedPageHandler_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_page =
            input_data_view.TakePage<decltype(p_page)>();
      }
      if (success) {
        p_handler =
            input_data_view.TakeHandler<decltype(p_handler)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UntrustedPageHandlerFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateUntrustedPageHandler(        
        std::move(p_page), 
        std::move(p_handler));
      return true;
    }
    case messages::UntrustedPageHandlerFactory::kShouldShowUI: {
      DCHECK(message->is_serialized());
      internal::UntrustedPageHandlerFactory_ShouldShowUI_Params_Data* params =
          reinterpret_cast<internal::UntrustedPageHandlerFactory_ShouldShowUI_Params_Data*>(
              message->mutable_payload());
      

      // Validation for UntrustedPageHandlerFactory.1
      bool success = true;
      UntrustedPageHandlerFactory_ShouldShowUI_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UntrustedPageHandlerFactory::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShouldShowUI(        );
      return true;
    }
  }
  return false;
}

// static
bool UntrustedPageHandlerFactoryStubDispatch::AcceptWithResponder(
    UntrustedPageHandlerFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::UntrustedPageHandlerFactory>(message->header()->name)) {
    case messages::UntrustedPageHandlerFactory::kCreateUntrustedPageHandler: {
      break;
    }
    case messages::UntrustedPageHandlerFactory::kShouldShowUI: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kUntrustedPageHandlerFactoryValidationInfo[] = {
    { &internal::UntrustedPageHandlerFactory_CreateUntrustedPageHandler_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::UntrustedPageHandlerFactory_ShouldShowUI_Params_Data::Validate,
     nullptr /* no response */},
};

bool UntrustedPageHandlerFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::read_anything::mojom::UntrustedPageHandlerFactory::Name_,
    kUntrustedPageHandlerFactoryValidationInfo);
}

// The declaration includes the definition on other builds.

UntrustedPageHandler::IPCStableHashFunction UntrustedPageHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::UntrustedPageHandler>(message.name())) {
    case messages::UntrustedPageHandler::kGetDependencyParserModel: {
      return &UntrustedPageHandler::GetDependencyParserModel_Sym::IPCStableHash;
    }
    case messages::UntrustedPageHandler::kGetVoicePackInfo: {
      return &UntrustedPageHandler::GetVoicePackInfo_Sym::IPCStableHash;
    }
    case messages::UntrustedPageHandler::kInstallVoicePack: {
      return &UntrustedPageHandler::InstallVoicePack_Sym::IPCStableHash;
    }
    case messages::UntrustedPageHandler::kUninstallVoice: {
      return &UntrustedPageHandler::UninstallVoice_Sym::IPCStableHash;
    }
    case messages::UntrustedPageHandler::kOnCopy: {
      return &UntrustedPageHandler::OnCopy_Sym::IPCStableHash;
    }
    case messages::UntrustedPageHandler::kOnLineSpaceChange: {
      return &UntrustedPageHandler::OnLineSpaceChange_Sym::IPCStableHash;
    }
    case messages::UntrustedPageHandler::kOnLetterSpaceChange: {
      return &UntrustedPageHandler::OnLetterSpaceChange_Sym::IPCStableHash;
    }
    case messages::UntrustedPageHandler::kOnFontChange: {
      return &UntrustedPageHandler::OnFontChange_Sym::IPCStableHash;
    }
    case messages::UntrustedPageHandler::kOnFontSizeChange: {
      return &UntrustedPageHandler::OnFontSizeChange_Sym::IPCStableHash;
    }
    case messages::UntrustedPageHandler::kOnLinksEnabledChanged: {
      return &UntrustedPageHandler::OnLinksEnabledChanged_Sym::IPCStableHash;
    }
    case messages::UntrustedPageHandler::kOnImagesEnabledChanged: {
      return &UntrustedPageHandler::OnImagesEnabledChanged_Sym::IPCStableHash;
    }
    case messages::UntrustedPageHandler::kOnColorChange: {
      return &UntrustedPageHandler::OnColorChange_Sym::IPCStableHash;
    }
    case messages::UntrustedPageHandler::kOnSpeechRateChange: {
      return &UntrustedPageHandler::OnSpeechRateChange_Sym::IPCStableHash;
    }
    case messages::UntrustedPageHandler::kOnVoiceChange: {
      return &UntrustedPageHandler::OnVoiceChange_Sym::IPCStableHash;
    }
    case messages::UntrustedPageHandler::kOnLanguagePrefChange: {
      return &UntrustedPageHandler::OnLanguagePrefChange_Sym::IPCStableHash;
    }
    case messages::UntrustedPageHandler::kLogExtensionState: {
      return &UntrustedPageHandler::LogExtensionState_Sym::IPCStableHash;
    }
    case messages::UntrustedPageHandler::kOnHighlightGranularityChanged: {
      return &UntrustedPageHandler::OnHighlightGranularityChanged_Sym::IPCStableHash;
    }
    case messages::UntrustedPageHandler::kOnReadAloudAudioStateChange: {
      return &UntrustedPageHandler::OnReadAloudAudioStateChange_Sym::IPCStableHash;
    }
    case messages::UntrustedPageHandler::kOnLinkClicked: {
      return &UntrustedPageHandler::OnLinkClicked_Sym::IPCStableHash;
    }
    case messages::UntrustedPageHandler::kOnImageDataRequested: {
      return &UntrustedPageHandler::OnImageDataRequested_Sym::IPCStableHash;
    }
    case messages::UntrustedPageHandler::kOnSelectionChange: {
      return &UntrustedPageHandler::OnSelectionChange_Sym::IPCStableHash;
    }
    case messages::UntrustedPageHandler::kOnCollapseSelection: {
      return &UntrustedPageHandler::OnCollapseSelection_Sym::IPCStableHash;
    }
    case messages::UntrustedPageHandler::kOnScreenshotRequested: {
      return &UntrustedPageHandler::OnScreenshotRequested_Sym::IPCStableHash;
    }
    case messages::UntrustedPageHandler::kScrollToTargetNode: {
      return &UntrustedPageHandler::ScrollToTargetNode_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* UntrustedPageHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::UntrustedPageHandler>(message.name())) {
      case messages::UntrustedPageHandler::kGetDependencyParserModel:
            return "Receive read_anything::mojom::UntrustedPageHandler::GetDependencyParserModel";
      case messages::UntrustedPageHandler::kGetVoicePackInfo:
            return "Receive read_anything::mojom::UntrustedPageHandler::GetVoicePackInfo";
      case messages::UntrustedPageHandler::kInstallVoicePack:
            return "Receive read_anything::mojom::UntrustedPageHandler::InstallVoicePack";
      case messages::UntrustedPageHandler::kUninstallVoice:
            return "Receive read_anything::mojom::UntrustedPageHandler::UninstallVoice";
      case messages::UntrustedPageHandler::kOnCopy:
            return "Receive read_anything::mojom::UntrustedPageHandler::OnCopy";
      case messages::UntrustedPageHandler::kOnLineSpaceChange:
            return "Receive read_anything::mojom::UntrustedPageHandler::OnLineSpaceChange";
      case messages::UntrustedPageHandler::kOnLetterSpaceChange:
            return "Receive read_anything::mojom::UntrustedPageHandler::OnLetterSpaceChange";
      case messages::UntrustedPageHandler::kOnFontChange:
            return "Receive read_anything::mojom::UntrustedPageHandler::OnFontChange";
      case messages::UntrustedPageHandler::kOnFontSizeChange:
            return "Receive read_anything::mojom::UntrustedPageHandler::OnFontSizeChange";
      case messages::UntrustedPageHandler::kOnLinksEnabledChanged:
            return "Receive read_anything::mojom::UntrustedPageHandler::OnLinksEnabledChanged";
      case messages::UntrustedPageHandler::kOnImagesEnabledChanged:
            return "Receive read_anything::mojom::UntrustedPageHandler::OnImagesEnabledChanged";
      case messages::UntrustedPageHandler::kOnColorChange:
            return "Receive read_anything::mojom::UntrustedPageHandler::OnColorChange";
      case messages::UntrustedPageHandler::kOnSpeechRateChange:
            return "Receive read_anything::mojom::UntrustedPageHandler::OnSpeechRateChange";
      case messages::UntrustedPageHandler::kOnVoiceChange:
            return "Receive read_anything::mojom::UntrustedPageHandler::OnVoiceChange";
      case messages::UntrustedPageHandler::kOnLanguagePrefChange:
            return "Receive read_anything::mojom::UntrustedPageHandler::OnLanguagePrefChange";
      case messages::UntrustedPageHandler::kLogExtensionState:
            return "Receive read_anything::mojom::UntrustedPageHandler::LogExtensionState";
      case messages::UntrustedPageHandler::kOnHighlightGranularityChanged:
            return "Receive read_anything::mojom::UntrustedPageHandler::OnHighlightGranularityChanged";
      case messages::UntrustedPageHandler::kOnReadAloudAudioStateChange:
            return "Receive read_anything::mojom::UntrustedPageHandler::OnReadAloudAudioStateChange";
      case messages::UntrustedPageHandler::kOnLinkClicked:
            return "Receive read_anything::mojom::UntrustedPageHandler::OnLinkClicked";
      case messages::UntrustedPageHandler::kOnImageDataRequested:
            return "Receive read_anything::mojom::UntrustedPageHandler::OnImageDataRequested";
      case messages::UntrustedPageHandler::kOnSelectionChange:
            return "Receive read_anything::mojom::UntrustedPageHandler::OnSelectionChange";
      case messages::UntrustedPageHandler::kOnCollapseSelection:
            return "Receive read_anything::mojom::UntrustedPageHandler::OnCollapseSelection";
      case messages::UntrustedPageHandler::kOnScreenshotRequested:
            return "Receive read_anything::mojom::UntrustedPageHandler::OnScreenshotRequested";
      case messages::UntrustedPageHandler::kScrollToTargetNode:
            return "Receive read_anything::mojom::UntrustedPageHandler::ScrollToTargetNode";
    }
  } else {
    switch (static_cast<messages::UntrustedPageHandler>(message.name())) {
      case messages::UntrustedPageHandler::kGetDependencyParserModel:
            return "Receive reply read_anything::mojom::UntrustedPageHandler::GetDependencyParserModel";
      case messages::UntrustedPageHandler::kGetVoicePackInfo:
            return "Receive reply read_anything::mojom::UntrustedPageHandler::GetVoicePackInfo";
      case messages::UntrustedPageHandler::kInstallVoicePack:
            return "Receive reply read_anything::mojom::UntrustedPageHandler::InstallVoicePack";
      case messages::UntrustedPageHandler::kUninstallVoice:
            return "Receive reply read_anything::mojom::UntrustedPageHandler::UninstallVoice";
      case messages::UntrustedPageHandler::kOnCopy:
            return "Receive reply read_anything::mojom::UntrustedPageHandler::OnCopy";
      case messages::UntrustedPageHandler::kOnLineSpaceChange:
            return "Receive reply read_anything::mojom::UntrustedPageHandler::OnLineSpaceChange";
      case messages::UntrustedPageHandler::kOnLetterSpaceChange:
            return "Receive reply read_anything::mojom::UntrustedPageHandler::OnLetterSpaceChange";
      case messages::UntrustedPageHandler::kOnFontChange:
            return "Receive reply read_anything::mojom::UntrustedPageHandler::OnFontChange";
      case messages::UntrustedPageHandler::kOnFontSizeChange:
            return "Receive reply read_anything::mojom::UntrustedPageHandler::OnFontSizeChange";
      case messages::UntrustedPageHandler::kOnLinksEnabledChanged:
            return "Receive reply read_anything::mojom::UntrustedPageHandler::OnLinksEnabledChanged";
      case messages::UntrustedPageHandler::kOnImagesEnabledChanged:
            return "Receive reply read_anything::mojom::UntrustedPageHandler::OnImagesEnabledChanged";
      case messages::UntrustedPageHandler::kOnColorChange:
            return "Receive reply read_anything::mojom::UntrustedPageHandler::OnColorChange";
      case messages::UntrustedPageHandler::kOnSpeechRateChange:
            return "Receive reply read_anything::mojom::UntrustedPageHandler::OnSpeechRateChange";
      case messages::UntrustedPageHandler::kOnVoiceChange:
            return "Receive reply read_anything::mojom::UntrustedPageHandler::OnVoiceChange";
      case messages::UntrustedPageHandler::kOnLanguagePrefChange:
            return "Receive reply read_anything::mojom::UntrustedPageHandler::OnLanguagePrefChange";
      case messages::UntrustedPageHandler::kLogExtensionState:
            return "Receive reply read_anything::mojom::UntrustedPageHandler::LogExtensionState";
      case messages::UntrustedPageHandler::kOnHighlightGranularityChanged:
            return "Receive reply read_anything::mojom::UntrustedPageHandler::OnHighlightGranularityChanged";
      case messages::UntrustedPageHandler::kOnReadAloudAudioStateChange:
            return "Receive reply read_anything::mojom::UntrustedPageHandler::OnReadAloudAudioStateChange";
      case messages::UntrustedPageHandler::kOnLinkClicked:
            return "Receive reply read_anything::mojom::UntrustedPageHandler::OnLinkClicked";
      case messages::UntrustedPageHandler::kOnImageDataRequested:
            return "Receive reply read_anything::mojom::UntrustedPageHandler::OnImageDataRequested";
      case messages::UntrustedPageHandler::kOnSelectionChange:
            return "Receive reply read_anything::mojom::UntrustedPageHandler::OnSelectionChange";
      case messages::UntrustedPageHandler::kOnCollapseSelection:
            return "Receive reply read_anything::mojom::UntrustedPageHandler::OnCollapseSelection";
      case messages::UntrustedPageHandler::kOnScreenshotRequested:
            return "Receive reply read_anything::mojom::UntrustedPageHandler::OnScreenshotRequested";
      case messages::UntrustedPageHandler::kScrollToTargetNode:
            return "Receive reply read_anything::mojom::UntrustedPageHandler::ScrollToTargetNode";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t UntrustedPageHandler::GetDependencyParserModel_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf4943271;  // IPCStableHash for read_anything::mojom::UntrustedPageHandler::GetDependencyParserModel
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UntrustedPageHandler::GetVoicePackInfo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb28e412e;  // IPCStableHash for read_anything::mojom::UntrustedPageHandler::GetVoicePackInfo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UntrustedPageHandler::InstallVoicePack_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1fdead88;  // IPCStableHash for read_anything::mojom::UntrustedPageHandler::InstallVoicePack
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UntrustedPageHandler::UninstallVoice_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x833d5f39;  // IPCStableHash for read_anything::mojom::UntrustedPageHandler::UninstallVoice
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UntrustedPageHandler::OnCopy_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xac83b925;  // IPCStableHash for read_anything::mojom::UntrustedPageHandler::OnCopy
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UntrustedPageHandler::OnLineSpaceChange_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc3edb921;  // IPCStableHash for read_anything::mojom::UntrustedPageHandler::OnLineSpaceChange
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UntrustedPageHandler::OnLetterSpaceChange_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcebce1b5;  // IPCStableHash for read_anything::mojom::UntrustedPageHandler::OnLetterSpaceChange
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UntrustedPageHandler::OnFontChange_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x73287f45;  // IPCStableHash for read_anything::mojom::UntrustedPageHandler::OnFontChange
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UntrustedPageHandler::OnFontSizeChange_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3c1c5eae;  // IPCStableHash for read_anything::mojom::UntrustedPageHandler::OnFontSizeChange
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UntrustedPageHandler::OnLinksEnabledChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd2551567;  // IPCStableHash for read_anything::mojom::UntrustedPageHandler::OnLinksEnabledChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UntrustedPageHandler::OnImagesEnabledChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3d788fed;  // IPCStableHash for read_anything::mojom::UntrustedPageHandler::OnImagesEnabledChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UntrustedPageHandler::OnColorChange_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7d4ce092;  // IPCStableHash for read_anything::mojom::UntrustedPageHandler::OnColorChange
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UntrustedPageHandler::OnSpeechRateChange_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8a858bf7;  // IPCStableHash for read_anything::mojom::UntrustedPageHandler::OnSpeechRateChange
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UntrustedPageHandler::OnVoiceChange_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3c0c684c;  // IPCStableHash for read_anything::mojom::UntrustedPageHandler::OnVoiceChange
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UntrustedPageHandler::OnLanguagePrefChange_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6fd3909e;  // IPCStableHash for read_anything::mojom::UntrustedPageHandler::OnLanguagePrefChange
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UntrustedPageHandler::LogExtensionState_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x51ca22d6;  // IPCStableHash for read_anything::mojom::UntrustedPageHandler::LogExtensionState
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UntrustedPageHandler::OnHighlightGranularityChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe5e83a51;  // IPCStableHash for read_anything::mojom::UntrustedPageHandler::OnHighlightGranularityChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UntrustedPageHandler::OnReadAloudAudioStateChange_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2404de64;  // IPCStableHash for read_anything::mojom::UntrustedPageHandler::OnReadAloudAudioStateChange
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UntrustedPageHandler::OnLinkClicked_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3682b86f;  // IPCStableHash for read_anything::mojom::UntrustedPageHandler::OnLinkClicked
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UntrustedPageHandler::OnImageDataRequested_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8e4d8698;  // IPCStableHash for read_anything::mojom::UntrustedPageHandler::OnImageDataRequested
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UntrustedPageHandler::OnSelectionChange_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa317a813;  // IPCStableHash for read_anything::mojom::UntrustedPageHandler::OnSelectionChange
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UntrustedPageHandler::OnCollapseSelection_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcb050e07;  // IPCStableHash for read_anything::mojom::UntrustedPageHandler::OnCollapseSelection
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UntrustedPageHandler::OnScreenshotRequested_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc1017e60;  // IPCStableHash for read_anything::mojom::UntrustedPageHandler::OnScreenshotRequested
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UntrustedPageHandler::ScrollToTargetNode_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x577d143c;  // IPCStableHash for read_anything::mojom::UntrustedPageHandler::ScrollToTargetNode
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class UntrustedPageHandler_GetDependencyParserModel_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  UntrustedPageHandler_GetDependencyParserModel_ForwardToCallback(
      UntrustedPageHandler::GetDependencyParserModelCallback callback
      ) : callback_(std::move(callback)) {
  }

  UntrustedPageHandler_GetDependencyParserModel_ForwardToCallback(const UntrustedPageHandler_GetDependencyParserModel_ForwardToCallback&) = delete;
  UntrustedPageHandler_GetDependencyParserModel_ForwardToCallback& operator=(const UntrustedPageHandler_GetDependencyParserModel_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  UntrustedPageHandler::GetDependencyParserModelCallback callback_;
};

UntrustedPageHandlerProxy::UntrustedPageHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void UntrustedPageHandlerProxy::GetDependencyParserModel(
    GetDependencyParserModelCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send read_anything::mojom::UntrustedPageHandler::GetDependencyParserModel");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UntrustedPageHandler::kGetDependencyParserModel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::read_anything::mojom::internal::UntrustedPageHandler_GetDependencyParserModel_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UntrustedPageHandler::Name_);
  message.set_method_name("GetDependencyParserModel");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new UntrustedPageHandler_GetDependencyParserModel_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void UntrustedPageHandlerProxy::GetVoicePackInfo(
    const std::string& in_language) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send read_anything::mojom::UntrustedPageHandler::GetVoicePackInfo", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("language"), in_language,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UntrustedPageHandler::kGetVoicePackInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::read_anything::mojom::internal::UntrustedPageHandler_GetVoicePackInfo_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->language)::BaseType> language_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_language,
    language_fragment);

  params->language.Set(
      language_fragment.is_null() ? nullptr : language_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->language.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null language in UntrustedPageHandler.GetVoicePackInfo request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UntrustedPageHandler::Name_);
  message.set_method_name("GetVoicePackInfo");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void UntrustedPageHandlerProxy::InstallVoicePack(
    const std::string& in_language) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send read_anything::mojom::UntrustedPageHandler::InstallVoicePack", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("language"), in_language,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UntrustedPageHandler::kInstallVoicePack), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::read_anything::mojom::internal::UntrustedPageHandler_InstallVoicePack_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->language)::BaseType> language_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_language,
    language_fragment);

  params->language.Set(
      language_fragment.is_null() ? nullptr : language_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->language.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null language in UntrustedPageHandler.InstallVoicePack request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UntrustedPageHandler::Name_);
  message.set_method_name("InstallVoicePack");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void UntrustedPageHandlerProxy::UninstallVoice(
    const std::string& in_language) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send read_anything::mojom::UntrustedPageHandler::UninstallVoice", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("language"), in_language,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UntrustedPageHandler::kUninstallVoice), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::read_anything::mojom::internal::UntrustedPageHandler_UninstallVoice_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->language)::BaseType> language_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_language,
    language_fragment);

  params->language.Set(
      language_fragment.is_null() ? nullptr : language_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->language.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null language in UntrustedPageHandler.UninstallVoice request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UntrustedPageHandler::Name_);
  message.set_method_name("UninstallVoice");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void UntrustedPageHandlerProxy::OnCopy(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send read_anything::mojom::UntrustedPageHandler::OnCopy");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UntrustedPageHandler::kOnCopy), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::read_anything::mojom::internal::UntrustedPageHandler_OnCopy_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UntrustedPageHandler::Name_);
  message.set_method_name("OnCopy");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void UntrustedPageHandlerProxy::OnLineSpaceChange(
    LineSpacing in_line_spacing) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send read_anything::mojom::UntrustedPageHandler::OnLineSpaceChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("line_spacing"), in_line_spacing,
                        "<value of type LineSpacing>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UntrustedPageHandler::kOnLineSpaceChange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::read_anything::mojom::internal::UntrustedPageHandler_OnLineSpaceChange_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::read_anything::mojom::LineSpacing>(
    in_line_spacing,
    &params->line_spacing);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UntrustedPageHandler::Name_);
  message.set_method_name("OnLineSpaceChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void UntrustedPageHandlerProxy::OnLetterSpaceChange(
    LetterSpacing in_letter_spacing) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send read_anything::mojom::UntrustedPageHandler::OnLetterSpaceChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("letter_spacing"), in_letter_spacing,
                        "<value of type LetterSpacing>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UntrustedPageHandler::kOnLetterSpaceChange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::read_anything::mojom::internal::UntrustedPageHandler_OnLetterSpaceChange_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::read_anything::mojom::LetterSpacing>(
    in_letter_spacing,
    &params->letter_spacing);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UntrustedPageHandler::Name_);
  message.set_method_name("OnLetterSpaceChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void UntrustedPageHandlerProxy::OnFontChange(
    const std::string& in_font) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send read_anything::mojom::UntrustedPageHandler::OnFontChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("font"), in_font,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UntrustedPageHandler::kOnFontChange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::read_anything::mojom::internal::UntrustedPageHandler_OnFontChange_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->font)::BaseType> font_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_font,
    font_fragment);

  params->font.Set(
      font_fragment.is_null() ? nullptr : font_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->font.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null font in UntrustedPageHandler.OnFontChange request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UntrustedPageHandler::Name_);
  message.set_method_name("OnFontChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void UntrustedPageHandlerProxy::OnFontSizeChange(
    double in_font_size) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send read_anything::mojom::UntrustedPageHandler::OnFontSizeChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("font_size"), in_font_size,
                        "<value of type double>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UntrustedPageHandler::kOnFontSizeChange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::read_anything::mojom::internal::UntrustedPageHandler_OnFontSizeChange_Params_Data> params(
          message);
  params.Allocate();

  params->font_size = in_font_size;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UntrustedPageHandler::Name_);
  message.set_method_name("OnFontSizeChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void UntrustedPageHandlerProxy::OnLinksEnabledChanged(
    bool in_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send read_anything::mojom::UntrustedPageHandler::OnLinksEnabledChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enabled"), in_enabled,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UntrustedPageHandler::kOnLinksEnabledChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::read_anything::mojom::internal::UntrustedPageHandler_OnLinksEnabledChanged_Params_Data> params(
          message);
  params.Allocate();

  params->enabled = in_enabled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UntrustedPageHandler::Name_);
  message.set_method_name("OnLinksEnabledChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void UntrustedPageHandlerProxy::OnImagesEnabledChanged(
    bool in_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send read_anything::mojom::UntrustedPageHandler::OnImagesEnabledChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enabled"), in_enabled,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UntrustedPageHandler::kOnImagesEnabledChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::read_anything::mojom::internal::UntrustedPageHandler_OnImagesEnabledChanged_Params_Data> params(
          message);
  params.Allocate();

  params->enabled = in_enabled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UntrustedPageHandler::Name_);
  message.set_method_name("OnImagesEnabledChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void UntrustedPageHandlerProxy::OnColorChange(
    Colors in_color) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send read_anything::mojom::UntrustedPageHandler::OnColorChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("color"), in_color,
                        "<value of type Colors>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UntrustedPageHandler::kOnColorChange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::read_anything::mojom::internal::UntrustedPageHandler_OnColorChange_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::read_anything::mojom::Colors>(
    in_color,
    &params->color);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UntrustedPageHandler::Name_);
  message.set_method_name("OnColorChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void UntrustedPageHandlerProxy::OnSpeechRateChange(
    double in_rate) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send read_anything::mojom::UntrustedPageHandler::OnSpeechRateChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("rate"), in_rate,
                        "<value of type double>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UntrustedPageHandler::kOnSpeechRateChange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::read_anything::mojom::internal::UntrustedPageHandler_OnSpeechRateChange_Params_Data> params(
          message);
  params.Allocate();

  params->rate = in_rate;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UntrustedPageHandler::Name_);
  message.set_method_name("OnSpeechRateChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void UntrustedPageHandlerProxy::OnVoiceChange(
    const std::string& in_voice, const std::string& in_lang) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send read_anything::mojom::UntrustedPageHandler::OnVoiceChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("voice"), in_voice,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("lang"), in_lang,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UntrustedPageHandler::kOnVoiceChange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::read_anything::mojom::internal::UntrustedPageHandler_OnVoiceChange_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->voice)::BaseType> voice_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_voice,
    voice_fragment);

  params->voice.Set(
      voice_fragment.is_null() ? nullptr : voice_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->voice.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null voice in UntrustedPageHandler.OnVoiceChange request");
  mojo::internal::MessageFragment<
      typename decltype(params->lang)::BaseType> lang_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_lang,
    lang_fragment);

  params->lang.Set(
      lang_fragment.is_null() ? nullptr : lang_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->lang.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null lang in UntrustedPageHandler.OnVoiceChange request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UntrustedPageHandler::Name_);
  message.set_method_name("OnVoiceChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void UntrustedPageHandlerProxy::OnLanguagePrefChange(
    const std::string& in_lang, bool in_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send read_anything::mojom::UntrustedPageHandler::OnLanguagePrefChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("lang"), in_lang,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enabled"), in_enabled,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UntrustedPageHandler::kOnLanguagePrefChange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::read_anything::mojom::internal::UntrustedPageHandler_OnLanguagePrefChange_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->lang)::BaseType> lang_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_lang,
    lang_fragment);

  params->lang.Set(
      lang_fragment.is_null() ? nullptr : lang_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->lang.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null lang in UntrustedPageHandler.OnLanguagePrefChange request");

  params->enabled = in_enabled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UntrustedPageHandler::Name_);
  message.set_method_name("OnLanguagePrefChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void UntrustedPageHandlerProxy::LogExtensionState(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send read_anything::mojom::UntrustedPageHandler::LogExtensionState");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UntrustedPageHandler::kLogExtensionState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::read_anything::mojom::internal::UntrustedPageHandler_LogExtensionState_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UntrustedPageHandler::Name_);
  message.set_method_name("LogExtensionState");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void UntrustedPageHandlerProxy::OnHighlightGranularityChanged(
    HighlightGranularity in_granularity) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send read_anything::mojom::UntrustedPageHandler::OnHighlightGranularityChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("granularity"), in_granularity,
                        "<value of type HighlightGranularity>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UntrustedPageHandler::kOnHighlightGranularityChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::read_anything::mojom::internal::UntrustedPageHandler_OnHighlightGranularityChanged_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::read_anything::mojom::HighlightGranularity>(
    in_granularity,
    &params->granularity);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UntrustedPageHandler::Name_);
  message.set_method_name("OnHighlightGranularityChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void UntrustedPageHandlerProxy::OnReadAloudAudioStateChange(
    bool in_playing) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send read_anything::mojom::UntrustedPageHandler::OnReadAloudAudioStateChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("playing"), in_playing,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UntrustedPageHandler::kOnReadAloudAudioStateChange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::read_anything::mojom::internal::UntrustedPageHandler_OnReadAloudAudioStateChange_Params_Data> params(
          message);
  params.Allocate();

  params->playing = in_playing;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UntrustedPageHandler::Name_);
  message.set_method_name("OnReadAloudAudioStateChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void UntrustedPageHandlerProxy::OnLinkClicked(
    const ::ui::AXTreeID& in_target_tree_id, int32_t in_target_node_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send read_anything::mojom::UntrustedPageHandler::OnLinkClicked", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("target_tree_id"), in_target_tree_id,
                        "<value of type const ::ui::AXTreeID&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("target_node_id"), in_target_node_id,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UntrustedPageHandler::kOnLinkClicked), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::read_anything::mojom::internal::UntrustedPageHandler_OnLinkClicked_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->target_tree_id)>
      target_tree_id_fragment(params.message());
  target_tree_id_fragment.Claim(&params->target_tree_id);
  
  mojo::internal::Serialize<::ax::mojom::AXTreeIDDataView>(
    in_target_tree_id,
    target_tree_id_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->target_tree_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null target_tree_id in UntrustedPageHandler.OnLinkClicked request");

  params->target_node_id = in_target_node_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UntrustedPageHandler::Name_);
  message.set_method_name("OnLinkClicked");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void UntrustedPageHandlerProxy::OnImageDataRequested(
    const ::ui::AXTreeID& in_target_tree_id, int32_t in_target_node_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send read_anything::mojom::UntrustedPageHandler::OnImageDataRequested", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("target_tree_id"), in_target_tree_id,
                        "<value of type const ::ui::AXTreeID&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("target_node_id"), in_target_node_id,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UntrustedPageHandler::kOnImageDataRequested), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::read_anything::mojom::internal::UntrustedPageHandler_OnImageDataRequested_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->target_tree_id)>
      target_tree_id_fragment(params.message());
  target_tree_id_fragment.Claim(&params->target_tree_id);
  
  mojo::internal::Serialize<::ax::mojom::AXTreeIDDataView>(
    in_target_tree_id,
    target_tree_id_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->target_tree_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null target_tree_id in UntrustedPageHandler.OnImageDataRequested request");

  params->target_node_id = in_target_node_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UntrustedPageHandler::Name_);
  message.set_method_name("OnImageDataRequested");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void UntrustedPageHandlerProxy::OnSelectionChange(
    const ::ui::AXTreeID& in_target_tree_id, int32_t in_anchor_node_id, int32_t in_anchor_offset, int32_t in_focus_node_id, int32_t in_focus_offset) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send read_anything::mojom::UntrustedPageHandler::OnSelectionChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("target_tree_id"), in_target_tree_id,
                        "<value of type const ::ui::AXTreeID&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("anchor_node_id"), in_anchor_node_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("anchor_offset"), in_anchor_offset,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("focus_node_id"), in_focus_node_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("focus_offset"), in_focus_offset,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UntrustedPageHandler::kOnSelectionChange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::read_anything::mojom::internal::UntrustedPageHandler_OnSelectionChange_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->target_tree_id)>
      target_tree_id_fragment(params.message());
  target_tree_id_fragment.Claim(&params->target_tree_id);
  
  mojo::internal::Serialize<::ax::mojom::AXTreeIDDataView>(
    in_target_tree_id,
    target_tree_id_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->target_tree_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null target_tree_id in UntrustedPageHandler.OnSelectionChange request");

  params->anchor_node_id = in_anchor_node_id;

  params->anchor_offset = in_anchor_offset;

  params->focus_node_id = in_focus_node_id;

  params->focus_offset = in_focus_offset;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UntrustedPageHandler::Name_);
  message.set_method_name("OnSelectionChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void UntrustedPageHandlerProxy::OnCollapseSelection(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send read_anything::mojom::UntrustedPageHandler::OnCollapseSelection");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UntrustedPageHandler::kOnCollapseSelection), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::read_anything::mojom::internal::UntrustedPageHandler_OnCollapseSelection_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UntrustedPageHandler::Name_);
  message.set_method_name("OnCollapseSelection");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void UntrustedPageHandlerProxy::OnScreenshotRequested(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send read_anything::mojom::UntrustedPageHandler::OnScreenshotRequested");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UntrustedPageHandler::kOnScreenshotRequested), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::read_anything::mojom::internal::UntrustedPageHandler_OnScreenshotRequested_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UntrustedPageHandler::Name_);
  message.set_method_name("OnScreenshotRequested");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void UntrustedPageHandlerProxy::ScrollToTargetNode(
    const ::ui::AXTreeID& in_target_tree_id, int32_t in_target_node_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send read_anything::mojom::UntrustedPageHandler::ScrollToTargetNode", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("target_tree_id"), in_target_tree_id,
                        "<value of type const ::ui::AXTreeID&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("target_node_id"), in_target_node_id,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UntrustedPageHandler::kScrollToTargetNode), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::read_anything::mojom::internal::UntrustedPageHandler_ScrollToTargetNode_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->target_tree_id)>
      target_tree_id_fragment(params.message());
  target_tree_id_fragment.Claim(&params->target_tree_id);
  
  mojo::internal::Serialize<::ax::mojom::AXTreeIDDataView>(
    in_target_tree_id,
    target_tree_id_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->target_tree_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null target_tree_id in UntrustedPageHandler.ScrollToTargetNode request");

  params->target_node_id = in_target_node_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UntrustedPageHandler::Name_);
  message.set_method_name("ScrollToTargetNode");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class UntrustedPageHandler_GetDependencyParserModel_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static UntrustedPageHandler::GetDependencyParserModelCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<UntrustedPageHandler_GetDependencyParserModel_ProxyToResponder> proxy(
        new UntrustedPageHandler_GetDependencyParserModel_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&UntrustedPageHandler_GetDependencyParserModel_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~UntrustedPageHandler_GetDependencyParserModel_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  UntrustedPageHandler_GetDependencyParserModel_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "UntrustedPageHandler::GetDependencyParserModelCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::File in_model_file);
};

bool UntrustedPageHandler_GetDependencyParserModel_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::UntrustedPageHandler_GetDependencyParserModel_ResponseParams_Data* params =
      reinterpret_cast<
          internal::UntrustedPageHandler_GetDependencyParserModel_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for UntrustedPageHandler.0
  bool success = true;
  ::base::File p_model_file{};
  UntrustedPageHandler_GetDependencyParserModel_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadModelFile(&p_model_file))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        UntrustedPageHandler::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_model_file));
  }
  return true;
}

void UntrustedPageHandler_GetDependencyParserModel_ProxyToResponder::Run(
    ::base::File in_model_file) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply read_anything::mojom::UntrustedPageHandler::GetDependencyParserModel", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("model_file"), in_model_file,
                        "<value of type ::base::File>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UntrustedPageHandler::kGetDependencyParserModel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::read_anything::mojom::internal::UntrustedPageHandler_GetDependencyParserModel_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->model_file)::BaseType> model_file_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::FileDataView>(
    in_model_file,
    model_file_fragment);

  params->model_file.Set(
      model_file_fragment.is_null() ? nullptr : model_file_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UntrustedPageHandler::Name_);
  message.set_method_name("GetDependencyParserModel");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool UntrustedPageHandlerStubDispatch::Accept(
    UntrustedPageHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::UntrustedPageHandler>(message->header()->name)) {
    case messages::UntrustedPageHandler::kGetDependencyParserModel: {
      break;
    }
    case messages::UntrustedPageHandler::kGetVoicePackInfo: {
      DCHECK(message->is_serialized());
      internal::UntrustedPageHandler_GetVoicePackInfo_Params_Data* params =
          reinterpret_cast<internal::UntrustedPageHandler_GetVoicePackInfo_Params_Data*>(
              message->mutable_payload());
      

      // Validation for UntrustedPageHandler.1
      bool success = true;
      std::string p_language{};
      UntrustedPageHandler_GetVoicePackInfo_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLanguage(&p_language))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UntrustedPageHandler::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetVoicePackInfo(        
        std::move(p_language));
      return true;
    }
    case messages::UntrustedPageHandler::kInstallVoicePack: {
      DCHECK(message->is_serialized());
      internal::UntrustedPageHandler_InstallVoicePack_Params_Data* params =
          reinterpret_cast<internal::UntrustedPageHandler_InstallVoicePack_Params_Data*>(
              message->mutable_payload());
      

      // Validation for UntrustedPageHandler.2
      bool success = true;
      std::string p_language{};
      UntrustedPageHandler_InstallVoicePack_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLanguage(&p_language))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UntrustedPageHandler::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->InstallVoicePack(        
        std::move(p_language));
      return true;
    }
    case messages::UntrustedPageHandler::kUninstallVoice: {
      DCHECK(message->is_serialized());
      internal::UntrustedPageHandler_UninstallVoice_Params_Data* params =
          reinterpret_cast<internal::UntrustedPageHandler_UninstallVoice_Params_Data*>(
              message->mutable_payload());
      

      // Validation for UntrustedPageHandler.3
      bool success = true;
      std::string p_language{};
      UntrustedPageHandler_UninstallVoice_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLanguage(&p_language))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UntrustedPageHandler::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UninstallVoice(        
        std::move(p_language));
      return true;
    }
    case messages::UntrustedPageHandler::kOnCopy: {
      DCHECK(message->is_serialized());
      internal::UntrustedPageHandler_OnCopy_Params_Data* params =
          reinterpret_cast<internal::UntrustedPageHandler_OnCopy_Params_Data*>(
              message->mutable_payload());
      

      // Validation for UntrustedPageHandler.4
      bool success = true;
      UntrustedPageHandler_OnCopy_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UntrustedPageHandler::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnCopy(        );
      return true;
    }
    case messages::UntrustedPageHandler::kOnLineSpaceChange: {
      DCHECK(message->is_serialized());
      internal::UntrustedPageHandler_OnLineSpaceChange_Params_Data* params =
          reinterpret_cast<internal::UntrustedPageHandler_OnLineSpaceChange_Params_Data*>(
              message->mutable_payload());
      

      // Validation for UntrustedPageHandler.5
      bool success = true;
      LineSpacing p_line_spacing{};
      UntrustedPageHandler_OnLineSpaceChange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLineSpacing(&p_line_spacing))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UntrustedPageHandler::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnLineSpaceChange(        
        std::move(p_line_spacing));
      return true;
    }
    case messages::UntrustedPageHandler::kOnLetterSpaceChange: {
      DCHECK(message->is_serialized());
      internal::UntrustedPageHandler_OnLetterSpaceChange_Params_Data* params =
          reinterpret_cast<internal::UntrustedPageHandler_OnLetterSpaceChange_Params_Data*>(
              message->mutable_payload());
      

      // Validation for UntrustedPageHandler.6
      bool success = true;
      LetterSpacing p_letter_spacing{};
      UntrustedPageHandler_OnLetterSpaceChange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLetterSpacing(&p_letter_spacing))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UntrustedPageHandler::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnLetterSpaceChange(        
        std::move(p_letter_spacing));
      return true;
    }
    case messages::UntrustedPageHandler::kOnFontChange: {
      DCHECK(message->is_serialized());
      internal::UntrustedPageHandler_OnFontChange_Params_Data* params =
          reinterpret_cast<internal::UntrustedPageHandler_OnFontChange_Params_Data*>(
              message->mutable_payload());
      

      // Validation for UntrustedPageHandler.7
      bool success = true;
      std::string p_font{};
      UntrustedPageHandler_OnFontChange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFont(&p_font))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UntrustedPageHandler::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFontChange(        
        std::move(p_font));
      return true;
    }
    case messages::UntrustedPageHandler::kOnFontSizeChange: {
      DCHECK(message->is_serialized());
      internal::UntrustedPageHandler_OnFontSizeChange_Params_Data* params =
          reinterpret_cast<internal::UntrustedPageHandler_OnFontSizeChange_Params_Data*>(
              message->mutable_payload());
      

      // Validation for UntrustedPageHandler.8
      bool success = true;
      double p_font_size{};
      UntrustedPageHandler_OnFontSizeChange_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_font_size = input_data_view.font_size();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UntrustedPageHandler::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFontSizeChange(        
        std::move(p_font_size));
      return true;
    }
    case messages::UntrustedPageHandler::kOnLinksEnabledChanged: {
      DCHECK(message->is_serialized());
      internal::UntrustedPageHandler_OnLinksEnabledChanged_Params_Data* params =
          reinterpret_cast<internal::UntrustedPageHandler_OnLinksEnabledChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for UntrustedPageHandler.9
      bool success = true;
      bool p_enabled{};
      UntrustedPageHandler_OnLinksEnabledChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_enabled = input_data_view.enabled();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UntrustedPageHandler::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnLinksEnabledChanged(        
        std::move(p_enabled));
      return true;
    }
    case messages::UntrustedPageHandler::kOnImagesEnabledChanged: {
      DCHECK(message->is_serialized());
      internal::UntrustedPageHandler_OnImagesEnabledChanged_Params_Data* params =
          reinterpret_cast<internal::UntrustedPageHandler_OnImagesEnabledChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for UntrustedPageHandler.10
      bool success = true;
      bool p_enabled{};
      UntrustedPageHandler_OnImagesEnabledChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_enabled = input_data_view.enabled();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UntrustedPageHandler::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnImagesEnabledChanged(        
        std::move(p_enabled));
      return true;
    }
    case messages::UntrustedPageHandler::kOnColorChange: {
      DCHECK(message->is_serialized());
      internal::UntrustedPageHandler_OnColorChange_Params_Data* params =
          reinterpret_cast<internal::UntrustedPageHandler_OnColorChange_Params_Data*>(
              message->mutable_payload());
      

      // Validation for UntrustedPageHandler.11
      bool success = true;
      Colors p_color{};
      UntrustedPageHandler_OnColorChange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadColor(&p_color))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UntrustedPageHandler::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnColorChange(        
        std::move(p_color));
      return true;
    }
    case messages::UntrustedPageHandler::kOnSpeechRateChange: {
      DCHECK(message->is_serialized());
      internal::UntrustedPageHandler_OnSpeechRateChange_Params_Data* params =
          reinterpret_cast<internal::UntrustedPageHandler_OnSpeechRateChange_Params_Data*>(
              message->mutable_payload());
      

      // Validation for UntrustedPageHandler.12
      bool success = true;
      double p_rate{};
      UntrustedPageHandler_OnSpeechRateChange_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_rate = input_data_view.rate();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UntrustedPageHandler::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSpeechRateChange(        
        std::move(p_rate));
      return true;
    }
    case messages::UntrustedPageHandler::kOnVoiceChange: {
      DCHECK(message->is_serialized());
      internal::UntrustedPageHandler_OnVoiceChange_Params_Data* params =
          reinterpret_cast<internal::UntrustedPageHandler_OnVoiceChange_Params_Data*>(
              message->mutable_payload());
      

      // Validation for UntrustedPageHandler.13
      bool success = true;
      std::string p_voice{};
      std::string p_lang{};
      UntrustedPageHandler_OnVoiceChange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadVoice(&p_voice))
        success = false;
      if (success && !input_data_view.ReadLang(&p_lang))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UntrustedPageHandler::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnVoiceChange(        
        std::move(p_voice), 
        std::move(p_lang));
      return true;
    }
    case messages::UntrustedPageHandler::kOnLanguagePrefChange: {
      DCHECK(message->is_serialized());
      internal::UntrustedPageHandler_OnLanguagePrefChange_Params_Data* params =
          reinterpret_cast<internal::UntrustedPageHandler_OnLanguagePrefChange_Params_Data*>(
              message->mutable_payload());
      

      // Validation for UntrustedPageHandler.14
      bool success = true;
      std::string p_lang{};
      bool p_enabled{};
      UntrustedPageHandler_OnLanguagePrefChange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLang(&p_lang))
        success = false;
      if (success)
        p_enabled = input_data_view.enabled();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UntrustedPageHandler::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnLanguagePrefChange(        
        std::move(p_lang), 
        std::move(p_enabled));
      return true;
    }
    case messages::UntrustedPageHandler::kLogExtensionState: {
      DCHECK(message->is_serialized());
      internal::UntrustedPageHandler_LogExtensionState_Params_Data* params =
          reinterpret_cast<internal::UntrustedPageHandler_LogExtensionState_Params_Data*>(
              message->mutable_payload());
      

      // Validation for UntrustedPageHandler.15
      bool success = true;
      UntrustedPageHandler_LogExtensionState_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UntrustedPageHandler::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LogExtensionState(        );
      return true;
    }
    case messages::UntrustedPageHandler::kOnHighlightGranularityChanged: {
      DCHECK(message->is_serialized());
      internal::UntrustedPageHandler_OnHighlightGranularityChanged_Params_Data* params =
          reinterpret_cast<internal::UntrustedPageHandler_OnHighlightGranularityChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for UntrustedPageHandler.16
      bool success = true;
      HighlightGranularity p_granularity{};
      UntrustedPageHandler_OnHighlightGranularityChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadGranularity(&p_granularity))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UntrustedPageHandler::Name_, 16, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnHighlightGranularityChanged(        
        std::move(p_granularity));
      return true;
    }
    case messages::UntrustedPageHandler::kOnReadAloudAudioStateChange: {
      DCHECK(message->is_serialized());
      internal::UntrustedPageHandler_OnReadAloudAudioStateChange_Params_Data* params =
          reinterpret_cast<internal::UntrustedPageHandler_OnReadAloudAudioStateChange_Params_Data*>(
              message->mutable_payload());
      

      // Validation for UntrustedPageHandler.17
      bool success = true;
      bool p_playing{};
      UntrustedPageHandler_OnReadAloudAudioStateChange_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_playing = input_data_view.playing();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UntrustedPageHandler::Name_, 17, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnReadAloudAudioStateChange(        
        std::move(p_playing));
      return true;
    }
    case messages::UntrustedPageHandler::kOnLinkClicked: {
      DCHECK(message->is_serialized());
      internal::UntrustedPageHandler_OnLinkClicked_Params_Data* params =
          reinterpret_cast<internal::UntrustedPageHandler_OnLinkClicked_Params_Data*>(
              message->mutable_payload());
      

      // Validation for UntrustedPageHandler.18
      bool success = true;
      ::ui::AXTreeID p_target_tree_id{};
      int32_t p_target_node_id{};
      UntrustedPageHandler_OnLinkClicked_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTargetTreeId(&p_target_tree_id))
        success = false;
      if (success)
        p_target_node_id = input_data_view.target_node_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UntrustedPageHandler::Name_, 18, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnLinkClicked(        
        std::move(p_target_tree_id), 
        std::move(p_target_node_id));
      return true;
    }
    case messages::UntrustedPageHandler::kOnImageDataRequested: {
      DCHECK(message->is_serialized());
      internal::UntrustedPageHandler_OnImageDataRequested_Params_Data* params =
          reinterpret_cast<internal::UntrustedPageHandler_OnImageDataRequested_Params_Data*>(
              message->mutable_payload());
      

      // Validation for UntrustedPageHandler.19
      bool success = true;
      ::ui::AXTreeID p_target_tree_id{};
      int32_t p_target_node_id{};
      UntrustedPageHandler_OnImageDataRequested_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTargetTreeId(&p_target_tree_id))
        success = false;
      if (success)
        p_target_node_id = input_data_view.target_node_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UntrustedPageHandler::Name_, 19, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnImageDataRequested(        
        std::move(p_target_tree_id), 
        std::move(p_target_node_id));
      return true;
    }
    case messages::UntrustedPageHandler::kOnSelectionChange: {
      DCHECK(message->is_serialized());
      internal::UntrustedPageHandler_OnSelectionChange_Params_Data* params =
          reinterpret_cast<internal::UntrustedPageHandler_OnSelectionChange_Params_Data*>(
              message->mutable_payload());
      

      // Validation for UntrustedPageHandler.20
      bool success = true;
      ::ui::AXTreeID p_target_tree_id{};
      int32_t p_anchor_node_id{};
      int32_t p_anchor_offset{};
      int32_t p_focus_node_id{};
      int32_t p_focus_offset{};
      UntrustedPageHandler_OnSelectionChange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTargetTreeId(&p_target_tree_id))
        success = false;
      if (success)
        p_anchor_node_id = input_data_view.anchor_node_id();
      if (success)
        p_anchor_offset = input_data_view.anchor_offset();
      if (success)
        p_focus_node_id = input_data_view.focus_node_id();
      if (success)
        p_focus_offset = input_data_view.focus_offset();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UntrustedPageHandler::Name_, 20, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSelectionChange(        
        std::move(p_target_tree_id), 
        std::move(p_anchor_node_id), 
        std::move(p_anchor_offset), 
        std::move(p_focus_node_id), 
        std::move(p_focus_offset));
      return true;
    }
    case messages::UntrustedPageHandler::kOnCollapseSelection: {
      DCHECK(message->is_serialized());
      internal::UntrustedPageHandler_OnCollapseSelection_Params_Data* params =
          reinterpret_cast<internal::UntrustedPageHandler_OnCollapseSelection_Params_Data*>(
              message->mutable_payload());
      

      // Validation for UntrustedPageHandler.21
      bool success = true;
      UntrustedPageHandler_OnCollapseSelection_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UntrustedPageHandler::Name_, 21, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnCollapseSelection(        );
      return true;
    }
    case messages::UntrustedPageHandler::kOnScreenshotRequested: {
      DCHECK(message->is_serialized());
      internal::UntrustedPageHandler_OnScreenshotRequested_Params_Data* params =
          reinterpret_cast<internal::UntrustedPageHandler_OnScreenshotRequested_Params_Data*>(
              message->mutable_payload());
      

      // Validation for UntrustedPageHandler.22
      bool success = true;
      UntrustedPageHandler_OnScreenshotRequested_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UntrustedPageHandler::Name_, 22, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnScreenshotRequested(        );
      return true;
    }
    case messages::UntrustedPageHandler::kScrollToTargetNode: {
      DCHECK(message->is_serialized());
      internal::UntrustedPageHandler_ScrollToTargetNode_Params_Data* params =
          reinterpret_cast<internal::UntrustedPageHandler_ScrollToTargetNode_Params_Data*>(
              message->mutable_payload());
      

      // Validation for UntrustedPageHandler.23
      bool success = true;
      ::ui::AXTreeID p_target_tree_id{};
      int32_t p_target_node_id{};
      UntrustedPageHandler_ScrollToTargetNode_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTargetTreeId(&p_target_tree_id))
        success = false;
      if (success)
        p_target_node_id = input_data_view.target_node_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UntrustedPageHandler::Name_, 23, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ScrollToTargetNode(        
        std::move(p_target_tree_id), 
        std::move(p_target_node_id));
      return true;
    }
  }
  return false;
}

// static
bool UntrustedPageHandlerStubDispatch::AcceptWithResponder(
    UntrustedPageHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::UntrustedPageHandler>(message->header()->name)) {
    case messages::UntrustedPageHandler::kGetDependencyParserModel: {
      internal::UntrustedPageHandler_GetDependencyParserModel_Params_Data* params =
          reinterpret_cast<
              internal::UntrustedPageHandler_GetDependencyParserModel_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for UntrustedPageHandler.0
      bool success = true;
      UntrustedPageHandler_GetDependencyParserModel_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UntrustedPageHandler::Name_, 0, false);
        return false;
      }
      auto callback =
          UntrustedPageHandler_GetDependencyParserModel_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDependencyParserModel(std::move(callback));
      return true;
    }
    case messages::UntrustedPageHandler::kGetVoicePackInfo: {
      break;
    }
    case messages::UntrustedPageHandler::kInstallVoicePack: {
      break;
    }
    case messages::UntrustedPageHandler::kUninstallVoice: {
      break;
    }
    case messages::UntrustedPageHandler::kOnCopy: {
      break;
    }
    case messages::UntrustedPageHandler::kOnLineSpaceChange: {
      break;
    }
    case messages::UntrustedPageHandler::kOnLetterSpaceChange: {
      break;
    }
    case messages::UntrustedPageHandler::kOnFontChange: {
      break;
    }
    case messages::UntrustedPageHandler::kOnFontSizeChange: {
      break;
    }
    case messages::UntrustedPageHandler::kOnLinksEnabledChanged: {
      break;
    }
    case messages::UntrustedPageHandler::kOnImagesEnabledChanged: {
      break;
    }
    case messages::UntrustedPageHandler::kOnColorChange: {
      break;
    }
    case messages::UntrustedPageHandler::kOnSpeechRateChange: {
      break;
    }
    case messages::UntrustedPageHandler::kOnVoiceChange: {
      break;
    }
    case messages::UntrustedPageHandler::kOnLanguagePrefChange: {
      break;
    }
    case messages::UntrustedPageHandler::kLogExtensionState: {
      break;
    }
    case messages::UntrustedPageHandler::kOnHighlightGranularityChanged: {
      break;
    }
    case messages::UntrustedPageHandler::kOnReadAloudAudioStateChange: {
      break;
    }
    case messages::UntrustedPageHandler::kOnLinkClicked: {
      break;
    }
    case messages::UntrustedPageHandler::kOnImageDataRequested: {
      break;
    }
    case messages::UntrustedPageHandler::kOnSelectionChange: {
      break;
    }
    case messages::UntrustedPageHandler::kOnCollapseSelection: {
      break;
    }
    case messages::UntrustedPageHandler::kOnScreenshotRequested: {
      break;
    }
    case messages::UntrustedPageHandler::kScrollToTargetNode: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kUntrustedPageHandlerValidationInfo[] = {
    { &internal::UntrustedPageHandler_GetDependencyParserModel_Params_Data::Validate,
     &internal::UntrustedPageHandler_GetDependencyParserModel_ResponseParams_Data::Validate},
    { &internal::UntrustedPageHandler_GetVoicePackInfo_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::UntrustedPageHandler_InstallVoicePack_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::UntrustedPageHandler_UninstallVoice_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::UntrustedPageHandler_OnCopy_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::UntrustedPageHandler_OnLineSpaceChange_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::UntrustedPageHandler_OnLetterSpaceChange_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::UntrustedPageHandler_OnFontChange_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::UntrustedPageHandler_OnFontSizeChange_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::UntrustedPageHandler_OnLinksEnabledChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::UntrustedPageHandler_OnImagesEnabledChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::UntrustedPageHandler_OnColorChange_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::UntrustedPageHandler_OnSpeechRateChange_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::UntrustedPageHandler_OnVoiceChange_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::UntrustedPageHandler_OnLanguagePrefChange_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::UntrustedPageHandler_LogExtensionState_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::UntrustedPageHandler_OnHighlightGranularityChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::UntrustedPageHandler_OnReadAloudAudioStateChange_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::UntrustedPageHandler_OnLinkClicked_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::UntrustedPageHandler_OnImageDataRequested_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::UntrustedPageHandler_OnSelectionChange_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::UntrustedPageHandler_OnCollapseSelection_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::UntrustedPageHandler_OnScreenshotRequested_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::UntrustedPageHandler_ScrollToTargetNode_Params_Data::Validate,
     nullptr /* no response */},
};

bool UntrustedPageHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::read_anything::mojom::UntrustedPageHandler::Name_,
    kUntrustedPageHandlerValidationInfo);
}

bool UntrustedPageHandlerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::read_anything::mojom::UntrustedPageHandler::Name_,
    kUntrustedPageHandlerValidationInfo);
}
// The declaration includes the definition on other builds.

UntrustedPage::IPCStableHashFunction UntrustedPage::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::UntrustedPage>(message.name())) {
    case messages::UntrustedPage::kAccessibilityEventReceived: {
      return &UntrustedPage::AccessibilityEventReceived_Sym::IPCStableHash;
    }
    case messages::UntrustedPage::kOnGetVoicePackInfo: {
      return &UntrustedPage::OnGetVoicePackInfo_Sym::IPCStableHash;
    }
    case messages::UntrustedPage::kAccessibilityLocationChangesReceived: {
      return &UntrustedPage::AccessibilityLocationChangesReceived_Sym::IPCStableHash;
    }
    case messages::UntrustedPage::kOnActiveAXTreeIDChanged: {
      return &UntrustedPage::OnActiveAXTreeIDChanged_Sym::IPCStableHash;
    }
    case messages::UntrustedPage::kOnAXTreeDestroyed: {
      return &UntrustedPage::OnAXTreeDestroyed_Sym::IPCStableHash;
    }
    case messages::UntrustedPage::kSetLanguageCode: {
      return &UntrustedPage::SetLanguageCode_Sym::IPCStableHash;
    }
    case messages::UntrustedPage::kOnTtsEngineInstalled: {
      return &UntrustedPage::OnTtsEngineInstalled_Sym::IPCStableHash;
    }
    case messages::UntrustedPage::kSetDefaultLanguageCode: {
      return &UntrustedPage::SetDefaultLanguageCode_Sym::IPCStableHash;
    }
    case messages::UntrustedPage::kOnSettingsRestoredFromPrefs: {
      return &UntrustedPage::OnSettingsRestoredFromPrefs_Sym::IPCStableHash;
    }
    case messages::UntrustedPage::kScreenAIServiceReady: {
      return &UntrustedPage::ScreenAIServiceReady_Sym::IPCStableHash;
    }
    case messages::UntrustedPage::kOnReadingModeHidden: {
      return &UntrustedPage::OnReadingModeHidden_Sym::IPCStableHash;
    }
    case messages::UntrustedPage::kOnTabWillDetach: {
      return &UntrustedPage::OnTabWillDetach_Sym::IPCStableHash;
    }
    case messages::UntrustedPage::kOnTabMuteStateChange: {
      return &UntrustedPage::OnTabMuteStateChange_Sym::IPCStableHash;
    }
    case messages::UntrustedPage::kOnImageDataDownloaded: {
      return &UntrustedPage::OnImageDataDownloaded_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* UntrustedPage::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::UntrustedPage>(message.name())) {
      case messages::UntrustedPage::kAccessibilityEventReceived:
            return "Receive read_anything::mojom::UntrustedPage::AccessibilityEventReceived";
      case messages::UntrustedPage::kOnGetVoicePackInfo:
            return "Receive read_anything::mojom::UntrustedPage::OnGetVoicePackInfo";
      case messages::UntrustedPage::kAccessibilityLocationChangesReceived:
            return "Receive read_anything::mojom::UntrustedPage::AccessibilityLocationChangesReceived";
      case messages::UntrustedPage::kOnActiveAXTreeIDChanged:
            return "Receive read_anything::mojom::UntrustedPage::OnActiveAXTreeIDChanged";
      case messages::UntrustedPage::kOnAXTreeDestroyed:
            return "Receive read_anything::mojom::UntrustedPage::OnAXTreeDestroyed";
      case messages::UntrustedPage::kSetLanguageCode:
            return "Receive read_anything::mojom::UntrustedPage::SetLanguageCode";
      case messages::UntrustedPage::kOnTtsEngineInstalled:
            return "Receive read_anything::mojom::UntrustedPage::OnTtsEngineInstalled";
      case messages::UntrustedPage::kSetDefaultLanguageCode:
            return "Receive read_anything::mojom::UntrustedPage::SetDefaultLanguageCode";
      case messages::UntrustedPage::kOnSettingsRestoredFromPrefs:
            return "Receive read_anything::mojom::UntrustedPage::OnSettingsRestoredFromPrefs";
      case messages::UntrustedPage::kScreenAIServiceReady:
            return "Receive read_anything::mojom::UntrustedPage::ScreenAIServiceReady";
      case messages::UntrustedPage::kOnReadingModeHidden:
            return "Receive read_anything::mojom::UntrustedPage::OnReadingModeHidden";
      case messages::UntrustedPage::kOnTabWillDetach:
            return "Receive read_anything::mojom::UntrustedPage::OnTabWillDetach";
      case messages::UntrustedPage::kOnTabMuteStateChange:
            return "Receive read_anything::mojom::UntrustedPage::OnTabMuteStateChange";
      case messages::UntrustedPage::kOnImageDataDownloaded:
            return "Receive read_anything::mojom::UntrustedPage::OnImageDataDownloaded";
    }
  } else {
    switch (static_cast<messages::UntrustedPage>(message.name())) {
      case messages::UntrustedPage::kAccessibilityEventReceived:
            return "Receive reply read_anything::mojom::UntrustedPage::AccessibilityEventReceived";
      case messages::UntrustedPage::kOnGetVoicePackInfo:
            return "Receive reply read_anything::mojom::UntrustedPage::OnGetVoicePackInfo";
      case messages::UntrustedPage::kAccessibilityLocationChangesReceived:
            return "Receive reply read_anything::mojom::UntrustedPage::AccessibilityLocationChangesReceived";
      case messages::UntrustedPage::kOnActiveAXTreeIDChanged:
            return "Receive reply read_anything::mojom::UntrustedPage::OnActiveAXTreeIDChanged";
      case messages::UntrustedPage::kOnAXTreeDestroyed:
            return "Receive reply read_anything::mojom::UntrustedPage::OnAXTreeDestroyed";
      case messages::UntrustedPage::kSetLanguageCode:
            return "Receive reply read_anything::mojom::UntrustedPage::SetLanguageCode";
      case messages::UntrustedPage::kOnTtsEngineInstalled:
            return "Receive reply read_anything::mojom::UntrustedPage::OnTtsEngineInstalled";
      case messages::UntrustedPage::kSetDefaultLanguageCode:
            return "Receive reply read_anything::mojom::UntrustedPage::SetDefaultLanguageCode";
      case messages::UntrustedPage::kOnSettingsRestoredFromPrefs:
            return "Receive reply read_anything::mojom::UntrustedPage::OnSettingsRestoredFromPrefs";
      case messages::UntrustedPage::kScreenAIServiceReady:
            return "Receive reply read_anything::mojom::UntrustedPage::ScreenAIServiceReady";
      case messages::UntrustedPage::kOnReadingModeHidden:
            return "Receive reply read_anything::mojom::UntrustedPage::OnReadingModeHidden";
      case messages::UntrustedPage::kOnTabWillDetach:
            return "Receive reply read_anything::mojom::UntrustedPage::OnTabWillDetach";
      case messages::UntrustedPage::kOnTabMuteStateChange:
            return "Receive reply read_anything::mojom::UntrustedPage::OnTabMuteStateChange";
      case messages::UntrustedPage::kOnImageDataDownloaded:
            return "Receive reply read_anything::mojom::UntrustedPage::OnImageDataDownloaded";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t UntrustedPage::AccessibilityEventReceived_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7dd0d973;  // IPCStableHash for read_anything::mojom::UntrustedPage::AccessibilityEventReceived
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UntrustedPage::OnGetVoicePackInfo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3b53c06b;  // IPCStableHash for read_anything::mojom::UntrustedPage::OnGetVoicePackInfo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UntrustedPage::AccessibilityLocationChangesReceived_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x851a9f96;  // IPCStableHash for read_anything::mojom::UntrustedPage::AccessibilityLocationChangesReceived
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UntrustedPage::OnActiveAXTreeIDChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x37ca32ef;  // IPCStableHash for read_anything::mojom::UntrustedPage::OnActiveAXTreeIDChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UntrustedPage::OnAXTreeDestroyed_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x27b241e1;  // IPCStableHash for read_anything::mojom::UntrustedPage::OnAXTreeDestroyed
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UntrustedPage::SetLanguageCode_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3fb144db;  // IPCStableHash for read_anything::mojom::UntrustedPage::SetLanguageCode
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UntrustedPage::OnTtsEngineInstalled_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x20d3a84e;  // IPCStableHash for read_anything::mojom::UntrustedPage::OnTtsEngineInstalled
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UntrustedPage::SetDefaultLanguageCode_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5e202fca;  // IPCStableHash for read_anything::mojom::UntrustedPage::SetDefaultLanguageCode
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UntrustedPage::OnSettingsRestoredFromPrefs_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcb2666d0;  // IPCStableHash for read_anything::mojom::UntrustedPage::OnSettingsRestoredFromPrefs
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UntrustedPage::ScreenAIServiceReady_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcddbb64f;  // IPCStableHash for read_anything::mojom::UntrustedPage::ScreenAIServiceReady
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UntrustedPage::OnReadingModeHidden_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3ef16dca;  // IPCStableHash for read_anything::mojom::UntrustedPage::OnReadingModeHidden
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UntrustedPage::OnTabWillDetach_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7416c189;  // IPCStableHash for read_anything::mojom::UntrustedPage::OnTabWillDetach
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UntrustedPage::OnTabMuteStateChange_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7a4b6849;  // IPCStableHash for read_anything::mojom::UntrustedPage::OnTabMuteStateChange
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UntrustedPage::OnImageDataDownloaded_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6080c132;  // IPCStableHash for read_anything::mojom::UntrustedPage::OnImageDataDownloaded
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

UntrustedPageProxy::UntrustedPageProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void UntrustedPageProxy::AccessibilityEventReceived(
    const ::ui::AXTreeID& in_tree_id, const std::vector<::ui::AXTreeUpdate>& in_updates, const std::vector<::ui::AXEvent>& in_events) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send read_anything::mojom::UntrustedPage::AccessibilityEventReceived", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tree_id"), in_tree_id,
                        "<value of type const ::ui::AXTreeID&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("updates"), in_updates,
                        "<value of type const std::vector<::ui::AXTreeUpdate>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("events"), in_events,
                        "<value of type const std::vector<::ui::AXEvent>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UntrustedPage::kAccessibilityEventReceived), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::read_anything::mojom::internal::UntrustedPage_AccessibilityEventReceived_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->tree_id)>
      tree_id_fragment(params.message());
  tree_id_fragment.Claim(&params->tree_id);
  
  mojo::internal::Serialize<::ax::mojom::AXTreeIDDataView>(
    in_tree_id,
    tree_id_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->tree_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null tree_id in UntrustedPage.AccessibilityEventReceived request");
  mojo::internal::MessageFragment<
      typename decltype(params->updates)::BaseType>
      updates_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& updates_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::ax::mojom::AXTreeUpdateDataView>>(
    in_updates,
    updates_fragment,
    &updates_validate_params);

  params->updates.Set(
      updates_fragment.is_null() ? nullptr : updates_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->updates.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null updates in UntrustedPage.AccessibilityEventReceived request");
  mojo::internal::MessageFragment<
      typename decltype(params->events)::BaseType>
      events_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& events_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::ax::mojom::AXEventDataView>>(
    in_events,
    events_fragment,
    &events_validate_params);

  params->events.Set(
      events_fragment.is_null() ? nullptr : events_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->events.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null events in UntrustedPage.AccessibilityEventReceived request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UntrustedPage::Name_);
  message.set_method_name("AccessibilityEventReceived");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void UntrustedPageProxy::OnGetVoicePackInfo(
    VoicePackInfoPtr in_voice_pack_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send read_anything::mojom::UntrustedPage::OnGetVoicePackInfo", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("voice_pack_info"), in_voice_pack_info,
                        "<value of type VoicePackInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UntrustedPage::kOnGetVoicePackInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::read_anything::mojom::internal::UntrustedPage_OnGetVoicePackInfo_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->voice_pack_info)::BaseType> voice_pack_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::read_anything::mojom::VoicePackInfoDataView>(
    in_voice_pack_info,
    voice_pack_info_fragment);

  params->voice_pack_info.Set(
      voice_pack_info_fragment.is_null() ? nullptr : voice_pack_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->voice_pack_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null voice_pack_info in UntrustedPage.OnGetVoicePackInfo request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UntrustedPage::Name_);
  message.set_method_name("OnGetVoicePackInfo");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void UntrustedPageProxy::AccessibilityLocationChangesReceived(
    const ::ui::AXTreeID& in_tree_id, const ::ui::AXLocationAndScrollUpdates& in_details) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send read_anything::mojom::UntrustedPage::AccessibilityLocationChangesReceived", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tree_id"), in_tree_id,
                        "<value of type const ::ui::AXTreeID&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("details"), in_details,
                        "<value of type const ::ui::AXLocationAndScrollUpdates&>");
   });
#endif

  CHECK(base::FeatureList::IsEnabled(::ax::mojom::features::kReadAnythingDocsIntegration));
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UntrustedPage::kAccessibilityLocationChangesReceived), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::read_anything::mojom::internal::UntrustedPage_AccessibilityLocationChangesReceived_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->tree_id)>
      tree_id_fragment(params.message());
  tree_id_fragment.Claim(&params->tree_id);
  
  mojo::internal::Serialize<::ax::mojom::AXTreeIDDataView>(
    in_tree_id,
    tree_id_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->tree_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null tree_id in UntrustedPage.AccessibilityLocationChangesReceived request");
  mojo::internal::MessageFragment<
      typename decltype(params->details)::BaseType> details_fragment(
          params.message());
  
  mojo::internal::Serialize<::ax::mojom::AXLocationAndScrollUpdatesDataView>(
    in_details,
    details_fragment);

  params->details.Set(
      details_fragment.is_null() ? nullptr : details_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->details.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null details in UntrustedPage.AccessibilityLocationChangesReceived request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UntrustedPage::Name_);
  message.set_method_name("AccessibilityLocationChangesReceived");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void UntrustedPageProxy::OnActiveAXTreeIDChanged(
    const ::ui::AXTreeID& in_tree_id, int64_t in_ukm_source_id, bool in_is_pdf) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send read_anything::mojom::UntrustedPage::OnActiveAXTreeIDChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tree_id"), in_tree_id,
                        "<value of type const ::ui::AXTreeID&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ukm_source_id"), in_ukm_source_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_pdf"), in_is_pdf,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UntrustedPage::kOnActiveAXTreeIDChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::read_anything::mojom::internal::UntrustedPage_OnActiveAXTreeIDChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->tree_id)>
      tree_id_fragment(params.message());
  tree_id_fragment.Claim(&params->tree_id);
  
  mojo::internal::Serialize<::ax::mojom::AXTreeIDDataView>(
    in_tree_id,
    tree_id_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->tree_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null tree_id in UntrustedPage.OnActiveAXTreeIDChanged request");

  params->ukm_source_id = in_ukm_source_id;

  params->is_pdf = in_is_pdf;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UntrustedPage::Name_);
  message.set_method_name("OnActiveAXTreeIDChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void UntrustedPageProxy::OnAXTreeDestroyed(
    const ::ui::AXTreeID& in_tree_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send read_anything::mojom::UntrustedPage::OnAXTreeDestroyed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tree_id"), in_tree_id,
                        "<value of type const ::ui::AXTreeID&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UntrustedPage::kOnAXTreeDestroyed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::read_anything::mojom::internal::UntrustedPage_OnAXTreeDestroyed_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->tree_id)>
      tree_id_fragment(params.message());
  tree_id_fragment.Claim(&params->tree_id);
  
  mojo::internal::Serialize<::ax::mojom::AXTreeIDDataView>(
    in_tree_id,
    tree_id_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->tree_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null tree_id in UntrustedPage.OnAXTreeDestroyed request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UntrustedPage::Name_);
  message.set_method_name("OnAXTreeDestroyed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void UntrustedPageProxy::SetLanguageCode(
    const std::string& in_code) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send read_anything::mojom::UntrustedPage::SetLanguageCode", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("code"), in_code,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UntrustedPage::kSetLanguageCode), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::read_anything::mojom::internal::UntrustedPage_SetLanguageCode_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->code)::BaseType> code_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_code,
    code_fragment);

  params->code.Set(
      code_fragment.is_null() ? nullptr : code_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->code.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null code in UntrustedPage.SetLanguageCode request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UntrustedPage::Name_);
  message.set_method_name("SetLanguageCode");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void UntrustedPageProxy::OnTtsEngineInstalled(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send read_anything::mojom::UntrustedPage::OnTtsEngineInstalled");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UntrustedPage::kOnTtsEngineInstalled), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::read_anything::mojom::internal::UntrustedPage_OnTtsEngineInstalled_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UntrustedPage::Name_);
  message.set_method_name("OnTtsEngineInstalled");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void UntrustedPageProxy::SetDefaultLanguageCode(
    const std::string& in_code) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send read_anything::mojom::UntrustedPage::SetDefaultLanguageCode", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("code"), in_code,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UntrustedPage::kSetDefaultLanguageCode), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::read_anything::mojom::internal::UntrustedPage_SetDefaultLanguageCode_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->code)::BaseType> code_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_code,
    code_fragment);

  params->code.Set(
      code_fragment.is_null() ? nullptr : code_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->code.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null code in UntrustedPage.SetDefaultLanguageCode request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UntrustedPage::Name_);
  message.set_method_name("SetDefaultLanguageCode");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void UntrustedPageProxy::OnSettingsRestoredFromPrefs(
    LineSpacing in_line_spacing, LetterSpacing in_letter_spacing, const std::string& in_font, double in_font_size, bool in_links_enabled, bool in_images_enabled, Colors in_color, double in_speech_rate, ::base::Value::Dict in_voices, ::base::Value::List in_languages_enabled_in_pref, HighlightGranularity in_granularity) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send read_anything::mojom::UntrustedPage::OnSettingsRestoredFromPrefs", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("line_spacing"), in_line_spacing,
                        "<value of type LineSpacing>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("letter_spacing"), in_letter_spacing,
                        "<value of type LetterSpacing>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("font"), in_font,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("font_size"), in_font_size,
                        "<value of type double>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("links_enabled"), in_links_enabled,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("images_enabled"), in_images_enabled,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("color"), in_color,
                        "<value of type Colors>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("speech_rate"), in_speech_rate,
                        "<value of type double>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("voices"), in_voices,
                        "<value of type ::base::Value::Dict>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("languages_enabled_in_pref"), in_languages_enabled_in_pref,
                        "<value of type ::base::Value::List>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("granularity"), in_granularity,
                        "<value of type HighlightGranularity>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UntrustedPage::kOnSettingsRestoredFromPrefs), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::read_anything::mojom::internal::UntrustedPage_OnSettingsRestoredFromPrefs_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::read_anything::mojom::LineSpacing>(
    in_line_spacing,
    &params->line_spacing);

  
  mojo::internal::Serialize<::read_anything::mojom::LetterSpacing>(
    in_letter_spacing,
    &params->letter_spacing);
  mojo::internal::MessageFragment<
      typename decltype(params->font)::BaseType> font_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_font,
    font_fragment);

  params->font.Set(
      font_fragment.is_null() ? nullptr : font_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->font.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null font in UntrustedPage.OnSettingsRestoredFromPrefs request");

  params->font_size = in_font_size;

  params->links_enabled = in_links_enabled;

  params->images_enabled = in_images_enabled;

  
  mojo::internal::Serialize<::read_anything::mojom::Colors>(
    in_color,
    &params->color);

  params->speech_rate = in_speech_rate;
  mojo::internal::MessageFragment<
      typename decltype(params->voices)::BaseType> voices_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::DictionaryValueDataView>(
    in_voices,
    voices_fragment);

  params->voices.Set(
      voices_fragment.is_null() ? nullptr : voices_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->voices.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null voices in UntrustedPage.OnSettingsRestoredFromPrefs request");
  mojo::internal::MessageFragment<
      typename decltype(params->languages_enabled_in_pref)::BaseType> languages_enabled_in_pref_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ListValueDataView>(
    in_languages_enabled_in_pref,
    languages_enabled_in_pref_fragment);

  params->languages_enabled_in_pref.Set(
      languages_enabled_in_pref_fragment.is_null() ? nullptr : languages_enabled_in_pref_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->languages_enabled_in_pref.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null languages_enabled_in_pref in UntrustedPage.OnSettingsRestoredFromPrefs request");

  
  mojo::internal::Serialize<::read_anything::mojom::HighlightGranularity>(
    in_granularity,
    &params->granularity);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UntrustedPage::Name_);
  message.set_method_name("OnSettingsRestoredFromPrefs");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void UntrustedPageProxy::ScreenAIServiceReady(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send read_anything::mojom::UntrustedPage::ScreenAIServiceReady");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UntrustedPage::kScreenAIServiceReady), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::read_anything::mojom::internal::UntrustedPage_ScreenAIServiceReady_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UntrustedPage::Name_);
  message.set_method_name("ScreenAIServiceReady");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void UntrustedPageProxy::OnReadingModeHidden(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send read_anything::mojom::UntrustedPage::OnReadingModeHidden");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UntrustedPage::kOnReadingModeHidden), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::read_anything::mojom::internal::UntrustedPage_OnReadingModeHidden_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UntrustedPage::Name_);
  message.set_method_name("OnReadingModeHidden");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void UntrustedPageProxy::OnTabWillDetach(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send read_anything::mojom::UntrustedPage::OnTabWillDetach");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UntrustedPage::kOnTabWillDetach), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::read_anything::mojom::internal::UntrustedPage_OnTabWillDetach_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UntrustedPage::Name_);
  message.set_method_name("OnTabWillDetach");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void UntrustedPageProxy::OnTabMuteStateChange(
    bool in_muted) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send read_anything::mojom::UntrustedPage::OnTabMuteStateChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("muted"), in_muted,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UntrustedPage::kOnTabMuteStateChange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::read_anything::mojom::internal::UntrustedPage_OnTabMuteStateChange_Params_Data> params(
          message);
  params.Allocate();

  params->muted = in_muted;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UntrustedPage::Name_);
  message.set_method_name("OnTabMuteStateChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void UntrustedPageProxy::OnImageDataDownloaded(
    const ::ui::AXTreeID& in_tree_id, int32_t in_node_id, const ::SkBitmap& in_image) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send read_anything::mojom::UntrustedPage::OnImageDataDownloaded", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tree_id"), in_tree_id,
                        "<value of type const ::ui::AXTreeID&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("node_id"), in_node_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("image"), in_image,
                        "<value of type const ::SkBitmap&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UntrustedPage::kOnImageDataDownloaded), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::read_anything::mojom::internal::UntrustedPage_OnImageDataDownloaded_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->tree_id)>
      tree_id_fragment(params.message());
  tree_id_fragment.Claim(&params->tree_id);
  
  mojo::internal::Serialize<::ax::mojom::AXTreeIDDataView>(
    in_tree_id,
    tree_id_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->tree_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null tree_id in UntrustedPage.OnImageDataDownloaded request");

  params->node_id = in_node_id;
  mojo::internal::MessageFragment<
      typename decltype(params->image)::BaseType> image_fragment(
          params.message());
  
  mojo::internal::Serialize<::skia::mojom::BitmapN32DataView>(
    in_image,
    image_fragment);

  params->image.Set(
      image_fragment.is_null() ? nullptr : image_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->image.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null image in UntrustedPage.OnImageDataDownloaded request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UntrustedPage::Name_);
  message.set_method_name("OnImageDataDownloaded");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool UntrustedPageStubDispatch::Accept(
    UntrustedPage* impl,
    mojo::Message* message) {
  switch (static_cast<messages::UntrustedPage>(message->header()->name)) {
    case messages::UntrustedPage::kAccessibilityEventReceived: {
      DCHECK(message->is_serialized());
      internal::UntrustedPage_AccessibilityEventReceived_Params_Data* params =
          reinterpret_cast<internal::UntrustedPage_AccessibilityEventReceived_Params_Data*>(
              message->mutable_payload());
      

      // Validation for UntrustedPage.0
      bool success = true;
      ::ui::AXTreeID p_tree_id{};
      std::vector<::ui::AXTreeUpdate> p_updates{};
      std::vector<::ui::AXEvent> p_events{};
      UntrustedPage_AccessibilityEventReceived_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTreeId(&p_tree_id))
        success = false;
      if (success && !input_data_view.ReadUpdates(&p_updates))
        success = false;
      if (success && !input_data_view.ReadEvents(&p_events))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UntrustedPage::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AccessibilityEventReceived(        
        std::move(p_tree_id), 
        std::move(p_updates), 
        std::move(p_events));
      return true;
    }
    case messages::UntrustedPage::kOnGetVoicePackInfo: {
      DCHECK(message->is_serialized());
      internal::UntrustedPage_OnGetVoicePackInfo_Params_Data* params =
          reinterpret_cast<internal::UntrustedPage_OnGetVoicePackInfo_Params_Data*>(
              message->mutable_payload());
      

      // Validation for UntrustedPage.1
      bool success = true;
      VoicePackInfoPtr p_voice_pack_info{};
      UntrustedPage_OnGetVoicePackInfo_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadVoicePackInfo(&p_voice_pack_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UntrustedPage::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnGetVoicePackInfo(        
        std::move(p_voice_pack_info));
      return true;
    }
    case messages::UntrustedPage::kAccessibilityLocationChangesReceived: {
      DCHECK(message->is_serialized());
      internal::UntrustedPage_AccessibilityLocationChangesReceived_Params_Data* params =
          reinterpret_cast<internal::UntrustedPage_AccessibilityLocationChangesReceived_Params_Data*>(
              message->mutable_payload());
      

      // Validation for UntrustedPage.2
      bool success = true;
      ::ui::AXTreeID p_tree_id{};
      ::ui::AXLocationAndScrollUpdates p_details{};
      UntrustedPage_AccessibilityLocationChangesReceived_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTreeId(&p_tree_id))
        success = false;
      if (success && !input_data_view.ReadDetails(&p_details))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UntrustedPage::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AccessibilityLocationChangesReceived(        
        std::move(p_tree_id), 
        p_details);
      return true;
    }
    case messages::UntrustedPage::kOnActiveAXTreeIDChanged: {
      DCHECK(message->is_serialized());
      internal::UntrustedPage_OnActiveAXTreeIDChanged_Params_Data* params =
          reinterpret_cast<internal::UntrustedPage_OnActiveAXTreeIDChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for UntrustedPage.3
      bool success = true;
      ::ui::AXTreeID p_tree_id{};
      int64_t p_ukm_source_id{};
      bool p_is_pdf{};
      UntrustedPage_OnActiveAXTreeIDChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTreeId(&p_tree_id))
        success = false;
      if (success)
        p_ukm_source_id = input_data_view.ukm_source_id();
      if (success)
        p_is_pdf = input_data_view.is_pdf();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UntrustedPage::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnActiveAXTreeIDChanged(        
        std::move(p_tree_id), 
        std::move(p_ukm_source_id), 
        std::move(p_is_pdf));
      return true;
    }
    case messages::UntrustedPage::kOnAXTreeDestroyed: {
      DCHECK(message->is_serialized());
      internal::UntrustedPage_OnAXTreeDestroyed_Params_Data* params =
          reinterpret_cast<internal::UntrustedPage_OnAXTreeDestroyed_Params_Data*>(
              message->mutable_payload());
      

      // Validation for UntrustedPage.4
      bool success = true;
      ::ui::AXTreeID p_tree_id{};
      UntrustedPage_OnAXTreeDestroyed_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTreeId(&p_tree_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UntrustedPage::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnAXTreeDestroyed(        
        std::move(p_tree_id));
      return true;
    }
    case messages::UntrustedPage::kSetLanguageCode: {
      DCHECK(message->is_serialized());
      internal::UntrustedPage_SetLanguageCode_Params_Data* params =
          reinterpret_cast<internal::UntrustedPage_SetLanguageCode_Params_Data*>(
              message->mutable_payload());
      

      // Validation for UntrustedPage.5
      bool success = true;
      std::string p_code{};
      UntrustedPage_SetLanguageCode_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCode(&p_code))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UntrustedPage::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetLanguageCode(        
        std::move(p_code));
      return true;
    }
    case messages::UntrustedPage::kOnTtsEngineInstalled: {
      DCHECK(message->is_serialized());
      internal::UntrustedPage_OnTtsEngineInstalled_Params_Data* params =
          reinterpret_cast<internal::UntrustedPage_OnTtsEngineInstalled_Params_Data*>(
              message->mutable_payload());
      

      // Validation for UntrustedPage.6
      bool success = true;
      UntrustedPage_OnTtsEngineInstalled_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UntrustedPage::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnTtsEngineInstalled(        );
      return true;
    }
    case messages::UntrustedPage::kSetDefaultLanguageCode: {
      DCHECK(message->is_serialized());
      internal::UntrustedPage_SetDefaultLanguageCode_Params_Data* params =
          reinterpret_cast<internal::UntrustedPage_SetDefaultLanguageCode_Params_Data*>(
              message->mutable_payload());
      

      // Validation for UntrustedPage.7
      bool success = true;
      std::string p_code{};
      UntrustedPage_SetDefaultLanguageCode_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCode(&p_code))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UntrustedPage::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetDefaultLanguageCode(        
        std::move(p_code));
      return true;
    }
    case messages::UntrustedPage::kOnSettingsRestoredFromPrefs: {
      DCHECK(message->is_serialized());
      internal::UntrustedPage_OnSettingsRestoredFromPrefs_Params_Data* params =
          reinterpret_cast<internal::UntrustedPage_OnSettingsRestoredFromPrefs_Params_Data*>(
              message->mutable_payload());
      

      // Validation for UntrustedPage.8
      bool success = true;
      LineSpacing p_line_spacing{};
      LetterSpacing p_letter_spacing{};
      std::string p_font{};
      double p_font_size{};
      bool p_links_enabled{};
      bool p_images_enabled{};
      Colors p_color{};
      double p_speech_rate{};
      ::base::Value::Dict p_voices{};
      ::base::Value::List p_languages_enabled_in_pref{};
      HighlightGranularity p_granularity{};
      UntrustedPage_OnSettingsRestoredFromPrefs_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLineSpacing(&p_line_spacing))
        success = false;
      if (success && !input_data_view.ReadLetterSpacing(&p_letter_spacing))
        success = false;
      if (success && !input_data_view.ReadFont(&p_font))
        success = false;
      if (success)
        p_font_size = input_data_view.font_size();
      if (success)
        p_links_enabled = input_data_view.links_enabled();
      if (success)
        p_images_enabled = input_data_view.images_enabled();
      if (success && !input_data_view.ReadColor(&p_color))
        success = false;
      if (success)
        p_speech_rate = input_data_view.speech_rate();
      if (success && !input_data_view.ReadVoices(&p_voices))
        success = false;
      if (success && !input_data_view.ReadLanguagesEnabledInPref(&p_languages_enabled_in_pref))
        success = false;
      if (success && !input_data_view.ReadGranularity(&p_granularity))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UntrustedPage::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSettingsRestoredFromPrefs(        
        std::move(p_line_spacing), 
        std::move(p_letter_spacing), 
        std::move(p_font), 
        std::move(p_font_size), 
        std::move(p_links_enabled), 
        std::move(p_images_enabled), 
        std::move(p_color), 
        std::move(p_speech_rate), 
        std::move(p_voices), 
        std::move(p_languages_enabled_in_pref), 
        std::move(p_granularity));
      return true;
    }
    case messages::UntrustedPage::kScreenAIServiceReady: {
      DCHECK(message->is_serialized());
      internal::UntrustedPage_ScreenAIServiceReady_Params_Data* params =
          reinterpret_cast<internal::UntrustedPage_ScreenAIServiceReady_Params_Data*>(
              message->mutable_payload());
      

      // Validation for UntrustedPage.9
      bool success = true;
      UntrustedPage_ScreenAIServiceReady_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UntrustedPage::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ScreenAIServiceReady(        );
      return true;
    }
    case messages::UntrustedPage::kOnReadingModeHidden: {
      DCHECK(message->is_serialized());
      internal::UntrustedPage_OnReadingModeHidden_Params_Data* params =
          reinterpret_cast<internal::UntrustedPage_OnReadingModeHidden_Params_Data*>(
              message->mutable_payload());
      

      // Validation for UntrustedPage.10
      bool success = true;
      UntrustedPage_OnReadingModeHidden_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UntrustedPage::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnReadingModeHidden(        );
      return true;
    }
    case messages::UntrustedPage::kOnTabWillDetach: {
      DCHECK(message->is_serialized());
      internal::UntrustedPage_OnTabWillDetach_Params_Data* params =
          reinterpret_cast<internal::UntrustedPage_OnTabWillDetach_Params_Data*>(
              message->mutable_payload());
      

      // Validation for UntrustedPage.11
      bool success = true;
      UntrustedPage_OnTabWillDetach_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UntrustedPage::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnTabWillDetach(        );
      return true;
    }
    case messages::UntrustedPage::kOnTabMuteStateChange: {
      DCHECK(message->is_serialized());
      internal::UntrustedPage_OnTabMuteStateChange_Params_Data* params =
          reinterpret_cast<internal::UntrustedPage_OnTabMuteStateChange_Params_Data*>(
              message->mutable_payload());
      

      // Validation for UntrustedPage.12
      bool success = true;
      bool p_muted{};
      UntrustedPage_OnTabMuteStateChange_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_muted = input_data_view.muted();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UntrustedPage::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnTabMuteStateChange(        
        std::move(p_muted));
      return true;
    }
    case messages::UntrustedPage::kOnImageDataDownloaded: {
      DCHECK(message->is_serialized());
      internal::UntrustedPage_OnImageDataDownloaded_Params_Data* params =
          reinterpret_cast<internal::UntrustedPage_OnImageDataDownloaded_Params_Data*>(
              message->mutable_payload());
      

      // Validation for UntrustedPage.13
      bool success = true;
      ::ui::AXTreeID p_tree_id{};
      int32_t p_node_id{};
      ::SkBitmap p_image{};
      UntrustedPage_OnImageDataDownloaded_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTreeId(&p_tree_id))
        success = false;
      if (success)
        p_node_id = input_data_view.node_id();
      if (success && !input_data_view.ReadImage(&p_image))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UntrustedPage::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnImageDataDownloaded(        
        std::move(p_tree_id), 
        std::move(p_node_id), 
        std::move(p_image));
      return true;
    }
  }
  return false;
}

// static
bool UntrustedPageStubDispatch::AcceptWithResponder(
    UntrustedPage* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::UntrustedPage>(message->header()->name)) {
    case messages::UntrustedPage::kAccessibilityEventReceived: {
      break;
    }
    case messages::UntrustedPage::kOnGetVoicePackInfo: {
      break;
    }
    case messages::UntrustedPage::kAccessibilityLocationChangesReceived: {
      break;
    }
    case messages::UntrustedPage::kOnActiveAXTreeIDChanged: {
      break;
    }
    case messages::UntrustedPage::kOnAXTreeDestroyed: {
      break;
    }
    case messages::UntrustedPage::kSetLanguageCode: {
      break;
    }
    case messages::UntrustedPage::kOnTtsEngineInstalled: {
      break;
    }
    case messages::UntrustedPage::kSetDefaultLanguageCode: {
      break;
    }
    case messages::UntrustedPage::kOnSettingsRestoredFromPrefs: {
      break;
    }
    case messages::UntrustedPage::kScreenAIServiceReady: {
      break;
    }
    case messages::UntrustedPage::kOnReadingModeHidden: {
      break;
    }
    case messages::UntrustedPage::kOnTabWillDetach: {
      break;
    }
    case messages::UntrustedPage::kOnTabMuteStateChange: {
      break;
    }
    case messages::UntrustedPage::kOnImageDataDownloaded: {
      break;
    }
  }
  return false;
}
namespace {

bool ValidateWithRuntimeFeature_UntrustedPage_AccessibilityLocationChangesReceived(
  const void* data, mojo::internal::ValidationContext* validation_context) {
  if (!base::FeatureList::IsEnabled(::ax::mojom::features::kReadAnythingDocsIntegration)) {
    return false;
  }
  return internal::UntrustedPage_AccessibilityLocationChangesReceived_Params_Data::Validate(
    data, validation_context);
}
}  // namespace
static const mojo::internal::GenericValidationInfo kUntrustedPageValidationInfo[] = {
    { &internal::UntrustedPage_AccessibilityEventReceived_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::UntrustedPage_OnGetVoicePackInfo_Params_Data::Validate,
     nullptr /* no response */},
    { &ValidateWithRuntimeFeature_UntrustedPage_AccessibilityLocationChangesReceived,
     nullptr /* no response */},
    { &internal::UntrustedPage_OnActiveAXTreeIDChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::UntrustedPage_OnAXTreeDestroyed_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::UntrustedPage_SetLanguageCode_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::UntrustedPage_OnTtsEngineInstalled_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::UntrustedPage_SetDefaultLanguageCode_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::UntrustedPage_OnSettingsRestoredFromPrefs_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::UntrustedPage_ScreenAIServiceReady_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::UntrustedPage_OnReadingModeHidden_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::UntrustedPage_OnTabWillDetach_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::UntrustedPage_OnTabMuteStateChange_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::UntrustedPage_OnImageDataDownloaded_Params_Data::Validate,
     nullptr /* no response */},
};

bool UntrustedPageRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::read_anything::mojom::UntrustedPage::Name_,
    kUntrustedPageValidationInfo);
}



}  // read_anything::mojom


namespace mojo {


// static
bool StructTraits<::read_anything::mojom::VoicePackInfo::DataView, ::read_anything::mojom::VoicePackInfoPtr>::Read(
    ::read_anything::mojom::VoicePackInfo::DataView input,
    ::read_anything::mojom::VoicePackInfoPtr* output) {
  bool success = true;
  ::read_anything::mojom::VoicePackInfoPtr result(::read_anything::mojom::VoicePackInfo::New());
  
      if (success && !input.ReadPackState(&result->pack_state))
        success = false;
      if (success && !input.ReadLanguage(&result->language))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::read_anything::mojom::VoicePackInstallationState::DataView, ::read_anything::mojom::VoicePackInstallationStatePtr>::Read(
    ::read_anything::mojom::VoicePackInstallationState::DataView input,
    ::read_anything::mojom::VoicePackInstallationStatePtr* output) {
  using UnionType = ::read_anything::mojom::VoicePackInstallationState;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kInstallationState: {
      ::read_anything::mojom::InstallationState result_installation_state;
      if (!input.ReadInstallationState(&result_installation_state))
        return false;

      *output = UnionType::NewInstallationState(result_installation_state);
      break;
    }
    case Tag::kErrorCode: {
      ::read_anything::mojom::ErrorCode result_error_code;
      if (!input.ReadErrorCode(&result_error_code))
        return false;

      *output = UnionType::NewErrorCode(result_error_code);
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace read_anything::mojom {


void UntrustedPageHandlerFactoryInterceptorForTesting::CreateUntrustedPageHandler(::mojo::PendingRemote<UntrustedPage> page, ::mojo::PendingReceiver<UntrustedPageHandler> handler) {
  GetForwardingInterface()->CreateUntrustedPageHandler(
    std::move(page)
    , 
    std::move(handler)
    );
}
void UntrustedPageHandlerFactoryInterceptorForTesting::ShouldShowUI() {
  GetForwardingInterface()->ShouldShowUI();
}
UntrustedPageHandlerFactoryAsyncWaiter::UntrustedPageHandlerFactoryAsyncWaiter(
    UntrustedPageHandlerFactory* proxy) : proxy_(proxy) {}

UntrustedPageHandlerFactoryAsyncWaiter::~UntrustedPageHandlerFactoryAsyncWaiter() = default;





void UntrustedPageHandlerInterceptorForTesting::GetDependencyParserModel(GetDependencyParserModelCallback callback) {
  GetForwardingInterface()->GetDependencyParserModel(std::move(callback));
}
void UntrustedPageHandlerInterceptorForTesting::GetVoicePackInfo(const std::string& language) {
  GetForwardingInterface()->GetVoicePackInfo(
    std::move(language)
    );
}
void UntrustedPageHandlerInterceptorForTesting::InstallVoicePack(const std::string& language) {
  GetForwardingInterface()->InstallVoicePack(
    std::move(language)
    );
}
void UntrustedPageHandlerInterceptorForTesting::UninstallVoice(const std::string& language) {
  GetForwardingInterface()->UninstallVoice(
    std::move(language)
    );
}
void UntrustedPageHandlerInterceptorForTesting::OnCopy() {
  GetForwardingInterface()->OnCopy();
}
void UntrustedPageHandlerInterceptorForTesting::OnLineSpaceChange(LineSpacing line_spacing) {
  GetForwardingInterface()->OnLineSpaceChange(
    std::move(line_spacing)
    );
}
void UntrustedPageHandlerInterceptorForTesting::OnLetterSpaceChange(LetterSpacing letter_spacing) {
  GetForwardingInterface()->OnLetterSpaceChange(
    std::move(letter_spacing)
    );
}
void UntrustedPageHandlerInterceptorForTesting::OnFontChange(const std::string& font) {
  GetForwardingInterface()->OnFontChange(
    std::move(font)
    );
}
void UntrustedPageHandlerInterceptorForTesting::OnFontSizeChange(double font_size) {
  GetForwardingInterface()->OnFontSizeChange(
    std::move(font_size)
    );
}
void UntrustedPageHandlerInterceptorForTesting::OnLinksEnabledChanged(bool enabled) {
  GetForwardingInterface()->OnLinksEnabledChanged(
    std::move(enabled)
    );
}
void UntrustedPageHandlerInterceptorForTesting::OnImagesEnabledChanged(bool enabled) {
  GetForwardingInterface()->OnImagesEnabledChanged(
    std::move(enabled)
    );
}
void UntrustedPageHandlerInterceptorForTesting::OnColorChange(Colors color) {
  GetForwardingInterface()->OnColorChange(
    std::move(color)
    );
}
void UntrustedPageHandlerInterceptorForTesting::OnSpeechRateChange(double rate) {
  GetForwardingInterface()->OnSpeechRateChange(
    std::move(rate)
    );
}
void UntrustedPageHandlerInterceptorForTesting::OnVoiceChange(const std::string& voice, const std::string& lang) {
  GetForwardingInterface()->OnVoiceChange(
    std::move(voice)
    , 
    std::move(lang)
    );
}
void UntrustedPageHandlerInterceptorForTesting::OnLanguagePrefChange(const std::string& lang, bool enabled) {
  GetForwardingInterface()->OnLanguagePrefChange(
    std::move(lang)
    , 
    std::move(enabled)
    );
}
void UntrustedPageHandlerInterceptorForTesting::LogExtensionState() {
  GetForwardingInterface()->LogExtensionState();
}
void UntrustedPageHandlerInterceptorForTesting::OnHighlightGranularityChanged(HighlightGranularity granularity) {
  GetForwardingInterface()->OnHighlightGranularityChanged(
    std::move(granularity)
    );
}
void UntrustedPageHandlerInterceptorForTesting::OnReadAloudAudioStateChange(bool playing) {
  GetForwardingInterface()->OnReadAloudAudioStateChange(
    std::move(playing)
    );
}
void UntrustedPageHandlerInterceptorForTesting::OnLinkClicked(const ::ui::AXTreeID& target_tree_id, int32_t target_node_id) {
  GetForwardingInterface()->OnLinkClicked(
    std::move(target_tree_id)
    , 
    std::move(target_node_id)
    );
}
void UntrustedPageHandlerInterceptorForTesting::OnImageDataRequested(const ::ui::AXTreeID& target_tree_id, int32_t target_node_id) {
  GetForwardingInterface()->OnImageDataRequested(
    std::move(target_tree_id)
    , 
    std::move(target_node_id)
    );
}
void UntrustedPageHandlerInterceptorForTesting::OnSelectionChange(const ::ui::AXTreeID& target_tree_id, int32_t anchor_node_id, int32_t anchor_offset, int32_t focus_node_id, int32_t focus_offset) {
  GetForwardingInterface()->OnSelectionChange(
    std::move(target_tree_id)
    , 
    std::move(anchor_node_id)
    , 
    std::move(anchor_offset)
    , 
    std::move(focus_node_id)
    , 
    std::move(focus_offset)
    );
}
void UntrustedPageHandlerInterceptorForTesting::OnCollapseSelection() {
  GetForwardingInterface()->OnCollapseSelection();
}
void UntrustedPageHandlerInterceptorForTesting::OnScreenshotRequested() {
  GetForwardingInterface()->OnScreenshotRequested();
}
void UntrustedPageHandlerInterceptorForTesting::ScrollToTargetNode(const ::ui::AXTreeID& target_tree_id, int32_t target_node_id) {
  GetForwardingInterface()->ScrollToTargetNode(
    std::move(target_tree_id)
    , 
    std::move(target_node_id)
    );
}
UntrustedPageHandlerAsyncWaiter::UntrustedPageHandlerAsyncWaiter(
    UntrustedPageHandler* proxy) : proxy_(proxy) {}

UntrustedPageHandlerAsyncWaiter::~UntrustedPageHandlerAsyncWaiter() = default;


void UntrustedPageHandlerAsyncWaiter::GetDependencyParserModel(
    ::base::File* out_model_file) {
  base::RunLoop loop;
  proxy_->GetDependencyParserModel(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::File* out_model_file
,
             ::base::File model_file) {*out_model_file = std::move(model_file);
            loop->Quit();
          },
          &loop,
          out_model_file));
  loop.Run();
}

::base::File UntrustedPageHandlerAsyncWaiter::GetDependencyParserModel(
    ) {
  ::base::File async_wait_result;
  GetDependencyParserModel(&async_wait_result);
  return async_wait_result;
}




void UntrustedPageInterceptorForTesting::AccessibilityEventReceived(const ::ui::AXTreeID& tree_id, const std::vector<::ui::AXTreeUpdate>& updates, const std::vector<::ui::AXEvent>& events) {
  GetForwardingInterface()->AccessibilityEventReceived(
    std::move(tree_id)
    , 
    std::move(updates)
    , 
    std::move(events)
    );
}
void UntrustedPageInterceptorForTesting::OnGetVoicePackInfo(VoicePackInfoPtr voice_pack_info) {
  GetForwardingInterface()->OnGetVoicePackInfo(
    std::move(voice_pack_info)
    );
}
void UntrustedPageInterceptorForTesting::AccessibilityLocationChangesReceived(const ::ui::AXTreeID& tree_id, const ::ui::AXLocationAndScrollUpdates& details) {
  GetForwardingInterface()->AccessibilityLocationChangesReceived(
    std::move(tree_id)
    , 
    details);
}
void UntrustedPageInterceptorForTesting::OnActiveAXTreeIDChanged(const ::ui::AXTreeID& tree_id, int64_t ukm_source_id, bool is_pdf) {
  GetForwardingInterface()->OnActiveAXTreeIDChanged(
    std::move(tree_id)
    , 
    std::move(ukm_source_id)
    , 
    std::move(is_pdf)
    );
}
void UntrustedPageInterceptorForTesting::OnAXTreeDestroyed(const ::ui::AXTreeID& tree_id) {
  GetForwardingInterface()->OnAXTreeDestroyed(
    std::move(tree_id)
    );
}
void UntrustedPageInterceptorForTesting::SetLanguageCode(const std::string& code) {
  GetForwardingInterface()->SetLanguageCode(
    std::move(code)
    );
}
void UntrustedPageInterceptorForTesting::OnTtsEngineInstalled() {
  GetForwardingInterface()->OnTtsEngineInstalled();
}
void UntrustedPageInterceptorForTesting::SetDefaultLanguageCode(const std::string& code) {
  GetForwardingInterface()->SetDefaultLanguageCode(
    std::move(code)
    );
}
void UntrustedPageInterceptorForTesting::OnSettingsRestoredFromPrefs(LineSpacing line_spacing, LetterSpacing letter_spacing, const std::string& font, double font_size, bool links_enabled, bool images_enabled, Colors color, double speech_rate, ::base::Value::Dict voices, ::base::Value::List languages_enabled_in_pref, HighlightGranularity granularity) {
  GetForwardingInterface()->OnSettingsRestoredFromPrefs(
    std::move(line_spacing)
    , 
    std::move(letter_spacing)
    , 
    std::move(font)
    , 
    std::move(font_size)
    , 
    std::move(links_enabled)
    , 
    std::move(images_enabled)
    , 
    std::move(color)
    , 
    std::move(speech_rate)
    , 
    std::move(voices)
    , 
    std::move(languages_enabled_in_pref)
    , 
    std::move(granularity)
    );
}
void UntrustedPageInterceptorForTesting::ScreenAIServiceReady() {
  GetForwardingInterface()->ScreenAIServiceReady();
}
void UntrustedPageInterceptorForTesting::OnReadingModeHidden() {
  GetForwardingInterface()->OnReadingModeHidden();
}
void UntrustedPageInterceptorForTesting::OnTabWillDetach() {
  GetForwardingInterface()->OnTabWillDetach();
}
void UntrustedPageInterceptorForTesting::OnTabMuteStateChange(bool muted) {
  GetForwardingInterface()->OnTabMuteStateChange(
    std::move(muted)
    );
}
void UntrustedPageInterceptorForTesting::OnImageDataDownloaded(const ::ui::AXTreeID& tree_id, int32_t node_id, const ::SkBitmap& image) {
  GetForwardingInterface()->OnImageDataDownloaded(
    std::move(tree_id)
    , 
    std::move(node_id)
    , 
    std::move(image)
    );
}
UntrustedPageAsyncWaiter::UntrustedPageAsyncWaiter(
    UntrustedPage* proxy) : proxy_(proxy) {}

UntrustedPageAsyncWaiter::~UntrustedPageAsyncWaiter() = default;







}  // read_anything::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif