// chrome/common/network_easter_egg.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/common/network_easter_egg.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/common/network_easter_egg.mojom-params-data.h"
#include "chrome/common/network_easter_egg.mojom-shared-message-ids.h"

#include "chrome/common/network_easter_egg.mojom-import-headers.h"
#include "chrome/common/network_easter_egg.mojom-test-utils.h"


namespace chrome::mojom {
// The declaration includes the definition on other builds.

NetworkEasterEgg::IPCStableHashFunction NetworkEasterEgg::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::NetworkEasterEgg>(message.name())) {
    case messages::NetworkEasterEgg::kGetHighScore: {
      return &NetworkEasterEgg::GetHighScore_Sym::IPCStableHash;
    }
    case messages::NetworkEasterEgg::kUpdateHighScore: {
      return &NetworkEasterEgg::UpdateHighScore_Sym::IPCStableHash;
    }
    case messages::NetworkEasterEgg::kResetHighScore: {
      return &NetworkEasterEgg::ResetHighScore_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* NetworkEasterEgg::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::NetworkEasterEgg>(message.name())) {
      case messages::NetworkEasterEgg::kGetHighScore:
            return "Receive chrome::mojom::NetworkEasterEgg::GetHighScore";
      case messages::NetworkEasterEgg::kUpdateHighScore:
            return "Receive chrome::mojom::NetworkEasterEgg::UpdateHighScore";
      case messages::NetworkEasterEgg::kResetHighScore:
            return "Receive chrome::mojom::NetworkEasterEgg::ResetHighScore";
    }
  } else {
    switch (static_cast<messages::NetworkEasterEgg>(message.name())) {
      case messages::NetworkEasterEgg::kGetHighScore:
            return "Receive reply chrome::mojom::NetworkEasterEgg::GetHighScore";
      case messages::NetworkEasterEgg::kUpdateHighScore:
            return "Receive reply chrome::mojom::NetworkEasterEgg::UpdateHighScore";
      case messages::NetworkEasterEgg::kResetHighScore:
            return "Receive reply chrome::mojom::NetworkEasterEgg::ResetHighScore";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t NetworkEasterEgg::GetHighScore_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe6825bb5;  // IPCStableHash for chrome::mojom::NetworkEasterEgg::GetHighScore
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkEasterEgg::UpdateHighScore_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbf680631;  // IPCStableHash for chrome::mojom::NetworkEasterEgg::UpdateHighScore
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkEasterEgg::ResetHighScore_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9b13bf18;  // IPCStableHash for chrome::mojom::NetworkEasterEgg::ResetHighScore
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class NetworkEasterEgg_GetHighScore_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkEasterEgg_GetHighScore_ForwardToCallback(
      NetworkEasterEgg::GetHighScoreCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkEasterEgg_GetHighScore_ForwardToCallback(const NetworkEasterEgg_GetHighScore_ForwardToCallback&) = delete;
  NetworkEasterEgg_GetHighScore_ForwardToCallback& operator=(const NetworkEasterEgg_GetHighScore_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkEasterEgg::GetHighScoreCallback callback_;
};

NetworkEasterEggProxy::NetworkEasterEggProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void NetworkEasterEggProxy::GetHighScore(
    GetHighScoreCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send chrome::mojom::NetworkEasterEgg::GetHighScore");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkEasterEgg::kGetHighScore), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::NetworkEasterEgg_GetHighScore_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkEasterEgg::Name_);
  message.set_method_name("GetHighScore");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkEasterEgg_GetHighScore_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkEasterEggProxy::UpdateHighScore(
    uint32_t in_high_score) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::NetworkEasterEgg::UpdateHighScore", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("high_score"), in_high_score,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkEasterEgg::kUpdateHighScore), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::NetworkEasterEgg_UpdateHighScore_Params_Data> params(
          message);
  params.Allocate();

  params->high_score = in_high_score;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkEasterEgg::Name_);
  message.set_method_name("UpdateHighScore");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkEasterEggProxy::ResetHighScore(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send chrome::mojom::NetworkEasterEgg::ResetHighScore");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkEasterEgg::kResetHighScore), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::NetworkEasterEgg_ResetHighScore_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkEasterEgg::Name_);
  message.set_method_name("ResetHighScore");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class NetworkEasterEgg_GetHighScore_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkEasterEgg::GetHighScoreCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkEasterEgg_GetHighScore_ProxyToResponder> proxy(
        new NetworkEasterEgg_GetHighScore_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkEasterEgg_GetHighScore_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkEasterEgg_GetHighScore_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkEasterEgg_GetHighScore_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "NetworkEasterEgg::GetHighScoreCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      uint32_t in_high_score);
};

bool NetworkEasterEgg_GetHighScore_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkEasterEgg_GetHighScore_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkEasterEgg_GetHighScore_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkEasterEgg.0
  bool success = true;
  uint32_t p_high_score{};
  NetworkEasterEgg_GetHighScore_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_high_score = input_data_view.high_score();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkEasterEgg::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_high_score));
  }
  return true;
}

void NetworkEasterEgg_GetHighScore_ProxyToResponder::Run(
    uint32_t in_high_score) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply chrome::mojom::NetworkEasterEgg::GetHighScore", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("high_score"), in_high_score,
                        "<value of type uint32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkEasterEgg::kGetHighScore), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::NetworkEasterEgg_GetHighScore_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->high_score = in_high_score;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkEasterEgg::Name_);
  message.set_method_name("GetHighScore");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool NetworkEasterEggStubDispatch::Accept(
    NetworkEasterEgg* impl,
    mojo::Message* message) {
  switch (static_cast<messages::NetworkEasterEgg>(message->header()->name)) {
    case messages::NetworkEasterEgg::kGetHighScore: {
      break;
    }
    case messages::NetworkEasterEgg::kUpdateHighScore: {
      DCHECK(message->is_serialized());
      internal::NetworkEasterEgg_UpdateHighScore_Params_Data* params =
          reinterpret_cast<internal::NetworkEasterEgg_UpdateHighScore_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NetworkEasterEgg.1
      bool success = true;
      uint32_t p_high_score{};
      NetworkEasterEgg_UpdateHighScore_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_high_score = input_data_view.high_score();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkEasterEgg::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateHighScore(        
        std::move(p_high_score));
      return true;
    }
    case messages::NetworkEasterEgg::kResetHighScore: {
      DCHECK(message->is_serialized());
      internal::NetworkEasterEgg_ResetHighScore_Params_Data* params =
          reinterpret_cast<internal::NetworkEasterEgg_ResetHighScore_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NetworkEasterEgg.2
      bool success = true;
      NetworkEasterEgg_ResetHighScore_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkEasterEgg::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResetHighScore(        );
      return true;
    }
  }
  return false;
}

// static
bool NetworkEasterEggStubDispatch::AcceptWithResponder(
    NetworkEasterEgg* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::NetworkEasterEgg>(message->header()->name)) {
    case messages::NetworkEasterEgg::kGetHighScore: {
      internal::NetworkEasterEgg_GetHighScore_Params_Data* params =
          reinterpret_cast<
              internal::NetworkEasterEgg_GetHighScore_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkEasterEgg.0
      bool success = true;
      NetworkEasterEgg_GetHighScore_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkEasterEgg::Name_, 0, false);
        return false;
      }
      auto callback =
          NetworkEasterEgg_GetHighScore_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetHighScore(std::move(callback));
      return true;
    }
    case messages::NetworkEasterEgg::kUpdateHighScore: {
      break;
    }
    case messages::NetworkEasterEgg::kResetHighScore: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kNetworkEasterEggValidationInfo[] = {
    { &internal::NetworkEasterEgg_GetHighScore_Params_Data::Validate,
     &internal::NetworkEasterEgg_GetHighScore_ResponseParams_Data::Validate},
    { &internal::NetworkEasterEgg_UpdateHighScore_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NetworkEasterEgg_ResetHighScore_Params_Data::Validate,
     nullptr /* no response */},
};

bool NetworkEasterEggRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::chrome::mojom::NetworkEasterEgg::Name_,
    kNetworkEasterEggValidationInfo);
}

bool NetworkEasterEggResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::chrome::mojom::NetworkEasterEgg::Name_,
    kNetworkEasterEggValidationInfo);
}


}  // chrome::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace chrome::mojom {


void NetworkEasterEggInterceptorForTesting::GetHighScore(GetHighScoreCallback callback) {
  GetForwardingInterface()->GetHighScore(std::move(callback));
}
void NetworkEasterEggInterceptorForTesting::UpdateHighScore(uint32_t high_score) {
  GetForwardingInterface()->UpdateHighScore(
    std::move(high_score)
    );
}
void NetworkEasterEggInterceptorForTesting::ResetHighScore() {
  GetForwardingInterface()->ResetHighScore();
}
NetworkEasterEggAsyncWaiter::NetworkEasterEggAsyncWaiter(
    NetworkEasterEgg* proxy) : proxy_(proxy) {}

NetworkEasterEggAsyncWaiter::~NetworkEasterEggAsyncWaiter() = default;


void NetworkEasterEggAsyncWaiter::GetHighScore(
    uint32_t* out_high_score) {
  base::RunLoop loop;
  proxy_->GetHighScore(
      base::BindOnce(
          [](base::RunLoop* loop,
             uint32_t* out_high_score
,
             uint32_t high_score) {*out_high_score = std::move(high_score);
            loop->Quit();
          },
          &loop,
          out_high_score));
  loop.Run();
}

uint32_t NetworkEasterEggAsyncWaiter::GetHighScore(
    ) {
  uint32_t async_wait_result;
  GetHighScore(&async_wait_result);
  return async_wait_result;
}






}  // chrome::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif