// chrome/common/mac/app_shim.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/common/mac/app_shim.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/common/mac/app_shim.mojom-params-data.h"
namespace chrome {
namespace mojom {

NOINLINE static const char* AppShimLaunchTypeToStringHelper(AppShimLaunchType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AppShimLaunchType::kRegisterOnly:
      return "kRegisterOnly";
    case AppShimLaunchType::kNormal:
      return "kNormal";
    case AppShimLaunchType::kNotificationAction:
      return "kNotificationAction";
    default:
      return nullptr;
  }
}

std::string AppShimLaunchTypeToString(AppShimLaunchType value) {
  const char *str = AppShimLaunchTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AppShimLaunchType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AppShimLaunchType value) {
  return os << AppShimLaunchTypeToString(value);
}

NOINLINE static const char* AppShimLaunchResultToStringHelper(AppShimLaunchResult value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AppShimLaunchResult::kSuccess:
      return "kSuccess";
    case AppShimLaunchResult::kSuccessAndDisconnect:
      return "kSuccessAndDisconnect";
    case AppShimLaunchResult::kDuplicateHost:
      return "kDuplicateHost";
    case AppShimLaunchResult::kProfileNotFound:
      return "kProfileNotFound";
    case AppShimLaunchResult::kAppNotFound:
      return "kAppNotFound";
    case AppShimLaunchResult::kProfileLocked:
      return "kProfileLocked";
    case AppShimLaunchResult::kFailedValidation:
      return "kFailedValidation";
    default:
      return nullptr;
  }
}

std::string AppShimLaunchResultToString(AppShimLaunchResult value) {
  const char *str = AppShimLaunchResultToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AppShimLaunchResult value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AppShimLaunchResult value) {
  return os << AppShimLaunchResultToString(value);
}

NOINLINE static const char* AppShimAttentionTypeToStringHelper(AppShimAttentionType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AppShimAttentionType::kCancel:
      return "kCancel";
    case AppShimAttentionType::kCritical:
      return "kCritical";
    default:
      return nullptr;
  }
}

std::string AppShimAttentionTypeToString(AppShimAttentionType value) {
  const char *str = AppShimAttentionTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AppShimAttentionType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AppShimAttentionType value) {
  return os << AppShimAttentionTypeToString(value);
}

NOINLINE static const char* AppShimLoginItemRestoreStateToStringHelper(AppShimLoginItemRestoreState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AppShimLoginItemRestoreState::kNone:
      return "kNone";
    case AppShimLoginItemRestoreState::kWindowed:
      return "kWindowed";
    case AppShimLoginItemRestoreState::kHidden:
      return "kHidden";
    default:
      return nullptr;
  }
}

std::string AppShimLoginItemRestoreStateToString(AppShimLoginItemRestoreState value) {
  const char *str = AppShimLoginItemRestoreStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AppShimLoginItemRestoreState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AppShimLoginItemRestoreState value) {
  return os << AppShimLoginItemRestoreStateToString(value);
}

NOINLINE static const char* AppShimScreenReaderSupportModeToStringHelper(AppShimScreenReaderSupportMode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AppShimScreenReaderSupportMode::kPartial:
      return "kPartial";
    case AppShimScreenReaderSupportMode::kComplete:
      return "kComplete";
    default:
      return nullptr;
  }
}

std::string AppShimScreenReaderSupportModeToString(AppShimScreenReaderSupportMode value) {
  const char *str = AppShimScreenReaderSupportModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AppShimScreenReaderSupportMode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AppShimScreenReaderSupportMode value) {
  return os << AppShimScreenReaderSupportModeToString(value);
}

namespace internal {


// static
bool ProfileMenuItem_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProfileMenuItem_Data* object =
      static_cast<const ProfileMenuItem_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->name, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->icon, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->profile_path, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->profile_path, validation_context))
    return false;

  return true;
}

ProfileMenuItem_Data::ProfileMenuItem_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ApplicationDockMenuItem_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ApplicationDockMenuItem_Data* object =
      static_cast<const ApplicationDockMenuItem_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->name, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

ApplicationDockMenuItem_Data::ApplicationDockMenuItem_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AppShimInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AppShimInfo_Data* object =
      static_cast<const AppShimInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->profile_path, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->profile_path, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& app_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_url, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->app_url, validation_context))
    return false;


  if (!::chrome::mojom::internal::AppShimLaunchType_Data
        ::Validate(object->launch_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->files, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& files_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->files, validation_context,
                                         &files_validate_params)) {
    return false;
  }


  if (!::chrome::mojom::internal::AppShimLoginItemRestoreState_Data
        ::Validate(object->login_item_restore_state, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->urls, 7, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& urls_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->urls, validation_context,
                                         &urls_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->notification_action_handler, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->notification_action_handler,
                                                 validation_context)) {
    return false;
  }

  return true;
}

AppShimInfo_Data::AppShimInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FeatureState_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FeatureState_Data* object =
      static_cast<const FeatureState_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->field_trial_states, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& field_trial_states_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->field_trial_states, validation_context,
                                         &field_trial_states_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->field_trial_params, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& field_trial_params_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->field_trial_params, validation_context,
                                         &field_trial_params_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->enable_features, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& enable_features_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->enable_features, validation_context,
                                         &enable_features_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->disable_features, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& disable_features_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->disable_features, validation_context,
                                         &disable_features_validate_params)) {
    return false;
  }

  return true;
}

FeatureState_Data::FeatureState_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AppShim_CreateRemoteCocoaApplication_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AppShim_CreateRemoteCocoaApplication_Params_Data* object =
      static_cast<const AppShim_CreateRemoteCocoaApplication_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->application, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->application,
                                                 validation_context)) {
    return false;
  }

  return true;
}

AppShim_CreateRemoteCocoaApplication_Params_Data::AppShim_CreateRemoteCocoaApplication_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AppShim_CreateCommandDispatcherForWidget_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AppShim_CreateCommandDispatcherForWidget_Params_Data* object =
      static_cast<const AppShim_CreateCommandDispatcherForWidget_Params_Data*>(data);

  return true;
}

AppShim_CreateCommandDispatcherForWidget_Params_Data::AppShim_CreateCommandDispatcherForWidget_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AppShim_SetUserAttention_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AppShim_SetUserAttention_Params_Data* object =
      static_cast<const AppShim_SetUserAttention_Params_Data*>(data);


  if (!::chrome::mojom::internal::AppShimAttentionType_Data
        ::Validate(object->attention_type, validation_context))
    return false;

  return true;
}

AppShim_SetUserAttention_Params_Data::AppShim_SetUserAttention_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AppShim_SetBadgeLabel_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AppShim_SetBadgeLabel_Params_Data* object =
      static_cast<const AppShim_SetBadgeLabel_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->badge_label, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& badge_label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->badge_label, validation_context,
                                         &badge_label_validate_params)) {
    return false;
  }

  return true;
}

AppShim_SetBadgeLabel_Params_Data::AppShim_SetBadgeLabel_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AppShim_UpdateProfileMenu_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AppShim_UpdateProfileMenu_Params_Data* object =
      static_cast<const AppShim_UpdateProfileMenu_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->profile_menu_items, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& profile_menu_items_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->profile_menu_items, validation_context,
                                         &profile_menu_items_validate_params)) {
    return false;
  }

  return true;
}

AppShim_UpdateProfileMenu_Params_Data::AppShim_UpdateProfileMenu_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AppShim_UpdateApplicationDockMenu_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AppShim_UpdateApplicationDockMenu_Params_Data* object =
      static_cast<const AppShim_UpdateApplicationDockMenu_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->dock_menu_items, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& dock_menu_items_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->dock_menu_items, validation_context,
                                         &dock_menu_items_validate_params)) {
    return false;
  }

  return true;
}

AppShim_UpdateApplicationDockMenu_Params_Data::AppShim_UpdateApplicationDockMenu_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AppShim_BindNotificationProvider_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AppShim_BindNotificationProvider_Params_Data* object =
      static_cast<const AppShim_BindNotificationProvider_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->provider, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->provider,
                                                 validation_context)) {
    return false;
  }

  return true;
}

AppShim_BindNotificationProvider_Params_Data::AppShim_BindNotificationProvider_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AppShim_RequestNotificationPermission_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AppShim_RequestNotificationPermission_Params_Data* object =
      static_cast<const AppShim_RequestNotificationPermission_Params_Data*>(data);

  return true;
}

AppShim_RequestNotificationPermission_Params_Data::AppShim_RequestNotificationPermission_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AppShim_RequestNotificationPermission_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AppShim_RequestNotificationPermission_ResponseParams_Data* object =
      static_cast<const AppShim_RequestNotificationPermission_ResponseParams_Data*>(data);


  if (!::mac_notifications::mojom::internal::RequestPermissionResult_Data
        ::Validate(object->result, validation_context))
    return false;

  return true;
}

AppShim_RequestNotificationPermission_ResponseParams_Data::AppShim_RequestNotificationPermission_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AppShim_BindChildHistogramFetcherFactory_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AppShim_BindChildHistogramFetcherFactory_Params_Data* object =
      static_cast<const AppShim_BindChildHistogramFetcherFactory_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

AppShim_BindChildHistogramFetcherFactory_Params_Data::AppShim_BindChildHistogramFetcherFactory_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AppShimHost_FocusApp_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AppShimHost_FocusApp_Params_Data* object =
      static_cast<const AppShimHost_FocusApp_Params_Data*>(data);

  return true;
}

AppShimHost_FocusApp_Params_Data::AppShimHost_FocusApp_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AppShimHost_ReopenApp_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AppShimHost_ReopenApp_Params_Data* object =
      static_cast<const AppShimHost_ReopenApp_Params_Data*>(data);

  return true;
}

AppShimHost_ReopenApp_Params_Data::AppShimHost_ReopenApp_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AppShimHost_FilesOpened_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AppShimHost_FilesOpened_Params_Data* object =
      static_cast<const AppShimHost_FilesOpened_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->files, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& files_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->files, validation_context,
                                         &files_validate_params)) {
    return false;
  }

  return true;
}

AppShimHost_FilesOpened_Params_Data::AppShimHost_FilesOpened_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AppShimHost_ProfileSelectedFromMenu_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AppShimHost_ProfileSelectedFromMenu_Params_Data* object =
      static_cast<const AppShimHost_ProfileSelectedFromMenu_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->profile_path, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->profile_path, validation_context))
    return false;

  return true;
}

AppShimHost_ProfileSelectedFromMenu_Params_Data::AppShimHost_ProfileSelectedFromMenu_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AppShimHost_OpenAppSettings_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AppShimHost_OpenAppSettings_Params_Data* object =
      static_cast<const AppShimHost_OpenAppSettings_Params_Data*>(data);

  return true;
}

AppShimHost_OpenAppSettings_Params_Data::AppShimHost_OpenAppSettings_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AppShimHost_UrlsOpened_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AppShimHost_UrlsOpened_Params_Data* object =
      static_cast<const AppShimHost_UrlsOpened_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->urls, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& urls_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->urls, validation_context,
                                         &urls_validate_params)) {
    return false;
  }

  return true;
}

AppShimHost_UrlsOpened_Params_Data::AppShimHost_UrlsOpened_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AppShimHost_OpenAppWithOverrideUrl_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AppShimHost_OpenAppWithOverrideUrl_Params_Data* object =
      static_cast<const AppShimHost_OpenAppWithOverrideUrl_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->override_url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->override_url, validation_context))
    return false;

  return true;
}

AppShimHost_OpenAppWithOverrideUrl_Params_Data::AppShimHost_OpenAppWithOverrideUrl_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AppShimHost_EnableAccessibilitySupport_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AppShimHost_EnableAccessibilitySupport_Params_Data* object =
      static_cast<const AppShimHost_EnableAccessibilitySupport_Params_Data*>(data);


  if (!::chrome::mojom::internal::AppShimScreenReaderSupportMode_Data
        ::Validate(object->mode, validation_context))
    return false;

  return true;
}

AppShimHost_EnableAccessibilitySupport_Params_Data::AppShimHost_EnableAccessibilitySupport_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AppShimHost_ApplicationWillTerminate_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AppShimHost_ApplicationWillTerminate_Params_Data* object =
      static_cast<const AppShimHost_ApplicationWillTerminate_Params_Data*>(data);

  return true;
}

AppShimHost_ApplicationWillTerminate_Params_Data::AppShimHost_ApplicationWillTerminate_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AppShimHost_NotificationPermissionStatusChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AppShimHost_NotificationPermissionStatusChanged_Params_Data* object =
      static_cast<const AppShimHost_NotificationPermissionStatusChanged_Params_Data*>(data);


  if (!::mac_notifications::mojom::internal::PermissionStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

AppShimHost_NotificationPermissionStatusChanged_Params_Data::AppShimHost_NotificationPermissionStatusChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AppShimHostBootstrap_OnShimConnected_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AppShimHostBootstrap_OnShimConnected_Params_Data* object =
      static_cast<const AppShimHostBootstrap_OnShimConnected_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->host_receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->host_receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_shim_info, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->app_shim_info, validation_context))
    return false;

  return true;
}

AppShimHostBootstrap_OnShimConnected_Params_Data::AppShimHostBootstrap_OnShimConnected_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AppShimHostBootstrap_OnShimConnected_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AppShimHostBootstrap_OnShimConnected_ResponseParams_Data* object =
      static_cast<const AppShimHostBootstrap_OnShimConnected_ResponseParams_Data*>(data);


  if (!::chrome::mojom::internal::AppShimLaunchResult_Data
        ::Validate(object->launch_result, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->feature_state, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->feature_state, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->app_shim_receiver, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->app_shim_receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

AppShimHostBootstrap_OnShimConnected_ResponseParams_Data::AppShimHostBootstrap_OnShimConnected_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace chrome

namespace perfetto {

// static
void TraceFormatTraits<::chrome::mojom::AppShimLaunchType>::WriteIntoTrace(
   perfetto::TracedValue context, ::chrome::mojom::AppShimLaunchType value) {
  return std::move(context).WriteString(::chrome::mojom::AppShimLaunchTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::chrome::mojom::AppShimLaunchResult>::WriteIntoTrace(
   perfetto::TracedValue context, ::chrome::mojom::AppShimLaunchResult value) {
  return std::move(context).WriteString(::chrome::mojom::AppShimLaunchResultToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::chrome::mojom::AppShimAttentionType>::WriteIntoTrace(
   perfetto::TracedValue context, ::chrome::mojom::AppShimAttentionType value) {
  return std::move(context).WriteString(::chrome::mojom::AppShimAttentionTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::chrome::mojom::AppShimLoginItemRestoreState>::WriteIntoTrace(
   perfetto::TracedValue context, ::chrome::mojom::AppShimLoginItemRestoreState value) {
  return std::move(context).WriteString(::chrome::mojom::AppShimLoginItemRestoreStateToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::chrome::mojom::AppShimScreenReaderSupportMode>::WriteIntoTrace(
   perfetto::TracedValue context, ::chrome::mojom::AppShimScreenReaderSupportMode value) {
  return std::move(context).WriteString(::chrome::mojom::AppShimScreenReaderSupportModeToString(value));
}

} // namespace perfetto