// chrome/common/importer/profile_import.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_COMMON_IMPORTER_PROFILE_IMPORT_MOJOM_SHARED_H_
#define CHROME_COMMON_IMPORTER_PROFILE_IMPORT_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/common/importer/profile_import.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "sandbox/policy/mojom/sandbox.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"


#include "mojo/public/cpp/bindings/native_enum.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"

#include "chrome/common/importer/profile_import.mojom-data-view.h"




namespace std {

template <>
struct hash<::chrome::mojom::ImportedPasswordForm_Scheme>
    : public mojo::internal::EnumHashImpl<::chrome::mojom::ImportedPasswordForm_Scheme> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::chrome::mojom::ImportedPasswordForm_Scheme, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::chrome::mojom::ImportedPasswordForm_Scheme, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::chrome::mojom::ImportedPasswordForm_Scheme>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::chrome::mojom::ImportedPasswordFormDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::chrome::mojom::ImportedPasswordFormDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::chrome::mojom::internal::ImportedPasswordForm_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::chrome::mojom::ImportedPasswordForm_Scheme>(
      Traits::scheme(input),
      &fragment->scheme);

    decltype(Traits::signon_realm(input)) in_signon_realm = Traits::signon_realm(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->signon_realm)::BaseType> signon_realm_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_signon_realm,
      signon_realm_fragment);

    fragment->signon_realm.Set(
        signon_realm_fragment.is_null() ? nullptr : signon_realm_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->signon_realm.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null signon_realm in ImportedPasswordForm struct");

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in ImportedPasswordForm struct");

    decltype(Traits::action(input)) in_action = Traits::action(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->action)::BaseType> action_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_action,
      action_fragment);

    fragment->action.Set(
        action_fragment.is_null() ? nullptr : action_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->action.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null action in ImportedPasswordForm struct");

    decltype(Traits::username_element(input)) in_username_element = Traits::username_element(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->username_element)::BaseType> username_element_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_username_element,
      username_element_fragment);

    fragment->username_element.Set(
        username_element_fragment.is_null() ? nullptr : username_element_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->username_element.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null username_element in ImportedPasswordForm struct");

    decltype(Traits::username_value(input)) in_username_value = Traits::username_value(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->username_value)::BaseType> username_value_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_username_value,
      username_value_fragment);

    fragment->username_value.Set(
        username_value_fragment.is_null() ? nullptr : username_value_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->username_value.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null username_value in ImportedPasswordForm struct");

    decltype(Traits::password_element(input)) in_password_element = Traits::password_element(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->password_element)::BaseType> password_element_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_password_element,
      password_element_fragment);

    fragment->password_element.Set(
        password_element_fragment.is_null() ? nullptr : password_element_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->password_element.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null password_element in ImportedPasswordForm struct");

    decltype(Traits::password_value(input)) in_password_value = Traits::password_value(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->password_value)::BaseType> password_value_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_password_value,
      password_value_fragment);

    fragment->password_value.Set(
        password_value_fragment.is_null() ? nullptr : password_value_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->password_value.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null password_value in ImportedPasswordForm struct");

    fragment->blocked_by_user = Traits::blocked_by_user(input);
  }

  static bool Deserialize(::chrome::mojom::internal::ImportedPasswordForm_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::chrome::mojom::ImportedPasswordFormDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace chrome::mojom {

inline void ImportedPasswordFormDataView::GetSignonRealmDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->signon_realm.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ImportedPasswordFormDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void ImportedPasswordFormDataView::GetActionDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->action.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void ImportedPasswordFormDataView::GetUsernameElementDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->username_element.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void ImportedPasswordFormDataView::GetUsernameValueDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->username_value.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void ImportedPasswordFormDataView::GetPasswordElementDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->password_element.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void ImportedPasswordFormDataView::GetPasswordValueDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->password_value.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}



}  // chrome::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::chrome::mojom::ImportedPasswordForm_Scheme> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::chrome::mojom::ImportedPasswordForm_Scheme value);
};

} // namespace perfetto

#endif  // CHROME_COMMON_IMPORTER_PROFILE_IMPORT_MOJOM_SHARED_H_