// chrome/common/importer/profile_import.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/common/importer/profile_import.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/common/importer/profile_import.mojom-params-data.h"
namespace chrome {
namespace mojom {

NOINLINE static const char* ImportedPasswordForm_SchemeToStringHelper(ImportedPasswordForm_Scheme value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ImportedPasswordForm_Scheme::kHtml:
      return "kHtml";
    case ImportedPasswordForm_Scheme::kBasic:
      return "kBasic";
    default:
      return nullptr;
  }
}

std::string ImportedPasswordForm_SchemeToString(ImportedPasswordForm_Scheme value) {
  const char *str = ImportedPasswordForm_SchemeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ImportedPasswordForm_Scheme value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ImportedPasswordForm_Scheme value) {
  return os << ImportedPasswordForm_SchemeToString(value);
}

namespace internal {


// static
bool ImportedPasswordForm_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 72, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ImportedPasswordForm_Data* object =
      static_cast<const ImportedPasswordForm_Data*>(data);


  if (!::chrome::mojom::internal::ImportedPasswordForm_Scheme_Data
        ::Validate(object->scheme, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->signon_realm, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& signon_realm_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->signon_realm, validation_context,
                                         &signon_realm_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->action, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->action, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->username_element, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->username_element, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->username_value, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->username_value, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->password_element, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->password_element, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->password_value, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->password_value, validation_context))
    return false;

  return true;
}

ImportedPasswordForm_Data::ImportedPasswordForm_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProfileImportObserver_OnImportStart_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProfileImportObserver_OnImportStart_Params_Data* object =
      static_cast<const ProfileImportObserver_OnImportStart_Params_Data*>(data);

  return true;
}

ProfileImportObserver_OnImportStart_Params_Data::ProfileImportObserver_OnImportStart_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProfileImportObserver_OnImportFinished_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProfileImportObserver_OnImportFinished_Params_Data* object =
      static_cast<const ProfileImportObserver_OnImportFinished_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->error_msg, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& error_msg_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->error_msg, validation_context,
                                         &error_msg_validate_params)) {
    return false;
  }

  return true;
}

ProfileImportObserver_OnImportFinished_Params_Data::ProfileImportObserver_OnImportFinished_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProfileImportObserver_OnImportItemStart_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProfileImportObserver_OnImportItemStart_Params_Data* object =
      static_cast<const ProfileImportObserver_OnImportItemStart_Params_Data*>(data);


  if (!::chrome::mojom::internal::ImportItem_Data
        ::Validate(object->item, validation_context))
    return false;

  return true;
}

ProfileImportObserver_OnImportItemStart_Params_Data::ProfileImportObserver_OnImportItemStart_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProfileImportObserver_OnImportItemFinished_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProfileImportObserver_OnImportItemFinished_Params_Data* object =
      static_cast<const ProfileImportObserver_OnImportItemFinished_Params_Data*>(data);


  if (!::chrome::mojom::internal::ImportItem_Data
        ::Validate(object->item, validation_context))
    return false;

  return true;
}

ProfileImportObserver_OnImportItemFinished_Params_Data::ProfileImportObserver_OnImportItemFinished_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProfileImportObserver_OnHistoryImportStart_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProfileImportObserver_OnHistoryImportStart_Params_Data* object =
      static_cast<const ProfileImportObserver_OnHistoryImportStart_Params_Data*>(data);

  return true;
}

ProfileImportObserver_OnHistoryImportStart_Params_Data::ProfileImportObserver_OnHistoryImportStart_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProfileImportObserver_OnHistoryImportGroup_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProfileImportObserver_OnHistoryImportGroup_Params_Data* object =
      static_cast<const ProfileImportObserver_OnHistoryImportGroup_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->history_rows_group, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& history_rows_group_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->history_rows_group, validation_context,
                                         &history_rows_group_validate_params)) {
    return false;
  }

  return true;
}

ProfileImportObserver_OnHistoryImportGroup_Params_Data::ProfileImportObserver_OnHistoryImportGroup_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProfileImportObserver_OnHomePageImportReady_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProfileImportObserver_OnHomePageImportReady_Params_Data* object =
      static_cast<const ProfileImportObserver_OnHomePageImportReady_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->home_page, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->home_page, validation_context))
    return false;

  return true;
}

ProfileImportObserver_OnHomePageImportReady_Params_Data::ProfileImportObserver_OnHomePageImportReady_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProfileImportObserver_OnBookmarksImportStart_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProfileImportObserver_OnBookmarksImportStart_Params_Data* object =
      static_cast<const ProfileImportObserver_OnBookmarksImportStart_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->first_folder_name, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->first_folder_name, validation_context))
    return false;

  return true;
}

ProfileImportObserver_OnBookmarksImportStart_Params_Data::ProfileImportObserver_OnBookmarksImportStart_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProfileImportObserver_OnBookmarksImportGroup_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProfileImportObserver_OnBookmarksImportGroup_Params_Data* object =
      static_cast<const ProfileImportObserver_OnBookmarksImportGroup_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bookmarks_group, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& bookmarks_group_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->bookmarks_group, validation_context,
                                         &bookmarks_group_validate_params)) {
    return false;
  }

  return true;
}

ProfileImportObserver_OnBookmarksImportGroup_Params_Data::ProfileImportObserver_OnBookmarksImportGroup_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProfileImportObserver_OnFaviconsImportStart_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProfileImportObserver_OnFaviconsImportStart_Params_Data* object =
      static_cast<const ProfileImportObserver_OnFaviconsImportStart_Params_Data*>(data);

  return true;
}

ProfileImportObserver_OnFaviconsImportStart_Params_Data::ProfileImportObserver_OnFaviconsImportStart_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProfileImportObserver_OnFaviconsImportGroup_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProfileImportObserver_OnFaviconsImportGroup_Params_Data* object =
      static_cast<const ProfileImportObserver_OnFaviconsImportGroup_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->favicons_group, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->favicons_group, validation_context))
    return false;

  return true;
}

ProfileImportObserver_OnFaviconsImportGroup_Params_Data::ProfileImportObserver_OnFaviconsImportGroup_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProfileImportObserver_OnPasswordFormImportReady_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProfileImportObserver_OnPasswordFormImportReady_Params_Data* object =
      static_cast<const ProfileImportObserver_OnPasswordFormImportReady_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->form, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->form, validation_context))
    return false;

  return true;
}

ProfileImportObserver_OnPasswordFormImportReady_Params_Data::ProfileImportObserver_OnPasswordFormImportReady_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProfileImportObserver_OnKeywordsImportReady_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProfileImportObserver_OnKeywordsImportReady_Params_Data* object =
      static_cast<const ProfileImportObserver_OnKeywordsImportReady_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->search_engines, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& search_engines_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->search_engines, validation_context,
                                         &search_engines_validate_params)) {
    return false;
  }

  return true;
}

ProfileImportObserver_OnKeywordsImportReady_Params_Data::ProfileImportObserver_OnKeywordsImportReady_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProfileImportObserver_OnAutofillFormDataImportStart_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProfileImportObserver_OnAutofillFormDataImportStart_Params_Data* object =
      static_cast<const ProfileImportObserver_OnAutofillFormDataImportStart_Params_Data*>(data);

  return true;
}

ProfileImportObserver_OnAutofillFormDataImportStart_Params_Data::ProfileImportObserver_OnAutofillFormDataImportStart_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProfileImportObserver_OnAutofillFormDataImportGroup_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProfileImportObserver_OnAutofillFormDataImportGroup_Params_Data* object =
      static_cast<const ProfileImportObserver_OnAutofillFormDataImportGroup_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->autofill_form_data_entry_group, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& autofill_form_data_entry_group_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->autofill_form_data_entry_group, validation_context,
                                         &autofill_form_data_entry_group_validate_params)) {
    return false;
  }

  return true;
}

ProfileImportObserver_OnAutofillFormDataImportGroup_Params_Data::ProfileImportObserver_OnAutofillFormDataImportGroup_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProfileImport_StartImport_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProfileImport_StartImport_Params_Data* object =
      static_cast<const ProfileImport_StartImport_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->source_profile, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->source_profile, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->localized_strings, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& localized_strings_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
  if (!mojo::internal::ValidateContainer(object->localized_strings, validation_context,
                                         &localized_strings_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->observer, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->observer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

ProfileImport_StartImport_Params_Data::ProfileImport_StartImport_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProfileImport_CancelImport_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProfileImport_CancelImport_Params_Data* object =
      static_cast<const ProfileImport_CancelImport_Params_Data*>(data);

  return true;
}

ProfileImport_CancelImport_Params_Data::ProfileImport_CancelImport_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProfileImport_ReportImportItemFinished_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProfileImport_ReportImportItemFinished_Params_Data* object =
      static_cast<const ProfileImport_ReportImportItemFinished_Params_Data*>(data);


  if (!::chrome::mojom::internal::ImportItem_Data
        ::Validate(object->item, validation_context))
    return false;

  return true;
}

ProfileImport_ReportImportItemFinished_Params_Data::ProfileImport_ReportImportItemFinished_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace chrome

namespace perfetto {

// static
void TraceFormatTraits<::chrome::mojom::ImportedPasswordForm_Scheme>::WriteIntoTrace(
   perfetto::TracedValue context, ::chrome::mojom::ImportedPasswordForm_Scheme value) {
  return std::move(context).WriteString(::chrome::mojom::ImportedPasswordForm_SchemeToString(value));
}

} // namespace perfetto