// chrome/common/importer/profile_import.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_COMMON_IMPORTER_PROFILE_IMPORT_MOJOM_DATA_VIEW_H_
#define CHROME_COMMON_IMPORTER_PROFILE_IMPORT_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "chrome/common/importer/profile_import.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "sandbox/policy/mojom/sandbox.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace chrome::mojom {
using ImportedBookmarkEntryDataView = mojo::native::NativeStructDataView;

using ImporterAutofillFormDataEntryDataView = mojo::native::NativeStructDataView;

using SearchEngineInfoDataView = mojo::native::NativeStructDataView;

using ImporterURLRowDataView = mojo::native::NativeStructDataView;

using SourceProfileDataView = mojo::native::NativeStructDataView;

using FaviconUsageDataListDataView = mojo::native::NativeStructDataView;

using ImporterIE7PasswordInfoDataView = mojo::native::NativeStructDataView;

class ImportedPasswordFormDataView;



}  // chrome::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::chrome::mojom::ImportedPasswordFormDataView> {
  using Data = ::chrome::mojom::internal::ImportedPasswordForm_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace chrome::mojom {
using ImportItem = mojo::NativeEnum;


enum class ImportedPasswordForm_Scheme : int32_t {
  
  kHtml = 0,
  
  kBasic = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, ImportedPasswordForm_Scheme value);
inline bool IsKnownEnumValue(ImportedPasswordForm_Scheme value) {
  return internal::ImportedPasswordForm_Scheme_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class ProfileImportObserverInterfaceBase {};

using ProfileImportObserverPtrDataView =
    mojo::InterfacePtrDataView<ProfileImportObserverInterfaceBase>;
using ProfileImportObserverRequestDataView =
    mojo::InterfaceRequestDataView<ProfileImportObserverInterfaceBase>;
using ProfileImportObserverAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ProfileImportObserverInterfaceBase>;
using ProfileImportObserverAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ProfileImportObserverInterfaceBase>;
class ProfileImportInterfaceBase {};

using ProfileImportPtrDataView =
    mojo::InterfacePtrDataView<ProfileImportInterfaceBase>;
using ProfileImportRequestDataView =
    mojo::InterfaceRequestDataView<ProfileImportInterfaceBase>;
using ProfileImportAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ProfileImportInterfaceBase>;
using ProfileImportAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ProfileImportInterfaceBase>;


class ImportedPasswordFormDataView {
 public:
  ImportedPasswordFormDataView() = default;

  ImportedPasswordFormDataView(
      internal::ImportedPasswordForm_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadScheme(UserType* output) const {
    auto data_value = data_->scheme;
    return mojo::internal::Deserialize<::chrome::mojom::ImportedPasswordForm_Scheme>(
        data_value, output);
  }
  ImportedPasswordForm_Scheme scheme() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::chrome::mojom::ImportedPasswordForm_Scheme>(data_->scheme));
  }
  inline void GetSignonRealmDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSignonRealm(UserType* output) {
    
    auto* pointer = data_->signon_realm.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetActionDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAction(UserType* output) {
    
    auto* pointer = data_->action.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetUsernameElementDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUsernameElement(UserType* output) {
    
    auto* pointer = data_->username_element.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetUsernameValueDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUsernameValue(UserType* output) {
    
    auto* pointer = data_->username_value.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetPasswordElementDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPasswordElement(UserType* output) {
    
    auto* pointer = data_->password_element.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetPasswordValueDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPasswordValue(UserType* output) {
    
    auto* pointer = data_->password_value.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  bool blocked_by_user() const {
    return data_->blocked_by_user;
  }
 private:
  internal::ImportedPasswordForm_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // chrome::mojom

#endif  // CHROME_COMMON_IMPORTER_PROFILE_IMPORT_MOJOM_DATA_VIEW_H_