// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/common/extensions/api/generated_schemas.h"

#include <algorithm>
#include <iterator>
#include <string_view>

#include "base/containers/fixed_flat_map.h"

namespace {
constexpr char kActivityLogPrivate[] = R"R({"namespace":"activityLogPrivate","types":[{"id":"activityLogPrivate.ExtensionActivityType","type":"string","enum":["api_call","api_event","content_script","dom_access","dom_event","web_request"]},{"id":"activityLogPrivate.ExtensionActivityFilter","type":"string","enum":["api_call","api_event","content_script","dom_access","dom_event","web_request","any"]},{"id":"activityLogPrivate.ExtensionActivityDomVerb","type":"string","enum":["getter","setter","method","inserted","xhr","webrequest","modified"]},{"id":"activityLogPrivate.ExtensionActivity","type":"object","properties":{"activityId":{"type":"string","optional":true},"extensionId":{"type":"string","optional":true},"activityType":{"$ref":"activityLogPrivate.ExtensionActivityType"},"time":{"type":"number","optional":true},"apiCall":{"type":"string","optional":true},"args":{"type":"string","optional":true},"count":{"type":"number","optional":true},"pageUrl":{"type":"string","optional":true},"pageTitle":{"type":"string","optional":true},"argUrl":{"type":"string","optional":true},"other":{"type":"object","optional":true,"properties":{"prerender":{"type":"boolean","optional":true},"domVerb":{"$ref":"activityLogPrivate.ExtensionActivityDomVerb","optional":true},"webRequest":{"type":"string","optional":true},"extra":{"type":"string","optional":true}}}}},{"id":"activityLogPrivate.Filter","type":"object","properties":{"extensionId":{"type":"string","optional":true},"activityType":{"$ref":"activityLogPrivate.ExtensionActivityFilter"},"apiCall":{"type":"string","optional":true},"pageUrl":{"type":"string","optional":true},"argUrl":{"type":"string","optional":true},"daysAgo":{"type":"integer","optional":true}}},{"id":"activityLogPrivate.ActivityResultSet","type":"object","properties":{"activities":{"type":"array","items":{"$ref":"activityLogPrivate.ExtensionActivity"}}}}],"functions":[{"name":"getExtensionActivities","type":"function","parameters":[{"name":"filter","$ref":"activityLogPrivate.Filter"}],"returns_async":{"name":"callback","parameters":[{"name":"result","$ref":"activityLogPrivate.ActivityResultSet"}]}},{"name":"deleteActivities","type":"function","parameters":[{"name":"activityIds","type":"array","items":{"type":"string"}}],"returns_async":{"name":"callback","parameters":[],"optional":true}},{"name":"deleteActivitiesByExtension","type":"function","parameters":[{"name":"extensionId","type":"string"}],"returns_async":{"name":"callback","parameters":[],"optional":true}},{"name":"deleteDatabase","type":"function","parameters":[]},{"name":"deleteUrls","type":"function","parameters":[{"name":"urls","type":"array","items":{"type":"string"}}]}],"events":[{"name":"onExtensionActivity","type":"function","parameters":[{"name":"activity","$ref":"activityLogPrivate.ExtensionActivity"}]}]})R";
constexpr char kBookmarks[] = R"R({"namespace":"bookmarks","properties":{"MAX_WRITE_OPERATIONS_PER_HOUR":{"value":1000000,"deprecated":"Bookmark write operations are no longer limited by Chrome.","type":"integer"},"MAX_SUSTAINED_WRITE_OPERATIONS_PER_MINUTE":{"value":1000000,"deprecated":"Bookmark write operations are no longer limited by Chrome.","type":"integer"}},"types":[{"id":"bookmarks.FolderType","type":"string","enum":[{"name":"bookmarks-bar"},{"name":"other"},{"name":"mobile"},{"name":"managed"}]},{"id":"bookmarks.BookmarkTreeNodeUnmodifiable","type":"string","enum":["managed"]},{"id":"bookmarks.BookmarkTreeNode","type":"object","properties":{"id":{"type":"string","minimum":0},"parentId":{"type":"string","minimum":0,"optional":true},"index":{"type":"integer","optional":true},"url":{"type":"string","optional":true},"title":{"type":"string"},"dateAdded":{"type":"number","optional":true},"dateLastUsed":{"type":"number","optional":true},"dateGroupModified":{"type":"number","optional":true},"folderType":{"$ref":"bookmarks.FolderType","optional":true},"unmodifiable":{"$ref":"bookmarks.BookmarkTreeNodeUnmodifiable","optional":true},"syncing":{"type":"boolean"},"children":{"type":"array","optional":true,"items":{"$ref":"bookmarks.BookmarkTreeNode"}}}},{"id":"bookmarks.CreateDetails","type":"object","properties":{"parentId":{"type":"string","serialized_type":"int64","optional":true},"index":{"type":"integer","minimum":0,"optional":true},"title":{"type":"string","optional":true},"url":{"type":"string","optional":true}}}],"functions":[{"name":"get","type":"function","parameters":[{"name":"idOrIdList","choices":[{"type":"string","serialized_type":"int64"},{"type":"array","items":{"type":"string","serialized_type":"int64"},"minItems":1}]}],"returns_async":{"name":"callback","parameters":[{"name":"results","type":"array","items":{"$ref":"bookmarks.BookmarkTreeNode"}}]}},{"name":"getChildren","type":"function","parameters":[{"type":"string","serialized_type":"int64","name":"id"}],"returns_async":{"name":"callback","parameters":[{"name":"results","type":"array","items":{"$ref":"bookmarks.BookmarkTreeNode"}}]}},{"name":"getRecent","type":"function","parameters":[{"type":"integer","minimum":1,"name":"numberOfItems"}],"returns_async":{"name":"callback","parameters":[{"name":"results","type":"array","items":{"$ref":"bookmarks.BookmarkTreeNode"}}]}},{"name":"getTree","type":"function","parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"results","type":"array","items":{"$ref":"bookmarks.BookmarkTreeNode"}}]}},{"name":"getSubTree","type":"function","parameters":[{"type":"string","serialized_type":"int64","name":"id"}],"returns_async":{"name":"callback","parameters":[{"name":"results","type":"array","items":{"$ref":"bookmarks.BookmarkTreeNode"}}]}},{"name":"search","type":"function","parameters":[{"name":"query","choices":[{"type":"string"},{"type":"object","properties":{"query":{"type":"string","optional":true},"url":{"type":"string","optional":true},"title":{"type":"string","optional":true}}}]}],"returns_async":{"name":"callback","parameters":[{"name":"results","type":"array","items":{"$ref":"bookmarks.BookmarkTreeNode"}}]}},{"name":"create","type":"function","parameters":[{"$ref":"bookmarks.CreateDetails","name":"bookmark"}],"returns_async":{"name":"callback","optional":true,"parameters":[{"name":"result","$ref":"bookmarks.BookmarkTreeNode"}]}},{"name":"move","type":"function","parameters":[{"type":"string","serialized_type":"int64","name":"id"},{"type":"object","name":"destination","properties":{"parentId":{"type":"string","optional":true},"index":{"type":"integer","minimum":0,"optional":true}}}],"returns_async":{"name":"callback","optional":true,"parameters":[{"name":"result","$ref":"bookmarks.BookmarkTreeNode"}]}},{"name":"update","type":"function","parameters":[{"type":"string","serialized_type":"int64","name":"id"},{"type":"object","name":"changes","properties":{"title":{"type":"string","optional":true},"url":{"type":"string","optional":true}}}],"returns_async":{"name":"callback","optional":true,"parameters":[{"name":"result","$ref":"bookmarks.BookmarkTreeNode"}]}},{"name":"remove","type":"function","parameters":[{"type":"string","serialized_type":"int64","name":"id"}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"removeTree","type":"function","parameters":[{"type":"string","serialized_type":"int64","name":"id"}],"returns_async":{"name":"callback","optional":true,"parameters":[]}}],"events":[{"name":"onCreated","type":"function","parameters":[{"type":"string","name":"id"},{"$ref":"bookmarks.BookmarkTreeNode","name":"bookmark"}]},{"name":"onRemoved","type":"function","parameters":[{"type":"string","name":"id"},{"type":"object","name":"removeInfo","properties":{"parentId":{"type":"string"},"index":{"type":"integer"},"node":{"$ref":"bookmarks.BookmarkTreeNode"}}}]},{"name":"onChanged","type":"function","parameters":[{"type":"string","name":"id"},{"type":"object","name":"changeInfo","properties":{"title":{"type":"string"},"url":{"type":"string","optional":true}}}]},{"name":"onMoved","type":"function","parameters":[{"type":"string","name":"id"},{"type":"object","name":"moveInfo","properties":{"parentId":{"type":"string"},"index":{"type":"integer"},"oldParentId":{"type":"string"},"oldIndex":{"type":"integer"}}}]},{"name":"onChildrenReordered","type":"function","parameters":[{"type":"string","name":"id"},{"type":"object","name":"reorderInfo","properties":{"childIds":{"type":"array","items":{"type":"string"}}}}]},{"name":"onImportBegan","type":"function","parameters":[]},{"name":"onImportEnded","type":"function","parameters":[]}]})R";
constexpr char kCookies[] = R"R({"namespace":"cookies","types":[{"id":"cookies.SameSiteStatus","type":"string","enum":["no_restriction","lax","strict","unspecified"]},{"id":"cookies.CookiePartitionKey","type":"object","properties":{"topLevelSite":{"type":"string","optional":true},"hasCrossSiteAncestor":{"type":"boolean","optional":true}}},{"id":"cookies.Cookie","type":"object","properties":{"name":{"type":"string"},"value":{"type":"string"},"domain":{"type":"string"},"hostOnly":{"type":"boolean"},"path":{"type":"string"},"secure":{"type":"boolean"},"httpOnly":{"type":"boolean"},"sameSite":{"$ref":"cookies.SameSiteStatus"},"session":{"type":"boolean"},"expirationDate":{"type":"number","optional":true},"storeId":{"type":"string"},"partitionKey":{"$ref":"cookies.CookiePartitionKey","optional":true}}},{"id":"cookies.CookieStore","type":"object","properties":{"id":{"type":"string"},"tabIds":{"type":"array","items":{"type":"integer"}}}},{"id":"cookies.OnChangedCause","type":"string","enum":["evicted","expired","explicit","expired_overwrite","overwrite"]},{"id":"cookies.CookieDetails","type":"object","properties":{"url":{"type":"string"},"name":{"type":"string"},"storeId":{"type":"string","optional":true},"partitionKey":{"$ref":"cookies.CookiePartitionKey","optional":true}}},{"id":"cookies.FrameDetails","type":"object","properties":{"tabId":{"type":"integer","optional":true},"frameId":{"type":"integer","optional":true},"documentId":{"type":"string","optional":true}}}],"functions":[{"name":"get","type":"function","parameters":[{"name":"details","$ref":"cookies.CookieDetails"}],"returns_async":{"name":"callback","parameters":[{"name":"cookie","$ref":"cookies.Cookie","optional":true}]}},{"name":"getAll","type":"function","parameters":[{"type":"object","name":"details","properties":{"url":{"type":"string","optional":true},"name":{"type":"string","optional":true},"domain":{"type":"string","optional":true},"path":{"type":"string","optional":true},"secure":{"type":"boolean","optional":true},"session":{"type":"boolean","optional":true},"storeId":{"type":"string","optional":true},"partitionKey":{"$ref":"cookies.CookiePartitionKey","optional":true}}}],"returns_async":{"name":"callback","parameters":[{"name":"cookies","type":"array","items":{"$ref":"cookies.Cookie"}}]}},{"name":"set","type":"function","parameters":[{"type":"object","name":"details","properties":{"url":{"type":"string"},"name":{"type":"string","optional":true},"value":{"type":"string","optional":true},"domain":{"type":"string","optional":true},"path":{"type":"string","optional":true},"secure":{"type":"boolean","optional":true},"httpOnly":{"type":"boolean","optional":true},"sameSite":{"$ref":"cookies.SameSiteStatus","optional":true},"expirationDate":{"type":"number","optional":true},"storeId":{"type":"string","optional":true},"partitionKey":{"$ref":"cookies.CookiePartitionKey","optional":true}}}],"returns_async":{"name":"callback","optional":true,"min_version":"11.0.674.0","parameters":[{"name":"cookie","$ref":"cookies.Cookie","optional":true}]}},{"name":"remove","type":"function","parameters":[{"name":"details","$ref":"cookies.CookieDetails"}],"returns_async":{"name":"callback","optional":true,"min_version":"11.0.674.0","parameters":[{"name":"details","type":"object","optional":true,"properties":{"url":{"type":"string"},"name":{"type":"string"},"storeId":{"type":"string"},"partitionKey":{"$ref":"cookies.CookiePartitionKey","optional":true}}}]}},{"name":"getAllCookieStores","type":"function","parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"cookieStores","type":"array","items":{"$ref":"cookies.CookieStore"}}]}},{"name":"getPartitionKey","type":"function","parameters":[{"name":"details","$ref":"cookies.FrameDetails"}],"returns_async":{"name":"callback","optional":true,"parameters":[{"name":"details","type":"object","properties":{"partitionKey":{"$ref":"cookies.CookiePartitionKey"}}}]}}],"events":[{"name":"onChanged","type":"function","parameters":[{"type":"object","name":"changeInfo","properties":{"removed":{"type":"boolean"},"cookie":{"$ref":"cookies.Cookie"},"cause":{"min_version":"12.0.707.0","$ref":"cookies.OnChangedCause"}}}]}]})R";
constexpr char kContextMenus[] = R"R({"namespace":"contextMenus","properties":{"ACTION_MENU_TOP_LEVEL_LIMIT":{"value":6,"type":"integer"}},"types":[{"id":"contextMenus.ContextType","type":"string","enum":["all","page","frame","selection","link","editable","image","video","audio","launcher","browser_action","page_action","action"]},{"id":"contextMenus.ItemType","type":"string","enum":["normal","checkbox","radio","separator"]},{"id":"contextMenus.OnClickData","type":"object","properties":{"menuItemId":{"choices":[{"type":"integer"},{"type":"string"}]},"parentMenuItemId":{"choices":[{"type":"integer"},{"type":"string"}],"optional":true},"mediaType":{"type":"string","optional":true},"linkUrl":{"type":"string","optional":true},"srcUrl":{"type":"string","optional":true},"pageUrl":{"type":"string","optional":true},"frameUrl":{"type":"string","optional":true},"frameId":{"type":"integer","optional":true},"selectionText":{"type":"string","optional":true},"editable":{"type":"boolean"},"wasChecked":{"type":"boolean","optional":true},"checked":{"type":"boolean","optional":true}}},{"id":"contextMenus.CreateProperties","type":"object","properties":{"type":{"$ref":"contextMenus.ItemType","optional":true},"id":{"type":"string","optional":true},"title":{"type":"string","optional":true},"checked":{"type":"boolean","optional":true},"contexts":{"type":"array","items":{"$ref":"contextMenus.ContextType"},"minItems":1,"optional":true},"visible":{"type":"boolean","optional":true},"onclick":{"type":"function","optional":true,"parameters":[{"name":"info","$ref":"contextMenus.OnClickData"},{"name":"tab","$ref":"tabs.Tab"}]},"parentId":{"choices":[{"type":"integer"},{"type":"string"}],"optional":true},"documentUrlPatterns":{"type":"array","items":{"type":"string"},"optional":true},"targetUrlPatterns":{"type":"array","items":{"type":"string"},"optional":true},"enabled":{"type":"boolean","optional":true}}}],"functions":[{"name":"create","type":"function","returns":{"choices":[{"type":"integer"},{"type":"string"}]},"parameters":[{"$ref":"contextMenus.CreateProperties","name":"createProperties"}],"returns_async":{"name":"callback","optional":true,"parameters":[],"does_not_support_promises":"Synchronous return and callback crbug.com/1143032"}},{"name":"update","type":"function","parameters":[{"choices":[{"type":"integer"},{"type":"string"}],"name":"id"},{"type":"object","name":"updateProperties","preserveNull":true,"properties":{"type":{"$ref":"contextMenus.ItemType","optional":true},"title":{"type":"string","optional":true},"checked":{"type":"boolean","optional":true},"contexts":{"type":"array","items":{"$ref":"contextMenus.ContextType"},"minItems":1,"optional":true},"visible":{"type":"boolean","optional":true},"onclick":{"type":"function","optional":true,"parameters":[{"name":"info","$ref":"contextMenus.OnClickData"},{"name":"tab","$ref":"tabs.Tab"}]},"parentId":{"choices":[{"type":"integer"},{"type":"string"}],"optional":true},"documentUrlPatterns":{"type":"array","items":{"type":"string"},"optional":true},"targetUrlPatterns":{"type":"array","items":{"type":"string"},"optional":true},"enabled":{"type":"boolean","optional":true}}}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"remove","type":"function","parameters":[{"choices":[{"type":"integer"},{"type":"string"}],"name":"menuItemId"}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"removeAll","type":"function","parameters":[],"returns_async":{"name":"callback","optional":true,"parameters":[]}}],"events":[{"name":"onClicked","type":"function","parameters":[{"name":"info","$ref":"contextMenus.OnClickData"},{"name":"tab","$ref":"tabs.Tab","optional":true}]}]})R";
constexpr char kDebugger[] = R"R({"namespace":"debugger","types":[{"id":"debugger.Debuggee","type":"object","properties":{"tabId":{"type":"integer","optional":true},"extensionId":{"type":"string","optional":true},"targetId":{"type":"string","optional":true}}},{"id":"debugger.DebuggerSession","type":"object","properties":{"tabId":{"type":"integer","optional":true},"extensionId":{"type":"string","optional":true},"targetId":{"type":"string","optional":true},"sessionId":{"type":"string","optional":true}}},{"id":"debugger.TargetInfoType","type":"string","enum":["page","background_page","worker","other"]},{"id":"debugger.DetachReason","type":"string","enum":["target_closed","canceled_by_user"]},{"id":"debugger.TargetInfo","type":"object","properties":{"type":{"$ref":"debugger.TargetInfoType"},"id":{"type":"string"},"tabId":{"type":"integer","optional":true},"extensionId":{"type":"string","optional":true},"attached":{"type":"boolean"},"title":{"type":"string"},"url":{"type":"string"},"faviconUrl":{"type":"string","optional":true}}}],"functions":[{"name":"attach","type":"function","parameters":[{"$ref":"debugger.Debuggee","name":"target"},{"type":"string","name":"requiredVersion"}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"detach","type":"function","parameters":[{"$ref":"debugger.Debuggee","name":"target"}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"sendCommand","type":"function","parameters":[{"$ref":"debugger.DebuggerSession","name":"target"},{"type":"string","name":"method"},{"type":"object","name":"commandParams","optional":true,"additionalProperties":{"type":"any"}}],"returns_async":{"name":"callback","optional":true,"parameters":[{"type":"object","name":"result","optional":true,"additionalProperties":{"type":"any"}}]}},{"name":"getTargets","type":"function","parameters":[],"returns_async":{"name":"callback","parameters":[{"type":"array","name":"result","items":{"$ref":"debugger.TargetInfo"}}]}}],"events":[{"name":"onEvent","type":"function","parameters":[{"$ref":"debugger.DebuggerSession","name":"source"},{"type":"string","name":"method"},{"type":"object","name":"params","optional":true,"additionalProperties":{"type":"any"}}]},{"name":"onDetach","type":"function","parameters":[{"$ref":"debugger.Debuggee","name":"source"},{"$ref":"debugger.DetachReason","name":"reason"}]}]})R";
constexpr char kDeveloperPrivate[] = R"R({"namespace":"developerPrivate","types":[{"id":"developerPrivate.InspectOptions","properties":{"extension_id":{"name":"extension_id","type":"string"},"render_process_id":{"name":"render_process_id","choices":[{"type":"string"},{"type":"integer"}]},"render_view_id":{"name":"render_view_id","choices":[{"type":"string"},{"type":"integer"}]},"incognito":{"name":"incognito","type":"boolean"}},"type":"object"},{"id":"developerPrivate.ExtensionType","type":"string","enum":[{"name":"HOSTED_APP"},{"name":"PLATFORM_APP"},{"name":"LEGACY_PACKAGED_APP"},{"name":"EXTENSION"},{"name":"THEME"},{"name":"SHARED_MODULE"}]},{"id":"developerPrivate.Location","type":"string","enum":[{"name":"FROM_STORE"},{"name":"UNPACKED"},{"name":"THIRD_PARTY"},{"name":"INSTALLED_BY_DEFAULT"},{"name":"UNKNOWN"}]},{"id":"developerPrivate.ViewType","type":"string","enum":[{"name":"APP_WINDOW"},{"name":"BACKGROUND_CONTENTS"},{"name":"COMPONENT"},{"name":"EXTENSION_BACKGROUND_PAGE"},{"name":"EXTENSION_GUEST"},{"name":"EXTENSION_POPUP"},{"name":"EXTENSION_SERVICE_WORKER_BACKGROUND"},{"name":"TAB_CONTENTS"},{"name":"OFFSCREEN_DOCUMENT"},{"name":"EXTENSION_SIDE_PANEL"},{"name":"DEVELOPER_TOOLS"}]},{"id":"developerPrivate.ErrorType","type":"string","enum":[{"name":"MANIFEST"},{"name":"RUNTIME"}]},{"id":"developerPrivate.ErrorLevel","type":"string","enum":[{"name":"LOG"},{"name":"WARN"},{"name":"ERROR"}]},{"id":"developerPrivate.ExtensionState","type":"string","enum":[{"name":"ENABLED"},{"name":"DISABLED"},{"name":"TERMINATED"},{"name":"BLOCKLISTED"}]},{"id":"developerPrivate.CommandScope","type":"string","enum":[{"name":"GLOBAL"},{"name":"CHROME"}]},{"id":"developerPrivate.SafetyCheckWarningReason","type":"string","enum":[{"name":"UNPUBLISHED"},{"name":"POLICY"},{"name":"MALWARE"},{"name":"OFFSTORE"},{"name":"UNWANTED"},{"name":"NO_PRIVACY_PRACTICE"}]},{"id":"developerPrivate.AccessModifier","properties":{"isEnabled":{"name":"isEnabled","type":"boolean"},"isActive":{"name":"isActive","type":"boolean"}},"type":"object"},{"id":"developerPrivate.StackFrame","properties":{"lineNumber":{"name":"lineNumber","type":"integer"},"columnNumber":{"name":"columnNumber","type":"integer"},"url":{"name":"url","type":"string"},"functionName":{"name":"functionName","type":"string"}},"type":"object"},{"id":"developerPrivate.ManifestError","properties":{"type":{"name":"type","$ref":"developerPrivate.ErrorType"},"extensionId":{"name":"extensionId","type":"string"},"fromIncognito":{"name":"fromIncognito","type":"boolean"},"source":{"name":"source","type":"string"},"message":{"name":"message","type":"string"},"id":{"name":"id","type":"integer"},"manifestKey":{"name":"manifestKey","type":"string"},"manifestSpecific":{"optional":true,"name":"manifestSpecific","type":"string"}},"type":"object"},{"id":"developerPrivate.RuntimeError","properties":{"type":{"name":"type","$ref":"developerPrivate.ErrorType"},"extensionId":{"name":"extensionId","type":"string"},"fromIncognito":{"name":"fromIncognito","type":"boolean"},"source":{"name":"source","type":"string"},"message":{"name":"message","type":"string"},"id":{"name":"id","type":"integer"},"severity":{"name":"severity","$ref":"developerPrivate.ErrorLevel"},"contextUrl":{"name":"contextUrl","type":"string"},"occurrences":{"name":"occurrences","type":"integer"},"renderViewId":{"name":"renderViewId","type":"integer"},"renderProcessId":{"name":"renderProcessId","type":"integer"},"canInspect":{"name":"canInspect","type":"boolean"},"isServiceWorker":{"name":"isServiceWorker","type":"boolean"},"stackTrace":{"name":"stackTrace","type":"array","items":{"$ref":"developerPrivate.StackFrame"}}},"type":"object"},{"id":"developerPrivate.DisableReasons","properties":{"suspiciousInstall":{"name":"suspiciousInstall","type":"boolean"},"corruptInstall":{"name":"corruptInstall","type":"boolean"},"updateRequired":{"name":"updateRequired","type":"boolean"},"publishedInStoreRequired":{"name":"publishedInStoreRequired","type":"boolean"},"blockedByPolicy":{"name":"blockedByPolicy","type":"boolean"},"reloading":{"name":"reloading","type":"boolean"},"custodianApprovalRequired":{"name":"custodianApprovalRequired","type":"boolean"},"parentDisabledPermissions":{"name":"parentDisabledPermissions","type":"boolean"},"unsupportedManifestVersion":{"name":"unsupportedManifestVersion","type":"boolean"},"unsupportedDeveloperExtension":{"name":"unsupportedDeveloperExtension","type":"boolean"}},"type":"object"},{"id":"developerPrivate.OptionsPage","properties":{"openInTab":{"name":"openInTab","type":"boolean"},"url":{"name":"url","type":"string"}},"type":"object"},{"id":"developerPrivate.HomePage","properties":{"url":{"name":"url","type":"string"},"specified":{"name":"specified","type":"boolean"}},"type":"object"},{"id":"developerPrivate.ExtensionView","properties":{"url":{"name":"url","type":"string"},"renderProcessId":{"name":"renderProcessId","type":"integer"},"renderViewId":{"name":"renderViewId","type":"integer"},"incognito":{"name":"incognito","type":"boolean"},"isIframe":{"name":"isIframe","type":"boolean"},"type":{"name":"type","$ref":"developerPrivate.ViewType"}},"type":"object"},{"id":"developerPrivate.HostAccess","type":"string","enum":[{"name":"ON_CLICK"},{"name":"ON_SPECIFIC_SITES"},{"name":"ON_ALL_SITES"}]},{"id":"developerPrivate.SafetyCheckStrings","properties":{"panelString":{"optional":true,"name":"panelString","type":"string"},"detailString":{"optional":true,"name":"detailString","type":"string"}},"type":"object"},{"id":"developerPrivate.ControlledInfo","properties":{"text":{"name":"text","type":"string"}},"type":"object"},{"id":"developerPrivate.Command","properties":{"description":{"name":"description","type":"string"},"keybinding":{"name":"keybinding","type":"string"},"name":{"name":"name","type":"string"},"isActive":{"name":"isActive","type":"boolean"},"scope":{"name":"scope","$ref":"developerPrivate.CommandScope"},"isExtensionAction":{"name":"isExtensionAction","type":"boolean"}},"type":"object"},{"id":"developerPrivate.DependentExtension","properties":{"id":{"name":"id","type":"string"},"name":{"name":"name","type":"string"}},"type":"object"},{"id":"developerPrivate.Permission","properties":{"message":{"name":"message","type":"string"},"submessages":{"name":"submessages","type":"array","items":{"type":"string"}}},"type":"object"},{"id":"developerPrivate.SiteControl","properties":{"host":{"name":"host","type":"string"},"granted":{"name":"granted","type":"boolean"}},"type":"object"},{"id":"developerPrivate.RuntimeHostPermissions","properties":{"hasAllHosts":{"name":"hasAllHosts","type":"boolean"},"hostAccess":{"name":"hostAccess","$ref":"developerPrivate.HostAccess"},"hosts":{"name":"hosts","type":"array","items":{"$ref":"developerPrivate.SiteControl"}}},"type":"object"},{"id":"developerPrivate.Permissions","properties":{"simplePermissions":{"name":"simplePermissions","type":"array","items":{"$ref":"developerPrivate.Permission"}},"runtimeHostPermissions":{"optional":true,"name":"runtimeHostPermissions","$ref":"developerPrivate.RuntimeHostPermissions"},"canAccessSiteData":{"name":"canAccessSiteData","type":"boolean"}},"type":"object"},{"id":"developerPrivate.ExtensionInfo","properties":{"blocklistText":{"optional":true,"name":"blocklistText","type":"string"},"safetyCheckText":{"optional":true,"name":"safetyCheckText","$ref":"developerPrivate.SafetyCheckStrings"},"commands":{"name":"commands","type":"array","items":{"$ref":"developerPrivate.Command"}},"controlledInfo":{"optional":true,"name":"controlledInfo","$ref":"developerPrivate.ControlledInfo"},"dependentExtensions":{"name":"dependentExtensions","type":"array","items":{"$ref":"developerPrivate.DependentExtension"}},"description":{"name":"description","type":"string"},"disableReasons":{"name":"disableReasons","$ref":"developerPrivate.DisableReasons"},"errorCollection":{"name":"errorCollection","$ref":"developerPrivate.AccessModifier"},"fileAccess":{"name":"fileAccess","$ref":"developerPrivate.AccessModifier"},"fileAccessPendingChange":{"name":"fileAccessPendingChange","type":"boolean"},"homePage":{"name":"homePage","$ref":"developerPrivate.HomePage"},"iconUrl":{"name":"iconUrl","type":"string"},"id":{"name":"id","type":"strin)R" R"R(g"},"incognitoAccess":{"name":"incognitoAccess","$ref":"developerPrivate.AccessModifier"},"userScriptsAccess":{"name":"userScriptsAccess","$ref":"developerPrivate.AccessModifier"},"incognitoAccessPendingChange":{"name":"incognitoAccessPendingChange","type":"boolean"},"installWarnings":{"name":"installWarnings","type":"array","items":{"type":"string"}},"isCommandRegistrationHandledExternally":{"name":"isCommandRegistrationHandledExternally","type":"boolean"},"launchUrl":{"optional":true,"name":"launchUrl","type":"string"},"location":{"name":"location","$ref":"developerPrivate.Location"},"locationText":{"optional":true,"name":"locationText","type":"string"},"manifestErrors":{"name":"manifestErrors","type":"array","items":{"$ref":"developerPrivate.ManifestError"}},"manifestHomePageUrl":{"name":"manifestHomePageUrl","type":"string"},"mustRemainInstalled":{"name":"mustRemainInstalled","type":"boolean"},"name":{"name":"name","type":"string"},"offlineEnabled":{"name":"offlineEnabled","type":"boolean"},"optionsPage":{"optional":true,"name":"optionsPage","$ref":"developerPrivate.OptionsPage"},"path":{"optional":true,"name":"path","type":"string"},"permissions":{"name":"permissions","$ref":"developerPrivate.Permissions"},"prettifiedPath":{"optional":true,"name":"prettifiedPath","type":"string"},"recommendationsUrl":{"optional":true,"name":"recommendationsUrl","type":"string"},"runtimeErrors":{"name":"runtimeErrors","type":"array","items":{"$ref":"developerPrivate.RuntimeError"}},"runtimeWarnings":{"name":"runtimeWarnings","type":"array","items":{"type":"string"}},"state":{"name":"state","$ref":"developerPrivate.ExtensionState"},"type":{"name":"type","$ref":"developerPrivate.ExtensionType"},"updateUrl":{"name":"updateUrl","type":"string"},"userMayModify":{"name":"userMayModify","type":"boolean"},"version":{"name":"version","type":"string"},"views":{"name":"views","type":"array","items":{"$ref":"developerPrivate.ExtensionView"}},"webStoreUrl":{"name":"webStoreUrl","type":"string"},"showSafeBrowsingAllowlistWarning":{"name":"showSafeBrowsingAllowlistWarning","type":"boolean"},"safetyCheckWarningReason":{"optional":true,"name":"safetyCheckWarningReason","$ref":"developerPrivate.SafetyCheckWarningReason"},"showAccessRequestsInToolbar":{"name":"showAccessRequestsInToolbar","type":"boolean"},"pinnedToToolbar":{"optional":true,"name":"pinnedToToolbar","type":"boolean"},"isAffectedByMV2Deprecation":{"name":"isAffectedByMV2Deprecation","type":"boolean"},"didAcknowledgeMV2DeprecationNotice":{"name":"didAcknowledgeMV2DeprecationNotice","type":"boolean"},"canUploadAsAccountExtension":{"name":"canUploadAsAccountExtension","type":"boolean"}},"type":"object"},{"id":"developerPrivate.ProfileInfo","properties":{"canLoadUnpacked":{"name":"canLoadUnpacked","type":"boolean"},"inDeveloperMode":{"name":"inDeveloperMode","type":"boolean"},"isDeveloperModeControlledByPolicy":{"name":"isDeveloperModeControlledByPolicy","type":"boolean"},"isIncognitoAvailable":{"name":"isIncognitoAvailable","type":"boolean"},"isChildAccount":{"name":"isChildAccount","type":"boolean"},"isMv2DeprecationNoticeDismissed":{"name":"isMv2DeprecationNoticeDismissed","type":"boolean"}},"type":"object"},{"id":"developerPrivate.GetExtensionsInfoOptions","properties":{"includeDisabled":{"optional":true,"name":"includeDisabled","type":"boolean"},"includeTerminated":{"optional":true,"name":"includeTerminated","type":"boolean"}},"type":"object"},{"id":"developerPrivate.ExtensionConfigurationUpdate","properties":{"extensionId":{"name":"extensionId","type":"string"},"fileAccess":{"optional":true,"name":"fileAccess","type":"boolean"},"incognitoAccess":{"optional":true,"name":"incognitoAccess","type":"boolean"},"userScriptsAccess":{"optional":true,"name":"userScriptsAccess","type":"boolean"},"errorCollection":{"optional":true,"name":"errorCollection","type":"boolean"},"hostAccess":{"optional":true,"name":"hostAccess","$ref":"developerPrivate.HostAccess"},"showAccessRequestsInToolbar":{"optional":true,"name":"showAccessRequestsInToolbar","type":"boolean"},"acknowledgeSafetyCheckWarningReason":{"optional":true,"name":"acknowledgeSafetyCheckWarningReason","$ref":"developerPrivate.SafetyCheckWarningReason"},"acknowledgeSafetyCheckWarning":{"optional":true,"name":"acknowledgeSafetyCheckWarning","type":"boolean"},"pinnedToToolbar":{"optional":true,"name":"pinnedToToolbar","type":"boolean"}},"type":"object"},{"id":"developerPrivate.ProfileConfigurationUpdate","properties":{"inDeveloperMode":{"optional":true,"name":"inDeveloperMode","type":"boolean"},"isMv2DeprecationNoticeDismissed":{"optional":true,"name":"isMv2DeprecationNoticeDismissed","type":"boolean"}},"type":"object"},{"id":"developerPrivate.ExtensionCommandUpdate","properties":{"extensionId":{"name":"extensionId","type":"string"},"commandName":{"name":"commandName","type":"string"},"scope":{"optional":true,"name":"scope","$ref":"developerPrivate.CommandScope"},"keybinding":{"optional":true,"name":"keybinding","type":"string"}},"type":"object"},{"id":"developerPrivate.ReloadOptions","properties":{"failQuietly":{"optional":true,"name":"failQuietly","type":"boolean"},"populateErrorForUnpacked":{"optional":true,"name":"populateErrorForUnpacked","type":"boolean"}},"type":"object"},{"id":"developerPrivate.LoadUnpackedOptions","properties":{"failQuietly":{"optional":true,"name":"failQuietly","type":"boolean"},"populateError":{"optional":true,"name":"populateError","type":"boolean"},"retryGuid":{"optional":true,"name":"retryGuid","type":"string"},"useDraggedPath":{"optional":true,"name":"useDraggedPath","type":"boolean"}},"type":"object"},{"id":"developerPrivate.SiteSet","type":"string","enum":[{"name":"USER_PERMITTED"},{"name":"USER_RESTRICTED"},{"name":"EXTENSION_SPECIFIED"}]},{"id":"developerPrivate.UserSiteSettingsOptions","properties":{"siteSet":{"name":"siteSet","$ref":"developerPrivate.SiteSet"},"hosts":{"name":"hosts","type":"array","items":{"type":"string"}}},"type":"object"},{"id":"developerPrivate.UserSiteSettings","properties":{"permittedSites":{"name":"permittedSites","type":"array","items":{"type":"string"}},"restrictedSites":{"name":"restrictedSites","type":"array","items":{"type":"string"}}},"type":"object"},{"id":"developerPrivate.SiteInfo","properties":{"siteSet":{"name":"siteSet","$ref":"developerPrivate.SiteSet"},"numExtensions":{"name":"numExtensions","type":"integer"},"site":{"name":"site","type":"string"}},"type":"object"},{"id":"developerPrivate.SiteGroup","properties":{"etldPlusOne":{"name":"etldPlusOne","type":"string"},"numExtensions":{"name":"numExtensions","type":"integer"},"sites":{"name":"sites","type":"array","items":{"$ref":"developerPrivate.SiteInfo"}}},"type":"object"},{"id":"developerPrivate.MatchingExtensionInfo","properties":{"id":{"name":"id","type":"string"},"siteAccess":{"name":"siteAccess","$ref":"developerPrivate.HostAccess"},"canRequestAllSites":{"name":"canRequestAllSites","type":"boolean"}},"type":"object"},{"id":"developerPrivate.ExtensionSiteAccessUpdate","properties":{"id":{"name":"id","type":"string"},"siteAccess":{"name":"siteAccess","$ref":"developerPrivate.HostAccess"}},"type":"object"},{"id":"developerPrivate.PackStatus","type":"string","enum":[{"name":"SUCCESS"},{"name":"ERROR"},{"name":"WARNING"}]},{"id":"developerPrivate.FileType","type":"string","enum":[{"name":"LOAD"},{"name":"PEM"}]},{"id":"developerPrivate.SelectType","type":"string","enum":[{"name":"FILE"},{"name":"FOLDER"}]},{"id":"developerPrivate.EventType","type":"string","enum":[{"name":"INSTALLED"},{"name":"UNINSTALLED"},{"name":"LOADED"},{"name":"UNLOADED"},{"name":"VIEW_REGISTERED"},{"name":"VIEW_UNREGISTERED"},{"name":"ERROR_ADDED"},{"name":"ERRORS_REMOVED"},{"name":"PREFS_CHANGED"},{"name":"WARNINGS_CHANGED"},{"name":"COMMAND_ADDED"},{"name":"COMMAND_REMOVED"},{"name":"PERMISSIONS_CHANGED"},{"name":"SERVICE_WORKER_STARTED"},{"name":"SERVICE_WORKER_STOPPED"},{"name":"CONFIGURATION_CHANGED"},{"name":"PINNED_ACTIONS_CHANGED"}]},{"id":"developerPrivate.PackDirectoryResponse","properties":{"message":{"name":"message","type":"string"},"item_path":{"name":"item_path","type":"string"},"pem_path":{"name":"pem_path","type":"string"},"override_flags":{"na)R" R"R(me":"override_flags","type":"integer"},"status":{"name":"status","$ref":"developerPrivate.PackStatus"}},"type":"object"},{"id":"developerPrivate.ProjectInfo","properties":{"name":{"name":"name","type":"string"}},"type":"object"},{"id":"developerPrivate.EventData","properties":{"event_type":{"name":"event_type","$ref":"developerPrivate.EventType"},"item_id":{"name":"item_id","type":"string"},"extensionInfo":{"optional":true,"name":"extensionInfo","$ref":"developerPrivate.ExtensionInfo"}},"type":"object"},{"id":"developerPrivate.ErrorFileSource","properties":{"beforeHighlight":{"name":"beforeHighlight","type":"string"},"highlight":{"name":"highlight","type":"string"},"afterHighlight":{"name":"afterHighlight","type":"string"}},"type":"object"},{"id":"developerPrivate.LoadError","properties":{"error":{"name":"error","type":"string"},"path":{"name":"path","type":"string"},"source":{"optional":true,"name":"source","$ref":"developerPrivate.ErrorFileSource"},"retryGuid":{"name":"retryGuid","type":"string"}},"type":"object"},{"id":"developerPrivate.RequestFileSourceProperties","properties":{"extensionId":{"name":"extensionId","type":"string"},"pathSuffix":{"name":"pathSuffix","type":"string"},"message":{"name":"message","type":"string"},"manifestKey":{"optional":true,"name":"manifestKey","type":"string"},"manifestSpecific":{"optional":true,"name":"manifestSpecific","type":"string"},"lineNumber":{"optional":true,"name":"lineNumber","type":"integer"}},"type":"object"},{"id":"developerPrivate.RequestFileSourceResponse","properties":{"highlight":{"name":"highlight","type":"string"},"beforeHighlight":{"name":"beforeHighlight","type":"string"},"afterHighlight":{"name":"afterHighlight","type":"string"},"title":{"name":"title","type":"string"},"message":{"name":"message","type":"string"}},"type":"object"},{"id":"developerPrivate.OpenDevToolsProperties","properties":{"extensionId":{"optional":true,"name":"extensionId","type":"string"},"renderViewId":{"name":"renderViewId","type":"integer"},"renderProcessId":{"name":"renderProcessId","type":"integer"},"isServiceWorker":{"optional":true,"name":"isServiceWorker","type":"boolean"},"incognito":{"optional":true,"name":"incognito","type":"boolean"},"url":{"optional":true,"name":"url","type":"string"},"lineNumber":{"optional":true,"name":"lineNumber","type":"integer"},"columnNumber":{"optional":true,"name":"columnNumber","type":"integer"}},"type":"object"},{"id":"developerPrivate.DeleteExtensionErrorsProperties","properties":{"extensionId":{"name":"extensionId","type":"string"},"errorIds":{"optional":true,"name":"errorIds","type":"array","items":{"type":"integer"}},"type":{"optional":true,"name":"type","$ref":"developerPrivate.ErrorType"}},"type":"object"}],"functions":[{"parameters":[],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"autoUpdate","type":"function"},{"parameters":[{"name":"options","optional":true,"$ref":"developerPrivate.GetExtensionsInfoOptions"}],"returns_async":{"name":"callback","optional":true,"parameters":[{"name":"result","type":"array","items":{"$ref":"developerPrivate.ExtensionInfo"}}]},"name":"getExtensionsInfo","type":"function"},{"parameters":[{"name":"id","type":"string"}],"returns_async":{"name":"callback","optional":true,"parameters":[{"name":"result","$ref":"developerPrivate.ExtensionInfo"}]},"name":"getExtensionInfo","type":"function"},{"parameters":[{"name":"id","type":"string"}],"returns_async":{"name":"callback","parameters":[{"name":"string","type":"string"}]},"name":"getExtensionSize","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"info","$ref":"developerPrivate.ProfileInfo"}]},"name":"getProfileConfiguration","type":"function"},{"parameters":[{"name":"update","$ref":"developerPrivate.ProfileConfigurationUpdate"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"updateProfileConfiguration","type":"function"},{"parameters":[{"name":"extensionId","type":"string"},{"name":"options","optional":true,"$ref":"developerPrivate.ReloadOptions"}],"returns_async":{"name":"callback","optional":true,"parameters":[{"name":"error","optional":true,"$ref":"developerPrivate.LoadError"}]},"name":"reload","type":"function"},{"parameters":[{"name":"update","$ref":"developerPrivate.ExtensionConfigurationUpdate"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"updateExtensionConfiguration","type":"function"},{"parameters":[{"name":"options","optional":true,"$ref":"developerPrivate.LoadUnpackedOptions"}],"returns_async":{"name":"callback","optional":true,"parameters":[{"name":"error","optional":true,"$ref":"developerPrivate.LoadError"}]},"name":"loadUnpacked","type":"function"},{"parameters":[],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"installDroppedFile","type":"function"},{"parameters":[],"name":"notifyDragInstallInProgress","type":"function"},{"parameters":[{"name":"directory","type":"object","additionalProperties":{"type":"any"},"isInstanceOf":"DirectoryEntry"}],"returns_async":{"name":"callback","parameters":[{"name":"string","type":"string"}]},"name":"loadDirectory","type":"function"},{"parameters":[{"name":"selectType","$ref":"developerPrivate.SelectType"},{"name":"fileType","$ref":"developerPrivate.FileType"}],"returns_async":{"name":"callback","parameters":[{"name":"string","type":"string"}]},"name":"choosePath","type":"function"},{"parameters":[{"name":"path","type":"string"},{"name":"privateKeyPath","optional":true,"type":"string"},{"name":"flags","optional":true,"type":"integer"}],"returns_async":{"name":"callback","optional":true,"parameters":[{"name":"response","$ref":"developerPrivate.PackDirectoryResponse"}]},"name":"packDirectory","type":"function"},{"parameters":[{"name":"properties","$ref":"developerPrivate.RequestFileSourceProperties"}],"returns_async":{"name":"callback","parameters":[{"name":"response","$ref":"developerPrivate.RequestFileSourceResponse"}]},"name":"requestFileSource","type":"function"},{"parameters":[{"name":"properties","$ref":"developerPrivate.OpenDevToolsProperties"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"openDevTools","type":"function"},{"parameters":[{"name":"properties","$ref":"developerPrivate.DeleteExtensionErrorsProperties"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"deleteExtensionErrors","type":"function"},{"parameters":[{"name":"extensionId","type":"string"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"repairExtension","type":"function"},{"parameters":[{"name":"extensionId","type":"string"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"showOptions","type":"function"},{"parameters":[{"name":"extensionId","type":"string"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"showPath","type":"function"},{"parameters":[{"name":"isSuspended","type":"boolean"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"setShortcutHandlingSuspended","type":"function"},{"parameters":[{"name":"update","$ref":"developerPrivate.ExtensionCommandUpdate"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"updateExtensionCommand","type":"function"},{"parameters":[{"name":"extensionId","type":"string"},{"name":"host","type":"string"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"addHostPermission","type":"function"},{"parameters":[{"name":"extensionId","type":"string"},{"name":"host","type":"string"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"removeHostPermission","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"settings","$ref":"developerPrivate.UserSiteSettings"}]},"name":"getUserSiteSettings","type":"function"},{"parameters":[{"name":"options","$ref":"developerPrivate.UserSiteSettingsOptions"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"addUserSpecifiedSites","type":"function"},{"parameters":[{"name":"options","$ref":"developerPrivate.UserSiteSettingsOptions"}],"re)R" R"R(turns_async":{"name":"callback","optional":true,"parameters":[]},"name":"removeUserSpecifiedSites","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"siteGroups","type":"array","items":{"$ref":"developerPrivate.SiteGroup"}}]},"name":"getUserAndExtensionSitesByEtld","type":"function"},{"parameters":[{"name":"site","type":"string"}],"returns_async":{"name":"callback","parameters":[{"name":"matchingExtensions","type":"array","items":{"$ref":"developerPrivate.MatchingExtensionInfo"}}]},"name":"getMatchingExtensionsForSite","type":"function"},{"parameters":[{"name":"site","type":"string"},{"name":"updates","type":"array","items":{"$ref":"developerPrivate.ExtensionSiteAccessUpdate"}}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"updateSiteAccess","type":"function"},{"parameters":[{"name":"extensionIds","type":"array","items":{"type":"string"}}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"removeMultipleExtensions","type":"function"},{"parameters":[],"name":"dismissSafetyHubExtensionsMenuNotification","type":"function"},{"parameters":[{"name":"extensionId","type":"string"}],"name":"dismissMv2DeprecationNoticeForExtension","type":"function"},{"parameters":[{"name":"extensionId","type":"string"}],"returns_async":{"name":"callback","parameters":[{"name":"result","type":"boolean"}]},"name":"uploadExtensionToAccount","type":"function"},{"platforms":["desktop_android"],"parameters":[{"name":"extensionId","type":"string"}],"name":"showSiteSettings","type":"function"},{"deprecated":"Use openDevTools","parameters":[{"name":"options","$ref":"developerPrivate.InspectOptions"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"inspect","type":"function"}],"properties":{},"events":[{"parameters":[{"name":"response","$ref":"developerPrivate.EventData"}],"name":"onItemStateChanged","type":"function"},{"parameters":[{"name":"info","$ref":"developerPrivate.ProfileInfo"}],"name":"onProfileStateChanged","type":"function"},{"parameters":[{"name":"settings","$ref":"developerPrivate.UserSiteSettings"}],"name":"onUserSiteSettingsChanged","type":"function"}],"platforms":null,"deprecated":null})R";
constexpr char kDownloads[] = R"R({"namespace":"downloads","types":[{"id":"downloads.HeaderNameValuePair","properties":{"name":{"name":"name","type":"string"},"value":{"name":"value","type":"string"}},"type":"object"},{"id":"downloads.FilenameConflictAction","type":"string","enum":[{"name":"uniquify"},{"name":"overwrite"},{"name":"prompt"}]},{"id":"downloads.FilenameSuggestion","properties":{"filename":{"name":"filename","type":"string"},"conflictAction":{"optional":true,"name":"conflictAction","$ref":"downloads.FilenameConflictAction"}},"type":"object"},{"id":"downloads.HttpMethod","type":"string","enum":[{"name":"GET"},{"name":"POST"}]},{"id":"downloads.InterruptReason","type":"string","enum":[{"name":"FILE_FAILED"},{"name":"FILE_ACCESS_DENIED"},{"name":"FILE_NO_SPACE"},{"name":"FILE_NAME_TOO_LONG"},{"name":"FILE_TOO_LARGE"},{"name":"FILE_VIRUS_INFECTED"},{"name":"FILE_TRANSIENT_ERROR"},{"name":"FILE_BLOCKED"},{"name":"FILE_SECURITY_CHECK_FAILED"},{"name":"FILE_TOO_SHORT"},{"name":"FILE_HASH_MISMATCH"},{"name":"FILE_SAME_AS_SOURCE"},{"name":"NETWORK_FAILED"},{"name":"NETWORK_TIMEOUT"},{"name":"NETWORK_DISCONNECTED"},{"name":"NETWORK_SERVER_DOWN"},{"name":"NETWORK_INVALID_REQUEST"},{"name":"SERVER_FAILED"},{"name":"SERVER_NO_RANGE"},{"name":"SERVER_BAD_CONTENT"},{"name":"SERVER_UNAUTHORIZED"},{"name":"SERVER_CERT_PROBLEM"},{"name":"SERVER_FORBIDDEN"},{"name":"SERVER_UNREACHABLE"},{"name":"SERVER_CONTENT_LENGTH_MISMATCH"},{"name":"SERVER_CROSS_ORIGIN_REDIRECT"},{"name":"USER_CANCELED"},{"name":"USER_SHUTDOWN"},{"name":"CRASH"}]},{"id":"downloads.DownloadOptions","properties":{"url":{"name":"url","type":"string"},"filename":{"optional":true,"name":"filename","type":"string"},"conflictAction":{"optional":true,"name":"conflictAction","$ref":"downloads.FilenameConflictAction"},"saveAs":{"optional":true,"name":"saveAs","type":"boolean"},"method":{"optional":true,"name":"method","$ref":"downloads.HttpMethod"},"headers":{"optional":true,"name":"headers","type":"array","items":{"$ref":"downloads.HeaderNameValuePair"}},"body":{"optional":true,"name":"body","type":"string"}},"type":"object"},{"id":"downloads.DangerType","type":"string","enum":[{"name":"file"},{"name":"url"},{"name":"content"},{"name":"uncommon"},{"name":"host"},{"name":"unwanted"},{"name":"safe"},{"name":"accepted"},{"name":"allowlistedByPolicy"},{"name":"asyncScanning"},{"name":"asyncLocalPasswordScanning"},{"name":"passwordProtected"},{"name":"blockedTooLarge"},{"name":"sensitiveContentWarning"},{"name":"sensitiveContentBlock"},{"name":"deepScannedFailed"},{"name":"deepScannedSafe"},{"name":"deepScannedOpenedDangerous"},{"name":"promptForScanning"},{"name":"promptForLocalPasswordScanning"},{"name":"accountCompromise"},{"name":"blockedScanFailed"}]},{"id":"downloads.State","type":"string","enum":[{"name":"in_progress"},{"name":"interrupted"},{"name":"complete"}]},{"id":"downloads.DownloadItem","properties":{"id":{"name":"id","type":"integer"},"url":{"name":"url","type":"string"},"finalUrl":{"name":"finalUrl","type":"string"},"referrer":{"name":"referrer","type":"string"},"filename":{"name":"filename","type":"string"},"incognito":{"name":"incognito","type":"boolean"},"danger":{"name":"danger","$ref":"downloads.DangerType"},"mime":{"name":"mime","type":"string"},"startTime":{"name":"startTime","type":"string"},"endTime":{"optional":true,"name":"endTime","type":"string"},"estimatedEndTime":{"optional":true,"name":"estimatedEndTime","type":"string"},"state":{"name":"state","$ref":"downloads.State"},"paused":{"name":"paused","type":"boolean"},"canResume":{"name":"canResume","type":"boolean"},"error":{"optional":true,"name":"error","$ref":"downloads.InterruptReason"},"bytesReceived":{"name":"bytesReceived","type":"number"},"totalBytes":{"name":"totalBytes","type":"number"},"fileSize":{"name":"fileSize","type":"number"},"exists":{"name":"exists","type":"boolean"},"byExtensionId":{"optional":true,"name":"byExtensionId","type":"string"},"byExtensionName":{"optional":true,"name":"byExtensionName","type":"string"}},"type":"object"},{"id":"downloads.DownloadQuery","properties":{"query":{"optional":true,"name":"query","type":"array","items":{"type":"string"}},"startedBefore":{"optional":true,"name":"startedBefore","type":"string"},"startedAfter":{"optional":true,"name":"startedAfter","type":"string"},"endedBefore":{"optional":true,"name":"endedBefore","type":"string"},"endedAfter":{"optional":true,"name":"endedAfter","type":"string"},"totalBytesGreater":{"optional":true,"name":"totalBytesGreater","type":"number"},"totalBytesLess":{"optional":true,"name":"totalBytesLess","type":"number"},"filenameRegex":{"optional":true,"name":"filenameRegex","type":"string"},"urlRegex":{"optional":true,"name":"urlRegex","type":"string"},"finalUrlRegex":{"optional":true,"name":"finalUrlRegex","type":"string"},"limit":{"optional":true,"name":"limit","type":"integer"},"orderBy":{"optional":true,"name":"orderBy","type":"array","items":{"type":"string"}},"id":{"optional":true,"name":"id","type":"integer"},"url":{"optional":true,"name":"url","type":"string"},"finalUrl":{"optional":true,"name":"finalUrl","type":"string"},"filename":{"optional":true,"name":"filename","type":"string"},"danger":{"optional":true,"name":"danger","$ref":"downloads.DangerType"},"mime":{"optional":true,"name":"mime","type":"string"},"startTime":{"optional":true,"name":"startTime","type":"string"},"endTime":{"optional":true,"name":"endTime","type":"string"},"state":{"optional":true,"name":"state","$ref":"downloads.State"},"paused":{"optional":true,"name":"paused","type":"boolean"},"error":{"optional":true,"name":"error","$ref":"downloads.InterruptReason"},"bytesReceived":{"optional":true,"name":"bytesReceived","type":"number"},"totalBytes":{"optional":true,"name":"totalBytes","type":"number"},"fileSize":{"optional":true,"name":"fileSize","type":"number"},"exists":{"optional":true,"name":"exists","type":"boolean"}},"type":"object"},{"id":"downloads.StringDelta","properties":{"previous":{"optional":true,"name":"previous","type":"string"},"current":{"optional":true,"name":"current","type":"string"}},"type":"object"},{"id":"downloads.DoubleDelta","properties":{"previous":{"optional":true,"name":"previous","type":"number"},"current":{"optional":true,"name":"current","type":"number"}},"type":"object"},{"id":"downloads.BooleanDelta","properties":{"previous":{"optional":true,"name":"previous","type":"boolean"},"current":{"optional":true,"name":"current","type":"boolean"}},"type":"object"},{"id":"downloads.DownloadDelta","properties":{"id":{"name":"id","type":"integer"},"url":{"optional":true,"name":"url","$ref":"downloads.StringDelta"},"finalUrl":{"optional":true,"name":"finalUrl","$ref":"downloads.StringDelta"},"filename":{"optional":true,"name":"filename","$ref":"downloads.StringDelta"},"danger":{"optional":true,"name":"danger","$ref":"downloads.StringDelta"},"mime":{"optional":true,"name":"mime","$ref":"downloads.StringDelta"},"startTime":{"optional":true,"name":"startTime","$ref":"downloads.StringDelta"},"endTime":{"optional":true,"name":"endTime","$ref":"downloads.StringDelta"},"state":{"optional":true,"name":"state","$ref":"downloads.StringDelta"},"canResume":{"optional":true,"name":"canResume","$ref":"downloads.BooleanDelta"},"paused":{"optional":true,"name":"paused","$ref":"downloads.BooleanDelta"},"error":{"optional":true,"name":"error","$ref":"downloads.StringDelta"},"totalBytes":{"optional":true,"name":"totalBytes","$ref":"downloads.DoubleDelta"},"fileSize":{"optional":true,"name":"fileSize","$ref":"downloads.DoubleDelta"},"exists":{"optional":true,"name":"exists","$ref":"downloads.BooleanDelta"}},"type":"object"},{"id":"downloads.GetFileIconOptions","properties":{"size":{"optional":true,"name":"size","type":"integer"}},"type":"object"},{"id":"downloads.UiOptions","properties":{"enabled":{"name":"enabled","type":"boolean"}},"type":"object"}],"functions":[{"parameters":[{"name":"options","$ref":"downloads.DownloadOptions"}],"returns_async":{"name":"callback","optional":true,"parameters":[{"name":"downloadId","type":"integer"}]},"name":"download","type":"function"},{"parameters":[{"name":"query","$ref":"downloads.DownloadQuery"}],"returns_async":{"name":"callback","paramet)R" R"R(ers":[{"name":"results","type":"array","items":{"$ref":"downloads.DownloadItem"}}]},"name":"search","type":"function"},{"parameters":[{"name":"downloadId","type":"integer"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"pause","type":"function"},{"parameters":[{"name":"downloadId","type":"integer"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"resume","type":"function"},{"parameters":[{"name":"downloadId","type":"integer"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"cancel","type":"function"},{"parameters":[{"name":"downloadId","type":"integer"},{"name":"options","optional":true,"$ref":"downloads.GetFileIconOptions"}],"returns_async":{"name":"callback","parameters":[{"name":"iconURL","optional":true,"type":"string"}]},"name":"getFileIcon","type":"function"},{"parameters":[{"name":"downloadId","type":"integer"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"open","type":"function"},{"parameters":[{"name":"downloadId","type":"integer"}],"name":"show","type":"function"},{"parameters":[],"name":"showDefaultFolder","type":"function"},{"parameters":[{"name":"query","$ref":"downloads.DownloadQuery"}],"returns_async":{"name":"callback","optional":true,"parameters":[{"name":"erasedIds","type":"array","items":{"type":"integer"}}]},"name":"erase","type":"function"},{"parameters":[{"name":"downloadId","type":"integer"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"removeFile","type":"function"},{"parameters":[{"name":"downloadId","type":"integer"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"acceptDanger","type":"function"},{"deprecated":"Use $(ref:setUiOptions) instead.","parameters":[{"name":"enabled","type":"boolean"}],"name":"setShelfEnabled","type":"function"},{"parameters":[{"name":"options","$ref":"downloads.UiOptions"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"setUiOptions","type":"function"}],"properties":{},"events":[{"parameters":[{"name":"downloadItem","$ref":"downloads.DownloadItem"}],"name":"onCreated","type":"function"},{"parameters":[{"name":"downloadId","type":"integer"}],"name":"onErased","type":"function"},{"parameters":[{"name":"downloadDelta","$ref":"downloads.DownloadDelta"}],"name":"onChanged","type":"function"},{"options":{"maxListeners":1},"parameters":[{"name":"downloadItem","$ref":"downloads.DownloadItem"},{"name":"suggest","parameters":[{"name":"suggestion","optional":true,"$ref":"downloads.FilenameSuggestion"}],"type":"function"}],"name":"onDeterminingFilename","type":"function"}],"platforms":null,"deprecated":null})R";
constexpr char kDownloadsInternal[] = R"R({"namespace":"downloadsInternal","types":[],"functions":[{"parameters":[{"name":"downloadId","type":"integer"},{"name":"filename","type":"string"},{"name":"conflict_action","type":"string"}],"name":"determineFilename","type":"function"}],"properties":{},"events":[],"platforms":null,"deprecated":null})R";
constexpr char kEnterpriseHardwarePlatform[] = R"R({"namespace":"enterprise.hardwarePlatform","types":[{"id":"enterprise.hardwarePlatform.HardwarePlatformInfo","properties":{"model":{"name":"model","type":"string"},"manufacturer":{"name":"manufacturer","type":"string"}},"type":"object"}],"functions":[{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"info","$ref":"enterprise.hardwarePlatform.HardwarePlatformInfo"}]},"name":"getHardwarePlatformInfo","type":"function"}],"properties":{},"events":[],"platforms":null,"deprecated":null})R";
constexpr char kFontSettings[] = R"R({"namespace":"fontSettings","types":[{"id":"fontSettings.FontName","type":"object","properties":{"fontId":{"type":"string"},"displayName":{"type":"string"}}},{"id":"fontSettings.ScriptCode","type":"string","enum":["Afak","Arab","Armi","Armn","Avst","Bali","Bamu","Bass","Batk","Beng","Blis","Bopo","Brah","Brai","Bugi","Buhd","Cakm","Cans","Cari","Cham","Cher","Cirt","Copt","Cprt","Cyrl","Cyrs","Deva","Dsrt","Dupl","Egyd","Egyh","Egyp","Elba","Ethi","Geor","Geok","Glag","Goth","Gran","Grek","Gujr","Guru","Hang","Hani","Hano","Hans","Hant","Hebr","Hluw","Hmng","Hung","Inds","Ital","Java","Jpan","Jurc","Kali","Khar","Khmr","Khoj","Knda","Kpel","Kthi","Lana","Laoo","Latf","Latg","Latn","Lepc","Limb","Lina","Linb","Lisu","Loma","Lyci","Lydi","Mand","Mani","Maya","Mend","Merc","Mero","Mlym","Moon","Mong","Mroo","Mtei","Mymr","Narb","Nbat","Nkgb","Nkoo","Nshu","Ogam","Olck","Orkh","Orya","Osma","Palm","Perm","Phag","Phli","Phlp","Phlv","Phnx","Plrd","Prti","Rjng","Roro","Runr","Samr","Sara","Sarb","Saur","Sgnw","Shaw","Shrd","Sind","Sinh","Sora","Sund","Sylo","Syrc","Syre","Syrj","Syrn","Tagb","Takr","Tale","Talu","Taml","Tang","Tavt","Telu","Teng","Tfng","Tglg","Thaa","Thai","Tibt","Tirh","Ugar","Vaii","Visp","Wara","Wole","Xpeo","Xsux","Yiii","Zmth","Zsym","Zyyy"]},{"id":"fontSettings.GenericFamily","type":"string","enum":["standard","sansserif","serif","fixed","cursive","fantasy","math"]},{"id":"fontSettings.LevelOfControl","type":"string","enum":["not_controllable","controlled_by_other_extensions","controllable_by_this_extension","controlled_by_this_extension"]}],"functions":[{"name":"clearFont","parameters":[{"name":"details","type":"object","properties":{"script":{"$ref":"fontSettings.ScriptCode","optional":true},"genericFamily":{"$ref":"fontSettings.GenericFamily"}}}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"getFont","parameters":[{"name":"details","type":"object","properties":{"script":{"$ref":"fontSettings.ScriptCode","optional":true},"genericFamily":{"$ref":"fontSettings.GenericFamily"}}}],"returns_async":{"name":"callback","optional":true,"parameters":[{"name":"details","type":"object","properties":{"fontId":{"type":"string"},"levelOfControl":{"$ref":"fontSettings.LevelOfControl"}}}]}},{"name":"setFont","parameters":[{"name":"details","type":"object","properties":{"script":{"$ref":"fontSettings.ScriptCode","optional":true},"genericFamily":{"$ref":"fontSettings.GenericFamily"},"fontId":{"type":"string"}}}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"getFontList","parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"results","type":"array","items":{"$ref":"fontSettings.FontName"}}]}},{"name":"clearDefaultFontSize","parameters":[{"name":"details","type":"object","optional":true,"properties":{}}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"getDefaultFontSize","parameters":[{"name":"details","type":"object","optional":true,"properties":{}}],"returns_async":{"name":"callback","optional":true,"parameters":[{"name":"details","type":"object","properties":{"pixelSize":{"type":"integer"},"levelOfControl":{"$ref":"fontSettings.LevelOfControl"}}}]}},{"name":"setDefaultFontSize","parameters":[{"name":"details","type":"object","properties":{"pixelSize":{"type":"integer"}}}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"clearDefaultFixedFontSize","parameters":[{"name":"details","type":"object","optional":true,"properties":{}}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"getDefaultFixedFontSize","parameters":[{"name":"details","type":"object","optional":true,"properties":{}}],"returns_async":{"name":"callback","optional":true,"parameters":[{"name":"details","type":"object","properties":{"pixelSize":{"type":"integer"},"levelOfControl":{"$ref":"fontSettings.LevelOfControl"}}}]}},{"name":"setDefaultFixedFontSize","parameters":[{"name":"details","type":"object","properties":{"pixelSize":{"type":"integer"}}}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"clearMinimumFontSize","parameters":[{"name":"details","type":"object","optional":true,"properties":{}}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"getMinimumFontSize","parameters":[{"name":"details","type":"object","optional":true,"properties":{}}],"returns_async":{"name":"callback","optional":true,"parameters":[{"name":"details","type":"object","properties":{"pixelSize":{"type":"integer"},"levelOfControl":{"$ref":"fontSettings.LevelOfControl"}}}]}},{"name":"setMinimumFontSize","parameters":[{"name":"details","type":"object","properties":{"pixelSize":{"type":"integer"}}}],"returns_async":{"name":"callback","optional":true,"parameters":[]}}],"events":[{"name":"onFontChanged","parameters":[{"type":"object","name":"details","properties":{"fontId":{"type":"string"},"script":{"$ref":"fontSettings.ScriptCode","optional":true},"genericFamily":{"$ref":"fontSettings.GenericFamily"},"levelOfControl":{"$ref":"fontSettings.LevelOfControl"}}}]},{"name":"onDefaultFontSizeChanged","parameters":[{"type":"object","name":"details","properties":{"pixelSize":{"type":"integer"},"levelOfControl":{"$ref":"fontSettings.LevelOfControl"}}}]},{"name":"onDefaultFixedFontSizeChanged","parameters":[{"type":"object","name":"details","properties":{"pixelSize":{"type":"integer"},"levelOfControl":{"$ref":"fontSettings.LevelOfControl"}}}]},{"name":"onMinimumFontSizeChanged","parameters":[{"type":"object","name":"details","properties":{"pixelSize":{"type":"integer"},"levelOfControl":{"$ref":"fontSettings.LevelOfControl"}}}]}]})R";
constexpr char kGcm[] = R"R({"namespace":"gcm","properties":{"MAX_MESSAGE_SIZE":{"value":4096,"type":"integer"}},"functions":[{"name":"register","type":"function","parameters":[{"name":"senderIds","type":"array","items":{"type":"string","minLength":1},"minItems":1,"maxItems":100}],"returns_async":{"name":"callback","parameters":[{"name":"registrationId","type":"string"}]}},{"name":"unregister","type":"function","parameters":[],"returns_async":{"name":"callback","parameters":[]}},{"name":"send","type":"function","parameters":[{"name":"message","type":"object","properties":{"destinationId":{"type":"string","minLength":1},"messageId":{"type":"string","minLength":1},"timeToLive":{"type":"integer","minimum":0,"maximum":86400,"optional":true},"data":{"type":"object","properties":{},"additionalProperties":{"type":"string","minLength":1}}}}],"returns_async":{"name":"callback","parameters":[{"name":"messageId","type":"string"}]}}],"events":[{"name":"onMessage","type":"function","parameters":[{"name":"message","type":"object","properties":{"data":{"type":"object","properties":{},"additionalProperties":{"type":"string"}},"from":{"type":"string","optional":true},"collapseKey":{"type":"string","optional":true}}}]},{"name":"onMessagesDeleted","type":"function"},{"name":"onSendError","type":"function","parameters":[{"name":"error","type":"object","properties":{"errorMessage":{"type":"string"},"messageId":{"type":"string","optional":true},"details":{"type":"object","properties":{},"additionalProperties":{"type":"string"}}}}]}]})R";
constexpr char kHistory[] = R"R({"namespace":"history","types":[{"id":"history.TransitionType","type":"string","enum":[{"name":"link"},{"name":"typed"},{"name":"auto_bookmark"},{"name":"auto_subframe"},{"name":"manual_subframe"},{"name":"generated"},{"name":"auto_toplevel"},{"name":"form_submit"},{"name":"reload"},{"name":"keyword"},{"name":"keyword_generated"}]},{"id":"history.HistoryItem","type":"object","properties":{"id":{"type":"string","minimum":0},"url":{"type":"string","optional":true},"title":{"type":"string","optional":true},"lastVisitTime":{"type":"number","optional":true},"visitCount":{"type":"integer","optional":true},"typedCount":{"type":"integer","optional":true}}},{"id":"history.VisitItem","type":"object","properties":{"id":{"type":"string","minimum":0},"visitId":{"type":"string"},"visitTime":{"type":"number","optional":true},"referringVisitId":{"type":"string"},"transition":{"$ref":"history.TransitionType"},"isLocal":{"type":"boolean"}}},{"id":"history.UrlDetails","type":"object","properties":{"url":{"type":"string"}}}],"functions":[{"name":"search","type":"function","parameters":[{"name":"query","type":"object","properties":{"text":{"type":"string"},"startTime":{"type":"number","optional":true},"endTime":{"type":"number","optional":true},"maxResults":{"type":"integer","optional":true,"minimum":0}}}],"returns_async":{"name":"callback","parameters":[{"name":"results","type":"array","items":{"$ref":"history.HistoryItem"}}]}},{"name":"getVisits","type":"function","parameters":[{"name":"details","$ref":"history.UrlDetails"}],"returns_async":{"name":"callback","parameters":[{"name":"results","type":"array","items":{"$ref":"history.VisitItem"}}]}},{"name":"addUrl","type":"function","parameters":[{"name":"details","$ref":"history.UrlDetails"}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"deleteUrl","type":"function","parameters":[{"name":"details","$ref":"history.UrlDetails"}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"deleteRange","type":"function","parameters":[{"name":"range","type":"object","properties":{"startTime":{"type":"number"},"endTime":{"type":"number"}}}],"returns_async":{"name":"callback","parameters":[]}},{"name":"deleteAll","type":"function","parameters":[],"returns_async":{"name":"callback","parameters":[]}}],"events":[{"name":"onVisited","type":"function","parameters":[{"name":"result","$ref":"history.HistoryItem"}]},{"name":"onVisitRemoved","type":"function","parameters":[{"name":"removed","type":"object","properties":{"allHistory":{"type":"boolean"},"urls":{"type":"array","items":{"type":"string"},"optional":true}}}]}]})R";
constexpr char kIdentity[] = R"R({"namespace":"identity","types":[{"id":"identity.AccountInfo","properties":{"id":{"name":"id","type":"string"}},"type":"object"},{"id":"identity.AccountStatus","type":"string","enum":[{"name":"SYNC"},{"name":"ANY"}]},{"id":"identity.ProfileDetails","properties":{"accountStatus":{"optional":true,"name":"accountStatus","$ref":"identity.AccountStatus"}},"type":"object"},{"id":"identity.ProfileUserInfo","properties":{"email":{"name":"email","type":"string"},"id":{"name":"id","type":"string"}},"type":"object"},{"id":"identity.TokenDetails","properties":{"interactive":{"optional":true,"name":"interactive","type":"boolean"},"account":{"optional":true,"name":"account","$ref":"identity.AccountInfo"},"scopes":{"optional":true,"name":"scopes","type":"array","items":{"type":"string"}},"enableGranularPermissions":{"optional":true,"name":"enableGranularPermissions","type":"boolean"}},"type":"object"},{"id":"identity.InvalidTokenDetails","properties":{"token":{"name":"token","type":"string"}},"type":"object"},{"id":"identity.WebAuthFlowDetails","properties":{"url":{"name":"url","type":"string"},"interactive":{"optional":true,"name":"interactive","type":"boolean"},"abortOnLoadForNonInteractive":{"optional":true,"name":"abortOnLoadForNonInteractive","type":"boolean"},"timeoutMsForNonInteractive":{"optional":true,"name":"timeoutMsForNonInteractive","type":"integer"}},"type":"object"},{"id":"identity.GetAuthTokenResult","properties":{"token":{"optional":true,"name":"token","type":"string"},"grantedScopes":{"optional":true,"name":"grantedScopes","type":"array","items":{"type":"string"}}},"type":"object"}],"functions":[{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"accounts","type":"array","items":{"$ref":"identity.AccountInfo"}}]},"name":"getAccounts","type":"function"},{"parameters":[{"name":"details","optional":true,"$ref":"identity.TokenDetails"}],"returns_async":{"name":"callback","optional":true,"parameters":[{"name":"result","$ref":"identity.GetAuthTokenResult"}]},"name":"getAuthToken","type":"function"},{"parameters":[{"name":"details","optional":true,"$ref":"identity.ProfileDetails"}],"returns_async":{"name":"callback","parameters":[{"name":"userInfo","$ref":"identity.ProfileUserInfo"}]},"name":"getProfileUserInfo","type":"function"},{"parameters":[{"name":"details","$ref":"identity.InvalidTokenDetails"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"removeCachedAuthToken","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[]},"name":"clearAllCachedAuthTokens","type":"function"},{"parameters":[{"name":"details","$ref":"identity.WebAuthFlowDetails"}],"returns_async":{"name":"callback","parameters":[{"name":"responseUrl","optional":true,"type":"string"}]},"name":"launchWebAuthFlow","type":"function"},{"parameters":[{"name":"path","optional":true,"type":"string"}],"returns":{"name":"getRedirectURL","type":"string"},"name":"getRedirectURL","type":"function"}],"properties":{},"events":[{"parameters":[{"name":"account","$ref":"identity.AccountInfo"},{"name":"signedIn","type":"boolean"}],"name":"onSignInChanged","type":"function"}],"platforms":null,"deprecated":null})R";
constexpr char kInstanceID[] = R"R({"namespace":"instanceID","functions":[{"name":"getID","type":"function","parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"instanceID","type":"string"}]}},{"name":"getCreationTime","type":"function","parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"creationTime","type":"number"}]}},{"name":"getToken","type":"function","parameters":[{"name":"getTokenParams","type":"object","properties":{"authorizedEntity":{"type":"string","minLength":1},"scope":{"type":"string","minLength":1},"options":{"deprecated":"options are deprecated and will be ignored.","type":"object","properties":{},"additionalProperties":{"type":"string","minLength":1},"optional":true}}}],"returns_async":{"name":"callback","parameters":[{"name":"token","type":"string"}]}},{"name":"deleteToken","type":"function","parameters":[{"name":"deleteTokenParams","type":"object","properties":{"authorizedEntity":{"type":"string","minLength":1},"scope":{"type":"string","minLength":1}}}],"returns_async":{"name":"callback","parameters":[]}},{"name":"deleteID","type":"function","parameters":[],"returns_async":{"name":"callback","parameters":[]}}],"events":[{"name":"onTokenRefresh","type":"function"}]})R";
constexpr char kNotifications[] = R"R({"namespace":"notifications","types":[{"id":"notifications.TemplateType","type":"string","enum":[{"name":"basic"},{"name":"image"},{"name":"list"},{"name":"progress"}]},{"id":"notifications.PermissionLevel","type":"string","enum":[{"name":"granted"},{"name":"denied"}]},{"id":"notifications.NotificationItem","properties":{"title":{"name":"title","type":"string"},"message":{"name":"message","type":"string"}},"type":"object"},{"id":"notifications.NotificationBitmap","properties":{"width":{"name":"width","type":"integer"},"height":{"name":"height","type":"integer"},"data":{"optional":true,"name":"data","type":"binary","isInstanceOf":"ArrayBuffer"}},"type":"object"},{"id":"notifications.NotificationButton","properties":{"title":{"name":"title","type":"string"},"iconUrl":{"deprecated":"Button icons not visible for Mac OS X users.","optional":true,"name":"iconUrl","type":"string"},"iconBitmap":{"optional":true,"name":"iconBitmap","$ref":"notifications.NotificationBitmap"}},"type":"object"},{"id":"notifications.NotificationOptions","properties":{"type":{"optional":true,"name":"type","$ref":"notifications.TemplateType"},"iconUrl":{"optional":true,"name":"iconUrl","type":"string"},"iconBitmap":{"optional":true,"name":"iconBitmap","$ref":"notifications.NotificationBitmap"},"appIconMaskUrl":{"deprecated":"The app icon mask is not visible for Mac OS X users.","optional":true,"name":"appIconMaskUrl","type":"string"},"appIconMaskBitmap":{"optional":true,"name":"appIconMaskBitmap","$ref":"notifications.NotificationBitmap"},"title":{"optional":true,"name":"title","type":"string"},"message":{"optional":true,"name":"message","type":"string"},"contextMessage":{"optional":true,"name":"contextMessage","type":"string"},"priority":{"optional":true,"name":"priority","type":"integer"},"eventTime":{"optional":true,"name":"eventTime","type":"number"},"buttons":{"optional":true,"name":"buttons","type":"array","items":{"$ref":"notifications.NotificationButton"}},"expandedMessage":{"optional":true,"name":"expandedMessage","type":"string"},"imageUrl":{"deprecated":"The image is not visible for Mac OS X users.","optional":true,"name":"imageUrl","type":"string"},"imageBitmap":{"optional":true,"name":"imageBitmap","$ref":"notifications.NotificationBitmap"},"items":{"optional":true,"name":"items","type":"array","items":{"$ref":"notifications.NotificationItem"}},"progress":{"optional":true,"name":"progress","type":"integer"},"isClickable":{"deprecated":"This UI hint is ignored as of Chrome 67","optional":true,"name":"isClickable","type":"boolean"},"requireInteraction":{"optional":true,"name":"requireInteraction","type":"boolean"},"silent":{"optional":true,"name":"silent","type":"boolean"}},"type":"object"}],"functions":[{"parameters":[{"name":"notificationId","optional":true,"type":"string"},{"name":"options","$ref":"notifications.NotificationOptions"}],"returns_async":{"name":"callback","optional":true,"parameters":[{"name":"notificationId","type":"string"}]},"name":"create","type":"function"},{"parameters":[{"name":"notificationId","type":"string"},{"name":"options","$ref":"notifications.NotificationOptions"}],"returns_async":{"name":"callback","optional":true,"parameters":[{"name":"wasUpdated","type":"boolean"}]},"name":"update","type":"function"},{"parameters":[{"name":"notificationId","type":"string"}],"returns_async":{"name":"callback","optional":true,"parameters":[{"name":"wasCleared","type":"boolean"}]},"name":"clear","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"notifications","type":"object","additionalProperties":{"type":"any"}}]},"name":"getAll","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"level","$ref":"notifications.PermissionLevel"}]},"name":"getPermissionLevel","type":"function"}],"properties":{},"events":[{"parameters":[{"name":"notificationId","type":"string"},{"name":"byUser","type":"boolean"}],"name":"onClosed","type":"function"},{"parameters":[{"name":"notificationId","type":"string"}],"name":"onClicked","type":"function"},{"parameters":[{"name":"notificationId","type":"string"},{"name":"buttonIndex","type":"integer"}],"name":"onButtonClicked","type":"function"},{"parameters":[{"name":"level","$ref":"notifications.PermissionLevel"}],"name":"onPermissionLevelChanged","type":"function"},{"deprecated":"Custom notification settings button is no longer supported.","parameters":[],"name":"onShowSettings","type":"function"}],"platforms":null,"deprecated":null})R";
constexpr char kOmnibox[] = R"R({"namespace":"omnibox","types":[{"id":"omnibox.DescriptionStyleType","type":"string","enum":["url","match","dim"]},{"id":"omnibox.OnInputEnteredDisposition","type":"string","enum":["currentTab","newForegroundTab","newBackgroundTab"]},{"id":"omnibox.MatchClassification","type":"object","properties":{"offset":{"type":"integer"},"type":{"$ref":"omnibox.DescriptionStyleType"},"length":{"type":"integer","optional":true}}},{"id":"omnibox.Action","type":"object","properties":{"name":{"type":"string","minLength":1},"label":{"type":"string","minLength":1},"tooltipText":{"type":"string","minLength":1},"icon":{"optional":true,"type":"object","additionalProperties":{"type":"any"}}}},{"id":"omnibox.SuggestResult","type":"object","properties":{"content":{"type":"string","minLength":1},"description":{"type":"string","minLength":1},"deletable":{"type":"boolean","optional":true},"descriptionStyles":{"optional":true,"type":"array","items":{"name":"matchClassification","$ref":"omnibox.MatchClassification"}},"actions":{"optional":true,"type":"array","items":{"$ref":"omnibox.Action"}},"iconUrl":{"optional":true,"type":"string"}}},{"id":"omnibox.DefaultSuggestResult","type":"object","properties":{"description":{"type":"string","minLength":1},"descriptionStyles":{"optional":true,"type":"array","items":{"name":"matchClassification","$ref":"omnibox.MatchClassification"}}}},{"id":"omnibox.ActionExecution","type":"object","properties":{"actionName":{"type":"string"},"content":{"type":"string"}}}],"functions":[{"name":"sendSuggestions","type":"function","parameters":[{"type":"integer","name":"requestId"},{"name":"suggestResults","type":"array","items":{"$ref":"omnibox.SuggestResult"}}]},{"name":"setDefaultSuggestion","type":"function","parameters":[{"name":"suggestion","$ref":"omnibox.DefaultSuggestResult"}],"returns_async":{"name":"callback","optional":true,"parameters":[]}}],"events":[{"name":"onInputStarted","type":"function","parameters":[]},{"name":"onInputChanged","type":"function","parameters":[{"type":"string","name":"text"},{"name":"suggest","type":"function","parameters":[{"name":"suggestResults","type":"array","items":{"$ref":"omnibox.SuggestResult"}}]}]},{"name":"onInputEntered","type":"function","parameters":[{"type":"string","name":"text"},{"name":"disposition","$ref":"omnibox.OnInputEnteredDisposition"}]},{"name":"onInputCancelled","type":"function","parameters":[]},{"name":"onDeleteSuggestion","type":"function","parameters":[{"type":"string","name":"text"}]},{"name":"onActionExecuted","type":"function","parameters":[{"name":"actionExecution","$ref":"omnibox.ActionExecution"}]}]})R";
constexpr char kPageCapture[] = R"R({"namespace":"pageCapture","functions":[{"name":"saveAsMHTML","type":"function","parameters":[{"name":"details","type":"object","properties":{"tabId":{"type":"integer","minimum":0}}}],"returns_async":{"name":"callback","parameters":[{"name":"mhtmlData","type":"object","isInstanceOf":"Blob","optional":true}]}}]})R";
constexpr char kPermissions[] = R"R({"namespace":"permissions","types":[{"id":"permissions.Permissions","type":"object","properties":{"permissions":{"type":"array","items":{"type":"string"},"optional":true},"origins":{"type":"array","items":{"type":"string"},"optional":true}}}],"events":[{"name":"onAdded","type":"function","parameters":[{"$ref":"permissions.Permissions","name":"permissions"}]},{"name":"onRemoved","type":"function","parameters":[{"$ref":"permissions.Permissions","name":"permissions"}]}],"functions":[{"name":"getAll","type":"function","parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"permissions","$ref":"permissions.Permissions"}]}},{"name":"contains","type":"function","parameters":[{"name":"permissions","$ref":"permissions.Permissions"}],"returns_async":{"name":"callback","parameters":[{"name":"result","type":"boolean"}]}},{"name":"request","type":"function","parameters":[{"name":"permissions","$ref":"permissions.Permissions"}],"returns_async":{"name":"callback","optional":true,"parameters":[{"name":"granted","type":"boolean"}]}},{"name":"remove","type":"function","parameters":[{"name":"permissions","$ref":"permissions.Permissions"}],"returns_async":{"name":"callback","optional":true,"parameters":[{"name":"removed","type":"boolean"}]}},{"name":"addHostAccessRequest","type":"function","parameters":[{"name":"request","type":"object","properties":{"documentId":{"type":"string","optional":true},"tabId":{"type":"number","optional":true},"pattern":{"type":"string","optional":true}}}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"removeHostAccessRequest","type":"function","parameters":[{"name":"request","type":"object","properties":{"documentId":{"type":"string","optional":true},"tabId":{"type":"number","optional":true},"pattern":{"type":"string","optional":true}}}],"returns_async":{"name":"callback","optional":true,"parameters":[]}}]})R";
constexpr char kProcesses[] = R"R({"namespace":"processes","types":[{"id":"processes.ProcessType","type":"string","enum":[{"name":"browser"},{"name":"renderer"},{"name":"extension"},{"name":"notification"},{"name":"plugin"},{"name":"worker"},{"name":"nacl"},{"name":"service_worker"},{"name":"utility"},{"name":"gpu"},{"name":"other"}]},{"id":"processes.TaskInfo","properties":{"title":{"name":"title","type":"string"},"tabId":{"optional":true,"name":"tabId","type":"integer"}},"type":"object"},{"id":"processes.Cache","properties":{"size":{"name":"size","type":"number"},"liveSize":{"name":"liveSize","type":"number"}},"type":"object"},{"id":"processes.Process","properties":{"id":{"name":"id","type":"integer"},"osProcessId":{"name":"osProcessId","type":"integer"},"type":{"name":"type","$ref":"processes.ProcessType"},"profile":{"name":"profile","type":"string"},"naclDebugPort":{"name":"naclDebugPort","type":"integer"},"tasks":{"name":"tasks","type":"array","items":{"$ref":"processes.TaskInfo"}},"cpu":{"optional":true,"name":"cpu","type":"number"},"network":{"optional":true,"name":"network","type":"number"},"privateMemory":{"optional":true,"name":"privateMemory","type":"number"},"jsMemoryAllocated":{"optional":true,"name":"jsMemoryAllocated","type":"number"},"jsMemoryUsed":{"optional":true,"name":"jsMemoryUsed","type":"number"},"sqliteMemory":{"optional":true,"name":"sqliteMemory","type":"number"},"imageCache":{"optional":true,"name":"imageCache","$ref":"processes.Cache"},"scriptCache":{"optional":true,"name":"scriptCache","$ref":"processes.Cache"},"cssCache":{"optional":true,"name":"cssCache","$ref":"processes.Cache"}},"type":"object"}],"functions":[{"parameters":[{"name":"tabId","type":"integer"}],"returns_async":{"name":"callback","parameters":[{"name":"processId","type":"integer"}]},"name":"getProcessIdForTab","type":"function"},{"parameters":[{"name":"processId","type":"integer"}],"returns_async":{"name":"callback","optional":true,"parameters":[{"name":"didTerminate","type":"boolean"}]},"name":"terminate","type":"function"},{"parameters":[{"name":"processIds","choices":[{"type":"integer"},{"type":"array","items":{"type":"integer"}}]},{"name":"includeMemory","type":"boolean"}],"returns_async":{"name":"callback","parameters":[{"name":"processes","type":"object","additionalProperties":{"type":"any"}}]},"name":"getProcessInfo","type":"function"}],"properties":{},"events":[{"parameters":[{"name":"processes","type":"object","additionalProperties":{"type":"any"}}],"name":"onUpdated","type":"function"},{"parameters":[{"name":"processes","type":"object","additionalProperties":{"type":"any"}}],"name":"onUpdatedWithMemory","type":"function"},{"parameters":[{"name":"process","$ref":"processes.Process"}],"name":"onCreated","type":"function"},{"parameters":[{"name":"process","$ref":"processes.Process"}],"name":"onUnresponsive","type":"function"},{"parameters":[{"name":"processId","type":"integer"},{"name":"exitType","type":"integer"},{"name":"exitCode","type":"integer"}],"name":"onExited","type":"function"}],"platforms":null,"deprecated":null})R";
constexpr char kReadingList[] = R"R({"namespace":"readingList","functions":[{"name":"addEntry","type":"function","parameters":[{"$ref":"readingList.AddEntryOptions","name":"entry"}],"returns_async":{"parameters":[],"name":"callback","optional":true}},{"name":"removeEntry","type":"function","parameters":[{"$ref":"readingList.RemoveOptions","name":"info"}],"returns_async":{"parameters":[],"name":"callback","optional":true}},{"name":"updateEntry","type":"function","parameters":[{"$ref":"readingList.UpdateEntryOptions","name":"info"}],"returns_async":{"parameters":[],"name":"callback","optional":true}},{"name":"query","type":"function","parameters":[{"$ref":"readingList.QueryInfo","name":"info"}],"returns_async":{"parameters":[{"type":"array","items":{"$ref":"readingList.ReadingListEntry"},"name":"entries"}],"name":"callback"}}],"types":[{"id":"readingList.ReadingListEntry","properties":{"url":{"type":"string","name":"url"},"title":{"type":"string","name":"title"},"hasBeenRead":{"type":"boolean","name":"hasBeenRead"},"lastUpdateTime":{"type":"number","name":"lastUpdateTime"},"creationTime":{"type":"number","name":"creationTime"}},"type":"object"},{"id":"readingList.AddEntryOptions","properties":{"url":{"type":"string","name":"url"},"title":{"type":"string","name":"title"},"hasBeenRead":{"type":"boolean","name":"hasBeenRead"}},"type":"object"},{"id":"readingList.RemoveOptions","properties":{"url":{"type":"string","name":"url"}},"type":"object"},{"id":"readingList.UpdateEntryOptions","properties":{"url":{"type":"string","name":"url"},"title":{"type":"string","name":"title","optional":true},"hasBeenRead":{"type":"boolean","name":"hasBeenRead","optional":true}},"type":"object"},{"id":"readingList.QueryInfo","properties":{"url":{"type":"string","name":"url","optional":true},"title":{"type":"string","name":"title","optional":true},"hasBeenRead":{"type":"boolean","name":"hasBeenRead","optional":true}},"type":"object"}],"events":[{"name":"onEntryAdded","type":"function","parameters":[{"$ref":"readingList.ReadingListEntry","name":"entry"}]},{"name":"onEntryRemoved","type":"function","parameters":[{"$ref":"readingList.ReadingListEntry","name":"entry"}]},{"name":"onEntryUpdated","type":"function","parameters":[{"$ref":"readingList.ReadingListEntry","name":"entry"}]}],"properties":{},"platforms":null,"deprecated":null})R";
constexpr char kSearch[] = R"R({"namespace":"search","types":[{"id":"search.Disposition","type":"string","enum":[{"name":"CURRENT_TAB"},{"name":"NEW_TAB"},{"name":"NEW_WINDOW"}]},{"id":"search.QueryInfo","properties":{"text":{"name":"text","type":"string"},"disposition":{"optional":true,"name":"disposition","$ref":"search.Disposition"},"tabId":{"optional":true,"name":"tabId","type":"integer"}},"type":"object"}],"functions":[{"parameters":[{"name":"queryInfo","$ref":"search.QueryInfo"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"query","type":"function"}],"properties":{},"events":[],"platforms":null,"deprecated":null})R";
constexpr char kScripting[] = R"R({"namespace":"scripting","types":[{"id":"scripting.StyleOrigin","type":"string","enum":[{"name":"AUTHOR"},{"name":"USER"}]},{"id":"scripting.ExecutionWorld","type":"string","enum":[{"name":"ISOLATED"},{"name":"MAIN"}]},{"id":"scripting.InjectionTarget","properties":{"tabId":{"name":"tabId","type":"integer"},"frameIds":{"optional":true,"name":"frameIds","type":"array","items":{"type":"integer"}},"documentIds":{"optional":true,"name":"documentIds","type":"array","items":{"type":"string"}},"allFrames":{"optional":true,"name":"allFrames","type":"boolean"}},"type":"object"},{"id":"scripting.ScriptInjection","properties":{"func":{"serializableFunction":true,"optional":true,"name":"func","parameters":[],"type":"function"},"args":{"optional":true,"name":"args","type":"array","items":{"type":"any"}},"function":{"serializableFunction":true,"optional":true,"name":"function","parameters":[],"type":"function"},"files":{"optional":true,"name":"files","type":"array","items":{"type":"string"}},"target":{"name":"target","$ref":"scripting.InjectionTarget"},"world":{"optional":true,"name":"world","$ref":"scripting.ExecutionWorld"},"injectImmediately":{"optional":true,"name":"injectImmediately","type":"boolean"}},"type":"object"},{"id":"scripting.CSSInjection","properties":{"target":{"name":"target","$ref":"scripting.InjectionTarget"},"css":{"optional":true,"name":"css","type":"string"},"files":{"optional":true,"name":"files","type":"array","items":{"type":"string"}},"origin":{"optional":true,"name":"origin","$ref":"scripting.StyleOrigin"}},"type":"object"},{"id":"scripting.InjectionResult","properties":{"result":{"optional":true,"name":"result","type":"any"},"frameId":{"name":"frameId","type":"integer"},"documentId":{"name":"documentId","type":"string"}},"type":"object"},{"id":"scripting.RegisteredContentScript","properties":{"id":{"name":"id","type":"string"},"matches":{"optional":true,"name":"matches","type":"array","items":{"type":"string"}},"excludeMatches":{"optional":true,"name":"excludeMatches","type":"array","items":{"type":"string"}},"css":{"optional":true,"name":"css","type":"array","items":{"type":"string"}},"js":{"optional":true,"name":"js","type":"array","items":{"type":"string"}},"allFrames":{"optional":true,"name":"allFrames","type":"boolean"},"matchOriginAsFallback":{"optional":true,"name":"matchOriginAsFallback","type":"boolean"},"runAt":{"optional":true,"name":"runAt","$ref":"extensionTypes.RunAt"},"persistAcrossSessions":{"optional":true,"name":"persistAcrossSessions","type":"boolean"},"world":{"optional":true,"name":"world","$ref":"scripting.ExecutionWorld"}},"type":"object"},{"id":"scripting.ContentScriptFilter","properties":{"ids":{"optional":true,"name":"ids","type":"array","items":{"type":"string"}}},"type":"object"}],"functions":[{"parameters":[{"name":"injection","$ref":"scripting.ScriptInjection"}],"returns_async":{"name":"callback","optional":true,"parameters":[{"name":"results","type":"array","items":{"$ref":"scripting.InjectionResult"}}]},"name":"executeScript","type":"function"},{"parameters":[{"name":"injection","$ref":"scripting.CSSInjection"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"insertCSS","type":"function"},{"parameters":[{"name":"injection","$ref":"scripting.CSSInjection"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"removeCSS","type":"function"},{"parameters":[{"name":"scripts","type":"array","items":{"$ref":"scripting.RegisteredContentScript"}}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"registerContentScripts","type":"function"},{"parameters":[{"name":"filter","optional":true,"$ref":"scripting.ContentScriptFilter"}],"returns_async":{"name":"callback","parameters":[{"name":"scripts","type":"array","items":{"$ref":"scripting.RegisteredContentScript"}}]},"name":"getRegisteredContentScripts","type":"function"},{"parameters":[{"name":"filter","optional":true,"$ref":"scripting.ContentScriptFilter"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"unregisterContentScripts","type":"function"},{"parameters":[{"name":"scripts","type":"array","items":{"$ref":"scripting.RegisteredContentScript"}}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"updateContentScripts","type":"function"}],"properties":{},"events":[],"platforms":null,"deprecated":null})R";
constexpr char kTabs[] = R"R({"namespace":"tabs","types":[{"id":"tabs.TabStatus","type":"string","enum":["unloaded","loading","complete"]},{"id":"tabs.MutedInfoReason","type":"string","enum":[{"name":"user"},{"name":"capture"},{"name":"extension"}]},{"id":"tabs.MutedInfo","type":"object","properties":{"muted":{"type":"boolean"},"reason":{"$ref":"tabs.MutedInfoReason","optional":true},"extensionId":{"type":"string","optional":true}}},{"id":"tabs.Tab","type":"object","properties":{"id":{"type":"integer","minimum":-1,"optional":true},"index":{"type":"integer","minimum":-1},"groupId":{"type":"integer","minimum":-1},"splitViewId":{"type":"integer","minimum":-1,"optional":true},"windowId":{"type":"integer","minimum":-1},"openerTabId":{"type":"integer","minimum":0,"optional":true},"selected":{"type":"boolean","deprecated":"Please use $(ref:tabs.Tab.highlighted)."},"lastAccessed":{"type":"number"},"highlighted":{"type":"boolean"},"active":{"type":"boolean"},"pinned":{"type":"boolean"},"audible":{"type":"boolean","optional":true},"frozen":{"type":"boolean"},"discarded":{"type":"boolean"},"autoDiscardable":{"type":"boolean"},"mutedInfo":{"$ref":"tabs.MutedInfo","optional":true},"url":{"type":"string","optional":true},"pendingUrl":{"type":"string","optional":true},"title":{"type":"string","optional":true},"favIconUrl":{"type":"string","optional":true},"status":{"$ref":"tabs.TabStatus","optional":true},"incognito":{"type":"boolean"},"width":{"type":"integer","optional":true},"height":{"type":"integer","optional":true},"sessionId":{"type":"string","optional":true}}},{"id":"tabs.ZoomSettingsMode","type":"string","enum":[{"name":"automatic"},{"name":"manual"},{"name":"disabled"}]},{"id":"tabs.ZoomSettingsScope","type":"string","enum":[{"name":"per-origin"},{"name":"per-tab"}]},{"id":"tabs.ZoomSettings","type":"object","properties":{"mode":{"$ref":"tabs.ZoomSettingsMode","optional":true},"scope":{"$ref":"tabs.ZoomSettingsScope","optional":true},"defaultZoomFactor":{"type":"number","optional":true}}},{"id":"tabs.WindowType","type":"string","enum":["normal","popup","panel","app","devtools"]}],"properties":{"MAX_CAPTURE_VISIBLE_TAB_CALLS_PER_SECOND":{"value":2,"type":"integer"},"SPLIT_VIEW_ID_NONE":{"value":-1,"type":"integer"},"TAB_ID_NONE":{"value":-1,"type":"integer"},"TAB_INDEX_NONE":{"value":-1,"type":"integer"}},"functions":[{"name":"get","type":"function","parameters":[{"type":"integer","name":"tabId","minimum":0}],"returns_async":{"name":"callback","parameters":[{"name":"tab","$ref":"tabs.Tab"}]}},{"name":"getCurrent","type":"function","parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"tab","$ref":"tabs.Tab","optional":true}]}},{"name":"connect","type":"function","parameters":[{"type":"integer","name":"tabId","minimum":0},{"type":"object","name":"connectInfo","properties":{"name":{"type":"string","optional":true},"frameId":{"type":"integer","optional":true,"minimum":0},"documentId":{"type":"string","optional":true}},"optional":true}],"returns":{"$ref":"runtime.Port"}},{"name":"sendRequest","deprecated":"Please use $(ref:runtime.sendMessage).","type":"function","parameters":[{"type":"integer","name":"tabId","minimum":0},{"type":"any","name":"request"}],"returns_async":{"name":"callback","optional":true,"parameters":[{"name":"response","type":"any"}]}},{"name":"sendMessage","type":"function","parameters":[{"type":"integer","name":"tabId","minimum":0},{"type":"any","name":"message"},{"type":"object","name":"options","properties":{"frameId":{"type":"integer","optional":true,"minimum":0},"documentId":{"type":"string","optional":true}},"optional":true}],"returns_async":{"name":"callback","optional":true,"parameters":[{"name":"response","type":"any"}]}},{"name":"getSelected","deprecated":"Please use $(ref:tabs.query) <code>{active: true}</code>.","type":"function","parameters":[{"type":"integer","name":"windowId","minimum":-2,"optional":true}],"returns_async":{"name":"callback","parameters":[{"name":"tab","$ref":"tabs.Tab"}]}},{"name":"getAllInWindow","type":"function","deprecated":"Please use $(ref:tabs.query) <code>{windowId: windowId}</code>.","parameters":[{"type":"integer","name":"windowId","minimum":-2,"optional":true}],"returns_async":{"name":"callback","parameters":[{"name":"tabs","type":"array","items":{"$ref":"tabs.Tab"}}]}},{"name":"create","type":"function","parameters":[{"type":"object","name":"createProperties","properties":{"windowId":{"type":"integer","minimum":-2,"optional":true},"index":{"type":"integer","minimum":0,"optional":true},"url":{"type":"string","optional":true},"active":{"type":"boolean","optional":true},"selected":{"deprecated":"Please use <em>active</em>.","type":"boolean","optional":true},"pinned":{"type":"boolean","optional":true},"openerTabId":{"type":"integer","minimum":0,"optional":true}}}],"returns_async":{"name":"callback","optional":true,"parameters":[{"name":"tab","$ref":"tabs.Tab"}]}},{"name":"duplicate","type":"function","parameters":[{"type":"integer","name":"tabId","minimum":0}],"returns_async":{"name":"callback","optional":true,"parameters":[{"name":"tab","optional":true,"$ref":"tabs.Tab"}]}},{"name":"query","type":"function","parameters":[{"type":"object","name":"queryInfo","properties":{"active":{"type":"boolean","optional":true},"pinned":{"type":"boolean","optional":true},"audible":{"type":"boolean","optional":true},"muted":{"type":"boolean","optional":true},"highlighted":{"type":"boolean","optional":true},"frozen":{"type":"boolean","optional":true},"discarded":{"type":"boolean","optional":true},"autoDiscardable":{"type":"boolean","optional":true},"currentWindow":{"type":"boolean","optional":true},"lastFocusedWindow":{"type":"boolean","optional":true},"status":{"$ref":"tabs.TabStatus","optional":true},"title":{"type":"string","optional":true},"url":{"choices":[{"type":"string"},{"type":"array","items":{"type":"string"}}],"optional":true},"groupId":{"type":"integer","optional":true,"minimum":-1},"splitViewId":{"type":"integer","minimum":-1,"optional":true},"windowId":{"type":"integer","optional":true,"minimum":-2},"windowType":{"$ref":"tabs.WindowType","optional":true},"index":{"type":"integer","optional":true,"minimum":0}}}],"returns_async":{"name":"callback","parameters":[{"name":"result","type":"array","items":{"$ref":"tabs.Tab"}}]}},{"name":"highlight","type":"function","parameters":[{"type":"object","name":"highlightInfo","properties":{"windowId":{"type":"integer","optional":true,"minimum":-2},"tabs":{"choices":[{"type":"array","items":{"type":"integer","minimum":0}},{"type":"integer"}]}}}],"returns_async":{"name":"callback","optional":true,"parameters":[{"name":"window","$ref":"windows.Window"}]}},{"name":"update","type":"function","parameters":[{"type":"integer","name":"tabId","minimum":0,"optional":true},{"type":"object","name":"updateProperties","properties":{"url":{"type":"string","optional":true},"active":{"type":"boolean","optional":true},"highlighted":{"type":"boolean","optional":true},"selected":{"deprecated":"Please use <em>highlighted</em>.","type":"boolean","optional":true},"pinned":{"type":"boolean","optional":true},"muted":{"type":"boolean","optional":true},"openerTabId":{"type":"integer","minimum":0,"optional":true},"autoDiscardable":{"type":"boolean","optional":true}}}],"returns_async":{"name":"callback","optional":true,"parameters":[{"name":"tab","$ref":"tabs.Tab","optional":true}]}},{"name":"move","type":"function","parameters":[{"name":"tabIds","choices":[{"type":"integer","minimum":0},{"type":"array","items":{"type":"integer","minimum":0}}]},{"type":"object","name":"moveProperties","properties":{"windowId":{"type":"integer","minimum":-2,"optional":true},"index":{"type":"integer","minimum":-1}}}],"returns_async":{"name":"callback","optional":true,"parameters":[{"name":"tabs","choices":[{"$ref":"tabs.Tab"},{"type":"array","items":{"$ref":"tabs.Tab"}}]}]}},{"name":"reload","type":"function","parameters":[{"type":"integer","name":"tabId","minimum":0,"optional":true},{"type":"object","name":"reloadProperties","optional":true,"properties":{"bypassCache":{"type":"boolean","optional":true}}}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"remove","type":"function","p)R" R"R(arameters":[{"name":"tabIds","choices":[{"type":"integer","minimum":0},{"type":"array","items":{"type":"integer","minimum":0}}]}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"group","type":"function","parameters":[{"name":"options","type":"object","properties":{"tabIds":{"choices":[{"type":"integer","minimum":0},{"type":"array","items":{"type":"integer","minimum":0},"minItems":1}]},"groupId":{"type":"integer","minimum":0,"optional":true},"createProperties":{"type":"object","optional":true,"properties":{"windowId":{"type":"integer","minimum":-2,"optional":true}}}}}],"returns_async":{"name":"callback","optional":true,"parameters":[{"name":"groupId","type":"integer","minimum":0}]}},{"name":"ungroup","type":"function","parameters":[{"name":"tabIds","choices":[{"type":"integer","minimum":0},{"type":"array","items":{"type":"integer","minimum":0},"minItems":1}]}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"detectLanguage","type":"function","parameters":[{"type":"integer","name":"tabId","minimum":0,"optional":true}],"returns_async":{"name":"callback","parameters":[{"type":"string","name":"language"}]}},{"name":"captureVisibleTab","type":"function","parameters":[{"type":"integer","name":"windowId","minimum":-2,"optional":true},{"$ref":"extensionTypes.ImageDetails","name":"options","optional":true}],"returns_async":{"name":"callback","parameters":[{"type":"string","name":"dataUrl"}]}},{"name":"executeScript","deprecated":"Replaced by $(ref:scripting.executeScript) in Manifest V3.","type":"function","parameters":[{"type":"integer","name":"tabId","minimum":0,"optional":true},{"$ref":"extensionTypes.InjectDetails","name":"details"}],"returns_async":{"name":"callback","optional":true,"parameters":[{"name":"result","optional":true,"type":"array","items":{"type":"any","minimum":0}}]}},{"name":"insertCSS","deprecated":"Replaced by $(ref:scripting.insertCSS) in Manifest V3.","type":"function","parameters":[{"type":"integer","name":"tabId","minimum":0,"optional":true},{"$ref":"extensionTypes.InjectDetails","name":"details"}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"removeCSS","deprecated":"Replaced by $(ref:scripting.removeCSS) in Manifest V3.","type":"function","parameters":[{"type":"integer","name":"tabId","minimum":0,"optional":true},{"$ref":"extensionTypes.DeleteInjectionDetails","name":"details"}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"setZoom","type":"function","parameters":[{"type":"integer","name":"tabId","minimum":0,"optional":true},{"type":"number","name":"zoomFactor"}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"getZoom","type":"function","parameters":[{"type":"integer","name":"tabId","minimum":0,"optional":true}],"returns_async":{"name":"callback","parameters":[{"type":"number","name":"zoomFactor"}]}},{"name":"setZoomSettings","type":"function","parameters":[{"type":"integer","name":"tabId","optional":true,"minimum":0},{"$ref":"tabs.ZoomSettings","name":"zoomSettings"}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"getZoomSettings","type":"function","parameters":[{"type":"integer","name":"tabId","optional":true,"minimum":0}],"returns_async":{"name":"callback","parameters":[{"$ref":"tabs.ZoomSettings","name":"zoomSettings"}]}},{"name":"discard","type":"function","parameters":[{"type":"integer","name":"tabId","optional":true,"minimum":0}],"returns_async":{"name":"callback","optional":true,"parameters":[{"name":"tab","$ref":"tabs.Tab","optional":true}]}},{"name":"goForward","type":"function","parameters":[{"type":"integer","name":"tabId","optional":true,"minimum":0}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"goBack","type":"function","parameters":[{"type":"integer","name":"tabId","optional":true,"minimum":0}],"returns_async":{"name":"callback","optional":true,"parameters":[]}}],"events":[{"name":"onCreated","type":"function","parameters":[{"$ref":"tabs.Tab","name":"tab"}]},{"name":"onUpdated","type":"function","parameters":[{"type":"integer","name":"tabId","minimum":0},{"type":"object","name":"changeInfo","properties":{"status":{"$ref":"tabs.TabStatus","optional":true},"url":{"type":"string","optional":true},"groupId":{"type":"integer","optional":true,"minimum":-1},"splitViewId":{"type":"integer","minimum":-1,"optional":true},"pinned":{"type":"boolean","optional":true},"audible":{"type":"boolean","optional":true},"frozen":{"type":"boolean","optional":true},"discarded":{"type":"boolean","optional":true},"autoDiscardable":{"type":"boolean","optional":true},"mutedInfo":{"$ref":"tabs.MutedInfo","optional":true},"favIconUrl":{"type":"string","optional":true},"title":{"type":"string","optional":true}}},{"$ref":"tabs.Tab","name":"tab"}]},{"name":"onMoved","type":"function","parameters":[{"type":"integer","name":"tabId","minimum":0},{"type":"object","name":"moveInfo","properties":{"windowId":{"type":"integer","minimum":0},"fromIndex":{"type":"integer","minimum":0},"toIndex":{"type":"integer","minimum":0}}}]},{"name":"onSelectionChanged","deprecated":"Please use $(ref:tabs.onActivated).","type":"function","parameters":[{"type":"integer","name":"tabId","minimum":0},{"type":"object","name":"selectInfo","properties":{"windowId":{"type":"integer","minimum":0}}}]},{"name":"onActiveChanged","deprecated":"Please use $(ref:tabs.onActivated).","type":"function","parameters":[{"type":"integer","name":"tabId","minimum":0},{"type":"object","name":"selectInfo","properties":{"windowId":{"type":"integer","minimum":0}}}]},{"name":"onActivated","type":"function","parameters":[{"type":"object","name":"activeInfo","properties":{"tabId":{"type":"integer","minimum":0},"windowId":{"type":"integer","minimum":0}}}]},{"name":"onHighlightChanged","deprecated":"Please use $(ref:tabs.onHighlighted).","type":"function","parameters":[{"type":"object","name":"selectInfo","properties":{"windowId":{"type":"integer","minimum":0},"tabIds":{"type":"array","name":"tabIds","items":{"type":"integer","minimum":0}}}}]},{"name":"onHighlighted","type":"function","parameters":[{"type":"object","name":"highlightInfo","properties":{"windowId":{"type":"integer","minimum":0},"tabIds":{"type":"array","name":"tabIds","items":{"type":"integer","minimum":0}}}}]},{"name":"onDetached","type":"function","parameters":[{"type":"integer","name":"tabId","minimum":0},{"type":"object","name":"detachInfo","properties":{"oldWindowId":{"type":"integer","minimum":0},"oldPosition":{"type":"integer","minimum":0}}}]},{"name":"onAttached","type":"function","parameters":[{"type":"integer","name":"tabId","minimum":0},{"type":"object","name":"attachInfo","properties":{"newWindowId":{"type":"integer","minimum":0},"newPosition":{"type":"integer","minimum":0}}}]},{"name":"onRemoved","type":"function","parameters":[{"type":"integer","name":"tabId","minimum":0},{"type":"object","name":"removeInfo","properties":{"windowId":{"type":"integer","minimum":0},"isWindowClosing":{"type":"boolean"}}}]},{"name":"onReplaced","type":"function","parameters":[{"type":"integer","name":"addedTabId","minimum":0},{"type":"integer","name":"removedTabId","minimum":0}]},{"name":"onZoomChange","type":"function","parameters":[{"type":"object","name":"ZoomChangeInfo","properties":{"tabId":{"type":"integer","minimum":0},"oldZoomFactor":{"type":"number"},"newZoomFactor":{"type":"number"},"zoomSettings":{"$ref":"tabs.ZoomSettings"}}}]}]})R";
constexpr char kWebAuthenticationProxy[] = R"R({"namespace":"webAuthenticationProxy","functions":[{"name":"completeCreateRequest","type":"function","parameters":[{"$ref":"webAuthenticationProxy.CreateResponseDetails","name":"details"}],"returns_async":{"parameters":[],"name":"callback"}},{"name":"completeGetRequest","type":"function","parameters":[{"$ref":"webAuthenticationProxy.GetResponseDetails","name":"details"}],"returns_async":{"parameters":[],"name":"callback"}},{"name":"completeIsUvpaaRequest","type":"function","parameters":[{"$ref":"webAuthenticationProxy.IsUvpaaResponseDetails","name":"details"}],"returns_async":{"parameters":[],"name":"callback"}},{"name":"attach","type":"function","parameters":[],"returns_async":{"parameters":[{"type":"string","optional":true,"name":"error"}],"name":"callback"}},{"name":"detach","type":"function","parameters":[],"returns_async":{"parameters":[{"type":"string","optional":true,"name":"error"}],"name":"callback"}}],"types":[{"id":"webAuthenticationProxy.IsUvpaaRequest","properties":{"requestId":{"type":"integer","name":"requestId"}},"type":"object"},{"id":"webAuthenticationProxy.CreateRequest","properties":{"requestId":{"type":"integer","name":"requestId"},"requestDetailsJson":{"type":"string","name":"requestDetailsJson"}},"type":"object"},{"id":"webAuthenticationProxy.GetRequest","properties":{"requestId":{"type":"integer","name":"requestId"},"requestDetailsJson":{"type":"string","name":"requestDetailsJson"}},"type":"object"},{"id":"webAuthenticationProxy.DOMExceptionDetails","properties":{"name":{"type":"string","name":"name"},"message":{"type":"string","name":"message"}},"type":"object"},{"id":"webAuthenticationProxy.CreateResponseDetails","properties":{"requestId":{"type":"integer","name":"requestId"},"error":{"$ref":"webAuthenticationProxy.DOMExceptionDetails","name":"error","optional":true},"responseJson":{"type":"string","name":"responseJson","optional":true}},"type":"object"},{"id":"webAuthenticationProxy.GetResponseDetails","properties":{"requestId":{"type":"integer","name":"requestId"},"error":{"$ref":"webAuthenticationProxy.DOMExceptionDetails","name":"error","optional":true},"responseJson":{"type":"string","name":"responseJson","optional":true}},"type":"object"},{"id":"webAuthenticationProxy.IsUvpaaResponseDetails","properties":{"requestId":{"type":"integer","name":"requestId"},"isUvpaa":{"type":"boolean","name":"isUvpaa"}},"type":"object"}],"events":[{"name":"onRemoteSessionStateChange","type":"function","parameters":[]},{"name":"onCreateRequest","type":"function","parameters":[{"$ref":"webAuthenticationProxy.CreateRequest","name":"requestInfo"}]},{"name":"onGetRequest","type":"function","parameters":[{"$ref":"webAuthenticationProxy.GetRequest","name":"requestInfo"}]},{"name":"onIsUvpaaRequest","type":"function","parameters":[{"$ref":"webAuthenticationProxy.IsUvpaaRequest","name":"requestInfo"}]},{"name":"onRequestCanceled","type":"function","parameters":[{"type":"integer","name":"requestId"}]}],"properties":{},"platforms":null,"deprecated":null})R";
constexpr char kWebNavigation[] = R"R({"namespace":"webNavigation","types":[{"id":"webNavigation.TransitionType","type":"string","enum":["link","typed","auto_bookmark","auto_subframe","manual_subframe","generated","start_page","form_submit","reload","keyword","keyword_generated"]},{"id":"webNavigation.TransitionQualifier","type":"string","enum":["client_redirect","server_redirect","forward_back","from_address_bar"]}],"functions":[{"name":"getFrame","type":"function","parameters":[{"type":"object","name":"details","properties":{"tabId":{"type":"integer","optional":true,"minimum":0},"processId":{"type":"integer","optional":true,"deprecated":"Frames are now uniquely identified by their tab ID and frame ID; the process ID is no longer needed and therefore ignored."},"frameId":{"type":"integer","optional":true,"minimum":0},"documentId":{"type":"string","optional":true}}}],"returns_async":{"name":"callback","parameters":[{"type":"object","name":"details","optional":true,"properties":{"errorOccurred":{"type":"boolean"},"url":{"type":"string"},"parentFrameId":{"type":"integer"},"documentId":{"type":"string"},"parentDocumentId":{"type":"string","optional":true},"documentLifecycle":{"$ref":"extensionTypes.DocumentLifecycle"},"frameType":{"$ref":"extensionTypes.FrameType"}}}]}},{"name":"getAllFrames","type":"function","parameters":[{"type":"object","name":"details","properties":{"tabId":{"type":"integer","minimum":0}}}],"returns_async":{"name":"callback","parameters":[{"name":"details","type":"array","optional":true,"items":{"type":"object","properties":{"errorOccurred":{"type":"boolean"},"processId":{"type":"integer"},"frameId":{"type":"integer"},"parentFrameId":{"type":"integer"},"url":{"type":"string"},"documentId":{"type":"string"},"parentDocumentId":{"type":"string","optional":true},"documentLifecycle":{"$ref":"extensionTypes.DocumentLifecycle"},"frameType":{"$ref":"extensionTypes.FrameType"}}}}]}}],"events":[{"name":"onBeforeNavigate","type":"function","filters":[{"name":"url","type":"array","items":{"$ref":"events.UrlFilter"}}],"parameters":[{"type":"object","name":"details","properties":{"tabId":{"type":"integer"},"url":{"type":"string"},"processId":{"type":"integer","deprecated":"The processId is no longer set for this event, since the process which will render the resulting document is not known until onCommit."},"frameId":{"type":"integer"},"parentFrameId":{"type":"integer"},"timeStamp":{"type":"number"},"parentDocumentId":{"type":"string","optional":true},"documentLifecycle":{"$ref":"extensionTypes.DocumentLifecycle"},"frameType":{"$ref":"extensionTypes.FrameType"}}}]},{"name":"onCommitted","type":"function","filters":[{"name":"url","type":"array","items":{"$ref":"events.UrlFilter"}}],"parameters":[{"type":"object","name":"details","properties":{"tabId":{"type":"integer"},"url":{"type":"string"},"processId":{"type":"integer"},"frameId":{"type":"integer"},"parentFrameId":{"type":"integer"},"transitionType":{"$ref":"webNavigation.TransitionType"},"transitionQualifiers":{"type":"array","items":{"$ref":"webNavigation.TransitionQualifier"}},"timeStamp":{"type":"number"},"documentId":{"type":"string"},"parentDocumentId":{"type":"string","optional":true},"documentLifecycle":{"$ref":"extensionTypes.DocumentLifecycle"},"frameType":{"$ref":"extensionTypes.FrameType"}}}]},{"name":"onDOMContentLoaded","type":"function","filters":[{"name":"url","type":"array","items":{"$ref":"events.UrlFilter"}}],"parameters":[{"type":"object","name":"details","properties":{"tabId":{"type":"integer"},"url":{"type":"string"},"processId":{"type":"integer"},"frameId":{"type":"integer"},"parentFrameId":{"type":"integer"},"timeStamp":{"type":"number"},"documentId":{"type":"string"},"parentDocumentId":{"type":"string","optional":true},"documentLifecycle":{"$ref":"extensionTypes.DocumentLifecycle"},"frameType":{"$ref":"extensionTypes.FrameType"}}}]},{"name":"onCompleted","type":"function","filters":[{"name":"url","type":"array","items":{"$ref":"events.UrlFilter"}}],"parameters":[{"type":"object","name":"details","properties":{"tabId":{"type":"integer"},"url":{"type":"string"},"processId":{"type":"integer"},"frameId":{"type":"integer"},"parentFrameId":{"type":"integer"},"timeStamp":{"type":"number"},"documentId":{"type":"string"},"parentDocumentId":{"type":"string","optional":true},"documentLifecycle":{"$ref":"extensionTypes.DocumentLifecycle"},"frameType":{"$ref":"extensionTypes.FrameType"}}}]},{"name":"onErrorOccurred","type":"function","filters":[{"name":"url","type":"array","items":{"$ref":"events.UrlFilter"}}],"parameters":[{"type":"object","name":"details","properties":{"tabId":{"type":"integer"},"url":{"type":"string"},"processId":{"type":"integer","deprecated":"The processId is no longer set for this event."},"frameId":{"type":"integer"},"parentFrameId":{"type":"integer"},"error":{"type":"string"},"timeStamp":{"type":"number"},"documentId":{"type":"string"},"parentDocumentId":{"type":"string","optional":true},"documentLifecycle":{"$ref":"extensionTypes.DocumentLifecycle"},"frameType":{"$ref":"extensionTypes.FrameType"}}}]},{"name":"onCreatedNavigationTarget","type":"function","filters":[{"name":"url","type":"array","items":{"$ref":"events.UrlFilter"}}],"parameters":[{"type":"object","name":"details","properties":{"sourceTabId":{"type":"integer"},"sourceProcessId":{"type":"integer"},"sourceFrameId":{"type":"integer"},"url":{"type":"string"},"tabId":{"type":"integer"},"timeStamp":{"type":"number"}}}]},{"name":"onReferenceFragmentUpdated","type":"function","filters":[{"name":"url","type":"array","items":{"$ref":"events.UrlFilter"}}],"parameters":[{"type":"object","name":"details","properties":{"tabId":{"type":"integer"},"url":{"type":"string"},"processId":{"type":"integer"},"frameId":{"type":"integer"},"parentFrameId":{"type":"integer"},"transitionType":{"$ref":"webNavigation.TransitionType"},"transitionQualifiers":{"type":"array","items":{"$ref":"webNavigation.TransitionQualifier"}},"timeStamp":{"type":"number"},"documentId":{"type":"string"},"parentDocumentId":{"type":"string","optional":true},"documentLifecycle":{"$ref":"extensionTypes.DocumentLifecycle"},"frameType":{"$ref":"extensionTypes.FrameType"}}}]},{"name":"onTabReplaced","type":"function","parameters":[{"type":"object","name":"details","properties":{"replacedTabId":{"type":"integer"},"tabId":{"type":"integer"},"timeStamp":{"type":"number"}}}]},{"name":"onHistoryStateUpdated","type":"function","filters":[{"name":"url","type":"array","items":{"$ref":"events.UrlFilter"}}],"parameters":[{"type":"object","name":"details","properties":{"tabId":{"type":"integer"},"url":{"type":"string"},"processId":{"type":"integer"},"frameId":{"type":"integer"},"parentFrameId":{"type":"integer"},"transitionType":{"$ref":"webNavigation.TransitionType"},"transitionQualifiers":{"type":"array","items":{"$ref":"webNavigation.TransitionQualifier"}},"timeStamp":{"type":"number"},"documentId":{"type":"string"},"parentDocumentId":{"type":"string","optional":true},"documentLifecycle":{"$ref":"extensionTypes.DocumentLifecycle"},"frameType":{"$ref":"extensionTypes.FrameType"}}}]}]})R";
constexpr char kWebrtcAudioPrivate[] = R"R({"namespace":"webrtcAudioPrivate","types":[{"id":"webrtcAudioPrivate.SinkInfo","properties":{"sinkId":{"name":"sinkId","type":"string"},"sinkLabel":{"name":"sinkLabel","type":"string"},"sampleRate":{"name":"sampleRate","type":"integer"},"isReady":{"name":"isReady","type":"boolean"},"isDefault":{"name":"isDefault","type":"boolean"}},"type":"object"}],"functions":[{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"sinkInfo","type":"array","items":{"$ref":"webrtcAudioPrivate.SinkInfo"}}]},"name":"getSinks","type":"function"},{"parameters":[{"name":"securityOrigin","type":"string"},{"name":"sourceIdInOrigin","type":"string"}],"returns_async":{"name":"callback","parameters":[{"name":"sinkId","type":"string"}]},"name":"getAssociatedSink","type":"function"}],"properties":{},"events":[{"parameters":[],"name":"onSinksChanged","type":"function"}],"platforms":null,"deprecated":null})R";
constexpr char kWebrtcLoggingPrivate[] = R"R({"namespace":"webrtcLoggingPrivate","types":[{"id":"webrtcLoggingPrivate.MetaDataEntry","properties":{"key":{"name":"key","type":"string"},"value":{"name":"value","type":"string"}},"type":"object"},{"id":"webrtcLoggingPrivate.UploadResult","properties":{"reportId":{"name":"reportId","type":"string"}},"type":"object"},{"id":"webrtcLoggingPrivate.RequestInfo","properties":{"tabId":{"optional":true,"name":"tabId","type":"integer"},"guestProcessId":{"optional":true,"name":"guestProcessId","type":"integer"},"targetWebview":{"optional":true,"name":"targetWebview","type":"boolean"}},"type":"object"},{"id":"webrtcLoggingPrivate.RecordingInfo","properties":{"prefixPath":{"name":"prefixPath","type":"string"},"didStop":{"name":"didStop","type":"boolean"},"didManualStop":{"name":"didManualStop","type":"boolean"}},"type":"object"},{"id":"webrtcLoggingPrivate.StartEventLoggingResult","properties":{"logId":{"name":"logId","type":"string"}},"type":"object"}],"functions":[{"parameters":[{"name":"request","$ref":"webrtcLoggingPrivate.RequestInfo"},{"name":"securityOrigin","type":"string"},{"name":"metaData","type":"array","items":{"$ref":"webrtcLoggingPrivate.MetaDataEntry"}}],"returns_async":{"name":"callback","parameters":[]},"name":"setMetaData","type":"function"},{"parameters":[{"name":"request","$ref":"webrtcLoggingPrivate.RequestInfo"},{"name":"securityOrigin","type":"string"}],"returns_async":{"name":"callback","parameters":[]},"name":"start","type":"function"},{"parameters":[{"name":"request","$ref":"webrtcLoggingPrivate.RequestInfo"},{"name":"securityOrigin","type":"string"},{"name":"shouldUpload","type":"boolean"}],"name":"setUploadOnRenderClose","type":"function"},{"parameters":[{"name":"request","$ref":"webrtcLoggingPrivate.RequestInfo"},{"name":"securityOrigin","type":"string"}],"returns_async":{"name":"callback","parameters":[]},"name":"stop","type":"function"},{"parameters":[{"name":"request","$ref":"webrtcLoggingPrivate.RequestInfo"},{"name":"securityOrigin","type":"string"},{"name":"logId","type":"string"}],"returns_async":{"name":"callback","parameters":[]},"name":"store","type":"function"},{"parameters":[{"name":"request","$ref":"webrtcLoggingPrivate.RequestInfo"},{"name":"securityOrigin","type":"string"},{"name":"logId","type":"string"}],"returns_async":{"name":"callback","parameters":[{"name":"result","$ref":"webrtcLoggingPrivate.UploadResult"}]},"name":"uploadStored","type":"function"},{"parameters":[{"name":"request","$ref":"webrtcLoggingPrivate.RequestInfo"},{"name":"securityOrigin","type":"string"}],"returns_async":{"name":"callback","parameters":[{"name":"result","$ref":"webrtcLoggingPrivate.UploadResult"}]},"name":"upload","type":"function"},{"parameters":[{"name":"request","$ref":"webrtcLoggingPrivate.RequestInfo"},{"name":"securityOrigin","type":"string"}],"returns_async":{"name":"callback","parameters":[]},"name":"discard","type":"function"},{"parameters":[{"name":"request","$ref":"webrtcLoggingPrivate.RequestInfo"},{"name":"securityOrigin","type":"string"},{"name":"incoming","type":"boolean"},{"name":"outgoing","type":"boolean"}],"returns_async":{"name":"callback","parameters":[]},"name":"startRtpDump","type":"function"},{"parameters":[{"name":"request","$ref":"webrtcLoggingPrivate.RequestInfo"},{"name":"securityOrigin","type":"string"},{"name":"incoming","type":"boolean"},{"name":"outgoing","type":"boolean"}],"returns_async":{"name":"callback","parameters":[]},"name":"stopRtpDump","type":"function"},{"parameters":[{"name":"request","$ref":"webrtcLoggingPrivate.RequestInfo"},{"name":"securityOrigin","type":"string"},{"name":"seconds","type":"integer"}],"returns_async":{"name":"callback","parameters":[{"name":"info","$ref":"webrtcLoggingPrivate.RecordingInfo"}]},"name":"startAudioDebugRecordings","type":"function"},{"parameters":[{"name":"request","$ref":"webrtcLoggingPrivate.RequestInfo"},{"name":"securityOrigin","type":"string"}],"returns_async":{"name":"callback","parameters":[{"name":"info","$ref":"webrtcLoggingPrivate.RecordingInfo"}]},"name":"stopAudioDebugRecordings","type":"function"},{"parameters":[{"name":"request","$ref":"webrtcLoggingPrivate.RequestInfo"},{"name":"securityOrigin","type":"string"},{"name":"sessionId","type":"string"},{"name":"maxLogSizeBytes","type":"integer"},{"name":"outputPeriodMs","type":"integer"},{"name":"webAppId","type":"integer"}],"returns_async":{"name":"callback","parameters":[{"name":"result","$ref":"webrtcLoggingPrivate.StartEventLoggingResult"}]},"name":"startEventLogging","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"entry","type":"object","additionalProperties":{"type":"any"},"isInstanceOf":"DirectoryEntry"}],"does_not_support_promises":"Custom hook sets lastError crbug.com/1504349"},"name":"getLogsDirectory","type":"function"}],"properties":{},"events":[],"platforms":null,"deprecated":null})R";
constexpr char kWebstorePrivate[] = R"R({"namespace":"webstorePrivate","types":[{"id":"webstorePrivate.Result","type":"string","enum":[{"name":""},{"name":"success"},{"name":"user_gesture_required"},{"name":"unknown_error"},{"name":"feature_disabled"},{"name":"unsupported_extension_type"},{"name":"missing_dependencies"},{"name":"install_error"},{"name":"user_cancelled"},{"name":"invalid_id"},{"name":"blacklisted"},{"name":"blocked_by_policy"},{"name":"install_in_progress"},{"name":"launch_in_progress"},{"name":"manifest_error"},{"name":"icon_error"},{"name":"invalid_icon_url"},{"name":"already_installed"},{"name":"blocked_for_child_account"}]},{"id":"webstorePrivate.WebGlStatus","type":"string","enum":["webgl_allowed","webgl_blocked"]},{"id":"webstorePrivate.ExtensionInstallStatus","type":"string","enum":[{"name":"can_request"},{"name":"request_pending"},{"name":"blocked_by_policy"},{"name":"installable"},{"name":"enabled"},{"name":"disabled"},{"name":"terminated"},{"name":"blacklisted"},{"name":"custodian_approval_required"},{"name":"custodian_approval_required_for_installation"},{"name":"force_installed"},{"name":"deprecated_manifest_version"},{"name":"corrupted"}]},{"id":"webstorePrivate.MV2DeprecationStatus","type":"string","enum":["inactive","warning","soft_disable","hard_disable"]}],"functions":[{"name":"install","parameters":[{"name":"expected_id","type":"string"}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"beginInstallWithManifest3","parameters":[{"name":"details","type":"object","properties":{"id":{"type":"string","minLength":32,"maxLength":32},"manifest":{"type":"string","minLength":1},"iconUrl":{"type":"string","optional":true,"desciption":"A URL for the image to display in the confirmation dialog"},"localizedName":{"type":"string","optional":true},"locale":{"type":"string","optional":true},"appInstallBubble":{"type":"boolean","optional":true},"enableLauncher":{"type":"boolean","optional":true},"authuser":{"type":"string","optional":true},"esbAllowlist":{"type":"boolean","optional":true}},"additionalProperties":{"type":"any"}}],"returns_async":{"name":"callback","optional":true,"parameters":[{"name":"result","$ref":"webstorePrivate.Result"}]}},{"name":"completeInstall","parameters":[{"name":"expected_id","type":"string"}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"enableAppLauncher","parameters":[],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"getBrowserLogin","parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"info","type":"object","properties":{"login":{"type":"string"}}}]}},{"name":"getStoreLogin","parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"login","type":"string"}]}},{"name":"setStoreLogin","parameters":[{"name":"login","type":"string"}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"getWebGLStatus","parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"webgl_status","$ref":"webstorePrivate.WebGlStatus"}]}},{"name":"getIsLauncherEnabled","parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"is_enabled","type":"boolean"}]}},{"name":"isInIncognitoMode","parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"is_incognito","type":"boolean"}]}},{"name":"isPendingCustodianApproval","parameters":[{"name":"id","type":"string"}],"returns_async":{"name":"callback","parameters":[{"name":"is_pending_approval","type":"boolean"}]}},{"name":"getReferrerChain","parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"referrerChain","type":"string"}]}},{"name":"getExtensionStatus","parameters":[{"name":"id","type":"string"},{"name":"manifest","type":"string","optional":true}],"returns_async":{"name":"callback","parameters":[{"name":"status","$ref":"webstorePrivate.ExtensionInstallStatus"}]}},{"name":"getFullChromeVersion","parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"info","type":"object","properties":{"version_number":{"type":"string"}}}]}},{"name":"getMV2DeprecationStatus","parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"status","$ref":"webstorePrivate.MV2DeprecationStatus"}]}}]})R";
constexpr char kWindows[] = R"R({"namespace":"windows","types":[{"id":"windows.WindowType","type":"string","enum":[{"name":"normal"},{"name":"popup"},{"name":"panel"},{"name":"app"},{"name":"devtools"}]},{"id":"windows.WindowState","type":"string","enum":[{"name":"normal"},{"name":"minimized"},{"name":"maximized"},{"name":"fullscreen"},{"name":"locked-fullscreen"}]},{"id":"windows.Window","type":"object","properties":{"id":{"type":"integer","optional":true,"minimum":0},"focused":{"type":"boolean"},"top":{"type":"integer","optional":true},"left":{"type":"integer","optional":true},"width":{"type":"integer","optional":true},"height":{"type":"integer","optional":true},"tabs":{"type":"array","items":{"$ref":"tabs.Tab"},"optional":true},"incognito":{"type":"boolean"},"type":{"$ref":"windows.WindowType","optional":true},"state":{"$ref":"windows.WindowState","optional":true},"alwaysOnTop":{"type":"boolean"},"sessionId":{"type":"string","optional":true}}},{"id":"windows.CreateType","type":"string","enum":[{"name":"normal"},{"name":"popup"},{"name":"panel"}]},{"id":"windows.QueryOptions","type":"object","properties":{"populate":{"type":"boolean","optional":true},"windowTypes":{"type":"array","items":{"$ref":"windows.WindowType"},"optional":true}}}],"properties":{"WINDOW_ID_NONE":{"value":-1,"type":"integer"},"WINDOW_ID_CURRENT":{"value":-2,"type":"integer"}},"functions":[{"name":"get","type":"function","parameters":[{"type":"integer","name":"windowId","minimum":-2},{"name":"queryOptions","$ref":"windows.QueryOptions","optional":true}],"returns_async":{"name":"callback","parameters":[{"name":"window","$ref":"windows.Window"}]}},{"name":"getCurrent","type":"function","parameters":[{"name":"queryOptions","$ref":"windows.QueryOptions","optional":true}],"returns_async":{"name":"callback","parameters":[{"name":"window","$ref":"windows.Window"}]}},{"name":"getLastFocused","type":"function","parameters":[{"name":"queryOptions","$ref":"windows.QueryOptions","optional":true}],"returns_async":{"name":"callback","parameters":[{"name":"window","$ref":"windows.Window"}]}},{"name":"getAll","type":"function","parameters":[{"name":"queryOptions","$ref":"windows.QueryOptions","optional":true}],"returns_async":{"name":"callback","parameters":[{"name":"windows","type":"array","items":{"$ref":"windows.Window"}}]}},{"name":"create","type":"function","parameters":[{"type":"object","name":"createData","properties":{"url":{"optional":true,"choices":[{"type":"string"},{"type":"array","items":{"type":"string"}}]},"tabId":{"type":"integer","minimum":0,"optional":true},"left":{"type":"integer","optional":true},"top":{"type":"integer","optional":true},"width":{"type":"integer","minimum":0,"optional":true},"height":{"type":"integer","minimum":0,"optional":true},"focused":{"type":"boolean","optional":true},"incognito":{"type":"boolean","optional":true},"type":{"$ref":"windows.CreateType","optional":true},"state":{"$ref":"windows.WindowState","optional":true},"setSelfAsOpener":{"type":"boolean","optional":true}},"optional":true}],"returns_async":{"name":"callback","optional":true,"parameters":[{"name":"window","$ref":"windows.Window","optional":true}]}},{"name":"update","type":"function","parameters":[{"type":"integer","name":"windowId","minimum":-2},{"type":"object","name":"updateInfo","properties":{"left":{"type":"integer","optional":true},"top":{"type":"integer","optional":true},"width":{"type":"integer","minimum":0,"optional":true},"height":{"type":"integer","minimum":0,"optional":true},"focused":{"type":"boolean","optional":true},"drawAttention":{"type":"boolean","optional":true},"state":{"$ref":"windows.WindowState","optional":true}}}],"returns_async":{"name":"callback","optional":true,"parameters":[{"name":"window","$ref":"windows.Window"}]}},{"name":"remove","type":"function","parameters":[{"type":"integer","name":"windowId","minimum":0}],"returns_async":{"name":"callback","optional":true,"parameters":[]}}],"events":[{"name":"onCreated","type":"function","filters":[{"name":"windowTypes","type":"array","items":{"$ref":"windows.WindowType"}}],"parameters":[{"$ref":"windows.Window","name":"window"}]},{"name":"onRemoved","type":"function","filters":[{"name":"windowTypes","type":"array","items":{"$ref":"windows.WindowType"}}],"parameters":[{"type":"integer","name":"windowId","minimum":0}]},{"name":"onFocusChanged","type":"function","filters":[{"name":"windowTypes","type":"array","items":{"$ref":"windows.WindowType"}}],"parameters":[{"type":"integer","name":"windowId","minimum":-1}]},{"name":"onBoundsChanged","type":"function","parameters":[{"$ref":"windows.Window","name":"window"}]}]})R";
constexpr char kMdns[] = R"R({"namespace":"mdns","types":[{"id":"mdns.MDnsService","properties":{"serviceName":{"name":"serviceName","type":"string"},"serviceHostPort":{"name":"serviceHostPort","type":"string"},"ipAddress":{"name":"ipAddress","type":"string"},"serviceData":{"name":"serviceData","type":"array","items":{"type":"string"}}},"type":"object"}],"functions":[{"parameters":[],"returns_async":{"name":"callback","parameters":[]},"name":"forceDiscovery","type":"function"}],"properties":{"MAX_SERVICE_INSTANCES_PER_EVENT":{"type":"integer","value":2048}},"events":[{"options":{"maxListeners":10,"supportsFilters":true},"parameters":[{"name":"services","type":"array","items":{"$ref":"mdns.MDnsService"}}],"name":"onServiceList","type":"function"}],"platforms":null,"deprecated":null})R";
constexpr char kAccessibilityFeatures[] = R"R({"namespace":"accessibilityFeatures","properties":{"spokenFeedback":{"$ref":"types.ChromeSetting","value":["spokenFeedback",{"type":"boolean"}],"platforms":["chromeos"]},"largeCursor":{"$ref":"types.ChromeSetting","value":["largeCursor",{"type":"boolean"}],"platforms":["chromeos"]},"stickyKeys":{"$ref":"types.ChromeSetting","value":["stickyKeys",{"type":"boolean"}],"platforms":["chromeos"]},"highContrast":{"$ref":"types.ChromeSetting","value":["highContrast",{"type":"boolean"}],"platforms":["chromeos"]},"screenMagnifier":{"$ref":"types.ChromeSetting","value":["screenMagnifier",{"type":"boolean"}],"platforms":["chromeos"]},"autoclick":{"$ref":"types.ChromeSetting","value":["autoclick",{"type":"boolean"}],"platforms":["chromeos"]},"virtualKeyboard":{"$ref":"types.ChromeSetting","value":["virtualKeyboard",{"type":"boolean"}],"platforms":["chromeos"]},"caretHighlight":{"$ref":"types.ChromeSetting","value":["caretHighlight",{"type":"boolean"}],"platforms":["chromeos"]},"cursorHighlight":{"$ref":"types.ChromeSetting","value":["cursorHighlight",{"type":"boolean"}],"platforms":["chromeos"]},"cursorColor":{"$ref":"types.ChromeSetting","value":["cursorColor",{"type":"boolean"}],"platforms":["chromeos"]},"dockedMagnifier":{"$ref":"types.ChromeSetting","value":["dockedMagnifier",{"type":"boolean"}],"platforms":["chromeos"]},"focusHighlight":{"$ref":"types.ChromeSetting","value":["focusHighlight",{"type":"boolean"}],"platforms":["chromeos"]},"selectToSpeak":{"$ref":"types.ChromeSetting","value":["selectToSpeak",{"type":"boolean"}],"platforms":["chromeos"]},"switchAccess":{"$ref":"types.ChromeSetting","value":["switchAccess",{"type":"boolean"}],"platforms":["chromeos"]},"animationPolicy":{"$ref":"types.ChromeSetting","value":["animationPolicy",{"type":"string","enum":[{"name":"allowed"},{"name":"once"},{"name":"none"}]}]},"dictation":{"$ref":"types.ChromeSetting","value":["dictation",{"type":"boolean"}],"platforms":["chromeos"]}}})R";
constexpr char kExperimentalActor[] = R"R({"namespace":"experimentalActor","types":[],"functions":[{"parameters":[{"name":"taskId","type":"integer"}],"returns_async":{"name":"stopTaskcallback","parameters":[]},"name":"stopTask","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"taskId","type":"integer"}]},"name":"createTask","type":"function"},{"parameters":[{"name":"actionsProto","type":"binary","isInstanceOf":"ArrayBuffer"}],"returns_async":{"name":"callback","parameters":[{"name":"data","type":"binary","isInstanceOf":"ArrayBuffer"}]},"name":"performActions","type":"function"},{"parameters":[{"name":"tabId","type":"integer"}],"returns_async":{"name":"callback","parameters":[{"name":"data","type":"binary","isInstanceOf":"ArrayBuffer"}]},"name":"requestTabObservation","type":"function"}],"properties":{},"events":[],"platforms":null,"deprecated":null})R";
constexpr char kExperimentalAiData[] = R"R({"namespace":"experimentalAiData","types":[],"functions":[{"parameters":[{"name":"domNodeId","type":"integer"},{"name":"frameId","type":"string"},{"name":"userInput","type":"string"},{"name":"tabId","type":"integer"}],"returns_async":{"name":"callback","parameters":[{"name":"data","type":"binary","isInstanceOf":"ArrayBuffer"}]},"name":"getAiData","type":"function"},{"parameters":[{"name":"tabId","type":"integer"},{"name":"aiDataSpecifier","type":"binary","isInstanceOf":"ArrayBuffer"}],"returns_async":{"name":"callback","parameters":[{"name":"data","type":"binary","isInstanceOf":"ArrayBuffer"}]},"name":"getAiDataWithSpecifier","type":"function"}],"properties":{},"events":[],"platforms":null,"deprecated":null})R";
constexpr char kAutofillPrivate[] = R"R({"namespace":"autofillPrivate","types":[{"id":"autofillPrivate.AccountInfo","properties":{"email":{"name":"email","type":"string"},"isSyncEnabledForAutofillProfiles":{"name":"isSyncEnabledForAutofillProfiles","type":"boolean"},"isEligibleForAddressAccountStorage":{"name":"isEligibleForAddressAccountStorage","type":"boolean"},"isAutofillSyncToggleAvailable":{"name":"isAutofillSyncToggleAvailable","type":"boolean"},"isAutofillSyncToggleEnabled":{"name":"isAutofillSyncToggleEnabled","type":"boolean"}},"type":"object"},{"id":"autofillPrivate.FieldType","type":"string","enum":[{"name":"NO_SERVER_DATA"},{"name":"UNKNOWN_TYPE"},{"name":"EMPTY_TYPE"},{"name":"NAME_FIRST"},{"name":"NAME_MIDDLE"},{"name":"NAME_LAST"},{"name":"NAME_MIDDLE_INITIAL"},{"name":"NAME_FULL"},{"name":"NAME_SUFFIX"},{"name":"ALTERNATIVE_FULL_NAME"},{"name":"ALTERNATIVE_GIVEN_NAME"},{"name":"ALTERNATIVE_FAMILY_NAME"},{"name":"EMAIL_ADDRESS"},{"name":"PHONE_HOME_NUMBER"},{"name":"PHONE_HOME_CITY_CODE"},{"name":"PHONE_HOME_COUNTRY_CODE"},{"name":"PHONE_HOME_CITY_AND_NUMBER"},{"name":"PHONE_HOME_WHOLE_NUMBER"},{"name":"ADDRESS_HOME_LINE1"},{"name":"ADDRESS_HOME_LINE2"},{"name":"ADDRESS_HOME_APT_NUM"},{"name":"ADDRESS_HOME_CITY"},{"name":"ADDRESS_HOME_STATE"},{"name":"ADDRESS_HOME_ZIP"},{"name":"ADDRESS_HOME_COUNTRY"},{"name":"CREDIT_CARD_NAME_FULL"},{"name":"CREDIT_CARD_NUMBER"},{"name":"CREDIT_CARD_EXP_MONTH"},{"name":"CREDIT_CARD_EXP_2_DIGIT_YEAR"},{"name":"CREDIT_CARD_EXP_4_DIGIT_YEAR"},{"name":"CREDIT_CARD_EXP_DATE_2_DIGIT_YEAR"},{"name":"CREDIT_CARD_EXP_DATE_4_DIGIT_YEAR"},{"name":"CREDIT_CARD_TYPE"},{"name":"CREDIT_CARD_VERIFICATION_CODE"},{"name":"COMPANY_NAME"},{"name":"MERCHANT_EMAIL_SIGNUP"},{"name":"MERCHANT_PROMO_CODE"},{"name":"PASSWORD"},{"name":"ACCOUNT_CREATION_PASSWORD"},{"name":"ADDRESS_HOME_STREET_ADDRESS"},{"name":"ADDRESS_HOME_SORTING_CODE"},{"name":"ADDRESS_HOME_DEPENDENT_LOCALITY"},{"name":"ADDRESS_HOME_LINE3"},{"name":"NOT_ACCOUNT_CREATION_PASSWORD"},{"name":"USERNAME"},{"name":"USERNAME_AND_EMAIL_ADDRESS"},{"name":"NEW_PASSWORD"},{"name":"PROBABLY_NEW_PASSWORD"},{"name":"NOT_NEW_PASSWORD"},{"name":"CREDIT_CARD_NAME_FIRST"},{"name":"CREDIT_CARD_NAME_LAST"},{"name":"PHONE_HOME_EXTENSION"},{"name":"CONFIRMATION_PASSWORD"},{"name":"AMBIGUOUS_TYPE"},{"name":"SEARCH_TERM"},{"name":"PRICE"},{"name":"NOT_PASSWORD"},{"name":"SINGLE_USERNAME"},{"name":"NOT_USERNAME"},{"name":"UPI_VPA"},{"name":"ADDRESS_HOME_STREET_NAME"},{"name":"ADDRESS_HOME_HOUSE_NUMBER"},{"name":"ADDRESS_HOME_SUBPREMISE"},{"name":"ADDRESS_HOME_OTHER_SUBUNIT"},{"name":"NAME_LAST_PREFIX"},{"name":"NAME_LAST_CORE"},{"name":"NAME_LAST_FIRST"},{"name":"NAME_LAST_CONJUNCTION"},{"name":"NAME_LAST_SECOND"},{"name":"NAME_HONORIFIC_PREFIX"},{"name":"ADDRESS_HOME_ADDRESS"},{"name":"ADDRESS_HOME_ADDRESS_WITH_NAME"},{"name":"ADDRESS_HOME_FLOOR"},{"name":"PHONE_HOME_CITY_CODE_WITH_TRUNK_PREFIX"},{"name":"PHONE_HOME_CITY_AND_NUMBER_WITHOUT_TRUNK_PREFIX"},{"name":"PHONE_HOME_NUMBER_PREFIX"},{"name":"PHONE_HOME_NUMBER_SUFFIX"},{"name":"IBAN_VALUE"},{"name":"CREDIT_CARD_STANDALONE_VERIFICATION_CODE"},{"name":"NUMERIC_QUANTITY"},{"name":"ONE_TIME_CODE"},{"name":"DELIVERY_INSTRUCTIONS"},{"name":"ADDRESS_HOME_OVERFLOW"},{"name":"ADDRESS_HOME_LANDMARK"},{"name":"ADDRESS_HOME_OVERFLOW_AND_LANDMARK"},{"name":"ADDRESS_HOME_ADMIN_LEVEL2"},{"name":"ADDRESS_HOME_STREET_LOCATION"},{"name":"ADDRESS_HOME_BETWEEN_STREETS"},{"name":"ADDRESS_HOME_BETWEEN_STREETS_OR_LANDMARK"},{"name":"ADDRESS_HOME_STREET_LOCATION_AND_LOCALITY"},{"name":"ADDRESS_HOME_STREET_LOCATION_AND_LANDMARK"},{"name":"ADDRESS_HOME_DEPENDENT_LOCALITY_AND_LANDMARK"},{"name":"ADDRESS_HOME_BETWEEN_STREETS_1"},{"name":"ADDRESS_HOME_BETWEEN_STREETS_2"},{"name":"SINGLE_USERNAME_FORGOT_PASSWORD"},{"name":"ADDRESS_HOME_APT"},{"name":"ADDRESS_HOME_APT_TYPE"},{"name":"ADDRESS_HOME_HOUSE_NUMBER_AND_APT"},{"name":"SINGLE_USERNAME_WITH_INTERMEDIATE_VALUES"},{"name":"PASSPORT_NUMBER"},{"name":"PASSPORT_ISSUING_COUNTRY"},{"name":"PASSPORT_EXPIRATION_DATE"},{"name":"PASSPORT_ISSUE_DATE"},{"name":"LOYALTY_MEMBERSHIP_PROGRAM"},{"name":"LOYALTY_MEMBERSHIP_PROVIDER"},{"name":"LOYALTY_MEMBERSHIP_ID"},{"name":"VEHICLE_LICENSE_PLATE"},{"name":"VEHICLE_VIN"},{"name":"VEHICLE_MAKE"},{"name":"VEHICLE_MODEL"},{"name":"DRIVERS_LICENSE_REGION"},{"name":"DRIVERS_LICENSE_NUMBER"},{"name":"DRIVERS_LICENSE_EXPIRATION_DATE"},{"name":"DRIVERS_LICENSE_ISSUE_DATE"},{"name":"VEHICLE_YEAR"},{"name":"VEHICLE_PLATE_STATE"},{"name":"EMAIL_OR_LOYALTY_MEMBERSHIP_ID"},{"name":"NATIONAL_ID_CARD_NUMBER"},{"name":"NATIONAL_ID_CARD_EXPIRATION_DATE"},{"name":"NATIONAL_ID_CARD_ISSUE_DATE"},{"name":"NATIONAL_ID_CARD_ISSUING_COUNTRY"},{"name":"KNOWN_TRAVELER_NUMBER"},{"name":"KNOWN_TRAVELER_NUMBER_EXPIRATION_DATE"},{"name":"REDRESS_NUMBER"},{"name":"ADDRESS_HOME_ZIP_PREFIX"},{"name":"ADDRESS_HOME_ZIP_SUFFIX"},{"name":"FLIGHT_RESERVATION_FLIGHT_NUMBER"},{"name":"FLIGHT_RESERVATION_TICKET_NUMBER"},{"name":"FLIGHT_RESERVATION_CONFIRMATION_CODE"},{"name":"FLIGHT_RESERVATION_PASSENGER_NAME"},{"name":"FLIGHT_RESERVATION_DEPARTURE_AIRPORT"},{"name":"FLIGHT_RESERVATION_ARRIVAL_AIRPORT"},{"name":"FLIGHT_RESERVATION_DEPARTURE_DATE"},{"name":"MAX_VALID_FIELD_TYPE"}]},{"id":"autofillPrivate.AddressRecordType","type":"string","enum":[{"name":"LOCAL_OR_SYNCABLE"},{"name":"ACCOUNT"},{"name":"ACCOUNT_HOME"},{"name":"ACCOUNT_WORK"},{"name":"ACCOUNT_NAME_EMAIL"}]},{"id":"autofillPrivate.AttributeTypeDataType","type":"string","enum":[{"name":"COUNTRY"},{"name":"DATE"},{"name":"STRING"}]},{"id":"autofillPrivate.AutofillMetadata","properties":{"summaryLabel":{"name":"summaryLabel","type":"string"},"summarySublabel":{"optional":true,"name":"summarySublabel","type":"string"},"recordType":{"optional":true,"name":"recordType","$ref":"autofillPrivate.AddressRecordType"},"isLocal":{"optional":true,"name":"isLocal","type":"boolean"},"isMigratable":{"optional":true,"name":"isMigratable","type":"boolean"},"isVirtualCardEnrollmentEligible":{"optional":true,"name":"isVirtualCardEnrollmentEligible","type":"boolean"},"isVirtualCardEnrolled":{"optional":true,"name":"isVirtualCardEnrolled","type":"boolean"}},"type":"object"},{"id":"autofillPrivate.AddressField","properties":{"type":{"name":"type","$ref":"autofillPrivate.FieldType"},"value":{"name":"value","type":"string"}},"type":"object"},{"id":"autofillPrivate.AddressEntry","properties":{"guid":{"optional":true,"name":"guid","type":"string"},"fields":{"name":"fields","type":"array","items":{"$ref":"autofillPrivate.AddressField"}},"languageCode":{"optional":true,"name":"languageCode","type":"string"},"metadata":{"optional":true,"name":"metadata","$ref":"autofillPrivate.AutofillMetadata"}},"type":"object"},{"id":"autofillPrivate.CountryEntry","properties":{"name":{"optional":true,"name":"name","type":"string"},"countryCode":{"optional":true,"name":"countryCode","type":"string"}},"type":"object"},{"id":"autofillPrivate.AddressComponent","properties":{"field":{"name":"field","$ref":"autofillPrivate.FieldType"},"fieldName":{"name":"fieldName","type":"string"},"isLongField":{"name":"isLongField","type":"boolean"},"isRequired":{"name":"isRequired","type":"boolean"},"placeholder":{"optional":true,"name":"placeholder","type":"string"}},"type":"object"},{"id":"autofillPrivate.AddressComponentRow","properties":{"row":{"name":"row","type":"array","items":{"$ref":"autofillPrivate.AddressComponent"}}},"type":"object"},{"id":"autofillPrivate.AddressComponents","properties":{"components":{"name":"components","type":"array","items":{"$ref":"autofillPrivate.AddressComponentRow"}},"languageCode":{"name":"languageCode","type":"string"}},"type":"object"},{"id":"autofillPrivate.CreditCardEntry","properties":{"guid":{"optional":true,"name":"guid","type":"string"},"instrumentId":{"optional":true,"name":"instrumentId","type":"string"},"name":{"optional":true,"name":"name","type":"string"},"cardNumber":{"optional":true,"name":"cardNumber","type":"string"},"expirationMonth":{"optional":true,"name":"expirationMonth","type":"string"},"expirationYear":{"optional":true,"name":"expirationYear","type":"string"},"nickname":{"optional":true,"name":"nickname","type":"string"},"network":{"optional":true,"name":"network","type")R" R"R(:"string"},"imageSrc":{"optional":true,"name":"imageSrc","type":"string"},"cvc":{"optional":true,"name":"cvc","type":"string"},"productTermsUrl":{"optional":true,"name":"productTermsUrl","type":"string"},"metadata":{"optional":true,"name":"metadata","$ref":"autofillPrivate.AutofillMetadata"}},"type":"object"},{"id":"autofillPrivate.IbanEntry","properties":{"guid":{"optional":true,"name":"guid","type":"string"},"instrumentId":{"optional":true,"name":"instrumentId","type":"string"},"value":{"optional":true,"name":"value","type":"string"},"nickname":{"optional":true,"name":"nickname","type":"string"},"metadata":{"optional":true,"name":"metadata","$ref":"autofillPrivate.AutofillMetadata"}},"type":"object"},{"id":"autofillPrivate.AttributeType","properties":{"typeName":{"name":"typeName","type":"integer"},"typeNameAsString":{"name":"typeNameAsString","type":"string"},"dataType":{"name":"dataType","$ref":"autofillPrivate.AttributeTypeDataType"}},"type":"object"},{"id":"autofillPrivate.EntityType","properties":{"typeName":{"name":"typeName","type":"integer"},"typeNameAsString":{"name":"typeNameAsString","type":"string"},"addEntityTypeString":{"name":"addEntityTypeString","type":"string"},"editEntityTypeString":{"name":"editEntityTypeString","type":"string"},"deleteEntityTypeString":{"name":"deleteEntityTypeString","type":"string"},"supportsWalletStorage":{"name":"supportsWalletStorage","type":"boolean"}},"type":"object"},{"id":"autofillPrivate.DateValue","properties":{"year":{"name":"year","type":"string"},"month":{"name":"month","type":"string"},"day":{"name":"day","type":"string"}},"type":"object"},{"id":"autofillPrivate.AttributeInstance","properties":{"type":{"name":"type","$ref":"autofillPrivate.AttributeType"},"value":{"name":"value","choices":[{"type":"string"},{"$ref":"autofillPrivate.DateValue"}]}},"type":"object"},{"id":"autofillPrivate.EntityInstance","properties":{"type":{"name":"type","$ref":"autofillPrivate.EntityType"},"attributeInstances":{"name":"attributeInstances","type":"array","items":{"$ref":"autofillPrivate.AttributeInstance"}},"guid":{"name":"guid","type":"string"},"nickname":{"name":"nickname","type":"string"}},"type":"object"},{"id":"autofillPrivate.EntityInstanceWithLabels","properties":{"guid":{"name":"guid","type":"string"},"type":{"name":"type","$ref":"autofillPrivate.EntityType"},"entityInstanceLabel":{"name":"entityInstanceLabel","type":"string"},"entityInstanceSubLabel":{"name":"entityInstanceSubLabel","type":"string"},"storedInWallet":{"name":"storedInWallet","type":"boolean"}},"type":"object"},{"id":"autofillPrivate.PayOverTimeIssuerEntry","properties":{"issuerId":{"optional":true,"name":"issuerId","type":"string"},"instrumentId":{"optional":true,"name":"instrumentId","type":"string"},"displayName":{"optional":true,"name":"displayName","type":"string"},"imageSrc":{"optional":true,"name":"imageSrc","type":"string"},"imageSrcDark":{"optional":true,"name":"imageSrcDark","type":"string"}},"type":"object"}],"functions":[{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"accountInfo","optional":true,"$ref":"autofillPrivate.AccountInfo"}]},"name":"getAccountInfo","type":"function"},{"parameters":[{"name":"address","$ref":"autofillPrivate.AddressEntry"}],"name":"saveAddress","type":"function"},{"parameters":[{"name":"guid","type":"string"}],"name":"removeAddress","type":"function"},{"parameters":[{"name":"forAccountStorage","type":"boolean"}],"returns_async":{"name":"callback","parameters":[{"name":"countries","type":"array","items":{"$ref":"autofillPrivate.CountryEntry"}}]},"name":"getCountryList","type":"function"},{"parameters":[{"name":"countryCode","type":"string"}],"returns_async":{"name":"callback","parameters":[{"name":"components","$ref":"autofillPrivate.AddressComponents"}]},"name":"getAddressComponents","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"entries","type":"array","items":{"$ref":"autofillPrivate.AddressEntry"}}]},"name":"getAddressList","type":"function"},{"parameters":[{"name":"card","$ref":"autofillPrivate.CreditCardEntry"}],"name":"saveCreditCard","type":"function"},{"parameters":[{"name":"iban","$ref":"autofillPrivate.IbanEntry"}],"name":"saveIban","type":"function"},{"parameters":[{"name":"guid","type":"string"}],"name":"removePaymentsEntity","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"entries","type":"array","items":{"$ref":"autofillPrivate.CreditCardEntry"}}]},"name":"getCreditCardList","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"entries","type":"array","items":{"$ref":"autofillPrivate.IbanEntry"}}]},"name":"getIbanList","type":"function"},{"parameters":[{"name":"ibanValue","type":"string"}],"returns_async":{"name":"callback","parameters":[{"name":"isValid","type":"boolean"}]},"name":"isValidIban","type":"function"},{"parameters":[],"name":"logServerCardLinkClicked","type":"function"},{"parameters":[],"name":"logServerIbanLinkClicked","type":"function"},{"parameters":[{"name":"cardId","type":"string"}],"name":"addVirtualCard","type":"function"},{"parameters":[{"name":"cardId","type":"string"}],"name":"removeVirtualCard","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"entries","type":"array","items":{"$ref":"autofillPrivate.PayOverTimeIssuerEntry"}}]},"name":"getPayOverTimeIssuerList","type":"function"},{"parameters":[],"name":"authenticateUserAndFlipMandatoryAuthToggle","type":"function"},{"parameters":[{"name":"guid","type":"string"}],"returns_async":{"name":"callback","parameters":[{"name":"card","optional":true,"$ref":"autofillPrivate.CreditCardEntry"}]},"name":"getLocalCard","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"isDeviceAuthAvailable","type":"boolean"}]},"name":"checkIfDeviceAuthAvailable","type":"function"},{"parameters":[],"name":"bulkDeleteAllCvcs","type":"function"},{"parameters":[{"name":"enabled","type":"boolean"}],"name":"setAutofillSyncToggleEnabled","type":"function"},{"parameters":[{"name":"entityInstance","$ref":"autofillPrivate.EntityInstance"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"addOrUpdateEntityInstance","type":"function"},{"parameters":[{"name":"guid","type":"string"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"removeEntityInstance","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"entries","type":"array","items":{"$ref":"autofillPrivate.EntityInstanceWithLabels"}}]},"name":"loadEntityInstances","type":"function"},{"parameters":[{"name":"guid","type":"string"}],"returns_async":{"name":"callback","parameters":[{"name":"entityInstance","$ref":"autofillPrivate.EntityInstance"}]},"name":"getEntityInstanceByGuid","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"entityTypes","type":"array","items":{"$ref":"autofillPrivate.EntityType"}}]},"name":"getWritableEntityTypes","type":"function"},{"parameters":[{"name":"entityTypeName","type":"integer"}],"returns_async":{"name":"callback","parameters":[{"name":"attributeTypes","type":"array","items":{"$ref":"autofillPrivate.AttributeType"}}]},"name":"getAllAttributeTypesForEntityTypeName","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"optedIn","type":"boolean"}]},"name":"getAutofillAiOptInStatus","type":"function"},{"parameters":[{"name":"optedIn","type":"boolean"}],"returns_async":{"name":"callback","parameters":[{"name":"success","type":"boolean"}]},"name":"setAutofillAiOptInStatus","type":"function"}],"properties":{},"events":[{"parameters":[{"name":"addressEntries","type":"array","items":{"$ref":"autofillPrivate.AddressEntry"}},{"name":"creditCardEntries","type":"array","items":{"$ref":"autofillPrivate.CreditCardEntry"}},{"name":"ibans","type":"array","items":{"$ref":"autofillPrivate.IbanEntry"}},{"name":"payOverTimeIssuers","type":"array","items":{"$ref":"autofillPrivate.PayOverTimeIssuerEntry"}},{"name":"accountInfo","optional":true,"$ref":"autofillPrivate)R" R"R(.AccountInfo"}],"name":"onPersonalDataChanged","type":"function"},{"parameters":[{"name":"entityInstancesWithLabels","type":"array","items":{"$ref":"autofillPrivate.EntityInstanceWithLabels"}}],"name":"onEntityInstancesChanged","type":"function"}],"platforms":null,"deprecated":null})R";
constexpr char kAutotestPrivate[] = R"R({"namespace":"autotestPrivate","types":[{"id":"autotestPrivate.ShelfAlignmentType","type":"string","enum":[{"name":"Bottom"},{"name":"Left"},{"name":"Right"}]},{"id":"autotestPrivate.ShelfItemType","type":"string","enum":[{"name":"PinnedApp"},{"name":"BrowserShortcut"},{"name":"App"},{"name":"UnpinnedBrowserShortcut"},{"name":"Dialog"}]},{"id":"autotestPrivate.ShelfItemStatus","type":"string","enum":[{"name":"Closed"},{"name":"Running"},{"name":"Attention"}]},{"id":"autotestPrivate.AppType","type":"string","enum":[{"name":"Arc"},{"name":"Crostini"},{"name":"Extension"},{"name":"Web"},{"name":"MacOS"},{"name":"PluginVm"},{"name":"StandaloneBrowser"},{"name":"Remote"},{"name":"Borealis"},{"name":"Bruschetta"}]},{"id":"autotestPrivate.AppInstallSource","type":"string","enum":[{"name":"Unknown"},{"name":"System"},{"name":"Policy"},{"name":"Oem"},{"name":"Default"},{"name":"Sync"},{"name":"User"},{"name":"SubApp"},{"name":"Kiosk"},{"name":"CommandLine"}]},{"id":"autotestPrivate.AppReadiness","type":"string","enum":[{"name":"Ready"},{"name":"DisabledByBlacklist"},{"name":"DisabledByPolicy"},{"name":"DisabledByUser"},{"name":"Terminated"},{"name":"UninstalledByUser"},{"name":"Removed"},{"name":"UninstalledByMigration"},{"name":"DisabledByLocalSettings"}]},{"id":"autotestPrivate.WakefulnessMode","type":"string","enum":[{"name":"Unknown"},{"name":"Asleep"},{"name":"Awake"},{"name":"Dreaming"},{"name":"Dozing"}]},{"id":"autotestPrivate.WindowStateType","type":"string","enum":[{"name":"Normal"},{"name":"Minimized"},{"name":"Maximized"},{"name":"Fullscreen"},{"name":"PrimarySnapped"},{"name":"SecondarySnapped"},{"name":"Pinned"},{"name":"TrustedPinned"},{"name":"PIP"},{"name":"Floated"}]},{"id":"autotestPrivate.WMEventType","type":"string","enum":[{"name":"WMEventNormal"},{"name":"WMEventMaximize"},{"name":"WMEventMinimize"},{"name":"WMEventFullscreen"},{"name":"WMEventSnapPrimary"},{"name":"WMEventSnapSecondary"},{"name":"WMEventFloat"}]},{"id":"autotestPrivate.RotationType","type":"string","enum":[{"name":"RotateAny"},{"name":"Rotate0"},{"name":"Rotate90"},{"name":"Rotate180"},{"name":"Rotate270"}]},{"id":"autotestPrivate.LauncherStateType","type":"string","enum":[{"name":"Closed"},{"name":"FullscreenAllApps"},{"name":"FullscreenSearch"}]},{"id":"autotestPrivate.OverviewStateType","type":"string","enum":[{"name":"Shown"},{"name":"Hidden"}]},{"id":"autotestPrivate.MouseButton","type":"string","enum":[{"name":"Left"},{"name":"Middle"},{"name":"Right"},{"name":"Back"},{"name":"Forward"}]},{"id":"autotestPrivate.WindowStateChangeDict","properties":{"eventType":{"name":"eventType","$ref":"autotestPrivate.WMEventType"},"failIfNoChange":{"optional":true,"name":"failIfNoChange","type":"boolean"}},"type":"object"},{"id":"autotestPrivate.LoginStatusDict","properties":{"isLoggedIn":{"name":"isLoggedIn","type":"boolean"},"isOwner":{"name":"isOwner","type":"boolean"},"isScreenLocked":{"name":"isScreenLocked","type":"boolean"},"isLockscreenWallpaperAnimating":{"name":"isLockscreenWallpaperAnimating","type":"boolean"},"isReadyForPassword":{"name":"isReadyForPassword","type":"boolean"},"areAllUserImagesLoaded":{"name":"areAllUserImagesLoaded","type":"boolean"},"isRegularUser":{"optional":true,"name":"isRegularUser","type":"boolean"},"isGuest":{"optional":true,"name":"isGuest","type":"boolean"},"isKiosk":{"optional":true,"name":"isKiosk","type":"boolean"},"email":{"optional":true,"name":"email","type":"string"},"displayEmail":{"optional":true,"name":"displayEmail","type":"string"},"displayName":{"optional":true,"name":"displayName","type":"string"},"userImage":{"optional":true,"name":"userImage","type":"string"},"hasValidOauth2Token":{"optional":true,"name":"hasValidOauth2Token","type":"boolean"}},"type":"object"},{"id":"autotestPrivate.ExtensionInfoDict","properties":{"id":{"name":"id","type":"string"},"version":{"name":"version","type":"string"},"name":{"name":"name","type":"string"},"publicKey":{"name":"publicKey","type":"string"},"description":{"name":"description","type":"string"},"backgroundUrl":{"name":"backgroundUrl","type":"string"},"optionsUrl":{"name":"optionsUrl","type":"string"},"hostPermissions":{"name":"hostPermissions","type":"array","items":{"type":"string"}},"effectiveHostPermissions":{"name":"effectiveHostPermissions","type":"array","items":{"type":"string"}},"apiPermissions":{"name":"apiPermissions","type":"array","items":{"type":"string"}},"isComponent":{"name":"isComponent","type":"boolean"},"isInternal":{"name":"isInternal","type":"boolean"},"isUserInstalled":{"name":"isUserInstalled","type":"boolean"},"isEnabled":{"name":"isEnabled","type":"boolean"},"allowedInIncognito":{"name":"allowedInIncognito","type":"boolean"},"hasPageAction":{"name":"hasPageAction","type":"boolean"}},"type":"object"},{"id":"autotestPrivate.ExtensionsInfoArray","properties":{"extensions":{"name":"extensions","type":"array","items":{"$ref":"autotestPrivate.ExtensionInfoDict"}}},"type":"object"},{"id":"autotestPrivate.Notification","properties":{"id":{"name":"id","type":"string"},"type":{"name":"type","type":"string"},"title":{"name":"title","type":"string"},"message":{"name":"message","type":"string"},"priority":{"name":"priority","type":"integer"},"progress":{"name":"progress","type":"integer"}},"type":"object"},{"id":"autotestPrivate.Printer","properties":{"printerName":{"name":"printerName","type":"string"},"printerId":{"optional":true,"name":"printerId","type":"string"},"printerType":{"optional":true,"name":"printerType","type":"string"},"printerDesc":{"optional":true,"name":"printerDesc","type":"string"},"printerMakeAndModel":{"optional":true,"name":"printerMakeAndModel","type":"string"},"printerUri":{"optional":true,"name":"printerUri","type":"string"},"printerPpd":{"optional":true,"name":"printerPpd","type":"string"}},"type":"object"},{"id":"autotestPrivate.ArcState","properties":{"provisioned":{"name":"provisioned","type":"boolean"},"tosNeeded":{"name":"tosNeeded","type":"boolean"},"preStartTime":{"name":"preStartTime","type":"number"},"startTime":{"name":"startTime","type":"number"}},"type":"object"},{"id":"autotestPrivate.PlayStoreState","properties":{"allowed":{"name":"allowed","type":"boolean"},"enabled":{"optional":true,"name":"enabled","type":"boolean"},"managed":{"optional":true,"name":"managed","type":"boolean"}},"type":"object"},{"id":"autotestPrivate.AssistantQueryResponse","properties":{"text":{"optional":true,"name":"text","type":"string"},"htmlResponse":{"optional":true,"name":"htmlResponse","type":"string"},"openUrl":{"optional":true,"name":"openUrl","type":"string"},"openAppResponse":{"optional":true,"name":"openAppResponse","type":"string"}},"type":"object"},{"id":"autotestPrivate.AssistantQueryStatus","properties":{"isMicOpen":{"name":"isMicOpen","type":"boolean"},"queryText":{"name":"queryText","type":"string"},"queryResponse":{"name":"queryResponse","$ref":"autotestPrivate.AssistantQueryResponse"}},"type":"object"},{"id":"autotestPrivate.ArcAppDict","properties":{"name":{"name":"name","type":"string"},"packageName":{"name":"packageName","type":"string"},"activity":{"name":"activity","type":"string"},"intentUri":{"name":"intentUri","type":"string"},"iconResourceId":{"name":"iconResourceId","type":"string"},"lastLaunchTime":{"name":"lastLaunchTime","type":"number"},"installTime":{"name":"installTime","type":"number"},"sticky":{"name":"sticky","type":"boolean"},"notificationsEnabled":{"name":"notificationsEnabled","type":"boolean"},"ready":{"name":"ready","type":"boolean"},"suspended":{"name":"suspended","type":"boolean"},"showInLauncher":{"name":"showInLauncher","type":"boolean"},"shortcut":{"name":"shortcut","type":"boolean"},"launchable":{"name":"launchable","type":"boolean"}},"type":"object"},{"id":"autotestPrivate.ArcAppKillsDict","properties":{"oom":{"name":"oom","type":"number"},"lmkdForeground":{"name":"lmkdForeground","type":"number"},"lmkdPerceptible":{"name":"lmkdPerceptible","type":"number"},"lmkdCached":{"name":"lmkdCached","type":"number"},"pressureForeground":{"name":"pressureForeground","type":"number"},"pressurePerceptible":{"name":"pressurePerceptible","type":"number"},"pressureCached":{"name":"pressureCached","type":"number")R" R"R(}},"type":"object"},{"id":"autotestPrivate.ArcPackageDict","properties":{"packageName":{"name":"packageName","type":"string"},"packageVersion":{"name":"packageVersion","type":"integer"},"lastBackupAndroidId":{"name":"lastBackupAndroidId","type":"string"},"lastBackupTime":{"name":"lastBackupTime","type":"number"},"shouldSync":{"name":"shouldSync","type":"boolean"},"vpnProvider":{"name":"vpnProvider","type":"boolean"}},"type":"object"},{"id":"autotestPrivate.Location","properties":{"x":{"name":"x","type":"number"},"y":{"name":"y","type":"number"}},"type":"object"},{"id":"autotestPrivate.Bounds","properties":{"left":{"name":"left","type":"number"},"top":{"name":"top","type":"number"},"width":{"name":"width","type":"number"},"height":{"name":"height","type":"number"}},"type":"object"},{"id":"autotestPrivate.ArcAppTracingInfo","properties":{"success":{"name":"success","type":"boolean"},"fps":{"name":"fps","type":"number"},"perceivedFps":{"name":"perceivedFps","type":"number"},"commitDeviation":{"name":"commitDeviation","type":"number"},"presentDeviation":{"name":"presentDeviation","type":"number"},"renderQuality":{"name":"renderQuality","type":"number"},"janksPerMinute":{"name":"janksPerMinute","type":"number"},"janksPercentage":{"name":"janksPercentage","type":"number"}},"type":"object"},{"id":"autotestPrivate.ThemeStyle","type":"string","enum":[{"name":"TonalSpot"},{"name":"Vibrant"},{"name":"Expressive"},{"name":"Spritz"},{"name":"Rainbow"},{"name":"FruitSalad"}]},{"id":"autotestPrivate.App","properties":{"appId":{"name":"appId","type":"string"},"name":{"name":"name","type":"string"},"shortName":{"name":"shortName","type":"string"},"publisherId":{"name":"publisherId","type":"string"},"type":{"optional":true,"name":"type","$ref":"autotestPrivate.AppType"},"installSource":{"optional":true,"name":"installSource","$ref":"autotestPrivate.AppInstallSource"},"readiness":{"optional":true,"name":"readiness","$ref":"autotestPrivate.AppReadiness"},"additionalSearchTerms":{"name":"additionalSearchTerms","type":"array","items":{"type":"string"}},"showInLauncher":{"optional":true,"name":"showInLauncher","type":"boolean"},"showInSearch":{"optional":true,"name":"showInSearch","type":"boolean"}},"type":"object"},{"id":"autotestPrivate.SystemWebApp","properties":{"internalName":{"name":"internalName","type":"string"},"url":{"name":"url","type":"string"},"name":{"name":"name","type":"string"},"startUrl":{"name":"startUrl","type":"string"}},"type":"object"},{"id":"autotestPrivate.ShelfItem","properties":{"appId":{"name":"appId","type":"string"},"launchId":{"name":"launchId","type":"string"},"title":{"name":"title","type":"string"},"type":{"optional":true,"name":"type","$ref":"autotestPrivate.ShelfItemType"},"status":{"name":"status","$ref":"autotestPrivate.ShelfItemStatus"},"showsTooltip":{"name":"showsTooltip","type":"boolean"},"pinnedByPolicy":{"name":"pinnedByPolicy","type":"boolean"},"pinStateForcedByType":{"name":"pinStateForcedByType","type":"boolean"},"hasNotification":{"name":"hasNotification","type":"boolean"}},"type":"object"},{"id":"autotestPrivate.AppWindowType","type":"string","enum":[{"name":"Browser"},{"name":"ChromeApp"},{"name":"ArcApp"},{"name":"CrostiniApp"},{"name":"SystemApp"},{"name":"ExtensionApp"},{"name":"Lacros"}]},{"id":"autotestPrivate.HotseatState","type":"string","enum":[{"name":"Hidden"},{"name":"ShownClamShell"},{"name":"ShownHomeLauncher"},{"name":"Extended"}]},{"id":"autotestPrivate.FrameMode","type":"string","enum":[{"name":"Normal"},{"name":"Immersive"}]},{"id":"autotestPrivate.OverviewInfo","properties":{"bounds":{"name":"bounds","$ref":"autotestPrivate.Bounds"},"isDragged":{"name":"isDragged","type":"boolean"}},"type":"object"},{"id":"autotestPrivate.ShelfIconPinUpdateParam","properties":{"appId":{"name":"appId","type":"string"},"pinned":{"name":"pinned","type":"boolean"}},"type":"object"},{"id":"autotestPrivate.AppWindowInfo","properties":{"id":{"name":"id","type":"integer"},"name":{"name":"name","type":"string"},"windowType":{"name":"windowType","$ref":"autotestPrivate.AppWindowType"},"stateType":{"name":"stateType","$ref":"autotestPrivate.WindowStateType"},"boundsInRoot":{"name":"boundsInRoot","$ref":"autotestPrivate.Bounds"},"displayId":{"name":"displayId","type":"string"},"isVisible":{"name":"isVisible","type":"boolean"},"canFocus":{"name":"canFocus","type":"boolean"},"title":{"name":"title","type":"string"},"isAnimating":{"name":"isAnimating","type":"boolean"},"targetBounds":{"name":"targetBounds","$ref":"autotestPrivate.Bounds"},"targetVisibility":{"name":"targetVisibility","type":"boolean"},"isActive":{"name":"isActive","type":"boolean"},"hasFocus":{"name":"hasFocus","type":"boolean"},"onActiveDesk":{"name":"onActiveDesk","type":"boolean"},"hasCapture":{"name":"hasCapture","type":"boolean"},"canResize":{"name":"canResize","type":"boolean"},"stackingOrder":{"name":"stackingOrder","type":"integer"},"frameMode":{"name":"frameMode","$ref":"autotestPrivate.FrameMode"},"isFrameVisible":{"name":"isFrameVisible","type":"boolean"},"captionHeight":{"name":"captionHeight","type":"integer"},"captionButtonEnabledStatus":{"name":"captionButtonEnabledStatus","type":"integer"},"captionButtonVisibleStatus":{"name":"captionButtonVisibleStatus","type":"integer"},"arcPackageName":{"optional":true,"name":"arcPackageName","type":"string"},"overviewInfo":{"optional":true,"name":"overviewInfo","$ref":"autotestPrivate.OverviewInfo"},"fullRestoreWindowAppId":{"optional":true,"name":"fullRestoreWindowAppId","type":"string"},"appId":{"optional":true,"name":"appId","type":"string"}},"type":"object"},{"id":"autotestPrivate.Accelerator","properties":{"keyCode":{"name":"keyCode","type":"string"},"shift":{"name":"shift","type":"boolean"},"control":{"name":"control","type":"boolean"},"alt":{"name":"alt","type":"boolean"},"search":{"name":"search","type":"boolean"},"pressed":{"name":"pressed","type":"boolean"}},"type":"object"},{"id":"autotestPrivate.ScrollableShelfState","properties":{"scrollDistance":{"optional":true,"name":"scrollDistance","type":"number"}},"type":"object"},{"id":"autotestPrivate.ShelfState","properties":{"scrollDistance":{"optional":true,"name":"scrollDistance","type":"number"}},"type":"object"},{"id":"autotestPrivate.ScrollableShelfInfo","properties":{"mainAxisOffset":{"name":"mainAxisOffset","type":"number"},"pageOffset":{"name":"pageOffset","type":"number"},"targetMainAxisOffset":{"optional":true,"name":"targetMainAxisOffset","type":"number"},"leftArrowBounds":{"name":"leftArrowBounds","$ref":"autotestPrivate.Bounds"},"rightArrowBounds":{"name":"rightArrowBounds","$ref":"autotestPrivate.Bounds"},"isAnimating":{"name":"isAnimating","type":"boolean"},"iconsUnderAnimation":{"name":"iconsUnderAnimation","type":"boolean"},"isOverflow":{"name":"isOverflow","type":"boolean"},"iconsBoundsInScreen":{"name":"iconsBoundsInScreen","type":"array","items":{"$ref":"autotestPrivate.Bounds"}},"isShelfWidgetAnimating":{"name":"isShelfWidgetAnimating","type":"boolean"}},"type":"object"},{"id":"autotestPrivate.HotseatSwipeDescriptor","properties":{"swipeStartLocation":{"name":"swipeStartLocation","$ref":"autotestPrivate.Location"},"swipeEndLocation":{"name":"swipeEndLocation","$ref":"autotestPrivate.Location"}},"type":"object"},{"id":"autotestPrivate.HotseatInfo","properties":{"swipeUp":{"name":"swipeUp","$ref":"autotestPrivate.HotseatSwipeDescriptor"},"state":{"name":"state","$ref":"autotestPrivate.HotseatState"},"isAnimating":{"name":"isAnimating","type":"boolean"},"isAutoHidden":{"name":"isAutoHidden","type":"boolean"}},"type":"object"},{"id":"autotestPrivate.ShelfUIInfo","properties":{"hotseatInfo":{"name":"hotseatInfo","$ref":"autotestPrivate.HotseatInfo"},"scrollableShelfInfo":{"name":"scrollableShelfInfo","$ref":"autotestPrivate.ScrollableShelfInfo"}},"type":"object"},{"id":"autotestPrivate.DesksInfo","properties":{"activeDeskIndex":{"name":"activeDeskIndex","type":"integer"},"numDesks":{"name":"numDesks","type":"integer"},"isAnimating":{"name":"isAnimating","type":"boolean"},"deskContainers":{"name":"deskContainers","type":"array","items":{"type":"string"}}},"type":"object"},{"id":"autotestPrivate.LauncherSearchBoxState","properties":{)R" R"R("ghostText":{"name":"ghostText","type":"string"}},"type":"object"},{"id":"autotestPrivate.FrameCountingPerSinkData","properties":{"sinkType":{"name":"sinkType","type":"string"},"isRoot":{"name":"isRoot","type":"boolean"},"debugLabel":{"name":"debugLabel","type":"string"},"presentedFrames":{"name":"presentedFrames","type":"array","items":{"type":"integer"}}},"type":"object"},{"id":"autotestPrivate.OverdrawData","properties":{"averageOverdraws":{"name":"averageOverdraws","type":"array","items":{"type":"number"}}},"type":"object"},{"id":"autotestPrivate.SetWindowBoundsResult","properties":{"bounds":{"name":"bounds","$ref":"autotestPrivate.Bounds"},"displayId":{"name":"displayId","type":"string"}},"type":"object"},{"id":"autotestPrivate.DisplaySmoothnessData","properties":{"framesExpected":{"name":"framesExpected","type":"integer"},"framesProduced":{"name":"framesProduced","type":"integer"},"jankCount":{"name":"jankCount","type":"integer"},"throughput":{"name":"throughput","type":"array","items":{"type":"integer"}},"jankTimestamps":{"name":"jankTimestamps","type":"array","items":{"type":"integer"}},"jankDurations":{"name":"jankDurations","type":"array","items":{"type":"integer"}}},"type":"object"},{"id":"autotestPrivate.ThroughputTrackerAnimationData","properties":{"startOffsetMs":{"name":"startOffsetMs","type":"integer"},"stopOffsetMs":{"name":"stopOffsetMs","type":"integer"},"framesExpected":{"name":"framesExpected","type":"integer"},"framesProduced":{"name":"framesProduced","type":"integer"},"jankCount":{"name":"jankCount","type":"integer"}},"type":"object"},{"id":"autotestPrivate.ResetHoldingSpaceOptions","properties":{"markTimeOfFirstAdd":{"name":"markTimeOfFirstAdd","type":"boolean"}},"type":"object"},{"id":"autotestPrivate.LoginEventRecorderData","properties":{"name":{"name":"name","type":"string"},"microsecnods_since_unix_epoch":{"name":"microsecnods_since_unix_epoch","type":"number"}},"type":"object"},{"id":"autotestPrivate.GetAccessTokenParams","properties":{"email":{"name":"email","type":"string"},"scopes":{"name":"scopes","type":"array","items":{"type":"string"}},"timeoutMs":{"optional":true,"name":"timeoutMs","type":"integer"}},"type":"object"},{"id":"autotestPrivate.GetAccessTokenData","properties":{"accessToken":{"name":"accessToken","type":"string"},"expirationTimeUnixMs":{"name":"expirationTimeUnixMs","type":"string"}},"type":"object"},{"id":"autotestPrivate.MakeFuseboxTempDirData","properties":{"fuseboxFilePath":{"name":"fuseboxFilePath","type":"string"},"underlyingFilePath":{"name":"underlyingFilePath","type":"string"}},"type":"object"},{"id":"autotestPrivate.GetCurrentInputMethodDescriptorData","properties":{"keyboardLayout":{"name":"keyboardLayout","type":"string"}},"type":"object"},{"id":"autotestPrivate.OrcaResponseArray","properties":{"responses":{"name":"responses","type":"array","items":{"type":"string"}}},"type":"object"},{"id":"autotestPrivate.ScannerResponseArray","properties":{"responses":{"name":"responses","type":"array","items":{"type":"string"}}},"type":"object"}],"functions":[{"parameters":[],"name":"initializeEvents","type":"function"},{"parameters":[],"name":"logout","type":"function"},{"parameters":[],"name":"restart","type":"function"},{"parameters":[{"name":"force","type":"boolean"}],"name":"shutdown","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"status","$ref":"autotestPrivate.LoginStatusDict"}]},"name":"loginStatus","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[]},"name":"waitForLoginAnimationEnd","type":"function"},{"parameters":[],"name":"lockScreen","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"info","$ref":"autotestPrivate.ExtensionsInfoArray"}]},"name":"getExtensionsInfo","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"all_policies","type":"any"}]},"name":"getAllEnterprisePolicies","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[]},"name":"refreshEnterprisePolicies","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[]},"name":"refreshRemoteCommands","type":"function"},{"parameters":[],"name":"simulateAsanMemoryBug","type":"function"},{"parameters":[{"name":"value","type":"integer"}],"name":"setTouchpadSensitivity","type":"function"},{"parameters":[{"name":"enabled","type":"boolean"}],"name":"setTapToClick","type":"function"},{"parameters":[{"name":"enabled","type":"boolean"}],"name":"setThreeFingerClick","type":"function"},{"parameters":[{"name":"enabled","type":"boolean"}],"name":"setTapDragging","type":"function"},{"parameters":[{"name":"enabled","type":"boolean"}],"name":"setNaturalScroll","type":"function"},{"parameters":[{"name":"value","type":"integer"}],"name":"setMouseSensitivity","type":"function"},{"parameters":[{"name":"right","type":"boolean"}],"name":"setPrimaryButtonRight","type":"function"},{"parameters":[{"name":"enabled","type":"boolean"}],"name":"setMouseReverseScroll","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"notifications","type":"array","items":{"$ref":"autotestPrivate.Notification"}}]},"name":"getVisibleNotifications","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[]},"name":"removeAllNotifications","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"startTicks","type":"number"}]},"name":"getArcStartTime","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"result","$ref":"autotestPrivate.ArcState"}]},"name":"getArcState","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"result","$ref":"autotestPrivate.PlayStoreState"}]},"name":"getPlayStoreState","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"printers","type":"array","items":{"$ref":"autotestPrivate.Printer"}}]},"name":"getPrinterList","type":"function"},{"parameters":[{"name":"appId","type":"string"}],"returns_async":{"name":"callback","parameters":[{"name":"appShown","type":"boolean"}]},"name":"isAppShown","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"arcProvisioned","type":"boolean"}]},"name":"isArcProvisioned","type":"function"},{"parameters":[{"name":"appId","type":"string"}],"returns_async":{"name":"callback","parameters":[{"name":"package","$ref":"autotestPrivate.ArcAppDict"}]},"name":"getArcApp","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"counts","$ref":"autotestPrivate.ArcAppKillsDict"}]},"name":"getArcAppKills","type":"function"},{"parameters":[{"name":"packageName","type":"string"}],"returns_async":{"name":"callback","parameters":[{"name":"package","$ref":"autotestPrivate.ArcPackageDict"}]},"name":"getArcPackage","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[]},"name":"waitForSystemWebAppsInstall","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"items","type":"array","items":{"type":"string"}}]},"name":"getDefaultPinnedAppIds","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"systemWebApps","type":"array","items":{"$ref":"autotestPrivate.SystemWebApp"}}]},"name":"getRegisteredSystemWebApps","type":"function"},{"parameters":[{"name":"appId","type":"string"}],"returns_async":{"name":"callback","parameters":[{"name":"isOpen","type":"boolean"}]},"name":"isSystemWebAppOpen","type":"function"},{"parameters":[{"name":"appId","type":"string"}],"returns_async":{"name":"callback","parameters":[]},"name":"launchApp","type":"function"},{"parameters":[{"name":"appName","type":"string"},{"name":"url","type":"string"}],"returns_async":{"name":"callback","parameters":[]},"name":"launchSystemWebApp","type":"function"},{"parameters":[{"name":"absolutePath","type":"string"}],"returns_async":{"name":"callback","parameters":[]},"name":"launchFilesAppToPath","type":"function"},{"parameters":[{"name":"appId)R" R"R(","type":"string"}],"returns_async":{"name":"callback","parameters":[]},"name":"closeApp","type":"function"},{"parameters":[{"name":"printer","$ref":"autotestPrivate.Printer"}],"name":"updatePrinter","type":"function"},{"parameters":[{"name":"printerId","type":"string"}],"name":"removePrinter","type":"function"},{"parameters":[{"name":"enabled","type":"boolean"}],"returns_async":{"name":"callback","parameters":[]},"name":"setPlayStoreEnabled","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"data","type":"string"}]},"name":"getClipboardTextData","type":"function"},{"parameters":[{"name":"data","type":"string"}],"returns_async":{"name":"callback","parameters":[]},"name":"setClipboardTextData","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[]},"name":"runCrostiniInstaller","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[]},"name":"runCrostiniUninstaller","type":"function"},{"parameters":[{"name":"enabled","type":"boolean"}],"returns_async":{"name":"callback","parameters":[]},"name":"setCrostiniEnabled","type":"function"},{"parameters":[{"name":"path","type":"string"}],"returns_async":{"name":"callback","parameters":[]},"name":"exportCrostini","type":"function"},{"parameters":[{"name":"path","type":"string"}],"returns_async":{"name":"callback","parameters":[]},"name":"importCrostini","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"canBeAllowed","type":"boolean"}]},"name":"couldAllowCrostini","type":"function"},{"parameters":[{"name":"imageUrl","type":"string"},{"name":"imageHash","type":"string"},{"name":"licenseKey","type":"string"}],"name":"setPluginVMPolicy","type":"function"},{"parameters":[],"name":"showPluginVMInstaller","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[]},"name":"installBorealis","type":"function"},{"parameters":[{"name":"name","type":"string"},{"name":"path","type":"string"}],"name":"registerComponent","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"base64Png","type":"string"}]},"name":"takeScreenshot","type":"function"},{"parameters":[{"name":"display_id","type":"string"}],"returns_async":{"name":"callback","parameters":[{"name":"base64Png","type":"string"}]},"name":"takeScreenshotForDisplay","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[]},"name":"loadSmartDimComponent","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"refreshed","type":"boolean"}]},"name":"isArcPackageListInitialRefreshed","type":"function"},{"parameters":[{"name":"pref_name","type":"string"},{"name":"value","type":"any"}],"returns_async":{"name":"callback","parameters":[]},"name":"setAllowedPref","type":"function"},{"parameters":[{"name":"pref_name","type":"string"}],"returns_async":{"name":"callback","parameters":[]},"name":"clearAllowedPref","type":"function"},{"parameters":[{"name":"pref_name","type":"string"},{"name":"value","type":"any"}],"returns_async":{"name":"callback","parameters":[]},"name":"setWhitelistedPref","type":"function"},{"parameters":[{"name":"appId","type":"string"},{"name":"scaled","type":"boolean"}],"returns_async":{"name":"callback","parameters":[]},"name":"setCrostiniAppScaled","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"scaleFactor","type":"number"}]},"name":"getPrimaryDisplayScaleFactor","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"enabled","type":"boolean"}]},"name":"isTabletModeEnabled","type":"function"},{"parameters":[{"name":"enabled","type":"boolean"}],"returns_async":{"name":"callback","parameters":[{"name":"enabled","type":"boolean"}]},"name":"setTabletModeEnabled","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"apps","type":"array","items":{"$ref":"autotestPrivate.App"}}]},"name":"getAllInstalledApps","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"items","type":"array","items":{"$ref":"autotestPrivate.ShelfItem"}}]},"name":"getShelfItems","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"state","$ref":"autotestPrivate.LauncherSearchBoxState"}]},"name":"getLauncherSearchBoxState","type":"function"},{"parameters":[{"name":"displayId","type":"string"}],"returns_async":{"name":"callback","parameters":[{"name":"behavior","type":"string"}]},"name":"getShelfAutoHideBehavior","type":"function"},{"parameters":[{"name":"displayId","type":"string"},{"name":"behavior","type":"string"}],"returns_async":{"name":"callback","parameters":[]},"name":"setShelfAutoHideBehavior","type":"function"},{"parameters":[{"name":"displayId","type":"string"}],"returns_async":{"name":"callback","parameters":[{"name":"alignment","$ref":"autotestPrivate.ShelfAlignmentType"}]},"name":"getShelfAlignment","type":"function"},{"parameters":[{"name":"displayId","type":"string"},{"name":"alignment","$ref":"autotestPrivate.ShelfAlignmentType"}],"returns_async":{"name":"callback","parameters":[]},"name":"setShelfAlignment","type":"function"},{"parameters":[{"name":"appId","type":"string"}],"returns_async":{"name":"callback","parameters":[]},"name":"pinShelfIcon","type":"function"},{"parameters":[{"name":"updateParams","type":"array","items":{"$ref":"autotestPrivate.ShelfIconPinUpdateParam"}}],"returns_async":{"name":"callback","optional":true,"parameters":[{"name":"results","type":"array","items":{"type":"string"}}]},"name":"setShelfIconPin","type":"function"},{"parameters":[{"name":"start","type":"boolean"}],"returns_async":{"name":"callback","parameters":[{"name":"finished","type":"boolean"}]},"name":"setOverviewModeState","type":"function"},{"parameters":[],"name":"showVirtualKeyboardIfEnabled","type":"function"},{"parameters":[{"name":"color","type":"integer"},{"name":"theme","$ref":"autotestPrivate.ThemeStyle"}],"returns_async":{"name":"callback","parameters":[{"name":"result","type":"boolean"}]},"name":"sendArcOverlayColor","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[]},"name":"arcAppTracingStart","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"info","$ref":"autotestPrivate.ArcAppTracingInfo"}]},"name":"arcAppTracingStopAndAnalyze","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[]},"name":"swapWindowsInSplitView","type":"function"},{"parameters":[{"name":"packageName","type":"string"}],"returns_async":{"name":"callback","parameters":[]},"name":"setArcAppWindowFocus","type":"function"},{"parameters":[{"name":"displayId","type":"string"},{"name":"rotation","$ref":"autotestPrivate.RotationType"}],"returns_async":{"name":"callback","parameters":[{"name":"success","type":"boolean"}]},"name":"waitForDisplayRotation","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"window_list","type":"array","items":{"$ref":"autotestPrivate.AppWindowInfo"}}]},"name":"getAppWindowList","type":"function"},{"parameters":[{"name":"id","type":"integer"},{"name":"change","$ref":"autotestPrivate.WindowStateChangeDict"},{"name":"wait","optional":true,"type":"boolean"}],"returns_async":{"name":"callback","parameters":[{"name":"currentType","$ref":"autotestPrivate.WindowStateType"}]},"name":"setAppWindowState","type":"function"},{"parameters":[{"name":"id","type":"integer"}],"returns_async":{"name":"callback","parameters":[]},"name":"activateAppWindow","type":"function"},{"parameters":[{"name":"id","type":"integer"}],"returns_async":{"name":"callback","parameters":[]},"name":"closeAppWindow","type":"function"},{"parameters":[{"name":"timeout_ms","type":"integer"}],"returns_async":{"name":"callback","parameters":[{"name":"appId","type":"string"}]},"name":"installPWAForCurrentURL","type":"function"},{"parameters":[{"name":"accelerator","$ref":"autotestPrivate.Accelerator"}],"returns_async":{"name":"callback","parameters":[{"name":"success","type":"boolean"}]},)R" R"R("name":"activateAccelerator","type":"function"},{"parameters":[{"name":"launcherState","$ref":"autotestPrivate.LauncherStateType"}],"returns_async":{"name":"callback","parameters":[]},"name":"waitForLauncherState","type":"function"},{"parameters":[{"name":"overviewState","$ref":"autotestPrivate.OverviewStateType"}],"returns_async":{"name":"callback","parameters":[]},"name":"waitForOverviewState","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"success","type":"boolean"}]},"name":"createNewDesk","type":"function"},{"parameters":[{"name":"index","type":"integer"}],"returns_async":{"name":"callback","parameters":[{"name":"success","type":"boolean"}]},"name":"activateDeskAtIndex","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"success","type":"boolean"}]},"name":"removeActiveDesk","type":"function"},{"parameters":[{"name":"index","type":"integer"}],"returns_async":{"name":"callback","parameters":[{"name":"success","type":"boolean"}]},"name":"activateAdjacentDesksToTargetIndex","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"count","type":"integer"}]},"name":"getDeskCount","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"desks","$ref":"autotestPrivate.DesksInfo"}]},"name":"getDesksInfo","type":"function"},{"parameters":[{"name":"button","$ref":"autotestPrivate.MouseButton"}],"returns_async":{"name":"callback","parameters":[]},"name":"mouseClick","type":"function"},{"parameters":[{"name":"button","$ref":"autotestPrivate.MouseButton"}],"returns_async":{"name":"callback","parameters":[]},"name":"mousePress","type":"function"},{"parameters":[{"name":"button","$ref":"autotestPrivate.MouseButton"}],"returns_async":{"name":"callback","parameters":[]},"name":"mouseRelease","type":"function"},{"parameters":[{"name":"location","$ref":"autotestPrivate.Location"},{"name":"duration_in_ms","type":"number"}],"returns_async":{"name":"callback","parameters":[]},"name":"mouseMove","type":"function"},{"parameters":[{"name":"enabled","type":"boolean"}],"returns_async":{"name":"callback","parameters":[]},"name":"setMetricsEnabled","type":"function"},{"parameters":[{"name":"enabled","type":"boolean"}],"returns_async":{"name":"callback","parameters":[]},"name":"setArcTouchMode","type":"function"},{"parameters":[{"name":"state","$ref":"autotestPrivate.ScrollableShelfState"}],"returns_async":{"name":"callback","parameters":[{"name":"info","$ref":"autotestPrivate.ScrollableShelfInfo"}]},"name":"getScrollableShelfInfoForState","type":"function"},{"parameters":[{"name":"state","$ref":"autotestPrivate.ShelfState"}],"returns_async":{"name":"callback","parameters":[{"name":"info","$ref":"autotestPrivate.ShelfUIInfo"}]},"name":"getShelfUIInfoForState","type":"function"},{"parameters":[{"name":"id","type":"integer"},{"name":"bounds","$ref":"autotestPrivate.Bounds"},{"name":"displayId","type":"string"}],"returns_async":{"name":"callback","parameters":[{"name":"result","$ref":"autotestPrivate.SetWindowBoundsResult"}]},"name":"setWindowBounds","type":"function"},{"parameters":[{"name":"displayId","optional":true,"type":"string"},{"name":"throughputIntervalMs","optional":true,"type":"integer"}],"returns_async":{"name":"callback","parameters":[]},"name":"startSmoothnessTracking","type":"function"},{"parameters":[{"name":"displayId","optional":true,"type":"string"}],"returns_async":{"name":"callback","parameters":[{"name":"data","$ref":"autotestPrivate.DisplaySmoothnessData"}]},"name":"stopSmoothnessTracking","type":"function"},{"parameters":[],"name":"disableSwitchAccessDialog","type":"function"},{"parameters":[{"name":"numCompletions","type":"integer"},{"name":"timeout","type":"integer"}],"returns_async":{"name":"callback","parameters":[]},"name":"waitForAmbientPhotoAnimation","type":"function"},{"parameters":[{"name":"timeout","type":"integer"}],"returns_async":{"name":"callback","parameters":[]},"name":"waitForAmbientVideo","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[]},"name":"disableAutomation","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[]},"name":"startThroughputTrackerDataCollection","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"data","type":"array","items":{"$ref":"autotestPrivate.ThroughputTrackerAnimationData"}}]},"name":"stopThroughputTrackerDataCollection","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"data","type":"array","items":{"$ref":"autotestPrivate.ThroughputTrackerAnimationData"}}]},"name":"getThroughputTrackerData","type":"function"},{"parameters":[{"name":"displayId","optional":true,"type":"string"}],"returns_async":{"name":"callback","parameters":[{"name":"smoothness","type":"integer"}]},"name":"getDisplaySmoothness","type":"function"},{"parameters":[{"name":"options","optional":true,"$ref":"autotestPrivate.ResetHoldingSpaceOptions"}],"returns_async":{"name":"callback","parameters":[]},"name":"resetHoldingSpace","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[]},"name":"startLoginEventRecorderDataCollection","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"data","type":"array","items":{"$ref":"autotestPrivate.LoginEventRecorderData"}}]},"name":"getLoginEventRecorderLoginEvents","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[]},"name":"addLoginEventForTesting","type":"function"},{"parameters":[{"name":"darkModeEnabled","type":"boolean"}],"returns_async":{"name":"callback","parameters":[]},"name":"forceAutoThemeMode","type":"function"},{"parameters":[{"name":"accessTokenParams","$ref":"autotestPrivate.GetAccessTokenParams"}],"returns_async":{"name":"callback","parameters":[{"name":"data","$ref":"autotestPrivate.GetAccessTokenData"}]},"name":"getAccessToken","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"isReady","type":"boolean"}]},"name":"isInputMethodReadyForTesting","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"data","$ref":"autotestPrivate.MakeFuseboxTempDirData"}]},"name":"makeFuseboxTempDir","type":"function"},{"parameters":[{"name":"fuseboxFilePath","type":"string"}],"returns_async":{"name":"callback","parameters":[]},"name":"removeFuseboxTempDir","type":"function"},{"parameters":[{"name":"extensionId","type":"string"}],"returns_async":{"name":"callback","parameters":[]},"name":"removeComponentExtension","type":"function"},{"parameters":[{"name":"bucketSizeInSeconds","type":"integer"}],"returns_async":{"name":"callback","parameters":[]},"name":"startFrameCounting","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"data","type":"array","items":{"$ref":"autotestPrivate.FrameCountingPerSinkData"}}]},"name":"stopFrameCounting","type":"function"},{"parameters":[{"name":"bucketSizeInSeconds","type":"integer"},{"name":"displayId","optional":true,"type":"string"}],"returns_async":{"name":"callback","parameters":[]},"name":"startOverdrawTracking","type":"function"},{"parameters":[{"name":"displayId","optional":true,"type":"string"}],"returns_async":{"name":"callback","parameters":[{"name":"data","$ref":"autotestPrivate.OverdrawData"}]},"name":"stopOverdrawTracking","type":"function"},{"parameters":[{"name":"vm_name","type":"string"}],"returns_async":{"name":"callback","parameters":[]},"name":"installBruschetta","type":"function"},{"parameters":[{"name":"vm_name","type":"string"}],"returns_async":{"name":"callback","parameters":[]},"name":"removeBruschetta","type":"function"},{"parameters":[{"name":"feature_name","type":"string"}],"returns_async":{"name":"callback","parameters":[{"name":"enabled","type":"boolean"}]},"name":"isFeatureEnabled","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"data","$ref":"autotestPrivate.GetCurrentInputMethodDescriptorData"}]},"name":"getCurrentInputMethodDescriptor","type":"funct)R" R"R(ion"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"success","type":"boolean"}]},"name":"overrideLobsterResponseForTesting","type":"function"},{"parameters":[{"name":"array","$ref":"autotestPrivate.OrcaResponseArray"}],"returns_async":{"name":"callback","parameters":[{"name":"success","type":"boolean"}]},"name":"overrideOrcaResponseForTesting","type":"function"},{"parameters":[{"name":"array","$ref":"autotestPrivate.ScannerResponseArray"}],"returns_async":{"name":"callback","parameters":[{"name":"success","type":"boolean"}]},"name":"overrideScannerResponsesForTesting","type":"function"},{"parameters":[{"name":"enabled","type":"boolean"}],"returns_async":{"name":"callback","parameters":[]},"name":"setArcInteractiveState","type":"function"},{"parameters":[{"name":"trial_name","type":"string"},{"name":"group_name","type":"string"}],"returns_async":{"name":"callback","parameters":[{"name":"active","type":"boolean"}]},"name":"isFieldTrialActive","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"mode","$ref":"autotestPrivate.WakefulnessMode"}]},"name":"getArcWakefulnessMode","type":"function"},{"parameters":[{"name":"locale","type":"string"}],"returns_async":{"name":"callback","parameters":[]},"name":"setDeviceLanguage","type":"function"},{"parameters":[{"name":"type","type":"string"}],"returns_async":{"name":"callback","parameters":[{"name":"data","type":"string"}]},"name":"getDeviceEventLog","type":"function"}],"properties":{},"events":[{"parameters":[],"name":"onClipboardDataChanged","type":"function"}],"platforms":["chromeos"],"deprecated":null})R";
constexpr char kBookmarkManagerPrivate[] = R"R({"namespace":"bookmarkManagerPrivate","types":[{"id":"bookmarkManagerPrivate.BookmarkNodeDataElement","type":"object","properties":{"id":{"type":"string","optional":true},"parentId":{"type":"string","optional":true},"title":{"type":"string"},"url":{"type":"string","optional":true},"children":{"type":"array","items":{"$ref":"bookmarkManagerPrivate.BookmarkNodeDataElement"}}}},{"id":"bookmarkManagerPrivate.BookmarkNodeData","type":"object","properties":{"sameProfile":{"type":"boolean"},"elements":{"type":"array","items":{"$ref":"bookmarkManagerPrivate.BookmarkNodeDataElement"}}}},{"id":"bookmarkManagerPrivate.OpenInNewTabParams","type":"object","properties":{"active":{"type":"boolean"},"split":{"type":"boolean"}}}],"functions":[{"name":"copy","type":"function","parameters":[{"name":"idList","type":"array","items":{"type":"string"},"minItems":1}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"cut","type":"function","parameters":[{"name":"idList","type":"array","items":{"type":"string"},"minItems":1}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"paste","type":"function","parameters":[{"type":"string","name":"parentId"},{"name":"selectedIdList","optional":true,"type":"array","items":{"type":"string"},"minItems":0}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"canPaste","type":"function","parameters":[{"type":"string","name":"parentId"}],"returns_async":{"name":"callback","parameters":[{"name":"result","type":"boolean"}]}},{"name":"isActiveTabInSplit","type":"function","parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"result","type":"boolean"}]}},{"name":"sortChildren","type":"function","parameters":[{"type":"string","name":"parentId"}]},{"name":"startDrag","type":"function","parameters":[{"name":"idList","type":"array","items":{"type":"string"},"minItems":1},{"name":"dragNodeIndex","type":"integer","minimum":0},{"name":"isFromTouch","type":"boolean"},{"name":"x","type":"integer","minimum":0},{"name":"y","type":"integer","minimum":0}]},{"name":"drop","type":"function","parameters":[{"name":"parentId","type":"string"},{"name":"index","type":"integer","minimum":0,"optional":true}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"getSubtree","type":"function","parameters":[{"name":"id","type":"string"},{"name":"foldersOnly","type":"boolean"}],"returns_async":{"name":"callback","parameters":[{"name":"results","type":"array","items":{"$ref":"bookmarks.BookmarkTreeNode"}}]}},{"name":"removeTrees","type":"function","parameters":[{"name":"idList","type":"array","items":{"type":"string"},"minItems":1}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"undo","type":"function","parameters":[]},{"name":"redo","type":"function","parameters":[]},{"name":"openInNewTab","type":"function","parameters":[{"name":"id","type":"string"},{"name":"params","optional":true,"$ref":"bookmarkManagerPrivate.OpenInNewTabParams"}]},{"name":"openInNewWindow","type":"function","parameters":[{"name":"idList","type":"array","items":{"type":"string"},"minItems":1},{"name":"incognito","type":"boolean"}]},{"name":"openInNewTabGroup","type":"function","parameters":[{"name":"idList","type":"array","items":{"type":"string"},"minItems":1}]},{"name":"import","type":"function","parameters":[],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"export","type":"function","parameters":[],"returns_async":{"name":"callback","optional":true,"parameters":[]}}],"events":[{"name":"onDragEnter","type":"function","parameters":[{"name":"bookmarkNodeData","$ref":"bookmarkManagerPrivate.BookmarkNodeData"}]},{"name":"onDragLeave","type":"function","parameters":[{"name":"bookmarkNodeData","$ref":"bookmarkManagerPrivate.BookmarkNodeData"}]},{"name":"onDrop","type":"function","parameters":[{"name":"bookmarkNodeData","$ref":"bookmarkManagerPrivate.BookmarkNodeData"}]}]})R";
constexpr char kBrailleDisplayPrivate[] = R"R({"namespace":"brailleDisplayPrivate","types":[{"id":"brailleDisplayPrivate.KeyCommand","type":"string","enum":[{"name":"line_up"},{"name":"line_down"},{"name":"pan_left"},{"name":"pan_right"},{"name":"top"},{"name":"bottom"},{"name":"routing"},{"name":"secondary_routing"},{"name":"dots"},{"name":"chord"},{"name":"standard_key"}]},{"id":"brailleDisplayPrivate.KeyEvent","properties":{"command":{"name":"command","$ref":"brailleDisplayPrivate.KeyCommand"},"displayPosition":{"optional":true,"name":"displayPosition","type":"integer"},"brailleDots":{"optional":true,"name":"brailleDots","type":"integer"},"standardKeyCode":{"optional":true,"name":"standardKeyCode","type":"string"},"standardKeyChar":{"optional":true,"name":"standardKeyChar","type":"string"},"spaceKey":{"optional":true,"name":"spaceKey","type":"boolean"},"altKey":{"optional":true,"name":"altKey","type":"boolean"},"shiftKey":{"optional":true,"name":"shiftKey","type":"boolean"},"ctrlKey":{"optional":true,"name":"ctrlKey","type":"boolean"}},"type":"object"},{"id":"brailleDisplayPrivate.DisplayState","properties":{"available":{"name":"available","type":"boolean"},"textRowCount":{"optional":true,"name":"textRowCount","type":"integer"},"textColumnCount":{"optional":true,"name":"textColumnCount","type":"integer"},"cellSize":{"optional":true,"name":"cellSize","type":"integer"}},"type":"object"}],"functions":[{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"result","$ref":"brailleDisplayPrivate.DisplayState"}]},"name":"getDisplayState","type":"function"},{"parameters":[{"name":"cells","type":"binary","isInstanceOf":"ArrayBuffer"},{"name":"columns","type":"integer"},{"name":"rows","type":"integer"}],"name":"writeDots","type":"function"},{"parameters":[{"name":"address","type":"string"}],"name":"updateBluetoothBrailleDisplayAddress","type":"function"}],"properties":{},"events":[{"parameters":[{"name":"state","$ref":"brailleDisplayPrivate.DisplayState"}],"name":"onDisplayStateChanged","type":"function"},{"parameters":[{"name":"event","$ref":"brailleDisplayPrivate.KeyEvent"}],"name":"onKeyEvent","type":"function"}],"platforms":null,"deprecated":null})R";
constexpr char kChromeWebViewInternal[] = R"R({"namespace":"chromeWebViewInternal","dependencies":["contextMenus"],"types":[{"id":"chromeWebViewInternal.ContextMenuItem","type":"object","properties":{"label":{"type":"string","optional":true},"commandId":{"type":"integer"}}}],"functions":[{"name":"contextMenusCreate","type":"function","returns":{"choices":[{"type":"integer"},{"type":"string"}]},"parameters":[{"type":"integer","name":"instanceId"},{"type":"object","name":"createProperties","properties":{"type":{"$ref":"contextMenus.ItemType","optional":true},"id":{"type":"string","optional":true},"title":{"type":"string","optional":true},"checked":{"type":"boolean","optional":true},"contexts":{"type":"array","items":{"$ref":"contextMenus.ContextType"},"minItems":1,"optional":true},"visible":{"type":"boolean","optional":true},"onclick":{"type":"function","optional":true,"parameters":[{"name":"info","$ref":"contextMenus.OnClickData"}]},"parentId":{"choices":[{"type":"integer"},{"type":"string"}],"optional":true},"documentUrlPatterns":{"type":"array","items":{"type":"string"},"optional":true},"targetUrlPatterns":{"type":"array","items":{"type":"string"},"optional":true},"enabled":{"type":"boolean","optional":true}}}],"returns_async":{"name":"callback","optional":true,"parameters":[],"does_not_support_promises":"Synchronous return and callback crbug.com/1143032"}},{"name":"contextMenusUpdate","type":"function","parameters":[{"type":"integer","name":"instanceId"},{"choices":[{"type":"integer"},{"type":"string"}],"name":"id"},{"type":"object","name":"updateProperties","properties":{"type":{"$ref":"contextMenus.ItemType","optional":true},"title":{"type":"string","optional":true},"checked":{"type":"boolean","optional":true},"contexts":{"type":"array","items":{"$ref":"contextMenus.ContextType"},"minItems":1,"optional":true},"visible":{"type":"boolean","optional":true},"onclick":{"type":"function","optional":true},"parentId":{"choices":[{"type":"integer"},{"type":"string"}],"optional":true},"documentUrlPatterns":{"type":"array","items":{"type":"string"},"optional":true},"targetUrlPatterns":{"type":"array","items":{"type":"string"},"optional":true},"enabled":{"type":"boolean","optional":true}}}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"contextMenusRemove","type":"function","parameters":[{"type":"integer","name":"instanceId"},{"choices":[{"type":"integer"},{"type":"string"}],"name":"menuItemId"}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"contextMenusRemoveAll","type":"function","parameters":[{"type":"integer","name":"instanceId"}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"showContextMenu","type":"function","parameters":[{"type":"integer","name":"instanceId"},{"type":"integer","name":"requestId"},{"type":"array","name":"itemsToShow","items":{"$ref":"chromeWebViewInternal.ContextMenuItem"},"optional":true}]}],"events":[{"name":"onClicked","type":"function","$ref":"contextMenus.onClicked"},{"name":"onShow","type":"function","parameters":[{"name":"event","type":"object","properties":{"preventDefault":{"type":"function","parameters":[]}}}]}]})R";
constexpr char kCommandLinePrivate[] = R"R({"namespace":"commandLinePrivate","functions":[{"name":"hasSwitch","type":"function","parameters":[{"name":"name","type":"string"}],"returns_async":{"name":"callback","parameters":[{"name":"result","type":"boolean"}]}}]})R";
constexpr char kContentSettings[] = R"R({"namespace":"contentSettings","types":[{"id":"contentSettings.ResourceIdentifier","type":"object","properties":{"id":{"type":"string"},"description":{"type":"string","optional":true}}},{"id":"contentSettings.Scope","type":"string","enum":["regular","incognito_session_only"]},{"id":"contentSettings.ContentSetting","js_module":"ContentSetting","type":"object","functions":[{"name":"clear","type":"function","parameters":[{"name":"details","type":"object","properties":{"scope":{"$ref":"contentSettings.Scope","optional":true}}}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"get","type":"function","parameters":[{"name":"details","type":"object","properties":{"primaryUrl":{"type":"string"},"secondaryUrl":{"type":"string","optional":true},"resourceIdentifier":{"$ref":"contentSettings.ResourceIdentifier","optional":true},"incognito":{"type":"boolean","optional":true}}}],"returns_async":{"name":"callback","parameters":[{"name":"details","type":"object","properties":{"setting":{"type":"any"}}}]}},{"name":"set","type":"function","parameters":[{"name":"details","type":"object","properties":{"primaryPattern":{"type":"string"},"secondaryPattern":{"type":"string","optional":true},"resourceIdentifier":{"$ref":"contentSettings.ResourceIdentifier","optional":true},"setting":{"type":"any"},"scope":{"$ref":"contentSettings.Scope","optional":true}}}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"getResourceIdentifiers","type":"function","parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"resourceIdentifiers","type":"array","optional":true,"items":{"$ref":"contentSettings.ResourceIdentifier"}}]}}]},{"id":"contentSettings.AutoVerifyContentSetting","type":"string","enum":["allow","block"]},{"id":"contentSettings.ClipboardContentSetting","type":"string","enum":["allow","block","ask"]},{"id":"contentSettings.CookiesContentSetting","type":"string","enum":["allow","block","session_only"]},{"id":"contentSettings.ImagesContentSetting","type":"string","enum":["allow","block"]},{"id":"contentSettings.JavascriptContentSetting","type":"string","enum":["allow","block"]},{"id":"contentSettings.LocationContentSetting","type":"string","enum":["allow","block","ask"]},{"id":"contentSettings.PluginsContentSetting","type":"string","enum":["block"]},{"id":"contentSettings.PopupsContentSetting","type":"string","enum":["allow","block"]},{"id":"contentSettings.NotificationsContentSetting","type":"string","enum":["allow","block","ask"]},{"id":"contentSettings.FullscreenContentSetting","type":"string","enum":["allow"]},{"id":"contentSettings.MouselockContentSetting","type":"string","enum":["allow"]},{"id":"contentSettings.MicrophoneContentSetting","type":"string","enum":["allow","block","ask"]},{"id":"contentSettings.CameraContentSetting","type":"string","enum":["allow","block","ask"]},{"id":"contentSettings.PpapiBrokerContentSetting","type":"string","enum":["block"]},{"id":"contentSettings.MultipleAutomaticDownloadsContentSetting","type":"string","enum":["allow","block","ask"]},{"id":"contentSettings.SoundContentSetting","type":"string","enum":["allow","block"]}],"properties":{"autoVerify":{"$ref":"contentSettings.ContentSetting","value":["anti-abuse",{"$ref":"contentSettings.AutoVerifyContentSetting"}]},"cookies":{"$ref":"contentSettings.ContentSetting","value":["cookies",{"$ref":"contentSettings.CookiesContentSetting"}]},"images":{"$ref":"contentSettings.ContentSetting","value":["images",{"$ref":"contentSettings.ImagesContentSetting"}]},"javascript":{"$ref":"contentSettings.ContentSetting","value":["javascript",{"$ref":"contentSettings.JavascriptContentSetting"}]},"location":{"$ref":"contentSettings.ContentSetting","value":["geolocation",{"$ref":"contentSettings.LocationContentSetting"}]},"plugins":{"$ref":"contentSettings.ContentSetting","value":["plugins",{"$ref":"contentSettings.PluginsContentSetting"}]},"popups":{"$ref":"contentSettings.ContentSetting","value":["popups",{"$ref":"contentSettings.PopupsContentSetting"}]},"notifications":{"$ref":"contentSettings.ContentSetting","value":["notifications",{"$ref":"contentSettings.NotificationsContentSetting"}]},"fullscreen":{"$ref":"contentSettings.ContentSetting","value":["fullscreen",{"$ref":"contentSettings.FullscreenContentSetting"}]},"mouselock":{"$ref":"contentSettings.ContentSetting","value":["mouselock",{"$ref":"contentSettings.MouselockContentSetting"}]},"microphone":{"$ref":"contentSettings.ContentSetting","value":["media-stream-mic",{"$ref":"contentSettings.MicrophoneContentSetting"}]},"clipboard":{"$ref":"contentSettings.ContentSetting","value":["clipboard",{"$ref":"contentSettings.ClipboardContentSetting"}]},"camera":{"$ref":"contentSettings.ContentSetting","value":["media-stream-camera",{"$ref":"contentSettings.CameraContentSetting"}]},"unsandboxedPlugins":{"$ref":"contentSettings.ContentSetting","value":["ppapi-broker",{"$ref":"contentSettings.PpapiBrokerContentSetting"}]},"automaticDownloads":{"$ref":"contentSettings.ContentSetting","value":["automatic-downloads",{"$ref":"contentSettings.MultipleAutomaticDownloadsContentSetting"}]},"sound":{"$ref":"contentSettings.ContentSetting","value":["sound",{"$ref":"contentSettings.SoundContentSetting"}]}}})R";
constexpr char kDesktopCapture[] = R"R({"namespace":"desktopCapture","types":[{"id":"desktopCapture.DesktopCaptureSourceType","type":"string","enum":["screen","window","tab","audio"]},{"id":"desktopCapture.SystemAudioPreferenceEnum","type":"string","enum":["include","exclude"]},{"id":"desktopCapture.WindowAudioPreferenceEnum","type":"string","enum":["system","window","exclude"]},{"id":"desktopCapture.SelfCapturePreferenceEnum","type":"string","enum":["include","exclude"]}],"functions":[{"name":"chooseDesktopMedia","type":"function","parameters":[{"type":"array","items":{"$ref":"desktopCapture.DesktopCaptureSourceType"},"name":"sources"},{"$ref":"tabs.Tab","name":"targetTab","optional":true},{"type":"object","name":"options","optional":true,"properties":{"systemAudio":{"$ref":"desktopCapture.SystemAudioPreferenceEnum","optional":true},"windowAudio":{"$ref":"desktopCapture.WindowAudioPreferenceEnum","optional":true},"selfBrowserSurface":{"$ref":"desktopCapture.SelfCapturePreferenceEnum","optional":true},"suppressLocalAudioPlaybackIntended":{"type":"boolean","optional":true}}}],"returns_async":{"name":"callback","parameters":[{"name":"streamId","type":"string"},{"name":"options","type":"object","properties":{"canRequestAudioTrack":{"type":"boolean"}}}],"does_not_support_promises":"Synchronous return and callback crbug.com/1143032, Multi-parameter callback crbug.com/1313625"},"returns":{"type":"integer"}},{"name":"cancelChooseDesktopMedia","type":"function","parameters":[{"name":"desktopMediaRequestId","type":"integer"}]}]})R";
constexpr char kCrashReportPrivate[] = R"R({"namespace":"crashReportPrivate","types":[{"id":"crashReportPrivate.ErrorInfo","properties":{"message":{"name":"message","type":"string"},"url":{"name":"url","type":"string"},"product":{"optional":true,"name":"product","type":"string"},"version":{"optional":true,"name":"version","type":"string"},"lineNumber":{"optional":true,"name":"lineNumber","type":"integer"},"columnNumber":{"optional":true,"name":"columnNumber","type":"integer"},"debugId":{"optional":true,"name":"debugId","type":"string"},"stackTrace":{"optional":true,"name":"stackTrace","type":"string"}},"type":"object"}],"functions":[{"parameters":[{"name":"info","$ref":"crashReportPrivate.ErrorInfo"}],"returns_async":{"name":"callback","parameters":[]},"name":"reportError","type":"function"}],"properties":{},"events":[],"platforms":["chromeos"],"deprecated":null})R";
constexpr char kEnterpriseReportingPrivate[] = R"R({"namespace":"enterprise.reportingPrivate","types":[{"id":"enterprise.reportingPrivate.SettingValue","type":"string","enum":[{"name":"UNKNOWN"},{"name":"DISABLED"},{"name":"ENABLED"}]},{"id":"enterprise.reportingPrivate.DeviceInfo","properties":{"osName":{"name":"osName","type":"string"},"osVersion":{"name":"osVersion","type":"string"},"deviceHostName":{"name":"deviceHostName","type":"string"},"deviceModel":{"name":"deviceModel","type":"string"},"serialNumber":{"name":"serialNumber","type":"string"},"screenLockSecured":{"name":"screenLockSecured","$ref":"enterprise.reportingPrivate.SettingValue"},"diskEncrypted":{"name":"diskEncrypted","$ref":"enterprise.reportingPrivate.SettingValue"},"macAddresses":{"name":"macAddresses","type":"array","items":{"type":"string"}},"windowsMachineDomain":{"optional":true,"name":"windowsMachineDomain","type":"string"},"windowsUserDomain":{"optional":true,"name":"windowsUserDomain","type":"string"},"securityPatchLevel":{"name":"securityPatchLevel","type":"string"},"secureBootEnabled":{"optional":true,"name":"secureBootEnabled","$ref":"enterprise.reportingPrivate.SettingValue"}},"type":"object"},{"id":"enterprise.reportingPrivate.RealtimeUrlCheckMode","type":"string","enum":[{"name":"DISABLED"},{"name":"ENABLED_MAIN_FRAME"}]},{"id":"enterprise.reportingPrivate.SafeBrowsingLevel","type":"string","enum":[{"name":"DISABLED"},{"name":"STANDARD"},{"name":"ENHANCED"}]},{"id":"enterprise.reportingPrivate.PasswordProtectionTrigger","type":"string","enum":[{"name":"PASSWORD_PROTECTION_OFF"},{"name":"PASSWORD_REUSE"},{"name":"PHISHING_REUSE"},{"name":"POLICY_UNSET"}]},{"id":"enterprise.reportingPrivate.ContextInfo","properties":{"browserAffiliationIds":{"name":"browserAffiliationIds","type":"array","items":{"type":"string"}},"profileAffiliationIds":{"name":"profileAffiliationIds","type":"array","items":{"type":"string"}},"onFileAttachedProviders":{"name":"onFileAttachedProviders","type":"array","items":{"type":"string"}},"onFileDownloadedProviders":{"name":"onFileDownloadedProviders","type":"array","items":{"type":"string"}},"onBulkDataEntryProviders":{"name":"onBulkDataEntryProviders","type":"array","items":{"type":"string"}},"onPrintProviders":{"name":"onPrintProviders","type":"array","items":{"type":"string"}},"realtimeUrlCheckMode":{"name":"realtimeUrlCheckMode","$ref":"enterprise.reportingPrivate.RealtimeUrlCheckMode"},"onSecurityEventProviders":{"name":"onSecurityEventProviders","type":"array","items":{"type":"string"}},"browserVersion":{"name":"browserVersion","type":"string"},"safeBrowsingProtectionLevel":{"name":"safeBrowsingProtectionLevel","$ref":"enterprise.reportingPrivate.SafeBrowsingLevel"},"siteIsolationEnabled":{"name":"siteIsolationEnabled","type":"boolean"},"builtInDnsClientEnabled":{"name":"builtInDnsClientEnabled","type":"boolean"},"passwordProtectionWarningTrigger":{"name":"passwordProtectionWarningTrigger","$ref":"enterprise.reportingPrivate.PasswordProtectionTrigger"},"chromeRemoteDesktopAppBlocked":{"name":"chromeRemoteDesktopAppBlocked","type":"boolean"},"osFirewall":{"name":"osFirewall","$ref":"enterprise.reportingPrivate.SettingValue"},"systemDnsServers":{"name":"systemDnsServers","type":"array","items":{"type":"string"}},"enterpriseProfileId":{"optional":true,"name":"enterpriseProfileId","type":"string"}},"type":"object"},{"id":"enterprise.reportingPrivate.CertificateStatus","type":"string","enum":[{"name":"OK"},{"name":"POLICY_UNSET"}]},{"id":"enterprise.reportingPrivate.Certificate","properties":{"status":{"name":"status","$ref":"enterprise.reportingPrivate.CertificateStatus"},"encodedCertificate":{"optional":true,"name":"encodedCertificate","type":"binary","isInstanceOf":"ArrayBuffer"}},"type":"object"},{"id":"enterprise.reportingPrivate.EventType","type":"string","enum":[{"name":"DEVICE"},{"name":"USER"}]},{"id":"enterprise.reportingPrivate.EnqueueRecordRequest","properties":{"recordData":{"name":"recordData","type":"binary"},"priority":{"name":"priority","type":"integer"},"eventType":{"name":"eventType","$ref":"enterprise.reportingPrivate.EventType"}},"type":"object"},{"id":"enterprise.reportingPrivate.UserContext","properties":{"userId":{"name":"userId","type":"string"}},"type":"object"},{"id":"enterprise.reportingPrivate.AntiVirusProductState","type":"string","enum":[{"name":"ON"},{"name":"OFF"},{"name":"SNOOZED"},{"name":"EXPIRED"}]},{"id":"enterprise.reportingPrivate.AntiVirusSignal","properties":{"displayName":{"name":"displayName","type":"string"},"productId":{"name":"productId","type":"string"},"state":{"name":"state","$ref":"enterprise.reportingPrivate.AntiVirusProductState"}},"type":"object"},{"id":"enterprise.reportingPrivate.HotfixSignal","properties":{"hotfixId":{"name":"hotfixId","type":"string"}},"type":"object"},{"id":"enterprise.reportingPrivate.PresenceValue","type":"string","enum":[{"name":"UNSPECIFIED"},{"name":"ACCESS_DENIED"},{"name":"NOT_FOUND"},{"name":"FOUND"}]},{"id":"enterprise.reportingPrivate.GetFileSystemInfoOptions","properties":{"path":{"name":"path","type":"string"},"computeSha256":{"name":"computeSha256","type":"boolean"},"computeExecutableMetadata":{"name":"computeExecutableMetadata","type":"boolean"}},"type":"object"},{"id":"enterprise.reportingPrivate.GetFileSystemInfoRequest","properties":{"userContext":{"name":"userContext","$ref":"enterprise.reportingPrivate.UserContext"},"options":{"name":"options","type":"array","items":{"$ref":"enterprise.reportingPrivate.GetFileSystemInfoOptions"}}},"type":"object"},{"id":"enterprise.reportingPrivate.GetFileSystemInfoResponse","properties":{"path":{"name":"path","type":"string"},"presence":{"name":"presence","$ref":"enterprise.reportingPrivate.PresenceValue"},"sha256Hash":{"optional":true,"name":"sha256Hash","type":"string"},"isRunning":{"optional":true,"name":"isRunning","type":"boolean"},"publicKeysHashes":{"optional":true,"name":"publicKeysHashes","type":"array","items":{"type":"string"}},"productName":{"optional":true,"name":"productName","type":"string"},"version":{"optional":true,"name":"version","type":"string"}},"type":"object"},{"id":"enterprise.reportingPrivate.RegistryHive","type":"string","enum":[{"name":"HKEY_CLASSES_ROOT"},{"name":"HKEY_LOCAL_MACHINE"},{"name":"HKEY_CURRENT_USER"}]},{"id":"enterprise.reportingPrivate.GetSettingsOptions","properties":{"path":{"name":"path","type":"string"},"key":{"name":"key","type":"string"},"getValue":{"name":"getValue","type":"boolean"},"hive":{"optional":true,"name":"hive","$ref":"enterprise.reportingPrivate.RegistryHive"}},"type":"object"},{"id":"enterprise.reportingPrivate.GetSettingsRequest","properties":{"userContext":{"name":"userContext","$ref":"enterprise.reportingPrivate.UserContext"},"options":{"name":"options","type":"array","items":{"$ref":"enterprise.reportingPrivate.GetSettingsOptions"}}},"type":"object"},{"id":"enterprise.reportingPrivate.GetSettingsResponse","properties":{"path":{"name":"path","type":"string"},"key":{"name":"key","type":"string"},"hive":{"optional":true,"name":"hive","$ref":"enterprise.reportingPrivate.RegistryHive"},"presence":{"name":"presence","$ref":"enterprise.reportingPrivate.PresenceValue"},"value":{"optional":true,"name":"value","type":"string"}},"type":"object"},{"id":"enterprise.reportingPrivate.EventResult","type":"string","enum":[{"name":"EVENT_RESULT_DATA_MASKED"},{"name":"EVENT_RESULT_DATA_UNMASKED"}]},{"id":"enterprise.reportingPrivate.DetectorType","type":"string","enum":[{"name":"PREDEFINED_DLP"},{"name":"USER_DEFINED"}]},{"id":"enterprise.reportingPrivate.MatchedDetector","properties":{"detectorId":{"name":"detectorId","type":"string"},"displayName":{"name":"displayName","type":"string"},"maskType":{"optional":true,"name":"maskType","type":"string"},"pattern":{"optional":true,"name":"pattern","type":"string"},"detectorType":{"optional":true,"name":"detectorType","$ref":"enterprise.reportingPrivate.DetectorType"}},"type":"object"},{"id":"enterprise.reportingPrivate.TriggeredRuleInfo","properties":{"ruleId":{"name":"ruleId","type":"string"},"ruleName":{"name":"ruleName","type":"string"},"matchedDetectors":{"name":"matchedDetectors","type":"array","items":{"$ref":"enterprise.reportingPrivate.MatchedDetector"}}},)R" R"R("type":"object"},{"id":"enterprise.reportingPrivate.DataMaskingEvent","properties":{"url":{"name":"url","type":"string"},"eventResult":{"name":"eventResult","$ref":"enterprise.reportingPrivate.EventResult"},"triggeredRuleInfo":{"name":"triggeredRuleInfo","type":"array","items":{"$ref":"enterprise.reportingPrivate.TriggeredRuleInfo"}}},"type":"object"},{"id":"enterprise.reportingPrivate.DataMaskingRules","properties":{"url":{"name":"url","type":"string"},"triggeredRuleInfo":{"name":"triggeredRuleInfo","type":"array","items":{"$ref":"enterprise.reportingPrivate.TriggeredRuleInfo"}}},"type":"object"}],"functions":[{"platforms":["win","mac","linux"],"parameters":[],"returns_async":{"name":"callback","optional":true,"parameters":[{"name":"id","type":"string"}]},"name":"getDeviceId","type":"function"},{"platforms":["win","mac"],"parameters":[{"name":"resetSecret","optional":true,"type":"boolean"}],"returns_async":{"name":"callback","parameters":[{"name":"secret","type":"binary","isInstanceOf":"ArrayBuffer"}]},"name":"getPersistentSecret","type":"function"},{"platforms":["win","mac","linux"],"parameters":[{"name":"id","type":"string"}],"returns_async":{"name":"callback","parameters":[{"name":"data","type":"binary","isInstanceOf":"ArrayBuffer"}]},"name":"getDeviceData","type":"function"},{"platforms":["win","mac","linux"],"parameters":[{"name":"id","type":"string"},{"name":"data","optional":true,"type":"binary","isInstanceOf":"ArrayBuffer"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"setDeviceData","type":"function"},{"platforms":["win","mac","linux"],"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"deviceInfo","$ref":"enterprise.reportingPrivate.DeviceInfo"}]},"name":"getDeviceInfo","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"contextInfo","$ref":"enterprise.reportingPrivate.ContextInfo"}]},"name":"getContextInfo","type":"function"},{"parameters":[{"name":"url","type":"string"}],"returns_async":{"name":"callback","parameters":[{"name":"certificate","$ref":"enterprise.reportingPrivate.Certificate"}]},"name":"getCertificate","type":"function"},{"platforms":["chromeos"],"parameters":[{"name":"request","$ref":"enterprise.reportingPrivate.EnqueueRecordRequest"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"enqueueRecord","type":"function"},{"platforms":["win","mac","linux"],"parameters":[{"name":"request","$ref":"enterprise.reportingPrivate.GetFileSystemInfoRequest"}],"returns_async":{"name":"callback","parameters":[{"name":"fileSystemSignals","type":"array","items":{"$ref":"enterprise.reportingPrivate.GetFileSystemInfoResponse"}}]},"name":"getFileSystemInfo","type":"function"},{"platforms":["win","mac"],"parameters":[{"name":"request","$ref":"enterprise.reportingPrivate.GetSettingsRequest"}],"returns_async":{"name":"callback","parameters":[{"name":"settings","type":"array","items":{"$ref":"enterprise.reportingPrivate.GetSettingsResponse"}}]},"name":"getSettings","type":"function"},{"platforms":["win"],"parameters":[{"name":"userContext","$ref":"enterprise.reportingPrivate.UserContext"}],"returns_async":{"name":"callback","parameters":[{"name":"avSignals","type":"array","items":{"$ref":"enterprise.reportingPrivate.AntiVirusSignal"}}]},"name":"getAvInfo","type":"function"},{"platforms":["win"],"parameters":[{"name":"userContext","$ref":"enterprise.reportingPrivate.UserContext"}],"returns_async":{"name":"callback","parameters":[{"name":"hotfixSignals","type":"array","items":{"$ref":"enterprise.reportingPrivate.HotfixSignal"}}]},"name":"getHotfixes","type":"function"},{"parameters":[{"name":"event","$ref":"enterprise.reportingPrivate.DataMaskingEvent"}],"returns_async":{"name":"callback","parameters":[]},"name":"reportDataMaskingEvent","type":"function"}],"properties":{},"events":[{"parameters":[{"name":"rules","$ref":"enterprise.reportingPrivate.DataMaskingRules"}],"name":"onDataMaskingRulesTriggered","type":"function"}],"platforms":null,"deprecated":null})R";
constexpr char kImageWriterPrivate[] = R"R({"namespace":"imageWriterPrivate","types":[{"id":"imageWriterPrivate.Stage","type":"string","enum":[{"name":"confirmation"},{"name":"download"},{"name":"verifyDownload"},{"name":"unzip"},{"name":"write"},{"name":"verifyWrite"},{"name":"unknown"}]},{"id":"imageWriterPrivate.UrlWriteOptions","properties":{"imageHash":{"optional":true,"name":"imageHash","type":"string"},"saveAsDownload":{"optional":true,"name":"saveAsDownload","type":"boolean"}},"type":"object"},{"id":"imageWriterPrivate.ProgressInfo","properties":{"stage":{"name":"stage","$ref":"imageWriterPrivate.Stage"},"percentComplete":{"name":"percentComplete","type":"integer"}},"type":"object"},{"id":"imageWriterPrivate.RemovableStorageDevice","properties":{"storageUnitId":{"name":"storageUnitId","type":"string"},"capacity":{"name":"capacity","type":"number"},"vendor":{"name":"vendor","type":"string"},"model":{"name":"model","type":"string"},"removable":{"name":"removable","type":"boolean"}},"type":"object"}],"functions":[{"parameters":[{"name":"storageUnitId","type":"string"},{"name":"imageUrl","type":"string"},{"name":"options","optional":true,"$ref":"imageWriterPrivate.UrlWriteOptions"}],"returns_async":{"name":"callback","parameters":[]},"name":"writeFromUrl","type":"function"},{"parameters":[{"name":"storageUnitId","type":"string"},{"name":"fileEntry","type":"object","additionalProperties":{"type":"any"},"isInstanceOf":"FileEntry"}],"returns_async":{"name":"callback","parameters":[]},"name":"writeFromFile","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[]},"name":"cancelWrite","type":"function"},{"parameters":[{"name":"storageUnitId","type":"string"}],"returns_async":{"name":"callback","parameters":[]},"name":"destroyPartitions","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"devices","type":"array","items":{"$ref":"imageWriterPrivate.RemovableStorageDevice"}}]},"name":"listRemovableStorageDevices","type":"function"}],"properties":{},"events":[{"parameters":[{"name":"info","$ref":"imageWriterPrivate.ProgressInfo"}],"name":"onWriteProgress","type":"function"},{"parameters":[],"name":"onWriteComplete","type":"function"},{"parameters":[{"name":"info","$ref":"imageWriterPrivate.ProgressInfo"},{"name":"error","type":"string"}],"name":"onWriteError","type":"function"},{"parameters":[{"name":"device","$ref":"imageWriterPrivate.RemovableStorageDevice"}],"name":"onDeviceInserted","type":"function"},{"parameters":[{"name":"device","$ref":"imageWriterPrivate.RemovableStorageDevice"}],"name":"onDeviceRemoved","type":"function"}],"platforms":null,"deprecated":null})R";
constexpr char kLanguageSettingsPrivate[] = R"R({"namespace":"languageSettingsPrivate","types":[{"id":"languageSettingsPrivate.MoveType","type":"string","enum":[{"name":"TOP"},{"name":"UP"},{"name":"DOWN"},{"name":"UNKNOWN"}]},{"id":"languageSettingsPrivate.Language","properties":{"code":{"name":"code","type":"string"},"displayName":{"name":"displayName","type":"string"},"nativeDisplayName":{"name":"nativeDisplayName","type":"string"},"supportsUI":{"optional":true,"name":"supportsUI","type":"boolean"},"supportsSpellcheck":{"optional":true,"name":"supportsSpellcheck","type":"boolean"},"supportsTranslate":{"optional":true,"name":"supportsTranslate","type":"boolean"},"isProhibitedLanguage":{"optional":true,"name":"isProhibitedLanguage","type":"boolean"}},"type":"object"},{"id":"languageSettingsPrivate.SpellcheckDictionaryStatus","properties":{"languageCode":{"name":"languageCode","type":"string"},"isReady":{"name":"isReady","type":"boolean"},"isDownloading":{"optional":true,"name":"isDownloading","type":"boolean"},"downloadFailed":{"optional":true,"name":"downloadFailed","type":"boolean"}},"type":"object"},{"id":"languageSettingsPrivate.InputMethod","properties":{"id":{"name":"id","type":"string"},"displayName":{"name":"displayName","type":"string"},"languageCodes":{"name":"languageCodes","type":"array","items":{"type":"string"}},"tags":{"name":"tags","type":"array","items":{"type":"string"}},"enabled":{"optional":true,"name":"enabled","type":"boolean"},"hasOptionsPage":{"optional":true,"name":"hasOptionsPage","type":"boolean"},"isProhibitedByPolicy":{"optional":true,"name":"isProhibitedByPolicy","type":"boolean"}},"type":"object"},{"id":"languageSettingsPrivate.InputMethodLists","properties":{"componentExtensionImes":{"name":"componentExtensionImes","type":"array","items":{"$ref":"languageSettingsPrivate.InputMethod"}},"thirdPartyExtensionImes":{"name":"thirdPartyExtensionImes","type":"array","items":{"$ref":"languageSettingsPrivate.InputMethod"}}},"type":"object"}],"functions":[{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"languages","type":"array","items":{"$ref":"languageSettingsPrivate.Language"}}]},"name":"getLanguageList","type":"function"},{"parameters":[{"name":"languageCode","type":"string"}],"name":"enableLanguage","type":"function"},{"parameters":[{"name":"languageCode","type":"string"}],"name":"disableLanguage","type":"function"},{"parameters":[{"name":"languageCode","type":"string"},{"name":"enable","type":"boolean"}],"name":"setEnableTranslationForLanguage","type":"function"},{"parameters":[{"name":"languageCode","type":"string"},{"name":"moveType","$ref":"languageSettingsPrivate.MoveType"}],"name":"moveLanguage","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"languageCodes","type":"array","items":{"type":"string"}}]},"name":"getAlwaysTranslateLanguages","type":"function"},{"parameters":[{"name":"languageCode","type":"string"},{"name":"alwaysTranslate","type":"boolean"}],"name":"setLanguageAlwaysTranslateState","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"languageCodes","type":"array","items":{"type":"string"}}]},"name":"getNeverTranslateLanguages","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"status","type":"array","items":{"$ref":"languageSettingsPrivate.SpellcheckDictionaryStatus"}}]},"name":"getSpellcheckDictionaryStatuses","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"words","type":"array","items":{"type":"string"}}]},"name":"getSpellcheckWords","type":"function"},{"parameters":[{"name":"word","type":"string"}],"name":"addSpellcheckWord","type":"function"},{"parameters":[{"name":"word","type":"string"}],"name":"removeSpellcheckWord","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"languageCode","type":"string"}]},"name":"getTranslateTargetLanguage","type":"function"},{"parameters":[{"name":"languageCode","type":"string"}],"name":"setTranslateTargetLanguage","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"lists","$ref":"languageSettingsPrivate.InputMethodLists"}]},"name":"getInputMethodLists","type":"function"},{"parameters":[{"name":"inputMethodId","type":"string"}],"name":"addInputMethod","type":"function"},{"parameters":[{"name":"inputMethodId","type":"string"}],"name":"removeInputMethod","type":"function"},{"parameters":[{"name":"languageCode","type":"string"}],"name":"retryDownloadDictionary","type":"function"}],"properties":{},"events":[{"parameters":[{"name":"statuses","type":"array","items":{"$ref":"languageSettingsPrivate.SpellcheckDictionaryStatus"}}],"name":"onSpellcheckDictionariesChanged","type":"function"},{"parameters":[{"name":"wordsAdded","type":"array","items":{"type":"string"}},{"name":"wordsRemoved","type":"array","items":{"type":"string"}}],"name":"onCustomDictionaryChanged","type":"function"},{"parameters":[{"name":"inputMethodId","type":"string"}],"name":"onInputMethodAdded","type":"function"},{"parameters":[{"name":"inputMethodId","type":"string"}],"name":"onInputMethodRemoved","type":"function"}],"platforms":null,"deprecated":null})R";
constexpr char kPasswordsPrivate[] = R"R({"namespace":"passwordsPrivate","types":[{"id":"passwordsPrivate.PlaintextReason","type":"string","enum":[{"name":"VIEW"},{"name":"COPY"},{"name":"EDIT"}]},{"id":"passwordsPrivate.ExportProgressStatus","type":"string","enum":[{"name":"NOT_STARTED"},{"name":"IN_PROGRESS"},{"name":"SUCCEEDED"},{"name":"FAILED_CANCELLED"},{"name":"FAILED_WRITE_FAILED"}]},{"id":"passwordsPrivate.CompromiseType","type":"string","enum":[{"name":"LEAKED"},{"name":"PHISHED"},{"name":"REUSED"},{"name":"WEAK"}]},{"id":"passwordsPrivate.PasswordStoreSet","type":"string","enum":[{"name":"DEVICE"},{"name":"ACCOUNT"},{"name":"DEVICE_AND_ACCOUNT"}]},{"id":"passwordsPrivate.PasswordCheckState","type":"string","enum":[{"name":"IDLE"},{"name":"RUNNING"},{"name":"CANCELED"},{"name":"OFFLINE"},{"name":"SIGNED_OUT"},{"name":"NO_PASSWORDS"},{"name":"QUOTA_LIMIT"},{"name":"OTHER_ERROR"}]},{"id":"passwordsPrivate.ImportResultsStatus","type":"string","enum":[{"name":"UNKNOWN_ERROR"},{"name":"SUCCESS"},{"name":"IO_ERROR"},{"name":"BAD_FORMAT"},{"name":"DISMISSED"},{"name":"MAX_FILE_SIZE"},{"name":"IMPORT_ALREADY_ACTIVE"},{"name":"NUM_PASSWORDS_EXCEEDED"},{"name":"CONFLICTS"}]},{"id":"passwordsPrivate.ImportEntryStatus","type":"string","enum":[{"name":"UNKNOWN_ERROR"},{"name":"MISSING_PASSWORD"},{"name":"MISSING_URL"},{"name":"INVALID_URL"},{"name":"NON_ASCII_URL"},{"name":"LONG_URL"},{"name":"LONG_PASSWORD"},{"name":"LONG_USERNAME"},{"name":"CONFLICT_PROFILE"},{"name":"CONFLICT_ACCOUNT"},{"name":"LONG_NOTE"},{"name":"LONG_CONCATENATED_NOTE"},{"name":"VALID"}]},{"id":"passwordsPrivate.FamilyFetchStatus","type":"string","enum":[{"name":"UNKNOWN_ERROR"},{"name":"NO_MEMBERS"},{"name":"SUCCESS"}]},{"id":"passwordsPrivate.PublicKey","properties":{"value":{"name":"value","type":"string"},"version":{"name":"version","type":"integer"}},"type":"object"},{"id":"passwordsPrivate.RecipientInfo","properties":{"userId":{"name":"userId","type":"string"},"email":{"name":"email","type":"string"},"displayName":{"name":"displayName","type":"string"},"profileImageUrl":{"name":"profileImageUrl","type":"string"},"isEligible":{"name":"isEligible","type":"boolean"},"publicKey":{"optional":true,"name":"publicKey","$ref":"passwordsPrivate.PublicKey"}},"type":"object"},{"id":"passwordsPrivate.FamilyFetchResults","properties":{"status":{"name":"status","$ref":"passwordsPrivate.FamilyFetchStatus"},"familyMembers":{"name":"familyMembers","type":"array","items":{"$ref":"passwordsPrivate.RecipientInfo"}}},"type":"object"},{"id":"passwordsPrivate.ImportEntry","properties":{"status":{"name":"status","$ref":"passwordsPrivate.ImportEntryStatus"},"url":{"name":"url","type":"string"},"username":{"name":"username","type":"string"},"password":{"name":"password","type":"string"},"id":{"name":"id","type":"integer"}},"type":"object"},{"id":"passwordsPrivate.ImportResults","properties":{"status":{"name":"status","$ref":"passwordsPrivate.ImportResultsStatus"},"numberImported":{"name":"numberImported","type":"integer"},"displayedEntries":{"name":"displayedEntries","type":"array","items":{"$ref":"passwordsPrivate.ImportEntry"}},"fileName":{"name":"fileName","type":"string"}},"type":"object"},{"id":"passwordsPrivate.UrlCollection","properties":{"signonRealm":{"name":"signonRealm","type":"string"},"shown":{"name":"shown","type":"string"},"link":{"name":"link","type":"string"}},"type":"object"},{"id":"passwordsPrivate.CompromisedInfo","properties":{"compromiseTime":{"name":"compromiseTime","type":"number"},"elapsedTimeSinceCompromise":{"name":"elapsedTimeSinceCompromise","type":"string"},"compromiseTypes":{"name":"compromiseTypes","type":"array","items":{"$ref":"passwordsPrivate.CompromiseType"}},"isMuted":{"name":"isMuted","type":"boolean"}},"type":"object"},{"id":"passwordsPrivate.DomainInfo","properties":{"name":{"name":"name","type":"string"},"url":{"name":"url","type":"string"},"signonRealm":{"name":"signonRealm","type":"string"}},"type":"object"},{"id":"passwordsPrivate.BackupPasswordInfo","properties":{"value":{"name":"value","type":"string"},"creationDate":{"name":"creationDate","type":"string"}},"type":"object"},{"id":"passwordsPrivate.PasswordUiEntry","properties":{"affiliatedDomains":{"name":"affiliatedDomains","type":"array","items":{"$ref":"passwordsPrivate.DomainInfo"}},"username":{"name":"username","type":"string"},"displayName":{"optional":true,"name":"displayName","type":"string"},"password":{"optional":true,"name":"password","type":"string"},"backupPassword":{"optional":true,"name":"backupPassword","$ref":"passwordsPrivate.BackupPasswordInfo"},"federationText":{"optional":true,"name":"federationText","type":"string"},"id":{"name":"id","type":"integer"},"storedIn":{"name":"storedIn","$ref":"passwordsPrivate.PasswordStoreSet"},"isPasskey":{"name":"isPasskey","type":"boolean"},"note":{"optional":true,"name":"note","type":"string"},"changePasswordUrl":{"optional":true,"name":"changePasswordUrl","type":"string"},"compromisedInfo":{"optional":true,"name":"compromisedInfo","$ref":"passwordsPrivate.CompromisedInfo"},"creationTime":{"optional":true,"name":"creationTime","type":"number"},"hidden":{"name":"hidden","type":"boolean"}},"type":"object"},{"id":"passwordsPrivate.CredentialGroup","properties":{"name":{"name":"name","type":"string"},"iconUrl":{"name":"iconUrl","type":"string"},"entries":{"name":"entries","type":"array","items":{"$ref":"passwordsPrivate.PasswordUiEntry"}}},"type":"object"},{"id":"passwordsPrivate.ExceptionEntry","properties":{"urls":{"name":"urls","$ref":"passwordsPrivate.UrlCollection"},"id":{"name":"id","type":"integer"}},"type":"object"},{"id":"passwordsPrivate.PasswordExportProgress","properties":{"status":{"name":"status","$ref":"passwordsPrivate.ExportProgressStatus"},"filePath":{"optional":true,"name":"filePath","type":"string"},"folderName":{"optional":true,"name":"folderName","type":"string"}},"type":"object"},{"id":"passwordsPrivate.PasswordCheckStatus","properties":{"state":{"name":"state","$ref":"passwordsPrivate.PasswordCheckState"},"totalNumberOfPasswords":{"optional":true,"name":"totalNumberOfPasswords","type":"integer"},"alreadyProcessed":{"optional":true,"name":"alreadyProcessed","type":"integer"},"remainingInQueue":{"optional":true,"name":"remainingInQueue","type":"integer"},"elapsedTimeSinceLastCheck":{"optional":true,"name":"elapsedTimeSinceLastCheck","type":"string"}},"type":"object"},{"id":"passwordsPrivate.AddPasswordOptions","properties":{"url":{"name":"url","type":"string"},"username":{"name":"username","type":"string"},"password":{"name":"password","type":"string"},"note":{"name":"note","type":"string"},"useAccountStore":{"name":"useAccountStore","type":"boolean"}},"type":"object"},{"id":"passwordsPrivate.PasswordUiEntryList","properties":{"entries":{"name":"entries","type":"array","items":{"$ref":"passwordsPrivate.PasswordUiEntry"}}},"type":"object"}],"functions":[{"parameters":[],"name":"recordPasswordsPageAccessInSettings","type":"function"},{"parameters":[{"name":"credential","$ref":"passwordsPrivate.PasswordUiEntry"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"changeCredential","type":"function"},{"parameters":[{"name":"id","type":"integer"},{"name":"fromStores","$ref":"passwordsPrivate.PasswordStoreSet"}],"name":"removeCredential","type":"function"},{"parameters":[{"name":"id","type":"integer"}],"name":"removePasswordException","type":"function"},{"parameters":[],"name":"undoRemoveSavedPasswordOrException","type":"function"},{"parameters":[{"name":"id","type":"integer"},{"name":"reason","$ref":"passwordsPrivate.PlaintextReason"}],"returns_async":{"name":"callback","parameters":[{"name":"password","type":"string"}]},"name":"requestPlaintextPassword","type":"function"},{"parameters":[{"name":"ids","type":"array","items":{"type":"integer"}}],"returns_async":{"name":"callback","parameters":[{"name":"entries","type":"array","items":{"$ref":"passwordsPrivate.PasswordUiEntry"}}]},"name":"requestCredentialsDetails","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"entries","type":"array","items":{"$ref":"passwordsPrivate.PasswordUiEntry"}}]},"name":"getSavedPasswordList","type":"function"},{"parame)R" R"R(ters":[],"returns_async":{"name":"callback","parameters":[{"name":"entries","type":"array","items":{"$ref":"passwordsPrivate.CredentialGroup"}}]},"name":"getCredentialGroups","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"exceptions","type":"array","items":{"$ref":"passwordsPrivate.ExceptionEntry"}}]},"name":"getPasswordExceptionList","type":"function"},{"parameters":[{"name":"ids","type":"array","items":{"type":"integer"}}],"name":"movePasswordsToAccount","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"results","$ref":"passwordsPrivate.FamilyFetchResults"}]},"name":"fetchFamilyMembers","type":"function"},{"parameters":[{"name":"id","type":"integer"},{"name":"recipients","type":"array","items":{"$ref":"passwordsPrivate.RecipientInfo"}}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"sharePassword","type":"function"},{"parameters":[{"name":"toStore","$ref":"passwordsPrivate.PasswordStoreSet"}],"returns_async":{"name":"callback","parameters":[{"name":"results","$ref":"passwordsPrivate.ImportResults"}]},"name":"importPasswords","type":"function"},{"parameters":[{"name":"selectedIds","type":"array","items":{"type":"integer"}}],"returns_async":{"name":"callback","parameters":[{"name":"results","$ref":"passwordsPrivate.ImportResults"}]},"name":"continueImport","type":"function"},{"parameters":[{"name":"deleteFile","type":"boolean"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"resetImporter","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[]},"name":"exportPasswords","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"status","$ref":"passwordsPrivate.ExportProgressStatus"}]},"name":"requestExportProgressStatus","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"enabled","type":"boolean"}]},"name":"isAccountStorageEnabled","type":"function"},{"parameters":[{"name":"enabled","type":"boolean"}],"name":"setAccountStorageEnabled","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"show","type":"boolean"}]},"name":"shouldShowAccountStorageSettingToggle","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"entries","type":"array","items":{"$ref":"passwordsPrivate.PasswordUiEntry"}}]},"name":"getInsecureCredentials","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"entries","type":"array","items":{"$ref":"passwordsPrivate.PasswordUiEntryList"}}]},"name":"getCredentialsWithReusedPassword","type":"function"},{"parameters":[{"name":"credential","$ref":"passwordsPrivate.PasswordUiEntry"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"muteInsecureCredential","type":"function"},{"parameters":[{"name":"credential","$ref":"passwordsPrivate.PasswordUiEntry"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"unmuteInsecureCredential","type":"function"},{"parameters":[],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"startPasswordCheck","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"status","$ref":"passwordsPrivate.PasswordCheckStatus"}]},"name":"getPasswordCheckStatus","type":"function"},{"parameters":[{"name":"url","type":"string"}],"returns_async":{"name":"callback","parameters":[{"name":"urlCollection","$ref":"passwordsPrivate.UrlCollection"}]},"name":"getUrlCollection","type":"function"},{"parameters":[{"name":"options","$ref":"passwordsPrivate.AddPasswordOptions"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"addPassword","type":"function"},{"parameters":[],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"extendAuthValidity","type":"function"},{"platforms":["win","mac","chromeos"],"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"result","type":"boolean"}]},"name":"switchBiometricAuthBeforeFillingState","type":"function"},{"parameters":[],"name":"showAddShortcutDialog","type":"function"},{"parameters":[{"name":"file_path","type":"string"}],"name":"showExportedFileInShell","type":"function"},{"parameters":[],"returns_async":{"name":"callback","optional":true,"parameters":[{"name":"success","type":"boolean"}]},"name":"changePasswordManagerPin","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"available","type":"boolean"}]},"name":"isPasswordManagerPinAvailable","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"success","type":"boolean"}]},"name":"disconnectCloudAuthenticator","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"connected","type":"boolean"}]},"name":"isConnectedToCloudAuthenticator","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"success","type":"boolean"}]},"name":"deleteAllPasswordManagerData","type":"function"}],"properties":{},"events":[{"parameters":[{"name":"entries","type":"array","items":{"$ref":"passwordsPrivate.PasswordUiEntry"}}],"name":"onSavedPasswordsListChanged","type":"function"},{"parameters":[{"name":"exceptions","type":"array","items":{"$ref":"passwordsPrivate.ExceptionEntry"}}],"name":"onPasswordExceptionsListChanged","type":"function"},{"parameters":[{"name":"status","$ref":"passwordsPrivate.PasswordExportProgress"}],"name":"onPasswordsFileExportProgress","type":"function"},{"parameters":[{"name":"enabled","type":"boolean"}],"name":"onAccountStorageEnabledStateChanged","type":"function"},{"parameters":[{"name":"show","type":"boolean"}],"name":"onShouldShowAccountStorageSettingToggleChanged","type":"function"},{"parameters":[{"name":"insecureCredentials","type":"array","items":{"$ref":"passwordsPrivate.PasswordUiEntry"}}],"name":"onInsecureCredentialsChanged","type":"function"},{"parameters":[{"name":"status","$ref":"passwordsPrivate.PasswordCheckStatus"}],"name":"onPasswordCheckStatusChanged","type":"function"},{"parameters":[],"name":"onPasswordManagerAuthTimeout","type":"function"}],"platforms":null,"deprecated":null})R";
constexpr char kResourcesPrivate[] = R"R({"namespace":"resourcesPrivate","types":[{"id":"resourcesPrivate.Component","type":"string","enum":[{"name":"identity"},{"name":"pdf"}]}],"functions":[{"parameters":[{"name":"component","$ref":"resourcesPrivate.Component"}],"returns_async":{"name":"callback","parameters":[{"name":"result","type":"object","additionalProperties":{"type":"any"}}]},"name":"getStrings","type":"function"}],"properties":{},"events":[],"platforms":null,"deprecated":null})R";
constexpr char kSafeBrowsingPrivate[] = R"R({"namespace":"safeBrowsingPrivate","types":[{"id":"safeBrowsingPrivate.URLType","type":"string","enum":[{"name":"EVENT_URL"},{"name":"LANDING_PAGE"},{"name":"LANDING_REFERRER"},{"name":"CLIENT_REDIRECT"},{"name":"RECENT_NAVIGATION"},{"name":"REFERRER"}]},{"id":"safeBrowsingPrivate.NavigationInitiation","type":"string","enum":[{"name":"BROWSER_INITIATED"},{"name":"RENDERER_INITIATED_WITHOUT_USER_GESTURE"},{"name":"RENDERER_INITIATED_WITH_USER_GESTURE"},{"name":"COPY_PASTE_USER_INITIATED"},{"name":"NOTIFICATION_INITIATED"}]},{"id":"safeBrowsingPrivate.PolicySpecifiedPasswordReuse","properties":{"url":{"name":"url","type":"string"},"userName":{"name":"userName","type":"string"},"isPhishingUrl":{"name":"isPhishingUrl","type":"boolean"}},"type":"object"},{"id":"safeBrowsingPrivate.DangerousDownloadInfo","properties":{"url":{"name":"url","type":"string"},"fileName":{"name":"fileName","type":"string"},"downloadDigestSha256":{"name":"downloadDigestSha256","type":"string"},"userName":{"name":"userName","type":"string"}},"type":"object"},{"id":"safeBrowsingPrivate.InterstitialInfo","properties":{"url":{"name":"url","type":"string"},"reason":{"name":"reason","type":"string"},"netErrorCode":{"optional":true,"name":"netErrorCode","type":"string"},"userName":{"name":"userName","type":"string"}},"type":"object"},{"id":"safeBrowsingPrivate.ServerRedirect","properties":{"url":{"optional":true,"name":"url","type":"string"}},"type":"object"},{"id":"safeBrowsingPrivate.ReferrerChainEntry","properties":{"url":{"name":"url","type":"string"},"mainFrameUrl":{"optional":true,"name":"mainFrameUrl","type":"string"},"urlType":{"name":"urlType","$ref":"safeBrowsingPrivate.URLType"},"ipAddresses":{"optional":true,"name":"ipAddresses","type":"array","items":{"type":"string"}},"referrerUrl":{"optional":true,"name":"referrerUrl","type":"string"},"referrerMainFrameUrl":{"optional":true,"name":"referrerMainFrameUrl","type":"string"},"isRetargeting":{"optional":true,"name":"isRetargeting","type":"boolean"},"navigationTimeMs":{"optional":true,"name":"navigationTimeMs","type":"number"},"serverRedirectChain":{"optional":true,"name":"serverRedirectChain","type":"array","items":{"$ref":"safeBrowsingPrivate.ServerRedirect"}},"navigationInitiation":{"optional":true,"name":"navigationInitiation","$ref":"safeBrowsingPrivate.NavigationInitiation"},"maybeLaunchedByExternalApp":{"optional":true,"name":"maybeLaunchedByExternalApp","type":"boolean"},"isSubframeUrlRemoved":{"optional":true,"name":"isSubframeUrlRemoved","type":"boolean"},"isSubframeReferrerUrlRemoved":{"optional":true,"name":"isSubframeReferrerUrlRemoved","type":"boolean"},"isUrlRemovedByPolicy":{"name":"isUrlRemovedByPolicy","type":"boolean"}},"type":"object"}],"functions":[{"parameters":[{"name":"tabId","type":"integer"}],"returns_async":{"name":"callback","parameters":[{"name":"entries","type":"array","items":{"$ref":"safeBrowsingPrivate.ReferrerChainEntry"}}]},"name":"getReferrerChain","type":"function"}],"properties":{},"events":[{"parameters":[{"name":"reuseDetails","$ref":"safeBrowsingPrivate.PolicySpecifiedPasswordReuse"}],"name":"onPolicySpecifiedPasswordReuseDetected","type":"function"},{"parameters":[{"name":"userName","type":"string"}],"name":"onPolicySpecifiedPasswordChanged","type":"function"},{"parameters":[{"name":"dict","$ref":"safeBrowsingPrivate.DangerousDownloadInfo"}],"name":"onDangerousDownloadOpened","type":"function"},{"parameters":[{"name":"dict","$ref":"safeBrowsingPrivate.InterstitialInfo"}],"name":"onSecurityInterstitialShown","type":"function"},{"parameters":[{"name":"dict","$ref":"safeBrowsingPrivate.InterstitialInfo"}],"name":"onSecurityInterstitialProceeded","type":"function"}],"platforms":null,"deprecated":null})R";
constexpr char kSessions[] = R"R({"namespace":"sessions","types":[{"id":"sessions.Filter","type":"object","properties":{"maxResults":{"type":"integer","minimum":0,"maximum":25,"optional":true}}},{"id":"sessions.Session","type":"object","properties":{"lastModified":{"type":"integer"},"tab":{"$ref":"tabs.Tab","optional":true},"window":{"$ref":"windows.Window","optional":true}}},{"id":"sessions.Device","type":"object","properties":{"info":{"type":"string"},"deviceName":{"type":"string"},"sessions":{"type":"array","items":{"$ref":"sessions.Session"}}}}],"functions":[{"name":"getRecentlyClosed","type":"function","parameters":[{"$ref":"sessions.Filter","name":"filter","optional":true}],"returns_async":{"name":"callback","parameters":[{"name":"sessions","type":"array","items":{"$ref":"sessions.Session"}}]}},{"name":"getDevices","type":"function","parameters":[{"$ref":"sessions.Filter","name":"filter","optional":true}],"returns_async":{"name":"callback","parameters":[{"name":"devices","type":"array","items":{"$ref":"sessions.Device"}}]}},{"name":"restore","type":"function","parameters":[{"type":"string","name":"sessionId","optional":true}],"returns_async":{"name":"callback","optional":true,"parameters":[{"$ref":"sessions.Session","name":"restoredSession"}]}}],"events":[{"name":"onChanged","type":"function"}],"properties":{"MAX_SESSION_RESULTS":{"value":25,"type":"integer"}}})R";
constexpr char kSettingsPrivate[] = R"R({"namespace":"settingsPrivate","types":[{"id":"settingsPrivate.PrefType","type":"string","enum":[{"name":"BOOLEAN"},{"name":"NUMBER"},{"name":"STRING"},{"name":"URL"},{"name":"LIST"},{"name":"DICTIONARY"}]},{"id":"settingsPrivate.ControlledBy","type":"string","enum":[{"name":"DEVICE_POLICY"},{"name":"USER_POLICY"},{"name":"OWNER"},{"name":"PRIMARY_USER"},{"name":"EXTENSION"},{"name":"PARENT"},{"name":"CHILD_RESTRICTION"},{"name":"SAFE_BROWSING_OFF"}]},{"id":"settingsPrivate.Enforcement","type":"string","enum":[{"name":"ENFORCED"},{"name":"RECOMMENDED"},{"name":"PARENT_SUPERVISED"}]},{"id":"settingsPrivate.PrefObject","properties":{"key":{"name":"key","type":"string"},"type":{"name":"type","$ref":"settingsPrivate.PrefType"},"value":{"optional":true,"name":"value","type":"any"},"controlledBy":{"optional":true,"name":"controlledBy","$ref":"settingsPrivate.ControlledBy"},"controlledByName":{"optional":true,"name":"controlledByName","type":"string"},"enforcement":{"optional":true,"name":"enforcement","$ref":"settingsPrivate.Enforcement"},"recommendedValue":{"optional":true,"name":"recommendedValue","type":"any"},"userSelectableValues":{"optional":true,"name":"userSelectableValues","type":"array","items":{"type":"any"}},"userControlDisabled":{"optional":true,"name":"userControlDisabled","type":"boolean"},"extensionId":{"optional":true,"name":"extensionId","type":"string"},"extensionCanBeDisabled":{"optional":true,"name":"extensionCanBeDisabled","type":"boolean"}},"type":"object"}],"functions":[{"parameters":[{"name":"name","type":"string"},{"name":"value","type":"any"},{"name":"pageId","optional":true,"type":"string"}],"returns_async":{"name":"callback","optional":true,"parameters":[{"name":"success","type":"boolean"}]},"name":"setPref","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"prefs","type":"array","items":{"$ref":"settingsPrivate.PrefObject"}}]},"name":"getAllPrefs","type":"function"},{"parameters":[{"name":"name","type":"string"}],"returns_async":{"name":"callback","parameters":[{"name":"pref","$ref":"settingsPrivate.PrefObject"}]},"name":"getPref","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"zoom","type":"number"}]},"name":"getDefaultZoom","type":"function"},{"parameters":[{"name":"zoom","type":"number"}],"returns_async":{"name":"callback","optional":true,"parameters":[{"name":"success","type":"boolean"}]},"name":"setDefaultZoom","type":"function"}],"properties":{},"events":[{"parameters":[{"name":"prefs","type":"array","items":{"$ref":"settingsPrivate.PrefObject"}}],"name":"onPrefsChanged","type":"function"}],"platforms":null,"deprecated":null})R";
constexpr char kSidePanel[] = R"R({"namespace":"sidePanel","types":[{"id":"sidePanel.SidePanel","properties":{"default_path":{"name":"default_path","type":"string"}},"type":"object"},{"id":"sidePanel.Side","type":"string","enum":[{"name":"left"},{"name":"right"}]},{"id":"sidePanel.PanelLayout","properties":{"side":{"name":"side","$ref":"sidePanel.Side"}},"type":"object"},{"id":"sidePanel.PanelOptions","properties":{"tabId":{"optional":true,"name":"tabId","type":"integer"},"path":{"optional":true,"name":"path","type":"string"},"enabled":{"optional":true,"name":"enabled","type":"boolean"}},"type":"object"},{"id":"sidePanel.PanelBehavior","properties":{"openPanelOnActionClick":{"optional":true,"name":"openPanelOnActionClick","type":"boolean"}},"type":"object"},{"id":"sidePanel.GetPanelOptions","properties":{"tabId":{"optional":true,"name":"tabId","type":"integer"}},"type":"object"},{"id":"sidePanel.OpenOptions","properties":{"windowId":{"optional":true,"name":"windowId","type":"integer"},"tabId":{"optional":true,"name":"tabId","type":"integer"}},"type":"object"},{"id":"sidePanel.CloseOptions","properties":{"windowId":{"optional":true,"name":"windowId","type":"integer"},"tabId":{"optional":true,"name":"tabId","type":"integer"}},"type":"object"},{"id":"sidePanel.PanelOpenedInfo","properties":{"windowId":{"name":"windowId","type":"integer"},"tabId":{"optional":true,"name":"tabId","type":"integer"},"path":{"name":"path","type":"string"}},"type":"object"},{"id":"sidePanel.PanelClosedInfo","properties":{"windowId":{"name":"windowId","type":"integer"},"tabId":{"optional":true,"name":"tabId","type":"integer"},"path":{"name":"path","type":"string"}},"type":"object"}],"functions":[{"parameters":[{"name":"options","$ref":"sidePanel.PanelOptions"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"setOptions","type":"function"},{"parameters":[{"name":"options","$ref":"sidePanel.GetPanelOptions"}],"returns_async":{"name":"callback","parameters":[{"name":"options","$ref":"sidePanel.PanelOptions"}]},"name":"getOptions","type":"function"},{"parameters":[{"name":"behavior","$ref":"sidePanel.PanelBehavior"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"setPanelBehavior","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"behavior","$ref":"sidePanel.PanelBehavior"}]},"name":"getPanelBehavior","type":"function"},{"parameters":[{"name":"options","$ref":"sidePanel.OpenOptions"}],"returns_async":{"name":"callback","parameters":[]},"name":"open","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"layout","$ref":"sidePanel.PanelLayout"}]},"name":"getLayout","type":"function"},{"parameters":[{"name":"options","$ref":"sidePanel.CloseOptions"}],"returns_async":{"name":"callback","parameters":[]},"name":"close","type":"function"}],"properties":{},"events":[{"parameters":[{"name":"info","$ref":"sidePanel.PanelOpenedInfo"}],"name":"onOpened","type":"function"},{"parameters":[{"name":"info","$ref":"sidePanel.PanelClosedInfo"}],"name":"onClosed","type":"function"}],"platforms":null,"deprecated":null})R";
constexpr char kSystemPrivate[] = R"R({"namespace":"systemPrivate","types":[{"id":"systemPrivate.UpdateStatusState","type":"string","enum":["NotAvailable","Updating","NeedRestart"]},{"id":"systemPrivate.GetIncognitoModeAvailabilityValue","type":"string","enum":["enabled","disabled","forced"]},{"id":"systemPrivate.UpdateStatus","type":"object","properties":{"state":{"$ref":"systemPrivate.UpdateStatusState"},"downloadProgress":{"type":"number"}}}],"functions":[{"name":"getIncognitoModeAvailability","type":"function","parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"value","$ref":"systemPrivate.GetIncognitoModeAvailabilityValue"}]}},{"name":"getUpdateStatus","type":"function","parameters":[],"returns_async":{"name":"callback","parameters":[{"$ref":"systemPrivate.UpdateStatus","name":"status"}]}},{"name":"getApiKey","type":"function","parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"key","type":"string"}]}}]})R";
constexpr char kTabCapture[] = R"R({"namespace":"tabCapture","types":[{"id":"tabCapture.TabCaptureState","type":"string","enum":[{"name":"pending"},{"name":"active"},{"name":"stopped"},{"name":"error"}]},{"id":"tabCapture.CaptureInfo","properties":{"tabId":{"name":"tabId","type":"integer"},"status":{"name":"status","$ref":"tabCapture.TabCaptureState"},"fullscreen":{"name":"fullscreen","type":"boolean"}},"type":"object"},{"id":"tabCapture.MediaStreamConstraint","properties":{"mandatory":{"name":"mandatory","type":"object","additionalProperties":{"type":"any"}},"optional":{"optional":true,"name":"optional","type":"object","additionalProperties":{"type":"any"}}},"type":"object"},{"id":"tabCapture.CaptureOptions","properties":{"audio":{"optional":true,"name":"audio","type":"boolean"},"video":{"optional":true,"name":"video","type":"boolean"},"audioConstraints":{"optional":true,"name":"audioConstraints","$ref":"tabCapture.MediaStreamConstraint"},"videoConstraints":{"optional":true,"name":"videoConstraints","$ref":"tabCapture.MediaStreamConstraint"},"presentationId":{"optional":true,"name":"presentationId","type":"string"}},"type":"object"},{"id":"tabCapture.GetMediaStreamOptions","properties":{"consumerTabId":{"optional":true,"name":"consumerTabId","type":"integer"},"targetTabId":{"optional":true,"name":"targetTabId","type":"integer"}},"type":"object"}],"functions":[{"parameters":[{"name":"options","$ref":"tabCapture.CaptureOptions"}],"returns_async":{"name":"callback","parameters":[{"name":"stream","type":"object","additionalProperties":{"type":"any"},"isInstanceOf":"LocalMediaStream"}],"does_not_support_promises":"Custom hook sets lastError crbug.com/1504349"},"name":"capture","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"result","type":"array","items":{"$ref":"tabCapture.CaptureInfo"}}]},"name":"getCapturedTabs","type":"function"},{"parameters":[{"name":"options","optional":true,"$ref":"tabCapture.GetMediaStreamOptions"}],"returns_async":{"name":"callback","parameters":[{"name":"streamId","type":"string"}]},"name":"getMediaStreamId","type":"function"}],"properties":{},"events":[{"parameters":[{"name":"info","$ref":"tabCapture.CaptureInfo"}],"name":"onStatusChanged","type":"function"}],"platforms":null,"deprecated":null})R";
constexpr char kTabGroups[] = R"R({"namespace":"tabGroups","types":[{"id":"tabGroups.Color","type":"string","enum":["grey","blue","red","yellow","green","pink","purple","cyan","orange"]},{"id":"tabGroups.TabGroup","type":"object","properties":{"id":{"type":"integer","minimum":0},"collapsed":{"type":"boolean"},"color":{"$ref":"tabGroups.Color"},"title":{"type":"string","optional":true},"windowId":{"type":"integer","minimum":0},"shared":{"type":"boolean"}}}],"properties":{"TAB_GROUP_ID_NONE":{"value":-1,"type":"integer"}},"functions":[{"name":"get","type":"function","parameters":[{"type":"integer","name":"groupId","minimum":0}],"returns_async":{"name":"callback","parameters":[{"name":"group","$ref":"tabGroups.TabGroup"}]}},{"name":"query","type":"function","parameters":[{"type":"object","name":"queryInfo","properties":{"collapsed":{"type":"boolean","optional":true},"color":{"$ref":"tabGroups.Color","optional":true},"title":{"type":"string","optional":true},"shared":{"type":"boolean","optional":true},"windowId":{"type":"integer","optional":true,"minimum":-2}}}],"returns_async":{"name":"callback","parameters":[{"name":"result","type":"array","items":{"$ref":"tabGroups.TabGroup"}}]}},{"name":"update","type":"function","parameters":[{"type":"integer","name":"groupId","minimum":0},{"type":"object","name":"updateProperties","properties":{"collapsed":{"type":"boolean","optional":true},"color":{"$ref":"tabGroups.Color","optional":true},"title":{"type":"string","optional":true}}}],"returns_async":{"name":"callback","optional":true,"parameters":[{"name":"group","$ref":"tabGroups.TabGroup","optional":true}]}},{"name":"move","type":"function","parameters":[{"type":"integer","name":"groupId","minimum":0},{"type":"object","name":"moveProperties","properties":{"windowId":{"type":"integer","minimum":-2,"optional":true},"index":{"type":"integer","minimum":-1}}}],"returns_async":{"name":"callback","optional":true,"parameters":[{"name":"group","$ref":"tabGroups.TabGroup","optional":true}]}}],"events":[{"name":"onCreated","type":"function","parameters":[{"$ref":"tabGroups.TabGroup","name":"group"}]},{"name":"onUpdated","type":"function","parameters":[{"$ref":"tabGroups.TabGroup","name":"group"}]},{"name":"onMoved","type":"function","parameters":[{"$ref":"tabGroups.TabGroup","name":"group"}]},{"name":"onRemoved","type":"function","parameters":[{"$ref":"tabGroups.TabGroup","name":"group"}]}]})R";
constexpr char kWebrtcDesktopCapturePrivate[] = R"R({"namespace":"webrtcDesktopCapturePrivate","types":[{"id":"webrtcDesktopCapturePrivate.RequestInfo","properties":{"guestProcessId":{"name":"guestProcessId","type":"integer"},"guestRenderFrameId":{"name":"guestRenderFrameId","type":"integer"}},"type":"object"},{"id":"webrtcDesktopCapturePrivate.DesktopCaptureSourceType","type":"string","enum":[{"name":"screen"},{"name":"window"},{"name":"tab"}]}],"functions":[{"parameters":[{"name":"sources","type":"array","items":{"$ref":"webrtcDesktopCapturePrivate.DesktopCaptureSourceType"}},{"name":"request","$ref":"webrtcDesktopCapturePrivate.RequestInfo"}],"returns":{"name":"chooseDesktopMedia","type":"integer"},"returns_async":{"name":"callback","parameters":[{"name":"streamId","type":"string"}],"does_not_support_promises":"Synchronous return and callback crbug.com/1143032"},"name":"chooseDesktopMedia","type":"function"},{"parameters":[{"name":"desktopMediaRequestId","type":"integer"}],"name":"cancelChooseDesktopMedia","type":"function"}],"properties":{},"events":[],"platforms":null,"deprecated":null})R";
constexpr char kPdfViewerPrivate[] = R"R({"namespace":"pdfViewerPrivate","types":[{"id":"pdfViewerPrivate.SaveRequestType","type":"string","enum":[{"name":"ANNOTATION"},{"name":"ORIGINAL"},{"name":"EDITED"},{"name":"SEARCHIFIED"}]},{"id":"pdfViewerPrivate.SaveToDriveErrorType","type":"string","enum":[{"name":"NO_ERROR"},{"name":"UNKNOWN_ERROR"},{"name":"QUOTA_EXCEEDED"},{"name":"OFFLINE"},{"name":"OAUTH_ERROR"},{"name":"ACCOUNT_CHOOSER_CANCELED"},{"name":"PARENT_FOLDER_SELECTION_FAILED"}]},{"id":"pdfViewerPrivate.SaveToDriveStatus","type":"string","enum":[{"name":"NOT_STARTED"},{"name":"INITIATED"},{"name":"ACCOUNT_CHOOSER_SHOWN"},{"name":"ACCOUNT_SELECTED"},{"name":"ACCOUNT_ADD_SELECTED"},{"name":"ACCOUNT_ADDED"},{"name":"FETCH_OAUTH"},{"name":"FETCH_PARENT_FOLDER"},{"name":"UPLOAD_STARTED"},{"name":"UPLOAD_IN_PROGRESS"},{"name":"UPLOAD_COMPLETED"},{"name":"UPLOAD_RETRIED"},{"name":"UPLOAD_FAILED"}]},{"id":"pdfViewerPrivate.SaveToDriveProgress","properties":{"status":{"name":"status","$ref":"pdfViewerPrivate.SaveToDriveStatus"},"errorType":{"name":"errorType","$ref":"pdfViewerPrivate.SaveToDriveErrorType"},"driveItemId":{"optional":true,"name":"driveItemId","type":"string"},"fileSizeBytes":{"optional":true,"name":"fileSizeBytes","type":"integer"},"uploadedBytes":{"optional":true,"name":"uploadedBytes","type":"integer"},"fileMetadata":{"optional":true,"name":"fileMetadata","type":"string"},"fileName":{"optional":true,"name":"fileName","type":"string"},"parentFolderName":{"optional":true,"name":"parentFolderName","type":"string"},"accountEmail":{"optional":true,"name":"accountEmail","type":"string"},"accountIsManaged":{"optional":true,"name":"accountIsManaged","type":"boolean"}},"type":"object"},{"id":"pdfViewerPrivate.StreamInfo","properties":{"originalUrl":{"name":"originalUrl","type":"string"},"streamUrl":{"name":"streamUrl","type":"string"},"tabId":{"name":"tabId","type":"integer"},"embedded":{"name":"embedded","type":"boolean"}},"type":"object"},{"id":"pdfViewerPrivate.PdfPluginAttributes","properties":{"backgroundColor":{"name":"backgroundColor","type":"number"},"allowJavascript":{"name":"allowJavascript","type":"boolean"}},"type":"object"}],"functions":[{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"streamInfo","$ref":"pdfViewerPrivate.StreamInfo"}]},"name":"getStreamInfo","type":"function"},{"parameters":[{"name":"url","type":"string"}],"returns_async":{"name":"callback","parameters":[{"name":"result","type":"boolean"}]},"name":"isAllowedLocalFileAccess","type":"function"},{"parameters":[{"name":"saveRequestType","optional":true,"$ref":"pdfViewerPrivate.SaveRequestType"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"saveToDrive","type":"function"},{"parameters":[{"name":"title","type":"string"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"setPdfDocumentTitle","type":"function"},{"parameters":[{"name":"attributes","$ref":"pdfViewerPrivate.PdfPluginAttributes"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"setPdfPluginAttributes","type":"function"}],"properties":{},"events":[{"parameters":[{"name":"streamUrl","type":"string"}],"name":"onSave","type":"function"},{"parameters":[{"name":"streamUrl","type":"string"},{"name":"progress","$ref":"pdfViewerPrivate.SaveToDriveProgress"}],"name":"onSaveToDriveProgress","type":"function"},{"parameters":[{"name":"pdfUrl","type":"string"}],"name":"onShouldUpdateViewport","type":"function"}],"platforms":null,"deprecated":null})R";
constexpr char kAction[] = R"R({"namespace":"action","types":[{"id":"action.TabDetails","type":"object","properties":{"tabId":{"type":"integer","optional":true,"minimum":0}}},{"id":"action.UserSettings","type":"object","properties":{"isOnToolbar":{"type":"boolean"}}},{"id":"action.UserSettingsChange","type":"object","properties":{"isOnToolbar":{"type":"boolean","optional":true}}},{"id":"action.OpenPopupOptions","type":"object","properties":{"windowId":{"type":"integer","optional":true}}}],"functions":[{"name":"setTitle","type":"function","parameters":[{"name":"details","type":"object","properties":{"title":{"type":"string"},"tabId":{"type":"integer","optional":true,"minimum":0}}}],"returns_async":{"name":"callback","parameters":[],"optional":true}},{"name":"getTitle","type":"function","parameters":[{"name":"details","$ref":"action.TabDetails"}],"returns_async":{"name":"callback","parameters":[{"name":"result","type":"string"}]}},{"name":"setIcon","type":"function","parameters":[{"name":"details","type":"object","properties":{"imageData":{"choices":[{"$ref":"extensionTypes.ImageDataType"},{"type":"object","additionalProperties":{"type":"any"}}],"optional":true},"path":{"choices":[{"type":"string"},{"type":"object","additionalProperties":{"type":"any"}}],"optional":true},"tabId":{"type":"integer","optional":true,"minimum":0}}}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"setPopup","type":"function","parameters":[{"name":"details","type":"object","properties":{"tabId":{"type":"integer","optional":true,"minimum":0},"popup":{"type":"string"}}}],"returns_async":{"name":"callback","parameters":[],"optional":true}},{"name":"getPopup","type":"function","parameters":[{"name":"details","$ref":"action.TabDetails"}],"returns_async":{"name":"callback","parameters":[{"name":"result","type":"string"}]}},{"name":"setBadgeText","type":"function","parameters":[{"name":"details","type":"object","properties":{"text":{"type":"string","optional":true},"tabId":{"type":"integer","optional":true,"minimum":0}}}],"returns_async":{"name":"callback","parameters":[],"optional":true}},{"name":"getBadgeText","type":"function","parameters":[{"name":"details","$ref":"action.TabDetails"}],"returns_async":{"name":"callback","parameters":[{"name":"result","type":"string"}]}},{"name":"setBadgeBackgroundColor","type":"function","parameters":[{"name":"details","type":"object","properties":{"color":{"choices":[{"type":"string"},{"$ref":"extensionTypes.ColorArray"}]},"tabId":{"type":"integer","optional":true,"minimum":0}}}],"returns_async":{"name":"callback","parameters":[],"optional":true}},{"name":"getBadgeBackgroundColor","type":"function","parameters":[{"name":"details","$ref":"action.TabDetails"}],"returns_async":{"name":"callback","parameters":[{"name":"result","$ref":"extensionTypes.ColorArray"}]}},{"name":"setBadgeTextColor","type":"function","parameters":[{"name":"details","type":"object","properties":{"color":{"choices":[{"type":"string"},{"$ref":"extensionTypes.ColorArray"}]},"tabId":{"type":"integer","optional":true,"minimum":0}}}],"returns_async":{"name":"callback","parameters":[],"optional":true}},{"name":"getBadgeTextColor","type":"function","parameters":[{"name":"details","$ref":"action.TabDetails"}],"returns_async":{"name":"callback","parameters":[{"name":"result","$ref":"extensionTypes.ColorArray"}]}},{"name":"enable","type":"function","parameters":[{"type":"integer","optional":true,"name":"tabId","minimum":0}],"returns_async":{"name":"callback","parameters":[],"optional":true}},{"name":"disable","type":"function","parameters":[{"type":"integer","optional":true,"name":"tabId","minimum":0}],"returns_async":{"name":"callback","parameters":[],"optional":true}},{"name":"isEnabled","type":"function","parameters":[{"type":"integer","optional":true,"name":"tabId","minimum":0}],"returns_async":{"name":"callback","parameters":[{"name":"isEnabled","type":"boolean"}]}},{"name":"getUserSettings","type":"function","parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"userSettings","$ref":"action.UserSettings"}]}},{"name":"openPopup","type":"function","parameters":[{"$ref":"action.OpenPopupOptions","name":"options","optional":true}],"returns_async":{"name":"callback","parameters":[]}}],"events":[{"name":"onClicked","type":"function","parameters":[{"name":"tab","$ref":"tabs.Tab"}]},{"name":"onUserSettingsChanged","type":"function","parameters":[{"name":"change","$ref":"action.UserSettingsChange"}]}]})R";
constexpr char kBrowsingData[] = R"R({"namespace":"browsingData","types":[{"id":"browsingData.RemovalOptions","type":"object","properties":{"since":{"type":"number","optional":true},"originTypes":{"type":"object","optional":true,"properties":{"unprotectedWeb":{"type":"boolean","optional":true},"protectedWeb":{"type":"boolean","optional":true},"extension":{"type":"boolean","optional":true}}},"origins":{"type":"array","items":{"type":"string"},"optional":true,"minItems":1},"excludeOrigins":{"type":"array","items":{"type":"string"},"optional":true}}},{"id":"browsingData.DataTypeSet","type":"object","properties":{"appcache":{"type":"boolean","optional":true},"cache":{"type":"boolean","optional":true},"cacheStorage":{"type":"boolean","optional":true},"cookies":{"type":"boolean","optional":true},"downloads":{"type":"boolean","optional":true},"fileSystems":{"type":"boolean","optional":true},"formData":{"type":"boolean","optional":true},"history":{"type":"boolean","optional":true},"indexedDB":{"type":"boolean","optional":true},"localStorage":{"type":"boolean","optional":true},"serverBoundCertificates":{"type":"boolean","optional":true,"deprecated":"Support for server-bound certificates has been removed. This data type will be ignored."},"passwords":{"type":"boolean","optional":true},"pluginData":{"type":"boolean","optional":true,"deprecated":"Support for Flash has been removed. This data type will be ignored."},"serviceWorkers":{"type":"boolean","optional":true},"webSQL":{"type":"boolean","optional":true}}}],"functions":[{"name":"settings","type":"function","parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"result","type":"object","properties":{"options":{"$ref":"browsingData.RemovalOptions"},"dataToRemove":{"$ref":"browsingData.DataTypeSet"},"dataRemovalPermitted":{"$ref":"browsingData.DataTypeSet"}}}]}},{"name":"remove","type":"function","parameters":[{"$ref":"browsingData.RemovalOptions","name":"options"},{"name":"dataToRemove","$ref":"browsingData.DataTypeSet"}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"removeAppcache","type":"function","parameters":[{"$ref":"browsingData.RemovalOptions","name":"options"}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"removeCache","type":"function","parameters":[{"$ref":"browsingData.RemovalOptions","name":"options"}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"removeCacheStorage","type":"function","parameters":[{"$ref":"browsingData.RemovalOptions","name":"options"}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"removeCookies","type":"function","parameters":[{"$ref":"browsingData.RemovalOptions","name":"options"}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"removeDownloads","type":"function","parameters":[{"$ref":"browsingData.RemovalOptions","name":"options"}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"removeFileSystems","type":"function","parameters":[{"$ref":"browsingData.RemovalOptions","name":"options"}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"removeFormData","type":"function","parameters":[{"$ref":"browsingData.RemovalOptions","name":"options"}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"removeHistory","type":"function","parameters":[{"$ref":"browsingData.RemovalOptions","name":"options"}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"removeIndexedDB","type":"function","parameters":[{"$ref":"browsingData.RemovalOptions","name":"options"}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"removeLocalStorage","type":"function","parameters":[{"$ref":"browsingData.RemovalOptions","name":"options"}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"removePluginData","deprecated":"Support for Flash has been removed. This function has no effect.","type":"function","parameters":[{"$ref":"browsingData.RemovalOptions","name":"options"}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"removePasswords","type":"function","parameters":[{"$ref":"browsingData.RemovalOptions","name":"options"}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"removeServiceWorkers","type":"function","parameters":[{"$ref":"browsingData.RemovalOptions","name":"options"}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"removeWebSQL","type":"function","parameters":[{"$ref":"browsingData.RemovalOptions","name":"options"}],"returns_async":{"name":"callback","optional":true,"parameters":[]}}]})R";
constexpr char kExtension[] = R"R({"namespace":"extension","properties":{"lastError":{"type":"object","optional":true,"deprecated":"Please use $(ref:runtime.lastError).","properties":{"message":{"type":"string"}}},"inIncognitoContext":{"type":"boolean","optional":true}},"types":[{"id":"extension.ViewType","type":"string","enum":["tab","popup"]}],"functions":[{"name":"sendRequest","deprecated":"Please use $(ref:runtime.sendMessage).","type":"function","parameters":[{"type":"string","name":"extensionId","optional":true},{"type":"any","name":"request"}],"returns_async":{"name":"callback","optional":true,"parameters":[{"name":"response","type":"any"}]}},{"name":"getURL","deprecated":"Please use $(ref:runtime.getURL).","type":"function","parameters":[{"type":"string","name":"path"}],"returns":{"type":"string"}},{"name":"getViews","type":"function","parameters":[{"type":"object","name":"fetchProperties","optional":true,"properties":{"type":{"$ref":"extension.ViewType","optional":true},"windowId":{"type":"integer","optional":true},"tabId":{"type":"integer","optional":true}}}],"returns":{"type":"array","items":{"name":"viewGlobals","type":"object","isInstanceOf":"Window","additionalProperties":{"type":"any"}}}},{"name":"getBackgroundPage","type":"function","parameters":[],"returns":{"type":"object","optional":true,"name":"backgroundPageGlobal","isInstanceOf":"Window","additionalProperties":{"type":"any"}}},{"name":"getExtensionTabs","deprecated":"Please use $(ref:extension.getViews) <code>{type: \"tab\"}</code>.","type":"function","maximumManifestVersion":1,"parameters":[{"type":"integer","name":"windowId","optional":true}],"returns":{"type":"array","items":{"type":"object","name":"tabGlobals","isInstanceOf":"Window","additionalProperties":{"type":"any"}}}},{"name":"isAllowedIncognitoAccess","type":"function","min_version":"12.0.706.0","parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"isAllowedAccess","type":"boolean"}]}},{"name":"isAllowedFileSchemeAccess","type":"function","min_version":"12.0.706.0","parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"isAllowedAccess","type":"boolean"}]}},{"name":"setUpdateUrlData","type":"function","parameters":[{"type":"string","name":"data","maxLength":1024}]}],"events":[{"name":"onRequest","deprecated":"Please use $(ref:runtime.onMessage).","type":"function","options":{"unmanaged":true},"parameters":[{"name":"request","type":"any","optional":true},{"name":"sender","$ref":"runtime.MessageSender"},{"name":"sendResponse","type":"function"}]},{"name":"onRequestExternal","deprecated":"Please use $(ref:runtime.onMessageExternal).","type":"function","parameters":[{"name":"request","type":"any","optional":true},{"name":"sender","$ref":"runtime.MessageSender"},{"name":"sendResponse","type":"function"}]}]})R";
constexpr char kTopSites[] = R"R({"namespace":"topSites","types":[{"id":"topSites.MostVisitedURL","type":"object","properties":{"url":{"type":"string"},"title":{"type":"string"}}}],"functions":[{"name":"get","type":"function","parameters":[],"returns_async":{"name":"callback","parameters":[{"type":"array","name":"data","items":{"$ref":"topSites.MostVisitedURL"}}]}}]})R";
constexpr char kBrowserAction[] = R"R({"namespace":"browserAction","types":[{"id":"browserAction.TabDetails","type":"object","properties":{"tabId":{"type":"integer","optional":true,"minimum":0}}}],"functions":[{"name":"setTitle","type":"function","parameters":[{"name":"details","type":"object","properties":{"title":{"type":"string"},"tabId":{"type":"integer","optional":true}}}],"returns_async":{"name":"callback","parameters":[],"optional":true}},{"name":"getTitle","type":"function","parameters":[{"name":"details","$ref":"browserAction.TabDetails"}],"returns_async":{"name":"callback","parameters":[{"name":"result","type":"string"}]}},{"name":"setIcon","type":"function","parameters":[{"name":"details","type":"object","properties":{"imageData":{"choices":[{"$ref":"extensionTypes.ImageDataType"},{"type":"object","additionalProperties":{"type":"any"}}],"optional":true},"path":{"choices":[{"type":"string"},{"type":"object","additionalProperties":{"type":"any"}}],"optional":true},"tabId":{"type":"integer","optional":true}}}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"setPopup","type":"function","parameters":[{"name":"details","type":"object","properties":{"tabId":{"type":"integer","optional":true,"minimum":0},"popup":{"type":"string"}}}],"returns_async":{"name":"callback","parameters":[],"optional":true}},{"name":"getPopup","type":"function","parameters":[{"name":"details","$ref":"browserAction.TabDetails"}],"returns_async":{"name":"callback","parameters":[{"name":"result","type":"string"}]}},{"name":"setBadgeText","type":"function","parameters":[{"name":"details","type":"object","properties":{"text":{"type":"string","optional":true},"tabId":{"type":"integer","optional":true}}}],"returns_async":{"name":"callback","parameters":[],"optional":true}},{"name":"getBadgeText","type":"function","parameters":[{"name":"details","$ref":"browserAction.TabDetails"}],"returns_async":{"name":"callback","parameters":[{"name":"result","type":"string"}]}},{"name":"setBadgeBackgroundColor","type":"function","parameters":[{"name":"details","type":"object","properties":{"color":{"choices":[{"type":"string"},{"$ref":"extensionTypes.ColorArray"}]},"tabId":{"type":"integer","optional":true}}}],"returns_async":{"name":"callback","parameters":[],"optional":true}},{"name":"getBadgeBackgroundColor","type":"function","parameters":[{"name":"details","$ref":"browserAction.TabDetails"}],"returns_async":{"name":"callback","parameters":[{"name":"result","$ref":"extensionTypes.ColorArray"}]}},{"name":"enable","type":"function","parameters":[{"type":"integer","optional":true,"name":"tabId","minimum":0}],"returns_async":{"name":"callback","parameters":[],"optional":true}},{"name":"disable","type":"function","parameters":[{"type":"integer","optional":true,"name":"tabId","minimum":0}],"returns_async":{"name":"callback","parameters":[],"optional":true}},{"name":"openPopup","type":"function","parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"popupView","type":"object","optional":true,"additionalProperties":{"type":"any"}}]}}],"events":[{"name":"onClicked","type":"function","parameters":[{"name":"tab","$ref":"tabs.Tab"}]}]})R";
constexpr char kIdltest[] = R"R({"namespace":"idltest","types":[],"functions":[{"parameters":[{"name":"input","type":"binary","isInstanceOf":"ArrayBuffer"}],"returns_async":{"name":"callback","parameters":[{"name":"array","type":"array","items":{"type":"integer"}}]},"name":"sendArrayBuffer","type":"function"},{"parameters":[{"name":"input","type":"binary"}],"returns_async":{"name":"callback","parameters":[{"name":"array","type":"array","items":{"type":"integer"}}]},"name":"sendArrayBufferView","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"buffer","type":"binary","isInstanceOf":"ArrayBuffer"}]},"name":"getArrayBuffer","type":"function"},{"parameters":[{"name":"switch","type":"integer"}],"name":"nocompileFunc","type":"function"}],"properties":{},"events":[],"platforms":null,"deprecated":null})R";
constexpr char kPageAction[] = R"R({"namespace":"pageAction","types":[{"id":"pageAction.ImageDataType","type":"object","isInstanceOf":"ImageData","additionalProperties":{"type":"any"}},{"id":"pageAction.TabDetails","type":"object","properties":{"tabId":{"type":"integer","optional":true,"minimum":0}}}],"functions":[{"name":"show","type":"function","parameters":[{"type":"integer","name":"tabId","minimum":0}],"returns_async":{"name":"callback","parameters":[],"optional":true}},{"name":"hide","type":"function","parameters":[{"type":"integer","name":"tabId","minimum":0}],"returns_async":{"name":"callback","parameters":[],"optional":true}},{"name":"setTitle","type":"function","parameters":[{"name":"details","type":"object","properties":{"tabId":{"type":"integer","minimum":0},"title":{"type":"string"}}}],"returns_async":{"name":"callback","parameters":[],"optional":true}},{"name":"getTitle","type":"function","parameters":[{"name":"details","$ref":"pageAction.TabDetails"}],"returns_async":{"name":"callback","parameters":[{"name":"result","type":"string"}]}},{"name":"setIcon","type":"function","parameters":[{"name":"details","type":"object","properties":{"tabId":{"type":"integer","minimum":0},"imageData":{"choices":[{"$ref":"pageAction.ImageDataType"},{"type":"object","additionalProperties":{"type":"any"}}],"optional":true},"path":{"choices":[{"type":"string"},{"type":"object","additionalProperties":{"type":"any"}}],"optional":true},"iconIndex":{"type":"integer","minimum":0,"optional":true}}}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"setPopup","type":"function","parameters":[{"name":"details","type":"object","properties":{"tabId":{"type":"integer","minimum":0},"popup":{"type":"string"}}}],"returns_async":{"name":"callback","parameters":[],"optional":true}},{"name":"getPopup","type":"function","parameters":[{"name":"details","$ref":"pageAction.TabDetails"}],"returns_async":{"name":"callback","parameters":[{"name":"result","type":"string"}]}}],"events":[{"name":"onClicked","type":"function","parameters":[{"name":"tab","$ref":"tabs.Tab"}]}]})R";
constexpr char kApp[] = R"R({"namespace":"app","types":[{"id":"app.Details","type":"object","properties":{},"additionalProperties":{"type":"any"}},{"id":"app.DOMWindow","type":"object","properties":{},"additionalProperties":{"type":"any"}},{"id":"app.InstallState","type":"string","enum":["not_installed","installed","disabled"]},{"id":"app.RunningState","type":"string","enum":["running","cannot_run","ready_to_run"]}],"functions":[{"name":"getIsInstalled","type":"function","parameters":[],"returns":{"name":"isInstalled","type":"boolean"}},{"name":"installState","type":"function","parameters":[],"returns_async":{"name":"callback","parameters":[{"$ref":"app.InstallState","name":"state"}]}},{"name":"runningState","type":"function","parameters":[],"returns":{"$ref":"app.RunningState"}},{"name":"getDetails","type":"function","parameters":[],"returns":{"$ref":"app.Details","optional":true}}]})R";
constexpr char kCommands[] = R"R({"namespace":"commands","types":[{"id":"commands.Command","type":"object","properties":{"name":{"type":"string","optional":true},"description":{"type":"string","optional":true},"shortcut":{"type":"string","optional":true}}}],"events":[{"name":"onCommand","type":"function","parameters":[{"name":"command","type":"string"},{"$ref":"tabs.Tab","name":"tab","optional":true}]}],"functions":[{"name":"getAll","type":"function","parameters":[],"returns_async":{"name":"callback","optional":true,"parameters":[{"name":"commands","type":"array","items":{"$ref":"commands.Command"}}]}}]})R";
constexpr char kDeclarativeContent[] = R"R({"namespace":"declarativeContent","types":[{"id":"declarativeContent.ImageDataType","type":"binary","isInstanceOf":"ImageData","additionalProperties":{"type":"any"}},{"id":"declarativeContent.PageStateMatcherInstanceType","type":"string","enum":["declarativeContent.PageStateMatcher"]},{"id":"declarativeContent.ShowPageActionInstanceType","type":"string","enum":["declarativeContent.ShowPageAction"]},{"id":"declarativeContent.ShowActionInstanceType","type":"string","enum":["declarativeContent.ShowAction"]},{"id":"declarativeContent.SetIconInstanceType","type":"string","enum":["declarativeContent.SetIcon"]},{"id":"declarativeContent.RequestContentScriptInstanceType","type":"string","enum":["declarativeContent.RequestContentScript"]},{"id":"declarativeContent.PageStateMatcher","type":"object","properties":{"pageUrl":{"$ref":"events.UrlFilter","optional":true},"css":{"type":"array","optional":true,"items":{"type":"string"}},"isBookmarked":{"type":"boolean","optional":true},"instanceType":{"$ref":"declarativeContent.PageStateMatcherInstanceType"}}},{"id":"declarativeContent.ShowPageAction","deprecated":"Please use $(ref:declarativeContent.ShowAction).","type":"object","properties":{"instanceType":{"$ref":"declarativeContent.ShowPageActionInstanceType"}}},{"id":"declarativeContent.ShowAction","type":"object","properties":{"instanceType":{"$ref":"declarativeContent.ShowActionInstanceType"}}},{"id":"declarativeContent.SetIcon","type":"object","properties":{"instanceType":{"$ref":"declarativeContent.SetIconInstanceType"},"imageData":{"choices":[{"$ref":"declarativeContent.ImageDataType"},{"type":"object","additionalProperties":{"type":"any"}}],"optional":true}}},{"id":"declarativeContent.RequestContentScript","type":"object","properties":{"css":{"type":"array","optional":true,"items":{"type":"string"}},"js":{"type":"array","optional":true,"items":{"type":"string"}},"allFrames":{"type":"boolean","optional":true},"matchAboutBlank":{"type":"boolean","optional":true},"instanceType":{"$ref":"declarativeContent.RequestContentScriptInstanceType"}}}],"functions":[],"events":[{"name":"onPageChanged","options":{"supportsListeners":false,"supportsRules":true,"conditions":["declarativeContent.PageStateMatcher"],"actions":["declarativeContent.RequestContentScript","declarativeContent.SetIcon","declarativeContent.ShowPageAction","declarativeContent.ShowAction"]}}]})R";
constexpr char kDom[] = R"R({"namespace":"dom","functions":[{"name":"openOrClosedShadowRoot","type":"function","parameters":[{"name":"element","type":"object","isInstanceOf":"HTMLElement","additionalProperties":{"type":"any"}}],"returns":{"name":"shadowRoot","type":"object","additionalProperties":{"type":"any"}}}]})R";
constexpr char kPrivacy[] = R"R({"namespace":"privacy","types":[{"id":"privacy.IPHandlingPolicy","type":"string","enum":["default","default_public_and_private_interfaces","default_public_interface_only","disable_non_proxied_udp"]}],"properties":{"network":{"type":"object","value":{},"properties":{"networkPredictionEnabled":{"$ref":"types.ChromeSetting","value":["networkPredictionEnabled",{"type":"boolean"}]},"webRTCIPHandlingPolicy":{"$ref":"types.ChromeSetting","value":["webRTCIPHandlingPolicy",{"$ref":"privacy.IPHandlingPolicy"}]}}},"services":{"type":"object","value":{},"properties":{"alternateErrorPagesEnabled":{"$ref":"types.ChromeSetting","value":["alternateErrorPagesEnabled",{"type":"boolean"}]},"autofillEnabled":{"$ref":"types.ChromeSetting","value":["autofillEnabled",{"type":"boolean"}],"deprecated":"Please use privacy.services.autofillAddressEnabled and privacy.services.autofillCreditCardEnabled. This remains for backward compatibility in this release and will be removed in the future."},"autofillAddressEnabled":{"$ref":"types.ChromeSetting","value":["autofillAddressEnabled",{"type":"boolean"}]},"autofillCreditCardEnabled":{"$ref":"types.ChromeSetting","value":["autofillCreditCardEnabled",{"type":"boolean"}]},"passwordSavingEnabled":{"$ref":"types.ChromeSetting","value":["passwordSavingEnabled",{"type":"boolean"}]},"safeBrowsingEnabled":{"$ref":"types.ChromeSetting","value":["safeBrowsingEnabled",{"type":"boolean"}]},"safeBrowsingExtendedReportingEnabled":{"$ref":"types.ChromeSetting","value":["safeBrowsingExtendedReportingEnabled",{"type":"boolean"}]},"searchSuggestEnabled":{"$ref":"types.ChromeSetting","value":["searchSuggestEnabled",{"type":"boolean"}]},"spellingServiceEnabled":{"$ref":"types.ChromeSetting","value":["spellingServiceEnabled",{"type":"boolean"}]},"translationServiceEnabled":{"$ref":"types.ChromeSetting","value":["translationServiceEnabled",{"type":"boolean"}]}}},"websites":{"type":"object","value":{},"properties":{"thirdPartyCookiesAllowed":{"$ref":"types.ChromeSetting","value":["thirdPartyCookiesAllowed",{"type":"boolean"}]},"topicsEnabled":{"$ref":"types.ChromeSetting","value":["topicsEnabled",{"type":"boolean"}]},"fledgeEnabled":{"$ref":"types.ChromeSetting","value":["fledgeEnabled",{"type":"boolean"}]},"adMeasurementEnabled":{"$ref":"types.ChromeSetting","value":["adMeasurementEnabled",{"type":"boolean"}]},"hyperlinkAuditingEnabled":{"$ref":"types.ChromeSetting","value":["hyperlinkAuditingEnabled",{"type":"boolean"}]},"referrersEnabled":{"$ref":"types.ChromeSetting","value":["referrersEnabled",{"type":"boolean"}]},"doNotTrackEnabled":{"$ref":"types.ChromeSetting","value":["doNotTrackEnabled",{"type":"boolean"}]},"protectedContentEnabled":{"$ref":"types.ChromeSetting","value":["protectedContentEnabled",{"type":"boolean"}],"platforms":["win","chromeos"]},"relatedWebsiteSetsEnabled":{"$ref":"types.ChromeSetting","value":["relatedWebsiteSetsEnabled",{"type":"boolean"}]}}}}})R";
constexpr char kProxy[] = R"R({"namespace":"proxy","types":[{"id":"proxy.Scheme","type":"string","enum":["http","https","quic","socks4","socks5"]},{"id":"proxy.Mode","type":"string","enum":["direct","auto_detect","pac_script","fixed_servers","system"]},{"id":"proxy.ProxyServer","type":"object","properties":{"scheme":{"$ref":"proxy.Scheme","optional":true},"host":{"type":"string"},"port":{"type":"integer","optional":true}}},{"id":"proxy.ProxyRules","type":"object","properties":{"singleProxy":{"$ref":"proxy.ProxyServer","optional":true},"proxyForHttp":{"$ref":"proxy.ProxyServer","optional":true},"proxyForHttps":{"$ref":"proxy.ProxyServer","optional":true},"proxyForFtp":{"$ref":"proxy.ProxyServer","optional":true},"fallbackProxy":{"$ref":"proxy.ProxyServer","optional":true},"bypassList":{"type":"array","items":{"type":"string"},"optional":true}}},{"id":"proxy.PacScript","type":"object","properties":{"url":{"type":"string","optional":true},"data":{"type":"string","optional":true},"mandatory":{"type":"boolean","optional":true}}},{"id":"proxy.ProxyConfig","type":"object","properties":{"rules":{"$ref":"proxy.ProxyRules","optional":true},"pacScript":{"$ref":"proxy.PacScript","optional":true},"mode":{"$ref":"proxy.Mode"}}}],"properties":{"settings":{"$ref":"types.ChromeSetting","value":["proxy",{"$ref":"proxy.ProxyConfig"}]}},"events":[{"name":"onProxyError","type":"function","parameters":[{"type":"object","name":"details","properties":{"fatal":{"type":"boolean"},"error":{"type":"string"},"details":{"type":"string"}}}]}]})R";
constexpr char kTts[] = R"R({"namespace":"tts","types":[{"id":"tts.EventType","type":"string","enum":["start","end","word","sentence","marker","interrupted","cancelled","error","pause","resume"]},{"id":"tts.VoiceGender","type":"string","deprecated":"Gender is deprecated and is ignored.","enum":["male","female"]},{"id":"tts.TtsOptions","type":"object","properties":{"enqueue":{"type":"boolean","optional":true},"voiceName":{"type":"string","optional":true},"extensionId":{"type":"string","optional":true},"lang":{"type":"string","optional":true},"gender":{"$ref":"tts.VoiceGender","optional":true,"deprecated":"Gender is deprecated and will be ignored."},"rate":{"type":"number","optional":true,"minimum":0.1,"maximum":10},"pitch":{"type":"number","optional":true,"minimum":0,"maximum":2},"volume":{"type":"number","optional":true,"minimum":0,"maximum":1},"requiredEventTypes":{"type":"array","items":{"type":"string"},"optional":true},"desiredEventTypes":{"type":"array","items":{"type":"string"},"optional":true},"onEvent":{"type":"function","optional":true,"parameters":[{"name":"event","$ref":"tts.TtsEvent"}]}}},{"id":"tts.TtsEvent","type":"object","properties":{"type":{"$ref":"tts.EventType"},"charIndex":{"type":"integer","optional":true},"errorMessage":{"type":"string","optional":true},"srcId":{"type":"number","optional":true},"isFinalEvent":{"type":"boolean","optional":true},"length":{"type":"integer","optional":true}}},{"id":"tts.TtsVoice","type":"object","properties":{"voiceName":{"type":"string","optional":true},"lang":{"type":"string","optional":true},"gender":{"$ref":"tts.VoiceGender","optional":true,"deprecated":"Gender is deprecated and will be ignored."},"remote":{"type":"boolean","optional":true},"extensionId":{"type":"string","optional":true},"eventTypes":{"type":"array","items":{"$ref":"tts.EventType"},"optional":true}}}],"functions":[{"name":"speak","type":"function","parameters":[{"type":"string","name":"utterance"},{"$ref":"tts.TtsOptions","name":"options","optional":true}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"stop","type":"function","parameters":[]},{"name":"pause","type":"function","parameters":[]},{"name":"resume","type":"function","parameters":[]},{"name":"isSpeaking","type":"function","parameters":[],"returns_async":{"name":"callback","optional":true,"parameters":[{"name":"speaking","type":"boolean"}]}},{"name":"getVoices","type":"function","parameters":[],"returns_async":{"name":"callback","optional":true,"parameters":[{"type":"array","name":"voices","items":{"$ref":"tts.TtsVoice"}}]}}],"events":[{"name":"onEvent","type":"function","parameters":[{"name":"event","$ref":"tts.TtsEvent"}]},{"name":"onVoicesChanged","type":"function"}]})R";
constexpr char kTtsEngine[] = R"R({"namespace":"ttsEngine","types":[{"id":"ttsEngine.TtsClientSource","type":"string","enum":["chromefeature","extension"]},{"id":"ttsEngine.TtsClient","type":"object","properties":{"id":{"type":"string"},"source":{"$ref":"ttsEngine.TtsClientSource"}}},{"id":"ttsEngine.VoiceGender","type":"string","deprecated":"Gender is deprecated and will be ignored.","enum":["male","female"]},{"id":"ttsEngine.LanguageUninstallOptions","type":"object","properties":{"uninstallImmediately":{"type":"boolean"}}},{"id":"ttsEngine.LanguageInstallStatus","type":"string","enum":["notInstalled","installing","installed","failed"]},{"id":"ttsEngine.LanguageStatus","type":"object","properties":{"lang":{"type":"string"},"installStatus":{"$ref":"ttsEngine.LanguageInstallStatus"},"error":{"type":"string","optional":true}}},{"id":"ttsEngine.SpeakOptions","type":"object","properties":{"voiceName":{"type":"string","optional":true},"lang":{"type":"string","optional":true},"gender":{"$ref":"ttsEngine.VoiceGender","optional":true,"deprecated":"Gender is deprecated and will be ignored."},"rate":{"type":"number","optional":true,"minimum":0.1,"maximum":10.0},"pitch":{"type":"number","optional":true,"minimum":0,"maximum":2},"volume":{"type":"number","optional":true,"minimum":0,"maximum":1}}},{"id":"ttsEngine.AudioStreamOptions","type":"object","properties":{"sampleRate":{"type":"integer"},"bufferSize":{"type":"integer"}}},{"id":"ttsEngine.AudioBuffer","type":"object","properties":{"audioBuffer":{"type":"binary"},"charIndex":{"type":"integer","optional":true},"isLastBuffer":{"type":"boolean","optional":true}}}],"functions":[{"name":"updateVoices","type":"function","parameters":[{"type":"array","name":"voices","items":{"$ref":"tts.TtsVoice"}}]},{"name":"sendTtsEvent","type":"function","parameters":[{"type":"integer","name":"requestId"},{"name":"event","$ref":"tts.TtsEvent"}]},{"name":"sendTtsAudio","type":"function","parameters":[{"type":"integer","name":"requestId"},{"name":"audio","$ref":"ttsEngine.AudioBuffer"}],"platforms":["chromeos"]},{"name":"updateLanguage","type":"function","parameters":[{"name":"status","$ref":"ttsEngine.LanguageStatus"}]}],"events":[{"name":"onSpeak","type":"function","parameters":[{"type":"string","name":"utterance"},{"$ref":"ttsEngine.SpeakOptions","name":"options"},{"name":"sendTtsEvent","type":"function","parameters":[{"name":"event","$ref":"tts.TtsEvent"}]}]},{"name":"onSpeakWithAudioStream","type":"function","parameters":[{"type":"string","name":"utterance"},{"$ref":"ttsEngine.SpeakOptions","name":"options"},{"$ref":"ttsEngine.AudioStreamOptions","name":"audioStreamOptions"},{"name":"sendTtsAudio","type":"function","parameters":[{"$ref":"ttsEngine.AudioBuffer","name":"audioBufferParams"}]},{"name":"sendError","type":"function","parameters":[{"type":"string","name":"errorMessage","optional":true}]}],"platforms":["chromeos"]},{"name":"onStop","type":"function"},{"name":"onPause","type":"function"},{"name":"onResume","type":"function"},{"name":"onInstallLanguageRequest","type":"function","parameters":[{"name":"requestor","$ref":"ttsEngine.TtsClient"},{"name":"lang","type":"string"}]},{"name":"onUninstallLanguageRequest","type":"function","parameters":[{"name":"requestor","$ref":"ttsEngine.TtsClient"},{"name":"lang","type":"string"},{"name":"uninstallOptions","$ref":"ttsEngine.LanguageUninstallOptions"}]},{"name":"onLanguageStatusRequest","type":"function","parameters":[{"name":"requestor","$ref":"ttsEngine.TtsClient"},{"name":"lang","type":"string"}]}]})R";
constexpr char kInputMethodPrivate[] = R"R({"namespace":"inputMethodPrivate","types":[{"id":"inputMethodPrivate.MenuItemStyle","type":"string","enum":["check","radio","separator"]},{"id":"inputMethodPrivate.MenuItem","type":"object","properties":{"id":{"type":"string"},"label":{"type":"string","optional":true},"style":{"$ref":"inputMethodPrivate.MenuItemStyle","optional":true},"visible":{"type":"boolean","optional":true},"checked":{"type":"boolean","optional":true},"enabled":{"type":"boolean","optional":true}}},{"id":"inputMethodPrivate.UnderlineStyle","type":"string","enum":["underline","doubleUnderline","noUnderline"]},{"id":"inputMethodPrivate.FocusReason","type":"string","enum":["mouse","touch","pen","other"]},{"id":"inputMethodPrivate.InputModeType","type":"string","enum":["noKeyboard","text","tel","url","email","numeric","decimal","search"]},{"id":"inputMethodPrivate.InputContextType","type":"string","enum":["text","search","tel","url","email","number","password","null"]},{"id":"inputMethodPrivate.AutoCapitalizeType","type":"string","enum":["off","characters","words","sentences"]},{"id":"inputMethodPrivate.LanguagePackStatus","type":"string","enum":["unknown","notInstalled","inProgress","installed","errorOther","errorNeedsReboot"]},{"id":"inputMethodPrivate.LanguagePackStatusChange","type":"object","properties":{"engineIds":{"type":"array","items":{"type":"string"}},"status":{"$ref":"inputMethodPrivate.LanguagePackStatus"}}},{"id":"inputMethodPrivate.InputContext","type":"object","properties":{"contextID":{"type":"integer"},"type":{"$ref":"inputMethodPrivate.InputContextType"},"mode":{"$ref":"inputMethodPrivate.InputModeType"},"autoCorrect":{"type":"boolean"},"autoComplete":{"type":"boolean"},"autoCapitalize":{"$ref":"inputMethodPrivate.AutoCapitalizeType"},"spellCheck":{"type":"boolean"},"shouldDoLearning":{"type":"boolean"},"focusReason":{"$ref":"inputMethodPrivate.FocusReason"},"appKey":{"type":"string","optional":true}}},{"id":"inputMethodPrivate.InputMethodSettings","type":"object","properties":{"enableCompletion":{"type":"boolean","optional":true},"enableDoubleSpacePeriod":{"type":"boolean","optional":true},"enableGestureTyping":{"type":"boolean","optional":true},"enablePrediction":{"type":"boolean","optional":true},"enableSoundOnKeypress":{"type":"boolean","optional":true},"physicalKeyboardAutoCorrectionEnabledByDefault":{"type":"boolean","optional":true},"physicalKeyboardAutoCorrectionLevel":{"type":"integer","optional":true},"physicalKeyboardEnableCapitalization":{"type":"boolean","optional":true},"physicalKeyboardEnableDiacriticsOnLongpress":{"type":"boolean","optional":true},"physicalKeyboardEnablePredictiveWriting":{"type":"boolean","optional":true},"virtualKeyboardAutoCorrectionLevel":{"type":"integer","optional":true},"virtualKeyboardEnableCapitalization":{"type":"boolean","optional":true},"xkbLayout":{"type":"string","optional":true},"koreanEnableSyllableInput":{"type":"boolean","optional":true},"koreanKeyboardLayout":{"type":"string","optional":true},"koreanShowHangulCandidate":{"type":"boolean","optional":true},"pinyinChinesePunctuation":{"type":"boolean","optional":true},"pinyinDefaultChinese":{"type":"boolean","optional":true},"pinyinEnableFuzzy":{"type":"boolean","optional":true},"pinyinEnableLowerPaging":{"type":"boolean","optional":true},"pinyinEnableUpperPaging":{"type":"boolean","optional":true},"pinyinFullWidthCharacter":{"type":"boolean","optional":true},"pinyinFuzzyConfig":{"type":"object","optional":true,"properties":{"an_ang":{"type":"boolean","optional":true},"c_ch":{"type":"boolean","optional":true},"en_eng":{"type":"boolean","optional":true},"f_h":{"type":"boolean","optional":true},"ian_iang":{"type":"boolean","optional":true},"in_ing":{"type":"boolean","optional":true},"k_g":{"type":"boolean","optional":true},"l_n":{"type":"boolean","optional":true},"r_l":{"type":"boolean","optional":true},"s_sh":{"type":"boolean","optional":true},"uan_uang":{"type":"boolean","optional":true},"z_zh":{"type":"boolean","optional":true}}},"zhuyinKeyboardLayout":{"type":"string","optional":true},"zhuyinPageSize":{"type":"integer","optional":true},"zhuyinSelectKeys":{"type":"string","optional":true},"vietnameseVniAllowFlexibleDiacritics":{"type":"boolean","optional":true},"vietnameseVniNewStyleToneMarkPlacement":{"type":"boolean","optional":true},"vietnameseVniInsertDoubleHornOnUo":{"type":"boolean","optional":true},"vietnameseVniShowUnderline":{"type":"boolean","optional":true},"vietnameseTelexAllowFlexibleDiacritics":{"type":"boolean","optional":true},"vietnameseTelexNewStyleToneMarkPlacement":{"type":"boolean","optional":true},"vietnameseTelexInsertDoubleHornOnUo":{"type":"boolean","optional":true},"vietnameseTelexInsertUHornOnW":{"type":"boolean","optional":true},"vietnameseTelexShowUnderline":{"type":"boolean","optional":true}}}],"functions":[{"name":"getInputMethodConfig","type":"function","parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"config","type":"object","properties":{"isPhysicalKeyboardAutocorrectEnabled":{"type":"boolean"},"isImeMenuActivated":{"type":"boolean"}}}]}},{"name":"getInputMethods","type":"function","parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"inputMethods","type":"array","items":{"type":"object","properties":{"id":{"type":"string"},"name":{"type":"string"},"indicator":{"type":"string"}}}}]}},{"name":"getCurrentInputMethod","type":"function","parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"inputMethodId","type":"string"}]}},{"name":"setCurrentInputMethod","type":"function","parameters":[{"name":"inputMethodId","type":"string"}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"switchToLastUsedInputMethod","type":"function","parameters":[],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"fetchAllDictionaryWords","type":"function","parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"words","type":"array","items":{"type":"string"}}]}},{"name":"addWordToDictionary","type":"function","parameters":[{"name":"word","type":"string"}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"setXkbLayout","type":"function","parameters":[{"name":"xkb_name","type":"string"}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"finishComposingText","type":"function","parameters":[{"name":"parameters","type":"object","properties":{"contextID":{"type":"integer"}}}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"showInputView","type":"function","parameters":[],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"hideInputView","type":"function","parameters":[],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"openOptionsPage","type":"function","parameters":[{"name":"inputMethodId","type":"string"}]},{"name":"getSurroundingText","type":"function","parameters":[{"name":"beforeLength","type":"integer"},{"name":"afterLength","type":"integer"}],"returns_async":{"name":"callback","parameters":[{"name":"surroundingInfo","type":"object","properties":{"before":{"type":"string"},"selected":{"type":"string"},"after":{"type":"string"}}}]}},{"name":"getSettings","type":"function","parameters":[{"name":"engineID","type":"string"}],"returns_async":{"name":"callback","parameters":[{"name":"settings","$ref":"inputMethodPrivate.InputMethodSettings","optional":true}]}},{"name":"setSettings","type":"function","parameters":[{"name":"engineID","type":"string"},{"name":"settings","$ref":"inputMethodPrivate.InputMethodSettings"}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"setCompositionRange","type":"function","parameters":[{"name":"parameters","type":"object","properties":{"contextID":{"type":"integer"},"selectionBefore":{"type":"integer"},"selectionAfter":{"type":"integer"},"segments":{"type":"array","optional":true,"items":{"type":"object","properties":{"start":{"type":"integer"},"end":{"type":"integer"},"style":{"$ref":"inputMethodPrivate.UnderlineStyle"}}}}}}],"returns_async":{"name":"callback","optional":true,"parameters":[{"name":"success","type":"boolea)R" R"R(n"}]}},{"name":"reset","type":"function","parameters":[]},{"name":"onAutocorrect","type":"function","platforms":["chromeos"],"parameters":[{"name":"parameters","type":"object","properties":{"contextID":{"type":"integer"},"typedWord":{"type":"string"},"correctedWord":{"type":"string"},"startIndex":{"type":"integer"}}}]},{"name":"notifyInputMethodReadyForTesting","type":"function","parameters":[]},{"name":"getLanguagePackStatus","type":"function","parameters":[{"name":"inputMethodId","type":"string"}],"returns_async":{"name":"callback","parameters":[{"name":"status","$ref":"inputMethodPrivate.LanguagePackStatus"}]}}],"events":[{"name":"onCaretBoundsChanged","type":"function","parameters":[{"name":"caretBounds","type":"object","properties":{"x":{"type":"integer"},"y":{"type":"integer"},"w":{"type":"integer"},"h":{"type":"integer"}}}]},{"name":"onChanged","type":"function","parameters":[{"name":"newInputMethodId","type":"string"}]},{"name":"onDictionaryLoaded","type":"function","parameters":[]},{"name":"onDictionaryChanged","type":"function","parameters":[{"name":"added","type":"array","items":{"type":"string"}},{"name":"removed","type":"array","items":{"type":"string"}}]},{"name":"onImeMenuActivationChanged","type":"function","parameters":[{"name":"activation","type":"boolean"}]},{"name":"onImeMenuListChanged","type":"function","parameters":[]},{"name":"onImeMenuItemsChanged","type":"function","parameters":[{"name":"engineID","type":"string"},{"name":"items","type":"array","items":{"$ref":"inputMethodPrivate.MenuItem"}}]},{"name":"onFocus","type":"function","parameters":[{"$ref":"inputMethodPrivate.InputContext","name":"context"}]},{"name":"onScreenProjectionChanged","type":"function","parameters":[{"name":"isProjected","type":"boolean"}]},{"name":"onSuggestionsChanged","type":"function","parameters":[{"name":"suggestions","type":"array","items":{"type":"string"}}]},{"name":"onInputMethodOptionsChanged","type":"function","parameters":[{"name":"engineID","type":"string"}]},{"name":"onLanguagePackStatusChanged","type":"function","parameters":[{"name":"change","$ref":"inputMethodPrivate.LanguagePackStatusChange"}]}]})R";
}  // namespace

namespace extensions {
namespace api {

// static
bool ChromeGeneratedSchemas::IsGenerated(std::string_view name) {
  return !Get(name).empty();
}

// static
std::string_view ChromeGeneratedSchemas::Get(std::string_view name) {
  static constexpr auto kSchemas = base::MakeFixedFlatMap<std::string_view, std::string_view>({
    {"accessibilityFeatures", kAccessibilityFeatures},
    {"action", kAction},
    {"activityLogPrivate", kActivityLogPrivate},
    {"app", kApp},
    {"autofillPrivate", kAutofillPrivate},
    {"autotestPrivate", kAutotestPrivate},
    {"bookmarkManagerPrivate", kBookmarkManagerPrivate},
    {"bookmarks", kBookmarks},
    {"brailleDisplayPrivate", kBrailleDisplayPrivate},
    {"browserAction", kBrowserAction},
    {"browsingData", kBrowsingData},
    {"chromeWebViewInternal", kChromeWebViewInternal},
    {"commandLinePrivate", kCommandLinePrivate},
    {"commands", kCommands},
    {"contentSettings", kContentSettings},
    {"contextMenus", kContextMenus},
    {"cookies", kCookies},
    {"crashReportPrivate", kCrashReportPrivate},
    {"debugger", kDebugger},
    {"declarativeContent", kDeclarativeContent},
    {"desktopCapture", kDesktopCapture},
    {"developerPrivate", kDeveloperPrivate},
    {"dom", kDom},
    {"downloads", kDownloads},
    {"downloadsInternal", kDownloadsInternal},
    {"enterprise.hardwarePlatform", kEnterpriseHardwarePlatform},
    {"enterprise.reportingPrivate", kEnterpriseReportingPrivate},
    {"experimentalActor", kExperimentalActor},
    {"experimentalAiData", kExperimentalAiData},
    {"extension", kExtension},
    {"fontSettings", kFontSettings},
    {"gcm", kGcm},
    {"history", kHistory},
    {"identity", kIdentity},
    {"idltest", kIdltest},
    {"imageWriterPrivate", kImageWriterPrivate},
    {"inputMethodPrivate", kInputMethodPrivate},
    {"instanceID", kInstanceID},
    {"languageSettingsPrivate", kLanguageSettingsPrivate},
    {"mdns", kMdns},
    {"notifications", kNotifications},
    {"omnibox", kOmnibox},
    {"pageAction", kPageAction},
    {"pageCapture", kPageCapture},
    {"passwordsPrivate", kPasswordsPrivate},
    {"pdfViewerPrivate", kPdfViewerPrivate},
    {"permissions", kPermissions},
    {"privacy", kPrivacy},
    {"processes", kProcesses},
    {"proxy", kProxy},
    {"readingList", kReadingList},
    {"resourcesPrivate", kResourcesPrivate},
    {"safeBrowsingPrivate", kSafeBrowsingPrivate},
    {"scripting", kScripting},
    {"search", kSearch},
    {"sessions", kSessions},
    {"settingsPrivate", kSettingsPrivate},
    {"sidePanel", kSidePanel},
    {"systemPrivate", kSystemPrivate},
    {"tabCapture", kTabCapture},
    {"tabGroups", kTabGroups},
    {"tabs", kTabs},
    {"topSites", kTopSites},
    {"tts", kTts},
    {"ttsEngine", kTtsEngine},
    {"webAuthenticationProxy", kWebAuthenticationProxy},
    {"webNavigation", kWebNavigation},
    {"webrtcAudioPrivate", kWebrtcAudioPrivate},
    {"webrtcDesktopCapturePrivate", kWebrtcDesktopCapturePrivate},
    {"webrtcLoggingPrivate", kWebrtcLoggingPrivate},
    {"webstorePrivate", kWebstorePrivate},
    {"windows", kWindows},
  });
  auto it = kSchemas.find(name);
  return it != kSchemas.end() ? it->second : std::string_view();
}

}  // namespace api
}  // namespace extensions
