// chrome/common/compose/compose.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_COMMON_COMPOSE_COMPOSE_MOJOM_H_
#define CHROME_COMMON_COMPOSE_COMPOSE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/common/compose/compose.mojom-features.h"  // IWYU pragma: export
#include "chrome/common/compose/compose.mojom-shared.h"  // IWYU pragma: export
#include "chrome/common/compose/compose.mojom-forward.h"  // IWYU pragma: export
#include "components/compose/core/browser/compose_enums.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace compose::mojom {

class ComposeSessionUntrustedPageHandlerFactoryProxy;

template <typename ImplRefTraits>
class ComposeSessionUntrustedPageHandlerFactoryStub;

class ComposeSessionUntrustedPageHandlerFactoryRequestValidator;


class ComposeSessionUntrustedPageHandlerFactory
    : public ComposeSessionUntrustedPageHandlerFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "compose.mojom.ComposeSessionUntrustedPageHandlerFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ComposeSessionUntrustedPageHandlerFactoryInterfaceBase;
  using Proxy_ = ComposeSessionUntrustedPageHandlerFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = ComposeSessionUntrustedPageHandlerFactoryStub<ImplRefTraits>;

  using RequestValidator_ = ComposeSessionUntrustedPageHandlerFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreateComposeSessionUntrustedPageHandlerMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateComposeSessionUntrustedPageHandler_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ComposeSessionUntrustedPageHandlerFactory() = default;

  virtual void CreateComposeSessionUntrustedPageHandler(::mojo::PendingReceiver<ComposeClientUntrustedPageHandler> client_handler, ::mojo::PendingReceiver<ComposeSessionUntrustedPageHandler> handler, ::mojo::PendingRemote<ComposeUntrustedDialog> dialog) = 0;
};

class ComposeSessionUntrustedPageHandlerProxy;

template <typename ImplRefTraits>
class ComposeSessionUntrustedPageHandlerStub;

class ComposeSessionUntrustedPageHandlerRequestValidator;
class ComposeSessionUntrustedPageHandlerResponseValidator;


class ComposeSessionUntrustedPageHandler
    : public ComposeSessionUntrustedPageHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "compose.mojom.ComposeSessionUntrustedPageHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ComposeSessionUntrustedPageHandlerInterfaceBase;
  using Proxy_ = ComposeSessionUntrustedPageHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = ComposeSessionUntrustedPageHandlerStub<ImplRefTraits>;

  using RequestValidator_ = ComposeSessionUntrustedPageHandlerRequestValidator;
  using ResponseValidator_ = ComposeSessionUntrustedPageHandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kLogCancelEditMinVersion = 0,
    kComposeMinVersion = 0,
    kRewriteMinVersion = 0,
    kLogEditInputMinVersion = 0,
    kSaveWebUIStateMinVersion = 0,
    kAcceptComposeResultMinVersion = 0,
    kRequestInitialStateMinVersion = 0,
    kUndoMinVersion = 0,
    kRecoverFromErrorStateMinVersion = 0,
    kRedoMinVersion = 0,
    kOpenBugReportingLinkMinVersion = 0,
    kOpenComposeLearnMorePageMinVersion = 0,
    kOpenEnterpriseComposeLearnMorePageMinVersion = 0,
    kOpenFeedbackSurveyLinkMinVersion = 0,
    kOpenSignInPageMinVersion = 0,
    kSetUserFeedbackMinVersion = 0,
    kEditResultMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct LogCancelEdit_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Compose_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Rewrite_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct LogEditInput_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SaveWebUIState_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AcceptComposeResult_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestInitialState_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Undo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RecoverFromErrorState_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Redo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenBugReportingLink_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenComposeLearnMorePage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenEnterpriseComposeLearnMorePage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenFeedbackSurveyLink_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenSignInPage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetUserFeedback_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct EditResult_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ComposeSessionUntrustedPageHandler() = default;

  virtual void LogCancelEdit() = 0;

  virtual void Compose(const std::string& input, InputMode mode, bool edited) = 0;

  virtual void Rewrite(StyleModifier style) = 0;

  virtual void LogEditInput() = 0;

  virtual void SaveWebUIState(const std::string& webui_state) = 0;

  using AcceptComposeResultCallback = base::OnceCallback<void(bool)>;
  using AcceptComposeResultMojoCallback = base::OnceCallback<void(bool)>;

  virtual void AcceptComposeResult(AcceptComposeResultCallback callback) = 0;

  using RequestInitialStateCallback = base::OnceCallback<void(OpenMetadataPtr)>;
  using RequestInitialStateMojoCallback = base::OnceCallback<void(OpenMetadataPtr)>;

  virtual void RequestInitialState(RequestInitialStateCallback callback) = 0;

  using UndoCallback = base::OnceCallback<void(ComposeStatePtr)>;
  using UndoMojoCallback = base::OnceCallback<void(ComposeStatePtr)>;

  virtual void Undo(UndoCallback callback) = 0;

  using RecoverFromErrorStateCallback = base::OnceCallback<void(ComposeStatePtr)>;
  using RecoverFromErrorStateMojoCallback = base::OnceCallback<void(ComposeStatePtr)>;

  virtual void RecoverFromErrorState(RecoverFromErrorStateCallback callback) = 0;

  using RedoCallback = base::OnceCallback<void(ComposeStatePtr)>;
  using RedoMojoCallback = base::OnceCallback<void(ComposeStatePtr)>;

  virtual void Redo(RedoCallback callback) = 0;

  virtual void OpenBugReportingLink() = 0;

  virtual void OpenComposeLearnMorePage() = 0;

  virtual void OpenEnterpriseComposeLearnMorePage() = 0;

  virtual void OpenFeedbackSurveyLink() = 0;

  virtual void OpenSignInPage() = 0;

  virtual void SetUserFeedback(UserFeedback feedback) = 0;

  using EditResultCallback = base::OnceCallback<void(bool)>;
  using EditResultMojoCallback = base::OnceCallback<void(bool)>;

  virtual void EditResult(const std::string& new_result, EditResultCallback callback) = 0;
};

class ComposeClientUntrustedPageHandlerProxy;

template <typename ImplRefTraits>
class ComposeClientUntrustedPageHandlerStub;

class ComposeClientUntrustedPageHandlerRequestValidator;


class ComposeClientUntrustedPageHandler
    : public ComposeClientUntrustedPageHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "compose.mojom.ComposeClientUntrustedPageHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ComposeClientUntrustedPageHandlerInterfaceBase;
  using Proxy_ = ComposeClientUntrustedPageHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = ComposeClientUntrustedPageHandlerStub<ImplRefTraits>;

  using RequestValidator_ = ComposeClientUntrustedPageHandlerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kShowUIMinVersion = 0,
    kCloseUIMinVersion = 0,
    kCompleteFirstRunMinVersion = 0,
    kOpenComposeSettingsMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ShowUI_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CloseUI_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CompleteFirstRun_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenComposeSettings_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ComposeClientUntrustedPageHandler() = default;

  virtual void ShowUI() = 0;

  virtual void CloseUI(CloseReason reason) = 0;

  virtual void CompleteFirstRun() = 0;

  virtual void OpenComposeSettings() = 0;
};

class ComposeUntrustedDialogProxy;

template <typename ImplRefTraits>
class ComposeUntrustedDialogStub;

class ComposeUntrustedDialogRequestValidator;


class ComposeUntrustedDialog
    : public ComposeUntrustedDialogInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "compose.mojom.ComposeUntrustedDialog";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ComposeUntrustedDialogInterfaceBase;
  using Proxy_ = ComposeUntrustedDialogProxy;

  template <typename ImplRefTraits>
  using Stub_ = ComposeUntrustedDialogStub<ImplRefTraits>;

  using RequestValidator_ = ComposeUntrustedDialogRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kResponseReceivedMinVersion = 0,
    kPartialResponseReceivedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ResponseReceived_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PartialResponseReceived_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ComposeUntrustedDialog() = default;

  virtual void ResponseReceived(ComposeResponsePtr response) = 0;

  virtual void PartialResponseReceived(PartialComposeResponsePtr partial_response) = 0;
};



class  ComposeSessionUntrustedPageHandlerFactoryProxy
    : public ComposeSessionUntrustedPageHandlerFactory {
 public:
  using InterfaceType = ComposeSessionUntrustedPageHandlerFactory;

  explicit ComposeSessionUntrustedPageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateComposeSessionUntrustedPageHandler(::mojo::PendingReceiver<ComposeClientUntrustedPageHandler> client_handler, ::mojo::PendingReceiver<ComposeSessionUntrustedPageHandler> handler, ::mojo::PendingRemote<ComposeUntrustedDialog> dialog) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  ComposeSessionUntrustedPageHandlerProxy
    : public ComposeSessionUntrustedPageHandler {
 public:
  using InterfaceType = ComposeSessionUntrustedPageHandler;

  explicit ComposeSessionUntrustedPageHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void LogCancelEdit() final;
  
  void Compose(const std::string& input, InputMode mode, bool edited) final;
  
  void Rewrite(StyleModifier style) final;
  
  void LogEditInput() final;
  
  void SaveWebUIState(const std::string& webui_state) final;
  
  void AcceptComposeResult(AcceptComposeResultCallback callback) final;
  
  void RequestInitialState(RequestInitialStateCallback callback) final;
  
  void Undo(UndoCallback callback) final;
  
  void RecoverFromErrorState(RecoverFromErrorStateCallback callback) final;
  
  void Redo(RedoCallback callback) final;
  
  void OpenBugReportingLink() final;
  
  void OpenComposeLearnMorePage() final;
  
  void OpenEnterpriseComposeLearnMorePage() final;
  
  void OpenFeedbackSurveyLink() final;
  
  void OpenSignInPage() final;
  
  void SetUserFeedback(UserFeedback feedback) final;
  
  void EditResult(const std::string& new_result, EditResultCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  ComposeClientUntrustedPageHandlerProxy
    : public ComposeClientUntrustedPageHandler {
 public:
  using InterfaceType = ComposeClientUntrustedPageHandler;

  explicit ComposeClientUntrustedPageHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ShowUI() final;
  
  void CloseUI(CloseReason reason) final;
  
  void CompleteFirstRun() final;
  
  void OpenComposeSettings() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  ComposeUntrustedDialogProxy
    : public ComposeUntrustedDialog {
 public:
  using InterfaceType = ComposeUntrustedDialog;

  explicit ComposeUntrustedDialogProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ResponseReceived(ComposeResponsePtr response) final;
  
  void PartialResponseReceived(PartialComposeResponsePtr partial_response) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  ComposeSessionUntrustedPageHandlerFactoryStubDispatch {
 public:
  static bool Accept(ComposeSessionUntrustedPageHandlerFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ComposeSessionUntrustedPageHandlerFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ComposeSessionUntrustedPageHandlerFactory>>
class ComposeSessionUntrustedPageHandlerFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ComposeSessionUntrustedPageHandlerFactoryStub() = default;
  ~ComposeSessionUntrustedPageHandlerFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ComposeSessionUntrustedPageHandlerFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ComposeSessionUntrustedPageHandlerFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ComposeSessionUntrustedPageHandlerStubDispatch {
 public:
  static bool Accept(ComposeSessionUntrustedPageHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ComposeSessionUntrustedPageHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ComposeSessionUntrustedPageHandler>>
class ComposeSessionUntrustedPageHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ComposeSessionUntrustedPageHandlerStub() = default;
  ~ComposeSessionUntrustedPageHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ComposeSessionUntrustedPageHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ComposeSessionUntrustedPageHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ComposeClientUntrustedPageHandlerStubDispatch {
 public:
  static bool Accept(ComposeClientUntrustedPageHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ComposeClientUntrustedPageHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ComposeClientUntrustedPageHandler>>
class ComposeClientUntrustedPageHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ComposeClientUntrustedPageHandlerStub() = default;
  ~ComposeClientUntrustedPageHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ComposeClientUntrustedPageHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ComposeClientUntrustedPageHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ComposeUntrustedDialogStubDispatch {
 public:
  static bool Accept(ComposeUntrustedDialog* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ComposeUntrustedDialog* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ComposeUntrustedDialog>>
class ComposeUntrustedDialogStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ComposeUntrustedDialogStub() = default;
  ~ComposeUntrustedDialogStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ComposeUntrustedDialogStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ComposeUntrustedDialogStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ComposeSessionUntrustedPageHandlerFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ComposeSessionUntrustedPageHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ComposeClientUntrustedPageHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ComposeUntrustedDialogRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ComposeSessionUntrustedPageHandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};






class  PartialComposeResponse {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PartialComposeResponse, T>::value>;
  using DataView = PartialComposeResponseDataView;
  using Data_ = internal::PartialComposeResponse_Data;

  template <typename... Args>
  static PartialComposeResponsePtr New(Args&&... args) {
    return PartialComposeResponsePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PartialComposeResponsePtr From(const U& u) {
    return mojo::TypeConverter<PartialComposeResponsePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PartialComposeResponse>::Convert(*this);
  }


  PartialComposeResponse();

  explicit PartialComposeResponse(
      const std::string& result);


  ~PartialComposeResponse();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PartialComposeResponsePtr>
  PartialComposeResponsePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PartialComposeResponse::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PartialComposeResponse::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PartialComposeResponse::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PartialComposeResponse::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PartialComposeResponse::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PartialComposeResponse::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PartialComposeResponse_UnserializedMessageContext<
            UserType, PartialComposeResponse::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PartialComposeResponse::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PartialComposeResponse::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PartialComposeResponse_UnserializedMessageContext<
            UserType, PartialComposeResponse::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PartialComposeResponse::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string result;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PartialComposeResponse::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PartialComposeResponse::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PartialComposeResponse::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PartialComposeResponse::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  ConfigurableParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ConfigurableParams, T>::value>;
  using DataView = ConfigurableParamsDataView;
  using Data_ = internal::ConfigurableParams_Data;

  template <typename... Args>
  static ConfigurableParamsPtr New(Args&&... args) {
    return ConfigurableParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ConfigurableParamsPtr From(const U& u) {
    return mojo::TypeConverter<ConfigurableParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ConfigurableParams>::Convert(*this);
  }


  ConfigurableParams();

  ConfigurableParams(
      int32_t min_word_limit,
      int32_t max_word_limit,
      int32_t max_character_limit);


  ~ConfigurableParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ConfigurableParamsPtr>
  ConfigurableParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ConfigurableParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ConfigurableParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ConfigurableParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ConfigurableParams::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ConfigurableParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ConfigurableParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ConfigurableParams_UnserializedMessageContext<
            UserType, ConfigurableParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ConfigurableParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ConfigurableParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ConfigurableParams_UnserializedMessageContext<
            UserType, ConfigurableParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ConfigurableParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t min_word_limit;
  
  int32_t max_word_limit;
  
  int32_t max_character_limit;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ConfigurableParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ConfigurableParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ConfigurableParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ConfigurableParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}








class  ComposeResponse {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ComposeResponse, T>::value>;
  using DataView = ComposeResponseDataView;
  using Data_ = internal::ComposeResponse_Data;

  template <typename... Args>
  static ComposeResponsePtr New(Args&&... args) {
    return ComposeResponsePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ComposeResponsePtr From(const U& u) {
    return mojo::TypeConverter<ComposeResponsePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ComposeResponse>::Convert(*this);
  }


  ComposeResponse();

  ComposeResponse(
      ::compose::mojom::ComposeStatus status,
      const std::string& result,
      bool undo_available,
      bool redo_available,
      bool provided_by_user,
      bool on_device_evaluation_used,
      bool triggered_from_modifier);


  ~ComposeResponse();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ComposeResponsePtr>
  ComposeResponsePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ComposeResponse::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ComposeResponse::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ComposeResponse::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ComposeResponse::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ComposeResponse::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ComposeResponse::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ComposeResponse_UnserializedMessageContext<
            UserType, ComposeResponse::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ComposeResponse::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ComposeResponse::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ComposeResponse_UnserializedMessageContext<
            UserType, ComposeResponse::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ComposeResponse::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::compose::mojom::ComposeStatus status;
  
  std::string result;
  
  bool undo_available;
  
  bool redo_available;
  
  bool provided_by_user;
  
  bool on_device_evaluation_used;
  
  bool triggered_from_modifier;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ComposeResponse::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ComposeResponse::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ComposeResponse::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ComposeResponse::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  ComposeState {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ComposeState, T>::value>;
  using DataView = ComposeStateDataView;
  using Data_ = internal::ComposeState_Data;

  template <typename... Args>
  static ComposeStatePtr New(Args&&... args) {
    return ComposeStatePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ComposeStatePtr From(const U& u) {
    return mojo::TypeConverter<ComposeStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ComposeState>::Convert(*this);
  }


  ComposeState();

  ComposeState(
      const std::string& webui_state,
      ComposeResponsePtr response,
      bool has_pending_request,
      UserFeedback feedback);

ComposeState(const ComposeState&) = delete;
ComposeState& operator=(const ComposeState&) = delete;

  ~ComposeState();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ComposeStatePtr>
  ComposeStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ComposeState::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ComposeState::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ComposeState::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ComposeState::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ComposeState::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ComposeState::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ComposeState_UnserializedMessageContext<
            UserType, ComposeState::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ComposeState::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ComposeState::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ComposeState_UnserializedMessageContext<
            UserType, ComposeState::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ComposeState::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string webui_state;
  
  ComposeResponsePtr response;
  
  bool has_pending_request;
  
  UserFeedback feedback;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ComposeState::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ComposeState::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ComposeState::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ComposeState::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  OpenMetadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<OpenMetadata, T>::value>;
  using DataView = OpenMetadataDataView;
  using Data_ = internal::OpenMetadata_Data;

  template <typename... Args>
  static OpenMetadataPtr New(Args&&... args) {
    return OpenMetadataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static OpenMetadataPtr From(const U& u) {
    return mojo::TypeConverter<OpenMetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, OpenMetadata>::Convert(*this);
  }


  OpenMetadata();

  OpenMetadata(
      bool fre_complete,
      bool msbb_state,
      const std::string& initial_input,
      bool text_selected,
      ComposeStatePtr compose_state,
      ConfigurableParamsPtr configurable_params);

OpenMetadata(const OpenMetadata&) = delete;
OpenMetadata& operator=(const OpenMetadata&) = delete;

  ~OpenMetadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = OpenMetadataPtr>
  OpenMetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, OpenMetadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, OpenMetadata::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, OpenMetadata::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        OpenMetadata::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        OpenMetadata::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        OpenMetadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::OpenMetadata_UnserializedMessageContext<
            UserType, OpenMetadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<OpenMetadata::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return OpenMetadata::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::OpenMetadata_UnserializedMessageContext<
            UserType, OpenMetadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<OpenMetadata::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool fre_complete;
  
  bool msbb_state;
  
  std::string initial_input;
  
  bool text_selected;
  
  ComposeStatePtr compose_state;
  
  ConfigurableParamsPtr configurable_params;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, OpenMetadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, OpenMetadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, OpenMetadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, OpenMetadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ComposeResponsePtr ComposeResponse::Clone() const {
  return New(
      mojo::Clone(status),
      mojo::Clone(result),
      mojo::Clone(undo_available),
      mojo::Clone(redo_available),
      mojo::Clone(provided_by_user),
      mojo::Clone(on_device_evaluation_used),
      mojo::Clone(triggered_from_modifier)
  );
}

template <typename T, ComposeResponse::EnableIfSame<T>*>
bool ComposeResponse::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->status, other_struct.status))
    return false;
  if (!mojo::Equals(this->result, other_struct.result))
    return false;
  if (!mojo::Equals(this->undo_available, other_struct.undo_available))
    return false;
  if (!mojo::Equals(this->redo_available, other_struct.redo_available))
    return false;
  if (!mojo::Equals(this->provided_by_user, other_struct.provided_by_user))
    return false;
  if (!mojo::Equals(this->on_device_evaluation_used, other_struct.on_device_evaluation_used))
    return false;
  if (!mojo::Equals(this->triggered_from_modifier, other_struct.triggered_from_modifier))
    return false;
  return true;
}

template <typename T, ComposeResponse::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.status < rhs.status)
    return true;
  if (rhs.status < lhs.status)
    return false;
  if (lhs.result < rhs.result)
    return true;
  if (rhs.result < lhs.result)
    return false;
  if (lhs.undo_available < rhs.undo_available)
    return true;
  if (rhs.undo_available < lhs.undo_available)
    return false;
  if (lhs.redo_available < rhs.redo_available)
    return true;
  if (rhs.redo_available < lhs.redo_available)
    return false;
  if (lhs.provided_by_user < rhs.provided_by_user)
    return true;
  if (rhs.provided_by_user < lhs.provided_by_user)
    return false;
  if (lhs.on_device_evaluation_used < rhs.on_device_evaluation_used)
    return true;
  if (rhs.on_device_evaluation_used < lhs.on_device_evaluation_used)
    return false;
  if (lhs.triggered_from_modifier < rhs.triggered_from_modifier)
    return true;
  if (rhs.triggered_from_modifier < lhs.triggered_from_modifier)
    return false;
  return false;
}
template <typename StructPtrType>
PartialComposeResponsePtr PartialComposeResponse::Clone() const {
  return New(
      mojo::Clone(result)
  );
}

template <typename T, PartialComposeResponse::EnableIfSame<T>*>
bool PartialComposeResponse::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->result, other_struct.result))
    return false;
  return true;
}

template <typename T, PartialComposeResponse::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.result < rhs.result)
    return true;
  if (rhs.result < lhs.result)
    return false;
  return false;
}
template <typename StructPtrType>
ComposeStatePtr ComposeState::Clone() const {
  return New(
      mojo::Clone(webui_state),
      mojo::Clone(response),
      mojo::Clone(has_pending_request),
      mojo::Clone(feedback)
  );
}

template <typename T, ComposeState::EnableIfSame<T>*>
bool ComposeState::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->webui_state, other_struct.webui_state))
    return false;
  if (!mojo::Equals(this->response, other_struct.response))
    return false;
  if (!mojo::Equals(this->has_pending_request, other_struct.has_pending_request))
    return false;
  if (!mojo::Equals(this->feedback, other_struct.feedback))
    return false;
  return true;
}

template <typename T, ComposeState::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.webui_state < rhs.webui_state)
    return true;
  if (rhs.webui_state < lhs.webui_state)
    return false;
  if (lhs.response < rhs.response)
    return true;
  if (rhs.response < lhs.response)
    return false;
  if (lhs.has_pending_request < rhs.has_pending_request)
    return true;
  if (rhs.has_pending_request < lhs.has_pending_request)
    return false;
  if (lhs.feedback < rhs.feedback)
    return true;
  if (rhs.feedback < lhs.feedback)
    return false;
  return false;
}
template <typename StructPtrType>
ConfigurableParamsPtr ConfigurableParams::Clone() const {
  return New(
      mojo::Clone(min_word_limit),
      mojo::Clone(max_word_limit),
      mojo::Clone(max_character_limit)
  );
}

template <typename T, ConfigurableParams::EnableIfSame<T>*>
bool ConfigurableParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->min_word_limit, other_struct.min_word_limit))
    return false;
  if (!mojo::Equals(this->max_word_limit, other_struct.max_word_limit))
    return false;
  if (!mojo::Equals(this->max_character_limit, other_struct.max_character_limit))
    return false;
  return true;
}

template <typename T, ConfigurableParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.min_word_limit < rhs.min_word_limit)
    return true;
  if (rhs.min_word_limit < lhs.min_word_limit)
    return false;
  if (lhs.max_word_limit < rhs.max_word_limit)
    return true;
  if (rhs.max_word_limit < lhs.max_word_limit)
    return false;
  if (lhs.max_character_limit < rhs.max_character_limit)
    return true;
  if (rhs.max_character_limit < lhs.max_character_limit)
    return false;
  return false;
}
template <typename StructPtrType>
OpenMetadataPtr OpenMetadata::Clone() const {
  return New(
      mojo::Clone(fre_complete),
      mojo::Clone(msbb_state),
      mojo::Clone(initial_input),
      mojo::Clone(text_selected),
      mojo::Clone(compose_state),
      mojo::Clone(configurable_params)
  );
}

template <typename T, OpenMetadata::EnableIfSame<T>*>
bool OpenMetadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->fre_complete, other_struct.fre_complete))
    return false;
  if (!mojo::Equals(this->msbb_state, other_struct.msbb_state))
    return false;
  if (!mojo::Equals(this->initial_input, other_struct.initial_input))
    return false;
  if (!mojo::Equals(this->text_selected, other_struct.text_selected))
    return false;
  if (!mojo::Equals(this->compose_state, other_struct.compose_state))
    return false;
  if (!mojo::Equals(this->configurable_params, other_struct.configurable_params))
    return false;
  return true;
}

template <typename T, OpenMetadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.fre_complete < rhs.fre_complete)
    return true;
  if (rhs.fre_complete < lhs.fre_complete)
    return false;
  if (lhs.msbb_state < rhs.msbb_state)
    return true;
  if (rhs.msbb_state < lhs.msbb_state)
    return false;
  if (lhs.initial_input < rhs.initial_input)
    return true;
  if (rhs.initial_input < lhs.initial_input)
    return false;
  if (lhs.text_selected < rhs.text_selected)
    return true;
  if (rhs.text_selected < lhs.text_selected)
    return false;
  if (lhs.compose_state < rhs.compose_state)
    return true;
  if (rhs.compose_state < lhs.compose_state)
    return false;
  if (lhs.configurable_params < rhs.configurable_params)
    return true;
  if (rhs.configurable_params < lhs.configurable_params)
    return false;
  return false;
}


}  // compose::mojom

namespace mojo {


template <>
struct  StructTraits<::compose::mojom::ComposeResponse::DataView,
                                         ::compose::mojom::ComposeResponsePtr> {
  static bool IsNull(const ::compose::mojom::ComposeResponsePtr& input) { return !input; }
  static void SetToNull(::compose::mojom::ComposeResponsePtr* output) { output->reset(); }

  static decltype(::compose::mojom::ComposeResponse::status) status(
      const ::compose::mojom::ComposeResponsePtr& input) {
    return input->status;
  }

  static const decltype(::compose::mojom::ComposeResponse::result)& result(
      const ::compose::mojom::ComposeResponsePtr& input) {
    return input->result;
  }

  static decltype(::compose::mojom::ComposeResponse::undo_available) undo_available(
      const ::compose::mojom::ComposeResponsePtr& input) {
    return input->undo_available;
  }

  static decltype(::compose::mojom::ComposeResponse::redo_available) redo_available(
      const ::compose::mojom::ComposeResponsePtr& input) {
    return input->redo_available;
  }

  static decltype(::compose::mojom::ComposeResponse::provided_by_user) provided_by_user(
      const ::compose::mojom::ComposeResponsePtr& input) {
    return input->provided_by_user;
  }

  static decltype(::compose::mojom::ComposeResponse::on_device_evaluation_used) on_device_evaluation_used(
      const ::compose::mojom::ComposeResponsePtr& input) {
    return input->on_device_evaluation_used;
  }

  static decltype(::compose::mojom::ComposeResponse::triggered_from_modifier) triggered_from_modifier(
      const ::compose::mojom::ComposeResponsePtr& input) {
    return input->triggered_from_modifier;
  }

  static bool Read(::compose::mojom::ComposeResponse::DataView input, ::compose::mojom::ComposeResponsePtr* output);
};


template <>
struct  StructTraits<::compose::mojom::PartialComposeResponse::DataView,
                                         ::compose::mojom::PartialComposeResponsePtr> {
  static bool IsNull(const ::compose::mojom::PartialComposeResponsePtr& input) { return !input; }
  static void SetToNull(::compose::mojom::PartialComposeResponsePtr* output) { output->reset(); }

  static const decltype(::compose::mojom::PartialComposeResponse::result)& result(
      const ::compose::mojom::PartialComposeResponsePtr& input) {
    return input->result;
  }

  static bool Read(::compose::mojom::PartialComposeResponse::DataView input, ::compose::mojom::PartialComposeResponsePtr* output);
};


template <>
struct  StructTraits<::compose::mojom::ComposeState::DataView,
                                         ::compose::mojom::ComposeStatePtr> {
  static bool IsNull(const ::compose::mojom::ComposeStatePtr& input) { return !input; }
  static void SetToNull(::compose::mojom::ComposeStatePtr* output) { output->reset(); }

  static const decltype(::compose::mojom::ComposeState::webui_state)& webui_state(
      const ::compose::mojom::ComposeStatePtr& input) {
    return input->webui_state;
  }

  static const decltype(::compose::mojom::ComposeState::response)& response(
      const ::compose::mojom::ComposeStatePtr& input) {
    return input->response;
  }

  static decltype(::compose::mojom::ComposeState::has_pending_request) has_pending_request(
      const ::compose::mojom::ComposeStatePtr& input) {
    return input->has_pending_request;
  }

  static decltype(::compose::mojom::ComposeState::feedback) feedback(
      const ::compose::mojom::ComposeStatePtr& input) {
    return input->feedback;
  }

  static bool Read(::compose::mojom::ComposeState::DataView input, ::compose::mojom::ComposeStatePtr* output);
};


template <>
struct  StructTraits<::compose::mojom::ConfigurableParams::DataView,
                                         ::compose::mojom::ConfigurableParamsPtr> {
  static bool IsNull(const ::compose::mojom::ConfigurableParamsPtr& input) { return !input; }
  static void SetToNull(::compose::mojom::ConfigurableParamsPtr* output) { output->reset(); }

  static decltype(::compose::mojom::ConfigurableParams::min_word_limit) min_word_limit(
      const ::compose::mojom::ConfigurableParamsPtr& input) {
    return input->min_word_limit;
  }

  static decltype(::compose::mojom::ConfigurableParams::max_word_limit) max_word_limit(
      const ::compose::mojom::ConfigurableParamsPtr& input) {
    return input->max_word_limit;
  }

  static decltype(::compose::mojom::ConfigurableParams::max_character_limit) max_character_limit(
      const ::compose::mojom::ConfigurableParamsPtr& input) {
    return input->max_character_limit;
  }

  static bool Read(::compose::mojom::ConfigurableParams::DataView input, ::compose::mojom::ConfigurableParamsPtr* output);
};


template <>
struct  StructTraits<::compose::mojom::OpenMetadata::DataView,
                                         ::compose::mojom::OpenMetadataPtr> {
  static bool IsNull(const ::compose::mojom::OpenMetadataPtr& input) { return !input; }
  static void SetToNull(::compose::mojom::OpenMetadataPtr* output) { output->reset(); }

  static decltype(::compose::mojom::OpenMetadata::fre_complete) fre_complete(
      const ::compose::mojom::OpenMetadataPtr& input) {
    return input->fre_complete;
  }

  static decltype(::compose::mojom::OpenMetadata::msbb_state) msbb_state(
      const ::compose::mojom::OpenMetadataPtr& input) {
    return input->msbb_state;
  }

  static const decltype(::compose::mojom::OpenMetadata::initial_input)& initial_input(
      const ::compose::mojom::OpenMetadataPtr& input) {
    return input->initial_input;
  }

  static decltype(::compose::mojom::OpenMetadata::text_selected) text_selected(
      const ::compose::mojom::OpenMetadataPtr& input) {
    return input->text_selected;
  }

  static const decltype(::compose::mojom::OpenMetadata::compose_state)& compose_state(
      const ::compose::mojom::OpenMetadataPtr& input) {
    return input->compose_state;
  }

  static const decltype(::compose::mojom::OpenMetadata::configurable_params)& configurable_params(
      const ::compose::mojom::OpenMetadataPtr& input) {
    return input->configurable_params;
  }

  static bool Read(::compose::mojom::OpenMetadata::DataView input, ::compose::mojom::OpenMetadataPtr* output);
};

}  // namespace mojo

#endif  // CHROME_COMMON_COMPOSE_COMPOSE_MOJOM_H_