// chrome/common/actor_webui.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_COMMON_ACTOR_WEBUI_MOJOM_H_
#define CHROME_COMMON_ACTOR_WEBUI_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/common/actor_webui.mojom-features.h"  // IWYU pragma: export
#include "chrome/common/actor_webui.mojom-shared.h"  // IWYU pragma: export
#include "chrome/common/actor_webui.mojom-forward.h"  // IWYU pragma: export
#include "skia/public/mojom/bitmap.mojom.h"
#include "url/mojom/origin.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace actor::webui::mojom {





class  TaskOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TaskOptions, T>::value>;
  using DataView = TaskOptionsDataView;
  using Data_ = internal::TaskOptions_Data;

  template <typename... Args>
  static TaskOptionsPtr New(Args&&... args) {
    return TaskOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TaskOptionsPtr From(const U& u) {
    return mojo::TypeConverter<TaskOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TaskOptions>::Convert(*this);
  }


  TaskOptions();

  explicit TaskOptions(
      const std::optional<std::string>& title);


  ~TaskOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TaskOptionsPtr>
  TaskOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TaskOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TaskOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TaskOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TaskOptions::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TaskOptions::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TaskOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TaskOptions_UnserializedMessageContext<
            UserType, TaskOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TaskOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TaskOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TaskOptions_UnserializedMessageContext<
            UserType, TaskOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TaskOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<std::string> title;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TaskOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TaskOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TaskOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TaskOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class  SelectCredentialDialogResponse {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SelectCredentialDialogResponse, T>::value>;
  using DataView = SelectCredentialDialogResponseDataView;
  using Data_ = internal::SelectCredentialDialogResponse_Data;

  template <typename... Args>
  static SelectCredentialDialogResponsePtr New(Args&&... args) {
    return SelectCredentialDialogResponsePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SelectCredentialDialogResponsePtr From(const U& u) {
    return mojo::TypeConverter<SelectCredentialDialogResponsePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SelectCredentialDialogResponse>::Convert(*this);
  }


  SelectCredentialDialogResponse();

  SelectCredentialDialogResponse(
      int32_t task_id,
      std::optional<SelectCredentialDialogErrorReason> error_reason,
      std::optional<UserGrantedPermissionDuration> permission_duration,
      std::optional<int32_t> selected_credential_id);


  ~SelectCredentialDialogResponse();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SelectCredentialDialogResponsePtr>
  SelectCredentialDialogResponsePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SelectCredentialDialogResponse::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SelectCredentialDialogResponse::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SelectCredentialDialogResponse::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SelectCredentialDialogResponse::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SelectCredentialDialogResponse::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SelectCredentialDialogResponse::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SelectCredentialDialogResponse_UnserializedMessageContext<
            UserType, SelectCredentialDialogResponse::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SelectCredentialDialogResponse::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SelectCredentialDialogResponse::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SelectCredentialDialogResponse_UnserializedMessageContext<
            UserType, SelectCredentialDialogResponse::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SelectCredentialDialogResponse::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t task_id;
  
  std::optional<SelectCredentialDialogErrorReason> error_reason;
  
  std::optional<UserGrantedPermissionDuration> permission_duration;
  
  std::optional<int32_t> selected_credential_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SelectCredentialDialogResponse::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SelectCredentialDialogResponse::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SelectCredentialDialogResponse::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SelectCredentialDialogResponse::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}








class  FormFillingResponse {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FormFillingResponse, T>::value>;
  using DataView = FormFillingResponseDataView;
  using Data_ = internal::FormFillingResponse_Data;

  template <typename... Args>
  static FormFillingResponsePtr New(Args&&... args) {
    return FormFillingResponsePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FormFillingResponsePtr From(const U& u) {
    return mojo::TypeConverter<FormFillingResponsePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FormFillingResponse>::Convert(*this);
  }


  FormFillingResponse();

  explicit FormFillingResponse(
      const std::string& selected_suggestion_id);


  ~FormFillingResponse();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FormFillingResponsePtr>
  FormFillingResponsePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FormFillingResponse::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FormFillingResponse::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FormFillingResponse::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FormFillingResponse::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FormFillingResponse::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FormFillingResponse::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FormFillingResponse_UnserializedMessageContext<
            UserType, FormFillingResponse::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FormFillingResponse::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FormFillingResponse::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FormFillingResponse_UnserializedMessageContext<
            UserType, FormFillingResponse::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FormFillingResponse::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string selected_suggestion_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FormFillingResponse::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FormFillingResponse::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FormFillingResponse::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FormFillingResponse::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}











class  SelectAutofillSuggestionsDialogResult {
 public:
  using DataView = SelectAutofillSuggestionsDialogResultDataView;
  using Data_ = internal::SelectAutofillSuggestionsDialogResult_Data;
  using Tag = Data_::SelectAutofillSuggestionsDialogResult_Tag;

  template <typename... Args>
  static SelectAutofillSuggestionsDialogResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |error_reason|.
  static SelectAutofillSuggestionsDialogResultPtr NewErrorReason(
      SelectAutofillSuggestionsDialogErrorReason value);
  // Construct an instance holding |selected_suggestions|.
  static SelectAutofillSuggestionsDialogResultPtr NewSelectedSuggestions(
      std::vector<FormFillingResponsePtr> value);

  template <typename U>
  static SelectAutofillSuggestionsDialogResultPtr From(const U& u) {
    return mojo::TypeConverter<SelectAutofillSuggestionsDialogResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SelectAutofillSuggestionsDialogResult>::Convert(*this);
  }
  ~SelectAutofillSuggestionsDialogResult();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  SelectAutofillSuggestionsDialogResult(const SelectAutofillSuggestionsDialogResult& other) = delete;
  SelectAutofillSuggestionsDialogResult& operator=(const SelectAutofillSuggestionsDialogResult& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = SelectAutofillSuggestionsDialogResultPtr>
  SelectAutofillSuggestionsDialogResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, SelectAutofillSuggestionsDialogResult>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, SelectAutofillSuggestionsDialogResult>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_error_reason() const { return tag_ == Tag::kErrorReason; }
  SelectAutofillSuggestionsDialogErrorReason get_error_reason() const {
    CHECK(tag_ == Tag::kErrorReason);
    return data_.error_reason;
  }
  void set_error_reason(SelectAutofillSuggestionsDialogErrorReason error_reason);

  bool is_selected_suggestions() const { return tag_ == Tag::kSelectedSuggestions; }
  const std::vector<FormFillingResponsePtr>& get_selected_suggestions() const {
    CHECK(tag_ == Tag::kSelectedSuggestions);
    return data_.selected_suggestions;
  }
  std::vector<FormFillingResponsePtr>& get_selected_suggestions() {
    CHECK(tag_ == Tag::kSelectedSuggestions);
    return data_.selected_suggestions;
  }
  void set_selected_suggestions(std::vector<FormFillingResponsePtr> selected_suggestions);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SelectAutofillSuggestionsDialogResult::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<SelectAutofillSuggestionsDialogResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kErrorReason)>,
        SelectAutofillSuggestionsDialogErrorReason value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSelectedSuggestions)>,
        std::vector<FormFillingResponsePtr> value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    SelectAutofillSuggestionsDialogErrorReason error_reason;
    std::vector<FormFillingResponsePtr> selected_suggestions;
  };

  SelectAutofillSuggestionsDialogResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kErrorReason)>,
      SelectAutofillSuggestionsDialogErrorReason value);
  SelectAutofillSuggestionsDialogResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kSelectedSuggestions)>,
      std::vector<FormFillingResponsePtr> value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class  UserConfirmationDialogResult {
 public:
  using DataView = UserConfirmationDialogResultDataView;
  using Data_ = internal::UserConfirmationDialogResult_Data;
  using Tag = Data_::UserConfirmationDialogResult_Tag;

  template <typename... Args>
  static UserConfirmationDialogResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |permission_granted|.
  static UserConfirmationDialogResultPtr NewPermissionGranted(
      bool value);
  // Construct an instance holding |error_reason|.
  static UserConfirmationDialogResultPtr NewErrorReason(
      ConfirmationRequestErrorReason value);

  template <typename U>
  static UserConfirmationDialogResultPtr From(const U& u) {
    return mojo::TypeConverter<UserConfirmationDialogResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, UserConfirmationDialogResult>::Convert(*this);
  }
  ~UserConfirmationDialogResult();


  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = UserConfirmationDialogResultPtr>
  UserConfirmationDialogResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, UserConfirmationDialogResult>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, UserConfirmationDialogResult>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }
  size_t Hash(size_t seed) const;

  Tag which() const {
    return tag_;
  }

  bool is_permission_granted() const { return tag_ == Tag::kPermissionGranted; }
  bool get_permission_granted() const {
    CHECK(tag_ == Tag::kPermissionGranted);
    return data_.permission_granted;
  }
  void set_permission_granted(bool permission_granted);

  bool is_error_reason() const { return tag_ == Tag::kErrorReason; }
  ConfirmationRequestErrorReason get_error_reason() const {
    CHECK(tag_ == Tag::kErrorReason);
    return data_.error_reason;
  }
  void set_error_reason(ConfirmationRequestErrorReason error_reason);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        UserConfirmationDialogResult::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<UserConfirmationDialogResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kPermissionGranted)>,
        bool value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kErrorReason)>,
        ConfirmationRequestErrorReason value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    bool permission_granted;
    ConfirmationRequestErrorReason error_reason;
  };

  UserConfirmationDialogResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kPermissionGranted)>,
      bool value);
  UserConfirmationDialogResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kErrorReason)>,
      ConfirmationRequestErrorReason value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class  ConfirmationRequestResult {
 public:
  using DataView = ConfirmationRequestResultDataView;
  using Data_ = internal::ConfirmationRequestResult_Data;
  using Tag = Data_::ConfirmationRequestResult_Tag;

  template <typename... Args>
  static ConfirmationRequestResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |permission_granted|.
  static ConfirmationRequestResultPtr NewPermissionGranted(
      bool value);
  // Construct an instance holding |error_reason|.
  static ConfirmationRequestResultPtr NewErrorReason(
      ConfirmationRequestErrorReason value);

  template <typename U>
  static ConfirmationRequestResultPtr From(const U& u) {
    return mojo::TypeConverter<ConfirmationRequestResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ConfirmationRequestResult>::Convert(*this);
  }
  ~ConfirmationRequestResult();


  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = ConfirmationRequestResultPtr>
  ConfirmationRequestResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, ConfirmationRequestResult>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, ConfirmationRequestResult>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }
  size_t Hash(size_t seed) const;

  Tag which() const {
    return tag_;
  }

  bool is_permission_granted() const { return tag_ == Tag::kPermissionGranted; }
  bool get_permission_granted() const {
    CHECK(tag_ == Tag::kPermissionGranted);
    return data_.permission_granted;
  }
  void set_permission_granted(bool permission_granted);

  bool is_error_reason() const { return tag_ == Tag::kErrorReason; }
  ConfirmationRequestErrorReason get_error_reason() const {
    CHECK(tag_ == Tag::kErrorReason);
    return data_.error_reason;
  }
  void set_error_reason(ConfirmationRequestErrorReason error_reason);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ConfirmationRequestResult::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<ConfirmationRequestResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kPermissionGranted)>,
        bool value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kErrorReason)>,
        ConfirmationRequestErrorReason value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    bool permission_granted;
    ConfirmationRequestErrorReason error_reason;
  };

  ConfirmationRequestResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kPermissionGranted)>,
      bool value);
  ConfirmationRequestResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kErrorReason)>,
      ConfirmationRequestErrorReason value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};






class  Credential {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Credential, T>::value>;
  using DataView = CredentialDataView;
  using Data_ = internal::Credential_Data;

  template <typename... Args>
  static CredentialPtr New(Args&&... args) {
    return CredentialPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CredentialPtr From(const U& u) {
    return mojo::TypeConverter<CredentialPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Credential>::Convert(*this);
  }


  Credential();

  Credential(
      int32_t id,
      const std::string& username,
      const std::string& source_site_or_app,
      const ::url::Origin& request_origin);


  ~Credential();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CredentialPtr>
  CredentialPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Credential::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Credential::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Credential::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Credential::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Credential::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Credential::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Credential_UnserializedMessageContext<
            UserType, Credential::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Credential::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Credential::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Credential_UnserializedMessageContext<
            UserType, Credential::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Credential::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t id;
  
  std::string username;
  
  std::string source_site_or_app;
  
  ::url::Origin request_origin;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Credential::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Credential::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Credential::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Credential::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  SelectCredentialDialogRequest {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SelectCredentialDialogRequest, T>::value>;
  using DataView = SelectCredentialDialogRequestDataView;
  using Data_ = internal::SelectCredentialDialogRequest_Data;

  template <typename... Args>
  static SelectCredentialDialogRequestPtr New(Args&&... args) {
    return SelectCredentialDialogRequestPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SelectCredentialDialogRequestPtr From(const U& u) {
    return mojo::TypeConverter<SelectCredentialDialogRequestPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SelectCredentialDialogRequest>::Convert(*this);
  }


  SelectCredentialDialogRequest();

  SelectCredentialDialogRequest(
      int32_t task_id,
      bool show_dialog,
      std::vector<CredentialPtr> credentials,
      const base::flat_map<std::string, ::SkBitmap>& icons);

SelectCredentialDialogRequest(const SelectCredentialDialogRequest&) = delete;
SelectCredentialDialogRequest& operator=(const SelectCredentialDialogRequest&) = delete;

  ~SelectCredentialDialogRequest();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SelectCredentialDialogRequestPtr>
  SelectCredentialDialogRequestPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SelectCredentialDialogRequest::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SelectCredentialDialogRequest::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SelectCredentialDialogRequest::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SelectCredentialDialogRequest::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SelectCredentialDialogRequest_UnserializedMessageContext<
            UserType, SelectCredentialDialogRequest::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SelectCredentialDialogRequest::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SelectCredentialDialogRequest::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SelectCredentialDialogRequest_UnserializedMessageContext<
            UserType, SelectCredentialDialogRequest::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SelectCredentialDialogRequest::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t task_id;
  
  bool show_dialog;
  
  std::vector<CredentialPtr> credentials;
  
  base::flat_map<std::string, ::SkBitmap> icons;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SelectCredentialDialogRequest::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SelectCredentialDialogRequest::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SelectCredentialDialogRequest::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SelectCredentialDialogRequest::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  AutofillSuggestion {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AutofillSuggestion, T>::value>;
  using DataView = AutofillSuggestionDataView;
  using Data_ = internal::AutofillSuggestion_Data;

  template <typename... Args>
  static AutofillSuggestionPtr New(Args&&... args) {
    return AutofillSuggestionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AutofillSuggestionPtr From(const U& u) {
    return mojo::TypeConverter<AutofillSuggestionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AutofillSuggestion>::Convert(*this);
  }


  AutofillSuggestion();

  AutofillSuggestion(
      const std::string& id,
      const std::string& title,
      const std::string& details,
      const ::SkBitmap& icon);


  ~AutofillSuggestion();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AutofillSuggestionPtr>
  AutofillSuggestionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AutofillSuggestion::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AutofillSuggestion::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AutofillSuggestion::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AutofillSuggestion::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AutofillSuggestion_UnserializedMessageContext<
            UserType, AutofillSuggestion::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AutofillSuggestion::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AutofillSuggestion::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AutofillSuggestion_UnserializedMessageContext<
            UserType, AutofillSuggestion::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AutofillSuggestion::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string id;
  
  std::string title;
  
  std::string details;
  
  ::SkBitmap icon;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AutofillSuggestion::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AutofillSuggestion::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AutofillSuggestion::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AutofillSuggestion::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  FormFillingRequest {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FormFillingRequest, T>::value>;
  using DataView = FormFillingRequestDataView;
  using Data_ = internal::FormFillingRequest_Data;

  template <typename... Args>
  static FormFillingRequestPtr New(Args&&... args) {
    return FormFillingRequestPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FormFillingRequestPtr From(const U& u) {
    return mojo::TypeConverter<FormFillingRequestPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FormFillingRequest>::Convert(*this);
  }


  FormFillingRequest();

  FormFillingRequest(
      int64_t requested_data,
      std::vector<AutofillSuggestionPtr> suggestions);

FormFillingRequest(const FormFillingRequest&) = delete;
FormFillingRequest& operator=(const FormFillingRequest&) = delete;

  ~FormFillingRequest();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FormFillingRequestPtr>
  FormFillingRequestPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FormFillingRequest::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FormFillingRequest::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FormFillingRequest::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FormFillingRequest::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FormFillingRequest_UnserializedMessageContext<
            UserType, FormFillingRequest::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FormFillingRequest::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FormFillingRequest::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FormFillingRequest_UnserializedMessageContext<
            UserType, FormFillingRequest::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FormFillingRequest::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int64_t requested_data;
  
  std::vector<AutofillSuggestionPtr> suggestions;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FormFillingRequest::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FormFillingRequest::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FormFillingRequest::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FormFillingRequest::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  SelectAutofillSuggestionsDialogRequest {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SelectAutofillSuggestionsDialogRequest, T>::value>;
  using DataView = SelectAutofillSuggestionsDialogRequestDataView;
  using Data_ = internal::SelectAutofillSuggestionsDialogRequest_Data;

  template <typename... Args>
  static SelectAutofillSuggestionsDialogRequestPtr New(Args&&... args) {
    return SelectAutofillSuggestionsDialogRequestPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SelectAutofillSuggestionsDialogRequestPtr From(const U& u) {
    return mojo::TypeConverter<SelectAutofillSuggestionsDialogRequestPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SelectAutofillSuggestionsDialogRequest>::Convert(*this);
  }


  SelectAutofillSuggestionsDialogRequest();

  SelectAutofillSuggestionsDialogRequest(
      int32_t task_id,
      std::vector<FormFillingRequestPtr> form_filling_requests);

SelectAutofillSuggestionsDialogRequest(const SelectAutofillSuggestionsDialogRequest&) = delete;
SelectAutofillSuggestionsDialogRequest& operator=(const SelectAutofillSuggestionsDialogRequest&) = delete;

  ~SelectAutofillSuggestionsDialogRequest();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SelectAutofillSuggestionsDialogRequestPtr>
  SelectAutofillSuggestionsDialogRequestPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SelectAutofillSuggestionsDialogRequest::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SelectAutofillSuggestionsDialogRequest::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SelectAutofillSuggestionsDialogRequest::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SelectAutofillSuggestionsDialogRequest::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SelectAutofillSuggestionsDialogRequest_UnserializedMessageContext<
            UserType, SelectAutofillSuggestionsDialogRequest::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SelectAutofillSuggestionsDialogRequest::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SelectAutofillSuggestionsDialogRequest::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SelectAutofillSuggestionsDialogRequest_UnserializedMessageContext<
            UserType, SelectAutofillSuggestionsDialogRequest::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SelectAutofillSuggestionsDialogRequest::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t task_id;
  
  std::vector<FormFillingRequestPtr> form_filling_requests;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SelectAutofillSuggestionsDialogRequest::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SelectAutofillSuggestionsDialogRequest::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SelectAutofillSuggestionsDialogRequest::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SelectAutofillSuggestionsDialogRequest::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  SelectAutofillSuggestionsDialogResponse {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SelectAutofillSuggestionsDialogResponse, T>::value>;
  using DataView = SelectAutofillSuggestionsDialogResponseDataView;
  using Data_ = internal::SelectAutofillSuggestionsDialogResponse_Data;

  template <typename... Args>
  static SelectAutofillSuggestionsDialogResponsePtr New(Args&&... args) {
    return SelectAutofillSuggestionsDialogResponsePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SelectAutofillSuggestionsDialogResponsePtr From(const U& u) {
    return mojo::TypeConverter<SelectAutofillSuggestionsDialogResponsePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SelectAutofillSuggestionsDialogResponse>::Convert(*this);
  }


  SelectAutofillSuggestionsDialogResponse();

  SelectAutofillSuggestionsDialogResponse(
      int32_t task_id,
      SelectAutofillSuggestionsDialogResultPtr result);

SelectAutofillSuggestionsDialogResponse(const SelectAutofillSuggestionsDialogResponse&) = delete;
SelectAutofillSuggestionsDialogResponse& operator=(const SelectAutofillSuggestionsDialogResponse&) = delete;

  ~SelectAutofillSuggestionsDialogResponse();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SelectAutofillSuggestionsDialogResponsePtr>
  SelectAutofillSuggestionsDialogResponsePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SelectAutofillSuggestionsDialogResponse::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SelectAutofillSuggestionsDialogResponse::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SelectAutofillSuggestionsDialogResponse::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SelectAutofillSuggestionsDialogResponse::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SelectAutofillSuggestionsDialogResponse::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SelectAutofillSuggestionsDialogResponse::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SelectAutofillSuggestionsDialogResponse_UnserializedMessageContext<
            UserType, SelectAutofillSuggestionsDialogResponse::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SelectAutofillSuggestionsDialogResponse::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SelectAutofillSuggestionsDialogResponse::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SelectAutofillSuggestionsDialogResponse_UnserializedMessageContext<
            UserType, SelectAutofillSuggestionsDialogResponse::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SelectAutofillSuggestionsDialogResponse::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t task_id;
  
  SelectAutofillSuggestionsDialogResultPtr result;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SelectAutofillSuggestionsDialogResponse::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SelectAutofillSuggestionsDialogResponse::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SelectAutofillSuggestionsDialogResponse::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SelectAutofillSuggestionsDialogResponse::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  UserConfirmationDialogPayload {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<UserConfirmationDialogPayload, T>::value>;
  using DataView = UserConfirmationDialogPayloadDataView;
  using Data_ = internal::UserConfirmationDialogPayload_Data;

  template <typename... Args>
  static UserConfirmationDialogPayloadPtr New(Args&&... args) {
    return UserConfirmationDialogPayloadPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static UserConfirmationDialogPayloadPtr From(const U& u) {
    return mojo::TypeConverter<UserConfirmationDialogPayloadPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, UserConfirmationDialogPayload>::Convert(*this);
  }


  UserConfirmationDialogPayload();

  UserConfirmationDialogPayload(
      const ::url::Origin& navigation_origin,
      bool for_blocklisted_origin);


  ~UserConfirmationDialogPayload();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = UserConfirmationDialogPayloadPtr>
  UserConfirmationDialogPayloadPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, UserConfirmationDialogPayload::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, UserConfirmationDialogPayload::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, UserConfirmationDialogPayload::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UserConfirmationDialogPayload::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UserConfirmationDialogPayload::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        UserConfirmationDialogPayload::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::UserConfirmationDialogPayload_UnserializedMessageContext<
            UserType, UserConfirmationDialogPayload::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<UserConfirmationDialogPayload::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return UserConfirmationDialogPayload::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::UserConfirmationDialogPayload_UnserializedMessageContext<
            UserType, UserConfirmationDialogPayload::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<UserConfirmationDialogPayload::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::url::Origin navigation_origin;
  
  bool for_blocklisted_origin;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, UserConfirmationDialogPayload::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, UserConfirmationDialogPayload::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, UserConfirmationDialogPayload::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, UserConfirmationDialogPayload::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  UserConfirmationDialogRequest {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<UserConfirmationDialogRequest, T>::value>;
  using DataView = UserConfirmationDialogRequestDataView;
  using Data_ = internal::UserConfirmationDialogRequest_Data;

  template <typename... Args>
  static UserConfirmationDialogRequestPtr New(Args&&... args) {
    return UserConfirmationDialogRequestPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static UserConfirmationDialogRequestPtr From(const U& u) {
    return mojo::TypeConverter<UserConfirmationDialogRequestPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, UserConfirmationDialogRequest>::Convert(*this);
  }


  UserConfirmationDialogRequest();

  explicit UserConfirmationDialogRequest(
      UserConfirmationDialogPayloadPtr payload);

UserConfirmationDialogRequest(const UserConfirmationDialogRequest&) = delete;
UserConfirmationDialogRequest& operator=(const UserConfirmationDialogRequest&) = delete;

  ~UserConfirmationDialogRequest();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = UserConfirmationDialogRequestPtr>
  UserConfirmationDialogRequestPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, UserConfirmationDialogRequest::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, UserConfirmationDialogRequest::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, UserConfirmationDialogRequest::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UserConfirmationDialogRequest::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UserConfirmationDialogRequest::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        UserConfirmationDialogRequest::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::UserConfirmationDialogRequest_UnserializedMessageContext<
            UserType, UserConfirmationDialogRequest::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<UserConfirmationDialogRequest::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return UserConfirmationDialogRequest::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::UserConfirmationDialogRequest_UnserializedMessageContext<
            UserType, UserConfirmationDialogRequest::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<UserConfirmationDialogRequest::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  UserConfirmationDialogPayloadPtr payload;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, UserConfirmationDialogRequest::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, UserConfirmationDialogRequest::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, UserConfirmationDialogRequest::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, UserConfirmationDialogRequest::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  UserConfirmationDialogResponse {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<UserConfirmationDialogResponse, T>::value>;
  using DataView = UserConfirmationDialogResponseDataView;
  using Data_ = internal::UserConfirmationDialogResponse_Data;

  template <typename... Args>
  static UserConfirmationDialogResponsePtr New(Args&&... args) {
    return UserConfirmationDialogResponsePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static UserConfirmationDialogResponsePtr From(const U& u) {
    return mojo::TypeConverter<UserConfirmationDialogResponsePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, UserConfirmationDialogResponse>::Convert(*this);
  }


  UserConfirmationDialogResponse();

  explicit UserConfirmationDialogResponse(
      ConfirmationRequestResultPtr result);

UserConfirmationDialogResponse(const UserConfirmationDialogResponse&) = delete;
UserConfirmationDialogResponse& operator=(const UserConfirmationDialogResponse&) = delete;

  ~UserConfirmationDialogResponse();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = UserConfirmationDialogResponsePtr>
  UserConfirmationDialogResponsePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, UserConfirmationDialogResponse::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, UserConfirmationDialogResponse::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, UserConfirmationDialogResponse::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UserConfirmationDialogResponse::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UserConfirmationDialogResponse::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        UserConfirmationDialogResponse::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::UserConfirmationDialogResponse_UnserializedMessageContext<
            UserType, UserConfirmationDialogResponse::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<UserConfirmationDialogResponse::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return UserConfirmationDialogResponse::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::UserConfirmationDialogResponse_UnserializedMessageContext<
            UserType, UserConfirmationDialogResponse::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<UserConfirmationDialogResponse::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ConfirmationRequestResultPtr result;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, UserConfirmationDialogResponse::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, UserConfirmationDialogResponse::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, UserConfirmationDialogResponse::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, UserConfirmationDialogResponse::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  NavigationConfirmationRequest {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<NavigationConfirmationRequest, T>::value>;
  using DataView = NavigationConfirmationRequestDataView;
  using Data_ = internal::NavigationConfirmationRequest_Data;

  template <typename... Args>
  static NavigationConfirmationRequestPtr New(Args&&... args) {
    return NavigationConfirmationRequestPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static NavigationConfirmationRequestPtr From(const U& u) {
    return mojo::TypeConverter<NavigationConfirmationRequestPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, NavigationConfirmationRequest>::Convert(*this);
  }


  NavigationConfirmationRequest();

  NavigationConfirmationRequest(
      int32_t task_id,
      const ::url::Origin& navigation_origin);


  ~NavigationConfirmationRequest();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = NavigationConfirmationRequestPtr>
  NavigationConfirmationRequestPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, NavigationConfirmationRequest::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, NavigationConfirmationRequest::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, NavigationConfirmationRequest::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NavigationConfirmationRequest::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NavigationConfirmationRequest::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        NavigationConfirmationRequest::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::NavigationConfirmationRequest_UnserializedMessageContext<
            UserType, NavigationConfirmationRequest::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<NavigationConfirmationRequest::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return NavigationConfirmationRequest::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::NavigationConfirmationRequest_UnserializedMessageContext<
            UserType, NavigationConfirmationRequest::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<NavigationConfirmationRequest::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t task_id;
  
  ::url::Origin navigation_origin;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, NavigationConfirmationRequest::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, NavigationConfirmationRequest::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, NavigationConfirmationRequest::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, NavigationConfirmationRequest::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  NavigationConfirmationResponse {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<NavigationConfirmationResponse, T>::value>;
  using DataView = NavigationConfirmationResponseDataView;
  using Data_ = internal::NavigationConfirmationResponse_Data;

  template <typename... Args>
  static NavigationConfirmationResponsePtr New(Args&&... args) {
    return NavigationConfirmationResponsePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static NavigationConfirmationResponsePtr From(const U& u) {
    return mojo::TypeConverter<NavigationConfirmationResponsePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, NavigationConfirmationResponse>::Convert(*this);
  }


  NavigationConfirmationResponse();

  explicit NavigationConfirmationResponse(
      ConfirmationRequestResultPtr result);

NavigationConfirmationResponse(const NavigationConfirmationResponse&) = delete;
NavigationConfirmationResponse& operator=(const NavigationConfirmationResponse&) = delete;

  ~NavigationConfirmationResponse();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = NavigationConfirmationResponsePtr>
  NavigationConfirmationResponsePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, NavigationConfirmationResponse::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, NavigationConfirmationResponse::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, NavigationConfirmationResponse::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NavigationConfirmationResponse::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NavigationConfirmationResponse::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        NavigationConfirmationResponse::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::NavigationConfirmationResponse_UnserializedMessageContext<
            UserType, NavigationConfirmationResponse::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<NavigationConfirmationResponse::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return NavigationConfirmationResponse::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::NavigationConfirmationResponse_UnserializedMessageContext<
            UserType, NavigationConfirmationResponse::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<NavigationConfirmationResponse::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ConfirmationRequestResultPtr result;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, NavigationConfirmationResponse::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, NavigationConfirmationResponse::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, NavigationConfirmationResponse::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, NavigationConfirmationResponse::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
SelectAutofillSuggestionsDialogResultPtr SelectAutofillSuggestionsDialogResult::Clone() const {
  switch (tag_) {
    case Tag::kErrorReason:
      return NewErrorReason(
          mojo::Clone(data_.error_reason));
    case Tag::kSelectedSuggestions:
      return NewSelectedSuggestions(
          mojo::Clone(data_.selected_suggestions));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, SelectAutofillSuggestionsDialogResult>::value>::type*>
bool SelectAutofillSuggestionsDialogResult::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kErrorReason:
      return mojo::Equals(data_.error_reason, other.data_.error_reason);
    case Tag::kSelectedSuggestions:
      return mojo::Equals(data_.selected_suggestions, other.data_.selected_suggestions);
  }

  return false;
}
template <typename UnionPtrType>
UserConfirmationDialogResultPtr UserConfirmationDialogResult::Clone() const {
  switch (tag_) {
    case Tag::kPermissionGranted:
      return NewPermissionGranted(
          mojo::Clone(data_.permission_granted));
    case Tag::kErrorReason:
      return NewErrorReason(
          mojo::Clone(data_.error_reason));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, UserConfirmationDialogResult>::value>::type*>
bool UserConfirmationDialogResult::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kPermissionGranted:
      return mojo::Equals(data_.permission_granted, other.data_.permission_granted);
    case Tag::kErrorReason:
      return mojo::Equals(data_.error_reason, other.data_.error_reason);
  }

  return false;
}
template <typename UnionPtrType>
ConfirmationRequestResultPtr ConfirmationRequestResult::Clone() const {
  switch (tag_) {
    case Tag::kPermissionGranted:
      return NewPermissionGranted(
          mojo::Clone(data_.permission_granted));
    case Tag::kErrorReason:
      return NewErrorReason(
          mojo::Clone(data_.error_reason));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, ConfirmationRequestResult>::value>::type*>
bool ConfirmationRequestResult::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kPermissionGranted:
      return mojo::Equals(data_.permission_granted, other.data_.permission_granted);
    case Tag::kErrorReason:
      return mojo::Equals(data_.error_reason, other.data_.error_reason);
  }

  return false;
}
template <typename StructPtrType>
TaskOptionsPtr TaskOptions::Clone() const {
  return New(
      mojo::Clone(title)
  );
}

template <typename T, TaskOptions::EnableIfSame<T>*>
bool TaskOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  return true;
}

template <typename T, TaskOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  return false;
}
template <typename StructPtrType>
CredentialPtr Credential::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(username),
      mojo::Clone(source_site_or_app),
      mojo::Clone(request_origin)
  );
}

template <typename T, Credential::EnableIfSame<T>*>
bool Credential::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->username, other_struct.username))
    return false;
  if (!mojo::Equals(this->source_site_or_app, other_struct.source_site_or_app))
    return false;
  if (!mojo::Equals(this->request_origin, other_struct.request_origin))
    return false;
  return true;
}

template <typename T, Credential::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.username < rhs.username)
    return true;
  if (rhs.username < lhs.username)
    return false;
  if (lhs.source_site_or_app < rhs.source_site_or_app)
    return true;
  if (rhs.source_site_or_app < lhs.source_site_or_app)
    return false;
  if (lhs.request_origin < rhs.request_origin)
    return true;
  if (rhs.request_origin < lhs.request_origin)
    return false;
  return false;
}
template <typename StructPtrType>
SelectCredentialDialogRequestPtr SelectCredentialDialogRequest::Clone() const {
  return New(
      mojo::Clone(task_id),
      mojo::Clone(show_dialog),
      mojo::Clone(credentials),
      mojo::Clone(icons)
  );
}

template <typename T, SelectCredentialDialogRequest::EnableIfSame<T>*>
bool SelectCredentialDialogRequest::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->task_id, other_struct.task_id))
    return false;
  if (!mojo::Equals(this->show_dialog, other_struct.show_dialog))
    return false;
  if (!mojo::Equals(this->credentials, other_struct.credentials))
    return false;
  if (!mojo::Equals(this->icons, other_struct.icons))
    return false;
  return true;
}

template <typename T, SelectCredentialDialogRequest::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.task_id < rhs.task_id)
    return true;
  if (rhs.task_id < lhs.task_id)
    return false;
  if (lhs.show_dialog < rhs.show_dialog)
    return true;
  if (rhs.show_dialog < lhs.show_dialog)
    return false;
  if (lhs.credentials < rhs.credentials)
    return true;
  if (rhs.credentials < lhs.credentials)
    return false;
  if (lhs.icons < rhs.icons)
    return true;
  if (rhs.icons < lhs.icons)
    return false;
  return false;
}
template <typename StructPtrType>
SelectCredentialDialogResponsePtr SelectCredentialDialogResponse::Clone() const {
  return New(
      mojo::Clone(task_id),
      mojo::Clone(error_reason),
      mojo::Clone(permission_duration),
      mojo::Clone(selected_credential_id)
  );
}

template <typename T, SelectCredentialDialogResponse::EnableIfSame<T>*>
bool SelectCredentialDialogResponse::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->task_id, other_struct.task_id))
    return false;
  if (!mojo::Equals(this->error_reason, other_struct.error_reason))
    return false;
  if (!mojo::Equals(this->permission_duration, other_struct.permission_duration))
    return false;
  if (!mojo::Equals(this->selected_credential_id, other_struct.selected_credential_id))
    return false;
  return true;
}

template <typename T, SelectCredentialDialogResponse::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.task_id < rhs.task_id)
    return true;
  if (rhs.task_id < lhs.task_id)
    return false;
  if (lhs.error_reason < rhs.error_reason)
    return true;
  if (rhs.error_reason < lhs.error_reason)
    return false;
  if (lhs.permission_duration < rhs.permission_duration)
    return true;
  if (rhs.permission_duration < lhs.permission_duration)
    return false;
  if (lhs.selected_credential_id < rhs.selected_credential_id)
    return true;
  if (rhs.selected_credential_id < lhs.selected_credential_id)
    return false;
  return false;
}
template <typename StructPtrType>
AutofillSuggestionPtr AutofillSuggestion::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(title),
      mojo::Clone(details),
      mojo::Clone(icon)
  );
}

template <typename T, AutofillSuggestion::EnableIfSame<T>*>
bool AutofillSuggestion::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->details, other_struct.details))
    return false;
  if (!mojo::Equals(this->icon, other_struct.icon))
    return false;
  return true;
}

template <typename T, AutofillSuggestion::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  if (lhs.details < rhs.details)
    return true;
  if (rhs.details < lhs.details)
    return false;
  if (lhs.icon < rhs.icon)
    return true;
  if (rhs.icon < lhs.icon)
    return false;
  return false;
}
template <typename StructPtrType>
FormFillingRequestPtr FormFillingRequest::Clone() const {
  return New(
      mojo::Clone(requested_data),
      mojo::Clone(suggestions)
  );
}

template <typename T, FormFillingRequest::EnableIfSame<T>*>
bool FormFillingRequest::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->requested_data, other_struct.requested_data))
    return false;
  if (!mojo::Equals(this->suggestions, other_struct.suggestions))
    return false;
  return true;
}

template <typename T, FormFillingRequest::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.requested_data < rhs.requested_data)
    return true;
  if (rhs.requested_data < lhs.requested_data)
    return false;
  if (lhs.suggestions < rhs.suggestions)
    return true;
  if (rhs.suggestions < lhs.suggestions)
    return false;
  return false;
}
template <typename StructPtrType>
SelectAutofillSuggestionsDialogRequestPtr SelectAutofillSuggestionsDialogRequest::Clone() const {
  return New(
      mojo::Clone(task_id),
      mojo::Clone(form_filling_requests)
  );
}

template <typename T, SelectAutofillSuggestionsDialogRequest::EnableIfSame<T>*>
bool SelectAutofillSuggestionsDialogRequest::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->task_id, other_struct.task_id))
    return false;
  if (!mojo::Equals(this->form_filling_requests, other_struct.form_filling_requests))
    return false;
  return true;
}

template <typename T, SelectAutofillSuggestionsDialogRequest::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.task_id < rhs.task_id)
    return true;
  if (rhs.task_id < lhs.task_id)
    return false;
  if (lhs.form_filling_requests < rhs.form_filling_requests)
    return true;
  if (rhs.form_filling_requests < lhs.form_filling_requests)
    return false;
  return false;
}
template <typename StructPtrType>
FormFillingResponsePtr FormFillingResponse::Clone() const {
  return New(
      mojo::Clone(selected_suggestion_id)
  );
}

template <typename T, FormFillingResponse::EnableIfSame<T>*>
bool FormFillingResponse::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->selected_suggestion_id, other_struct.selected_suggestion_id))
    return false;
  return true;
}

template <typename T, FormFillingResponse::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.selected_suggestion_id < rhs.selected_suggestion_id)
    return true;
  if (rhs.selected_suggestion_id < lhs.selected_suggestion_id)
    return false;
  return false;
}
template <typename StructPtrType>
SelectAutofillSuggestionsDialogResponsePtr SelectAutofillSuggestionsDialogResponse::Clone() const {
  return New(
      mojo::Clone(task_id),
      mojo::Clone(result)
  );
}

template <typename T, SelectAutofillSuggestionsDialogResponse::EnableIfSame<T>*>
bool SelectAutofillSuggestionsDialogResponse::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->task_id, other_struct.task_id))
    return false;
  if (!mojo::Equals(this->result, other_struct.result))
    return false;
  return true;
}

template <typename T, SelectAutofillSuggestionsDialogResponse::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.task_id < rhs.task_id)
    return true;
  if (rhs.task_id < lhs.task_id)
    return false;
  if (lhs.result < rhs.result)
    return true;
  if (rhs.result < lhs.result)
    return false;
  return false;
}
template <typename StructPtrType>
UserConfirmationDialogPayloadPtr UserConfirmationDialogPayload::Clone() const {
  return New(
      mojo::Clone(navigation_origin),
      mojo::Clone(for_blocklisted_origin)
  );
}

template <typename T, UserConfirmationDialogPayload::EnableIfSame<T>*>
bool UserConfirmationDialogPayload::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->navigation_origin, other_struct.navigation_origin))
    return false;
  if (!mojo::Equals(this->for_blocklisted_origin, other_struct.for_blocklisted_origin))
    return false;
  return true;
}

template <typename T, UserConfirmationDialogPayload::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.navigation_origin < rhs.navigation_origin)
    return true;
  if (rhs.navigation_origin < lhs.navigation_origin)
    return false;
  if (lhs.for_blocklisted_origin < rhs.for_blocklisted_origin)
    return true;
  if (rhs.for_blocklisted_origin < lhs.for_blocklisted_origin)
    return false;
  return false;
}
template <typename StructPtrType>
UserConfirmationDialogRequestPtr UserConfirmationDialogRequest::Clone() const {
  return New(
      mojo::Clone(payload)
  );
}

template <typename T, UserConfirmationDialogRequest::EnableIfSame<T>*>
bool UserConfirmationDialogRequest::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->payload, other_struct.payload))
    return false;
  return true;
}

template <typename T, UserConfirmationDialogRequest::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.payload < rhs.payload)
    return true;
  if (rhs.payload < lhs.payload)
    return false;
  return false;
}
template <typename StructPtrType>
UserConfirmationDialogResponsePtr UserConfirmationDialogResponse::Clone() const {
  return New(
      mojo::Clone(result)
  );
}

template <typename T, UserConfirmationDialogResponse::EnableIfSame<T>*>
bool UserConfirmationDialogResponse::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->result, other_struct.result))
    return false;
  return true;
}

template <typename T, UserConfirmationDialogResponse::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.result < rhs.result)
    return true;
  if (rhs.result < lhs.result)
    return false;
  return false;
}
template <typename StructPtrType>
NavigationConfirmationRequestPtr NavigationConfirmationRequest::Clone() const {
  return New(
      mojo::Clone(task_id),
      mojo::Clone(navigation_origin)
  );
}

template <typename T, NavigationConfirmationRequest::EnableIfSame<T>*>
bool NavigationConfirmationRequest::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->task_id, other_struct.task_id))
    return false;
  if (!mojo::Equals(this->navigation_origin, other_struct.navigation_origin))
    return false;
  return true;
}

template <typename T, NavigationConfirmationRequest::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.task_id < rhs.task_id)
    return true;
  if (rhs.task_id < lhs.task_id)
    return false;
  if (lhs.navigation_origin < rhs.navigation_origin)
    return true;
  if (rhs.navigation_origin < lhs.navigation_origin)
    return false;
  return false;
}
template <typename StructPtrType>
NavigationConfirmationResponsePtr NavigationConfirmationResponse::Clone() const {
  return New(
      mojo::Clone(result)
  );
}

template <typename T, NavigationConfirmationResponse::EnableIfSame<T>*>
bool NavigationConfirmationResponse::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->result, other_struct.result))
    return false;
  return true;
}

template <typename T, NavigationConfirmationResponse::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.result < rhs.result)
    return true;
  if (rhs.result < lhs.result)
    return false;
  return false;
}


}  // actor::webui::mojom

namespace mojo {


template <>
struct  StructTraits<::actor::webui::mojom::TaskOptions::DataView,
                                         ::actor::webui::mojom::TaskOptionsPtr> {
  static bool IsNull(const ::actor::webui::mojom::TaskOptionsPtr& input) { return !input; }
  static void SetToNull(::actor::webui::mojom::TaskOptionsPtr* output) { output->reset(); }

  static const decltype(::actor::webui::mojom::TaskOptions::title)& title(
      const ::actor::webui::mojom::TaskOptionsPtr& input) {
    return input->title;
  }

  static bool Read(::actor::webui::mojom::TaskOptions::DataView input, ::actor::webui::mojom::TaskOptionsPtr* output);
};


template <>
struct  StructTraits<::actor::webui::mojom::Credential::DataView,
                                         ::actor::webui::mojom::CredentialPtr> {
  static bool IsNull(const ::actor::webui::mojom::CredentialPtr& input) { return !input; }
  static void SetToNull(::actor::webui::mojom::CredentialPtr* output) { output->reset(); }

  static decltype(::actor::webui::mojom::Credential::id) id(
      const ::actor::webui::mojom::CredentialPtr& input) {
    return input->id;
  }

  static const decltype(::actor::webui::mojom::Credential::username)& username(
      const ::actor::webui::mojom::CredentialPtr& input) {
    return input->username;
  }

  static const decltype(::actor::webui::mojom::Credential::source_site_or_app)& source_site_or_app(
      const ::actor::webui::mojom::CredentialPtr& input) {
    return input->source_site_or_app;
  }

  static const decltype(::actor::webui::mojom::Credential::request_origin)& request_origin(
      const ::actor::webui::mojom::CredentialPtr& input) {
    return input->request_origin;
  }

  static bool Read(::actor::webui::mojom::Credential::DataView input, ::actor::webui::mojom::CredentialPtr* output);
};


template <>
struct  StructTraits<::actor::webui::mojom::SelectCredentialDialogRequest::DataView,
                                         ::actor::webui::mojom::SelectCredentialDialogRequestPtr> {
  static bool IsNull(const ::actor::webui::mojom::SelectCredentialDialogRequestPtr& input) { return !input; }
  static void SetToNull(::actor::webui::mojom::SelectCredentialDialogRequestPtr* output) { output->reset(); }

  static decltype(::actor::webui::mojom::SelectCredentialDialogRequest::task_id) task_id(
      const ::actor::webui::mojom::SelectCredentialDialogRequestPtr& input) {
    return input->task_id;
  }

  static decltype(::actor::webui::mojom::SelectCredentialDialogRequest::show_dialog) show_dialog(
      const ::actor::webui::mojom::SelectCredentialDialogRequestPtr& input) {
    return input->show_dialog;
  }

  static const decltype(::actor::webui::mojom::SelectCredentialDialogRequest::credentials)& credentials(
      const ::actor::webui::mojom::SelectCredentialDialogRequestPtr& input) {
    return input->credentials;
  }

  static  decltype(::actor::webui::mojom::SelectCredentialDialogRequest::icons)& icons(
       ::actor::webui::mojom::SelectCredentialDialogRequestPtr& input) {
    return input->icons;
  }

  static bool Read(::actor::webui::mojom::SelectCredentialDialogRequest::DataView input, ::actor::webui::mojom::SelectCredentialDialogRequestPtr* output);
};


template <>
struct  StructTraits<::actor::webui::mojom::SelectCredentialDialogResponse::DataView,
                                         ::actor::webui::mojom::SelectCredentialDialogResponsePtr> {
  static bool IsNull(const ::actor::webui::mojom::SelectCredentialDialogResponsePtr& input) { return !input; }
  static void SetToNull(::actor::webui::mojom::SelectCredentialDialogResponsePtr* output) { output->reset(); }

  static decltype(::actor::webui::mojom::SelectCredentialDialogResponse::task_id) task_id(
      const ::actor::webui::mojom::SelectCredentialDialogResponsePtr& input) {
    return input->task_id;
  }

  static decltype(::actor::webui::mojom::SelectCredentialDialogResponse::error_reason) error_reason(
      const ::actor::webui::mojom::SelectCredentialDialogResponsePtr& input) {
    return input->error_reason;
  }

  static decltype(::actor::webui::mojom::SelectCredentialDialogResponse::permission_duration) permission_duration(
      const ::actor::webui::mojom::SelectCredentialDialogResponsePtr& input) {
    return input->permission_duration;
  }

  static decltype(::actor::webui::mojom::SelectCredentialDialogResponse::selected_credential_id) selected_credential_id(
      const ::actor::webui::mojom::SelectCredentialDialogResponsePtr& input) {
    return input->selected_credential_id;
  }

  static bool Read(::actor::webui::mojom::SelectCredentialDialogResponse::DataView input, ::actor::webui::mojom::SelectCredentialDialogResponsePtr* output);
};


template <>
struct  StructTraits<::actor::webui::mojom::AutofillSuggestion::DataView,
                                         ::actor::webui::mojom::AutofillSuggestionPtr> {
  static bool IsNull(const ::actor::webui::mojom::AutofillSuggestionPtr& input) { return !input; }
  static void SetToNull(::actor::webui::mojom::AutofillSuggestionPtr* output) { output->reset(); }

  static const decltype(::actor::webui::mojom::AutofillSuggestion::id)& id(
      const ::actor::webui::mojom::AutofillSuggestionPtr& input) {
    return input->id;
  }

  static const decltype(::actor::webui::mojom::AutofillSuggestion::title)& title(
      const ::actor::webui::mojom::AutofillSuggestionPtr& input) {
    return input->title;
  }

  static const decltype(::actor::webui::mojom::AutofillSuggestion::details)& details(
      const ::actor::webui::mojom::AutofillSuggestionPtr& input) {
    return input->details;
  }

  static  decltype(::actor::webui::mojom::AutofillSuggestion::icon)& icon(
       ::actor::webui::mojom::AutofillSuggestionPtr& input) {
    return input->icon;
  }

  static bool Read(::actor::webui::mojom::AutofillSuggestion::DataView input, ::actor::webui::mojom::AutofillSuggestionPtr* output);
};


template <>
struct  StructTraits<::actor::webui::mojom::FormFillingRequest::DataView,
                                         ::actor::webui::mojom::FormFillingRequestPtr> {
  static bool IsNull(const ::actor::webui::mojom::FormFillingRequestPtr& input) { return !input; }
  static void SetToNull(::actor::webui::mojom::FormFillingRequestPtr* output) { output->reset(); }

  static decltype(::actor::webui::mojom::FormFillingRequest::requested_data) requested_data(
      const ::actor::webui::mojom::FormFillingRequestPtr& input) {
    return input->requested_data;
  }

  static  decltype(::actor::webui::mojom::FormFillingRequest::suggestions)& suggestions(
       ::actor::webui::mojom::FormFillingRequestPtr& input) {
    return input->suggestions;
  }

  static bool Read(::actor::webui::mojom::FormFillingRequest::DataView input, ::actor::webui::mojom::FormFillingRequestPtr* output);
};


template <>
struct  StructTraits<::actor::webui::mojom::SelectAutofillSuggestionsDialogRequest::DataView,
                                         ::actor::webui::mojom::SelectAutofillSuggestionsDialogRequestPtr> {
  static bool IsNull(const ::actor::webui::mojom::SelectAutofillSuggestionsDialogRequestPtr& input) { return !input; }
  static void SetToNull(::actor::webui::mojom::SelectAutofillSuggestionsDialogRequestPtr* output) { output->reset(); }

  static decltype(::actor::webui::mojom::SelectAutofillSuggestionsDialogRequest::task_id) task_id(
      const ::actor::webui::mojom::SelectAutofillSuggestionsDialogRequestPtr& input) {
    return input->task_id;
  }

  static  decltype(::actor::webui::mojom::SelectAutofillSuggestionsDialogRequest::form_filling_requests)& form_filling_requests(
       ::actor::webui::mojom::SelectAutofillSuggestionsDialogRequestPtr& input) {
    return input->form_filling_requests;
  }

  static bool Read(::actor::webui::mojom::SelectAutofillSuggestionsDialogRequest::DataView input, ::actor::webui::mojom::SelectAutofillSuggestionsDialogRequestPtr* output);
};


template <>
struct  StructTraits<::actor::webui::mojom::FormFillingResponse::DataView,
                                         ::actor::webui::mojom::FormFillingResponsePtr> {
  static bool IsNull(const ::actor::webui::mojom::FormFillingResponsePtr& input) { return !input; }
  static void SetToNull(::actor::webui::mojom::FormFillingResponsePtr* output) { output->reset(); }

  static const decltype(::actor::webui::mojom::FormFillingResponse::selected_suggestion_id)& selected_suggestion_id(
      const ::actor::webui::mojom::FormFillingResponsePtr& input) {
    return input->selected_suggestion_id;
  }

  static bool Read(::actor::webui::mojom::FormFillingResponse::DataView input, ::actor::webui::mojom::FormFillingResponsePtr* output);
};


template <>
struct  StructTraits<::actor::webui::mojom::SelectAutofillSuggestionsDialogResponse::DataView,
                                         ::actor::webui::mojom::SelectAutofillSuggestionsDialogResponsePtr> {
  static bool IsNull(const ::actor::webui::mojom::SelectAutofillSuggestionsDialogResponsePtr& input) { return !input; }
  static void SetToNull(::actor::webui::mojom::SelectAutofillSuggestionsDialogResponsePtr* output) { output->reset(); }

  static decltype(::actor::webui::mojom::SelectAutofillSuggestionsDialogResponse::task_id) task_id(
      const ::actor::webui::mojom::SelectAutofillSuggestionsDialogResponsePtr& input) {
    return input->task_id;
  }

  static const decltype(::actor::webui::mojom::SelectAutofillSuggestionsDialogResponse::result)& result(
      const ::actor::webui::mojom::SelectAutofillSuggestionsDialogResponsePtr& input) {
    return input->result;
  }

  static bool Read(::actor::webui::mojom::SelectAutofillSuggestionsDialogResponse::DataView input, ::actor::webui::mojom::SelectAutofillSuggestionsDialogResponsePtr* output);
};


template <>
struct  StructTraits<::actor::webui::mojom::UserConfirmationDialogPayload::DataView,
                                         ::actor::webui::mojom::UserConfirmationDialogPayloadPtr> {
  static bool IsNull(const ::actor::webui::mojom::UserConfirmationDialogPayloadPtr& input) { return !input; }
  static void SetToNull(::actor::webui::mojom::UserConfirmationDialogPayloadPtr* output) { output->reset(); }

  static const decltype(::actor::webui::mojom::UserConfirmationDialogPayload::navigation_origin)& navigation_origin(
      const ::actor::webui::mojom::UserConfirmationDialogPayloadPtr& input) {
    return input->navigation_origin;
  }

  static decltype(::actor::webui::mojom::UserConfirmationDialogPayload::for_blocklisted_origin) for_blocklisted_origin(
      const ::actor::webui::mojom::UserConfirmationDialogPayloadPtr& input) {
    return input->for_blocklisted_origin;
  }

  static bool Read(::actor::webui::mojom::UserConfirmationDialogPayload::DataView input, ::actor::webui::mojom::UserConfirmationDialogPayloadPtr* output);
};


template <>
struct  StructTraits<::actor::webui::mojom::UserConfirmationDialogRequest::DataView,
                                         ::actor::webui::mojom::UserConfirmationDialogRequestPtr> {
  static bool IsNull(const ::actor::webui::mojom::UserConfirmationDialogRequestPtr& input) { return !input; }
  static void SetToNull(::actor::webui::mojom::UserConfirmationDialogRequestPtr* output) { output->reset(); }

  static const decltype(::actor::webui::mojom::UserConfirmationDialogRequest::payload)& payload(
      const ::actor::webui::mojom::UserConfirmationDialogRequestPtr& input) {
    return input->payload;
  }

  static bool Read(::actor::webui::mojom::UserConfirmationDialogRequest::DataView input, ::actor::webui::mojom::UserConfirmationDialogRequestPtr* output);
};


template <>
struct  StructTraits<::actor::webui::mojom::UserConfirmationDialogResponse::DataView,
                                         ::actor::webui::mojom::UserConfirmationDialogResponsePtr> {
  static bool IsNull(const ::actor::webui::mojom::UserConfirmationDialogResponsePtr& input) { return !input; }
  static void SetToNull(::actor::webui::mojom::UserConfirmationDialogResponsePtr* output) { output->reset(); }

  static const decltype(::actor::webui::mojom::UserConfirmationDialogResponse::result)& result(
      const ::actor::webui::mojom::UserConfirmationDialogResponsePtr& input) {
    return input->result;
  }

  static bool Read(::actor::webui::mojom::UserConfirmationDialogResponse::DataView input, ::actor::webui::mojom::UserConfirmationDialogResponsePtr* output);
};


template <>
struct  StructTraits<::actor::webui::mojom::NavigationConfirmationRequest::DataView,
                                         ::actor::webui::mojom::NavigationConfirmationRequestPtr> {
  static bool IsNull(const ::actor::webui::mojom::NavigationConfirmationRequestPtr& input) { return !input; }
  static void SetToNull(::actor::webui::mojom::NavigationConfirmationRequestPtr* output) { output->reset(); }

  static decltype(::actor::webui::mojom::NavigationConfirmationRequest::task_id) task_id(
      const ::actor::webui::mojom::NavigationConfirmationRequestPtr& input) {
    return input->task_id;
  }

  static const decltype(::actor::webui::mojom::NavigationConfirmationRequest::navigation_origin)& navigation_origin(
      const ::actor::webui::mojom::NavigationConfirmationRequestPtr& input) {
    return input->navigation_origin;
  }

  static bool Read(::actor::webui::mojom::NavigationConfirmationRequest::DataView input, ::actor::webui::mojom::NavigationConfirmationRequestPtr* output);
};


template <>
struct  StructTraits<::actor::webui::mojom::NavigationConfirmationResponse::DataView,
                                         ::actor::webui::mojom::NavigationConfirmationResponsePtr> {
  static bool IsNull(const ::actor::webui::mojom::NavigationConfirmationResponsePtr& input) { return !input; }
  static void SetToNull(::actor::webui::mojom::NavigationConfirmationResponsePtr* output) { output->reset(); }

  static const decltype(::actor::webui::mojom::NavigationConfirmationResponse::result)& result(
      const ::actor::webui::mojom::NavigationConfirmationResponsePtr& input) {
    return input->result;
  }

  static bool Read(::actor::webui::mojom::NavigationConfirmationResponse::DataView input, ::actor::webui::mojom::NavigationConfirmationResponsePtr* output);
};


template <>
struct  UnionTraits<::actor::webui::mojom::SelectAutofillSuggestionsDialogResult::DataView,
                                        ::actor::webui::mojom::SelectAutofillSuggestionsDialogResultPtr> {
  static bool IsNull(const ::actor::webui::mojom::SelectAutofillSuggestionsDialogResultPtr& input) { return !input; }
  static void SetToNull(::actor::webui::mojom::SelectAutofillSuggestionsDialogResultPtr* output) { output->reset(); }

  static ::actor::webui::mojom::SelectAutofillSuggestionsDialogResult::Tag GetTag(const ::actor::webui::mojom::SelectAutofillSuggestionsDialogResultPtr& input) {
    return input->which();
  }

  static  ::actor::webui::mojom::SelectAutofillSuggestionsDialogErrorReason error_reason(const ::actor::webui::mojom::SelectAutofillSuggestionsDialogResultPtr& input) {
    return input->get_error_reason();
  }

  static const std::vector<::actor::webui::mojom::FormFillingResponsePtr>& selected_suggestions(const ::actor::webui::mojom::SelectAutofillSuggestionsDialogResultPtr& input) {
    return input->get_selected_suggestions();
  }

  static bool Read(::actor::webui::mojom::SelectAutofillSuggestionsDialogResult::DataView input, ::actor::webui::mojom::SelectAutofillSuggestionsDialogResultPtr* output);
};


template <>
struct  UnionTraits<::actor::webui::mojom::UserConfirmationDialogResult::DataView,
                                        ::actor::webui::mojom::UserConfirmationDialogResultPtr> {
  static bool IsNull(const ::actor::webui::mojom::UserConfirmationDialogResultPtr& input) { return !input; }
  static void SetToNull(::actor::webui::mojom::UserConfirmationDialogResultPtr* output) { output->reset(); }

  static ::actor::webui::mojom::UserConfirmationDialogResult::Tag GetTag(const ::actor::webui::mojom::UserConfirmationDialogResultPtr& input) {
    return input->which();
  }

  static  bool permission_granted(const ::actor::webui::mojom::UserConfirmationDialogResultPtr& input) {
    return input->get_permission_granted();
  }

  static  ::actor::webui::mojom::ConfirmationRequestErrorReason error_reason(const ::actor::webui::mojom::UserConfirmationDialogResultPtr& input) {
    return input->get_error_reason();
  }

  static bool Read(::actor::webui::mojom::UserConfirmationDialogResult::DataView input, ::actor::webui::mojom::UserConfirmationDialogResultPtr* output);
};


template <>
struct  UnionTraits<::actor::webui::mojom::ConfirmationRequestResult::DataView,
                                        ::actor::webui::mojom::ConfirmationRequestResultPtr> {
  static bool IsNull(const ::actor::webui::mojom::ConfirmationRequestResultPtr& input) { return !input; }
  static void SetToNull(::actor::webui::mojom::ConfirmationRequestResultPtr* output) { output->reset(); }

  static ::actor::webui::mojom::ConfirmationRequestResult::Tag GetTag(const ::actor::webui::mojom::ConfirmationRequestResultPtr& input) {
    return input->which();
  }

  static  bool permission_granted(const ::actor::webui::mojom::ConfirmationRequestResultPtr& input) {
    return input->get_permission_granted();
  }

  static  ::actor::webui::mojom::ConfirmationRequestErrorReason error_reason(const ::actor::webui::mojom::ConfirmationRequestResultPtr& input) {
    return input->get_error_reason();
  }

  static bool Read(::actor::webui::mojom::ConfirmationRequestResult::DataView input, ::actor::webui::mojom::ConfirmationRequestResultPtr* output);
};

}  // namespace mojo

#endif  // CHROME_COMMON_ACTOR_WEBUI_MOJOM_H_