// chrome/common/actor.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/common/actor.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/common/actor.mojom-params-data.h"
#include "chrome/common/actor.mojom-shared-message-ids.h"

#include "chrome/common/actor.mojom-import-headers.h"
#include "chrome/common/actor.mojom-test-utils.h"


namespace actor::mojom {
ObservedToolTarget::ObservedToolTarget()
    : node_attribute() {}

ObservedToolTarget::ObservedToolTarget(
    ::blink::mojom::AIPageContentAttributesPtr node_attribute_in)
    : node_attribute(std::move(node_attribute_in)) {}

ObservedToolTarget::~ObservedToolTarget() = default;

void ObservedToolTarget::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "node_attribute"), this->node_attribute,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::AIPageContentAttributesPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ObservedToolTarget::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ClickAction::ClickAction()
    : type(),
      count() {}

ClickAction::ClickAction(
    ClickAction::Type type_in,
    ClickAction::Count count_in)
    : type(std::move(type_in)),
      count(std::move(count_in)) {}

ClickAction::~ClickAction() = default;
size_t ClickAction::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->type);
  seed = mojo::internal::Hash(seed, this->count);
  return seed;
}

void ClickAction::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ClickAction::Type>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "count"), this->count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ClickAction::Count>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ClickAction::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
MouseMoveAction::MouseMoveAction() {}

MouseMoveAction::~MouseMoveAction() = default;
size_t MouseMoveAction::Hash(size_t seed) const {
  return seed;
}

void MouseMoveAction::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
}

bool MouseMoveAction::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ScrollToAction::ScrollToAction() {}

ScrollToAction::~ScrollToAction() = default;
size_t ScrollToAction::Hash(size_t seed) const {
  return seed;
}

void ScrollToAction::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
}

bool ScrollToAction::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TypeAction::TypeAction()
    : mode(),
      text(),
      follow_by_enter() {}

TypeAction::TypeAction(
    TypeAction::Mode mode_in,
    const std::string& text_in,
    bool follow_by_enter_in)
    : mode(std::move(mode_in)),
      text(std::move(text_in)),
      follow_by_enter(std::move(follow_by_enter_in)) {}

TypeAction::~TypeAction() = default;
size_t TypeAction::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->mode);
  seed = mojo::internal::Hash(seed, this->text);
  seed = mojo::internal::Hash(seed, this->follow_by_enter);
  return seed;
}

void TypeAction::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mode"), this->mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type TypeAction::Mode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "text"), this->text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "follow_by_enter"), this->follow_by_enter,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TypeAction::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ScrollAction::ScrollAction()
    : direction(),
      distance() {}

ScrollAction::ScrollAction(
    ScrollAction::ScrollDirection direction_in,
    float distance_in)
    : direction(std::move(direction_in)),
      distance(std::move(distance_in)) {}

ScrollAction::~ScrollAction() = default;
size_t ScrollAction::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->direction);
  seed = mojo::internal::Hash(seed, this->distance);
  return seed;
}

void ScrollAction::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "direction"), this->direction,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ScrollAction::ScrollDirection>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "distance"), this->distance,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ScrollAction::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SelectAction::SelectAction()
    : value() {}

SelectAction::SelectAction(
    const std::string& value_in)
    : value(std::move(value_in)) {}

SelectAction::~SelectAction() = default;
size_t SelectAction::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->value);
  return seed;
}

void SelectAction::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SelectAction::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DragAndReleaseAction::DragAndReleaseAction()
    : to_target() {}

DragAndReleaseAction::DragAndReleaseAction(
    ToolTargetPtr to_target_in)
    : to_target(std::move(to_target_in)) {}

DragAndReleaseAction::~DragAndReleaseAction() = default;

void DragAndReleaseAction::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "to_target"), this->to_target,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ToolTargetPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DragAndReleaseAction::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ScriptToolAction::ScriptToolAction()
    : name(),
      input_arguments() {}

ScriptToolAction::ScriptToolAction(
    const std::string& name_in,
    const std::string& input_arguments_in)
    : name(std::move(name_in)),
      input_arguments(std::move(input_arguments_in)) {}

ScriptToolAction::~ScriptToolAction() = default;
size_t ScriptToolAction::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->name);
  seed = mojo::internal::Hash(seed, this->input_arguments);
  return seed;
}

void ScriptToolAction::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_arguments"), this->input_arguments,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ScriptToolAction::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TaskId::TaskId()
    : id() {}

TaskId::TaskId(
    int32_t id_in)
    : id(std::move(id_in)) {}

TaskId::~TaskId() = default;

void TaskId::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TaskId::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ToolInvocation::ToolInvocation()
    : task_id(),
      action(),
      target(),
      observed_target() {}

ToolInvocation::ToolInvocation(
    const ::actor::TaskId& task_id_in,
    ToolActionPtr action_in,
    ToolTargetPtr target_in,
    ObservedToolTargetPtr observed_target_in)
    : task_id(std::move(task_id_in)),
      action(std::move(action_in)),
      target(std::move(target_in)),
      observed_target(std::move(observed_target_in)) {}

ToolInvocation::~ToolInvocation() = default;

void ToolInvocation::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "task_id"), this->task_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::actor::TaskId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "action"), this->action,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ToolActionPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "target"), this->target,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ToolTargetPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "observed_target"), this->observed_target,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ObservedToolTargetPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ToolInvocation::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ActionResult::ActionResult()
    : code(),
      requires_page_stabilization(),
      message(),
      script_tool_response(),
      execution_end_time() {}

ActionResult::ActionResult(
    ActionResultCode code_in,
    bool requires_page_stabilization_in,
    const std::string& message_in,
    const std::optional<std::string>& script_tool_response_in,
    std::optional<::base::TimeTicks> execution_end_time_in)
    : code(std::move(code_in)),
      requires_page_stabilization(std::move(requires_page_stabilization_in)),
      message(std::move(message_in)),
      script_tool_response(std::move(script_tool_response_in)),
      execution_end_time(std::move(execution_end_time_in)) {}

ActionResult::~ActionResult() = default;

void ActionResult::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "code"), this->code,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ActionResultCode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "requires_page_stabilization"), this->requires_page_stabilization,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "message"), this->message,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "script_tool_response"), this->script_tool_response,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "execution_end_time"), this->execution_end_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeTicks>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ActionResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
JournalDetails::JournalDetails()
    : key(),
      value() {}

JournalDetails::JournalDetails(
    const std::string& key_in,
    const std::string& value_in)
    : key(std::move(key_in)),
      value(std::move(value_in)) {}

JournalDetails::~JournalDetails() = default;
size_t JournalDetails::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->key);
  seed = mojo::internal::Hash(seed, this->value);
  return seed;
}

void JournalDetails::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "key"), this->key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool JournalDetails::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
JournalEntry::JournalEntry()
    : type(),
      task_id(),
      timestamp(),
      event(),
      track_uuid(),
      details() {}

JournalEntry::JournalEntry(
    JournalEntryType type_in,
    const ::actor::TaskId& task_id_in,
    ::base::Time timestamp_in,
    const std::string& event_in,
    uint64_t track_uuid_in,
    std::vector<JournalDetailsPtr> details_in)
    : type(std::move(type_in)),
      task_id(std::move(task_id_in)),
      timestamp(std::move(timestamp_in)),
      event(std::move(event_in)),
      track_uuid(std::move(track_uuid_in)),
      details(std::move(details_in)) {}

JournalEntry::~JournalEntry() = default;

void JournalEntry::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type JournalEntryType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "task_id"), this->task_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::actor::TaskId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "timestamp"), this->timestamp,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Time>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "event"), this->event,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "track_uuid"), this->track_uuid,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "details"), this->details,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<JournalDetailsPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool JournalEntry::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ToolTargetPtr
ToolTarget::NewDomNodeId(
    int32_t value) {
  return ToolTargetPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kDomNodeId)>,
      std::move(value));
}

ToolTargetPtr
ToolTarget::NewCoordinateDip(
    const ::gfx::Point& value) {
  return ToolTargetPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kCoordinateDip)>,
      std::move(value));
}

ToolTarget::ToolTarget(
    std::in_place_index_t<static_cast<size_t>(Tag::kDomNodeId)>,
    int32_t value)
    : tag_(Tag::kDomNodeId),
      data_(std::in_place_index<static_cast<size_t>(Tag::kDomNodeId)>,
            std::move(value)) {}

ToolTarget::ToolTarget(
    std::in_place_index_t<static_cast<size_t>(Tag::kCoordinateDip)>,
    const ::gfx::Point& value)
    : tag_(Tag::kCoordinateDip),
      data_(std::in_place_index<static_cast<size_t>(Tag::kCoordinateDip)>,
            std::move(value)) {}
ToolTarget::~ToolTarget() {
  DestroyActive();
}

void ToolTarget::set_dom_node_id(int32_t dom_node_id) {
  if (tag_ != Tag::kDomNodeId) {
    DestroyActive();
    tag_ = Tag::kDomNodeId;
  }
  data_.dom_node_id = dom_node_id;
}

void ToolTarget::set_coordinate_dip(const ::gfx::Point& coordinate_dip) {
  if (tag_ == Tag::kCoordinateDip) {
    data_.coordinate_dip = std::move(coordinate_dip);
  } else {
    DestroyActive();
    tag_ = Tag::kCoordinateDip;
    new (&data_.coordinate_dip) ::gfx::Point(
        std::move(coordinate_dip));
  }
}


ToolTarget::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kDomNodeId)>,
    int32_t value)
    : dom_node_id(std::move(value)) {}

ToolTarget::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kCoordinateDip)>,
    const ::gfx::Point& value)
    : coordinate_dip(std::move(value)) {}

void ToolTarget::DestroyActive() {
  switch (tag_) {

    case Tag::kDomNodeId:
      std::destroy_at(&data_.dom_node_id);
      break;
    case Tag::kCoordinateDip:
      std::destroy_at(&data_.coordinate_dip);
      break;
  }
}

bool ToolTarget::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
ToolActionPtr
ToolAction::NewClick(
    ClickActionPtr value) {
  return ToolActionPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kClick)>,
      std::move(value));
}

ToolActionPtr
ToolAction::NewDragAndRelease(
    DragAndReleaseActionPtr value) {
  return ToolActionPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kDragAndRelease)>,
      std::move(value));
}

ToolActionPtr
ToolAction::NewMouseMove(
    MouseMoveActionPtr value) {
  return ToolActionPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kMouseMove)>,
      std::move(value));
}

ToolActionPtr
ToolAction::NewScroll(
    ScrollActionPtr value) {
  return ToolActionPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kScroll)>,
      std::move(value));
}

ToolActionPtr
ToolAction::NewSelect(
    SelectActionPtr value) {
  return ToolActionPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSelect)>,
      std::move(value));
}

ToolActionPtr
ToolAction::NewType(
    TypeActionPtr value) {
  return ToolActionPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kType)>,
      std::move(value));
}

ToolActionPtr
ToolAction::NewScriptTool(
    ScriptToolActionPtr value) {
  return ToolActionPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kScriptTool)>,
      std::move(value));
}

ToolActionPtr
ToolAction::NewScrollTo(
    ScrollToActionPtr value) {
  return ToolActionPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kScrollTo)>,
      std::move(value));
}

ToolAction::ToolAction(
    std::in_place_index_t<static_cast<size_t>(Tag::kClick)>,
    ClickActionPtr value)
    : tag_(Tag::kClick),
      data_(std::in_place_index<static_cast<size_t>(Tag::kClick)>,
            std::move(value)) {}

ToolAction::ToolAction(
    std::in_place_index_t<static_cast<size_t>(Tag::kDragAndRelease)>,
    DragAndReleaseActionPtr value)
    : tag_(Tag::kDragAndRelease),
      data_(std::in_place_index<static_cast<size_t>(Tag::kDragAndRelease)>,
            std::move(value)) {}

ToolAction::ToolAction(
    std::in_place_index_t<static_cast<size_t>(Tag::kMouseMove)>,
    MouseMoveActionPtr value)
    : tag_(Tag::kMouseMove),
      data_(std::in_place_index<static_cast<size_t>(Tag::kMouseMove)>,
            std::move(value)) {}

ToolAction::ToolAction(
    std::in_place_index_t<static_cast<size_t>(Tag::kScroll)>,
    ScrollActionPtr value)
    : tag_(Tag::kScroll),
      data_(std::in_place_index<static_cast<size_t>(Tag::kScroll)>,
            std::move(value)) {}

ToolAction::ToolAction(
    std::in_place_index_t<static_cast<size_t>(Tag::kSelect)>,
    SelectActionPtr value)
    : tag_(Tag::kSelect),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSelect)>,
            std::move(value)) {}

ToolAction::ToolAction(
    std::in_place_index_t<static_cast<size_t>(Tag::kType)>,
    TypeActionPtr value)
    : tag_(Tag::kType),
      data_(std::in_place_index<static_cast<size_t>(Tag::kType)>,
            std::move(value)) {}

ToolAction::ToolAction(
    std::in_place_index_t<static_cast<size_t>(Tag::kScriptTool)>,
    ScriptToolActionPtr value)
    : tag_(Tag::kScriptTool),
      data_(std::in_place_index<static_cast<size_t>(Tag::kScriptTool)>,
            std::move(value)) {}

ToolAction::ToolAction(
    std::in_place_index_t<static_cast<size_t>(Tag::kScrollTo)>,
    ScrollToActionPtr value)
    : tag_(Tag::kScrollTo),
      data_(std::in_place_index<static_cast<size_t>(Tag::kScrollTo)>,
            std::move(value)) {}
ToolAction::~ToolAction() {
  DestroyActive();
}

void ToolAction::set_click(ClickActionPtr click) {
  if (tag_ == Tag::kClick) {
    data_.click = std::move(click);
  } else {
    DestroyActive();
    tag_ = Tag::kClick;
    new (&data_.click) ClickActionPtr(
        std::move(click));
  }
}

void ToolAction::set_drag_and_release(DragAndReleaseActionPtr drag_and_release) {
  if (tag_ == Tag::kDragAndRelease) {
    data_.drag_and_release = std::move(drag_and_release);
  } else {
    DestroyActive();
    tag_ = Tag::kDragAndRelease;
    new (&data_.drag_and_release) DragAndReleaseActionPtr(
        std::move(drag_and_release));
  }
}

void ToolAction::set_mouse_move(MouseMoveActionPtr mouse_move) {
  if (tag_ == Tag::kMouseMove) {
    data_.mouse_move = std::move(mouse_move);
  } else {
    DestroyActive();
    tag_ = Tag::kMouseMove;
    new (&data_.mouse_move) MouseMoveActionPtr(
        std::move(mouse_move));
  }
}

void ToolAction::set_scroll(ScrollActionPtr scroll) {
  if (tag_ == Tag::kScroll) {
    data_.scroll = std::move(scroll);
  } else {
    DestroyActive();
    tag_ = Tag::kScroll;
    new (&data_.scroll) ScrollActionPtr(
        std::move(scroll));
  }
}

void ToolAction::set_select(SelectActionPtr select) {
  if (tag_ == Tag::kSelect) {
    data_.select = std::move(select);
  } else {
    DestroyActive();
    tag_ = Tag::kSelect;
    new (&data_.select) SelectActionPtr(
        std::move(select));
  }
}

void ToolAction::set_type(TypeActionPtr type) {
  if (tag_ == Tag::kType) {
    data_.type = std::move(type);
  } else {
    DestroyActive();
    tag_ = Tag::kType;
    new (&data_.type) TypeActionPtr(
        std::move(type));
  }
}

void ToolAction::set_script_tool(ScriptToolActionPtr script_tool) {
  if (tag_ == Tag::kScriptTool) {
    data_.script_tool = std::move(script_tool);
  } else {
    DestroyActive();
    tag_ = Tag::kScriptTool;
    new (&data_.script_tool) ScriptToolActionPtr(
        std::move(script_tool));
  }
}

void ToolAction::set_scroll_to(ScrollToActionPtr scroll_to) {
  if (tag_ == Tag::kScrollTo) {
    data_.scroll_to = std::move(scroll_to);
  } else {
    DestroyActive();
    tag_ = Tag::kScrollTo;
    new (&data_.scroll_to) ScrollToActionPtr(
        std::move(scroll_to));
  }
}


ToolAction::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kClick)>,
    ClickActionPtr value)
    : click(std::move(value)) {}

ToolAction::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kDragAndRelease)>,
    DragAndReleaseActionPtr value)
    : drag_and_release(std::move(value)) {}

ToolAction::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kMouseMove)>,
    MouseMoveActionPtr value)
    : mouse_move(std::move(value)) {}

ToolAction::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kScroll)>,
    ScrollActionPtr value)
    : scroll(std::move(value)) {}

ToolAction::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSelect)>,
    SelectActionPtr value)
    : select(std::move(value)) {}

ToolAction::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kType)>,
    TypeActionPtr value)
    : type(std::move(value)) {}

ToolAction::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kScriptTool)>,
    ScriptToolActionPtr value)
    : script_tool(std::move(value)) {}

ToolAction::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kScrollTo)>,
    ScrollToActionPtr value)
    : scroll_to(std::move(value)) {}

void ToolAction::DestroyActive() {
  switch (tag_) {

    case Tag::kClick:
      std::destroy_at(&data_.click);
      break;
    case Tag::kDragAndRelease:
      std::destroy_at(&data_.drag_and_release);
      break;
    case Tag::kMouseMove:
      std::destroy_at(&data_.mouse_move);
      break;
    case Tag::kScroll:
      std::destroy_at(&data_.scroll);
      break;
    case Tag::kSelect:
      std::destroy_at(&data_.select);
      break;
    case Tag::kType:
      std::destroy_at(&data_.type);
      break;
    case Tag::kScriptTool:
      std::destroy_at(&data_.script_tool);
      break;
    case Tag::kScrollTo:
      std::destroy_at(&data_.scroll_to);
      break;
  }
}

bool ToolAction::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

JournalClient::IPCStableHashFunction JournalClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::JournalClient>(message.name())) {
    case messages::JournalClient::kAddEntriesToJournal: {
      return &JournalClient::AddEntriesToJournal_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* JournalClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::JournalClient>(message.name())) {
      case messages::JournalClient::kAddEntriesToJournal:
            return "Receive actor::mojom::JournalClient::AddEntriesToJournal";
    }
  } else {
    switch (static_cast<messages::JournalClient>(message.name())) {
      case messages::JournalClient::kAddEntriesToJournal:
            return "Receive reply actor::mojom::JournalClient::AddEntriesToJournal";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t JournalClient::AddEntriesToJournal_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdcda2d9f;  // IPCStableHash for actor::mojom::JournalClient::AddEntriesToJournal
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

JournalClientProxy::JournalClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void JournalClientProxy::AddEntriesToJournal(
    std::vector<JournalEntryPtr> in_entries) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send actor::mojom::JournalClient::AddEntriesToJournal", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("entries"), in_entries,
                        "<value of type std::vector<JournalEntryPtr>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::JournalClient::kAddEntriesToJournal), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::actor::mojom::internal::JournalClient_AddEntriesToJournal_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->entries)::BaseType>
      entries_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& entries_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::actor::mojom::JournalEntryDataView>>(
    in_entries,
    entries_fragment,
    &entries_validate_params);

  params->entries.Set(
      entries_fragment.is_null() ? nullptr : entries_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->entries.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null entries in JournalClient.AddEntriesToJournal request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(JournalClient::Name_);
  message.set_method_name("AddEntriesToJournal");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool JournalClientStubDispatch::Accept(
    JournalClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::JournalClient>(message->header()->name)) {
    case messages::JournalClient::kAddEntriesToJournal: {
      DCHECK(message->is_serialized());
      internal::JournalClient_AddEntriesToJournal_Params_Data* params =
          reinterpret_cast<internal::JournalClient_AddEntriesToJournal_Params_Data*>(
              message->mutable_payload());
      

      // Validation for JournalClient.0
      bool success = true;
      std::vector<JournalEntryPtr> p_entries{};
      JournalClient_AddEntriesToJournal_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEntries(&p_entries))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            JournalClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddEntriesToJournal(        
        std::move(p_entries));
      return true;
    }
  }
  return false;
}

// static
bool JournalClientStubDispatch::AcceptWithResponder(
    JournalClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::JournalClient>(message->header()->name)) {
    case messages::JournalClient::kAddEntriesToJournal: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kJournalClientValidationInfo[] = {
    { &internal::JournalClient_AddEntriesToJournal_Params_Data::Validate,
     nullptr /* no response */},
};

bool JournalClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::actor::mojom::JournalClient::Name_,
    kJournalClientValidationInfo);
}

// The declaration includes the definition on other builds.

PageStabilityMonitor::IPCStableHashFunction PageStabilityMonitor::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PageStabilityMonitor>(message.name())) {
    case messages::PageStabilityMonitor::kNotifyWhenStable: {
      return &PageStabilityMonitor::NotifyWhenStable_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PageStabilityMonitor::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PageStabilityMonitor>(message.name())) {
      case messages::PageStabilityMonitor::kNotifyWhenStable:
            return "Receive actor::mojom::PageStabilityMonitor::NotifyWhenStable";
    }
  } else {
    switch (static_cast<messages::PageStabilityMonitor>(message.name())) {
      case messages::PageStabilityMonitor::kNotifyWhenStable:
            return "Receive reply actor::mojom::PageStabilityMonitor::NotifyWhenStable";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PageStabilityMonitor::NotifyWhenStable_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa889e3af;  // IPCStableHash for actor::mojom::PageStabilityMonitor::NotifyWhenStable
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class PageStabilityMonitor_NotifyWhenStable_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageStabilityMonitor_NotifyWhenStable_ForwardToCallback(
      PageStabilityMonitor::NotifyWhenStableCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageStabilityMonitor_NotifyWhenStable_ForwardToCallback(const PageStabilityMonitor_NotifyWhenStable_ForwardToCallback&) = delete;
  PageStabilityMonitor_NotifyWhenStable_ForwardToCallback& operator=(const PageStabilityMonitor_NotifyWhenStable_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageStabilityMonitor::NotifyWhenStableCallback callback_;
};

PageStabilityMonitorProxy::PageStabilityMonitorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageStabilityMonitorProxy::NotifyWhenStable(
    ::base::TimeDelta in_observation_delay, NotifyWhenStableCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send actor::mojom::PageStabilityMonitor::NotifyWhenStable", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observation_delay"), in_observation_delay,
                        "<value of type ::base::TimeDelta>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageStabilityMonitor::kNotifyWhenStable), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::actor::mojom::internal::PageStabilityMonitor_NotifyWhenStable_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->observation_delay)::BaseType> observation_delay_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
    in_observation_delay,
    observation_delay_fragment);

  params->observation_delay.Set(
      observation_delay_fragment.is_null() ? nullptr : observation_delay_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->observation_delay.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null observation_delay in PageStabilityMonitor.NotifyWhenStable request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageStabilityMonitor::Name_);
  message.set_method_name("NotifyWhenStable");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageStabilityMonitor_NotifyWhenStable_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class PageStabilityMonitor_NotifyWhenStable_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageStabilityMonitor::NotifyWhenStableCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageStabilityMonitor_NotifyWhenStable_ProxyToResponder> proxy(
        new PageStabilityMonitor_NotifyWhenStable_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageStabilityMonitor_NotifyWhenStable_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageStabilityMonitor_NotifyWhenStable_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageStabilityMonitor_NotifyWhenStable_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageStabilityMonitor::NotifyWhenStableCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool PageStabilityMonitor_NotifyWhenStable_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageStabilityMonitor_NotifyWhenStable_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageStabilityMonitor_NotifyWhenStable_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageStabilityMonitor.0
  bool success = true;
  PageStabilityMonitor_NotifyWhenStable_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageStabilityMonitor::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void PageStabilityMonitor_NotifyWhenStable_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply actor::mojom::PageStabilityMonitor::NotifyWhenStable");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageStabilityMonitor::kNotifyWhenStable), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::actor::mojom::internal::PageStabilityMonitor_NotifyWhenStable_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageStabilityMonitor::Name_);
  message.set_method_name("NotifyWhenStable");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PageStabilityMonitorStubDispatch::Accept(
    PageStabilityMonitor* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PageStabilityMonitor>(message->header()->name)) {
    case messages::PageStabilityMonitor::kNotifyWhenStable: {
      break;
    }
  }
  return false;
}

// static
bool PageStabilityMonitorStubDispatch::AcceptWithResponder(
    PageStabilityMonitor* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PageStabilityMonitor>(message->header()->name)) {
    case messages::PageStabilityMonitor::kNotifyWhenStable: {
      internal::PageStabilityMonitor_NotifyWhenStable_Params_Data* params =
          reinterpret_cast<
              internal::PageStabilityMonitor_NotifyWhenStable_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageStabilityMonitor.0
      bool success = true;
      ::base::TimeDelta p_observation_delay{};
      PageStabilityMonitor_NotifyWhenStable_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadObservationDelay(&p_observation_delay))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageStabilityMonitor::Name_, 0, false);
        return false;
      }
      auto callback =
          PageStabilityMonitor_NotifyWhenStable_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyWhenStable(        
        std::move(p_observation_delay), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageStabilityMonitorValidationInfo[] = {
    { &internal::PageStabilityMonitor_NotifyWhenStable_Params_Data::Validate,
     &internal::PageStabilityMonitor_NotifyWhenStable_ResponseParams_Data::Validate},
};

bool PageStabilityMonitorRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::actor::mojom::PageStabilityMonitor::Name_,
    kPageStabilityMonitorValidationInfo);
}

bool PageStabilityMonitorResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::actor::mojom::PageStabilityMonitor::Name_,
    kPageStabilityMonitorValidationInfo);
}


}  // actor::mojom


namespace mojo {


// static
bool StructTraits<::actor::mojom::ObservedToolTarget::DataView, ::actor::mojom::ObservedToolTargetPtr>::Read(
    ::actor::mojom::ObservedToolTarget::DataView input,
    ::actor::mojom::ObservedToolTargetPtr* output) {
  bool success = true;
  ::actor::mojom::ObservedToolTargetPtr result(::actor::mojom::ObservedToolTarget::New());
  
      if (success && !input.ReadNodeAttribute(&result->node_attribute))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::actor::mojom::ClickAction::DataView, ::actor::mojom::ClickActionPtr>::Read(
    ::actor::mojom::ClickAction::DataView input,
    ::actor::mojom::ClickActionPtr* output) {
  bool success = true;
  ::actor::mojom::ClickActionPtr result(::actor::mojom::ClickAction::New());
  
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success && !input.ReadCount(&result->count))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::actor::mojom::MouseMoveAction::DataView, ::actor::mojom::MouseMoveActionPtr>::Read(
    ::actor::mojom::MouseMoveAction::DataView input,
    ::actor::mojom::MouseMoveActionPtr* output) {
  bool success = true;
  ::actor::mojom::MouseMoveActionPtr result(::actor::mojom::MouseMoveAction::New());
  
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::actor::mojom::ScrollToAction::DataView, ::actor::mojom::ScrollToActionPtr>::Read(
    ::actor::mojom::ScrollToAction::DataView input,
    ::actor::mojom::ScrollToActionPtr* output) {
  bool success = true;
  ::actor::mojom::ScrollToActionPtr result(::actor::mojom::ScrollToAction::New());
  
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::actor::mojom::TypeAction::DataView, ::actor::mojom::TypeActionPtr>::Read(
    ::actor::mojom::TypeAction::DataView input,
    ::actor::mojom::TypeActionPtr* output) {
  bool success = true;
  ::actor::mojom::TypeActionPtr result(::actor::mojom::TypeAction::New());
  
      if (success && !input.ReadMode(&result->mode))
        success = false;
      if (success && !input.ReadText(&result->text))
        success = false;
      if (success)
        result->follow_by_enter = input.follow_by_enter();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::actor::mojom::ScrollAction::DataView, ::actor::mojom::ScrollActionPtr>::Read(
    ::actor::mojom::ScrollAction::DataView input,
    ::actor::mojom::ScrollActionPtr* output) {
  bool success = true;
  ::actor::mojom::ScrollActionPtr result(::actor::mojom::ScrollAction::New());
  
      if (success && !input.ReadDirection(&result->direction))
        success = false;
      if (success)
        result->distance = input.distance();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::actor::mojom::SelectAction::DataView, ::actor::mojom::SelectActionPtr>::Read(
    ::actor::mojom::SelectAction::DataView input,
    ::actor::mojom::SelectActionPtr* output) {
  bool success = true;
  ::actor::mojom::SelectActionPtr result(::actor::mojom::SelectAction::New());
  
      if (success && !input.ReadValue(&result->value))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::actor::mojom::DragAndReleaseAction::DataView, ::actor::mojom::DragAndReleaseActionPtr>::Read(
    ::actor::mojom::DragAndReleaseAction::DataView input,
    ::actor::mojom::DragAndReleaseActionPtr* output) {
  bool success = true;
  ::actor::mojom::DragAndReleaseActionPtr result(::actor::mojom::DragAndReleaseAction::New());
  
      if (success && !input.ReadToTarget(&result->to_target))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::actor::mojom::ScriptToolAction::DataView, ::actor::mojom::ScriptToolActionPtr>::Read(
    ::actor::mojom::ScriptToolAction::DataView input,
    ::actor::mojom::ScriptToolActionPtr* output) {
  bool success = true;
  ::actor::mojom::ScriptToolActionPtr result(::actor::mojom::ScriptToolAction::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadInputArguments(&result->input_arguments))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::actor::mojom::TaskId::DataView, ::actor::mojom::TaskIdPtr>::Read(
    ::actor::mojom::TaskId::DataView input,
    ::actor::mojom::TaskIdPtr* output) {
  bool success = true;
  ::actor::mojom::TaskIdPtr result(::actor::mojom::TaskId::New());
  
      if (success)
        result->id = input.id();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::actor::mojom::ToolInvocation::DataView, ::actor::mojom::ToolInvocationPtr>::Read(
    ::actor::mojom::ToolInvocation::DataView input,
    ::actor::mojom::ToolInvocationPtr* output) {
  bool success = true;
  ::actor::mojom::ToolInvocationPtr result(::actor::mojom::ToolInvocation::New());
  
      if (success && !input.ReadTaskId(&result->task_id))
        success = false;
      if (success && !input.ReadAction(&result->action))
        success = false;
      if (success && !input.ReadTarget(&result->target))
        success = false;
      if (success && !input.ReadObservedTarget(&result->observed_target))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::actor::mojom::ActionResult::DataView, ::actor::mojom::ActionResultPtr>::Read(
    ::actor::mojom::ActionResult::DataView input,
    ::actor::mojom::ActionResultPtr* output) {
  bool success = true;
  ::actor::mojom::ActionResultPtr result(::actor::mojom::ActionResult::New());
  
      if (success && !input.ReadCode(&result->code))
        success = false;
      if (success)
        result->requires_page_stabilization = input.requires_page_stabilization();
      if (success && !input.ReadMessage(&result->message))
        success = false;
      if (success && !input.ReadScriptToolResponse(&result->script_tool_response))
        success = false;
      if (success && !input.ReadExecutionEndTime(&result->execution_end_time))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::actor::mojom::JournalDetails::DataView, ::actor::mojom::JournalDetailsPtr>::Read(
    ::actor::mojom::JournalDetails::DataView input,
    ::actor::mojom::JournalDetailsPtr* output) {
  bool success = true;
  ::actor::mojom::JournalDetailsPtr result(::actor::mojom::JournalDetails::New());
  
      if (success && !input.ReadKey(&result->key))
        success = false;
      if (success && !input.ReadValue(&result->value))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::actor::mojom::JournalEntry::DataView, ::actor::mojom::JournalEntryPtr>::Read(
    ::actor::mojom::JournalEntry::DataView input,
    ::actor::mojom::JournalEntryPtr* output) {
  bool success = true;
  ::actor::mojom::JournalEntryPtr result(::actor::mojom::JournalEntry::New());
  
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success && !input.ReadTaskId(&result->task_id))
        success = false;
      if (success && !input.ReadTimestamp(&result->timestamp))
        success = false;
      if (success && !input.ReadEvent(&result->event))
        success = false;
      if (success)
        result->track_uuid = input.track_uuid();
      if (success && !input.ReadDetails(&result->details))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::actor::mojom::ToolTarget::DataView, ::actor::mojom::ToolTargetPtr>::Read(
    ::actor::mojom::ToolTarget::DataView input,
    ::actor::mojom::ToolTargetPtr* output) {
  using UnionType = ::actor::mojom::ToolTarget;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kDomNodeId: {
      *output = UnionType::NewDomNodeId(input.dom_node_id());
      break;
    }
    case Tag::kCoordinateDip: {
      ::gfx::Point result_coordinate_dip{};
      if (!input.ReadCoordinateDip(&result_coordinate_dip))
        return false;

      *output = UnionType::NewCoordinateDip(
          std::move(result_coordinate_dip));
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::actor::mojom::ToolAction::DataView, ::actor::mojom::ToolActionPtr>::Read(
    ::actor::mojom::ToolAction::DataView input,
    ::actor::mojom::ToolActionPtr* output) {
  using UnionType = ::actor::mojom::ToolAction;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kClick: {
      ::actor::mojom::ClickActionPtr result_click{};
      if (!input.ReadClick(&result_click))
        return false;

      *output = UnionType::NewClick(
          std::move(result_click));
      break;
    }
    case Tag::kDragAndRelease: {
      ::actor::mojom::DragAndReleaseActionPtr result_drag_and_release{};
      if (!input.ReadDragAndRelease(&result_drag_and_release))
        return false;

      *output = UnionType::NewDragAndRelease(
          std::move(result_drag_and_release));
      break;
    }
    case Tag::kMouseMove: {
      ::actor::mojom::MouseMoveActionPtr result_mouse_move{};
      if (!input.ReadMouseMove(&result_mouse_move))
        return false;

      *output = UnionType::NewMouseMove(
          std::move(result_mouse_move));
      break;
    }
    case Tag::kScroll: {
      ::actor::mojom::ScrollActionPtr result_scroll{};
      if (!input.ReadScroll(&result_scroll))
        return false;

      *output = UnionType::NewScroll(
          std::move(result_scroll));
      break;
    }
    case Tag::kSelect: {
      ::actor::mojom::SelectActionPtr result_select{};
      if (!input.ReadSelect(&result_select))
        return false;

      *output = UnionType::NewSelect(
          std::move(result_select));
      break;
    }
    case Tag::kType: {
      ::actor::mojom::TypeActionPtr result_type{};
      if (!input.ReadType(&result_type))
        return false;

      *output = UnionType::NewType(
          std::move(result_type));
      break;
    }
    case Tag::kScriptTool: {
      ::actor::mojom::ScriptToolActionPtr result_script_tool{};
      if (!input.ReadScriptTool(&result_script_tool))
        return false;

      *output = UnionType::NewScriptTool(
          std::move(result_script_tool));
      break;
    }
    case Tag::kScrollTo: {
      ::actor::mojom::ScrollToActionPtr result_scroll_to{};
      if (!input.ReadScrollTo(&result_scroll_to))
        return false;

      *output = UnionType::NewScrollTo(
          std::move(result_scroll_to));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace actor::mojom {


void JournalClientInterceptorForTesting::AddEntriesToJournal(std::vector<JournalEntryPtr> entries) {
  GetForwardingInterface()->AddEntriesToJournal(
    std::move(entries)
    );
}
JournalClientAsyncWaiter::JournalClientAsyncWaiter(
    JournalClient* proxy) : proxy_(proxy) {}

JournalClientAsyncWaiter::~JournalClientAsyncWaiter() = default;





void PageStabilityMonitorInterceptorForTesting::NotifyWhenStable(::base::TimeDelta observation_delay, NotifyWhenStableCallback callback) {
  GetForwardingInterface()->NotifyWhenStable(
    std::move(observation_delay)
    , std::move(callback));
}
PageStabilityMonitorAsyncWaiter::PageStabilityMonitorAsyncWaiter(
    PageStabilityMonitor* proxy) : proxy_(proxy) {}

PageStabilityMonitorAsyncWaiter::~PageStabilityMonitorAsyncWaiter() = default;


void PageStabilityMonitorAsyncWaiter::NotifyWhenStable(
    ::base::TimeDelta observation_delay) {
  base::RunLoop loop;
  proxy_->NotifyWhenStable(
      std::move(observation_delay),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}








}  // actor::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif