// chrome/common/actor.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_COMMON_ACTOR_MOJOM_DATA_VIEW_H_
#define CHROME_COMMON_ACTOR_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "chrome/common/actor.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "third_party/blink/public/mojom/content_extraction/ai_page_content.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"


namespace actor::mojom {
class ObservedToolTargetDataView;

class ClickActionDataView;

class MouseMoveActionDataView;

class ScrollToActionDataView;

class TypeActionDataView;

class ScrollActionDataView;

class SelectActionDataView;

class DragAndReleaseActionDataView;

class ScriptToolActionDataView;

class TaskIdDataView;

class ToolInvocationDataView;

class ActionResultDataView;

class JournalDetailsDataView;

class JournalEntryDataView;

class ToolTargetDataView;
class ToolActionDataView;


}  // actor::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::actor::mojom::ObservedToolTargetDataView> {
  using Data = ::actor::mojom::internal::ObservedToolTarget_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::actor::mojom::ClickActionDataView> {
  using Data = ::actor::mojom::internal::ClickAction_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::actor::mojom::MouseMoveActionDataView> {
  using Data = ::actor::mojom::internal::MouseMoveAction_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::actor::mojom::ScrollToActionDataView> {
  using Data = ::actor::mojom::internal::ScrollToAction_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::actor::mojom::TypeActionDataView> {
  using Data = ::actor::mojom::internal::TypeAction_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::actor::mojom::ScrollActionDataView> {
  using Data = ::actor::mojom::internal::ScrollAction_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::actor::mojom::SelectActionDataView> {
  using Data = ::actor::mojom::internal::SelectAction_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::actor::mojom::DragAndReleaseActionDataView> {
  using Data = ::actor::mojom::internal::DragAndReleaseAction_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::actor::mojom::ScriptToolActionDataView> {
  using Data = ::actor::mojom::internal::ScriptToolAction_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::actor::mojom::TaskIdDataView> {
  using Data = ::actor::mojom::internal::TaskId_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::actor::mojom::ToolInvocationDataView> {
  using Data = ::actor::mojom::internal::ToolInvocation_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::actor::mojom::ActionResultDataView> {
  using Data = ::actor::mojom::internal::ActionResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::actor::mojom::JournalDetailsDataView> {
  using Data = ::actor::mojom::internal::JournalDetails_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::actor::mojom::JournalEntryDataView> {
  using Data = ::actor::mojom::internal::JournalEntry_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::actor::mojom::ToolTargetDataView> {
  using Data = ::actor::mojom::internal::ToolTarget_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::actor::mojom::ToolActionDataView> {
  using Data = ::actor::mojom::internal::ToolAction_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace actor::mojom {


enum class ActionResultCode : int32_t {
  
  kOk = 0,
  
  kError = 10,
  
  kUrlBlocked = 11,
  
  kNewTabCreationFailed = 12,
  
  kTabWentAway = 13,
  
  kTaskWentAway = 14,
  
  kCrossOriginNavigation = 15,
  
  kToolUnknown = 16,
  
  kFrameWentAway = 17,
  
  kInvalidDomNodeId = 18,
  
  kElementDisabled = 19,
  
  kElementOffscreen = 20,
  
  kCoordinatesOutOfBounds = 21,
  
  kArgumentsInvalid = 22,
  
  kTaskPaused = 23,
  
  kExecutorDestroyed = 24,
  
  kWindowWentAway = 25,
  
  kFrameLocationChangedSinceObservation = 26,
  
  kTriggeredNavigationBlocked = 27,
  
  kEmptyActionSequence = 28,
  
  kExecutorBusy = 29,
  
  kObservedTargetElementDestroyed = 30,
  
  kObservedTargetElementChanged = 31,
  
  kTargetNodeInteractionPointObscured = 32,
  
  kToolTimeout = 33,
  
  kFilePickerTriggered = 34,
  
  kFilePickerConfirmed = 35,
  
  kFilePickerCancelled = 36,
  
  kExecutionEngineExistingAction = 37,
  
  kExternalProtocolNavigationBlocked = 38,
  
  kNavigateInvalidUrl = 100,
  
  kNavigateFailedToStart = 101,
  
  kClickSuppressed = 200,
  
  kDragAndReleaseFromOffscreen = 300,
  
  kDragAndReleaseToOffscreen = 301,
  
  kDragAndReleaseFromMoveSuppressed = 302,
  
  kDragAndReleaseDownSuppressed = 303,
  
  kDragAndReleaseToMoveSuppressed = 304,
  
  kDragAndReleaseUpSuppressed = 305,
  
  kMouseMoveEventSuppressed = 400,
  
  kScrollNoScrollingElement = 500,
  
  kScrollTargetNotUserScrollable = 501,
  
  kScrollOffsetDidNotChange = 502,
  
  kSelectInvalidElement = 600,
  
  kSelectNoSuchOption = 601,
  
  kSelectOptionDisabled = 602,
  
  kSelectUnexpectedValue = 603,
  
  kTypeTargetNotElement = 700,
  
  kTypeTargetNotFocusable = 701,
  
  kTypeUnsupportedCharacters = 702,
  
  kTypeFailedMappingCharToKey = 703,
  
  kTypeKeyDownSuppressed = 704,
  
  kTypeInvalidTextEncoding = 705,
  
  kHistoryNoNavigationsCreated = 800,
  
  kHistoryCancelledBeforeStart = 801,
  
  kHistoryNoBackEntries = 802,
  
  kHistoryNoForwardEntries = 803,
  
  kHistoryFailedBeforeCommit = 804,
  
  kHistoryErrorPage = 805,
  
  kHistoryNavigationEntryChanged = 806,
  
  kLoginNoCredentialsAvailable = 900,
  
  kLoginNotLoginPage = 901,
  
  kLoginCredentialsEnteredButAnotherActionNeeded = 902,
  
  kLoginNoFillableFields = 903,
  
  kLoginFillingNotAllowed = 904,
  
  kLoginPageChangedDuringSelection = 905,
  
  kLoginDeviceReauthRequired = 906,
  
  kLoginDeviceReauthFailed = 907,
  
  kMediaControlNoMedia = 1000,
  kMinValue = 0,
  kMaxValue = 1000,
};

 std::ostream& operator<<(std::ostream& os, ActionResultCode value);
inline bool IsKnownEnumValue(ActionResultCode value) {
  return internal::ActionResultCode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class JournalEntryType : int32_t {
  
  kBegin = 0,
  
  kEnd = 1,
  
  kInstant = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, JournalEntryType value);
inline bool IsKnownEnumValue(JournalEntryType value) {
  return internal::JournalEntryType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ClickAction_Type : int32_t {
  
  kLeft = 1,
  
  kRight = 2,
  kMinValue = 1,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, ClickAction_Type value);
inline bool IsKnownEnumValue(ClickAction_Type value) {
  return internal::ClickAction_Type_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ClickAction_Count : int32_t {
  
  kSingle = 1,
  
  kDouble = 2,
  kMinValue = 1,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, ClickAction_Count value);
inline bool IsKnownEnumValue(ClickAction_Count value) {
  return internal::ClickAction_Count_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class TypeAction_Mode : int32_t {
  
  kDeleteExisting = 0,
  
  kPrepend = 1,
  
  kAppend = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, TypeAction_Mode value);
inline bool IsKnownEnumValue(TypeAction_Mode value) {
  return internal::TypeAction_Mode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ScrollAction_ScrollDirection : int32_t {
  
  kLeft = 1,
  
  kRight = 2,
  
  kUp = 3,
  
  kDown = 4,
  kMinValue = 1,
  kMaxValue = 4,
};

 std::ostream& operator<<(std::ostream& os, ScrollAction_ScrollDirection value);
inline bool IsKnownEnumValue(ScrollAction_ScrollDirection value) {
  return internal::ScrollAction_ScrollDirection_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class JournalClientInterfaceBase {};

using JournalClientPtrDataView =
    mojo::InterfacePtrDataView<JournalClientInterfaceBase>;
using JournalClientRequestDataView =
    mojo::InterfaceRequestDataView<JournalClientInterfaceBase>;
using JournalClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<JournalClientInterfaceBase>;
using JournalClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<JournalClientInterfaceBase>;
class PageStabilityMonitorInterfaceBase {};

using PageStabilityMonitorPtrDataView =
    mojo::InterfacePtrDataView<PageStabilityMonitorInterfaceBase>;
using PageStabilityMonitorRequestDataView =
    mojo::InterfaceRequestDataView<PageStabilityMonitorInterfaceBase>;
using PageStabilityMonitorAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageStabilityMonitorInterfaceBase>;
using PageStabilityMonitorAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageStabilityMonitorInterfaceBase>;


class ObservedToolTargetDataView {
 public:
  ObservedToolTargetDataView() = default;

  ObservedToolTargetDataView(
      internal::ObservedToolTarget_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNodeAttributeDataView(
      ::blink::mojom::AIPageContentAttributesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNodeAttribute(UserType* output) {
    
    auto* pointer = data_->node_attribute.Get();
    return mojo::internal::Deserialize<::blink::mojom::AIPageContentAttributesDataView>(
        pointer, output, message_);
  }
 private:
  internal::ObservedToolTarget_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ClickActionDataView {
 public:
  ClickActionDataView() = default;

  ClickActionDataView(
      internal::ClickAction_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::actor::mojom::ClickAction_Type>(
        data_value, output);
  }
  ClickAction_Type type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::actor::mojom::ClickAction_Type>(data_->type));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadCount(UserType* output) const {
    auto data_value = data_->count;
    return mojo::internal::Deserialize<::actor::mojom::ClickAction_Count>(
        data_value, output);
  }
  ClickAction_Count count() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::actor::mojom::ClickAction_Count>(data_->count));
  }
 private:
  internal::ClickAction_Data* data_ = nullptr;
};


class MouseMoveActionDataView {
 public:
  MouseMoveActionDataView() = default;

  MouseMoveActionDataView(
      internal::MouseMoveAction_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::MouseMoveAction_Data* data_ = nullptr;
};


class ScrollToActionDataView {
 public:
  ScrollToActionDataView() = default;

  ScrollToActionDataView(
      internal::ScrollToAction_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::ScrollToAction_Data* data_ = nullptr;
};


class TypeActionDataView {
 public:
  TypeActionDataView() = default;

  TypeActionDataView(
      internal::TypeAction_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadMode(UserType* output) const {
    auto data_value = data_->mode;
    return mojo::internal::Deserialize<::actor::mojom::TypeAction_Mode>(
        data_value, output);
  }
  TypeAction_Mode mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::actor::mojom::TypeAction_Mode>(data_->mode));
  }
  inline void GetTextDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadText(UserType* output) {
    
    auto* pointer = data_->text.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool follow_by_enter() const {
    return data_->follow_by_enter;
  }
 private:
  internal::TypeAction_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ScrollActionDataView {
 public:
  ScrollActionDataView() = default;

  ScrollActionDataView(
      internal::ScrollAction_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadDirection(UserType* output) const {
    auto data_value = data_->direction;
    return mojo::internal::Deserialize<::actor::mojom::ScrollAction_ScrollDirection>(
        data_value, output);
  }
  ScrollAction_ScrollDirection direction() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::actor::mojom::ScrollAction_ScrollDirection>(data_->direction));
  }
  float distance() const {
    return data_->distance;
  }
 private:
  internal::ScrollAction_Data* data_ = nullptr;
};


class SelectActionDataView {
 public:
  SelectActionDataView() = default;

  SelectActionDataView(
      internal::SelectAction_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetValueDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) {
    
    auto* pointer = data_->value.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::SelectAction_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DragAndReleaseActionDataView {
 public:
  DragAndReleaseActionDataView() = default;

  DragAndReleaseActionDataView(
      internal::DragAndReleaseAction_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetToTargetDataView(
      ToolTargetDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadToTarget(UserType* output) {
    
    auto* pointer = !data_->to_target.is_null() ? &data_->to_target : nullptr;
    return mojo::internal::Deserialize<::actor::mojom::ToolTargetDataView>(
        pointer, output, message_);
  }
 private:
  internal::DragAndReleaseAction_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ScriptToolActionDataView {
 public:
  ScriptToolActionDataView() = default;

  ScriptToolActionDataView(
      internal::ScriptToolAction_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetInputArgumentsDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInputArguments(UserType* output) {
    
    auto* pointer = data_->input_arguments.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::ScriptToolAction_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TaskIdDataView {
 public:
  TaskIdDataView() = default;

  TaskIdDataView(
      internal::TaskId_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t id() const {
    return data_->id;
  }
 private:
  internal::TaskId_Data* data_ = nullptr;
};


class ToolInvocationDataView {
 public:
  ToolInvocationDataView() = default;

  ToolInvocationDataView(
      internal::ToolInvocation_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTaskIdDataView(
      TaskIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTaskId(UserType* output) {
    
    auto* pointer = data_->task_id.Get();
    return mojo::internal::Deserialize<::actor::mojom::TaskIdDataView>(
        pointer, output, message_);
  }
  inline void GetActionDataView(
      ToolActionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAction(UserType* output) {
    
    auto* pointer = !data_->action.is_null() ? &data_->action : nullptr;
    return mojo::internal::Deserialize<::actor::mojom::ToolActionDataView>(
        pointer, output, message_);
  }
  inline void GetTargetDataView(
      ToolTargetDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTarget(UserType* output) {
    
    auto* pointer = !data_->target.is_null() ? &data_->target : nullptr;
    return mojo::internal::Deserialize<::actor::mojom::ToolTargetDataView>(
        pointer, output, message_);
  }
  inline void GetObservedTargetDataView(
      ObservedToolTargetDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadObservedTarget(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::actor::mojom::ObservedToolTargetDataView, UserType>(),
    "Attempting to read the optional `observed_target` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadObservedTarget` instead "
    "of `ReadObservedTarget if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->observed_target.Get();
    return mojo::internal::Deserialize<::actor::mojom::ObservedToolTargetDataView>(
        pointer, output, message_);
  }
 private:
  internal::ToolInvocation_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ActionResultDataView {
 public:
  ActionResultDataView() = default;

  ActionResultDataView(
      internal::ActionResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadCode(UserType* output) const {
    auto data_value = data_->code;
    return mojo::internal::Deserialize<::actor::mojom::ActionResultCode>(
        data_value, output);
  }
  ActionResultCode code() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::actor::mojom::ActionResultCode>(data_->code));
  }
  bool requires_page_stabilization() const {
    return data_->requires_page_stabilization;
  }
  inline void GetMessageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMessage(UserType* output) {
    
    auto* pointer = data_->message.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetScriptToolResponseDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScriptToolResponse(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `script_tool_response` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadScriptToolResponse` instead "
    "of `ReadScriptToolResponse if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->script_tool_response.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetExecutionEndTimeDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExecutionEndTime(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeTicksDataView, UserType>(),
    "Attempting to read the optional `execution_end_time` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadExecutionEndTime` instead "
    "of `ReadExecutionEndTime if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->execution_end_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
 private:
  internal::ActionResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class JournalDetailsDataView {
 public:
  JournalDetailsDataView() = default;

  JournalDetailsDataView(
      internal::JournalDetails_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetKeyDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadKey(UserType* output) {
    
    auto* pointer = data_->key.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetValueDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) {
    
    auto* pointer = data_->value.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::JournalDetails_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class JournalEntryDataView {
 public:
  JournalEntryDataView() = default;

  JournalEntryDataView(
      internal::JournalEntry_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::actor::mojom::JournalEntryType>(
        data_value, output);
  }
  JournalEntryType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::actor::mojom::JournalEntryType>(data_->type));
  }
  inline void GetTaskIdDataView(
      TaskIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTaskId(UserType* output) {
    
    auto* pointer = data_->task_id.Get();
    return mojo::internal::Deserialize<::actor::mojom::TaskIdDataView>(
        pointer, output, message_);
  }
  inline void GetTimestampDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTimestamp(UserType* output) {
    
    auto* pointer = data_->timestamp.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  inline void GetEventDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEvent(UserType* output) {
    
    auto* pointer = data_->event.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  uint64_t track_uuid() const {
    return data_->track_uuid;
  }
  inline void GetDetailsDataView(
      mojo::ArrayDataView<JournalDetailsDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDetails(UserType* output) {
    
    auto* pointer = data_->details.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::actor::mojom::JournalDetailsDataView>>(
        pointer, output, message_);
  }
 private:
  internal::JournalEntry_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ToolTargetDataView {
 public:
  using Tag = internal::ToolTarget_Data::ToolTarget_Tag;

  ToolTargetDataView() = default;

  ToolTargetDataView(
      internal::ToolTarget_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_dom_node_id() const { return data_->tag == Tag::kDomNodeId; }
  int32_t dom_node_id() const {
    CHECK(is_dom_node_id());
    return data_->data.f_dom_node_id;
  }
  bool is_coordinate_dip() const { return data_->tag == Tag::kCoordinateDip; }
  inline void GetCoordinateDipDataView(
      ::gfx::mojom::PointDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadCoordinateDip(UserType* output) const {
    
    CHECK(is_coordinate_dip());
    return mojo::internal::Deserialize<::gfx::mojom::PointDataView>(
        data_->data.f_coordinate_dip.Get(), output, message_);
  }

 private:
  internal::ToolTarget_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class ToolActionDataView {
 public:
  using Tag = internal::ToolAction_Data::ToolAction_Tag;

  ToolActionDataView() = default;

  ToolActionDataView(
      internal::ToolAction_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_click() const { return data_->tag == Tag::kClick; }
  inline void GetClickDataView(
      ClickActionDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadClick(UserType* output) const {
    
    CHECK(is_click());
    return mojo::internal::Deserialize<::actor::mojom::ClickActionDataView>(
        data_->data.f_click.Get(), output, message_);
  }
  bool is_drag_and_release() const { return data_->tag == Tag::kDragAndRelease; }
  inline void GetDragAndReleaseDataView(
      DragAndReleaseActionDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadDragAndRelease(UserType* output) const {
    
    CHECK(is_drag_and_release());
    return mojo::internal::Deserialize<::actor::mojom::DragAndReleaseActionDataView>(
        data_->data.f_drag_and_release.Get(), output, message_);
  }
  bool is_mouse_move() const { return data_->tag == Tag::kMouseMove; }
  inline void GetMouseMoveDataView(
      MouseMoveActionDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadMouseMove(UserType* output) const {
    
    CHECK(is_mouse_move());
    return mojo::internal::Deserialize<::actor::mojom::MouseMoveActionDataView>(
        data_->data.f_mouse_move.Get(), output, message_);
  }
  bool is_scroll() const { return data_->tag == Tag::kScroll; }
  inline void GetScrollDataView(
      ScrollActionDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadScroll(UserType* output) const {
    
    CHECK(is_scroll());
    return mojo::internal::Deserialize<::actor::mojom::ScrollActionDataView>(
        data_->data.f_scroll.Get(), output, message_);
  }
  bool is_select() const { return data_->tag == Tag::kSelect; }
  inline void GetSelectDataView(
      SelectActionDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSelect(UserType* output) const {
    
    CHECK(is_select());
    return mojo::internal::Deserialize<::actor::mojom::SelectActionDataView>(
        data_->data.f_select.Get(), output, message_);
  }
  bool is_type() const { return data_->tag == Tag::kType; }
  inline void GetTypeDataView(
      TypeActionDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    
    CHECK(is_type());
    return mojo::internal::Deserialize<::actor::mojom::TypeActionDataView>(
        data_->data.f_type.Get(), output, message_);
  }
  bool is_script_tool() const { return data_->tag == Tag::kScriptTool; }
  inline void GetScriptToolDataView(
      ScriptToolActionDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadScriptTool(UserType* output) const {
    
    CHECK(is_script_tool());
    return mojo::internal::Deserialize<::actor::mojom::ScriptToolActionDataView>(
        data_->data.f_script_tool.Get(), output, message_);
  }
  bool is_scroll_to() const { return data_->tag == Tag::kScrollTo; }
  inline void GetScrollToDataView(
      ScrollToActionDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadScrollTo(UserType* output) const {
    
    CHECK(is_scroll_to());
    return mojo::internal::Deserialize<::actor::mojom::ScrollToActionDataView>(
        data_->data.f_scroll_to.Get(), output, message_);
  }

 private:
  internal::ToolAction_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // actor::mojom

#endif  // CHROME_COMMON_ACTOR_MOJOM_DATA_VIEW_H_