// chrome/browser/ui/webui_browser/browser.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/browser/ui/webui_browser/browser.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui_browser/browser.mojom-params-data.h"
#include "chrome/browser/ui/webui_browser/browser.mojom-shared-message-ids.h"

#include "chrome/browser/ui/webui_browser/browser.mojom-import-headers.h"
#include "chrome/browser/ui/webui_browser/browser.mojom-test-utils.h"


namespace webui_browser::mojom {
// The declaration includes the definition on other builds.

PageHandlerFactory::IPCStableHashFunction PageHandlerFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PageHandlerFactory>(message.name())) {
    case messages::PageHandlerFactory::kCreatePageHandler: {
      return &PageHandlerFactory::CreatePageHandler_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PageHandlerFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PageHandlerFactory>(message.name())) {
      case messages::PageHandlerFactory::kCreatePageHandler:
            return "Receive webui_browser::mojom::PageHandlerFactory::CreatePageHandler";
    }
  } else {
    switch (static_cast<messages::PageHandlerFactory>(message.name())) {
      case messages::PageHandlerFactory::kCreatePageHandler:
            return "Receive reply webui_browser::mojom::PageHandlerFactory::CreatePageHandler";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PageHandlerFactory::CreatePageHandler_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbb5a6e78;  // IPCStableHash for webui_browser::mojom::PageHandlerFactory::CreatePageHandler
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PageHandlerFactoryProxy::PageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageHandlerFactoryProxy::CreatePageHandler(
    ::mojo::PendingRemote<Page> in_page, ::mojo::PendingReceiver<PageHandler> in_handler) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send webui_browser::mojom::PageHandlerFactory::CreatePageHandler", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page"), in_page,
                        "<value of type ::mojo::PendingRemote<Page>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handler"), in_handler,
                        "<value of type ::mojo::PendingReceiver<PageHandler>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandlerFactory::kCreatePageHandler), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::webui_browser::mojom::internal::PageHandlerFactory_CreatePageHandler_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::webui_browser::mojom::PageInterfaceBase>>(
    in_page,
    &params->page,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->page)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid page in PageHandlerFactory.CreatePageHandler request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::webui_browser::mojom::PageHandlerInterfaceBase>>(
    in_handler,
    &params->handler,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->handler)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid handler in PageHandlerFactory.CreatePageHandler request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandlerFactory::Name_);
  message.set_method_name("CreatePageHandler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PageHandlerFactoryStubDispatch::Accept(
    PageHandlerFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PageHandlerFactory>(message->header()->name)) {
    case messages::PageHandlerFactory::kCreatePageHandler: {
      DCHECK(message->is_serialized());
      internal::PageHandlerFactory_CreatePageHandler_Params_Data* params =
          reinterpret_cast<internal::PageHandlerFactory_CreatePageHandler_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandlerFactory.0
      bool success = true;
      ::mojo::PendingRemote<Page> p_page{};
      ::mojo::PendingReceiver<PageHandler> p_handler{};
      PageHandlerFactory_CreatePageHandler_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_page =
            input_data_view.TakePage<decltype(p_page)>();
      }
      if (success) {
        p_handler =
            input_data_view.TakeHandler<decltype(p_handler)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandlerFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreatePageHandler(        
        std::move(p_page), 
        std::move(p_handler));
      return true;
    }
  }
  return false;
}

// static
bool PageHandlerFactoryStubDispatch::AcceptWithResponder(
    PageHandlerFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PageHandlerFactory>(message->header()->name)) {
    case messages::PageHandlerFactory::kCreatePageHandler: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageHandlerFactoryValidationInfo[] = {
    { &internal::PageHandlerFactory_CreatePageHandler_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageHandlerFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::webui_browser::mojom::PageHandlerFactory::Name_,
    kPageHandlerFactoryValidationInfo);
}

// The declaration includes the definition on other builds.

Page::IPCStableHashFunction Page::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Page>(message.name())) {
    case messages::Page::kSetFocusToLocationBar: {
      return &Page::SetFocusToLocationBar_Sym::IPCStableHash;
    }
    case messages::Page::kSetReloadStopState: {
      return &Page::SetReloadStopState_Sym::IPCStableHash;
    }
    case messages::Page::kShowSidePanel: {
      return &Page::ShowSidePanel_Sym::IPCStableHash;
    }
    case messages::Page::kCloseSidePanel: {
      return &Page::CloseSidePanel_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Page::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Page>(message.name())) {
      case messages::Page::kSetFocusToLocationBar:
            return "Receive webui_browser::mojom::Page::SetFocusToLocationBar";
      case messages::Page::kSetReloadStopState:
            return "Receive webui_browser::mojom::Page::SetReloadStopState";
      case messages::Page::kShowSidePanel:
            return "Receive webui_browser::mojom::Page::ShowSidePanel";
      case messages::Page::kCloseSidePanel:
            return "Receive webui_browser::mojom::Page::CloseSidePanel";
    }
  } else {
    switch (static_cast<messages::Page>(message.name())) {
      case messages::Page::kSetFocusToLocationBar:
            return "Receive reply webui_browser::mojom::Page::SetFocusToLocationBar";
      case messages::Page::kSetReloadStopState:
            return "Receive reply webui_browser::mojom::Page::SetReloadStopState";
      case messages::Page::kShowSidePanel:
            return "Receive reply webui_browser::mojom::Page::ShowSidePanel";
      case messages::Page::kCloseSidePanel:
            return "Receive reply webui_browser::mojom::Page::CloseSidePanel";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Page::SetFocusToLocationBar_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa4dbe35a;  // IPCStableHash for webui_browser::mojom::Page::SetFocusToLocationBar
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::SetReloadStopState_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x79b37157;  // IPCStableHash for webui_browser::mojom::Page::SetReloadStopState
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::ShowSidePanel_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2bf0133e;  // IPCStableHash for webui_browser::mojom::Page::ShowSidePanel
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::CloseSidePanel_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd56be9ba;  // IPCStableHash for webui_browser::mojom::Page::CloseSidePanel
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PageProxy::PageProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageProxy::SetFocusToLocationBar(
    bool in_is_user_initiated) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send webui_browser::mojom::Page::SetFocusToLocationBar", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_user_initiated"), in_is_user_initiated,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kSetFocusToLocationBar), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::webui_browser::mojom::internal::Page_SetFocusToLocationBar_Params_Data> params(
          message);
  params.Allocate();

  params->is_user_initiated = in_is_user_initiated;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("SetFocusToLocationBar");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::SetReloadStopState(
    bool in_is_loading) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send webui_browser::mojom::Page::SetReloadStopState", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_loading"), in_is_loading,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kSetReloadStopState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::webui_browser::mojom::internal::Page_SetReloadStopState_Params_Data> params(
          message);
  params.Allocate();

  params->is_loading = in_is_loading;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("SetReloadStopState");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::ShowSidePanel(
    int32_t in_guest_contents_id, const std::string& in_title) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send webui_browser::mojom::Page::ShowSidePanel", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("guest_contents_id"), in_guest_contents_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("title"), in_title,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kShowSidePanel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::webui_browser::mojom::internal::Page_ShowSidePanel_Params_Data> params(
          message);
  params.Allocate();

  params->guest_contents_id = in_guest_contents_id;
  mojo::internal::MessageFragment<
      typename decltype(params->title)::BaseType> title_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_title,
    title_fragment);

  params->title.Set(
      title_fragment.is_null() ? nullptr : title_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->title.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null title in Page.ShowSidePanel request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("ShowSidePanel");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::CloseSidePanel(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send webui_browser::mojom::Page::CloseSidePanel");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kCloseSidePanel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::webui_browser::mojom::internal::Page_CloseSidePanel_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("CloseSidePanel");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PageStubDispatch::Accept(
    Page* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Page>(message->header()->name)) {
    case messages::Page::kSetFocusToLocationBar: {
      DCHECK(message->is_serialized());
      internal::Page_SetFocusToLocationBar_Params_Data* params =
          reinterpret_cast<internal::Page_SetFocusToLocationBar_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.0
      bool success = true;
      bool p_is_user_initiated{};
      Page_SetFocusToLocationBar_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_user_initiated = input_data_view.is_user_initiated();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetFocusToLocationBar(        
        std::move(p_is_user_initiated));
      return true;
    }
    case messages::Page::kSetReloadStopState: {
      DCHECK(message->is_serialized());
      internal::Page_SetReloadStopState_Params_Data* params =
          reinterpret_cast<internal::Page_SetReloadStopState_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.1
      bool success = true;
      bool p_is_loading{};
      Page_SetReloadStopState_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_loading = input_data_view.is_loading();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetReloadStopState(        
        std::move(p_is_loading));
      return true;
    }
    case messages::Page::kShowSidePanel: {
      DCHECK(message->is_serialized());
      internal::Page_ShowSidePanel_Params_Data* params =
          reinterpret_cast<internal::Page_ShowSidePanel_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.2
      bool success = true;
      int32_t p_guest_contents_id{};
      std::string p_title{};
      Page_ShowSidePanel_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_guest_contents_id = input_data_view.guest_contents_id();
      if (success && !input_data_view.ReadTitle(&p_title))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowSidePanel(        
        std::move(p_guest_contents_id), 
        std::move(p_title));
      return true;
    }
    case messages::Page::kCloseSidePanel: {
      DCHECK(message->is_serialized());
      internal::Page_CloseSidePanel_Params_Data* params =
          reinterpret_cast<internal::Page_CloseSidePanel_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.3
      bool success = true;
      Page_CloseSidePanel_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CloseSidePanel(        );
      return true;
    }
  }
  return false;
}

// static
bool PageStubDispatch::AcceptWithResponder(
    Page* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Page>(message->header()->name)) {
    case messages::Page::kSetFocusToLocationBar: {
      break;
    }
    case messages::Page::kSetReloadStopState: {
      break;
    }
    case messages::Page::kShowSidePanel: {
      break;
    }
    case messages::Page::kCloseSidePanel: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageValidationInfo[] = {
    { &internal::Page_SetFocusToLocationBar_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_SetReloadStopState_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_ShowSidePanel_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_CloseSidePanel_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::webui_browser::mojom::Page::Name_,
    kPageValidationInfo);
}

// The declaration includes the definition on other builds.

PageHandler::IPCStableHashFunction PageHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PageHandler>(message.name())) {
    case messages::PageHandler::kGetGuestIdForTabId: {
      return &PageHandler::GetGuestIdForTabId_Sym::IPCStableHash;
    }
    case messages::PageHandler::kLoadTabSearch: {
      return &PageHandler::LoadTabSearch_Sym::IPCStableHash;
    }
    case messages::PageHandler::kShowTabSearchBubble: {
      return &PageHandler::ShowTabSearchBubble_Sym::IPCStableHash;
    }
    case messages::PageHandler::kOpenAppMenu: {
      return &PageHandler::OpenAppMenu_Sym::IPCStableHash;
    }
    case messages::PageHandler::kOpenProfileMenu: {
      return &PageHandler::OpenProfileMenu_Sym::IPCStableHash;
    }
    case messages::PageHandler::kLaunchDevToolsForBrowser: {
      return &PageHandler::LaunchDevToolsForBrowser_Sym::IPCStableHash;
    }
    case messages::PageHandler::kOnSidePanelClosed: {
      return &PageHandler::OnSidePanelClosed_Sym::IPCStableHash;
    }
    case messages::PageHandler::kMinimize: {
      return &PageHandler::Minimize_Sym::IPCStableHash;
    }
    case messages::PageHandler::kMaximize: {
      return &PageHandler::Maximize_Sym::IPCStableHash;
    }
    case messages::PageHandler::kRestore: {
      return &PageHandler::Restore_Sym::IPCStableHash;
    }
    case messages::PageHandler::kClose: {
      return &PageHandler::Close_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PageHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PageHandler>(message.name())) {
      case messages::PageHandler::kGetGuestIdForTabId:
            return "Receive webui_browser::mojom::PageHandler::GetGuestIdForTabId";
      case messages::PageHandler::kLoadTabSearch:
            return "Receive webui_browser::mojom::PageHandler::LoadTabSearch";
      case messages::PageHandler::kShowTabSearchBubble:
            return "Receive webui_browser::mojom::PageHandler::ShowTabSearchBubble";
      case messages::PageHandler::kOpenAppMenu:
            return "Receive webui_browser::mojom::PageHandler::OpenAppMenu";
      case messages::PageHandler::kOpenProfileMenu:
            return "Receive webui_browser::mojom::PageHandler::OpenProfileMenu";
      case messages::PageHandler::kLaunchDevToolsForBrowser:
            return "Receive webui_browser::mojom::PageHandler::LaunchDevToolsForBrowser";
      case messages::PageHandler::kOnSidePanelClosed:
            return "Receive webui_browser::mojom::PageHandler::OnSidePanelClosed";
      case messages::PageHandler::kMinimize:
            return "Receive webui_browser::mojom::PageHandler::Minimize";
      case messages::PageHandler::kMaximize:
            return "Receive webui_browser::mojom::PageHandler::Maximize";
      case messages::PageHandler::kRestore:
            return "Receive webui_browser::mojom::PageHandler::Restore";
      case messages::PageHandler::kClose:
            return "Receive webui_browser::mojom::PageHandler::Close";
    }
  } else {
    switch (static_cast<messages::PageHandler>(message.name())) {
      case messages::PageHandler::kGetGuestIdForTabId:
            return "Receive reply webui_browser::mojom::PageHandler::GetGuestIdForTabId";
      case messages::PageHandler::kLoadTabSearch:
            return "Receive reply webui_browser::mojom::PageHandler::LoadTabSearch";
      case messages::PageHandler::kShowTabSearchBubble:
            return "Receive reply webui_browser::mojom::PageHandler::ShowTabSearchBubble";
      case messages::PageHandler::kOpenAppMenu:
            return "Receive reply webui_browser::mojom::PageHandler::OpenAppMenu";
      case messages::PageHandler::kOpenProfileMenu:
            return "Receive reply webui_browser::mojom::PageHandler::OpenProfileMenu";
      case messages::PageHandler::kLaunchDevToolsForBrowser:
            return "Receive reply webui_browser::mojom::PageHandler::LaunchDevToolsForBrowser";
      case messages::PageHandler::kOnSidePanelClosed:
            return "Receive reply webui_browser::mojom::PageHandler::OnSidePanelClosed";
      case messages::PageHandler::kMinimize:
            return "Receive reply webui_browser::mojom::PageHandler::Minimize";
      case messages::PageHandler::kMaximize:
            return "Receive reply webui_browser::mojom::PageHandler::Maximize";
      case messages::PageHandler::kRestore:
            return "Receive reply webui_browser::mojom::PageHandler::Restore";
      case messages::PageHandler::kClose:
            return "Receive reply webui_browser::mojom::PageHandler::Close";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PageHandler::GetGuestIdForTabId_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x281dfb19;  // IPCStableHash for webui_browser::mojom::PageHandler::GetGuestIdForTabId
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::LoadTabSearch_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa210998f;  // IPCStableHash for webui_browser::mojom::PageHandler::LoadTabSearch
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::ShowTabSearchBubble_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x89474bdb;  // IPCStableHash for webui_browser::mojom::PageHandler::ShowTabSearchBubble
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::OpenAppMenu_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc849451a;  // IPCStableHash for webui_browser::mojom::PageHandler::OpenAppMenu
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::OpenProfileMenu_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xaa8b8b4b;  // IPCStableHash for webui_browser::mojom::PageHandler::OpenProfileMenu
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::LaunchDevToolsForBrowser_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x14098a1e;  // IPCStableHash for webui_browser::mojom::PageHandler::LaunchDevToolsForBrowser
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::OnSidePanelClosed_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x36ec1fad;  // IPCStableHash for webui_browser::mojom::PageHandler::OnSidePanelClosed
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::Minimize_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x882f06f5;  // IPCStableHash for webui_browser::mojom::PageHandler::Minimize
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::Maximize_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb8b7cdc6;  // IPCStableHash for webui_browser::mojom::PageHandler::Maximize
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::Restore_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf1af80ea;  // IPCStableHash for webui_browser::mojom::PageHandler::Restore
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::Close_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd67893d3;  // IPCStableHash for webui_browser::mojom::PageHandler::Close
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class PageHandler_GetGuestIdForTabId_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_GetGuestIdForTabId_ForwardToCallback(
      PageHandler::GetGuestIdForTabIdCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_GetGuestIdForTabId_ForwardToCallback(const PageHandler_GetGuestIdForTabId_ForwardToCallback&) = delete;
  PageHandler_GetGuestIdForTabId_ForwardToCallback& operator=(const PageHandler_GetGuestIdForTabId_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::GetGuestIdForTabIdCallback callback_;
};

class PageHandler_LoadTabSearch_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_LoadTabSearch_ForwardToCallback(
      PageHandler::LoadTabSearchCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_LoadTabSearch_ForwardToCallback(const PageHandler_LoadTabSearch_ForwardToCallback&) = delete;
  PageHandler_LoadTabSearch_ForwardToCallback& operator=(const PageHandler_LoadTabSearch_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::LoadTabSearchCallback callback_;
};

PageHandlerProxy::PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageHandlerProxy::GetGuestIdForTabId(
    const ::tabs_api::NodeId& in_tab_id, ::mojo::PendingReceiver<GuestHandler> in_handler, GetGuestIdForTabIdCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send webui_browser::mojom::PageHandler::GetGuestIdForTabId", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tab_id"), in_tab_id,
                        "<value of type const ::tabs_api::NodeId&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handler"), in_handler,
                        "<value of type ::mojo::PendingReceiver<GuestHandler>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetGuestIdForTabId), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::webui_browser::mojom::internal::PageHandler_GetGuestIdForTabId_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->tab_id)::BaseType> tab_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::tabs_api::mojom::NodeIdDataView>(
    in_tab_id,
    tab_id_fragment);

  params->tab_id.Set(
      tab_id_fragment.is_null() ? nullptr : tab_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->tab_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null tab_id in PageHandler.GetGuestIdForTabId request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::webui_browser::mojom::GuestHandlerInterfaceBase>>(
    in_handler,
    &params->handler,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->handler)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid handler in PageHandler.GetGuestIdForTabId request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetGuestIdForTabId");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_GetGuestIdForTabId_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::LoadTabSearch(
    LoadTabSearchCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send webui_browser::mojom::PageHandler::LoadTabSearch");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kLoadTabSearch), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::webui_browser::mojom::internal::PageHandler_LoadTabSearch_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("LoadTabSearch");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_LoadTabSearch_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::ShowTabSearchBubble(
    const std::string& in_anchor_name) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send webui_browser::mojom::PageHandler::ShowTabSearchBubble", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("anchor_name"), in_anchor_name,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kShowTabSearchBubble), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::webui_browser::mojom::internal::PageHandler_ShowTabSearchBubble_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->anchor_name)::BaseType> anchor_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_anchor_name,
    anchor_name_fragment);

  params->anchor_name.Set(
      anchor_name_fragment.is_null() ? nullptr : anchor_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->anchor_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null anchor_name in PageHandler.ShowTabSearchBubble request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("ShowTabSearchBubble");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::OpenAppMenu(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send webui_browser::mojom::PageHandler::OpenAppMenu");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kOpenAppMenu), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::webui_browser::mojom::internal::PageHandler_OpenAppMenu_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("OpenAppMenu");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::OpenProfileMenu(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send webui_browser::mojom::PageHandler::OpenProfileMenu");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kOpenProfileMenu), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::webui_browser::mojom::internal::PageHandler_OpenProfileMenu_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("OpenProfileMenu");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::LaunchDevToolsForBrowser(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send webui_browser::mojom::PageHandler::LaunchDevToolsForBrowser");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kLaunchDevToolsForBrowser), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::webui_browser::mojom::internal::PageHandler_LaunchDevToolsForBrowser_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("LaunchDevToolsForBrowser");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::OnSidePanelClosed(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send webui_browser::mojom::PageHandler::OnSidePanelClosed");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kOnSidePanelClosed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::webui_browser::mojom::internal::PageHandler_OnSidePanelClosed_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("OnSidePanelClosed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::Minimize(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send webui_browser::mojom::PageHandler::Minimize");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kMinimize), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::webui_browser::mojom::internal::PageHandler_Minimize_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("Minimize");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::Maximize(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send webui_browser::mojom::PageHandler::Maximize");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kMaximize), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::webui_browser::mojom::internal::PageHandler_Maximize_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("Maximize");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::Restore(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send webui_browser::mojom::PageHandler::Restore");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kRestore), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::webui_browser::mojom::internal::PageHandler_Restore_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("Restore");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::Close(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send webui_browser::mojom::PageHandler::Close");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kClose), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::webui_browser::mojom::internal::PageHandler_Close_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("Close");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class PageHandler_GetGuestIdForTabId_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::GetGuestIdForTabIdCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_GetGuestIdForTabId_ProxyToResponder> proxy(
        new PageHandler_GetGuestIdForTabId_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_GetGuestIdForTabId_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_GetGuestIdForTabId_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_GetGuestIdForTabId_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::GetGuestIdForTabIdCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_guest_id);
};

bool PageHandler_GetGuestIdForTabId_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_GetGuestIdForTabId_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_GetGuestIdForTabId_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.0
  bool success = true;
  int32_t p_guest_id{};
  PageHandler_GetGuestIdForTabId_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_guest_id = input_data_view.guest_id();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_guest_id));
  }
  return true;
}

void PageHandler_GetGuestIdForTabId_ProxyToResponder::Run(
    int32_t in_guest_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply webui_browser::mojom::PageHandler::GetGuestIdForTabId", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("guest_id"), in_guest_id,
                        "<value of type int32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetGuestIdForTabId), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::webui_browser::mojom::internal::PageHandler_GetGuestIdForTabId_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->guest_id = in_guest_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetGuestIdForTabId");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_LoadTabSearch_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::LoadTabSearchCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_LoadTabSearch_ProxyToResponder> proxy(
        new PageHandler_LoadTabSearch_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_LoadTabSearch_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_LoadTabSearch_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_LoadTabSearch_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::LoadTabSearchCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_guest_id);
};

bool PageHandler_LoadTabSearch_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_LoadTabSearch_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_LoadTabSearch_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.1
  bool success = true;
  int32_t p_guest_id{};
  PageHandler_LoadTabSearch_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_guest_id = input_data_view.guest_id();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_guest_id));
  }
  return true;
}

void PageHandler_LoadTabSearch_ProxyToResponder::Run(
    int32_t in_guest_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply webui_browser::mojom::PageHandler::LoadTabSearch", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("guest_id"), in_guest_id,
                        "<value of type int32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kLoadTabSearch), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::webui_browser::mojom::internal::PageHandler_LoadTabSearch_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->guest_id = in_guest_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("LoadTabSearch");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PageHandlerStubDispatch::Accept(
    PageHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PageHandler>(message->header()->name)) {
    case messages::PageHandler::kGetGuestIdForTabId: {
      break;
    }
    case messages::PageHandler::kLoadTabSearch: {
      break;
    }
    case messages::PageHandler::kShowTabSearchBubble: {
      DCHECK(message->is_serialized());
      internal::PageHandler_ShowTabSearchBubble_Params_Data* params =
          reinterpret_cast<internal::PageHandler_ShowTabSearchBubble_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.2
      bool success = true;
      std::string p_anchor_name{};
      PageHandler_ShowTabSearchBubble_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAnchorName(&p_anchor_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowTabSearchBubble(        
        std::move(p_anchor_name));
      return true;
    }
    case messages::PageHandler::kOpenAppMenu: {
      DCHECK(message->is_serialized());
      internal::PageHandler_OpenAppMenu_Params_Data* params =
          reinterpret_cast<internal::PageHandler_OpenAppMenu_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.3
      bool success = true;
      PageHandler_OpenAppMenu_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenAppMenu(        );
      return true;
    }
    case messages::PageHandler::kOpenProfileMenu: {
      DCHECK(message->is_serialized());
      internal::PageHandler_OpenProfileMenu_Params_Data* params =
          reinterpret_cast<internal::PageHandler_OpenProfileMenu_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.4
      bool success = true;
      PageHandler_OpenProfileMenu_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenProfileMenu(        );
      return true;
    }
    case messages::PageHandler::kLaunchDevToolsForBrowser: {
      DCHECK(message->is_serialized());
      internal::PageHandler_LaunchDevToolsForBrowser_Params_Data* params =
          reinterpret_cast<internal::PageHandler_LaunchDevToolsForBrowser_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.5
      bool success = true;
      PageHandler_LaunchDevToolsForBrowser_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LaunchDevToolsForBrowser(        );
      return true;
    }
    case messages::PageHandler::kOnSidePanelClosed: {
      DCHECK(message->is_serialized());
      internal::PageHandler_OnSidePanelClosed_Params_Data* params =
          reinterpret_cast<internal::PageHandler_OnSidePanelClosed_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.6
      bool success = true;
      PageHandler_OnSidePanelClosed_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSidePanelClosed(        );
      return true;
    }
    case messages::PageHandler::kMinimize: {
      DCHECK(message->is_serialized());
      internal::PageHandler_Minimize_Params_Data* params =
          reinterpret_cast<internal::PageHandler_Minimize_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.7
      bool success = true;
      PageHandler_Minimize_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Minimize(        );
      return true;
    }
    case messages::PageHandler::kMaximize: {
      DCHECK(message->is_serialized());
      internal::PageHandler_Maximize_Params_Data* params =
          reinterpret_cast<internal::PageHandler_Maximize_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.8
      bool success = true;
      PageHandler_Maximize_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Maximize(        );
      return true;
    }
    case messages::PageHandler::kRestore: {
      DCHECK(message->is_serialized());
      internal::PageHandler_Restore_Params_Data* params =
          reinterpret_cast<internal::PageHandler_Restore_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.9
      bool success = true;
      PageHandler_Restore_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Restore(        );
      return true;
    }
    case messages::PageHandler::kClose: {
      DCHECK(message->is_serialized());
      internal::PageHandler_Close_Params_Data* params =
          reinterpret_cast<internal::PageHandler_Close_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.10
      bool success = true;
      PageHandler_Close_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Close(        );
      return true;
    }
  }
  return false;
}

// static
bool PageHandlerStubDispatch::AcceptWithResponder(
    PageHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PageHandler>(message->header()->name)) {
    case messages::PageHandler::kGetGuestIdForTabId: {
      internal::PageHandler_GetGuestIdForTabId_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_GetGuestIdForTabId_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.0
      bool success = true;
      ::tabs_api::NodeId p_tab_id{};
      ::mojo::PendingReceiver<GuestHandler> p_handler{};
      PageHandler_GetGuestIdForTabId_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTabId(&p_tab_id))
        success = false;
      if (success) {
        p_handler =
            input_data_view.TakeHandler<decltype(p_handler)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 0, false);
        return false;
      }
      auto callback =
          PageHandler_GetGuestIdForTabId_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetGuestIdForTabId(        
        std::move(p_tab_id), 
        std::move(p_handler), std::move(callback));
      return true;
    }
    case messages::PageHandler::kLoadTabSearch: {
      internal::PageHandler_LoadTabSearch_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_LoadTabSearch_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.1
      bool success = true;
      PageHandler_LoadTabSearch_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 1, false);
        return false;
      }
      auto callback =
          PageHandler_LoadTabSearch_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LoadTabSearch(std::move(callback));
      return true;
    }
    case messages::PageHandler::kShowTabSearchBubble: {
      break;
    }
    case messages::PageHandler::kOpenAppMenu: {
      break;
    }
    case messages::PageHandler::kOpenProfileMenu: {
      break;
    }
    case messages::PageHandler::kLaunchDevToolsForBrowser: {
      break;
    }
    case messages::PageHandler::kOnSidePanelClosed: {
      break;
    }
    case messages::PageHandler::kMinimize: {
      break;
    }
    case messages::PageHandler::kMaximize: {
      break;
    }
    case messages::PageHandler::kRestore: {
      break;
    }
    case messages::PageHandler::kClose: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageHandlerValidationInfo[] = {
    { &internal::PageHandler_GetGuestIdForTabId_Params_Data::Validate,
     &internal::PageHandler_GetGuestIdForTabId_ResponseParams_Data::Validate},
    { &internal::PageHandler_LoadTabSearch_Params_Data::Validate,
     &internal::PageHandler_LoadTabSearch_ResponseParams_Data::Validate},
    { &internal::PageHandler_ShowTabSearchBubble_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_OpenAppMenu_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_OpenProfileMenu_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_LaunchDevToolsForBrowser_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_OnSidePanelClosed_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_Minimize_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_Maximize_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_Restore_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_Close_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::webui_browser::mojom::PageHandler::Name_,
    kPageHandlerValidationInfo);
}

bool PageHandlerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::webui_browser::mojom::PageHandler::Name_,
    kPageHandlerValidationInfo);
}
// The declaration includes the definition on other builds.

GuestHandler::IPCStableHashFunction GuestHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::GuestHandler>(message.name())) {
    case messages::GuestHandler::kNavigate: {
      return &GuestHandler::Navigate_Sym::IPCStableHash;
    }
    case messages::GuestHandler::kCanGoBack: {
      return &GuestHandler::CanGoBack_Sym::IPCStableHash;
    }
    case messages::GuestHandler::kGoBack: {
      return &GuestHandler::GoBack_Sym::IPCStableHash;
    }
    case messages::GuestHandler::kCanGoForward: {
      return &GuestHandler::CanGoForward_Sym::IPCStableHash;
    }
    case messages::GuestHandler::kGoForward: {
      return &GuestHandler::GoForward_Sym::IPCStableHash;
    }
    case messages::GuestHandler::kReload: {
      return &GuestHandler::Reload_Sym::IPCStableHash;
    }
    case messages::GuestHandler::kStopLoading: {
      return &GuestHandler::StopLoading_Sym::IPCStableHash;
    }
    case messages::GuestHandler::kOpenPageInfoMenu: {
      return &GuestHandler::OpenPageInfoMenu_Sym::IPCStableHash;
    }
    case messages::GuestHandler::kGetSecurityIcon: {
      return &GuestHandler::GetSecurityIcon_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* GuestHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::GuestHandler>(message.name())) {
      case messages::GuestHandler::kNavigate:
            return "Receive webui_browser::mojom::GuestHandler::Navigate";
      case messages::GuestHandler::kCanGoBack:
            return "Receive webui_browser::mojom::GuestHandler::CanGoBack";
      case messages::GuestHandler::kGoBack:
            return "Receive webui_browser::mojom::GuestHandler::GoBack";
      case messages::GuestHandler::kCanGoForward:
            return "Receive webui_browser::mojom::GuestHandler::CanGoForward";
      case messages::GuestHandler::kGoForward:
            return "Receive webui_browser::mojom::GuestHandler::GoForward";
      case messages::GuestHandler::kReload:
            return "Receive webui_browser::mojom::GuestHandler::Reload";
      case messages::GuestHandler::kStopLoading:
            return "Receive webui_browser::mojom::GuestHandler::StopLoading";
      case messages::GuestHandler::kOpenPageInfoMenu:
            return "Receive webui_browser::mojom::GuestHandler::OpenPageInfoMenu";
      case messages::GuestHandler::kGetSecurityIcon:
            return "Receive webui_browser::mojom::GuestHandler::GetSecurityIcon";
    }
  } else {
    switch (static_cast<messages::GuestHandler>(message.name())) {
      case messages::GuestHandler::kNavigate:
            return "Receive reply webui_browser::mojom::GuestHandler::Navigate";
      case messages::GuestHandler::kCanGoBack:
            return "Receive reply webui_browser::mojom::GuestHandler::CanGoBack";
      case messages::GuestHandler::kGoBack:
            return "Receive reply webui_browser::mojom::GuestHandler::GoBack";
      case messages::GuestHandler::kCanGoForward:
            return "Receive reply webui_browser::mojom::GuestHandler::CanGoForward";
      case messages::GuestHandler::kGoForward:
            return "Receive reply webui_browser::mojom::GuestHandler::GoForward";
      case messages::GuestHandler::kReload:
            return "Receive reply webui_browser::mojom::GuestHandler::Reload";
      case messages::GuestHandler::kStopLoading:
            return "Receive reply webui_browser::mojom::GuestHandler::StopLoading";
      case messages::GuestHandler::kOpenPageInfoMenu:
            return "Receive reply webui_browser::mojom::GuestHandler::OpenPageInfoMenu";
      case messages::GuestHandler::kGetSecurityIcon:
            return "Receive reply webui_browser::mojom::GuestHandler::GetSecurityIcon";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t GuestHandler::Navigate_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1041f573;  // IPCStableHash for webui_browser::mojom::GuestHandler::Navigate
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GuestHandler::CanGoBack_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x83199e6d;  // IPCStableHash for webui_browser::mojom::GuestHandler::CanGoBack
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GuestHandler::GoBack_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb3293a8d;  // IPCStableHash for webui_browser::mojom::GuestHandler::GoBack
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GuestHandler::CanGoForward_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x60bb5d46;  // IPCStableHash for webui_browser::mojom::GuestHandler::CanGoForward
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GuestHandler::GoForward_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x52c5ebd6;  // IPCStableHash for webui_browser::mojom::GuestHandler::GoForward
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GuestHandler::Reload_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7d1c1e10;  // IPCStableHash for webui_browser::mojom::GuestHandler::Reload
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GuestHandler::StopLoading_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x69cfd255;  // IPCStableHash for webui_browser::mojom::GuestHandler::StopLoading
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GuestHandler::OpenPageInfoMenu_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2d3d1e1e;  // IPCStableHash for webui_browser::mojom::GuestHandler::OpenPageInfoMenu
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GuestHandler::GetSecurityIcon_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbd47e782;  // IPCStableHash for webui_browser::mojom::GuestHandler::GetSecurityIcon
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class GuestHandler_CanGoBack_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GuestHandler_CanGoBack_ForwardToCallback(
      GuestHandler::CanGoBackCallback callback
      ) : callback_(std::move(callback)) {
  }

  GuestHandler_CanGoBack_ForwardToCallback(const GuestHandler_CanGoBack_ForwardToCallback&) = delete;
  GuestHandler_CanGoBack_ForwardToCallback& operator=(const GuestHandler_CanGoBack_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  GuestHandler::CanGoBackCallback callback_;
};

class GuestHandler_CanGoForward_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GuestHandler_CanGoForward_ForwardToCallback(
      GuestHandler::CanGoForwardCallback callback
      ) : callback_(std::move(callback)) {
  }

  GuestHandler_CanGoForward_ForwardToCallback(const GuestHandler_CanGoForward_ForwardToCallback&) = delete;
  GuestHandler_CanGoForward_ForwardToCallback& operator=(const GuestHandler_CanGoForward_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  GuestHandler::CanGoForwardCallback callback_;
};

class GuestHandler_GetSecurityIcon_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GuestHandler_GetSecurityIcon_ForwardToCallback(
      GuestHandler::GetSecurityIconCallback callback
      ) : callback_(std::move(callback)) {
  }

  GuestHandler_GetSecurityIcon_ForwardToCallback(const GuestHandler_GetSecurityIcon_ForwardToCallback&) = delete;
  GuestHandler_GetSecurityIcon_ForwardToCallback& operator=(const GuestHandler_GetSecurityIcon_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  GuestHandler::GetSecurityIconCallback callback_;
};

GuestHandlerProxy::GuestHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void GuestHandlerProxy::Navigate(
    const ::GURL& in_src) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send webui_browser::mojom::GuestHandler::Navigate", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("src"), in_src,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GuestHandler::kNavigate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::webui_browser::mojom::internal::GuestHandler_Navigate_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->src)::BaseType> src_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_src,
    src_fragment);

  params->src.Set(
      src_fragment.is_null() ? nullptr : src_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->src.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null src in GuestHandler.Navigate request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GuestHandler::Name_);
  message.set_method_name("Navigate");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void GuestHandlerProxy::CanGoBack(
    CanGoBackCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send webui_browser::mojom::GuestHandler::CanGoBack");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GuestHandler::kCanGoBack), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::webui_browser::mojom::internal::GuestHandler_CanGoBack_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GuestHandler::Name_);
  message.set_method_name("CanGoBack");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GuestHandler_CanGoBack_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void GuestHandlerProxy::GoBack(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send webui_browser::mojom::GuestHandler::GoBack");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GuestHandler::kGoBack), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::webui_browser::mojom::internal::GuestHandler_GoBack_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GuestHandler::Name_);
  message.set_method_name("GoBack");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void GuestHandlerProxy::CanGoForward(
    CanGoForwardCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send webui_browser::mojom::GuestHandler::CanGoForward");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GuestHandler::kCanGoForward), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::webui_browser::mojom::internal::GuestHandler_CanGoForward_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GuestHandler::Name_);
  message.set_method_name("CanGoForward");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GuestHandler_CanGoForward_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void GuestHandlerProxy::GoForward(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send webui_browser::mojom::GuestHandler::GoForward");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GuestHandler::kGoForward), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::webui_browser::mojom::internal::GuestHandler_GoForward_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GuestHandler::Name_);
  message.set_method_name("GoForward");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void GuestHandlerProxy::Reload(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send webui_browser::mojom::GuestHandler::Reload");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GuestHandler::kReload), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::webui_browser::mojom::internal::GuestHandler_Reload_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GuestHandler::Name_);
  message.set_method_name("Reload");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void GuestHandlerProxy::StopLoading(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send webui_browser::mojom::GuestHandler::StopLoading");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GuestHandler::kStopLoading), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::webui_browser::mojom::internal::GuestHandler_StopLoading_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GuestHandler::Name_);
  message.set_method_name("StopLoading");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void GuestHandlerProxy::OpenPageInfoMenu(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send webui_browser::mojom::GuestHandler::OpenPageInfoMenu");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GuestHandler::kOpenPageInfoMenu), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::webui_browser::mojom::internal::GuestHandler_OpenPageInfoMenu_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GuestHandler::Name_);
  message.set_method_name("OpenPageInfoMenu");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void GuestHandlerProxy::GetSecurityIcon(
    GetSecurityIconCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send webui_browser::mojom::GuestHandler::GetSecurityIcon");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GuestHandler::kGetSecurityIcon), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::webui_browser::mojom::internal::GuestHandler_GetSecurityIcon_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GuestHandler::Name_);
  message.set_method_name("GetSecurityIcon");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GuestHandler_GetSecurityIcon_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class GuestHandler_CanGoBack_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static GuestHandler::CanGoBackCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<GuestHandler_CanGoBack_ProxyToResponder> proxy(
        new GuestHandler_CanGoBack_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&GuestHandler_CanGoBack_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GuestHandler_CanGoBack_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  GuestHandler_CanGoBack_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "GuestHandler::CanGoBackCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_can_go_back);
};

bool GuestHandler_CanGoBack_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::GuestHandler_CanGoBack_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GuestHandler_CanGoBack_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for GuestHandler.1
  bool success = true;
  bool p_can_go_back{};
  GuestHandler_CanGoBack_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_can_go_back = input_data_view.can_go_back();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GuestHandler::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_can_go_back));
  }
  return true;
}

void GuestHandler_CanGoBack_ProxyToResponder::Run(
    bool in_can_go_back) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply webui_browser::mojom::GuestHandler::CanGoBack", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("can_go_back"), in_can_go_back,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GuestHandler::kCanGoBack), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::webui_browser::mojom::internal::GuestHandler_CanGoBack_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->can_go_back = in_can_go_back;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GuestHandler::Name_);
  message.set_method_name("CanGoBack");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class GuestHandler_CanGoForward_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static GuestHandler::CanGoForwardCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<GuestHandler_CanGoForward_ProxyToResponder> proxy(
        new GuestHandler_CanGoForward_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&GuestHandler_CanGoForward_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GuestHandler_CanGoForward_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  GuestHandler_CanGoForward_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "GuestHandler::CanGoForwardCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_can_go_forward);
};

bool GuestHandler_CanGoForward_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::GuestHandler_CanGoForward_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GuestHandler_CanGoForward_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for GuestHandler.3
  bool success = true;
  bool p_can_go_forward{};
  GuestHandler_CanGoForward_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_can_go_forward = input_data_view.can_go_forward();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GuestHandler::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_can_go_forward));
  }
  return true;
}

void GuestHandler_CanGoForward_ProxyToResponder::Run(
    bool in_can_go_forward) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply webui_browser::mojom::GuestHandler::CanGoForward", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("can_go_forward"), in_can_go_forward,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GuestHandler::kCanGoForward), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::webui_browser::mojom::internal::GuestHandler_CanGoForward_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->can_go_forward = in_can_go_forward;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GuestHandler::Name_);
  message.set_method_name("CanGoForward");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class GuestHandler_GetSecurityIcon_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static GuestHandler::GetSecurityIconCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<GuestHandler_GetSecurityIcon_ProxyToResponder> proxy(
        new GuestHandler_GetSecurityIcon_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&GuestHandler_GetSecurityIcon_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GuestHandler_GetSecurityIcon_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  GuestHandler_GetSecurityIcon_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "GuestHandler::GetSecurityIconCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      SecurityIcon in_security_icon);
};

bool GuestHandler_GetSecurityIcon_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::GuestHandler_GetSecurityIcon_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GuestHandler_GetSecurityIcon_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for GuestHandler.8
  bool success = true;
  SecurityIcon p_security_icon{};
  GuestHandler_GetSecurityIcon_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadSecurityIcon(&p_security_icon))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GuestHandler::Name_, 8, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_security_icon));
  }
  return true;
}

void GuestHandler_GetSecurityIcon_ProxyToResponder::Run(
    SecurityIcon in_security_icon) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply webui_browser::mojom::GuestHandler::GetSecurityIcon", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("security_icon"), in_security_icon,
                        "<value of type SecurityIcon>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GuestHandler::kGetSecurityIcon), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::webui_browser::mojom::internal::GuestHandler_GetSecurityIcon_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::webui_browser::mojom::SecurityIcon>(
    in_security_icon,
    &params->security_icon);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GuestHandler::Name_);
  message.set_method_name("GetSecurityIcon");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool GuestHandlerStubDispatch::Accept(
    GuestHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::GuestHandler>(message->header()->name)) {
    case messages::GuestHandler::kNavigate: {
      DCHECK(message->is_serialized());
      internal::GuestHandler_Navigate_Params_Data* params =
          reinterpret_cast<internal::GuestHandler_Navigate_Params_Data*>(
              message->mutable_payload());
      

      // Validation for GuestHandler.0
      bool success = true;
      ::GURL p_src{};
      GuestHandler_Navigate_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSrc(&p_src))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GuestHandler::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Navigate(        
        std::move(p_src));
      return true;
    }
    case messages::GuestHandler::kCanGoBack: {
      break;
    }
    case messages::GuestHandler::kGoBack: {
      DCHECK(message->is_serialized());
      internal::GuestHandler_GoBack_Params_Data* params =
          reinterpret_cast<internal::GuestHandler_GoBack_Params_Data*>(
              message->mutable_payload());
      

      // Validation for GuestHandler.2
      bool success = true;
      GuestHandler_GoBack_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GuestHandler::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GoBack(        );
      return true;
    }
    case messages::GuestHandler::kCanGoForward: {
      break;
    }
    case messages::GuestHandler::kGoForward: {
      DCHECK(message->is_serialized());
      internal::GuestHandler_GoForward_Params_Data* params =
          reinterpret_cast<internal::GuestHandler_GoForward_Params_Data*>(
              message->mutable_payload());
      

      // Validation for GuestHandler.4
      bool success = true;
      GuestHandler_GoForward_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GuestHandler::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GoForward(        );
      return true;
    }
    case messages::GuestHandler::kReload: {
      DCHECK(message->is_serialized());
      internal::GuestHandler_Reload_Params_Data* params =
          reinterpret_cast<internal::GuestHandler_Reload_Params_Data*>(
              message->mutable_payload());
      

      // Validation for GuestHandler.5
      bool success = true;
      GuestHandler_Reload_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GuestHandler::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Reload(        );
      return true;
    }
    case messages::GuestHandler::kStopLoading: {
      DCHECK(message->is_serialized());
      internal::GuestHandler_StopLoading_Params_Data* params =
          reinterpret_cast<internal::GuestHandler_StopLoading_Params_Data*>(
              message->mutable_payload());
      

      // Validation for GuestHandler.6
      bool success = true;
      GuestHandler_StopLoading_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GuestHandler::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StopLoading(        );
      return true;
    }
    case messages::GuestHandler::kOpenPageInfoMenu: {
      DCHECK(message->is_serialized());
      internal::GuestHandler_OpenPageInfoMenu_Params_Data* params =
          reinterpret_cast<internal::GuestHandler_OpenPageInfoMenu_Params_Data*>(
              message->mutable_payload());
      

      // Validation for GuestHandler.7
      bool success = true;
      GuestHandler_OpenPageInfoMenu_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GuestHandler::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenPageInfoMenu(        );
      return true;
    }
    case messages::GuestHandler::kGetSecurityIcon: {
      break;
    }
  }
  return false;
}

// static
bool GuestHandlerStubDispatch::AcceptWithResponder(
    GuestHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::GuestHandler>(message->header()->name)) {
    case messages::GuestHandler::kNavigate: {
      break;
    }
    case messages::GuestHandler::kCanGoBack: {
      internal::GuestHandler_CanGoBack_Params_Data* params =
          reinterpret_cast<
              internal::GuestHandler_CanGoBack_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for GuestHandler.1
      bool success = true;
      GuestHandler_CanGoBack_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GuestHandler::Name_, 1, false);
        return false;
      }
      auto callback =
          GuestHandler_CanGoBack_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CanGoBack(std::move(callback));
      return true;
    }
    case messages::GuestHandler::kGoBack: {
      break;
    }
    case messages::GuestHandler::kCanGoForward: {
      internal::GuestHandler_CanGoForward_Params_Data* params =
          reinterpret_cast<
              internal::GuestHandler_CanGoForward_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for GuestHandler.3
      bool success = true;
      GuestHandler_CanGoForward_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GuestHandler::Name_, 3, false);
        return false;
      }
      auto callback =
          GuestHandler_CanGoForward_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CanGoForward(std::move(callback));
      return true;
    }
    case messages::GuestHandler::kGoForward: {
      break;
    }
    case messages::GuestHandler::kReload: {
      break;
    }
    case messages::GuestHandler::kStopLoading: {
      break;
    }
    case messages::GuestHandler::kOpenPageInfoMenu: {
      break;
    }
    case messages::GuestHandler::kGetSecurityIcon: {
      internal::GuestHandler_GetSecurityIcon_Params_Data* params =
          reinterpret_cast<
              internal::GuestHandler_GetSecurityIcon_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for GuestHandler.8
      bool success = true;
      GuestHandler_GetSecurityIcon_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GuestHandler::Name_, 8, false);
        return false;
      }
      auto callback =
          GuestHandler_GetSecurityIcon_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetSecurityIcon(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kGuestHandlerValidationInfo[] = {
    { &internal::GuestHandler_Navigate_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::GuestHandler_CanGoBack_Params_Data::Validate,
     &internal::GuestHandler_CanGoBack_ResponseParams_Data::Validate},
    { &internal::GuestHandler_GoBack_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::GuestHandler_CanGoForward_Params_Data::Validate,
     &internal::GuestHandler_CanGoForward_ResponseParams_Data::Validate},
    { &internal::GuestHandler_GoForward_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::GuestHandler_Reload_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::GuestHandler_StopLoading_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::GuestHandler_OpenPageInfoMenu_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::GuestHandler_GetSecurityIcon_Params_Data::Validate,
     &internal::GuestHandler_GetSecurityIcon_ResponseParams_Data::Validate},
};

bool GuestHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::webui_browser::mojom::GuestHandler::Name_,
    kGuestHandlerValidationInfo);
}

bool GuestHandlerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::webui_browser::mojom::GuestHandler::Name_,
    kGuestHandlerValidationInfo);
}


}  // webui_browser::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace webui_browser::mojom {


void PageHandlerFactoryInterceptorForTesting::CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) {
  GetForwardingInterface()->CreatePageHandler(
    std::move(page)
    , 
    std::move(handler)
    );
}
PageHandlerFactoryAsyncWaiter::PageHandlerFactoryAsyncWaiter(
    PageHandlerFactory* proxy) : proxy_(proxy) {}

PageHandlerFactoryAsyncWaiter::~PageHandlerFactoryAsyncWaiter() = default;





void PageInterceptorForTesting::SetFocusToLocationBar(bool is_user_initiated) {
  GetForwardingInterface()->SetFocusToLocationBar(
    std::move(is_user_initiated)
    );
}
void PageInterceptorForTesting::SetReloadStopState(bool is_loading) {
  GetForwardingInterface()->SetReloadStopState(
    std::move(is_loading)
    );
}
void PageInterceptorForTesting::ShowSidePanel(int32_t guest_contents_id, const std::string& title) {
  GetForwardingInterface()->ShowSidePanel(
    std::move(guest_contents_id)
    , 
    std::move(title)
    );
}
void PageInterceptorForTesting::CloseSidePanel() {
  GetForwardingInterface()->CloseSidePanel();
}
PageAsyncWaiter::PageAsyncWaiter(
    Page* proxy) : proxy_(proxy) {}

PageAsyncWaiter::~PageAsyncWaiter() = default;





void PageHandlerInterceptorForTesting::GetGuestIdForTabId(const ::tabs_api::NodeId& tab_id, ::mojo::PendingReceiver<GuestHandler> handler, GetGuestIdForTabIdCallback callback) {
  GetForwardingInterface()->GetGuestIdForTabId(
    std::move(tab_id)
    , 
    std::move(handler)
    , std::move(callback));
}
void PageHandlerInterceptorForTesting::LoadTabSearch(LoadTabSearchCallback callback) {
  GetForwardingInterface()->LoadTabSearch(std::move(callback));
}
void PageHandlerInterceptorForTesting::ShowTabSearchBubble(const std::string& anchor_name) {
  GetForwardingInterface()->ShowTabSearchBubble(
    std::move(anchor_name)
    );
}
void PageHandlerInterceptorForTesting::OpenAppMenu() {
  GetForwardingInterface()->OpenAppMenu();
}
void PageHandlerInterceptorForTesting::OpenProfileMenu() {
  GetForwardingInterface()->OpenProfileMenu();
}
void PageHandlerInterceptorForTesting::LaunchDevToolsForBrowser() {
  GetForwardingInterface()->LaunchDevToolsForBrowser();
}
void PageHandlerInterceptorForTesting::OnSidePanelClosed() {
  GetForwardingInterface()->OnSidePanelClosed();
}
void PageHandlerInterceptorForTesting::Minimize() {
  GetForwardingInterface()->Minimize();
}
void PageHandlerInterceptorForTesting::Maximize() {
  GetForwardingInterface()->Maximize();
}
void PageHandlerInterceptorForTesting::Restore() {
  GetForwardingInterface()->Restore();
}
void PageHandlerInterceptorForTesting::Close() {
  GetForwardingInterface()->Close();
}
PageHandlerAsyncWaiter::PageHandlerAsyncWaiter(
    PageHandler* proxy) : proxy_(proxy) {}

PageHandlerAsyncWaiter::~PageHandlerAsyncWaiter() = default;


void PageHandlerAsyncWaiter::GetGuestIdForTabId(
    const ::tabs_api::NodeId& tab_id, ::mojo::PendingReceiver<GuestHandler> handler, int32_t* out_guest_id) {
  base::RunLoop loop;
  proxy_->GetGuestIdForTabId(
      std::move(tab_id),
      std::move(handler),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_guest_id
,
             int32_t guest_id) {*out_guest_id = std::move(guest_id);
            loop->Quit();
          },
          &loop,
          out_guest_id));
  loop.Run();
}

int32_t PageHandlerAsyncWaiter::GetGuestIdForTabId(
    const ::tabs_api::NodeId& tab_id, ::mojo::PendingReceiver<GuestHandler> handler) {
  int32_t async_wait_result;
  GetGuestIdForTabId(std::move(tab_id),std::move(handler),&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::LoadTabSearch(
    int32_t* out_guest_id) {
  base::RunLoop loop;
  proxy_->LoadTabSearch(
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_guest_id
,
             int32_t guest_id) {*out_guest_id = std::move(guest_id);
            loop->Quit();
          },
          &loop,
          out_guest_id));
  loop.Run();
}

int32_t PageHandlerAsyncWaiter::LoadTabSearch(
    ) {
  int32_t async_wait_result;
  LoadTabSearch(&async_wait_result);
  return async_wait_result;
}




void GuestHandlerInterceptorForTesting::Navigate(const ::GURL& src) {
  GetForwardingInterface()->Navigate(
    std::move(src)
    );
}
void GuestHandlerInterceptorForTesting::CanGoBack(CanGoBackCallback callback) {
  GetForwardingInterface()->CanGoBack(std::move(callback));
}
void GuestHandlerInterceptorForTesting::GoBack() {
  GetForwardingInterface()->GoBack();
}
void GuestHandlerInterceptorForTesting::CanGoForward(CanGoForwardCallback callback) {
  GetForwardingInterface()->CanGoForward(std::move(callback));
}
void GuestHandlerInterceptorForTesting::GoForward() {
  GetForwardingInterface()->GoForward();
}
void GuestHandlerInterceptorForTesting::Reload() {
  GetForwardingInterface()->Reload();
}
void GuestHandlerInterceptorForTesting::StopLoading() {
  GetForwardingInterface()->StopLoading();
}
void GuestHandlerInterceptorForTesting::OpenPageInfoMenu() {
  GetForwardingInterface()->OpenPageInfoMenu();
}
void GuestHandlerInterceptorForTesting::GetSecurityIcon(GetSecurityIconCallback callback) {
  GetForwardingInterface()->GetSecurityIcon(std::move(callback));
}
GuestHandlerAsyncWaiter::GuestHandlerAsyncWaiter(
    GuestHandler* proxy) : proxy_(proxy) {}

GuestHandlerAsyncWaiter::~GuestHandlerAsyncWaiter() = default;


void GuestHandlerAsyncWaiter::CanGoBack(
    bool* out_can_go_back) {
  base::RunLoop loop;
  proxy_->CanGoBack(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_can_go_back
,
             bool can_go_back) {*out_can_go_back = std::move(can_go_back);
            loop->Quit();
          },
          &loop,
          out_can_go_back));
  loop.Run();
}

bool GuestHandlerAsyncWaiter::CanGoBack(
    ) {
  bool async_wait_result;
  CanGoBack(&async_wait_result);
  return async_wait_result;
}

void GuestHandlerAsyncWaiter::CanGoForward(
    bool* out_can_go_forward) {
  base::RunLoop loop;
  proxy_->CanGoForward(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_can_go_forward
,
             bool can_go_forward) {*out_can_go_forward = std::move(can_go_forward);
            loop->Quit();
          },
          &loop,
          out_can_go_forward));
  loop.Run();
}

bool GuestHandlerAsyncWaiter::CanGoForward(
    ) {
  bool async_wait_result;
  CanGoForward(&async_wait_result);
  return async_wait_result;
}

void GuestHandlerAsyncWaiter::GetSecurityIcon(
    SecurityIcon* out_security_icon) {
  base::RunLoop loop;
  proxy_->GetSecurityIcon(
      base::BindOnce(
          [](base::RunLoop* loop,
             SecurityIcon* out_security_icon
,
             SecurityIcon security_icon) {*out_security_icon = std::move(security_icon);
            loop->Quit();
          },
          &loop,
          out_security_icon));
  loop.Run();
}

SecurityIcon GuestHandlerAsyncWaiter::GetSecurityIcon(
    ) {
  SecurityIcon async_wait_result;
  GetSecurityIcon(&async_wait_result);
  return async_wait_result;
}






}  // webui_browser::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif