// chrome/browser/ui/webui_browser/browser.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/browser/ui/webui_browser/browser.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui_browser/browser.mojom-params-data.h"
namespace webui_browser {
namespace mojom {

NOINLINE static const char* SecurityIconToStringHelper(SecurityIcon value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SecurityIcon::HttpChromeRefresh:
      return "HttpChromeRefresh";
    case SecurityIcon::SecurePageInfoChromeRefresh:
      return "SecurePageInfoChromeRefresh";
    case SecurityIcon::NoEncryption:
      return "NoEncryption";
    case SecurityIcon::NotSecureWarningChromeRefresh:
      return "NotSecureWarningChromeRefresh";
    case SecurityIcon::BusinessChromeRefresh:
      return "BusinessChromeRefresh";
    case SecurityIcon::DangerousChromeRefresh:
      return "DangerousChromeRefresh";
    case SecurityIcon::ProductChromeRefresh:
      return "ProductChromeRefresh";
    case SecurityIcon::ExtensionChromeRefresh:
      return "ExtensionChromeRefresh";
    case SecurityIcon::OfflinePin:
      return "OfflinePin";
    default:
      return nullptr;
  }
}

std::string SecurityIconToString(SecurityIcon value) {
  const char *str = SecurityIconToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SecurityIcon value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SecurityIcon value) {
  return os << SecurityIconToString(value);
}

namespace internal {


// static
bool PageHandlerFactory_CreatePageHandler_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandlerFactory_CreatePageHandler_Params_Data* object =
      static_cast<const PageHandlerFactory_CreatePageHandler_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->page, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->page,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->handler, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->handler,
                                                 validation_context)) {
    return false;
  }

  return true;
}

PageHandlerFactory_CreatePageHandler_Params_Data::PageHandlerFactory_CreatePageHandler_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_SetFocusToLocationBar_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_SetFocusToLocationBar_Params_Data* object =
      static_cast<const Page_SetFocusToLocationBar_Params_Data*>(data);

  return true;
}

Page_SetFocusToLocationBar_Params_Data::Page_SetFocusToLocationBar_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_SetReloadStopState_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_SetReloadStopState_Params_Data* object =
      static_cast<const Page_SetReloadStopState_Params_Data*>(data);

  return true;
}

Page_SetReloadStopState_Params_Data::Page_SetReloadStopState_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_ShowSidePanel_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_ShowSidePanel_Params_Data* object =
      static_cast<const Page_ShowSidePanel_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& title_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->title, validation_context,
                                         &title_validate_params)) {
    return false;
  }

  return true;
}

Page_ShowSidePanel_Params_Data::Page_ShowSidePanel_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_CloseSidePanel_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_CloseSidePanel_Params_Data* object =
      static_cast<const Page_CloseSidePanel_Params_Data*>(data);

  return true;
}

Page_CloseSidePanel_Params_Data::Page_CloseSidePanel_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetGuestIdForTabId_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetGuestIdForTabId_Params_Data* object =
      static_cast<const PageHandler_GetGuestIdForTabId_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tab_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->tab_id, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->handler, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->handler,
                                                 validation_context)) {
    return false;
  }

  return true;
}

PageHandler_GetGuestIdForTabId_Params_Data::PageHandler_GetGuestIdForTabId_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetGuestIdForTabId_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetGuestIdForTabId_ResponseParams_Data* object =
      static_cast<const PageHandler_GetGuestIdForTabId_ResponseParams_Data*>(data);

  return true;
}

PageHandler_GetGuestIdForTabId_ResponseParams_Data::PageHandler_GetGuestIdForTabId_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_LoadTabSearch_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_LoadTabSearch_Params_Data* object =
      static_cast<const PageHandler_LoadTabSearch_Params_Data*>(data);

  return true;
}

PageHandler_LoadTabSearch_Params_Data::PageHandler_LoadTabSearch_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_LoadTabSearch_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_LoadTabSearch_ResponseParams_Data* object =
      static_cast<const PageHandler_LoadTabSearch_ResponseParams_Data*>(data);

  return true;
}

PageHandler_LoadTabSearch_ResponseParams_Data::PageHandler_LoadTabSearch_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_ShowTabSearchBubble_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_ShowTabSearchBubble_Params_Data* object =
      static_cast<const PageHandler_ShowTabSearchBubble_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->anchor_name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& anchor_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->anchor_name, validation_context,
                                         &anchor_name_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_ShowTabSearchBubble_Params_Data::PageHandler_ShowTabSearchBubble_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_OpenAppMenu_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_OpenAppMenu_Params_Data* object =
      static_cast<const PageHandler_OpenAppMenu_Params_Data*>(data);

  return true;
}

PageHandler_OpenAppMenu_Params_Data::PageHandler_OpenAppMenu_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_OpenProfileMenu_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_OpenProfileMenu_Params_Data* object =
      static_cast<const PageHandler_OpenProfileMenu_Params_Data*>(data);

  return true;
}

PageHandler_OpenProfileMenu_Params_Data::PageHandler_OpenProfileMenu_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_LaunchDevToolsForBrowser_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_LaunchDevToolsForBrowser_Params_Data* object =
      static_cast<const PageHandler_LaunchDevToolsForBrowser_Params_Data*>(data);

  return true;
}

PageHandler_LaunchDevToolsForBrowser_Params_Data::PageHandler_LaunchDevToolsForBrowser_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_OnSidePanelClosed_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_OnSidePanelClosed_Params_Data* object =
      static_cast<const PageHandler_OnSidePanelClosed_Params_Data*>(data);

  return true;
}

PageHandler_OnSidePanelClosed_Params_Data::PageHandler_OnSidePanelClosed_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_Minimize_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_Minimize_Params_Data* object =
      static_cast<const PageHandler_Minimize_Params_Data*>(data);

  return true;
}

PageHandler_Minimize_Params_Data::PageHandler_Minimize_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_Maximize_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_Maximize_Params_Data* object =
      static_cast<const PageHandler_Maximize_Params_Data*>(data);

  return true;
}

PageHandler_Maximize_Params_Data::PageHandler_Maximize_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_Restore_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_Restore_Params_Data* object =
      static_cast<const PageHandler_Restore_Params_Data*>(data);

  return true;
}

PageHandler_Restore_Params_Data::PageHandler_Restore_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_Close_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_Close_Params_Data* object =
      static_cast<const PageHandler_Close_Params_Data*>(data);

  return true;
}

PageHandler_Close_Params_Data::PageHandler_Close_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GuestHandler_Navigate_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GuestHandler_Navigate_Params_Data* object =
      static_cast<const GuestHandler_Navigate_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->src, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->src, validation_context))
    return false;

  return true;
}

GuestHandler_Navigate_Params_Data::GuestHandler_Navigate_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GuestHandler_CanGoBack_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GuestHandler_CanGoBack_Params_Data* object =
      static_cast<const GuestHandler_CanGoBack_Params_Data*>(data);

  return true;
}

GuestHandler_CanGoBack_Params_Data::GuestHandler_CanGoBack_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GuestHandler_CanGoBack_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GuestHandler_CanGoBack_ResponseParams_Data* object =
      static_cast<const GuestHandler_CanGoBack_ResponseParams_Data*>(data);

  return true;
}

GuestHandler_CanGoBack_ResponseParams_Data::GuestHandler_CanGoBack_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GuestHandler_GoBack_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GuestHandler_GoBack_Params_Data* object =
      static_cast<const GuestHandler_GoBack_Params_Data*>(data);

  return true;
}

GuestHandler_GoBack_Params_Data::GuestHandler_GoBack_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GuestHandler_CanGoForward_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GuestHandler_CanGoForward_Params_Data* object =
      static_cast<const GuestHandler_CanGoForward_Params_Data*>(data);

  return true;
}

GuestHandler_CanGoForward_Params_Data::GuestHandler_CanGoForward_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GuestHandler_CanGoForward_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GuestHandler_CanGoForward_ResponseParams_Data* object =
      static_cast<const GuestHandler_CanGoForward_ResponseParams_Data*>(data);

  return true;
}

GuestHandler_CanGoForward_ResponseParams_Data::GuestHandler_CanGoForward_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GuestHandler_GoForward_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GuestHandler_GoForward_Params_Data* object =
      static_cast<const GuestHandler_GoForward_Params_Data*>(data);

  return true;
}

GuestHandler_GoForward_Params_Data::GuestHandler_GoForward_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GuestHandler_Reload_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GuestHandler_Reload_Params_Data* object =
      static_cast<const GuestHandler_Reload_Params_Data*>(data);

  return true;
}

GuestHandler_Reload_Params_Data::GuestHandler_Reload_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GuestHandler_StopLoading_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GuestHandler_StopLoading_Params_Data* object =
      static_cast<const GuestHandler_StopLoading_Params_Data*>(data);

  return true;
}

GuestHandler_StopLoading_Params_Data::GuestHandler_StopLoading_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GuestHandler_OpenPageInfoMenu_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GuestHandler_OpenPageInfoMenu_Params_Data* object =
      static_cast<const GuestHandler_OpenPageInfoMenu_Params_Data*>(data);

  return true;
}

GuestHandler_OpenPageInfoMenu_Params_Data::GuestHandler_OpenPageInfoMenu_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GuestHandler_GetSecurityIcon_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GuestHandler_GetSecurityIcon_Params_Data* object =
      static_cast<const GuestHandler_GetSecurityIcon_Params_Data*>(data);

  return true;
}

GuestHandler_GetSecurityIcon_Params_Data::GuestHandler_GetSecurityIcon_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GuestHandler_GetSecurityIcon_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GuestHandler_GetSecurityIcon_ResponseParams_Data* object =
      static_cast<const GuestHandler_GetSecurityIcon_ResponseParams_Data*>(data);


  if (!::webui_browser::mojom::internal::SecurityIcon_Data
        ::Validate(object->security_icon, validation_context))
    return false;

  return true;
}

GuestHandler_GetSecurityIcon_ResponseParams_Data::GuestHandler_GetSecurityIcon_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace webui_browser

namespace perfetto {

// static
void TraceFormatTraits<::webui_browser::mojom::SecurityIcon>::WriteIntoTrace(
   perfetto::TracedValue context, ::webui_browser::mojom::SecurityIcon value) {
  return std::move(context).WriteString(::webui_browser::mojom::SecurityIconToString(value));
}

} // namespace perfetto