// chrome/browser/ui/webui/tab_strip_internals/tab_strip_internals.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_TAB_STRIP_INTERNALS_TAB_STRIP_INTERNALS_MOJOM_DATA_VIEW_H_
#define CHROME_BROWSER_UI_WEBUI_TAB_STRIP_INTERNALS_TAB_STRIP_INTERNALS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "chrome/browser/ui/webui/tab_strip_internals/tab_strip_internals.mojom-shared-internal.h"
#include "components/tab_groups/public/mojom/tab_group_types.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace tab_strip_internals::mojom {
class ContainerDataView;

class TabStripTreeDataView;

class WindowNodeDataView;

class NodeIdDataView;

class TabStripModelDataView;

class NodeDataView;

class TabDataView;

class TabStripCollectionDataView;

class PinnedCollectionDataView;

class UnpinnedCollectionDataView;

class GroupCollectionDataView;

class TabGroupVisualDataDataView;

class SplitCollectionDataView;

class SplitTabVisualDataDataView;

class SelectionModelDataView;

class DataDataView;


}  // tab_strip_internals::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::tab_strip_internals::mojom::ContainerDataView> {
  using Data = ::tab_strip_internals::mojom::internal::Container_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tab_strip_internals::mojom::TabStripTreeDataView> {
  using Data = ::tab_strip_internals::mojom::internal::TabStripTree_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tab_strip_internals::mojom::WindowNodeDataView> {
  using Data = ::tab_strip_internals::mojom::internal::WindowNode_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tab_strip_internals::mojom::NodeIdDataView> {
  using Data = ::tab_strip_internals::mojom::internal::NodeId_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tab_strip_internals::mojom::TabStripModelDataView> {
  using Data = ::tab_strip_internals::mojom::internal::TabStripModel_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tab_strip_internals::mojom::NodeDataView> {
  using Data = ::tab_strip_internals::mojom::internal::Node_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tab_strip_internals::mojom::TabDataView> {
  using Data = ::tab_strip_internals::mojom::internal::Tab_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tab_strip_internals::mojom::TabStripCollectionDataView> {
  using Data = ::tab_strip_internals::mojom::internal::TabStripCollection_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tab_strip_internals::mojom::PinnedCollectionDataView> {
  using Data = ::tab_strip_internals::mojom::internal::PinnedCollection_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tab_strip_internals::mojom::UnpinnedCollectionDataView> {
  using Data = ::tab_strip_internals::mojom::internal::UnpinnedCollection_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tab_strip_internals::mojom::GroupCollectionDataView> {
  using Data = ::tab_strip_internals::mojom::internal::GroupCollection_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tab_strip_internals::mojom::TabGroupVisualDataDataView> {
  using Data = ::tab_strip_internals::mojom::internal::TabGroupVisualData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tab_strip_internals::mojom::SplitCollectionDataView> {
  using Data = ::tab_strip_internals::mojom::internal::SplitCollection_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tab_strip_internals::mojom::SplitTabVisualDataDataView> {
  using Data = ::tab_strip_internals::mojom::internal::SplitTabVisualData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tab_strip_internals::mojom::SelectionModelDataView> {
  using Data = ::tab_strip_internals::mojom::internal::SelectionModel_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tab_strip_internals::mojom::DataDataView> {
  using Data = ::tab_strip_internals::mojom::internal::Data_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace tab_strip_internals::mojom {


enum class NodeId_Type : int32_t {
  
  kTab = 0,
  
  kCollection = 1,
  
  kWindow = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, NodeId_Type value);
inline bool IsKnownEnumValue(NodeId_Type value) {
  return internal::NodeId_Type_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SplitTabVisualData_Layout : int32_t {
  
  kVertical = 0,
  
  kHorizontal = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, SplitTabVisualData_Layout value);
inline bool IsKnownEnumValue(SplitTabVisualData_Layout value) {
  return internal::SplitTabVisualData_Layout_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class PageHandlerFactoryInterfaceBase {};

using PageHandlerFactoryPtrDataView =
    mojo::InterfacePtrDataView<PageHandlerFactoryInterfaceBase>;
using PageHandlerFactoryRequestDataView =
    mojo::InterfaceRequestDataView<PageHandlerFactoryInterfaceBase>;
using PageHandlerFactoryAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageHandlerFactoryInterfaceBase>;
using PageHandlerFactoryAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageHandlerFactoryInterfaceBase>;
class PageHandlerInterfaceBase {};

using PageHandlerPtrDataView =
    mojo::InterfacePtrDataView<PageHandlerInterfaceBase>;
using PageHandlerRequestDataView =
    mojo::InterfaceRequestDataView<PageHandlerInterfaceBase>;
using PageHandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageHandlerInterfaceBase>;
using PageHandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageHandlerInterfaceBase>;
class PageInterfaceBase {};

using PagePtrDataView =
    mojo::InterfacePtrDataView<PageInterfaceBase>;
using PageRequestDataView =
    mojo::InterfaceRequestDataView<PageInterfaceBase>;
using PageAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageInterfaceBase>;
using PageAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageInterfaceBase>;


class ContainerDataView {
 public:
  ContainerDataView() = default;

  ContainerDataView(
      internal::Container_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTabstripTreeDataView(
      TabStripTreeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTabstripTree(UserType* output) {
    
    auto* pointer = data_->tabstrip_tree.Get();
    return mojo::internal::Deserialize<::tab_strip_internals::mojom::TabStripTreeDataView>(
        pointer, output, message_);
  }
 private:
  internal::Container_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TabStripTreeDataView {
 public:
  TabStripTreeDataView() = default;

  TabStripTreeDataView(
      internal::TabStripTree_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetWindowsDataView(
      mojo::ArrayDataView<WindowNodeDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWindows(UserType* output) {
    
    auto* pointer = data_->windows.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::tab_strip_internals::mojom::WindowNodeDataView>>(
        pointer, output, message_);
  }
 private:
  internal::TabStripTree_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WindowNodeDataView {
 public:
  WindowNodeDataView() = default;

  WindowNodeDataView(
      internal::WindowNode_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      NodeIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<::tab_strip_internals::mojom::NodeIdDataView>(
        pointer, output, message_);
  }
  inline void GetTabstripModelDataView(
      TabStripModelDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTabstripModel(UserType* output) {
    
    auto* pointer = data_->tabstrip_model.Get();
    return mojo::internal::Deserialize<::tab_strip_internals::mojom::TabStripModelDataView>(
        pointer, output, message_);
  }
  inline void GetSelectionModelDataView(
      SelectionModelDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSelectionModel(UserType* output) {
    
    auto* pointer = data_->selection_model.Get();
    return mojo::internal::Deserialize<::tab_strip_internals::mojom::SelectionModelDataView>(
        pointer, output, message_);
  }
 private:
  internal::WindowNode_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NodeIdDataView {
 public:
  NodeIdDataView() = default;

  NodeIdDataView(
      internal::NodeId_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNodeIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNodeId(UserType* output) {
    
    auto* pointer = data_->node_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::tab_strip_internals::mojom::NodeId_Type>(
        data_value, output);
  }
  NodeId_Type type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::tab_strip_internals::mojom::NodeId_Type>(data_->type));
  }
 private:
  internal::NodeId_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TabStripModelDataView {
 public:
  TabStripModelDataView() = default;

  TabStripModelDataView(
      internal::TabStripModel_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRootDataView(
      NodeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRoot(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::tab_strip_internals::mojom::NodeDataView, UserType>(),
    "Attempting to read the optional `root` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRoot` instead "
    "of `ReadRoot if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->root.Get();
    return mojo::internal::Deserialize<::tab_strip_internals::mojom::NodeDataView>(
        pointer, output, message_);
  }
 private:
  internal::TabStripModel_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NodeDataView {
 public:
  NodeDataView() = default;

  NodeDataView(
      internal::Node_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDataDataView(
      DataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
    auto* pointer = !data_->data.is_null() ? &data_->data : nullptr;
    return mojo::internal::Deserialize<::tab_strip_internals::mojom::DataDataView>(
        pointer, output, message_);
  }
  inline void GetChildrenDataView(
      mojo::ArrayDataView<NodeDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadChildren(UserType* output) {
    
    auto* pointer = data_->children.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::tab_strip_internals::mojom::NodeDataView>>(
        pointer, output, message_);
  }
 private:
  internal::Node_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TabDataView {
 public:
  TabDataView() = default;

  TabDataView(
      internal::Tab_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      NodeIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<::tab_strip_internals::mojom::NodeIdDataView>(
        pointer, output, message_);
  }
  inline void GetTitleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
 private:
  internal::Tab_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TabStripCollectionDataView {
 public:
  TabStripCollectionDataView() = default;

  TabStripCollectionDataView(
      internal::TabStripCollection_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      NodeIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<::tab_strip_internals::mojom::NodeIdDataView>(
        pointer, output, message_);
  }
 private:
  internal::TabStripCollection_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PinnedCollectionDataView {
 public:
  PinnedCollectionDataView() = default;

  PinnedCollectionDataView(
      internal::PinnedCollection_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      NodeIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<::tab_strip_internals::mojom::NodeIdDataView>(
        pointer, output, message_);
  }
 private:
  internal::PinnedCollection_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class UnpinnedCollectionDataView {
 public:
  UnpinnedCollectionDataView() = default;

  UnpinnedCollectionDataView(
      internal::UnpinnedCollection_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      NodeIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<::tab_strip_internals::mojom::NodeIdDataView>(
        pointer, output, message_);
  }
 private:
  internal::UnpinnedCollection_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GroupCollectionDataView {
 public:
  GroupCollectionDataView() = default;

  GroupCollectionDataView(
      internal::GroupCollection_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      NodeIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<::tab_strip_internals::mojom::NodeIdDataView>(
        pointer, output, message_);
  }
  inline void GetVisualDataDataView(
      TabGroupVisualDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVisualData(UserType* output) {
    
    auto* pointer = data_->visualData.Get();
    return mojo::internal::Deserialize<::tab_strip_internals::mojom::TabGroupVisualDataDataView>(
        pointer, output, message_);
  }
 private:
  internal::GroupCollection_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TabGroupVisualDataDataView {
 public:
  TabGroupVisualDataDataView() = default;

  TabGroupVisualDataDataView(
      internal::TabGroupVisualData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTitleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadColor(UserType* output) const {
    auto data_value = data_->color;
    return mojo::internal::Deserialize<::tab_groups::mojom::Color>(
        data_value, output);
  }
  ::tab_groups::mojom::Color color() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::tab_groups::mojom::Color>(data_->color));
  }
  bool is_collapsed() const {
    return data_->is_collapsed;
  }
 private:
  internal::TabGroupVisualData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SplitCollectionDataView {
 public:
  SplitCollectionDataView() = default;

  SplitCollectionDataView(
      internal::SplitCollection_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      NodeIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<::tab_strip_internals::mojom::NodeIdDataView>(
        pointer, output, message_);
  }
  inline void GetVisualDataDataView(
      SplitTabVisualDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVisualData(UserType* output) {
    
    auto* pointer = data_->visualData.Get();
    return mojo::internal::Deserialize<::tab_strip_internals::mojom::SplitTabVisualDataDataView>(
        pointer, output, message_);
  }
 private:
  internal::SplitCollection_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SplitTabVisualDataDataView {
 public:
  SplitTabVisualDataDataView() = default;

  SplitTabVisualDataDataView(
      internal::SplitTabVisualData_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadLayout(UserType* output) const {
    auto data_value = data_->layout;
    return mojo::internal::Deserialize<::tab_strip_internals::mojom::SplitTabVisualData_Layout>(
        data_value, output);
  }
  SplitTabVisualData_Layout layout() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::tab_strip_internals::mojom::SplitTabVisualData_Layout>(data_->layout));
  }
  double split_ratio() const {
    return data_->split_ratio;
  }
 private:
  internal::SplitTabVisualData_Data* data_ = nullptr;
};


class SelectionModelDataView {
 public:
  SelectionModelDataView() = default;

  SelectionModelDataView(
      internal::SelectionModel_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t active_index() const {
    return data_->active_index;
  }
  int32_t anchor_index() const {
    return data_->anchor_index;
  }
  inline void GetSelectedIndicesDataView(
      mojo::ArrayDataView<int32_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSelectedIndices(UserType* output) {
    
    auto* pointer = data_->selected_indices.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<int32_t>>(
        pointer, output, message_);
  }
 private:
  internal::SelectionModel_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DataDataView {
 public:
  using Tag = internal::Data_Data::Data_Tag;

  DataDataView() = default;

  DataDataView(
      internal::Data_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_tab() const { return data_->tag == Tag::kTab; }
  inline void GetTabDataView(
      TabDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadTab(UserType* output) const {
    
    CHECK(is_tab());
    return mojo::internal::Deserialize<::tab_strip_internals::mojom::TabDataView>(
        data_->data.f_tab.Get(), output, message_);
  }
  bool is_tab_strip_collection() const { return data_->tag == Tag::kTabStripCollection; }
  inline void GetTabStripCollectionDataView(
      TabStripCollectionDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadTabStripCollection(UserType* output) const {
    
    CHECK(is_tab_strip_collection());
    return mojo::internal::Deserialize<::tab_strip_internals::mojom::TabStripCollectionDataView>(
        data_->data.f_tab_strip_collection.Get(), output, message_);
  }
  bool is_pinned_tab_collection() const { return data_->tag == Tag::kPinnedTabCollection; }
  inline void GetPinnedTabCollectionDataView(
      PinnedCollectionDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadPinnedTabCollection(UserType* output) const {
    
    CHECK(is_pinned_tab_collection());
    return mojo::internal::Deserialize<::tab_strip_internals::mojom::PinnedCollectionDataView>(
        data_->data.f_pinned_tab_collection.Get(), output, message_);
  }
  bool is_unpinned_tab_collection() const { return data_->tag == Tag::kUnpinnedTabCollection; }
  inline void GetUnpinnedTabCollectionDataView(
      UnpinnedCollectionDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadUnpinnedTabCollection(UserType* output) const {
    
    CHECK(is_unpinned_tab_collection());
    return mojo::internal::Deserialize<::tab_strip_internals::mojom::UnpinnedCollectionDataView>(
        data_->data.f_unpinned_tab_collection.Get(), output, message_);
  }
  bool is_tab_group_collection() const { return data_->tag == Tag::kTabGroupCollection; }
  inline void GetTabGroupCollectionDataView(
      GroupCollectionDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadTabGroupCollection(UserType* output) const {
    
    CHECK(is_tab_group_collection());
    return mojo::internal::Deserialize<::tab_strip_internals::mojom::GroupCollectionDataView>(
        data_->data.f_tab_group_collection.Get(), output, message_);
  }
  bool is_split_tab_collection() const { return data_->tag == Tag::kSplitTabCollection; }
  inline void GetSplitTabCollectionDataView(
      SplitCollectionDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSplitTabCollection(UserType* output) const {
    
    CHECK(is_split_tab_collection());
    return mojo::internal::Deserialize<::tab_strip_internals::mojom::SplitCollectionDataView>(
        data_->data.f_split_tab_collection.Get(), output, message_);
  }

 private:
  internal::Data_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // tab_strip_internals::mojom

#endif  // CHROME_BROWSER_UI_WEBUI_TAB_STRIP_INTERNALS_TAB_STRIP_INTERNALS_MOJOM_DATA_VIEW_H_