// chrome/browser/ui/webui/signin/history_sync_optin/history_sync_optin.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_SIGNIN_HISTORY_SYNC_OPTIN_HISTORY_SYNC_OPTIN_MOJOM_H_
#define CHROME_BROWSER_UI_WEBUI_SIGNIN_HISTORY_SYNC_OPTIN_HISTORY_SYNC_OPTIN_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/webui/signin/history_sync_optin/history_sync_optin.mojom-features.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/signin/history_sync_optin/history_sync_optin.mojom-shared.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/signin/history_sync_optin/history_sync_optin.mojom-forward.h"  // IWYU pragma: export
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace history_sync_optin::mojom {

class PageHandlerFactoryProxy;

template <typename ImplRefTraits>
class PageHandlerFactoryStub;

class PageHandlerFactoryRequestValidator;


class PageHandlerFactory
    : public PageHandlerFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "history_sync_optin.mojom.PageHandlerFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageHandlerFactoryInterfaceBase;
  using Proxy_ = PageHandlerFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageHandlerFactoryStub<ImplRefTraits>;

  using RequestValidator_ = PageHandlerFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreateHistorySyncOptinHandlerMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateHistorySyncOptinHandler_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PageHandlerFactory() = default;

  virtual void CreateHistorySyncOptinHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) = 0;
};

class PageHandlerProxy;

template <typename ImplRefTraits>
class PageHandlerStub;

class PageHandlerRequestValidator;


class PageHandler
    : public PageHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "history_sync_optin.mojom.PageHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageHandlerInterfaceBase;
  using Proxy_ = PageHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageHandlerStub<ImplRefTraits>;

  using RequestValidator_ = PageHandlerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kAcceptMinVersion = 0,
    kRejectMinVersion = 0,
    kRequestAccountInfoMinVersion = 0,
    kUpdateDialogHeightMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Accept_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Reject_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestAccountInfo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateDialogHeight_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PageHandler() = default;

  virtual void Accept() = 0;

  virtual void Reject() = 0;

  virtual void RequestAccountInfo() = 0;

  virtual void UpdateDialogHeight(uint32_t height) = 0;
};

class PageProxy;

template <typename ImplRefTraits>
class PageStub;

class PageRequestValidator;


class Page
    : public PageInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "history_sync_optin.mojom.Page";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageInterfaceBase;
  using Proxy_ = PageProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageStub<ImplRefTraits>;

  using RequestValidator_ = PageRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSendAccountInfoMinVersion = 0,
    kSendScreenModeMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SendAccountInfo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SendScreenMode_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Page() = default;

  virtual void SendAccountInfo(AccountInfoPtr account_info) = 0;

  virtual void SendScreenMode(ScreenMode screen_mode) = 0;
};



class  PageHandlerFactoryProxy
    : public PageHandlerFactory {
 public:
  using InterfaceType = PageHandlerFactory;

  explicit PageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateHistorySyncOptinHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PageHandlerProxy
    : public PageHandler {
 public:
  using InterfaceType = PageHandler;

  explicit PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Accept() final;
  
  void Reject() final;
  
  void RequestAccountInfo() final;
  
  void UpdateDialogHeight(uint32_t height) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PageProxy
    : public Page {
 public:
  using InterfaceType = Page;

  explicit PageProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SendAccountInfo(AccountInfoPtr account_info) final;
  
  void SendScreenMode(ScreenMode screen_mode) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  PageHandlerFactoryStubDispatch {
 public:
  static bool Accept(PageHandlerFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageHandlerFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageHandlerFactory>>
class PageHandlerFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageHandlerFactoryStub() = default;
  ~PageHandlerFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageHandlerStubDispatch {
 public:
  static bool Accept(PageHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageHandler>>
class PageHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageHandlerStub() = default;
  ~PageHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageStubDispatch {
 public:
  static bool Accept(Page* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Page* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Page>>
class PageStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageStub() = default;
  ~PageStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageHandlerFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class  AccountInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AccountInfo, T>::value>;
  using DataView = AccountInfoDataView;
  using Data_ = internal::AccountInfo_Data;

  template <typename... Args>
  static AccountInfoPtr New(Args&&... args) {
    return AccountInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AccountInfoPtr From(const U& u) {
    return mojo::TypeConverter<AccountInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AccountInfo>::Convert(*this);
  }


  AccountInfo();

  explicit AccountInfo(
      const ::GURL& account_image_src);


  ~AccountInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AccountInfoPtr>
  AccountInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AccountInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AccountInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AccountInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AccountInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AccountInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AccountInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AccountInfo_UnserializedMessageContext<
            UserType, AccountInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AccountInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AccountInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AccountInfo_UnserializedMessageContext<
            UserType, AccountInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AccountInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::GURL account_image_src;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AccountInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AccountInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AccountInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AccountInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
AccountInfoPtr AccountInfo::Clone() const {
  return New(
      mojo::Clone(account_image_src)
  );
}

template <typename T, AccountInfo::EnableIfSame<T>*>
bool AccountInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->account_image_src, other_struct.account_image_src))
    return false;
  return true;
}

template <typename T, AccountInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.account_image_src < rhs.account_image_src)
    return true;
  if (rhs.account_image_src < lhs.account_image_src)
    return false;
  return false;
}


}  // history_sync_optin::mojom

namespace mojo {


template <>
struct  StructTraits<::history_sync_optin::mojom::AccountInfo::DataView,
                                         ::history_sync_optin::mojom::AccountInfoPtr> {
  static bool IsNull(const ::history_sync_optin::mojom::AccountInfoPtr& input) { return !input; }
  static void SetToNull(::history_sync_optin::mojom::AccountInfoPtr* output) { output->reset(); }

  static const decltype(::history_sync_optin::mojom::AccountInfo::account_image_src)& account_image_src(
      const ::history_sync_optin::mojom::AccountInfoPtr& input) {
    return input->account_image_src;
  }

  static bool Read(::history_sync_optin::mojom::AccountInfo::DataView input, ::history_sync_optin::mojom::AccountInfoPtr* output);
};

}  // namespace mojo

#endif  // CHROME_BROWSER_UI_WEBUI_SIGNIN_HISTORY_SYNC_OPTIN_HISTORY_SYNC_OPTIN_MOJOM_H_